/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.util.LinkedHashMap;
import java.util.List;
import org.w3c.dom.Element;

public class UserTypeFieldMap
extends BasicDataSource {
    private static Logger log = new Logger(UserTypeFieldMap.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (!(data instanceof Element)) {
            log.warning("Unexpected type passed to Constraints: " + data.getClass().getName());
            return data;
        }
        Element element = (Element)data;
        LinkedHashMap<String, List<String>> constraintMap = new LinkedHashMap<String, List<String>>();
        DataSource listDS = DataSourceManager.getDataSource("List", null);
        try {
            List constraints = XML.getElementChildren(element);
            for (Element constraint : constraints) {
                String userType = XML.getAttribute(constraint, "userType");
                if (userType == null) {
                    userType = XML.getAttribute(constraint, "ID");
                }
                if (userType == null) {
                    log.warning("Constraint with no 'userType' or 'ID' attribute");
                    continue;
                }
                List<String> value = null;
                List elementChildren = XML.getElementChildren(constraint);
                value = elementChildren.isEmpty() ? DataTools.buildList("*") : (List<String>)listDS.toRecords(constraint);
                constraintMap.put(userType, value);
            }
        }
        finally {
            DataSourceManager.freeDataSource(listDS);
        }
        return constraintMap;
    }
}

