/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionDataSource
extends BasicDataSource {
    private static Logger log = new Logger(SessionDataSource.class.getName());
    private long lastPrimaryKey = 0L;

    public void init(Map theConfig) throws Exception {
        super.init(theConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSResponse execute(DSRequest req) throws Exception {
        RequestContext context = req.getRequestContext();
        if (context == null) {
            throw new Exception("Attempt to execute() DSRequest that was not initiated via HTTP request - this is not supported due to lack of session");
        }
        DSResponse dsResponse = new DSResponse(req == null ? (DataSource)null : req.getDataSource());
        dsResponse.setSuccess();
        Map storage = this.getStorage(context);
        String primaryKeyName = this.getPrimaryKeys().get(0);
        Map criteria = req.getCriteria();
        Object primaryKey = criteria == null ? null : (Object)criteria.get(primaryKeyName);
        Map map = storage;
        synchronized (map) {
            String opType = req.getOperationType();
            if (SessionDataSource.isFetch(opType)) {
                if (primaryKey != null) {
                    Map record = (Map)storage.get(primaryKey);
                    dsResponse.setData(record);
                } else {
                    ArrayList results = new ArrayList();
                    for (Map record : storage.values()) {
                        HashMap clonedRecord = new HashMap(record);
                        clonedRecord.remove("file_binary");
                        results.add(clonedRecord);
                    }
                    dsResponse.setData(results);
                }
            } else if (SessionDataSource.isRemove(opType)) {
                if (primaryKey != null) {
                    storage.remove(primaryKey);
                    dsResponse.setData(req.getCriteria());
                } else {
                    storage.clear();
                }
            } else if (SessionDataSource.isAdd(opType)) {
                Map values = req.getValues();
                primaryKey = this.generatePrimaryKey(req);
                values.put(primaryKeyName, primaryKey);
                dsResponse.setData(new HashMap(values));
                List uploadedFiles = req.getUploadedFiles();
                if (uploadedFiles != null) {
                    values.put("file_binary", ((ISCFileItem)uploadedFiles.get(0)).get());
                }
                storage.put(primaryKey, values);
            } else if (SessionDataSource.isUpdate(opType)) {
                Map record = (Map)storage.get(primaryKey);
                if (record == null) {
                    throw new Exception("Update failed for primaryKey: " + primaryKey.toString() + " - no such record in session");
                }
                Map values = req.getValues();
                DataTools.mapMerge(values, record);
                dsResponse.setData(values);
            } else {
                throw new Exception("Unsupported operation: " + opType);
            }
        }
        return dsResponse;
    }

    public synchronized Object generatePrimaryKey(DSRequest req) throws Exception {
        return this.lastPrimaryKey++;
    }

    public synchronized Map getStorage(RequestContext context) throws Exception {
        String dsName;
        HashMap storage;
        HttpSession session = context.request.getSession(true);
        HashMap sessionDS = (HashMap)session.getAttribute("isc.sessionDS");
        if (sessionDS == null) {
            sessionDS = new HashMap();
            session.setAttribute("isc.sessionDS", sessionDS);
        }
        if ((storage = (HashMap)sessionDS.get(dsName = this.getName())) == null) {
            storage = new HashMap();
            sessionDS.put(dsName, storage);
        }
        return storage;
    }
}

