/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.SystemSchemaTranslation;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;

public class InitListener
implements ServletContextListener,
ServletRequestListener {
    public static boolean isRegistered = false;

    public void contextInitialized(ServletContextEvent sce) {
        InitListener.oneTimeIdempotentInit(sce.getServletContext(), this.getClass().getName());
    }

    public static void oneTimeIdempotentInit(ServletContext servletContext, String initializingClassName) {
        if (servletContext != null && ISCFile.servletContext == null) {
            ISCFile.servletContext = servletContext;
        }
        ISCInit.go(initializingClassName);
        isRegistered = true;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SystemSchemaTranslation.finish();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        Logger.clearMDC();
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        RequestContext.purgeThreadLocal();
        Logger.removeContext();
        Logger.clearMDC();
        Logger.observeThread();
        Logger.enableThread();
        DataSource.purgeThreadDynamicId();
        DataSource.purgeLoadFlags();
        Config.getGlobal().purgeThreadLocal();
        if (request.getAttribute("isc_restart_requested") != null) {
            try {
                ISCInit.restartContainer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

