/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTree;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.PageSizePager;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;
import java.util.List;

public class CellBrowser
extends AbstractCellTree
implements ProvidesResize,
RequiresResize,
HasAnimation {
    private static Resources DEFAULT_RESOURCES;
    private static final SafeHtml LEAF_IMAGE;
    private static Template template;
    final List<TreeNodeImpl<?>> treeNodes = new ArrayList();
    private final ScrollAnimation animation = new ScrollAnimation();
    private final CellList.Resources cellListResources;
    private final SafeHtml closedImageHtml;
    private int defaultWidth = 200;
    private final int imageWidth;
    private boolean isAnimationEnabled;
    private final Widget loadingIndicator;
    private int minWidth;
    private final SafeHtml openImageHtml;
    private final PagerFactory pagerFactory;
    private final Integer pageSize;
    private Element scrollLock;
    private final Style style;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    @Deprecated
    public <T> CellBrowser(TreeViewModel viewModel, T rootValue) {
        this(new Builder<T>(viewModel, rootValue));
    }

    @Deprecated
    public <T> CellBrowser(TreeViewModel viewModel, T rootValue, Resources resources) {
        this(new Builder<T>(viewModel, rootValue).resources(resources));
    }

    protected <T> CellBrowser(Builder<T> builder) {
        super(((Builder)builder).viewModel);
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        Resources resources = ((Builder)builder).resources();
        this.style = resources.cellBrowserStyle();
        this.style.ensureInjected();
        this.cellListResources = new CellListResourcesImpl(resources);
        this.loadingIndicator = ((Builder)builder).loadingIndicator;
        this.pagerFactory = ((Builder)builder).pagerFactory;
        this.pageSize = ((Builder)builder).pageSize;
        this.initWidget(new SplitLayoutPanel());
        this.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
        this.setStyleName(this.style.cellBrowserWidget());
        ImageResource treeOpen = resources.cellBrowserOpen();
        ImageResource treeClosed = resources.cellBrowserClosed();
        this.openImageHtml = this.getImageHtml(treeOpen);
        this.closedImageHtml = this.getImageHtml(treeClosed);
        this.imageWidth = Math.max(treeOpen.getWidth(), treeClosed.getWidth());
        this.minWidth = this.imageWidth + 20;
        this.scrollLock = Document.get().createDivElement();
        this.scrollLock.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.scrollLock.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.scrollLock.getStyle().setZIndex(-32767);
        this.scrollLock.getStyle().setTop(0.0, Style.Unit.PX);
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            this.scrollLock.getStyle().setRight(0.0, Style.Unit.PX);
        } else {
            this.scrollLock.getStyle().setLeft(0.0, Style.Unit.PX);
        }
        this.scrollLock.getStyle().setHeight(1.0, Style.Unit.PX);
        this.scrollLock.getStyle().setWidth(1.0, Style.Unit.PX);
        this.getElement().appendChild(this.scrollLock);
        this.appendTreeNode(this.getNodeInfo(((Builder)builder).rootValue), ((Builder)builder).rootValue);
        this.sinkEvents(16384);
    }

    public int getDefaultColumnWidth() {
        return this.defaultWidth;
    }

    public int getMinimumColumnWidth() {
        return this.minWidth;
    }

    @Override
    public TreeNode getRootTreeNode() {
        return this.treeNodes.get(0);
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 16384: {
                this.adjustScrollLock();
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    public void onResize() {
        this.getSplitLayoutPanel().onResize();
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setDefaultColumnWidth(int width) {
        this.defaultWidth = width;
    }

    public void setMinimumColumnWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    protected <C> Widget createPager(HasData<C> display) {
        if (this.pagerFactory == null) {
            return null;
        }
        AbstractPager pager = this.pagerFactory.create(display);
        pager.setDisplay(display);
        return pager;
    }

    private void adjustScrollLock() {
        int scrollLeft = Math.abs(this.getElement().getScrollLeft());
        if (scrollLeft > 0) {
            int clientWidth = this.getElement().getClientWidth();
            this.scrollLock.getStyle().setWidth(scrollLeft + clientWidth, Style.Unit.PX);
        } else {
            this.scrollLock.getStyle().setWidth(1.0, Style.Unit.PX);
        }
    }

    private <C> TreeNode appendTreeNode(TreeViewModel.NodeInfo<C> nodeInfo, Object value) {
        int level = this.treeNodes.size();
        BrowserCellList<C> view = this.createDisplay(nodeInfo, level);
        ScrollPanel scrollable = new ScrollPanel();
        scrollable.getElement().setTabIndex(-1);
        Widget pager = this.createPager(view);
        if (pager != null) {
            FlowPanel flowPanel = new FlowPanel();
            flowPanel.add(view);
            flowPanel.add(pager);
            scrollable.setWidget(flowPanel);
        } else {
            scrollable.setWidget(view);
        }
        scrollable.setStyleName(this.style.cellBrowserColumn());
        if (level == 0) {
            scrollable.addStyleName(this.style.cellBrowserFirstColumn());
        }
        TreeNodeImpl<C> treeNode = new TreeNodeImpl<C>(nodeInfo, value, view, scrollable);
        this.treeNodes.add(treeNode);
        view.setSelectionModel(nodeInfo.getSelectionModel(), null);
        nodeInfo.setDataDisplay(view);
        SplitLayoutPanel splitPanel = this.getSplitLayoutPanel();
        splitPanel.insertLineStart(scrollable, this.defaultWidth, null);
        splitPanel.setWidgetMinSize(scrollable, this.minWidth);
        splitPanel.forceLayout();
        this.animation.scrollToEnd();
        return treeNode;
    }

    private <C> BrowserCellList<C> createDisplay(TreeViewModel.NodeInfo<C> nodeInfo, int level) {
        BrowserCellList<C> display = new BrowserCellList<C>(nodeInfo.getCell(), level, nodeInfo.getProvidesKey());
        if (this.loadingIndicator != null) {
            display.setLoadingIndicator(this.loadingIndicator);
        }
        if (this.pageSize != null) {
            display.setPageSize(this.pageSize);
        }
        display.setValueUpdater(nodeInfo.getValueUpdater());
        display.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        return display;
    }

    private SafeHtml getImageHtml(ImageResource res) {
        AbstractImagePrototype proto = AbstractImagePrototype.create(res);
        SafeHtml image = proto.getSafeHtml();
        SafeStylesBuilder cssBuilder = new SafeStylesBuilder();
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            cssBuilder.appendTrustedString("left:0px;");
        } else {
            cssBuilder.appendTrustedString("right:0px;");
        }
        cssBuilder.appendTrustedString("width: " + res.getWidth() + "px;");
        cssBuilder.appendTrustedString("height: " + res.getHeight() + "px;");
        return template.imageWrapper(cssBuilder.toSafeStyles(), image);
    }

    private SplitLayoutPanel getSplitLayoutPanel() {
        return (SplitLayoutPanel)this.getWidget();
    }

    private void trimToLevel(int level) {
        this.adjustScrollLock();
        for (int curLevel = this.treeNodes.size() - 1; curLevel > level; --curLevel) {
            TreeNodeImpl<?> removed = this.treeNodes.remove(curLevel);
            ((TreeNodeImpl)removed).destroy();
        }
        if (level < this.treeNodes.size()) {
            TreeNodeImpl<?> node = this.treeNodes.get(level);
            ((TreeNodeImpl)node).display.focusedKey = null;
            ((TreeNodeImpl)node).display.isFocusedOpen = false;
        }
    }

    private <C> TreeNode updateChildState(BrowserCellList<C> cellList, boolean fireEvents) {
        if (((BrowserCellList)cellList).isDestroyed) {
            return null;
        }
        Object newValue = cellList.getPresenter().getKeyboardSelectedRowValue();
        Object newKey = cellList.getValueKey(newValue);
        TreeNode closedNode = null;
        if (((BrowserCellList)cellList).focusedKey != null && ((BrowserCellList)cellList).isFocusedOpen && !((BrowserCellList)cellList).focusedKey.equals(newKey)) {
            closedNode = this.treeNodes.size() > ((BrowserCellList)cellList).level + 1 ? (TreeNode)this.treeNodes.get(((BrowserCellList)cellList).level + 1) : null;
            this.trimToLevel(((BrowserCellList)cellList).level);
        }
        TreeNode openNode = null;
        boolean justOpenedNode = false;
        if (newKey != null) {
            if (newKey.equals(((BrowserCellList)cellList).focusedKey)) {
                openNode = ((BrowserCellList)cellList).isFocusedOpen ? (TreeNode)this.treeNodes.get(((BrowserCellList)cellList).level + 1) : null;
            } else {
                TreeViewModel.NodeInfo<?> childNodeInfo;
                if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.getKeyboardSelectionPolicy()) {
                    cellList.setSelectedValue(newValue);
                }
                ((BrowserCellList)cellList).focusedKey = newKey;
                TreeViewModel.NodeInfo<?> nodeInfo = childNodeInfo = this.isLeaf(newValue) ? null : this.getNodeInfo(newValue);
                if (childNodeInfo != null) {
                    ((BrowserCellList)cellList).isFocusedOpen = true;
                    justOpenedNode = true;
                    openNode = this.appendTreeNode(childNodeInfo, newValue);
                }
            }
        }
        if (fireEvents) {
            if (closedNode != null) {
                CloseEvent.fire(this, closedNode);
            }
            if (openNode != null && justOpenedNode) {
                OpenEvent.fire(this, openNode);
            }
        }
        return openNode == null || openNode.isDestroyed() ? null : openNode;
    }

    static {
        LEAF_IMAGE = SafeHtmlUtils.fromSafeConstant("<div style='position:absolute;display:none;'></div>");
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellBrowserClosed();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellBrowserOpen();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Both, flipRtl=true)
        public ImageResource cellBrowserOpenBackground();

        @ClientBundle.Source(value={"cellTreeSelectedBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Both, flipRtl=true)
        public ImageResource cellBrowserSelectedBackground();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellBrowser.css"})
        public Style cellBrowserStyle();
    }

    class BrowserCellList<T>
    extends CellList<T> {
        private final int level;
        private Object focusedKey;
        private T selectedValue;
        private boolean isDestroyed;
        private boolean isFocusedOpen;
        private final Element tmpElem;

        public BrowserCellList(Cell<T> cell, int level, ProvidesKey<T> keyProvider) {
            super(cell, CellBrowser.this.cellListResources, keyProvider);
            this.tmpElem = Document.get().createDivElement();
            this.level = level;
        }

        protected void deselectValue() {
            SelectionModel<T> selectionModel = this.getSelectionModel();
            if (selectionModel != null && this.selectedValue != null) {
                selectionModel.setSelected(this.selectedValue, false);
            }
        }

        @Override
        protected Element getCellParent(Element item) {
            return item.getFirstChildElement().getNextSiblingElement();
        }

        @Override
        protected boolean isKeyboardNavigationSuppressed() {
            return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == CellBrowser.this.getKeyboardSelectionPolicy() || super.isKeyboardNavigationSuppressed();
        }

        @Override
        protected void onBrowserEvent2(Event event) {
            super.onBrowserEvent2(event);
            String eventType = event.getType();
            if ("keydown".equals(eventType) && !this.isKeyboardNavigationSuppressed()) {
                int keyCode = event.getKeyCode();
                boolean isRtl = LocaleInfo.getCurrentLocale().isRTL();
                keyCode = KeyCodes.maybeSwapArrowKeysForRtl(keyCode, isRtl);
                switch (keyCode) {
                    case 37: {
                        this.keyboardNavigateShallow();
                        return;
                    }
                    case 39: {
                        this.keyboardNavigateDeep();
                        return;
                    }
                }
            }
        }

        @Override
        protected void renderRowValues(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
            Cell cell = this.getCell();
            String keyboardSelectedItem = " " + CellBrowser.this.style.cellBrowserKeyboardSelectedItem();
            String selectedItem = " " + CellBrowser.this.style.cellBrowserSelectedItem();
            String openItem = " " + CellBrowser.this.style.cellBrowserOpenItem();
            String evenItem = CellBrowser.this.style.cellBrowserEvenItem();
            String oddItem = CellBrowser.this.style.cellBrowserOddItem();
            int keyboardSelectedRow = this.getKeyboardSelectedRow() + this.getPageStart();
            int length = values.size();
            int end = start + length;
            for (int i = start; i < end; ++i) {
                T value = values.get(i - start);
                boolean isSelected = selectionModel == null ? false : selectionModel.isSelected(value);
                boolean isOpen = this.isOpen(i);
                StringBuilder classesBuilder = new StringBuilder();
                classesBuilder.append(i % 2 == 0 ? evenItem : oddItem);
                if (isOpen) {
                    classesBuilder.append(openItem);
                }
                if (isSelected) {
                    classesBuilder.append(selectedItem);
                }
                SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
                Cell.Context context = new Cell.Context(i, 0, this.getValueKey(value));
                cell.render(context, value, cellBuilder);
                SafeHtml image = isOpen ? CellBrowser.this.openImageHtml : (CellBrowser.this.isLeaf(value) ? LEAF_IMAGE : CellBrowser.this.closedImageHtml);
                SafeStyles padding = SafeStylesUtils.fromTrustedString("padding-right: " + CellBrowser.this.imageWidth + "px;");
                if (i == keyboardSelectedRow) {
                    char accessKey;
                    if (this.isFocused) {
                        classesBuilder.append(keyboardSelectedItem);
                    }
                    if ((accessKey = this.getAccessKey()) != '\u0000') {
                        sb.append(template.divFocusableWithKey(i, classesBuilder.toString(), padding, this.getTabIndex(), this.getAccessKey(), image, cellBuilder.toSafeHtml()));
                        continue;
                    }
                    sb.append(template.divFocusable(i, classesBuilder.toString(), padding, this.getTabIndex(), image, cellBuilder.toSafeHtml()));
                    continue;
                }
                sb.append(template.div(i, classesBuilder.toString(), padding, image, cellBuilder.toSafeHtml()));
            }
            CellBrowser.this.updateChildState(this, true);
        }

        @Override
        protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
            super.setKeyboardSelected(index, selected, stealFocus);
            if (!this.isRowWithinBounds(index)) {
                return;
            }
            Element elem = this.getRowElement(index);
            Object value = this.getPresenter().getVisibleItem(index);
            boolean isOpen = selected && this.isOpen(index);
            BrowserCellList.setStyleName(elem, CellBrowser.this.style.cellBrowserOpenItem(), isOpen);
            SafeHtml image = null;
            image = isOpen ? CellBrowser.this.openImageHtml : (CellBrowser.this.getTreeViewModel().isLeaf(value) ? LEAF_IMAGE : CellBrowser.this.closedImageHtml);
            this.tmpElem.setInnerSafeHtml(image);
            elem.replaceChild(this.tmpElem.getFirstChildElement(), elem.getFirstChildElement());
            CellBrowser.this.updateChildState(this, true);
        }

        protected void setSelectedValue(T value) {
            Object oldKey = this.getValueKey(this.selectedValue);
            Object newKey = this.getValueKey(value);
            if (newKey != null && newKey.equals(oldKey)) {
                return;
            }
            this.deselectValue();
            SelectionModel<T> selectionModel = this.getSelectionModel();
            if (selectionModel != null) {
                this.selectedValue = value;
                selectionModel.setSelected(this.selectedValue, true);
            }
        }

        private boolean isOpen(int index) {
            Object value = this.getPresenter().getKeyboardSelectedRowValue();
            return index == this.getKeyboardSelectedRow() && value != null && !CellBrowser.this.getTreeViewModel().isLeaf(value);
        }

        private void keyboardNavigateDeep() {
            if (CellBrowser.this.isKeyboardSelectionDisabled()) {
                return;
            }
            if (this.level < CellBrowser.this.treeNodes.size() - 1) {
                TreeNodeImpl<?> treeNode = CellBrowser.this.treeNodes.get(this.level + 1);
                ((TreeNodeImpl)treeNode).display.getPresenter().setKeyboardSelectedRow(((TreeNodeImpl)treeNode).display.getKeyboardSelectedRow(), true, true);
            }
        }

        private void keyboardNavigateShallow() {
            if (CellBrowser.this.isKeyboardSelectionDisabled()) {
                return;
            }
            if (this.level > 0) {
                TreeNodeImpl<?> treeNode = CellBrowser.this.treeNodes.get(this.level - 1);
                ((TreeNodeImpl)treeNode).display.setFocus(true);
            }
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div __idx=\"{0}\" class=\"{1}\" style=\"{2}position:relative;outline:none;\">{3}<div>{4}</div></div>")
        public SafeHtml div(int var1, String var2, SafeStyles var3, SafeHtml var4, SafeHtml var5);

        @SafeHtmlTemplates.Template(value="<div __idx=\"{0}\" class=\"{1}\" style=\"{2}position:relative;outline:none;\" tabindex=\"{3}\">{4}<div>{5}</div></div>")
        public SafeHtml divFocusable(int var1, String var2, SafeStyles var3, int var4, SafeHtml var5, SafeHtml var6);

        @SafeHtmlTemplates.Template(value="<div __idx=\"{0}\" class=\"{1}\" style=\"{2}position:relative;outline:none;\" tabindex=\"{3}\" accessKey=\"{4}\">{5}<div>{6}</div></div>")
        public SafeHtml divFocusableWithKey(int var1, String var2, SafeStyles var3, int var4, char var5, SafeHtml var6, SafeHtml var7);

        @SafeHtmlTemplates.Template(value="<div style=\"{0}position:absolute;\">{1}</div>")
        public SafeHtml imageWrapper(SafeStyles var1, SafeHtml var2);
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellBrowser")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellBrowser.css";

        public String cellBrowserColumn();

        public String cellBrowserEvenItem();

        public String cellBrowserFirstColumn();

        public String cellBrowserKeyboardSelectedItem();

        public String cellBrowserOddItem();

        public String cellBrowserOpenItem();

        public String cellBrowserSelectedItem();

        public String cellBrowserWidget();
    }

    public static class Builder<T> {
        private final TreeViewModel viewModel;
        private final T rootValue;
        private Widget loadingIndicator;
        private PagerFactory pagerFactory = new PageSizePagerFactory();
        private Integer pageSize;
        private Resources resources;

        public Builder(TreeViewModel viewModel, T rootValue) {
            this.viewModel = viewModel;
            this.rootValue = rootValue;
        }

        public CellBrowser build() {
            return new CellBrowser(this);
        }

        public Builder<T> loadingIndicator(Widget widget) {
            this.loadingIndicator = widget;
            return this;
        }

        public Builder<T> pagerFactory(PagerFactory factory) {
            this.pagerFactory = factory;
            return this;
        }

        public Builder<T> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder<T> resources(Resources resources) {
            this.resources = resources;
            return this;
        }

        private Resources resources() {
            if (this.resources == null) {
                this.resources = CellBrowser.getDefaultResources();
            }
            return this.resources;
        }
    }

    private class ScrollAnimation
    extends Animation {
        private int startScrollLeft;
        private int targetScrollLeft;

        private ScrollAnimation() {
        }

        @Override
        protected void onComplete() {
            CellBrowser.this.getElement().setScrollLeft(this.targetScrollLeft);
        }

        @Override
        protected void onUpdate(double progress) {
            int diff = this.targetScrollLeft - this.startScrollLeft;
            CellBrowser.this.getElement().setScrollLeft(this.startScrollLeft + (int)((double)diff * progress));
        }

        void scrollToEnd() {
            com.google.gwt.user.client.Element elem = CellBrowser.this.getElement();
            this.targetScrollLeft = elem.getScrollWidth() - elem.getClientWidth();
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                this.targetScrollLeft *= -1;
            }
            if (CellBrowser.this.isAnimationEnabled()) {
                this.startScrollLeft = elem.getScrollLeft();
                this.run(250, elem);
            } else {
                this.onComplete();
            }
        }
    }

    private static class CellListResourcesImpl
    implements CellList.Resources {
        private final Resources delegate;
        private final CellListStyleImpl style;

        public CellListResourcesImpl(Resources delegate) {
            this.delegate = delegate;
            this.style = new CellListStyleImpl(delegate.cellBrowserStyle());
        }

        @Override
        public ImageResource cellListSelectedBackground() {
            return this.delegate.cellBrowserSelectedBackground();
        }

        @Override
        public CellList.Style cellListStyle() {
            return this.style;
        }
    }

    public static interface PagerFactory {
        public AbstractPager create(HasRows var1);
    }

    class TreeNodeImpl<C>
    implements TreeNode {
        private final BrowserCellList<C> display;
        private TreeViewModel.NodeInfo<C> nodeInfo;
        private final Object value;
        private final HandlerRegistration valueChangeHandler;
        private final Widget widget;

        public TreeNodeImpl(TreeViewModel.NodeInfo<C> nodeInfo, Object value, final BrowserCellList<C> display, Widget widget) {
            this.display = display;
            this.nodeInfo = nodeInfo;
            this.value = value;
            this.widget = widget;
            this.valueChangeHandler = display.addValueChangeHandler(new ValueChangeHandler<List<C>>(){
                final /* synthetic */ TreeNodeImpl this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void onValueChange(ValueChangeEvent<List<C>> event) {
                    Object focusedKey = display.focusedKey;
                    if (focusedKey != null) {
                        boolean stillExists = false;
                        List displayValues = event.getValue();
                        for (Object displayValue : displayValues) {
                            if (!focusedKey.equals(display.getValueKey(displayValue))) continue;
                            stillExists = true;
                            break;
                        }
                        if (!stillExists) {
                            this.this$1.CellBrowser.this.trimToLevel(display.level);
                        }
                    }
                }
            });
        }

        @Override
        public int getChildCount() {
            this.assertNotDestroyed();
            return this.display.getPresenter().getVisibleItemCount();
        }

        public C getChildValue(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            return (C)this.display.getVisibleItem(index);
        }

        @Override
        public int getIndex() {
            this.assertNotDestroyed();
            TreeNode parent = this.getParent();
            return parent == null ? 0 : super.getOpenIndex();
        }

        @Override
        public TreeNodeImpl<?> getParent() {
            this.assertNotDestroyed();
            return this.getParentImpl();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isChildLeaf(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            return CellBrowser.this.isLeaf(this.getChildValue(index));
        }

        @Override
        public boolean isChildOpen(int index) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            return ((BrowserCellList)this.display).focusedKey == null || !((BrowserCellList)this.display).isFocusedOpen ? false : ((BrowserCellList)this.display).focusedKey.equals(this.display.getValueKey(this.getChildValue(index)));
        }

        @Override
        public boolean isDestroyed() {
            TreeNodeImpl<?> parent;
            if (this.nodeInfo != null && (parent = this.getParentImpl()) != null && !parent.isDestroyed()) {
                parent.display.getPresenter().flush();
            }
            return this.nodeInfo == null;
        }

        @Override
        public TreeNode setChildOpen(int index, boolean open) {
            return this.setChildOpen(index, open, true);
        }

        @Override
        public TreeNode setChildOpen(int index, boolean open, boolean fireEvents) {
            this.assertNotDestroyed();
            this.checkChildBounds(index);
            if (open) {
                this.display.getPresenter().setKeyboardSelectedRow(index, false, true);
                return CellBrowser.this.updateChildState(this.display, fireEvents);
            }
            if (index == this.display.getKeyboardSelectedRow()) {
                this.display.getPresenter().clearKeyboardSelectedRowValue();
                CellBrowser.this.updateChildState(this.display, fireEvents);
            }
            return null;
        }

        BrowserCellList<C> getDisplay() {
            return this.display;
        }

        Object getFocusedKey() {
            return ((BrowserCellList)this.display).focusedKey;
        }

        boolean isFocusedOpen() {
            return ((BrowserCellList)this.display).isFocusedOpen;
        }

        private void assertNotDestroyed() {
            if (this.isDestroyed()) {
                throw new IllegalStateException("TreeNode no longer exists.");
            }
        }

        private void checkChildBounds(int index) {
            if (index < 0 || index >= this.getChildCount()) {
                throw new IndexOutOfBoundsException();
            }
        }

        private void destroy() {
            ((BrowserCellList)this.display).isDestroyed = true;
            this.valueChangeHandler.removeHandler();
            this.display.deselectValue();
            this.display.setSelectionModel(null);
            this.nodeInfo.unsetDataDisplay();
            CellBrowser.this.getSplitLayoutPanel().remove(this.widget);
            this.nodeInfo = null;
        }

        private int getOpenIndex() {
            return ((BrowserCellList)this.display).isFocusedOpen ? this.display.getKeyboardSelectedRow() : -1;
        }

        private TreeNodeImpl<?> getParentImpl() {
            return ((BrowserCellList)this.display).level == 0 ? null : CellBrowser.this.treeNodes.get(((BrowserCellList)this.display).level - 1);
        }
    }

    private static class PageSizePagerFactory
    implements PagerFactory {
        private PageSizePagerFactory() {
        }

        @Override
        public AbstractPager create(HasRows display) {
            return new PageSizePager(display.getVisibleRange().getLength());
        }
    }

    private static class CellListStyleImpl
    implements CellList.Style {
        private final Style delegate;

        public CellListStyleImpl(Style delegate) {
            this.delegate = delegate;
        }

        @Override
        public String cellListEvenItem() {
            return this.delegate.cellBrowserEvenItem();
        }

        @Override
        public String cellListKeyboardSelectedItem() {
            return this.delegate.cellBrowserKeyboardSelectedItem();
        }

        @Override
        public String cellListOddItem() {
            return this.delegate.cellBrowserOddItem();
        }

        @Override
        public String cellListSelectedItem() {
            return this.delegate.cellBrowserSelectedItem();
        }

        @Override
        public String cellListWidget() {
            return null;
        }

        @Override
        public boolean ensureInjected() {
            return this.delegate.ensureInjected();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getText() {
            return this.delegate.getText();
        }
    }
}

