/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.tour;

import com.smartgwt.client.util.tour.Tour;
import com.smartgwt.client.util.workflow.Process;
import com.smartgwt.client.callbacks.ProcessCallback;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class ProductTour extends ShowcasePanel {

    private static final String DESCRIPTION = 
    		"You can create attractive 'tours' of your product using the Tour system.<P>" +
    		"Click the 'Start Tour' button to start a tour of this Showcase.<P>" +
    		"Tours are extremely easy to build: they can be defined declaratively in an XML file, without writing any code.<P>" +
    		"Each step of the Tour provides text to show the user, and uses a locator to refer to some screen element. Placement of the tour window is automatic.<P>" +
    		"A locator can be obtained for any screen element using the Developer Console. <code>locators</code> are also used for Automated Testing. "
    		+ "They work cross-browser, and continue to work even if you rearrange your UI, so your tours will keep working even as you change your product!";
 
    public static class Factory  implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	ProductTour panel = new ProductTour();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
        
        public SourceEntity[] getSourceUrls() {
            return new SourceEntity[]{
                new SourceEntity("ProductTour.java", JAVA, "source/tour/ProductTour.java.html", false),
                new SourceEntity("productTour.process.xml", XML, "source/processes/productTour.process.xml.html", true)
            };
        }

    }

    public Canvas getViewPanel() {
    	
    	Button launchButton = new Button("Start Tour");
    	
    	launchButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				Tour.loadTour("productTour", new ProcessCallback() {
					
					@Override
					public void execute(Process process) {
						process.start();
						
					}
				});
				
			}
		});

        return launchButton;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
}
