package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.FilterBuilder;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.grid.HeaderSpan;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class AggregationCustomSQLSample extends ShowcasePanel {

    private static final String DESCRIPTION =
		"The Server Summaries feature can be used in combination with the SQL Templating feature to manage\r" +
		"filtering behavior.\r" +
		"<p>\r" +
		"This sample demonstrates two custom fetch operations against the <code>orderItem</code> dataSource. \r" +
		"Both are grouped by customer name and item, and show aggregated values for the\r" +
		"<code>amount</code> and <code>quantity</code> fields.\r" +
		"<P>\r" +
		"The filter form allows us to generate criteria for amount and quantity fields. By default filtering\r" +
		"will be applied post-aggregation, so a filter for items with <code>amount</code> greater than <code>30.00</code>\r" +
		"would retrieve orderItems where the aggregated total <code>amount</code> for the combined dataSource records\r" +
		"exceeds that value.\r" +
		"<br>\r" +
		"Side note: the <code>amount</code> field has its own customSQL expression \"<code>quantity * unitPrice</code>\".\r" +
		"This is automatically included inside the <code>\"sum\"</code> summaryFunction of the generated SQL, so you'll\r" +
		"ultimately end up with a group where clause like \"<code>sum(quantity*unitPrice) &gt; 30</code>\".\r" +
		"<P>\r" +
		"The second custom operation allows developers to apply the same criteria before aggregration. \r" +
		"It achieves this via SQL Templating within the <code>operationBinding</code>. The \"amount\" criteria\r" +
		"is manually included in <code>operationBinding.whereClause</code> and excluded from \r" +
		"<code>operationBinding.groupWhereClause</code>. (See the \r" +
		"<a href=https://www.smartclient.com/smartgwtee-latest/javadoc/index.html?com/smartgwt/client/docs/ServerSummaries.html>server summaries documentation</a> \r" +
		"for details on the <code>$sql.partialWhere(...)</code> and <code>$sql.partialHaving(...)</code> constructions used\r" +
		"to achieve this.)<br>\r" +
		"In this case, instead of having \"<code>sum(quantity*unitPrice) &gt; 30</code>\" in the group where clause of\r" +
		"the generated SQL statement, the main where clause will include \"<code>quantity * unitPrice &gt; 30</code>\".\r" +
		"<P>\r" +
		"To see this in action, use the top drop-down to select which fetch operation you want to perform. This causes\r" +
		"the appropriate <code>dsRequest.operationId</code> to be applied to the fetch request.";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	AggregationCustomSQLSample panel = new AggregationCustomSQLSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
    	
    	final DynamicForm operationForm = new DynamicForm();
    	operationForm.setWidth(550);
        
        SelectItem operationId = new SelectItem();
        operationId.setTitle("Filter");
        operationId.setName("operationId");
        operationId.setWidth("100%");
        operationId.setDefaultToFirstOption(true);
        
        Map<String,String> valueMap = new HashMap<String,String>();
        valueMap.put("orderAmount", "Exclude entire orders with total value greater than");
        valueMap.put("itemAmount", "Exclude individual items within an order with value greater than");
        operationId.setValueMap(valueMap);
        
        operationForm.setFields(operationId);
        
    	DataSource ds = DataSource.get("aggregationCustomSQL_orderItem");
    	final FilterBuilder advancedFilter = new FilterBuilder();
    	advancedFilter.setDataSource(ds);    	
    	AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
    	      new Criterion("amount", OperatorId.GREATER_THAN, 30),
    	      new Criterion("quantity", OperatorId.GREATER_THAN, 3)
    	});    	
    	advancedFilter.setCriteria(adCriteria);    	
    	
    	final ListGrid orderList = new ListGrid();
    	orderList.setDataSource(ds);
    	orderList.setWidth(550);
    	orderList.setHeight(300);
    	orderList.setShowFilterEditor(false);
    	orderList.setAutoFetchData(false);
    	orderList.setCanEdit(false);
    	orderList.setCanRemoveRecords(false);
    	
    	ListGridField orderCustomerName = new ListGridField("orderCustomerName");
    	orderCustomerName.setTitle("Customer name");
    	ListGridField itemDescription = new ListGridField("itemDescription");
    	ListGridField amount = new ListGridField("amount");
    	amount.setType(ListGridFieldType.FLOAT);
    	ListGridField quantity = new ListGridField("quantity");
    	quantity.setType(ListGridFieldType.INTEGER);
    	
    	orderList.setFields(orderCustomerName,itemDescription,amount,quantity);    	
    	
    	orderList.setHeaderSpans(new HeaderSpan[] {
    			new HeaderSpan("Items", new String[] {"itemCount", "items"})
        });
        
    	IButton filterButton = new IButton();
    	filterButton.setTitle("Filter");
    	filterButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				orderList.setData(new ListGridRecord[0]);
				DSRequest dsProperties = new DSRequest();
				dsProperties.setOperationId(operationForm.getValueAsString("operationId"));
				orderList.fetchData(advancedFilter.getCriteria(), null, dsProperties);
			}
    	});
    	
    	VStack vStack = new VStack();
    	vStack.setWidth100();
    	vStack.setMembersMargin(10);
    	vStack.setMembers(operationForm, advancedFilter, filterButton, orderList);
        
    	DSRequest dsProperties = new DSRequest();
		dsProperties.setOperationId(operationForm.getValueAsString("operationId"));
		orderList.fetchData(advancedFilter.getCriteria(), null, dsProperties);
    	
        return vStack;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

	public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("aggregationCustomSQL_order.ds.xml", XML, "source/aggregationCustomSQL_order.ds.xml.html", true)
        };
    }
}
