/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SimpleOperator
extends OperatorBase {
    @Override
    public boolean isRequiresFieldName() {
        return true;
    }

    @Override
    public boolean isRequiresValue() {
        return true;
    }

    @Override
    public boolean isRequiresCriteria() {
        return false;
    }

    public Criterion parseCriterion(String fieldName, Object value, List criterias, Map fieldQuery, Map valueQuery) {
        if (fieldName != null && fieldQuery != null) {
            log.warn("Both fieldName and fieldQuery were provided to parseCriterion().  Using fieldQuery");
            fieldName = null;
        }
        if (value != null && valueQuery != null) {
            log.warn("Both value and valueQuery were provided to parseCriterion().  Using valueQuery");
            value = null;
        }
        SimpleCriterion rtnValue = new SimpleCriterion(fieldName, this.getID(), value);
        rtnValue.setFieldQuery(fieldQuery);
        rtnValue.setValueQuery(valueQuery);
        return rtnValue;
    }

    public Map convertToMap(Criterion criterion) {
        boolean isValueQuery;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isFieldQuery = criterion.getFieldQuery() != null;
        boolean bl = isValueQuery = criterion.getValueQuery() != null;
        if (criterion instanceof RangeCriterion) {
            RangeCriterion rc = (RangeCriterion)criterion;
            result.put("operator", rc.getOperatorId());
            if (!isFieldQuery) {
                result.put("fieldName", rc.getFieldName());
            }
            if (isFieldQuery) {
                result.put("fieldQuery", rc.getFieldQuery());
            }
            result.put("min", rc.getMin());
            result.put("max", rc.getMax());
        } else if (criterion instanceof SetCriterion) {
            SetCriterion sc = (SetCriterion)criterion;
            result.put("operator", sc.getOperatorId());
            if (!isFieldQuery) {
                result.put("fieldName", sc.getFieldName());
            }
            if (isFieldQuery) {
                result.put("fieldQuery", sc.getFieldQuery());
            }
            if (!isValueQuery) {
                result.put("value", sc.getValues());
            }
            if (isValueQuery) {
                result.put("valueQuery", sc.getValueQuery());
            }
        } else if (criterion instanceof SimpleCriterion) {
            SimpleCriterion sc = (SimpleCriterion)criterion;
            result.put("operator", sc.getOperatorId());
            if (!isFieldQuery) {
                result.put("fieldName", sc.getFieldName());
            }
            if (isFieldQuery) {
                result.put("fieldQuery", sc.getFieldQuery());
            }
            if (!isValueQuery) {
                result.put("value", sc.getValue());
            }
            if (isValueQuery) {
                result.put("valueQuery", sc.getValueQuery());
            }
        }
        return result;
    }
}

