/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class CacheSyncStrategy {
    protected Logger log = new Logger(this.getClass());
    private static Map<String, Map<Class, CacheSyncStrategy>> registeredStrategies = new HashMap<String, Map<Class, CacheSyncStrategy>>();

    public abstract List getCacheSyncData(DSRequest var1, DSResponse var2) throws Exception;

    public abstract boolean worksForBatchAdd(DSRequest var1) throws Exception;

    public boolean shouldRunCacheSync(DSRequest req) throws Exception {
        DataSource ds;
        boolean shouldRun = true;
        if (req.isCacheSyncSkipped()) {
            shouldRun = false;
        }
        if ((ds = req.getDataSource()) instanceof ISQLDataSource) {
            shouldRun = shouldRun && !((ISQLDataSource)((Object)ds)).shouldInvalidateCache(req);
        } else {
            Object work;
            String opType = req.getOperationType();
            if (!(DataSource.isAdd(opType) || DataSource.isRemove(opType) || DataSource.isUpdate(opType))) {
                shouldRun = false;
            }
            if ((work = DataSource.getOperationProperty(req, "canSyncCache", null)) != null) {
                boolean bl = shouldRun = shouldRun && !work.toString().toLowerCase().equals("false");
            }
        }
        if (shouldRun && DataSource.isAdd(req.getOperationType()) && req.getValueSets().size() > 1 && !"simple".equals(req.getMultiInsertStrategy())) {
            shouldRun = this.worksForBatchAdd(req);
        }
        return shouldRun;
    }

    public void applyCacheSyncStrategy(DSRequest req, DSResponse resp) throws Exception {
        List data = this.getCacheSyncData(req, resp);
        if (data != null) {
            resp.setData(data);
        }
        resp.setCacheSyncComplete(true);
    }

    public boolean isCacheSyncFetchAllowed(DSRequest req, DSResponse resp) throws Exception {
        DataSource ds = req.getDataSource();
        String cacheSyncOperation = this.getCacheSyncOperation(req);
        DSRequest csReq = new DSRequest(req.getDataSource(), "fetch", req.getDSCacheManager());
        csReq.setOperationId(cacheSyncOperation);
        csReq.inheritClientContext(req);
        csReq.setPrimaryDSRequest(req);
        csReq.setParameter("additionalOutputs", req.getParameter("additionalOutputs"));
        csReq.setOutputs(req.getOutputs());
        if ("add".equals(req.getOperationType())) {
            List valueSets = req.getValueSets();
            HashMap valueSet = new HashMap((Map)valueSets.get(0));
            HashMap crit = new HashMap();
            HashMap values = new HashMap();
            for (String key : ds.getPrimaryKeys()) {
                crit.put(key, valueSet.get(key));
                valueSet.remove(key);
            }
            csReq.setCriteria(crit);
            csReq.setValues(valueSet);
        } else {
            csReq.setCriteria(req.getCriteria());
            csReq.setValues(req.getValues());
        }
        Iterator i = req.getAttributeNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            csReq.setAttribute(key, req.getAttribute(key));
        }
        boolean passesSecurityChecks = csReq.passesSecurityChecks();
        if (passesSecurityChecks) {
            DeclarativeSecurity.performFieldLevelDSRequestChecks(csReq);
            if (csReq.getDroppedFields() != null) {
                Iterator i2 = csReq.getDroppedFields().iterator();
                while (i2.hasNext()) {
                    req.removeField((String)i2.next(), true);
                }
            }
        }
        return passesSecurityChecks;
    }

    protected String getCacheSyncOperation(DSRequest request) throws Exception {
        DataTypeMap syncOpBinding;
        DataSource ds = request.getDataSource();
        String cacheSyncOperation = null;
        DataTypeMap updateOperationBinding = ds.getOperationBinding(request.getOperationType(), request.getOperationId());
        if (updateOperationBinding != null) {
            cacheSyncOperation = (String)updateOperationBinding.get("cacheSyncOperation");
        }
        if ((syncOpBinding = ds.getOperationBinding("fetch", cacheSyncOperation)) != null) {
            Object cacheSyncObj;
            boolean useIt = true;
            if (cacheSyncOperation == null && (cacheSyncObj = syncOpBinding.get("useForCacheSync")) != null) {
                useIt = Boolean.parseBoolean(cacheSyncObj.toString());
            }
            if (useIt) {
                if (cacheSyncOperation != null) {
                    this.log.info(ds.getName() + ": using specific cacheSyncOperation " + cacheSyncOperation);
                } else {
                    this.log.info(ds.getName() + ": using default operationBinding");
                }
            }
        }
        return cacheSyncOperation;
    }

    protected void convertToBeansIfRequired(DSRequest request, DSResponse response, List responseData) throws Exception {
        if (responseData == null || responseData.size() == 0) {
            return;
        }
        DataSource ds = request.getDataSource();
        DataTypeMap opConfig = ds.getOperationBinding(request);
        String beanClassName = null;
        if (opConfig != null) {
            beanClassName = (String)opConfig.get("beanClassName");
        }
        if (beanClassName == null && ds != null) {
            beanClassName = (String)ds.getConfig().get("beanClassName");
        }
        if (beanClassName != null && beanClassName.trim().length() > 0) {
            for (int i = 0; i < responseData.size(); ++i) {
                Map map = (Map)responseData.get(i);
                Object bean = DataTools.setProperties(map, Reflection.classForName(beanClassName).newInstance());
                responseData.set(i, bean);
            }
        }
    }

    static class CacheSyncNotAllowedException
    extends Exception {
        CacheSyncNotAllowedException() {
        }
    }
}

