/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.base.ISCInit;
import com.isomorphic.log.Logger;

public class Base
implements IAutoConfigurable {
    public static Config config = new Config();
    public static final boolean globalDebug;
    protected Logger log = new Logger(this.getClass().getName());
    public String configRoot;
    protected Config localConfig;
    public String implementer;

    @Override
    public void initAutoConfigurable(String configRoot) {
        this.configRoot = configRoot;
        Config localConfig = config.getSubtree(configRoot);
        this.initAutoConfigurable(localConfig);
    }

    @Override
    public void initAutoConfigurable(Config localConfig) {
        this.localConfig = localConfig;
        this.configRoot = localConfig.getString("configRoot", this.configRoot);
        if (this.configRoot != null) {
            this.log = new Logger(this.getClass().getName(), this.configRoot);
        }
    }

    public String getConfigRoot() {
        return this.configRoot;
    }

    public Config getLocalConfig() {
        return this.localConfig;
    }

    static {
        ISCInit.go(Base.class.getName());
        config = Config.getGlobal();
        globalDebug = config.getBoolean((Object)"debug", false);
    }
}

