/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompressionFilter
extends BaseFilter {
    private static Logger log;
    public int compressThreshold;
    public List compressableMimeTypes = null;
    private Config cacheControlOverrides;

    public void setCompressThreshold(String value) {
        this.compressThreshold = DataTypeMap.dataSizeNumBytes((Object)value, 250L).intValue();
    }

    public void setCompressableMimeTypes(String value) {
        List<String> list = DataTools.commaSeparatedStringToList(value);
        this.compressableMimeTypes = new ArrayList();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            String mimeType = i.next().toString().toLowerCase();
            if (mimeType.equals("")) continue;
            this.compressableMimeTypes.add(mimeType);
        }
        if (this.compressableMimeTypes.size() == 0) {
            this.compressableMimeTypes = null;
        }
        log.warn("CompressableMimeTypes: " + (this.compressableMimeTypes != null ? this.compressableMimeTypes.toString() : "null"));
    }

    public boolean canCompressContext(RequestContext context) {
        return ServletTools.compressionWorksForContext(context, log);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (log == null) {
            log = new Logger("com.isomorphic.compression.Compression");
        }
        this.cacheControlOverrides = config.getSubtree("compression.ie.svg.cacheControl");
        for (String key : this.cacheControlOverrides.keySet()) {
            this.cacheControlOverrides.put(key.toLowerCase(), this.cacheControlOverrides.get(key));
        }
        if (!InterfaceProvider.exists("IServletCompression")) {
            throw new ServletException("Compression module not found - CompressionFilter unavailable.");
        }
        try {
            IServletCompression i = (IServletCompression)InterfaceProvider.load("IServletCompression");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load compression module - compression unavailable.", e);
            throw new ServletException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestContext context = null;
        try {
            boolean mimeTypeCompressable;
            context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            String logPrefix = context.requestPath + ": ";
            boolean compress = true;
            String mimeType = ServletTools.mimeTypeForContext(context);
            boolean bl = mimeTypeCompressable = mimeType == null || ServletTools.compressionEnabledForMimeType(mimeType, this.compressableMimeTypes) && ServletTools.compressionWorksForMimeType(context, mimeType);
            if (!ServletTools.compressionEnabled()) {
                compress = false;
                log.debug(logPrefix + "Compression is disabled in config - not compressing");
            }
            if (compress && !this.canCompressContext(context)) {
                compress = false;
            }
            if (compress && !ServletTools.browserClaimsGZSupport(request) && !ServletTools.alwaysCompressMimeType(mimeType)) {
                compress = false;
                log.debug(logPrefix + "Browser is not compression-capable - not compressing");
            }
            if (compress && request.getAttribute("isc_dontCompress") != null) {
                compress = false;
                Object reason = request.getAttribute("isc_dontCompress");
                log.debug(logPrefix + "Compression disabled via isc_dontCompress flag" + (reason instanceof String ? reason.toString() : " - no reason provided") + ".");
            }
            if (compress && ServletTools.contextIsIncluded(context)) {
                compress = false;
                log.debug(logPrefix + "Filter invoked as part of include/forward - not compressing");
            }
            ServletTools.markContextAsIncluded(context);
            if (compress && !mimeTypeCompressable) {
                compress = false;
                log.debug(logPrefix + "Mime type '" + mimeType + "' is not compressable - not compressing");
            }
            if (!compress) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            log.debug(logPrefix + "Request looks compressable.");
            ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
            ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), "CompressionFilter");
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
            if (wrapResponse.dontCopyStreams) {
                log.debug(logPrefix + "WrapResponse dictates no compression.");
                return;
            }
            try {
                wrapResponse.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wrapBuf.flush();
            if (request.getAttribute("isc_dontCompress") != null) {
                compress = false;
                Object reason = request.getAttribute("isc_dontCompress");
                log.debug(logPrefix + "Compression disabled via isc_dontCompress flag" + (reason instanceof String ? reason.toString() : " - no reason provided") + ".");
            }
            if (compress && response.containsHeader("Content-Encoding")) {
                compress = false;
                log.debug(logPrefix + "Content-Encoding was set by filtered content - not compressing");
            }
            if (compress && response.containsHeader("content-disposition")) {
                compress = false;
                log.debug(logPrefix + "content-disposition was set by filtered content - not compressing");
            }
            int status = wrapResponse.getStatus();
            if (compress && status != 200 && status != 0) {
                compress = false;
                log.debug(logPrefix + "Received non-OK (200) http status: " + status + " - not compressing");
            }
            String wrapMimeType = wrapResponse.iscGetContentType();
            if (compress) {
                if (wrapMimeType != null) {
                    log.debug(logPrefix + "Using upstream-specified mime type: " + wrapMimeType + " (container-derived mime type was: " + mimeType + ")");
                    mimeType = wrapMimeType;
                } else {
                    log.debug("Using container-derived mime type: " + mimeType);
                }
                context.contentType = mimeType;
            }
            if (compress && !ServletTools.compressionEnabledForMimeType(mimeType, this.compressableMimeTypes)) {
                compress = false;
                log.debug(logPrefix + "Mime type '" + mimeType + "' is not compressable - not compressing");
            }
            String cacheControlHeaderValue = wrapResponse.getHeader("cache-control");
            if (compress && cacheControlHeaderValue != null && ServletTools.browserIsMSIE(request) && mimeType != null && mimeType.indexOf("svg") != -1) {
                cacheControlHeaderValue = cacheControlHeaderValue.toLowerCase();
                String cacheControlHeaderName = wrapResponse.getHeaderNameCaseSensitive("cache-control");
                String cacheControlOverride = this.cacheControlOverrides.getString(cacheControlHeaderValue);
                if (cacheControlOverride != null) {
                    log.debug(logPrefix + "Forcing " + cacheControlHeaderName + " to '" + cacheControlOverride + "' and proceeding with compression.");
                    response.setHeader(cacheControlHeaderName, cacheControlOverride);
                } else if (cacheControlHeaderValue.equals("no-cache")) {
                    log.warn(logPrefix + "Mime type '" + mimeType + "' is not compressable with Cache-Control: no-cache - not compressing.");
                    compress = false;
                }
            }
            if (!compress) {
                ServletOutputStream out = response.getOutputStream();
                wrapBuf.writeTo((OutputStream)out);
                try {
                    out.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    response.flushBuffer();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                    return;
                }
            }
            IServletCompression compression = (IServletCompression)InterfaceProvider.load("IServletCompression");
            compression.compressAndSend(context, wrapBuf, this.compressThreshold);
            return;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
            return;
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }
}

