/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.application.AppBase;
import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.SimpleCriteria;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.IsNullCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OtherFieldCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.Committable;
import com.isomorphic.datasource.DSCacheManager;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequestAlreadyStartedException;
import com.isomorphic.datasource.DSRequestCallback;
import com.isomorphic.datasource.DSRequestDoNotSerialize;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceDMI;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.SummaryFunctions;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.TemplatedMailMessage;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.velocity.IOWrapper;
import com.isomorphic.velocity.Velocity;
import jakarta.mail.Message;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DSRequest
extends BaseRequest<DSRequest, DSResponse>
implements Committable,
Callable<DSResponse> {
    private static Logger log = new Logger(DSRequest.class.getName());
    public static final String TRANSFORM_REQUEST_ATTRIBUTE_NAME = "transformRequestScript";
    public static final String TRANSFORM_RESPONSE_ATTRIBUTE_NAME = "transformResponseScript";
    public static final String TRANSFORM_RAW_RESPONSE_ATTRIBUTE_NAME = "transformRawResponseScript";
    public static final String REQUEST_TEMPLATE_ATTRIBUTE_NAME = "transformRequestScript";
    public static final String RESPONSE_TEMPLATE_ATTRIBUTE_NAME = "transformResponseScript";
    public static final String PAD_WITH_NULLS_STRATEGY = "padWithNulls";
    public static final String DROP_NON_MATCHING_RECORDS_STRATEGY = "dropRecords";
    public static final String DROP_NON_MATCHING_FIELDS_STRATEGY = "dropFields";
    public static final String POST_AGGREGATION_CRITERIA_ATTRIBUTE_NAME = "_postAggregationCriteria";
    private Map requestData;
    private AppBase app;
    Object clientSuppliedValues;
    Object clientSuppliedCriteria;
    private boolean beenThroughDMI = false;
    private boolean criteriaIsNormalized = false;
    private boolean beenThroughFieldLevelSecurity = false;
    private boolean validated = false;
    private boolean allowAnyRPC = false;
    private Object lastRow = null;
    private Map lastPrimaryKeys = null;
    private Map lastPrimaryKeysData = null;
    private Boolean partOfTransaction = null;
    private boolean beenThroughMailProcessing = false;
    private List<DSRequest> subRequests = new ArrayList<DSRequest>();
    private Map<String, DataSource> cachedDataSources = new HashMap<String, DataSource>();
    private boolean exportObjectCalled = false;
    private boolean sendRegularDSResponse = false;
    protected DSRequest primaryDSRequest = null;
    private boolean resourcesFreed = false;
    private boolean queueResourcesFreed = false;
    DataTypeMap sandboxContext = null;
    boolean assertedSandbox = false;
    Object dbSandboxToRestore = null;
    String sandboxDbName = null;
    private String operationType = null;
    private Boolean usePreparedStatements = null;
    public static final String SQL_PARAM_PREFIX = "^{";
    public static final String SQL_PARAM_SUFFIX = "}";
    private Map sqlParams;
    private Map<String, Integer> sqlParamsCounter;
    private LinkedList preparedSQLParams;
    List uploadedFiles;
    String downloadFieldName = null;
    String downloadFileName = null;
    private Boolean includeBinaryFields = null;
    private Object sortBy = null;
    private List<String> summaryFields;
    private List<String> groupBy = null;
    private Map<String, SummaryFunctionType> summaryFunctions = null;
    private Map<String, String> rawSummaryFunctions = null;
    private List summaryFunctionFields;
    public static final long FETCH_ALL = -1L;
    private long batchSize = -1L;
    private boolean _explicitBatchSize = false;
    private long startRow = 0L;
    private long endRow = -1L;
    public static final long ENDROW_UNSET = -1L;
    private String dataSourceName;
    DataSource ds;
    private static final AtomicBoolean warnedOfDataSourceReload = new AtomicBoolean(false);
    boolean requestStarted = false;
    public static int maxValuesMesssageLength = 1000;
    private boolean logResponseData = true;
    private static List<String> knownMailProps = new ArrayList(){
        {
            this.add("messageData");
            this.add("multiple");
            this.add("messageTemplate");
            this.add("templateFile");
            this.add("from");
            this.add("replyTo");
            this.add("to");
            this.add("cc");
            this.add("bcc");
            this.add("subject");
            this.add("contentType");
            this.add("encoding");
            this.add("host");
            this.add("port");
            this.add("auth");
            this.add("user");
            this.add("password");
        }
    };
    DateTime currentDateTime;
    private static String responseDataRegex = "\\$responseData\\.(last|first)(\\( *('[\\$_a-zA-Z][\\$_a-zA-Z0-9]*'|\"[\\$_a-zA-Z][\\$_a-zA-Z0-9]*\")( *, *('(";
    private static Pattern responseDataPattern;
    private static String responsesRegex;
    private static Pattern responsesPattern;
    private boolean preparedFieldData = false;
    private List skippedFields;
    private List<String> expressionFields;
    private Object expressions;
    private List<String> sortExpressionFields;
    private boolean summaryFunction = false;
    private boolean valueOperation = false;
    private Relation subqueryRelations = null;
    private Relation subqueryConnector = null;
    private static final String QUERY_FIELD_NAME_PREFIX = "__qf__";
    private Map<String, Map> queryFields;
    private static final String STATIC_VALUE_FIELD_NAME_PREFIX = "__sv__";
    private Map<String, Map> staticValueFields;
    Map templateContext = new HashMap();
    Set<String> snippets = new HashSet<String>();
    Map scriptContext = new HashMap();
    public static final String BUILTIN_APPLICATION = "builtinApplication";
    public static final String RUNNING_ROWCOUNT_QUERY_MARKER = "_runningRowCountQuery";
    private Boolean _allowMultiUpdate = null;
    private boolean _allowArbitrarySubqueries = false;
    private Object constraints = null;
    private List outputs = null;
    private List additionalOutputs = null;
    private Map operationConfig = null;
    private boolean forceInvalidateCache = false;
    OutputStream exportOutputStream = null;
    protected String userId;
    protected List<String> userRoles = Arrays.asList("*");
    protected String securityFailureMessage;
    List checkedDataSources = new ArrayList();
    private Map attributes = new HashMap();
    private boolean _isAuditRequest = false;
    private Boolean joinTransaction = null;
    FreeResourcesHandler freeResourcesHandler;
    private Boolean freeOnExecute = null;
    private List includeFrom = new ArrayList();
    private List consolidatedOutputs;
    private List droppedFields;
    private List<Map> droppedFieldValues;
    private Map<String, IncludeFromDefinition> validIncludeFromFields;
    private boolean selectCriteriaFields = false;
    private boolean selectSortByFields = false;
    private boolean isSubquery = false;
    private String forcedAlias = null;
    private String queryOutput = null;
    private boolean isNestedSubRequest = false;
    private Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Map map1;
            Map map0;
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            if (arg0 instanceof Map) {
                map0 = (Map)arg0;
                map1 = (Map)arg1;
            } else {
                try {
                    map0 = DSRequest.this.getDataSource().getProperties(arg0);
                    map1 = DSRequest.this.getDataSource().getProperties(arg1);
                }
                catch (Exception e) {
                    log.warn((Object)"Exception during sorting", e);
                    return 0;
                }
            }
            for (String fieldName : DSRequest.this.getSortByFields()) {
                int result;
                boolean descending;
                block17: {
                    IncludeFromDefinition incFrom;
                    descending = false;
                    if (fieldName.indexOf("-") == 0) {
                        fieldName = fieldName.substring(1);
                        descending = true;
                    }
                    if ((incFrom = IncludeFromDefinition.forSortByField(DSRequest.this.includeFrom, fieldName, true)) != null) {
                        fieldName = incFrom.getThisFieldName();
                    }
                    Object value0 = map0.get(fieldName);
                    Object value1 = map1.get(fieldName);
                    if (value0 == null) {
                        if (value1 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (value1 == null) {
                        return 1;
                    }
                    if (!(value0 instanceof Comparable)) continue;
                    result = 0;
                    try {
                        result = ((Comparable)value0).compareTo(value1);
                    }
                    catch (Exception e) {
                        if (!(value0 instanceof Number) || !(value1 instanceof Number)) break block17;
                        try {
                            int dp = Base.config.getInt("manual.server.sort.rounding.scale", 3);
                            BigDecimal bd0 = new BigDecimal(((Number)value0).doubleValue());
                            bd0 = bd0.setScale(dp, RoundingMode.HALF_UP);
                            BigDecimal bd1 = new BigDecimal(((Number)value1).doubleValue());
                            bd1 = bd1.setScale(dp, RoundingMode.HALF_UP);
                            result = bd0.compareTo(bd1);
                        }
                        catch (Exception e2) {
                            log.warn("Error comparing values " + String.valueOf(value0) + " and " + String.valueOf(value1) + " for field " + fieldName);
                            throw e;
                        }
                    }
                }
                if (result == 0) continue;
                return result * (descending ? -1 : 1);
            }
            return 0;
        }
    };
    private Boolean _shouldTrackTimings = null;
    private Boolean skipCacheSync = false;
    private Boolean skipAudit = null;
    DSRequestCallback callback;
    private Boolean _deferCacheSync = null;
    private String _discoveredCacheSyncStrategyName = null;
    private CacheSyncStrategy _discoveredCacheSyncStrategy = null;
    private boolean _warnIfFieldLevelSecurityFails;
    boolean criteriaTrimmed = false;

    public Object getParameter(Object key) {
        return this.requestData.get(key);
    }

    public boolean hasParameter(Object key) {
        return this.requestData.containsKey(key);
    }

    public DSRequest setParameter(Object key, Object value) {
        this.requestData.put(key, value);
        return this;
    }

    public boolean getBeenThroughDMI() {
        return this.beenThroughDMI;
    }

    public DSRequest setBeenThroughDMI(boolean newValue) {
        this.beenThroughDMI = newValue;
        return this;
    }

    public boolean getCriteriaIsNormalized() {
        return this.criteriaIsNormalized;
    }

    public DSRequest setCriteriaIsNormalized(boolean newValue) {
        this.criteriaIsNormalized = newValue;
        return this;
    }

    public boolean hasBeenThroughFieldLevelSecurity() {
        return this.beenThroughFieldLevelSecurity;
    }

    public DSRequest setBeenThroughFieldLevelSecurity(boolean newValue) {
        this.beenThroughFieldLevelSecurity = newValue;
        return this;
    }

    public boolean getValidated() {
        return this.validated;
    }

    public DSRequest setValidated(boolean newValue) {
        this.validated = newValue;
        return this;
    }

    public void clearCache() {
        this.lastRow = null;
        this.lastPrimaryKeys = null;
        this.lastPrimaryKeysData = null;
    }

    public Object getLastRow() throws Exception {
        return this.getLastRow(null, true);
    }

    public Object getLastRow(DSResponse resp, boolean qualifyColumnNames) throws Exception {
        if (this.lastRow == null) {
            CacheSyncStrategy strategy = this.getCacheSyncStrategy();
            if (strategy.shouldRunCacheSync(this) && !this.shouldDeferCacheSync()) {
                log.debug("Running cache sync eagerly");
                this.lastRow = strategy.getCacheSyncData(this, resp);
            } else {
                log.debug("Deferring cache sync...");
            }
        }
        return this.lastRow;
    }

    public void setLastPrimaryKeys(Map primaryKeys) {
        this.lastPrimaryKeys = primaryKeys;
    }

    public Map getLastPrimaryKeys(DSResponse resp) throws Exception {
        if (this.lastPrimaryKeys != null) {
            return this.lastPrimaryKeys;
        }
        DataSource ds = this.getDataSource();
        ISQLDataSource sqlDs = (ISQLDataSource)((Object)ds);
        if (resp != null && resp.getAffectedRows() == 0L) {
            return new HashMap();
        }
        if (this.lastPrimaryKeysData == null) {
            throw new Exception("getLastPrimaryKeys() called before valid insert/replace/update operation has been performed");
        }
        Map submittedPrimaryKeys = DataTools.subsetMap(this.lastPrimaryKeysData, ds.getPrimaryKeys());
        for (String keyName : submittedPrimaryKeys.keySet()) {
            if (submittedPrimaryKeys.get(keyName) != null) continue;
            submittedPrimaryKeys.remove(keyName);
        }
        List sequencesNotPresent = DataTools.setDisjunction(ds.getPrimaryKeys(), DataTools.keysAsList(submittedPrimaryKeys));
        if (sequencesNotPresent.isEmpty()) {
            this.lastPrimaryKeys = submittedPrimaryKeys;
        } else {
            Iterator i = sequencesNotPresent.iterator();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                DSField field = ds.getField(fieldName);
                if (field != null && field.getType().equals("sequence")) continue;
                i.remove();
            }
            this.lastPrimaryKeys = "native".equals(sqlDs.getSequenceModeName()) && "add".equalsIgnoreCase(this.getOperationType()) ? sqlDs.fetchLastPrimaryKeys(submittedPrimaryKeys, sequencesNotPresent, this) : submittedPrimaryKeys;
        }
        log.info("primaryKeys: " + String.valueOf(this.lastPrimaryKeys));
        return this.lastPrimaryKeys;
    }

    public void addToLastPrimaryKeys(DSResponse resp, Map morePKs) throws Exception {
        if (this.lastPrimaryKeys == null) {
            this.lastPrimaryKeys = this.getLastPrimaryKeys(resp);
        }
        this.lastPrimaryKeys.putAll(morePKs);
    }

    public void setLastPrimaryKeysData(Map keys) throws Exception {
        HashMap lastPrimaryKeysData;
        DataSource ds = this.getDataSource();
        if (AdvancedCriteria.isAdvancedCriteria(keys)) {
            HashMap pkData = new HashMap();
            this._extractPrimaryKeysData(pkData, keys, ds.getPrimaryKeys());
            lastPrimaryKeysData = pkData;
        } else {
            lastPrimaryKeysData = DataTools.subsetMap(keys, ds.getPrimaryKeys());
        }
        if (this.lastPrimaryKeysData == null) {
            this.lastPrimaryKeysData = lastPrimaryKeysData;
        } else {
            DataTools.putAllNotPresent(this.lastPrimaryKeysData, lastPrimaryKeysData);
        }
    }

    private void _extractPrimaryKeysData(Map extractedPKData, Map criteria, List pkList) {
        if (criteria != null && pkList != null && extractedPKData != null) {
            String fieldName;
            if (criteria.containsKey("criteria")) {
                for (Object c : (List)criteria.get("criteria")) {
                    this._extractPrimaryKeysData(extractedPKData, (Map)c, pkList);
                }
            } else if (criteria.containsKey("fieldName") && pkList.contains(fieldName = (String)criteria.get("fieldName"))) {
                extractedPKData.put(fieldName, criteria.get("value"));
            }
        }
    }

    public boolean isPartOfTransaction() {
        return Boolean.TRUE.equals(this.partOfTransaction);
    }

    public boolean isPartOfTransactionKnown() {
        return this.partOfTransaction != null;
    }

    public DSRequest addSubRequest(DSRequest req) {
        this.subRequests.add(req);
        return this;
    }

    public List getSubRequests() {
        return this.subRequests;
    }

    public DSRequest cacheDataSourceInstance(String dsName, DataSource ds) {
        if (ds != null && ds.isCacheable()) {
            DataSource existing = this.getCachedDataSourceInstance(dsName);
            if (existing != ds) {
                if (existing != null) {
                    log.debug("Freeing existing cached instance " + ds.getInstanceId() + " of DS " + ds.getName());
                    DataSourceManager.free(existing);
                }
                log.debug("Caching instance " + ds.getInstanceId() + " of DS " + ds.getName());
                this.getCachedDataSourceInstances().put(dsName, ds);
            } else {
                log.debug("Ignoring attempt to cache instance " + ds.getInstanceId() + " of DS " + ds.getName() + " because that exact instance is already cached");
            }
        }
        return this;
    }

    public DSRequest uncacheDataSourceInstance(String dsName) {
        this.getCachedDataSourceInstances().remove(dsName);
        return this;
    }

    public DataSource getCachedDataSourceInstance(String dsName) {
        return this.getCachedDataSourceInstances().get(dsName);
    }

    public Map<String, DataSource> getCachedDataSourceInstances() {
        if (this.getDSCacheManager() != null) {
            return this.getDSCacheManager().getCachedDataSourceInstances();
        }
        return this.cachedDataSources;
    }

    public boolean getExportObjectCalled() {
        return this.exportObjectCalled;
    }

    public void setExportObjectCalled(boolean value) {
        this.exportObjectCalled = value;
    }

    public boolean sendRegularDSResponse() {
        return this.sendRegularDSResponse;
    }

    public void setSendRegularDSResponse(boolean value) {
        this.sendRegularDSResponse = value;
    }

    public DSRequest setPartOfTransaction(boolean newValue) {
        this.partOfTransaction = newValue;
        if (newValue) {
            this.setFreeOnExecute(false);
        }
        return this;
    }

    public boolean getUseStrictJSON() {
        Object strict = this.getParameter("useStrictJSON");
        if (strict == null) {
            return false;
        }
        return (Boolean)strict;
    }

    public String getTextMatchStyle() {
        return (String)this.getOperationProperty("textMatchStyle");
    }

    public DSRequest setTextMatchStyle(String textMatchStyle) {
        if (textMatchStyle == null) {
            log.warn("setTextMatchStyle called with null value.  Abandoning because we do not support setting textMatchStyle to null");
        } else {
            this.setOperationProperty("textMatchStyle", textMatchStyle);
        }
        return this;
    }

    public DSRequest getPrimaryDSRequest() {
        return this.primaryDSRequest;
    }

    public DSRequest setPrimaryDSRequest(DSRequest newValue) {
        this.primaryDSRequest = newValue;
        return this;
    }

    public boolean isCacheSyncRequest() {
        return this.primaryDSRequest != null;
    }

    public boolean isConcatFetchRequest() {
        return Boolean.TRUE.equals(this.getAttribute("_isConcatFetch"));
    }

    public DSRequest markAsConcatFetchRequest() {
        return this.setAttribute("_isConcatFetch", true);
    }

    @Override
    public DSTransaction getDsTransaction() {
        DSTransaction dsTran = super.getDsTransaction();
        if (dsTran == null && this.isCacheSyncRequest()) {
            dsTran = this.primaryDSRequest.getDsTransaction();
        }
        return dsTran;
    }

    public DSRequest(String dataSourceName, String operationType, ValidationContext vc) {
        this();
        this.initFromValidationContext(vc);
        this.operationType = operationType;
        this.setDataSourceName(dataSourceName);
    }

    public DSRequest(String dataSourceName, String operationType) {
        this();
        this.operationType = operationType;
        this.setDataSourceName(dataSourceName);
    }

    public DSRequest(DataSource dataSource, String operationType) {
        this();
        this.operationType = operationType;
        this.setDataSource(dataSource);
    }

    public DSRequest(String dataSourceName, String operationType, RPCManager rpcManager) {
        this();
        this.setRPCManager(rpcManager);
        this.operationType = operationType;
        this.setDataSourceName(dataSourceName);
    }

    public DSRequest(DataSource dataSource, String operationType, RPCManager rpcManager) {
        this();
        this.setRPCManager(rpcManager);
        this.operationType = operationType;
        this.setDataSource(dataSource);
    }

    public DSRequest() {
        this.setRequestData(new HashMap());
        this.setAppID(BUILTIN_APPLICATION);
    }

    public DSRequest(String dataSourceName, String operationType, DSCacheManager dsCacheManager) {
        this();
        this.setDSCacheManager(dsCacheManager);
        this.operationType = operationType;
        this.setDataSourceName(dataSourceName);
    }

    public DSRequest(DataSource dataSource, String operationType, DSCacheManager dsCacheManager) {
        this();
        this.setDSCacheManager(dsCacheManager);
        this.operationType = operationType;
        this.setDataSource(dataSource);
    }

    public static DataTypeMap sandboxContextFromParams(RequestContext requestContext) {
        DataTypeMap<String, String> sandboxContext = new DataTypeMap<String, String>();
        Enumeration e = requestContext.request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!paramName.startsWith("sbx_")) continue;
            String key = paramName.substring("sbx_".length());
            sandboxContext.put(key, requestContext.request.getParameter(paramName));
        }
        return sandboxContext.size() == 0 ? null : sandboxContext;
    }

    public static DataTypeMap sandboxContextFromDsName(String dsName) {
        if (!dsName.contains("_sbx_")) {
            return null;
        }
        DataTypeMap<String, String> sandboxContext = new DataTypeMap<String, String>();
        String[] l = dsName.split("_sbx");
        for (int i = 1; i < l.length; ++i) {
            String s = l[i].substring(1);
            int underscoreIndex = s.indexOf("_");
            String key = s.substring(0, underscoreIndex);
            String value = s.substring(underscoreIndex + 1);
            sandboxContext.put(key, value);
        }
        return sandboxContext;
    }

    private void setRequestData(Map requestData) {
        Object endRow;
        Object startRow;
        Object applyCriteriaBeforeAggregation;
        Object summaryFunctionsParam;
        this.requestData = requestData;
        boolean recordTimings = Boolean.TRUE.equals(this.getParameter("recordTimingData"));
        if (recordTimings) {
            this.setShouldTrackTimings(recordTimings);
        }
        if (this.getRawCriteria() == null) {
            this.setCriteria(new HashMap());
        }
        if (this.getAppID() == null) {
            this.setAppID(BUILTIN_APPLICATION);
        }
        try {
            this.app = this.getApp();
        }
        catch (Exception e) {
            log.error((Object)"Couldn't fetch app definition", e);
        }
        String operation = this.getOperation();
        Map reqOpConfig = (Map)this.getParameter("operationConfig");
        this.operationType = operation;
        HashMap operations = this.app.getOperationsMap();
        if (operations == null) {
            log.error("No operations defined in app '" + this.getAppID() + "' - creating empty config");
            operations = new HashMap();
        }
        Map serverOpConfig = (Map)operations.get(operation);
        Object dataSource = null;
        if (serverOpConfig != null) {
            dataSource = serverOpConfig.get("dataSource");
            if (serverOpConfig.get("type") != null) {
                this.operationType = (String)serverOpConfig.get("type");
            }
            if (dataSource != null) {
                if (dataSource instanceof String) {
                    this.dataSourceName = dataSource;
                } else {
                    List dataSources = dataSource;
                    this.dataSourceName = (String)dataSources.get(0);
                }
            }
        } else if (reqOpConfig != null && reqOpConfig.get("dataSource") != null) {
            this.operationType = (String)reqOpConfig.get("operationType");
            this.dataSourceName = (String)reqOpConfig.get("dataSource");
        } else if (operation != null && operation.indexOf(95) != -1) {
            this.operationType = operation.substring(operation.lastIndexOf(95) + 1);
            this.dataSourceName = operation.substring(0, operation.lastIndexOf(95));
        }
        if (this.dataSourceName != null) {
            this.sandboxContext = DSRequest.sandboxContextFromDsName(this.dataSourceName);
            if (this.sandboxContext != null) {
                this.sandboxDbName = this.sandboxContext.getString("dbName");
                if (this.sandboxDbName == null) {
                    throw new RuntimeException("Sandbox assertion must supply a dbName");
                }
                this.dataSourceName = this.dataSourceName.substring(0, this.dataSourceName.indexOf("_sbx_"));
            }
        }
        if (!this.getAppID().equals(BUILTIN_APPLICATION)) {
            List qualifiedUserTypes = DataTools.makeList("*");
            try {
                DataTools.addAll(qualifiedUserTypes, this.app.userIsOfTypes());
            }
            catch (Exception e) {
                log.error((Object)"Can't look up app users", e);
            }
            for (String userType : qualifiedUserTypes) {
                this.addConstraints(this.app.getConstraintsForUserType(userType, operation));
                this.addOutputs(this.app.getOutputsForUserType(userType, operation));
            }
        }
        this.clientSuppliedCriteria = this.getParameter("criteria");
        if (this.clientSuppliedCriteria != null) {
            this.clientSuppliedCriteria = this.clientSuppliedCriteria instanceof List ? new ArrayList((List)this.clientSuppliedCriteria) : new HashMap((Map)this.clientSuppliedCriteria);
        }
        this.clientSuppliedValues = this.getParameter("values");
        if (this.clientSuppliedValues != null) {
            this.clientSuppliedValues = this.clientSuppliedValues instanceof List ? new ArrayList((List)this.clientSuppliedValues) : new HashMap((Map)this.clientSuppliedValues);
        }
        if (this.outputs() == null) {
            Object outputs = this.getParameter("outputs");
            if (outputs instanceof List) {
                this.setOutputs((List)outputs);
            } else if (outputs instanceof String) {
                this.setOutputs(DataTools.commaSeparatedStringToList((String)outputs));
            }
        }
        HashMap opConfig = new HashMap();
        DataTools.mapMerge(serverOpConfig, opConfig);
        if (reqOpConfig != null) {
            String[] validReqOpConfigProps = new String[]{"dataSource", "repo", "operationType", "textMatchStyle"};
            for (int i = 0; i < validReqOpConfigProps.length; ++i) {
                if (!reqOpConfig.containsKey(validReqOpConfigProps[i])) continue;
                opConfig.put(validReqOpConfigProps[i], reqOpConfig.get(validReqOpConfigProps[i]));
            }
        }
        this.setOperationConfig(opConfig);
        Object sortOrder = this.getParameter("sortBy");
        if (sortOrder == null) {
            sortOrder = opConfig.get("sortBy");
        }
        this.setSortBy(sortOrder);
        Object groupByParam = this.getParameter("groupBy");
        if (groupByParam != null) {
            if (groupByParam instanceof String) {
                this.setGroupBy((String)groupByParam);
            } else if (groupByParam instanceof List) {
                this.setGroupBy((List)groupByParam);
            }
        }
        if ((summaryFunctionsParam = this.getParameter("summaryFunctions")) != null && summaryFunctionsParam instanceof Map) {
            this.setSummaryFunctions(this.convertMapOfStringToMapOfSummaryFunctionType((Map)summaryFunctionsParam));
        }
        if ((applyCriteriaBeforeAggregation = this.getParameter("applyCriteriaBeforeAggregation")) != null) {
            this.setApplyCriteriaBeforeAggregation(Boolean.parseBoolean(applyCriteriaBeforeAggregation.toString()));
        }
        if ((startRow = this.getParameter("startRow")) != null) {
            this.setStartRow(Long.parseLong(startRow.toString()));
        }
        if ((endRow = this.getParameter("endRow")) != null) {
            this.setEndRow(Long.parseLong(endRow.toString()));
        }
        if ((DataSource.isUpdate(this.getOperationType()) || DataSource.isRemove(this.getOperationType())) && !this.getAllowMultiUpdate()) {
            this.setTextMatchStyle("exactCase");
        }
    }

    public Map<String, SummaryFunctionType> convertMapOfStringToMapOfSummaryFunctionType(Map<String, String> incomingMap) {
        HashMap<String, SummaryFunctionType> summaryFunctions = new HashMap<String, SummaryFunctionType>();
        if (incomingMap != null) {
            for (Map.Entry<String, String> entry : incomingMap.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) {
                    log.warn("Encountered an empty or null SummaryFunctionType. Ignoring.");
                    continue;
                }
                try {
                    summaryFunctions.put(entry.getKey(), SummaryFunctionType.valueOf(entry.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Encountered unknown SummaryFunctionType '" + entry.getValue() + "'. Ignoring.");
                }
            }
        }
        return summaryFunctions;
    }

    public DSRequest(Map requestData, RequestContext context, RPCManager rpc) throws Exception {
        this.setRPCManager(rpc);
        this.setContext(context);
        if (rpc.hasTenantId()) {
            requestData.put("tenantId", rpc.getTenantId());
        }
        this.setRequestData(requestData);
        this.recordTimingData("RPCManager construction", TimingLogType.START, rpc.getConstructedTimestamp());
        this.recordTimingData("DSRequest construction", TimingLogType.START);
        if (this.getOperation() == null) {
            throw new Exception("operation not specified");
        }
        this.setClientRequest(true);
        this.parseUploadedFiles();
        this.decodeUploadedStrings();
        this.recordTimingData("DSRequest construction", TimingLogType.END);
    }

    public DSRequest(Map requestData) throws Exception {
        this.setRequestData(requestData);
    }

    @Deprecated
    public RequestContext getRequestContext() {
        return this.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSRequest parseUploadedFiles() throws Exception {
        Map criteria;
        if (this.context.request.isMultipart()) {
            if (this.getValueSets().size() > 1) {
                log.warn("Request including a file upload also specified multiple valueSets.  This is not supported.  The uploaded file will be ignored");
                return this;
            }
            DataSource ds = this.getDataSource();
            ArrayList<ISCFileItem> uploadedFiles = null;
            HashMap<Object, Object> addFields = new HashMap<Object, Object>();
            Map values = this.getValues();
            try {
                int dftMaxSize = config.getInt("DSRequest.maxUploadFileSize", 0);
                for (String fieldName : values.keySet()) {
                    DSField field = ds.getField(fieldName);
                    if (field == null || !field.isBinary()) continue;
                    Object fileFieldValue = values.get(fieldName);
                    String filename = fileFieldValue instanceof String ? (String)fileFieldValue : (fileFieldValue instanceof Map ? (String)((Map)fileFieldValue).get("name") : "");
                    filename = ISCFile.canonicalizePath(filename);
                    String shortFilename = filename;
                    if (shortFilename == null) {
                        shortFilename = "";
                    }
                    if (shortFilename.indexOf("/") != -1) {
                        shortFilename = shortFilename.substring(shortFilename.lastIndexOf("/") + 1);
                    }
                    int maxSize = dftMaxSize;
                    if (field.get("maxFileSize") != null) {
                        maxSize = ((Long)field.get("maxFileSize")).intValue();
                    }
                    ISCFileItem file2 = null;
                    ArrayList<ErrorReport> errors = null;
                    List<ISCFileItem> files = this.context.request.getUploadedFiles(fieldName);
                    if (files != null) {
                        for (ISCFileItem file2 : files) {
                            if (file2.getSize() > (long)maxSize) {
                                errors = new ArrayList<ErrorReport>();
                                ErrorReport errorReport = new ErrorReport();
                                errors.add(errorReport);
                                ErrorMessage errorMessage = new ErrorMessage("Size of '" + file2.getName() + "' (" + DataTools.formatFileSize(file2.getSize()) + ") exceeded maximum allowed file size of " + DataTools.formatFileSize(maxSize));
                                errorReport.addError(fieldName, errorMessage);
                                List<?> prevErrors = file2.getErrors();
                                if (prevErrors != null) {
                                    errors.addAll(0, prevErrors);
                                }
                                file2.setErrors(errors);
                            }
                            if (file2 == null) continue;
                            if (uploadedFiles == null) {
                                uploadedFiles = new ArrayList<ISCFileItem>();
                            }
                            uploadedFiles.add(file2);
                            file2.setFileName(filename);
                            Object filenameField = fieldName + "_filename";
                            Object filesizeField = fieldName + "_filesize";
                            Object dateCreatedField = fieldName + "_date_created";
                            if (ds != null) {
                                filenameField = ds.getFilenameField(fieldName);
                                filesizeField = ds.getFilesizeField(fieldName);
                                dateCreatedField = ds.getDateCreatedField(fieldName);
                            }
                            addFields.put(filenameField, shortFilename);
                            file2.setShortFileName(shortFilename);
                            addFields.put(filesizeField, file2.getSize());
                            addFields.put(dateCreatedField, this.getCurrentDate());
                        }
                        continue;
                    }
                    log.warn("We found a filename in the values for DataSource '" + ds.getName() + "', field '" + fieldName + "', but the expected corresponding binary content in the request body was missing.  Maybe a Filter or a framework like Struts has removed it?");
                }
                this.setUploadedFiles(uploadedFiles);
                this.setValues(DataTools.mapMerge(addFields, values));
            }
            finally {
                DataSourceManager.free(ds);
            }
        }
        if ((criteria = this.getCriteria(false)) != null && criteria.get("download_fieldname") != null) {
            this.setDownloadFieldName((String)criteria.get("download_fieldname"));
            this.setDownloadFileName((String)criteria.get("download_filename"));
        }
        return this;
    }

    protected void decodeUploadedStrings() throws Exception {
        if (this.getDataSource() == null) {
            return;
        }
        for (int k = 0; k < this.getValueSets().size(); ++k) {
            Map values = (Map)this.getValueSets().get(k);
            if (values == null || values.keySet() == null) continue;
            for (String fieldName : values.keySet()) {
                InputStream stream;
                Object value;
                DSField field = this.getDataSource().getField(fieldName);
                if (field == null || (value = values.get(fieldName)) == null || !field.isBinary() || !this.looksLikeBase64(value.toString()) || values.get(this.getDataSource().getFilenameField(fieldName)) != null || (stream = DataTools.base64Decode(value.toString())) == null) continue;
                values.put(fieldName, stream);
            }
        }
    }

    protected boolean looksLikeBase64(String value) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("C:\\fakepath\\")) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' || c <= '9' || c == '+' || c == '/' || c == '=') continue;
            return false;
        }
        return true;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public DSRequest setOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public String getOperationSource() {
        return (String)this.getParameter("operationSource");
    }

    public String getOperation() {
        return (String)this.getParameter("operation");
    }

    public String getOperationId() {
        return this.getOperation();
    }

    public DSRequest setOperationId(String operationId) {
        this.setParameter("operation", operationId);
        return this;
    }

    public String getComponentId() {
        return (String)this.getParameter("componentId");
    }

    public DSRequest setComponentId(String componentId) {
        this.setParameter("componentId", componentId);
        return this;
    }

    public boolean usePreparedStatements() {
        if (this.usePreparedStatements == null) {
            this.usePreparedStatements = config.getBoolean((Object)"sql.usePreparedStatements", false);
            if (this.ds != null) {
                this.usePreparedStatements = DataTools.getBoolean(this.ds.getConfig(), "usePreparedStatements", this.usePreparedStatements);
                DataTypeMap opBinding = this.ds.getOperationBinding(this);
                if (opBinding != null) {
                    this.usePreparedStatements = DataTools.getBoolean((Map)((Object)opBinding), "usePreparedStatements", this.usePreparedStatements);
                }
            }
        }
        return this.usePreparedStatements;
    }

    public String prepareSQLParam(String fieldName, String value) {
        return this.prepareSQLParam(fieldName, value, value);
    }

    public String prepareSQLParam(String fieldName, Object value, String stringValue) {
        DSRequest unionParentRequest = this.getParentRequestForSQLParams();
        if (unionParentRequest != null) {
            return unionParentRequest.prepareSQLParam(fieldName, value, stringValue);
        }
        if (this.usePreparedStatements()) {
            Object key = fieldName;
            if (this.sqlParams == null) {
                this.sqlParams = new HashMap();
            }
            if (this.sqlParams.containsKey(key) && !DataTools.equals(this.sqlParams.get(key), value)) {
                if (this.sqlParamsCounter == null) {
                    this.sqlParamsCounter = new HashMap<String, Integer>();
                }
                int counter = (this.sqlParamsCounter.containsKey(key) ? this.sqlParamsCounter.get(key) : 0) + 1;
                this.sqlParamsCounter.put((String)key, counter);
                key = (String)key + "_" + counter;
            }
            this.sqlParams.put(key, value);
            return SQL_PARAM_PREFIX + (String)key + SQL_PARAM_SUFFIX;
        }
        return stringValue;
    }

    public Map getSQLParams() {
        return this.sqlParams;
    }

    public DSRequest getParentRequestForSQLParams() {
        boolean unionMode = Boolean.TRUE.equals(this.getAttribute("unionMode"));
        DSRequest unionParentRequest = (DSRequest)this.getAttribute("unionParentRequest");
        if (unionMode && unionParentRequest != null) {
            DSRequest req = unionParentRequest.getParentRequestForSQLParams();
            return req != null ? req : unionParentRequest;
        }
        return null;
    }

    public String prepareSQLStmt(String sql) {
        int close;
        DSRequest unionParentRequest = this.getParentRequestForSQLParams();
        if (unionParentRequest != null) {
            return unionParentRequest.prepareSQLStmt((String)sql);
        }
        if (!this.usePreparedStatements() || sql == null) {
            return sql;
        }
        int start = 0;
        int varIndex = ((String)sql).indexOf(SQL_PARAM_PREFIX);
        int prefixLength = SQL_PARAM_PREFIX.length();
        int suffixLength = SQL_PARAM_SUFFIX.length();
        if (varIndex < 0) {
            return sql;
        }
        if (this.preparedSQLParams == null || !this.preparedSQLParams.isEmpty()) {
            this.preparedSQLParams = new LinkedList();
        }
        while (varIndex >= 0 && (close = ((String)sql).indexOf(SQL_PARAM_SUFFIX, varIndex + prefixLength)) >= 0) {
            String var = ((String)sql).substring(varIndex + prefixLength, close).trim();
            this.preparedSQLParams.add(this.sqlParams.get(var));
            sql = ((String)sql).substring(0, varIndex) + "?" + ((String)sql).substring(varIndex + var.length() + prefixLength + suffixLength);
            start = varIndex + suffixLength;
            varIndex = ((String)sql).indexOf(SQL_PARAM_PREFIX, start);
        }
        return sql;
    }

    public void clearPreparedSQLParams() {
        if (this.preparedSQLParams != null) {
            this.preparedSQLParams.clear();
        }
    }

    public LinkedList getPreparedSQLParams() {
        return this.preparedSQLParams;
    }

    public Map getCriteria() {
        return this.getCriteria(true);
    }

    public Map getCriteria(boolean returnValuesForAdd) {
        return this.getCriteria(returnValuesForAdd, this.getRawCriteria());
    }

    public Map getCriteria(boolean returnValuesForAdd, Object criteria) {
        if (returnValuesForAdd && DataSource.isAdd(this.getOperationType())) {
            return this.getValues();
        }
        if (criteria instanceof List) {
            List l = (List)criteria;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getCriteria() called on dsRequest containing multiple where clauses, returning first in list.");
            return (Map)l.get(0);
        }
        if (criteria instanceof Map) {
            return (Map)criteria;
        }
        return new HashMap();
    }

    public AdvancedCriteria getAdvancedCriteria() {
        return this.getAdvancedCriteria(this.getRawCriteria());
    }

    public AdvancedCriteria getAdvancedCriteria(Object criteria) {
        String textMatchStyle = this.getTextMatchStyle();
        String operator = DefaultOperators.IEquals.getID();
        if (textMatchStyle != null) {
            if (textMatchStyle.equals("startsWith")) {
                operator = DefaultOperators.IStartsWith.getID();
            } else if (textMatchStyle.equals("substring")) {
                operator = DefaultOperators.IContains.getID();
            } else if (textMatchStyle.equals("exactCase")) {
                operator = DefaultOperators.Equals.getID();
            }
        }
        return AdvancedCriteria.fromCollections(criteria, operator, this);
    }

    public boolean getIsAdvancedCriteria() {
        Object criteria = this.getRawCriteria();
        return this.getIsAdvancedCriteria(criteria);
    }

    public boolean getIsAdvancedCriteria(Object criteria) {
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        DataSource ds = null;
        try {
            ds = this.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l != null) {
            if (l.size() == 1) {
                Map critData = (Map)l.get(0);
                return AdvancedCriteria.isAdvancedCriteria(critData, ds);
            }
            return false;
        }
        if (criteria instanceof Map) {
            Map critData = (Map)criteria;
            return AdvancedCriteria.isAdvancedCriteria(critData, ds);
        }
        return false;
    }

    public DSRequest setAdvancedCriteria(AdvancedCriteria advancedCriteria) {
        this.requestData.put("criteria", advancedCriteria.getCriteriaAsMap());
        this.rebuildFieldDataIfNeeded();
        return this;
    }

    public Map getClientSuppliedCriteria() {
        if (DataSource.isAdd(this.getOperationType())) {
            return this.getValues();
        }
        Object criteria = this.clientSuppliedCriteria;
        if (criteria instanceof List) {
            List l = (List)criteria;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getClientSuppliedCriteria() called on dsRequest containing multiple where clauses, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)criteria;
    }

    public List getCriteriaSets() {
        return DataTools.makeListIfSingle(this.getRawCriteria());
    }

    public DSRequest setCriteria(Object criteria) {
        if (criteria instanceof AdvancedCriteria) {
            this.setAdvancedCriteria((AdvancedCriteria)criteria);
        } else {
            this.requestData.put("criteria", criteria);
            this.rebuildFieldDataIfNeeded();
        }
        return this;
    }

    public DSRequest setCriteria(String fieldName, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(fieldName, value);
        this.requestData.put("criteria", map);
        this.rebuildFieldDataIfNeeded();
        return this;
    }

    public Object getRawCriteria() {
        return this.requestData.get("criteria");
    }

    public void setRawCriteria(Object rawCriteria) {
        this.requestData.put("criteria", rawCriteria);
    }

    public DSRequest normalizeCriteria() throws Exception {
        if (!this.criteriaIsNormalized) {
            this.applySubqueryShortcuts(this.getCriteria());
            HashMap _subQuerySeparation = new HashMap();
            this.extractCriteriaSubqueries(this.getCriteria(), _subQuerySeparation);
            this.setParameter("_subQuerySeparation", _subQuerySeparation);
            Map criteria = this.getCriteria(false);
            DataSource ds = this.getDataSource();
            if (ds != null && ds.isAdvancedCriteria(criteria)) {
                this.setCriteria(ds.normalizeAdvancedCriteria(criteria));
            }
            if (ds != null) {
                if (DataSource.isFetch(this.getOperationType()) && ds.shouldApplyManualAggregation()) {
                    Object rawCriteria = this.getRawCriteria();
                    this.setAttribute(POST_AGGREGATION_CRITERIA_ATTRIBUTE_NAME, this.getPostAggregationCriteria(this.getCriteria()));
                    this.setCriteria(this.getPreAggregationCriteria(this.getCriteria()));
                }
            }
            this.criteriaIsNormalized = true;
        }
        return this;
    }

    private List<String> getPreOrPostAggregationCriteriaFields(Map criteria, boolean pre) throws Exception {
        ArrayList<String> aggregatedFields;
        if (criteria == null) {
            return null;
        }
        ArrayList criteriaFields = this.getDataSource().isAdvancedCriteria(criteria) ? this.ds.extractFieldNamesFromAdvancedCriteria(criteria) : new ArrayList(this.getCriteria().keySet());
        Map<String, SummaryFunctionType> functions = this.getSummaryFunctions();
        ArrayList<String> arrayList = aggregatedFields = functions != null ? new ArrayList<String>(functions.keySet()) : null;
        if (!pre) {
            return aggregatedFields;
        }
        return DataTools.setDisjunction(criteriaFields, aggregatedFields);
    }

    public Object getPreAggregationCriteria(Map criteria) throws Exception {
        return this.filterCriteria(criteria, this.getPreOrPostAggregationCriteriaFields(criteria, true));
    }

    public Object getPostAggregationCriteria(Map criteria) throws Exception {
        return this.filterCriteria(criteria, this.getPreOrPostAggregationCriteriaFields(criteria, false));
    }

    private Object filterCriteria(Object raw, List<String> fieldsToKeep) {
        boolean isAdvanced = this.getIsAdvancedCriteria();
        if (fieldsToKeep == null || fieldsToKeep.isEmpty()) {
            return new HashMap();
        }
        if (raw instanceof Map) {
            Map<String, String> newMap = new HashMap();
            if (isAdvanced) {
                newMap = this._filterCriteria((Map)raw, fieldsToKeep);
                if (newMap != null && "AdvancedCriteria".equals(((Map)raw).get("_constructor"))) {
                    newMap.put("_constructor", "AdvancedCriteria");
                }
                return newMap;
            }
            for (String fieldName : ((Map)raw).keySet()) {
                if (!fieldsToKeep.contains(fieldName)) continue;
                newMap.put(fieldName, (String)((Map)raw).get(fieldName));
            }
            return newMap;
        }
        if (raw instanceof List) {
            ArrayList<Object> newCriteria = new ArrayList<Object>();
            Iterator i = ((List)raw).iterator();
            while (i.hasNext()) {
                newCriteria.add(this.filterCriteria(i.next(), fieldsToKeep));
            }
            return newCriteria;
        }
        return raw;
    }

    private Map _filterCriteria(Map criteria, List<String> fieldsToKeep) {
        if (criteria == null) {
            return null;
        }
        if (criteria.containsKey("criteria")) {
            HashMap newMap = new HashMap(criteria);
            ArrayList newCrit = new ArrayList();
            for (Object c : (List)criteria.get("criteria")) {
                if ((c = this._filterCriteria((Map)c, fieldsToKeep)) == null) continue;
                newCrit.add(c);
            }
            newMap.put("criteria", newCrit);
            return newMap;
        }
        if (criteria.containsKey("fieldName")) {
            String fieldName = (String)criteria.get("fieldName");
            return fieldsToKeep.contains(fieldName) ? criteria : null;
        }
        return null;
    }

    private void applySubqueryShortcuts(Map criteria) throws Exception {
        if (!AdvancedCriteria.isAdvancedCriteria(criteria)) {
            return;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList subCrit;
            Object subCritObj = criteria.get("criteria");
            if (subCritObj instanceof List) {
                subCrit = (ArrayList)subCritObj;
            } else if (subCritObj instanceof Map) {
                subCrit = new ArrayList();
                subCrit.add(subCritObj);
            } else {
                throw new Exception("While trying to preprocess subquery shortcuts, encountered a property named 'criteria' that is neither a List nor a Map.  Unable to proceed");
            }
            for (int i = 0; i < subCrit.size(); ++i) {
                this.applySubqueryShortcuts((Map)subCrit.get(i));
            }
        } else {
            String fieldName = (String)criteria.get("fieldName");
            if (fieldName != null && fieldName.indexOf(46) != -1) {
                String[] elements = fieldName.split("\\!");
                if (elements.length > 1) {
                    fieldName = elements[1];
                }
                elements = fieldName.split("\\.");
                HashMap<String, String> fieldQuery = new HashMap<String, String>();
                fieldQuery.put("dataSource", elements[0]);
                fieldQuery.put("queryOutput", elements[1]);
                criteria.put("fieldQuery", fieldQuery);
                criteria.remove("fieldName");
                log.debug("Replaced shortcut reference '" + fieldName + "' with the corresponding fieldQuery");
            }
        }
    }

    private void extractCriteriaSubqueries(Map criteria, Map subQuerySeparation) throws Exception {
        if (!AdvancedCriteria.isAdvancedCriteria(criteria)) {
            return;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList subCrit;
            Object subCritObj = criteria.get("criteria");
            if (subCritObj instanceof List) {
                subCrit = (ArrayList)subCritObj;
            } else if (subCritObj instanceof Map) {
                subCrit = new ArrayList();
                subCrit.add(subCritObj);
            } else {
                throw new Exception("While trying to extract criteria subqueries, encountered a property named 'criteria' that is neither a List nor a Map.  Unable to proceed");
            }
            ArrayList subQuerySepList = new ArrayList();
            subQuerySeparation.put("criteria", subQuerySepList);
            for (int i = 0; i < subCrit.size(); ++i) {
                HashMap subQuerySepMap = new HashMap();
                subQuerySepList.add(subQuerySepMap);
                this.extractCriteriaSubqueries((Map)subCrit.get(i), subQuerySepMap);
            }
        } else {
            Map subquery;
            boolean isSubQuery = false;
            Map fieldQueryResults = null;
            Map valueQueryResults = null;
            Object fieldStaticValue = null;
            if (criteria.containsKey("fieldName")) {
                if (criteria.containsKey("fieldQuery")) {
                    log.warn("Criterion specifies both 'fieldName' and 'fieldQuery'.  These properties are mutually exclusive: dropping 'fieldQuery'");
                    criteria.remove("fieldQuery");
                }
                if (criteria.containsKey("fieldStaticValue")) {
                    log.warn("Criterion specifies both 'fieldName' and 'fieldStaticValue'.  These properties are mutually exclusive: dropping 'fieldStaticValue'");
                    criteria.remove("fieldStaticValue");
                }
            } else if (criteria.containsKey("fieldQuery")) {
                if (criteria.containsKey("fieldStaticValue")) {
                    log.warn("Criterion specifies both 'fieldQuery' and 'fieldStaticValue'.  These properties are mutually exclusive: dropping 'fieldStaticValue'");
                    criteria.remove("fieldStaticValue");
                }
                if ((subquery = (Map)criteria.get("fieldQuery")) != null) {
                    fieldQueryResults = this.extractCriteriaSubquery(subquery, true, subQuerySeparation);
                    isSubQuery = fieldQueryResults != null;
                    subQuerySeparation.put("fieldQuery", fieldQueryResults != null);
                }
            } else if (criteria.containsKey("fieldStaticValue")) {
                if (!"inSet".equals(criteria.get("operator")) && !"notInSet".equals(criteria.get("operator"))) {
                    log.warn("Criterion specifies a 'fieldStaticValue' but the criterion operator is " + String.valueOf(criteria.get("operator")) + ".  fieldStaticValue only makes sense for the inSet and notInSet operators");
                    return;
                }
                fieldStaticValue = criteria.get("fieldStaticValue");
            } else {
                log.warn("Criterion does not specify 'fieldName', 'fieldQuery' or 'fieldStaticValue' - one (and only one) of those properties is required");
                return;
            }
            if (criteria.containsKey("value")) {
                if (criteria.containsKey("valueQuery")) {
                    log.warn("Criterion specifies both 'value' and 'valueQuery'.  These properties are mutually exclusive: dropping 'valueQuery'");
                    criteria.remove("valueQuery");
                }
            } else {
                subquery = (Map)criteria.get("valueQuery");
                if (subquery != null) {
                    valueQueryResults = this.extractCriteriaSubquery(subquery, false, subQuerySeparation);
                    if (!isSubQuery) {
                        isSubQuery = valueQueryResults != null;
                    }
                    subQuerySeparation.put("valueQuery", valueQueryResults != null);
                }
            }
            if (!isSubQuery) {
                return;
            }
            if (fieldQueryResults != null && valueQueryResults == null && criteria.get("valueQuery") != null || valueQueryResults != null && fieldQueryResults == null && criteria.get("fieldQuery") != null) {
                Map subquery2;
                String msg = "We encountered an AdvancedCriteria with both a 'fieldQuery' and a 'valueQuery'.  The " + (valueQueryResults == null ? "field" : "value") + "Query was separated from the outer query (scan the client docs for 'fieldQuery' for the rules around this) but the " + (valueQueryResults == null ? "value" : "field") + "Query was not.  We can only process both subqueries in SQL, or both as separated subqueries - combining the two in a single criterion is not supported.  ";
                Map map = subquery2 = fieldQueryResults == null ? (Map)criteria.get("fieldQuery") : (Map)criteria.get("valueQuery");
                if (Boolean.TRUE.equals(subquery2.get("canEmbedSQL"))) {
                    msg = msg + "The " + (valueQueryResults == null ? "value" : "field") + "Query is explicitly marked 'canEmbedSQL:true' so we are not going to try separating it.  Cannot continue with subquery processing";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                msg = msg + "So we are going to mark the " + (valueQueryResults == null ? "value" : "field") + "Query for separation and try again";
                log.warn(msg);
                subquery2.put("canEmbedSQL", false);
                Map results = this.extractCriteriaSubquery(subquery2, false, subQuerySeparation);
                if (results == null) {
                    msg = "Attempt to manually separate a '" + (valueQueryResults == null ? "value" : "field") + "Query' so it is in line with a previously separated '" + (valueQueryResults == null ? "field" : "value") + "Query' did not succeed - the " + (valueQueryResults == null ? "value" : "field") + "Query is still embedded, or returned a null response.  Cannot continue with subquery processing";
                    log.warn(msg);
                    throw new Exception(msg);
                }
                if (valueQueryResults == null) {
                    valueQueryResults = results;
                    subQuerySeparation.put("valueQuery", true);
                } else {
                    fieldQueryResults = results;
                    subQuerySeparation.put("fieldQuery", true);
                }
            }
            boolean isMultiRVal = false;
            boolean isSetRVal = false;
            List rvals = null;
            Object rval = null;
            String rvalOutputField = null;
            if (valueQueryResults != null) {
                rvals = (List)valueQueryResults.get("records");
                rvalOutputField = (String)valueQueryResults.get("subqueryOutputField");
                if (rvalOutputField == null) {
                    rval = this.getRVal(rvals, null, null, null);
                } else {
                    Operator operator = DefaultOperators.getDefaultOperatorMap().get(criteria.get("operator"));
                    if ("inSet".equals(operator) || "notInSet".equals(operator)) {
                        isSetRVal = true;
                        ArrayList set = new ArrayList();
                        for (int i = 0; i < rvals.size(); ++i) {
                            set.add(((Map)rvals.get(i)).get(rvalOutputField));
                        }
                        rval = set;
                    } else {
                        boolean bl = isMultiRVal = rvals.size() > 1;
                        if (!isMultiRVal) {
                            rval = this.getRVal(rvals, null, rvalOutputField, rvalOutputField);
                        }
                    }
                }
            } else {
                rval = criteria.get("value");
            }
            if (fieldQueryResults != null) {
                String rvalIdField;
                HashSet set = new HashSet();
                List records = (List)fieldQueryResults.get("records");
                String subqueryOutputField = (String)fieldQueryResults.get("subqueryOutputField");
                String comparisonField = (String)fieldQueryResults.get("fromFieldName");
                String string = rvalIdField = valueQueryResults == null ? null : (String)valueQueryResults.get("fromFieldName");
                if (isMultiRVal && records != null && records.size() != 0 && records.size() != rvals.size()) {
                    Object comparisonValue = ((Map)records.get(0)).get(comparisonField);
                    Object emptyValue = comparisonValue instanceof Number ? new Integer(0) : (comparisonValue instanceof Date ? new Date(0L) : "");
                    for (int i = 0; i < rvals.size(); ++i) {
                        Map record = DataTools.find(records, comparisonField, ((Map)rvals.get(i)).get(rvalIdField));
                        if (record != null) continue;
                        HashMap<String, Object> newRec = new HashMap<String, Object>();
                        newRec.put(comparisonField, ((Map)rvals.get(i)).get(rvalIdField));
                        newRec.put(subqueryOutputField, emptyValue);
                        records.add(newRec);
                    }
                }
                if (subqueryOutputField == null) {
                    log.warn("No 'subqueryOutputField' was returned by separated subquery processing, cannot continue");
                } else {
                    HashMap<String, Object> dynamicCrit = new HashMap<String, Object>(criteria);
                    dynamicCrit.put("fieldName", subqueryOutputField);
                    dynamicCrit.put("value", rval);
                    dynamicCrit.remove("fieldQuery");
                    dynamicCrit.remove("valueQuery");
                    log.debug("fieldQuery retrieved " + records.size() + " records.  We will now filter them with the criterion: " + String.valueOf(dynamicCrit) + (isMultiRVal ? " (there are multiple values in this criterion; they will be set each tmie through the filtering loop)" : ""));
                    Criterion c = Evaluator.parseCriterion(dynamicCrit);
                    Evaluator e = new Evaluator(c, null);
                    for (int i = 0; i < records.size(); ++i) {
                        Map record = (Map)records.get(i);
                        if (isMultiRVal) {
                            rval = this.getRVal(rvals, record.get(comparisonField), rvalIdField, rvalOutputField);
                            dynamicCrit.put("value", rval);
                            c = Evaluator.parseCriterion(dynamicCrit);
                            if (c == null) continue;
                            e = new Evaluator(c, null);
                        }
                        if (e.valuesMatchCriteria(record)) {
                            set.add(record.get(comparisonField));
                            log.debug("Row with id " + String.valueOf(record.get(comparisonField)) + " matches the criteria because its value for " + subqueryOutputField + " was " + String.valueOf(record.get(subqueryOutputField)));
                            continue;
                        }
                        log.debug("Excluded row with id " + String.valueOf(record.get(comparisonField)) + " because its value for " + subqueryOutputField + " was " + String.valueOf(record.get(subqueryOutputField)) + ", which fails to match the criteria");
                    }
                    log.debug("Post-filter, there are " + set.size() + " records in the fieldQuery results");
                    criteria.put("fieldName", fieldQueryResults.get("toFieldName"));
                    criteria.put("operator", "inSet");
                    criteria.put("value", set);
                }
            } else if (isMultiRVal) {
                criteria.put("value", this.getMultiRValSet(rvals, rvalOutputField));
            } else {
                criteria.put("value", rval);
            }
            criteria.remove("fieldQuery");
            criteria.remove("valueQuery");
        }
    }

    private Object getRVal(List<Map> rvals, Object idValue, String rvalIdField, String rvalSummaryFunctionField) throws Exception {
        Object candidateValue;
        if (rvals == null || rvals.size() == 0) {
            log.warn("Null or empty rvals collection, returning null");
            return null;
        }
        Number rtnValue = null;
        int end = rvals.size();
        if (idValue == null) {
            end = 1;
        }
        for (int i = 0; i < end; ++i) {
            if (idValue != null && !idValue.equals(rvals.get(i).get(rvalIdField))) continue;
            if (rvalSummaryFunctionField != null) {
                rtnValue = (Number)rvals.get(i).get(rvalSummaryFunctionField);
                continue;
            }
            String fieldName = this.getDataSource().getDefaultSubqueryOutputFieldName();
            rtnValue = (Number)rvals.get(i).get(fieldName);
        }
        if (rtnValue == null && rvals != null && rvals.size() > 0 && (candidateValue = rvals.get(0).get(rvalSummaryFunctionField)) != null && candidateValue instanceof Number) {
            if (candidateValue instanceof AtomicInteger) {
                rtnValue = new AtomicInteger(0);
            } else if (candidateValue instanceof AtomicLong) {
                rtnValue = new AtomicLong(0L);
            } else {
                try {
                    Constructor<?> c = candidateValue.getClass().getConstructor(String.class);
                    if (c != null) {
                        rtnValue = c.newInstance("0");
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Caught Exception trying to create an instance of " + String.valueOf(candidateValue.getClass())), e);
                }
            }
        }
        log.info("Returning " + String.valueOf(rtnValue) + " for field " + rvalIdField + " with id " + String.valueOf(idValue));
        return rtnValue;
    }

    private Set getMultiRValSet(List<Map> rvals, String rvalIdField) {
        HashSet rtnValue = new HashSet();
        for (int i = 0; i < rvals.size(); ++i) {
            rtnValue.add(rvals.get(i).get(rvalIdField));
        }
        return rtnValue;
    }

    private Map extractCriteriaSubquery(Map subquery, boolean isFieldQuery, Map subQuerySeparation) throws Exception {
        DSRequestDoNotSerialize subReq;
        boolean globalAllowed = config.getBoolean((Object)"allowCriteriaSubqueries", true);
        Boolean dsAllowed = this.getDataSource().getConfig().getBoolean("allowCriteriaSubqueries");
        boolean subqueriesAllowed = dsAllowed != null ? dsAllowed : globalAllowed;
        if (!subqueriesAllowed) {
            throw new Exception("Encountered a " + (isFieldQuery ? "field" : "value") + "Query definition in an AdvancedCriteria, but this feature is disallowed " + (String)(Boolean.FALSE.equals(dsAllowed) ? "for DataSource " + this.getDataSourceName() : "globally"));
        }
        String dataSourceName = (String)subquery.get("dataSource");
        if (dataSourceName == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query does not specify a dataSource");
        }
        BasicDataSource ds = (BasicDataSource)DataSourceManager.get(dataSourceName);
        if (ds == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query specifies dataSource '" + dataSourceName + "', which is not known");
        }
        BasicDataSource thisDS = (BasicDataSource)this.ds;
        if (!this.isClientRequest() && this.allowArbitrarySubqueries()) {
            log.info("Server-initiated DSRequest allows arbitrary subqueries: creating a sub-DSRequest with every property specified in the subquery config");
            subReq = new DSRequestDoNotSerialize(subquery);
        } else {
            log.info("Client-initiated DSRequest, or does not allows arbitrary subqueries: creating a sub-DSRequest with just the properties allowed for restricted subqueries");
            subReq = new DSRequestDoNotSerialize(dataSourceName, "fetch", this.getRPCManager());
            if (subquery.containsKey("criteria")) {
                subReq.setCriteria(subquery.get("criteria"));
            }
            if (subquery.containsKey("operationId")) {
                subReq.setOperationId((String)subquery.get("operationId"));
            }
            if (subquery.containsKey("queryFK")) {
                subReq.setParameter("queryFK", subquery.get("queryFK"));
            }
            if (subquery.containsKey("queryOutput")) {
                subReq.setQueryOutput(subquery.get("queryOutput").toString());
            }
        }
        if (subquery.containsKey("summaryFunctions")) {
            Map sf = (Map)subquery.get("summaryFunctions");
            HashMap<String, SummaryFunctionType> sfConverted = new HashMap<String, SummaryFunctionType>();
            int c = 0;
            Iterator iter = sf.keySet().iterator();
            while (iter.hasNext()) {
                if (c++ > 0) {
                    log.warn((isFieldQuery ? "field" : "value") + "Query specifies multiple summaryFunctions, which is not supported (and does not make sense).  Discarding all but the first");
                    break;
                }
                String key = (String)iter.next();
                if (ds.getField(key) == null) {
                    log.warn("A " + (isFieldQuery ? "field" : "value") + "Query on dataSource '" + dataSourceName + "' specifies a summaryFunction on field '" + key + "' but the dataSource does not have a field of that name.  Expect incorrect results.");
                }
                sfConverted.put(key, SummaryFunctionType.valueOf(((String)sf.get(key)).toUpperCase()));
            }
            subReq.setSummaryFunctions(sfConverted);
        }
        if (subquery.containsKey("groupBy")) {
            Object groupByObj = subquery.get("groupBy");
            ArrayList<String> groupBy = null;
            if (!(groupByObj instanceof List)) {
                groupBy = new ArrayList<String>();
                groupBy.add((String)groupByObj);
            } else {
                groupBy = (ArrayList<String>)groupByObj;
            }
            subReq.setGroupBy(groupBy);
        }
        subReq.setWarnIfFieldLevelSecurityFails(true);
        subReq.isSubquery = true;
        this.subRequests.add(subReq);
        if (thisDS.shouldSeparateSubquery(subquery, ds, this)) {
            subReq.extractCriteriaSubqueries(subReq.getCriteria(), subQuerySeparation);
            Map value = this.processCriteriaSubquery(subReq, false);
            return value;
        }
        subReq.extractCriteriaSubqueries(subReq.getCriteria(), subQuerySeparation);
        this.processCriteriaSubquery(subReq, true);
        subquery.put("_validatedDSRequest", subReq);
        return null;
    }

    private Map processCriteriaSubquery(DSRequest subquery, boolean validateOnly) throws Exception {
        boolean joinToParentDS;
        if (!subquery.isSubquery) {
            return null;
        }
        ArrayList mappedFieldNames = null;
        if (this.consolidatedOutputs != null) {
            mappedFieldNames = new ArrayList(this.consolidatedOutputs);
            this.mapRawOutputFieldNames(mappedFieldNames);
        }
        DataSource thisDs = this.getDataSource();
        DataSource subDs = subquery.getDataSource();
        if (!subDs.allowAdvancedCriteria()) {
            String msg = "DataSource '" + subDs.getID() + "' specified on a 'fieldQuery' or 'valueQuery' criteria element, but that dataSource does not support AdvancedCriteria, which is a requirement of subquery criteria elements.  Cannot continue";
            log.warn(msg);
            throw new Exception(msg);
        }
        Object ac = null;
        String fromFieldName = null;
        String toFieldName = null;
        String outputFieldName = subDs.getDefaultSubqueryOutputFieldName(subquery);
        String fk = (String)subquery.getParameter("queryFK");
        boolean bl = joinToParentDS = !"*none*".equals(fk);
        if (joinToParentDS) {
            Relation relation = subDs.getRelation(new DataSource[]{thisDs}, null, fk, true, this);
            if (relation == null) {
                String msg = "DataSource '" + subDs.getID() + "' specified on a 'fieldQuery' or 'valueQuery' criteria element, but that dataSource is not related to the parent DataSource '" + thisDs.getID() + "'" + (String)(fk == null ? "" : " via the named FK field '" + fk + "'") + ". Cannot continue";
                log.warn(msg);
                throw new Exception(msg);
            }
            if (!validateOnly && relation.getNextRelation() != null) {
                String msg = "We detected that an indrect relation is required to resolve a subquery, and that subquery will be processed separately from the main query.  The subquery feature cannot currently handle indirect relations in separated subqueries; you should make the subquery embeddable, and then mark it 'canEmbedSQL:true'.  Search the client-side docs for 'canEmbedSQL' for more details";
                log.warn(msg);
                throw new Exception(msg);
            }
            List<DSField> from = relation.getFromFields();
            List<DSField> to = relation.getToFields();
            if (from.size() > 1) {
                String msg = "Currently, the AdvancedCriteria Subquery feature does not support composite keys, so cannot use the relation from '" + subDs.getID() + "' to '" + thisDs.getID() + "' via foreignKeys: " + String.valueOf(from);
                log.warn(msg);
                throw new Exception(msg);
            }
            fromFieldName = from.get(0).getName();
            toFieldName = to.get(0).getName();
            ArrayList<String> fromFieldList = new ArrayList<String>();
            fromFieldList.add(fromFieldName);
            Map<String, SummaryFunctionType> sf = subquery.getSummaryFunctions();
            List<String> gb = subquery.getGroupBy();
            if (sf != null && !sf.keySet().isEmpty()) {
                if ((gb == null || gb.isEmpty()) && !validateOnly) {
                    subquery.setGroupBy(fromFieldList);
                }
                fromFieldList.addAll(subquery.getSummaryFunctions().keySet());
                outputFieldName = subquery.getSummaryFunctions().keySet().iterator().next();
            } else if (gb != null && !gb.isEmpty()) {
                outputFieldName = gb.get(0);
            }
            if (subquery.getQueryOutput() != null) {
                fromFieldList.add(subquery.getQueryOutput());
                outputFieldName = subquery.getQueryOutput();
            }
            if (!fromFieldList.contains(outputFieldName)) {
                fromFieldList.add(outputFieldName);
            }
            subquery.setOutputs(fromFieldList);
            subquery.setClientRequest(true);
        } else {
            Map<String, SummaryFunctionType> sf = subquery.getSummaryFunctions();
            List<String> gb = subquery.getGroupBy();
            if (sf != null && !sf.keySet().isEmpty()) {
                outputFieldName = sf.keySet().iterator().next();
            } else if (gb != null && !gb.isEmpty()) {
                outputFieldName = gb.get(0);
            }
            if (subquery.getQueryOutput() != null) {
                outputFieldName = subquery.getQueryOutput();
            }
        }
        if (validateOnly) {
            if (!subquery.passesSecurityChecks()) {
                throw new SecurityException("A validate-only sub-request did not pass security checks.  DataSource: " + subDs.getID() + ", fields: " + String.valueOf(subquery.getOutputs()) + "  Security failure message: " + subquery.securityFailureMessage);
            }
        } else {
            DSResponse resp = subquery.execute();
            List<Map> records = resp.getRecords();
            if (records != null && subquery.getSummaryFunctions() != null) {
                records = this.coerceAggregatedValueTypes(records, subquery.getSummaryFunctions());
            }
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("fromFieldName", fromFieldName);
            value.put("toFieldName", toFieldName);
            value.put("records", records);
            value.put("subqueryOutputField", outputFieldName);
            return value;
        }
        return null;
    }

    private List<Map> coerceAggregatedValueTypes(List<Map> in, Map<String, SummaryFunctionType> summaryFunctions) {
        ArrayList<Map> out = new ArrayList<Map>();
        for (int i = 0; i < in.size(); ++i) {
            HashMap<String, Integer> record = new HashMap<String, Integer>(in.get(i));
            for (String fieldName : summaryFunctions.keySet()) {
                String sftName;
                SummaryFunctionType sft = summaryFunctions.get(fieldName);
                switch (sftName = sft.toString()) {
                    case "COUNT": {
                        record.put(fieldName, Integer.parseInt(record.get(fieldName).toString()));
                    }
                }
            }
            out.add(record);
        }
        return out;
    }

    public boolean criteriaHasPKs(Map criteria, List<String> primaryKeys, boolean forceSingle) {
        return this.criteriaHasPKs(criteria, primaryKeys, forceSingle, null);
    }

    public boolean criteriaHasPKs(Map criteria, List<String> primaryKeys, boolean forceSingle, List<String> passedKeys) {
        if (!AdvancedCriteria.isAdvancedCriteria(criteria)) {
            List keysMissing;
            List<String> keysPresent = DataTools.setIntersection(primaryKeys, new ArrayList(criteria.keySet()));
            if (passedKeys != null) {
                passedKeys.addAll(keysPresent);
            }
            if ((keysMissing = DataTools.setDisjunction(primaryKeys, keysPresent)).isEmpty()) {
                for (String key : keysPresent) {
                    if (!(criteria.get(key) instanceof List) || !forceSingle || ((List)criteria.get(key)).size() <= 1 || config.getBoolean((Object)"allowMultiPKUpdates", false)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (passedKeys == null) {
            passedKeys = new ArrayList<String>();
        }
        if (DefaultOperators.And.getID().equals(criteria.get("operator"))) {
            boolean oneIsSpecific = false;
            Object criteriaObj = criteria.get("criteria");
            if (criteriaObj == null || !(criteriaObj instanceof List) || ((List)criteriaObj).size() == 0 || !(((List)criteriaObj).get(0) instanceof Map)) {
                log.warn("In criteriaHasPKs, found an AND clause which has invalid 'criteria': it is either missing entirely, null, empty or not a List of Maps");
                return false;
            }
            for (Map criteriaMap : (List)criteria.get("criteria")) {
                if (!this.criteriaHasPKs(criteriaMap, primaryKeys, forceSingle, passedKeys)) continue;
                oneIsSpecific = true;
                if (primaryKeys.size() != 1) continue;
                return true;
            }
            if (oneIsSpecific) {
                List<String> keysPresent = DataTools.setIntersection(primaryKeys, passedKeys);
                List keysMissing = DataTools.setDisjunction(primaryKeys, keysPresent);
                return keysMissing.isEmpty();
            }
            return false;
        }
        if (DefaultOperators.Or.getID().equals(criteria.get("operator"))) {
            Object criteriaObj = criteria.get("criteria");
            if (criteriaObj == null || !(criteriaObj instanceof List) || ((List)criteriaObj).size() == 0 || !(((List)criteriaObj).get(0) instanceof Map)) {
                log.warn("In criteriaHasPKs, found an OR clause which has invalid 'criteria': it is either missing entirely, null, empty or not a List of Maps");
                return false;
            }
            List criterions = (List)criteria.get("criteria");
            if (primaryKeys.size() != 1) {
                return false;
            }
            int count2 = 0;
            for (Map criteriaMap : criterions) {
                if (forceSingle && count2 > 0) {
                    return false;
                }
                if (!this.criteriaHasPKs(criteriaMap, primaryKeys, forceSingle, passedKeys)) {
                    return false;
                }
                ++count2;
            }
            return true;
        }
        if (DefaultOperators.Not.getID().equals(criteria.get("operator"))) {
            return false;
        }
        boolean foundKey = false;
        for (String key : primaryKeys) {
            if (!key.equals(criteria.get("fieldName")) || !DefaultOperators.IEquals.getID().equals(criteria.get("operator")) && !DefaultOperators.Equals.getID().equals(criteria.get("operator")) && (!DefaultOperators.InSet.getID().equals(criteria.get("operator")) || !config.getBoolean((Object)"allowMultiPKUpdates", false)) || forceSingle && criteria.get("value") instanceof List && ((List)criteria.get("value")).size() != 1 && !config.getBoolean((Object)"allowMultiPKUpdates", false)) continue;
            passedKeys.add(key);
            foundKey = true;
            break;
        }
        return foundKey;
    }

    public DSRequest setApplyCriteriaBeforeAggregation(boolean applyCriteriaBeforeAggregation) {
        this.setParameter("applyCriteriaBeforeAggregation", applyCriteriaBeforeAggregation);
        return this;
    }

    public Object getApplyCriteriaBeforeAggregation() {
        return this.getParameter("applyCriteriaBeforeAggregation");
    }

    public DSRequest setUploadedFiles(List uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
        if (uploadedFiles == null) {
            return this;
        }
        String logMsg = "We parsed " + uploadedFiles.size() + " uploaded file(s)";
        if (uploadedFiles.size() > 0) {
            logMsg = logMsg + ": ";
            for (int i = 0; i < uploadedFiles.size(); ++i) {
                if (!(uploadedFiles.get(i) instanceof ISCFileItem)) continue;
                ISCFileItem ifi = (ISCFileItem)uploadedFiles.get(i);
                if (i > 0) {
                    logMsg = logMsg + ", ";
                }
                logMsg = logMsg + "\"" + ifi.getName() + "\" (" + ifi.getSize() + " bytes)";
            }
        }
        log.info(logMsg);
        return this;
    }

    public DSRequest clearUploadedFiles() {
        this.setUploadedFiles(null);
        return this;
    }

    public ISCFileItem getUploadedFile(String fieldName) throws Exception {
        ISCFileItem fileItem = this.context.request.getUploadedFile(fieldName);
        return fileItem;
    }

    public List getUploadedFiles() {
        return this.uploadedFiles;
    }

    public InputStream getUploadedFileStream(String fieldName) throws Exception {
        ISCFileItem fileItem = this.context.request.getUploadedFile(fieldName);
        if (this.getValues().get(fieldName) instanceof InputStream) {
            return (InputStream)this.getValues().get(fieldName);
        }
        if (fileItem == null) {
            return null;
        }
        return fileItem.getInputStream();
    }

    public List getUploadedFileStreams() {
        List uploadedFiles = this.getUploadedFiles();
        if (uploadedFiles == null) {
            return null;
        }
        ArrayList<Object> uploadedFileStreams = new ArrayList<Object>();
        for (ISCFileItem file : uploadedFiles) {
            String fieldName = file.getFieldName();
            if (this.getValues().get(fieldName) instanceof InputStream) {
                uploadedFileStreams.add(this.getValues().get(fieldName));
                continue;
            }
            uploadedFileStreams.add(file.getInputStream());
        }
        return uploadedFileStreams;
    }

    public List getBinaryStreams() throws Exception {
        boolean multiInsert;
        List streams = this.getUploadedFileStreams();
        List uploadedFiles = this.getUploadedFiles();
        ArrayList<Map<Object, Object>> fieldStreamMaps = new ArrayList<Map<Object, Object>>();
        boolean processUploadedFiles = true;
        if (this.getValueSets().size() > 1) {
            if (uploadedFiles != null && uploadedFiles.size() > 0) {
                log.warn("Request including a file upload also specified multiple valueSets.  This is not supported.  The upload(s) will be ignored");
            }
            processUploadedFiles = false;
        }
        if (processUploadedFiles && uploadedFiles != null && uploadedFiles.size() > 0) {
            for (int i = 0; i < uploadedFiles.size(); ++i) {
                int j;
                ISCFileItem file = (ISCFileItem)uploadedFiles.get(i);
                HashMap<String, Object> fieldStreamMap = new HashMap<String, Object>();
                fieldStreamMap.put("name", file.getFieldName());
                fieldStreamMap.put("stream", (InputStream)streams.get(i));
                for (j = 0; j < fieldStreamMaps.size(); ++j) {
                    String yourFieldName;
                    Map otherFieldStreamMap = (Map)fieldStreamMaps.get(j);
                    String myFieldName = (String)fieldStreamMap.get("name");
                    if (myFieldName.compareTo(yourFieldName = (String)otherFieldStreamMap.get("name")) < 0) break;
                }
                fieldStreamMaps.add(j, fieldStreamMap);
            }
        }
        this.getDataSource();
        boolean bl = multiInsert = DataSource.isAdd(this.getOperationType()) && Boolean.TRUE.equals(this.getAttribute("isBatchAdding"));
        if (!multiInsert) {
            Map values = this.getValues();
            if (values != null) {
                for (String key : values.keySet()) {
                    Map<String, InputStream> fieldStreamMap;
                    int j;
                    if (!(values.get(key) instanceof InputStream)) continue;
                    for (j = 0; j < fieldStreamMaps.size(); ++j) {
                        fieldStreamMap = (Map)fieldStreamMaps.get(j);
                        String fieldName = (String)fieldStreamMap.get("name");
                        if (key == null || fieldName == null || key.equals(fieldName)) {
                            fieldStreamMaps.remove(j);
                            break;
                        }
                        if (key.compareTo(fieldName) < 0) break;
                    }
                    fieldStreamMap = new HashMap();
                    fieldStreamMap.put("name", (InputStream)((Object)key));
                    fieldStreamMap.put("stream", (InputStream)values.get(key));
                    fieldStreamMaps.add(j, fieldStreamMap);
                }
            }
            ArrayList rtn = new ArrayList();
            Iterator i = fieldStreamMaps.iterator();
            while (i.hasNext()) {
                rtn.add(((Map)i.next()).get("stream"));
            }
            return rtn;
        }
        DecimalFormat df = new DecimalFormat("0000000");
        for (int i = 0; i < this.getValueSets().size(); ++i) {
            Map values = (Map)this.getValueSets().get(i);
            if (values == null) continue;
            for (Object key : values.keySet()) {
                Map<String, InputStream> fieldStreamMap;
                int j;
                Object value = values.get(key);
                if (!(value instanceof InputStream)) continue;
                key = df.format(i) + "-" + (String)key;
                for (j = 0; j < fieldStreamMaps.size(); ++j) {
                    fieldStreamMap = (Map)fieldStreamMaps.get(j);
                    String identifier = (String)fieldStreamMap.get("identifier");
                    if (key == null || identifier == null || ((String)key).equals(identifier)) {
                        fieldStreamMaps.remove(j);
                        break;
                    }
                    if (((String)key).compareTo(identifier) < 0) break;
                }
                fieldStreamMap = new HashMap();
                fieldStreamMap.put("identifier", (InputStream)key);
                fieldStreamMap.put("stream", (InputStream)value);
                fieldStreamMaps.add(j, fieldStreamMap);
            }
        }
        ArrayList rtn = new ArrayList();
        Iterator i = fieldStreamMaps.iterator();
        while (i.hasNext()) {
            rtn.add(((Map)i.next()).get("stream"));
        }
        return rtn;
    }

    public DSRequest setDownloadFieldName(String downloadFieldName) {
        this.downloadFieldName = downloadFieldName;
        return this;
    }

    public String getDownloadFieldName() {
        return this.downloadFieldName;
    }

    public DSRequest setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
        return this;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public boolean isDownload() {
        String opType;
        return this.getDownloadFieldName() != null && ("downloadFile".equals(opType = this.getOperationType()) || "viewFile".equals(opType));
    }

    public void setIncludeBinaryFields(boolean includeBinaryFields) {
        this.includeBinaryFields = includeBinaryFields;
    }

    public boolean getIncludeBinaryFields() {
        if (this.includeBinaryFields != null) {
            return this.includeBinaryFields;
        }
        if (this.isClientRequest() && !this.isDownload()) {
            return false;
        }
        return !this.isCacheSyncRequest();
    }

    public boolean isExport() {
        return this.getExportResults();
    }

    public boolean shouldReportDownloadErrorsAsDocuments() {
        return DataTools.asBoolean(this.getParameter("reportDownloadErrorsAsDocuments"), false);
    }

    public Map getValues() {
        return this.getValues(true);
    }

    public Map getValues(boolean returnCriteriaForFetch) {
        Object values;
        if (returnCriteriaForFetch) {
            if (DataSource.isFetch(this.getOperationType())) {
                return this.getCriteria();
            }
            if (DataSource.isRemove(this.getOperationType())) {
                return this.getCriteria();
            }
        }
        if ((values = this.getRawValues()) instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getValues() called on dsRequest containing multiple sets of values, returning first in list");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public Map getClientSuppliedValues() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getClientSuppliedCriteria();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getClientSuppliedCriteria();
        }
        Object values = this.clientSuppliedValues;
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getClientSuppliedValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getValueSets() {
        if (DataSource.isFetch(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        if (DataSource.isRemove(this.getOperationType())) {
            return this.getCriteriaSets();
        }
        return DataTools.makeListIfSingle(this.getRawValues());
    }

    public DSRequest setValues(Object values) {
        this.requestData.put("values", values);
        return this;
    }

    public Object getRawValues() {
        return this.requestData.get("values");
    }

    public Map getOldValues() {
        Object values = this.getRawOldValues();
        if (values instanceof List) {
            List l = (List)values;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (Map)l.get(0);
            }
            log.warning("getOldValues() called on dsRequest containing multiple sets of values, returning first in list.");
            return (Map)l.get(0);
        }
        return (Map)values;
    }

    public List getOldValueSets() {
        return DataTools.makeListIfSingle(this.getRawOldValues());
    }

    public Object getRawOldValues() {
        return this.requestData.get("oldValues");
    }

    public DSRequest setOldValues(Map oldValues) {
        this.requestData.put("oldValues", oldValues);
        return this;
    }

    public String getSortBy() {
        if (this.sortBy instanceof List) {
            List l = (List)this.sortBy;
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return (String)l.get(0);
            }
            log.warning("getSortBy() called on dsRequest containing multiple sortBy fields, returning first in list.");
            return (String)l.get(0);
        }
        return (String)this.sortBy;
    }

    public Object getRawSortBy() {
        return this.sortBy;
    }

    public List getSortByFields() {
        return DataTools.makeListIfSingle(this.sortBy);
    }

    public DSRequest setSortBy(Object sortBy) {
        this.sortBy = sortBy;
        if (this.beenThroughDMI) {
            try {
                this.createIncludeFromDefinitionFromSortBy(this.includeFrom, null, true);
            }
            catch (Exception ex) {
                this.preparedFieldData = false;
            }
        }
        return this;
    }

    private void buildSummaryFields() {
        Iterator<Object> i;
        if (this.summaryFields == null) {
            this.summaryFields = new ArrayList<String>();
        } else {
            this.summaryFields.clear();
        }
        List groupByList = null;
        ArrayList<String> newGroupByList = new ArrayList<String>();
        Map<String, SummaryFunctionType> summaryFunctionsMap = null;
        DataSource ds = null;
        try {
            ds = this.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean allowClientRequestedSummaries = config.getBoolean((Object)"datasources.allowClientRequestedSummaries", true);
        if (ds != null) {
            allowClientRequestedSummaries = DataTools.getBoolean(ds.getConfig(), "allowClientRequestedSummaries", allowClientRequestedSummaries);
            DataTypeMap opBinding = ds.getOperationBinding(this);
            if (opBinding != null && (allowClientRequestedSummaries = DataTools.getBoolean((Map)((Object)opBinding), "allowClientRequestedSummaries", allowClientRequestedSummaries))) {
                groupByList = DataTools.makeListIfSingle(opBinding.get("groupBy"));
                summaryFunctionsMap = this.convertMapOfStringToMapOfSummaryFunctionType((Map)opBinding.get("summaryFunctions"));
            }
        }
        if (allowClientRequestedSummaries && (groupByList == null || groupByList.isEmpty()) && (summaryFunctionsMap == null || summaryFunctionsMap.isEmpty())) {
            groupByList = this.getGroupBy();
            summaryFunctionsMap = this.getSummaryFunctions();
        }
        if (groupByList != null && !groupByList.isEmpty() || summaryFunctionsMap == null || !summaryFunctionsMap.isEmpty()) {
            // empty if block
        }
        if (summaryFunctionsMap != null) {
            i = summaryFunctionsMap.keySet().iterator();
            while (i.hasNext()) {
                String fieldName = (String)i.next();
                if (ds != null) {
                    DSField field;
                    SummaryFunctionType summaryFunctionType = summaryFunctionsMap.get(fieldName);
                    if (summaryFunctionType == null) {
                        log.warn("A null function name was specified in summaryFunctions for field '" + ds.getName() + "." + fieldName + "'. Skipping.");
                        i.remove();
                        continue;
                    }
                    if (!ds.supportsSummaryFunction(summaryFunctionType.getFunctionName())) {
                        String functionName = summaryFunctionType.getFunctionName().toLowerCase();
                        if (ds.supportsAggregationInherently() || SummaryFunctions.getSummaryFunction(functionName) == null) {
                            log.warn("Function name: '" + summaryFunctionType.getFunctionName() + "' specified in summaryFunctions for field '" + ds.getName() + "." + fieldName + "' is not supported by this type of DataSource. Skipping.");
                            i.remove();
                            continue;
                        }
                    }
                    if ((field = ds.getField(fieldName)) == null && (field = this.getAdditionalOutputsField(fieldName)) == null) {
                        log.warn("Field name: '" + fieldName + "' specified in group-by or summaryFunctions is not defined in data source. Skipping.");
                        i.remove();
                        continue;
                    }
                    if (!field.getBoolean("allowClientRequestedSummaries", allowClientRequestedSummaries)) {
                        log.warn("Client-requested summarization is NOT allowed for field '" + fieldName + "' specified in group-by or summaryFunctions. Skipping.");
                        i.remove();
                        continue;
                    }
                }
                if (this.summaryFields.contains(fieldName)) continue;
                this.summaryFields.add(fieldName);
            }
        }
        if (groupByList != null) {
            i = groupByList.iterator();
            while (i.hasNext()) {
                String fieldNameString = (String)i.next();
                if (fieldNameString == null) continue;
                boolean fieldShouldBeRemoved = false;
                for (String fieldName : fieldNameString.split(",")) {
                    fieldName = fieldName.trim();
                    if (summaryFunctionsMap != null && summaryFunctionsMap.containsKey(fieldName)) {
                        log.warn("Field name: '" + fieldName + "' is already specified in summary functions to use in select statement. Excluding it from group by clause.");
                        continue;
                    }
                    if (ds != null) {
                        DSField field = ds.getField(fieldName);
                        if (field == null && (field = this.getAdditionalOutputsField(fieldName)) == null) {
                            log.warn("Field name: '" + fieldName + "' specified in group-by or summary functions is not defined in data source. Skipping.");
                            fieldShouldBeRemoved = true;
                            continue;
                        }
                        if (!field.getBoolean("allowClientRequestedSummaries", allowClientRequestedSummaries)) {
                            log.warn("Client-requested summarization is NOT allowed for field '" + fieldName + "' specified in group-by or summary functions. Skipping.");
                            fieldShouldBeRemoved = true;
                            continue;
                        }
                    }
                    if (this.summaryFields.contains(fieldName)) continue;
                    this.summaryFields.add(fieldName);
                    newGroupByList.add(fieldName);
                }
                if (!fieldShouldBeRemoved) continue;
                i.remove();
            }
        }
        this.groupBy = newGroupByList;
        this.summaryFunctions = summaryFunctionsMap;
    }

    public List<String> getSummaryFields() {
        return this.summaryFields;
    }

    public boolean isSummary() {
        return this.summaryFields != null && this.summaryFields.size() > 0;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public DSRequest setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
        this.rebuildFieldDataIfNeeded();
        return this;
    }

    public DSRequest setGroupBy(String ... groupBy) {
        this.setGroupBy(new ArrayList<String>(Arrays.asList(groupBy)));
        return this;
    }

    public Map<String, SummaryFunctionType> getSummaryFunctions() {
        return this.summaryFunctions;
    }

    public DSRequest setSummaryFunctions(Map<String, SummaryFunctionType> summaryFunctions) {
        this.summaryFunctions = summaryFunctions;
        this.rebuildFieldDataIfNeeded();
        return this;
    }

    public Map<String, String> getRawSummaryFunctions() {
        if (this.rawSummaryFunctions == null && this.isClientRequest()) {
            this.rawSummaryFunctions = (Map)this.getParameter("summaryFunctions");
        }
        return this.rawSummaryFunctions;
    }

    public DSRequest setRawSummaryFunctions(Map<String, String> rawSummaryFunctions) {
        this.rawSummaryFunctions = rawSummaryFunctions;
        return this;
    }

    public List getSummaryFunctionFields() {
        return this.summaryFunctionFields;
    }

    public void setSummaryFunctionFields(List summaryFunctionFields) {
        this.summaryFunctionFields = summaryFunctionFields;
    }

    public boolean isPaged() {
        return this.batchSize != -1L || this.startRow != 0L || this.endRow != -1L;
    }

    public boolean _isExplicitBatchSize() {
        return this._explicitBatchSize;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public DSRequest _setBatchSize(long batchSize) throws Exception {
        if (!this._explicitBatchSize) {
            this.batchSize = batchSize;
        }
        return this;
    }

    public DSRequest setBatchSize(long batchSize) {
        this.batchSize = batchSize;
        this._explicitBatchSize = true;
        return this;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public DSRequest setStartRow(long startRow) {
        this.startRow = startRow;
        return this;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public DSRequest setEndRow(long endRow) {
        this.endRow = endRow;
        return this;
    }

    public Boolean getProgressiveLoading() {
        return (Boolean)this.getParameter("progressiveLoading");
    }

    public DSRequest setProgressiveLoading(Boolean progressiveLoading) {
        this.setParameter("progressiveLoading", progressiveLoading);
        return this;
    }

    public Object getFieldValue(Object fieldName) {
        Map valueSet = this.getValues();
        if (valueSet != null && valueSet.get(fieldName) != null) {
            return valueSet.get(fieldName);
        }
        if (DataSource.isAdd(this.getOperationType())) {
            return null;
        }
        return this.getCriteriaValue(fieldName);
    }

    public Object getCriteriaValue(Object fieldName) {
        if (this.getIsAdvancedCriteria()) {
            Object res;
            AdvancedCriteria ac = this.getAdvancedCriteria();
            if (ac != null && (res = ac.getFieldValue((String)fieldName)) != null) {
                return res;
            }
        } else {
            Map criteria = this.getCriteria();
            if (criteria != null && criteria.get(fieldName) != null) {
                return criteria.get(fieldName);
            }
        }
        return null;
    }

    public Object setCriteriaValue(String fieldName, Object value) {
        Object retValue = null;
        if (this.getIsAdvancedCriteria()) {
            AdvancedCriteria ac = this.getAdvancedCriteria();
            SimpleCriterion newCriterion = new SimpleCriterion(fieldName, "equals", value);
            Criterion oldCriterion = ac.asCriterion();
            ac = new AdvancedCriteria(DefaultOperators.And, newCriterion, oldCriterion);
            this.setAdvancedCriteria(ac);
        } else {
            Map criteria = this.getCriteria();
            retValue = criteria.get(fieldName);
            criteria.put(fieldName, value);
            this.setCriteria(criteria);
        }
        return retValue;
    }

    public DSRequest setFieldValue(Object fieldName, Object value) {
        LinkedHashMap<Object, Object> valueSet = this.getValues();
        if (valueSet == null && DataSource.isAddOrUpdate(this.getOperationType())) {
            valueSet = new LinkedHashMap<Object, Object>();
            this.setValues(valueSet);
        }
        if (DataSource.isAddOrUpdate(this.getOperationType())) {
            valueSet.put(fieldName, value);
        } else {
            this.setCriteriaValue(fieldName.toString(), value);
        }
        return this;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public DSRequest setDataSource(String dataSource) {
        return this.setDataSourceName(dataSource);
    }

    public DSRequest setDataSourceName(String dataSourceName) {
        if (this.dataSourceName == null && dataSourceName == null || dataSourceName.equals(this.dataSourceName)) {
            return this;
        }
        this.dataSourceName = dataSourceName;
        DataSourceManager.free(this.ds);
        this.ds = null;
        try {
            this.getDataSource();
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception attempting to get DataSource", e);
        }
        if (this.ds != null) {
            this.applyDefaultTextMatchStyle(this.ds);
        }
        return this;
    }

    public DataSource getDataSource() throws Exception {
        if (this.ds == null && this.getDataSourceName() != null) {
            if (this.sandboxContext != null && !this.assertedSandbox) {
                this.assertSandbox();
            }
            this.ds = this.getCachedDataSourceInstance(this.getDataSourceName());
            if (this.ds == null) {
                this.ds = DataSourceManager.getDataSource(this.getDataSourceName(), this);
                log.debug("Caching instance " + (String)(this.ds == null ? "null" : this.ds.getInstanceId() + " of DS '" + this.ds.getID() + "' from DSRequest.getDataSource()"));
                if (this.ds != null) {
                    this.dataSourceName = this.ds.getName();
                }
                this.cacheDataSourceInstance(this.getDataSourceName(), this.ds);
            }
        }
        return this.ds;
    }

    public DSRequest setDataSource(DataSource ds) {
        if (ds == this.ds) {
            return this;
        }
        if (this.ds != null) {
            DataSourceManager.freeDataSource(this.ds);
        }
        this.ds = ds;
        if (ds != null) {
            this.dataSourceName = ds.getName();
            this.applyDefaultTextMatchStyle(ds);
        }
        return this;
    }

    public void clearDataSource() {
        this.setDataSource((DataSource)null);
    }

    public boolean isDataSourceNull() {
        return this.ds == null;
    }

    private void applyDefaultTextMatchStyle(DataSource ds) {
        if (this.getTextMatchStyle() == null) {
            if (ds != null && ds.getConfig().get("defaultTextMatchStyle") != null) {
                this.setTextMatchStyle((String)ds.getConfig().get("defaultTextMatchStyle"));
            } else if (config.get("global.default.textMatchStyle") != null) {
                this.setTextMatchStyle(config.getString("global.default.textMatchStyle"));
            }
        }
    }

    @Override
    public void setRPCManager(RPCManager rpcManager) {
        super.setRPCManager(rpcManager);
        if (this.requestData != null && rpcManager != null && rpcManager.hasTenantId()) {
            this.setTenantId(rpcManager.getTenantId());
        }
    }

    private void initFromValidationContext(ValidationContext vc) {
        if (vc == null) {
            return;
        }
        RPCManager rpcManager = vc.getRPCManager();
        DSRequest contextReq = vc.getDSRequest();
        if (contextReq != null) {
            this.setTenantId(contextReq.getTenantId());
            rpcManager = contextReq.getRPCManager();
        }
        this.setRPCManager(rpcManager);
    }

    public String getTenantId() {
        return (String)this.requestData.get("tenantId");
    }

    public boolean hasTenantId() {
        return this.getTenantId() != null;
    }

    public boolean clearTenantId() {
        if (!this.hasTenantId()) {
            return false;
        }
        this.getCachedDataSourceInstances().clear();
        this.removeAttribute("_includeFromsAlreadySeen");
        this.requestData.remove("tenantId");
        return true;
    }

    private static String getReloadDataSourceMessage(String baseName) {
        return "A DataSource was already loaded for this DSRequest (e.g. during construction).  Setting a new tenant ID now forcse the DataSource to be reloaded, and the base name '" + baseName + "' to be recached.  To avoid, either pass an RPCManager with the authenticated tenant ID to the DSRequet constructor (if you're not now), or make sure this DataSource cannot be loaded as a non-multi-tenant DataSource.";
    }

    public DSRequest setTenantId(String tenantId) {
        if (this.requestData == null) {
            throw new IllegalStateException("request has no data map - can't set tenant ID");
        }
        String lastTenantId = this.requestData.put("tenantId", tenantId);
        if (this.ds != null && (tenantId != null ? !tenantId.equals(lastTenantId) : lastTenantId != null)) {
            String baseName = this.ds.getBaseName();
            this.uncacheDataSourceInstance(baseName);
            this.dataSourceName = null;
            this.setDataSourceName(baseName);
            String message = DSRequest.getReloadDataSourceMessage(baseName);
            if (warnedOfDataSourceReload.compareAndSet(false, true)) {
                log.warn(message);
            } else {
                log.debug(message);
            }
        }
        return this;
    }

    public String getValidationMode() {
        return (String)this.requestData.get("validationMode");
    }

    public DSRequest setValidationMode(String validationMode) {
        this.requestData.put("validationMode", validationMode);
        return this;
    }

    public boolean getPendingAddFlag() {
        return DataTools.getBoolean(this.requestData, "pendingAdd", false);
    }

    public DSRequest setPendingAddFlag(boolean pendingAdd) {
        this.requestData.put("pendingAdd", pendingAdd);
        return this;
    }

    public ErrorReport validate() throws Exception {
        List l = DataSource.validateDSRequest(this.getDataSource(), this);
        if (l != null) {
            return (ErrorReport)l.get(0);
        }
        return null;
    }

    public Boolean getGenerateRelatedUpdates() {
        Object generateRelatedUpdates = this.getParameter("generateRelatedUpdates");
        if (generateRelatedUpdates == null) {
            return null;
        }
        return DataTools.asBoolean(generateRelatedUpdates);
    }

    public void setGenerateRelatedUpdates(Boolean generateRelatedUpdates) {
        this.setParameter("generateRelatedUpdates", generateRelatedUpdates);
    }

    public void convertRelativeDates() {
        if (AdvancedCriteria.isAdvancedCriteria(this.getCriteria())) {
            Criterion criterion = Evaluator.parseAdvancedCriteria(this.getCriteria()).asCriterion();
            this.setCriteria(new AdvancedCriteria(DataSource.convertRelativeDates(criterion)));
        } else {
            this.setCriteria(DataSource.convertRelativeDates(this.getCriteria(), this));
        }
    }

    public boolean getRequestStarted() {
        return this.requestStarted;
    }

    public DSRequest setRequestStarted(boolean newValue) {
        this.requestStarted = newValue;
        return this;
    }

    @Override
    public DSResponse call() throws Exception {
        return this.execute();
    }

    protected void assertSandbox() throws Exception {
        log.info("Asserting sandboxContext: " + DataTools.prettyPrint((Object)this.sandboxContext));
        this.dbSandboxToRestore = Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "getRequestSandbox", this.sandboxDbName);
        Reflection.invokeStaticMethod("com.isomorphic.site.SandboxFilter", "assertSandboxForContext", new Object[]{this.context, this.sandboxContext});
    }

    public boolean shouldLogResponseData() {
        return this.logResponseData;
    }

    public void setLogResponseData(boolean newValue) {
        this.logResponseData = newValue;
    }

    @Override
    public DSResponse execute() throws Exception {
        Object required2;
        DSResponse dsResponse;
        block93: {
            DataSource ds;
            DSTransaction dsTransaction;
            boolean logAtDebug;
            block91: {
                Object dsSkipRemainingQueue2;
                block92: {
                    DataSource ds2;
                    Integer cacheSyncBatchSize;
                    Integer defaultFetchBatchSize;
                    block89: {
                        DSResponse i;
                        block90: {
                            DataSource ds3;
                            DataTypeMap operationBinding;
                            String cacheSyncOp;
                            String opType = this.getOperationType();
                            boolean bl = logAtDebug = DataSource.isFileSource(opType) || DataSource.isFileSourceSubrequest(opType, this.getOperationId());
                            if (logAtDebug ? log.isDebugEnabled() : log.isInfoEnabled()) {
                                String operationId;
                                DataTypeMap operationBinding2;
                                String componentId;
                                List values = this.getValueSets();
                                JSTranslater jsTrans = JSTranslater.instance().enablePrettyPrinting(true).collapseSmallContainers(true);
                                Object valuesString = "";
                                if (values != null && !DataSource.isFetch(opType) && !DataSource.isRemove(opType)) {
                                    valuesString = values.size() == 1 ? "\nvalues: " + jsTrans.toJS(values.get(0)) : "\nvalues: " + values.size() + " valueSets";
                                }
                                String message = "Executing " + (String)((componentId = this.getComponentId()) != null ? componentId + "->" : "") + this.getDataSourceName() + "." + this.getOperationType();
                                if (this.getDataSource() != null && (operationBinding2 = this.getDataSource().getOperationBinding(opType, this.getOperationId())) != null && (operationId = (String)operationBinding2.get("operationId")) != null) {
                                    message = message + "[" + operationId + "]";
                                }
                                if (DataSource.isFetch(opType)) {
                                    message = message + " rows: " + this.getStartRow() + "->" + this.getEndRow();
                                }
                                if (!logAtDebug && ((String)valuesString).length() > maxValuesMesssageLength) {
                                    valuesString = ((String)valuesString).substring(0, maxValuesMesssageLength);
                                    valuesString = (String)valuesString + "... [set log category to DEBUG to see full object]";
                                }
                                message = message + " with" + (String)(this.constraints() != null ? "\nconstraints: " + String.valueOf(this.constraints()) : "") + (String)(this.outputs() != null ? "\noutputs: " + String.valueOf(this.outputs()) : "") + (String)(this.getRawCriteria() != null ? "\ncriteria: " + jsTrans.toJS(this.getRawCriteria()) : "") + (String)(this.getSortByFields().size() > 0 ? "\nsortBy: " + String.valueOf(this.getSortByFields()) : "") + (String)valuesString;
                                if (logAtDebug) {
                                    log.debug(message);
                                } else {
                                    log.info(message);
                                }
                            }
                            if ((dsTransaction = this.getDsTransaction()) != null) {
                                dsTransaction.registerRequest(this);
                                if (dsTransaction.isSkipRemainingQueue()) {
                                    log.debug("DSTransaction.skipRemainingQueue is true so we're returning a DSResponse with status PROCESSING_SKIPPED.");
                                    dsResponse = new DSResponse();
                                    dsResponse.setStatus(4);
                                    dsTransaction.registerResponse(this, dsResponse);
                                    return dsResponse;
                                }
                            }
                            this.resourcesFreed = false;
                            dsResponse = null;
                            this.recordTimingData("DSRequest processing", TimingLogType.START);
                            if (this.getDataSource() != null) {
                                this.getDataSource().dsRequestStarted(this);
                            }
                            if (this.sandboxContext != null && !this.assertedSandbox) {
                                this.assertSandbox();
                            }
                            this.normalizeCriteria();
                            this.buildFieldData(false);
                            boolean skipSecurityCheck = false;
                            if (this.isCacheSyncRequest() && (cacheSyncOp = this.getOperationId()) != null && this.getDataSource() != null && (operationBinding = this.getDataSource().getOperationBinding(this.getOperationType(), this.getOperationId())) != null && cacheSyncOp.equals(operationBinding.get("operationId"))) {
                                skipSecurityCheck = true;
                            }
                            if (!skipSecurityCheck) {
                                this.recordTimingData("Declarative security checks", TimingLogType.START);
                                if (!this.passesSecurityChecks()) {
                                    throw new SecurityException(this.securityFailureMessage);
                                }
                                this.recordTimingData("Declarative security checks", TimingLogType.END);
                            }
                            if (this.getUploadedFiles() == null) break block89;
                            this.recordTimingData("Uploaded files processing", TimingLogType.START);
                            long dftMaxSize = config.getDataSizeNumBytes((Object)"DSRequest.maxUploadFileSize", 0L);
                            for (ISCFileItem file : this.getUploadedFiles()) {
                                List<?> errors = file.getErrors();
                                if (errors == null || this.getDataSource() == null) continue;
                                dsResponse = new DSResponse(this.getDataSource());
                                DSField field = this.ds.getField(file.getFieldName());
                                long maxSize = dftMaxSize;
                                if (field.get("maxFileSize") != null) {
                                    maxSize = field.getDataSizeNumBytes("maxFileSize");
                                }
                                dsResponse.setParameter("maxFileSize", DataTools.formatFileSize(maxSize));
                                dsResponse.setParameter("uploadedFileName", file.getShortFileName());
                                dsResponse.setParameter("uploadedFileSize", DataTools.formatFileSize(file.getSize()));
                                dsResponse.setStatus(-11);
                                dsResponse.requestConnectionClose();
                            }
                            this.recordTimingData("Uploaded files processing", TimingLogType.END);
                            if (dsResponse == null) break block89;
                            i = dsResponse;
                            if (dsResponse == null || dsTransaction == null) break block90;
                            this.getDsTransaction().registerResponse(this, dsResponse);
                            if (dsResponse.statusIsError() && (ds3 = this.getDataSource()) != null) {
                                boolean bindingSkipRemainingQueue;
                                DataTypeMap binding = ds3.getOperationBinding(this.getOperationType(), this.getOperationId());
                                boolean dsSkipRemainingQueue2 = "true".equals(ds3.getConfig().get("skipRemainingQueue"));
                                boolean bl2 = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                                if (dsSkipRemainingQueue2 || bindingSkipRemainingQueue) {
                                    log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                                    dsTransaction.skipRemainingQueue();
                                }
                            }
                        }
                        if (this.getFreeOnExecute()) {
                            log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
                            this.freeResources();
                            if (this.getRPCManager() == null) {
                                this.freeQueueResources();
                            }
                            if (this.getRPCManager() != null) {
                                this.getRPCManager().freeDataSources();
                            }
                        } else {
                            log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
                        }
                        if (this.trackTimings()) {
                            this.recordTimingData("DSRequest processing", TimingLogType.END);
                            this.copyTimingDataToResponse(dsResponse);
                        }
                        if (this.sandboxDbName != null) {
                            if (this.dbSandboxToRestore != null) {
                                log.info("Restoring sandboxDbName: " + this.sandboxDbName);
                                Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "setRequestSandbox", this.dbSandboxToRestore);
                            } else {
                                log.info("Clearing sandboxDbName: " + this.sandboxDbName);
                                Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "clearRequestSandbox", this.sandboxDbName);
                            }
                        }
                        return i;
                    }
                    if (this.getEndRow() == -1L && DataSource.isFetch(this.getOperationType()) && (defaultFetchBatchSize = config.getInteger("sql.defaultFetchBatchSize")) != null) {
                        this._setBatchSize(defaultFetchBatchSize.intValue());
                    }
                    if (this.isCacheSyncRequest() && !this.isConcatFetchRequest() && (cacheSyncBatchSize = config.getInteger("sql.cacheSyncBatchSize")) != null && cacheSyncBatchSize != 0) {
                        this._setBatchSize(cacheSyncBatchSize.intValue());
                    }
                    if (this.getDataSource() == null) break block91;
                    this.getDataSource().applyTransformRequestScript(this, new HashMap<String, Object>());
                    DataTypeMap binding = this.getDataSource().getOperationBinding(this);
                    Object object = required2 = binding == null ? null : binding.getCommaSeparatedList("requiredCriterion");
                    if (required2 == null) break block91;
                    ErrorReport er = new ErrorReport();
                    ArrayList<String> missing = new ArrayList<String>();
                    String msg = "Criterion required for field.";
                    dsSkipRemainingQueue2 = required2.iterator();
                    while (dsSkipRemainingQueue2.hasNext()) {
                        String fieldTitle;
                        String criteriaName = dsSkipRemainingQueue2.next();
                        if (this.getAdvancedCriteria() != null && this.getAdvancedCriteria().getFieldCriterion(criteriaName) != null) continue;
                        er.addError(criteriaName, new ErrorMessage(msg));
                        String criteriaDisplayName = criteriaName;
                        DSField field = this.getDataSource().getField(criteriaName);
                        if (field != null && (fieldTitle = field.getTitle(this.getContext().getLocale())) != null) {
                            criteriaDisplayName = StringEscapeUtils.unescapeHtml((String)fieldTitle);
                        }
                        missing.add(criteriaDisplayName);
                    }
                    if (missing.isEmpty()) break block91;
                    dsResponse = new DSResponse(this.getDataSource());
                    dsResponse.setStatus(-13);
                    dsResponse.setProperty("missingCriterion", StringUtils.join(missing, (String)", "));
                    dsSkipRemainingQueue2 = dsResponse;
                    if (dsResponse == null || dsTransaction == null) break block92;
                    this.getDsTransaction().registerResponse(this, dsResponse);
                    if (dsResponse.statusIsError() && (ds2 = this.getDataSource()) != null) {
                        boolean bindingSkipRemainingQueue;
                        DataTypeMap binding2 = ds2.getOperationBinding(this.getOperationType(), this.getOperationId());
                        boolean dsSkipRemainingQueue3 = "true".equals(ds2.getConfig().get("skipRemainingQueue"));
                        boolean bl = bindingSkipRemainingQueue = binding2 != null && "true".equals(binding2.get("skipRemainingQueue"));
                        if (dsSkipRemainingQueue3 || bindingSkipRemainingQueue) {
                            log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                            dsTransaction.skipRemainingQueue();
                        }
                    }
                }
                if (this.getFreeOnExecute()) {
                    log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
                    this.freeResources();
                    if (this.getRPCManager() == null) {
                        this.freeQueueResources();
                    }
                    if (this.getRPCManager() != null) {
                        this.getRPCManager().freeDataSources();
                    }
                } else {
                    log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
                }
                if (this.trackTimings()) {
                    this.recordTimingData("DSRequest processing", TimingLogType.END);
                    this.copyTimingDataToResponse(dsResponse);
                }
                if (this.sandboxDbName != null) {
                    if (this.dbSandboxToRestore != null) {
                        log.info("Restoring sandboxDbName: " + this.sandboxDbName);
                        Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "setRequestSandbox", this.dbSandboxToRestore);
                    } else {
                        log.info("Clearing sandboxDbName: " + this.sandboxDbName);
                        Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "clearRequestSandbox", this.sandboxDbName);
                    }
                }
                return dsSkipRemainingQueue2;
            }
            try {
                String autoConvertRelativeDates;
                if (!this.beenThroughDMI) {
                    if (dsTransaction != null) {
                        dsTransaction.initiateRequestProcessing();
                    }
                    this.applyFieldValueExpressions();
                    if (!this.hasBeenThroughFieldLevelSecurity()) {
                        this.recordTimingData("Field-level declarative security checks", TimingLogType.START);
                        DeclarativeSecurity.performFieldLevelDSRequestChecks(this);
                        this.recordTimingData("Field-level declarative security checks", TimingLogType.END);
                        this.recordTimingData("Prepare DSRequest for DMI", TimingLogType.START);
                    }
                    if ("update".equals(this.getOperationType()) || "add".equals(this.getOperationType())) {
                        this.removeIllegalValues();
                    }
                    if (this.getDataSource() != null) {
                        this.getDataSource().trimCriteria(this);
                    }
                    if (dsTransaction != null) {
                        dsTransaction.applyEarlierResponseValues(this);
                    }
                    if ("update".equals(this.getOperationType()) || "add".equals(this.getOperationType())) {
                        this.hashFieldValues();
                        this.populateModifierAndCreatorFields("add".equals(this.getOperationType()));
                        List files = this.getUploadedFiles();
                        if (files != null) {
                            for (Object f : files) {
                                ISCFileItem file;
                                file = (ISCFileItem)f;
                                this.getValues().put(file.getFieldName(), file.getInputStream());
                            }
                        }
                    }
                    if ("preDMI".equalsIgnoreCase(config.getString("datasources.autoConvertRelativeDates"))) {
                        this.convertRelativeDates();
                    }
                    this.recordTimingData("Prepare DSRequest for DMI", TimingLogType.END);
                    this.recordTimingData("DMI", TimingLogType.START);
                    dsResponse = DataSourceDMI.execute(this, this.getRPCManager(), this.context);
                    this.recordTimingData("DMI", TimingLogType.END);
                }
                if ("update".equals(this.getOperationType()) || "add".equals(this.getOperationType())) {
                    this.populateModifierAndCreatorFields("add".equals(this.getOperationType()));
                }
                if ("postDMI".equalsIgnoreCase(autoConvertRelativeDates = config.getString("datasources.autoConvertRelativeDates", "disabled")) || "true".equalsIgnoreCase(autoConvertRelativeDates)) {
                    this.convertRelativeDates();
                }
                if (this.getIsAdvancedCriteria()) {
                    this.collectQueryFieldsFromAdvancedCriteria(this.getCriteria(false));
                }
                if (dsResponse == null) {
                    dsResponse = this.getApp().execute(this, this.context);
                }
                if (dsResponse != null) {
                    dsResponse.setCacheSyncContext(this);
                    dsResponse.setDSCacheManager(this.getDSCacheManager());
                    dsResponse.setOperationType(this.getOperationType());
                    if (dsResponse.getDataSource() == null) {
                        dsResponse.setDataSource(this.getDataSource());
                    }
                    if (config.getBoolean((Object)"devenv", false)) {
                        dsResponse.setParameter("_subQuerySeparation", this.getParameter("_subQuerySeparation"));
                    }
                }
                if (!this.shouldDeferCacheSync()) {
                    this.executePostUpdateDataSourceOperations(dsResponse);
                }
                if (!this.getCacheSyncStrategy().shouldRunCacheSync(this) || !this.shouldDeferCacheSync()) {
                    this.executePostCacheSyncTransformations(dsResponse);
                    this.executePostTransformOperations(dsResponse);
                }
                if (this.shouldLogResponseData()) {
                    dsResponse.logData(logAtDebug);
                }
                required2 = dsResponse;
                if (dsResponse == null || dsTransaction == null) break block93;
                this.getDsTransaction().registerResponse(this, dsResponse);
            }
            catch (Exception e) {
                try {
                    DataSource ds4 = this.getDataSource();
                    if (dsTransaction != null && ds4 != null) {
                        boolean bindingSkipRemainingQueue;
                        DataTypeMap binding = ds4.getOperationBinding(this.getOperationType(), this.getOperationId());
                        boolean dsSkipRemainingQueue = "true".equals(ds4.getConfig().get("skipRemainingQueue"));
                        boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                        if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                            dsTransaction.skipRemainingQueue();
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (dsResponse != null && dsTransaction != null) {
                        DataSource ds5;
                        this.getDsTransaction().registerResponse(this, dsResponse);
                        if (dsResponse.statusIsError() && (ds5 = this.getDataSource()) != null) {
                            boolean bindingSkipRemainingQueue;
                            DataTypeMap binding = ds5.getOperationBinding(this.getOperationType(), this.getOperationId());
                            boolean dsSkipRemainingQueue = "true".equals(ds5.getConfig().get("skipRemainingQueue"));
                            boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                            if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                                log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                                dsTransaction.skipRemainingQueue();
                            }
                        }
                    }
                    if (this.getFreeOnExecute()) {
                        log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
                        this.freeResources();
                        if (this.getRPCManager() == null) {
                            this.freeQueueResources();
                        }
                        if (this.getRPCManager() != null) {
                            this.getRPCManager().freeDataSources();
                        }
                    } else {
                        log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
                    }
                    if (this.trackTimings()) {
                        this.recordTimingData("DSRequest processing", TimingLogType.END);
                        this.copyTimingDataToResponse(dsResponse);
                    }
                    if (this.sandboxDbName != null) {
                        if (this.dbSandboxToRestore != null) {
                            log.info("Restoring sandboxDbName: " + this.sandboxDbName);
                            Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "setRequestSandbox", this.dbSandboxToRestore);
                        } else {
                            log.info("Clearing sandboxDbName: " + this.sandboxDbName);
                            Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "clearRequestSandbox", this.sandboxDbName);
                        }
                    }
                    throw throwable;
                }
            }
            if (dsResponse.statusIsError() && (ds = this.getDataSource()) != null) {
                boolean bindingSkipRemainingQueue;
                DataTypeMap binding = ds.getOperationBinding(this.getOperationType(), this.getOperationId());
                boolean dsSkipRemainingQueue = "true".equals(ds.getConfig().get("skipRemainingQueue"));
                boolean bl = bindingSkipRemainingQueue = binding != null && "true".equals(binding.get("skipRemainingQueue"));
                if (dsSkipRemainingQueue || bindingSkipRemainingQueue) {
                    log.debug("DSRequest about to return response with error status and DataSource or operationBinding has skipRemainingQueue set. Calling DSTransaction.skipRemainingQueue()");
                    dsTransaction.skipRemainingQueue();
                }
            }
        }
        if (this.getFreeOnExecute()) {
            log.debug("About to free up resources for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName());
            this.freeResources();
            if (this.getRPCManager() == null) {
                this.freeQueueResources();
            }
            if (this.getRPCManager() != null) {
                this.getRPCManager().freeDataSources();
            }
        } else {
            log.debug("freeOnExecute is false for request of type " + this.getOperationType() + " on DataSource " + this.getDataSourceName() + " - not freeing resources!");
        }
        if (this.trackTimings()) {
            this.recordTimingData("DSRequest processing", TimingLogType.END);
            this.copyTimingDataToResponse(dsResponse);
        }
        if (this.sandboxDbName != null) {
            if (this.dbSandboxToRestore != null) {
                log.info("Restoring sandboxDbName: " + this.sandboxDbName);
                Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "setRequestSandbox", this.dbSandboxToRestore);
            } else {
                log.info("Clearing sandboxDbName: " + this.sandboxDbName);
                Reflection.invokeStaticMethod("com.isomorphic.sql.DBSandbox", "clearRequestSandbox", this.sandboxDbName);
            }
        }
        return required2;
    }

    public void executePostUpdateDataSourceOperations(DSResponse dsResponse) throws Exception {
        if (!Boolean.TRUE.equals(dsResponse.getParameter("_cameThruDsExecute"))) {
            return;
        }
        if (DataSource.isAdd(this.getOperationType()) || DataSource.isRemove(this.getOperationType()) || DataSource.isUpdate(this.getOperationType())) {
            this.getDataSource().executePostUpdateDataSourceOperations(this, dsResponse);
        }
    }

    public void executePostCacheSyncTransformations(DSResponse dsResponse) throws Exception {
        if (DataSource.isFetch(this.getOperationType())) {
            this.fetchRelatedValues(dsResponse);
            this.applyManualFilter(dsResponse, null);
            if (this.applyManualGroupByAndAggregation(dsResponse)) {
                this.applyManualFilter(dsResponse, this.getAttribute(POST_AGGREGATION_CRITERIA_ATTRIBUTE_NAME));
            }
            this.applyManualSort(dsResponse);
        }
        List<String> outputColumns = null;
        Object operationBinding = null;
        DataSource ds = this.getDataSource();
        if (ds != null) {
            operationBinding = ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        }
        if (operationBinding != null && operationBinding.get("outputs") != null) {
            String outputString = (String)operationBinding.get("outputs");
            String[] outputArray = outputString.split(",");
            outputColumns = new ArrayList();
            for (int i = 0; i < outputArray.length; ++i) {
                outputColumns.add(outputArray[i].trim());
            }
        }
        if (!"loadSchema".equals(this.getOperationType())) {
            List clientOutputs = this.outputs();
            if (clientOutputs != null) {
                if (outputColumns != null) {
                    if (outputColumns.containsAll(this.outputs())) {
                        outputColumns = this.outputs();
                    } else {
                        ArrayList<String> resultList = new ArrayList<String>();
                        Boolean goodFields = true;
                        for (String item : clientOutputs) {
                            if (!outputColumns.contains(item)) continue;
                            resultList.add(item);
                        }
                        if (resultList.size() > 0) {
                            outputColumns = resultList;
                        } else {
                            log.warn("The dsRequest contains a client-specified 'outputs', but this does not contain any fields that are also present in the server-specified 'outputs' for this operationBinding (" + this.getOperationId() + "). Ignoring the client-specified value");
                        }
                    }
                } else {
                    List<String> fieldNames = ds._getFieldNames();
                    outputColumns = new ArrayList();
                    boolean unionMode = Boolean.TRUE.equals(this.getAttribute("unionMode"));
                    for (String outputName : this.outputs) {
                        if (unionMode || fieldNames.contains(outputName)) {
                            outputColumns.add(outputName);
                            continue;
                        }
                        if (IncludeFromDefinition.isDynamicInclusion(outputName)) {
                            IncludeFromDefinition work = new IncludeFromDefinition(outputName, this);
                            outputColumns.add(work.getThisFieldName());
                            continue;
                        }
                        if (this.getAdditionalOutputsField(outputName) != null) {
                            outputColumns.add(outputName);
                            continue;
                        }
                        log.warn("The dsRequest contains a client-specified 'outputs' which contains a reference to a field '" + outputName + "' that is not on this DataSource and is not a dynamic reference to a field on another DataSource. Ignoring it.");
                    }
                }
                this.consolidatedOutputs = outputColumns;
            }
            List dataList = dsResponse.getDataList();
            ArrayList unfilteredDataList = null;
            if (dataList != null) {
                unfilteredDataList = new ArrayList(dataList);
            }
            DeclarativeSecurity.applyCreatorOverridesToResultSet(dataList, this);
            if (ds != null && dataList != null) {
                ArrayList<String> fieldsToRemove = new ArrayList<String>();
                for (DSField field : ds.getFields()) {
                    List outputs;
                    if (field.getStoreWithHash() == null || (outputs = this.getOutputs()) == null || outputs.contains(field.getName())) continue;
                    fieldsToRemove.add(field.getName());
                }
                for (String fieldName : fieldsToRemove) {
                    for (Object obj : dataList) {
                        if (!(obj instanceof Map)) continue;
                        Map record = (Map)obj;
                        record.remove(fieldName);
                    }
                }
            }
            HashMap<String, Object> transformContext = new HashMap<String, Object>();
            transformContext.put("responseObjectsUnfiltered", unfilteredDataList);
            ds.applyEarlyResponseTransformations(this, dsResponse, transformContext);
            if (!Boolean.TRUE.equals(this.getAttribute("transformResponseApplied"))) {
                ds.transformResponse(dsResponse.getDataList(), this, dsResponse);
                this.setAttribute("transformResponseApplied", true);
            }
            ds.applyTransformResponseScript(this, dsResponse, transformContext);
            ds.applyFieldValueScripts(this, dsResponse);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executePostTransformOperations(DSResponse dsResponse) throws Exception {
        dsResponse.setParameter("_cameThruDsExecute", null);
        Object operationBinding = null;
        DataSource ds = this.getDataSource();
        if (ds != null) {
            operationBinding = ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        }
        if (operationBinding != null) {
            Map map;
            Object value;
            if (operationBinding.containsKey("exportResults")) {
                Boolean exportResults = (Boolean)operationBinding.get("exportResults");
                dsResponse.setExportResults(exportResults);
            }
            if (operationBinding.containsKey("exportFilename")) {
                dsResponse.setExportFilename((String)operationBinding.get("exportFilename"));
            }
            if (operationBinding.containsKey("exportAs")) {
                dsResponse.setExportAs((String)operationBinding.get("exportAs"));
            }
            if (operationBinding.containsKey("exportDelimiter")) {
                dsResponse.setExportDelimiter((String)operationBinding.get("exportDelimiter"));
            }
            if (operationBinding.containsKey("exportTitleSeparatorChar")) {
                dsResponse.setExportTitleSeparatorChar((String)operationBinding.get("exportTitleSeparatorChar"));
            }
            if (operationBinding.containsKey("lineBreakStyle")) {
                dsResponse.setLineBreakStyle((String)operationBinding.get("lineBreakStyle"));
            }
            if (operationBinding.containsKey("exportDisplay")) {
                dsResponse.setExportDisplay((String)operationBinding.get("exportDisplay"));
            }
            if (operationBinding.containsKey("exportHeader")) {
                dsResponse.setExportHeader((String)operationBinding.get("exportHeader"));
            }
            if (operationBinding.containsKey("exportHeaderless")) {
                dsResponse.setExportHeaderless(DataTools.asBoolean(operationBinding.get("exportHeaderless"), false));
            }
            if (operationBinding.containsKey("exportFooter")) {
                dsResponse.setExportFooter((String)operationBinding.get("exportFooter"));
            }
            if (operationBinding.containsKey("exportFields") && (value = (map = (Map)operationBinding.get("exportFields")).get(map.keySet().toArray()[0])) instanceof List) {
                dsResponse.setExportFields((List)value);
            }
            if (operationBinding.containsKey("exportDatesAsFormattedString")) {
                Boolean exportDatesAsFormattedString = (Boolean)operationBinding.get("exportDatesAsFormattedString");
                dsResponse.setExportDatesAsFormattedString(exportDatesAsFormattedString);
            }
            if (operationBinding.containsKey("exportNumbersAsFormattedString")) {
                Boolean exportNumbersAsFormattedString = (Boolean)operationBinding.get("exportNumbersAsFormattedString");
                dsResponse.setExportNumbersAsFormattedString(exportNumbersAsFormattedString);
            }
        }
        if (this.getRPCManager() == null && this.shouldExportToFilesystem() || this.getExportTo() != null || this.getExportObjectCalled()) {
            void var14_16;
            String lineBreakStyle;
            String string;
            this.copyExportSettingsToResponse(dsResponse);
            List<Object> data = new ArrayList();
            Iterator iterator = null;
            Object initData = dsResponse.getData();
            if (initData instanceof List) {
                data = (List)initData;
            } else if (initData instanceof Object[]) {
                Object[] arr = (Object[])initData;
                for (int i = 0; i < arr.length; ++i) {
                    data.add(arr[i]);
                }
            } else if (initData instanceof Iterator) {
                iterator = (Iterator)initData;
            } else {
                data.add(initData);
            }
            HashMap<String, String> fieldMap = this.getExportFieldTitles();
            boolean receivedTitleMap = true;
            if (fieldMap == null) {
                fieldMap = new HashMap<String, String>();
                receivedTitleMap = false;
            }
            ds = dsResponse.getDataSource() != null ? dsResponse.getDataSource() : this.getDataSource();
            List<String> fieldNames = dsResponse.getExportFields();
            ArrayList<String> finalFields = (ArrayList<String>)dsResponse.getParameter("exportFields");
            if (finalFields == null) {
                finalFields = new ArrayList<String>();
            }
            boolean createExportFields = finalFields.isEmpty();
            if (fieldNames == null || fieldNames.isEmpty()) {
                fieldNames = ds._getFieldNames();
            }
            if ((string = dsResponse.getExportAs()) != null) {
                String string2 = string.toLowerCase();
            }
            if ((lineBreakStyle = dsResponse.getLineBreakStyle()) != null) {
                lineBreakStyle = lineBreakStyle.toLowerCase();
            }
            Object separatorChar = dsResponse.getExportTitleSeparatorChar();
            HashMap<String, String> otherFields = (HashMap<String, String>)dsResponse.getParameter("exportOtherFields");
            if (otherFields == null) {
                otherFields = new HashMap<String, String>();
            }
            boolean createOtherFields = dsResponse.getParameter("exportHeaderSpans") == null && otherFields.isEmpty();
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = fieldNames.get(i);
                if (createOtherFields && !otherFields.containsKey(fieldName)) {
                    String fieldTitle = fieldName;
                    Map exportFieldTitles = this.getExportFieldTitles();
                    DSField field = ds.getField(fieldName);
                    if (exportFieldTitles != null && exportFieldTitles.containsKey(fieldName)) {
                        fieldTitle = (String)exportFieldTitles.get(fieldName);
                    } else if (field != null && !field.getBoolean("hidden")) {
                        String string3 = fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                    }
                    if (var14_16.equals("xml")) {
                        if (separatorChar == null) {
                            separatorChar = "";
                        }
                        if (fieldTitle == null) {
                            fieldTitle = fieldName;
                        }
                        fieldTitle = fieldTitle.replaceAll("[$&<>() ]", (String)separatorChar);
                    }
                    if (!receivedTitleMap) {
                        fieldMap.put(fieldName, fieldTitle);
                    }
                    otherFields.put(field != null ? field.getName() : fieldName, fieldTitle);
                }
                if (!createExportFields || finalFields.contains(fieldName)) continue;
                finalFields.add(fieldName);
            }
            LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
            settings.put("exportAs", var14_16);
            settings.put("lineBreakStyle", lineBreakStyle);
            settings.put("exportDelimiter", dsResponse.getExportDelimiter());
            settings.put("dataSource", ds);
            settings.put("exportFields", finalFields);
            settings.put("exportHeader", dsResponse.getExportHeader());
            settings.put("exportHeaderless", dsResponse.getExportHeaderless());
            settings.put("exportFooter", dsResponse.getExportFooter());
            settings.put("exportOtherFields", otherFields);
            settings.put("exportDatesAsFormattedString", dsResponse.getExportDatesAsFormattedString());
            settings.put("exportNumbersAsFormattedString", dsResponse.getExportNumbersAsFormattedString());
            settings.put("formulaFields", dsResponse.getParameter("formulaFields"));
            settings.put("formulaRemap", dsResponse.getParameter("formulaRemap"));
            settings.put("exportDefaultBGColor", dsResponse.getParameter("exportDefaultBGColor"));
            settings.put("exportAlternateRowBGColor", dsResponse.getParameter("exportAlternateRowBGColor"));
            settings.put("exportRowBGColors", dsResponse.getParameter("exportRowBGColors"));
            settings.put("exportColumnBGColors", dsResponse.getParameter("exportColumnBGColors"));
            settings.put("exportRawValues", dsResponse.getParameter("exportRawValues"));
            settings.put("exportCurrencySymbol", dsResponse.getParameter("exportCurrencySymbol"));
            settings.put("exportHeaderHeight", dsResponse.getParameter("exportHeaderHeight"));
            settings.put("exportHeaderSpans", dsResponse.getParameter("exportHeaderSpans"));
            settings.put("exportFieldPixelWidths", dsResponse.getParameter("exportFieldPixelWidths"));
            settings.put("exportWidthScale", dsResponse.getParameter("exportWidthScale"));
            settings.put("exportWrapHeaderTitles", dsResponse.getParameter("exportWrapHeaderTitles"));
            settings.put("exportAlignments", dsResponse.getParameter("exportAlignments"));
            settings.put("exportStreaming", dsResponse.getParameter("exportStreaming"));
            settings.put("exportPropertyIdentifier", dsResponse.getParameter("exportPropertyIdentifier"));
            settings.put("exportTZ", dsResponse.getParameter("exportTZ"));
            settings.put("exportValueFields", DataTools.asBooleanObject(dsResponse.getParameter("exportValueFields")));
            if (this.getValues(false) != null && this.getValues(false).size() != 0) {
                settings.put("useTitlesAsAttributeNames", true);
            } else {
                settings.put("useTitlesAsAttributeNames", false);
            }
            DataExport de = DataExport.getDataExport(settings, this);
            OutputStream os = null;
            Object qname = null;
            if (this.shouldExportToFilesystem()) {
                if (dsResponse.getExportTo() != null) {
                    os = dsResponse.getExportTo();
                } else if (!config.getBoolean((Object)"export.allow.filesystem", false)) {
                    log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                    dsResponse.setExportToFilesystem(false);
                } else {
                    qname = config.getPath("export.location");
                    if (qname == null) {
                        qname = "";
                    }
                    if (!((String)qname).endsWith("/") && ((String)qname).length() > 0) {
                        qname = (String)qname + "/";
                    }
                    if (!((String)(qname = (String)qname + dsResponse.getExportPath())).endsWith("/") && ((String)qname).length() > 0) {
                        qname = (String)qname + "/";
                    }
                    qname = (String)qname + dsResponse.getExportFilename();
                    os = new BufferedOutputStream((OutputStream)((Object)new AtomicFileOutputStream((String)qname)));
                    log.info("Trying to export to file " + (String)qname);
                }
            }
            if (iterator == null) {
                iterator = data.iterator();
            }
            de.exportResultSet(iterator, fieldMap, os, dsResponse);
            if (os != null) {
                os.close();
            }
        }
        if (operationBinding != null && operationBinding.get("mail") != null && !this.beenThroughMailProcessing) {
            List mailDefs;
            this.beenThroughMailProcessing = true;
            if (!(operationBinding.get("mail") instanceof List)) {
                mailDefs = new ArrayList();
                mailDefs.add(operationBinding.get("mail"));
            } else {
                mailDefs = (List)operationBinding.get("mail");
            }
            for (Map mail : mailDefs) {
                Boolean multiple;
                Object baseData = dsResponse.getData();
                String msgData = (String)mail.get("messageData");
                if (msgData != null) {
                    baseData = Velocity.evaluate(msgData, Velocity.getStandardContextMap(this));
                }
                ArrayList<Object> data = null;
                if (mail.get("multiple") != null && !(multiple = (Boolean)mail.get("multiple")).booleanValue()) {
                    data = new ArrayList();
                    if (baseData instanceof List) {
                        data.add(((List)baseData).get(0));
                    } else {
                        data.add(baseData);
                    }
                }
                if (data == null) {
                    if (baseData instanceof List) {
                        data = (ArrayList<Object>)baseData;
                    } else {
                        data = new ArrayList<Object>();
                        if (baseData != null) {
                            data.add(baseData);
                        }
                    }
                }
                String messageTemplate = (String)mail.get("messageTemplate");
                String templateFile = (String)mail.get("templateFile");
                if (templateFile == null && messageTemplate == null) {
                    log.warn("DataSource " + this.getDataSourceName() + ", operation " + String.valueOf(operationBinding.get("operationId")) + ": A <mail> defiition is given, but it does not provide a templateFile property or a <messageTemplate> element. One of these is required - it will form the body of the email.");
                    continue;
                }
                if (templateFile != null && messageTemplate != null) {
                    log.warn("DataSource " + this.getDataSourceName() + ", operation " + String.valueOf(operationBinding.get("operationId")) + ": The <mail> defiition for this operation provides both a templateFile property and a <messageTemplate> element. Only one of these is allowed - ignoring the templateFile property.");
                }
                for (Object e : data) {
                    void var14_20;
                    HashMap item;
                    block86: {
                        if (e instanceof Map) {
                            item = new HashMap((Map)e);
                        } else {
                            if (e instanceof JSONFilter) {
                                Object object = ((JSONFilter)e).getObj();
                                if (object instanceof Map) {
                                    item = new HashMap((Map)object);
                                    break block86;
                                } else {
                                    log.warn("Encountered non-Map object [" + String.valueOf(object) + "] while processing email definitions");
                                    continue;
                                }
                            }
                            log.warn("Encountered non-Map object [" + String.valueOf(e) + "] while processing email definitions");
                            continue;
                        }
                    }
                    TemplatedMailMessage msg = new TemplatedMailMessage(this);
                    if (mail.get("from") != null) {
                        msg.setFrom((String)mail.get("from"));
                    }
                    if (mail.get("replyTo") != null) {
                        msg.setReplyTo((String)mail.get("replyTo"));
                    }
                    if (mail.get("to") != null) {
                        msg.addRecipients((String)mail.get("to"), Message.RecipientType.TO);
                    }
                    if (mail.get("cc") != null) {
                        msg.addRecipients((String)mail.get("cc"), Message.RecipientType.CC);
                    }
                    if (mail.get("bcc") != null) {
                        msg.addRecipients((String)mail.get("bcc"), Message.RecipientType.BCC);
                    }
                    if (mail.get("subject") != null) {
                        msg.setSubject((String)mail.get("subject"));
                    }
                    if (mail.get("contentType") != null) {
                        msg.setContentType((String)mail.get("contentType"));
                    }
                    if (mail.get("encoding") != null) {
                        msg.setEncoding((String)mail.get("encoding"));
                    }
                    if (mail.get("host") != null) {
                        msg.setHost((String)mail.get("host"));
                    }
                    if (mail.get("port") != null) {
                        msg.setPort((String)mail.get("port"));
                    }
                    if (mail.get("auth") != null) {
                        msg.setAuth((String)mail.get("auth"));
                    }
                    if (mail.get("user") != null) {
                        msg.setUser((String)mail.get("user"));
                    }
                    if (mail.get("password") != null) {
                        msg.setPassword((String)mail.get("password"));
                    }
                    for (Object key : mail.keySet()) {
                        Object value;
                        if (knownMailProps.contains(key) || (value = mail.get(key)) == null || "".equals(((String)value).trim())) continue;
                        msg.setProperty((String)key, (String)value);
                    }
                    Map contextMap = DataTools.mapMerge(Velocity.getStandardContextMap(this), item);
                    msg.setContextMap(contextMap);
                    msg.setMessageTemplate(messageTemplate);
                    msg.setTemplateFile(templateFile);
                    IOWrapper.installWrappersToContext(contextMap, (Map)var14_20);
                    msg.buildMessage(new HashMap(), (String)null);
                    try {
                        msg.send();
                    }
                    catch (Exception e2) {
                        log.warn(e2);
                    }
                }
            }
        }
    }

    public synchronized Date getCurrentDate() {
        return this.getCurrentDateTime().toDate();
    }

    public synchronized Date getCurrentDateUTC() {
        return this.getCurrentDateTimeUTC().toDate();
    }

    public synchronized DateTime getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTime();
        }
        return this.currentDateTime;
    }

    public synchronized DateTime getCurrentDateTimeUTC() {
        return this.getCurrentDateTime().withZone(DateTimeZone.UTC);
    }

    private void applyFieldValue(String fieldName, Object value) throws Exception {
        boolean isKey = this.getDataSource().getPrimaryKeys().contains(fieldName);
        Map valueset = this.getValues();
        if (isKey && !DataSource.isAdd(this.getOperationType()) && !DataSource.isCustom(this.getOperationType())) {
            valueset = this.getCriteria();
            if (this.getIsAdvancedCriteria()) {
                this.setCriteriaValue(fieldName, value);
                return;
            }
        }
        valueset.put(fieldName, value);
    }

    private void applyFieldValueExpressions() throws Exception {
        if (this.isClientRequest() && !config.getBoolean((Object)"dataSource.allowClientFieldValueExpressions", true)) {
            return;
        }
        Map expressions = this.getFieldValueExpressions();
        if (expressions == null) {
            return;
        }
        Date currentDate = this.getCurrentDate();
        Map<Object, Object> params = Velocity.getStandardContextMap(this);
        for (String fieldName : expressions.keySet()) {
            String value = ((String)expressions.get(fieldName)).trim();
            if (this.isClientRequest()) {
                Object evaluated;
                if ("$currentDate".equals(value)) {
                    this.applyFieldValue(fieldName, currentDate);
                    continue;
                }
                if ("$transactionDate".equals(value)) {
                    if (this.getDsTransaction() != null) {
                        this.applyFieldValue(fieldName, params.get("transactionDate"));
                        continue;
                    }
                    this.applyFieldValue(fieldName, currentDate);
                    continue;
                }
                if ("$userId".equals(value)) {
                    this.applyFieldValue(fieldName, this.getUserId());
                    continue;
                }
                if ("$masterId".equals(value)) {
                    this.applyFieldValue(fieldName, this.getMasterId(fieldName, true));
                    continue;
                }
                if (this.isValidResponseDataExpression(value)) {
                    evaluated = Velocity.evaluate(value, params, this.getOperationId(), this.getDataSource(), false, true);
                    this.applyFieldValue(fieldName, evaluated);
                    continue;
                }
                if (this.isValidResponsesExpression(value)) {
                    evaluated = Velocity.evaluate(value, params, this.getOperationId(), this.getDataSource(), false, true);
                    this.applyFieldValue(fieldName, evaluated);
                    continue;
                }
                String msg = "Value '" + value + "' not allowed in fieldValueExpression: client-initiated fieldValueExpressions may only be one of the documented fixed variable names, prefixed with '$'.  Please scan the client-side docs for 'fieldValueExpressions'";
                log.warn(msg);
                throw new Exception(msg);
            }
            System.out.println("Evaluating '" + value + "' to '" + String.valueOf(Velocity.evaluate(value, params)) + "'");
            Velocity.setMasterIdHandler(params, this, fieldName);
            this.applyFieldValue(fieldName, Velocity.evaluate(value, params));
        }
    }

    public boolean isValidResponseDataExpression(String value) {
        Matcher matcher = responseDataPattern.matcher(value);
        return matcher.matches();
    }

    public boolean isValidResponsesExpression(String value) {
        Matcher matcher = responsesPattern.matcher(value);
        return matcher.matches();
    }

    public Object getMasterId(String fieldName, boolean warn) throws Exception {
        DSTransaction dsTransaction = this.getDsTransaction();
        if (dsTransaction == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - no DSTransaction");
            }
            return null;
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - no DataSource on this DSRequest");
            }
            return null;
        }
        DSField field = ds.getField(fieldName);
        if (field == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - field '" + fieldName + "' not found");
            }
            return null;
        }
        if (field.getForeignKey() == null) {
            if (warn) {
                log.warn("$masterId cannot be determined - field '" + fieldName + "' does not declare a foreignKey");
            }
            return null;
        }
        String[] fkElements = field.getForeignKey().split("\\.");
        DataSource otherDS = null;
        String otherFieldName = null;
        if (fkElements.length == 1) {
            otherDS = ds;
            otherFieldName = fkElements[0];
        } else {
            otherDS = dsTransaction.getDataSource(fkElements[0]);
            otherFieldName = fkElements[1];
        }
        if (otherDS == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the foreignKey definition (" + field.getForeignKey() + ") does not name a DataSource known to the system");
            }
            return null;
        }
        if (otherDS.getField(otherFieldName) == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the foreignKey definition (" + field.getForeignKey() + ") targets a field  that does not exist on the target DataSource");
            }
            return null;
        }
        DSResponse lastResponse = (DSResponse)dsTransaction.findLastResponse(otherDS.getName(), "add");
        if (lastResponse == null) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - no prior \"add\" operation to the master DataSource " + otherDS.getName() + " was found");
            }
            return null;
        }
        Map<String, Object> record = lastResponse.getRecord();
        if (!record.containsKey(otherFieldName)) {
            if (warn) {
                log.warn("$masterId cannot be determined for field '" + fieldName + "' - the response data for the prior \"add\" operation to the master DataSource " + otherDS.getName() + " did not contain a value for field \"" + otherFieldName + "\"");
            }
            return null;
        }
        return record.get(otherFieldName);
    }

    public Map getFieldValueExpressions() {
        return (Map)this.getParameter("fieldValueExpressions");
    }

    public DSRequest setFieldValueExpressions(Map fieldValueExpressions) {
        this.setParameter("fieldValueExpressions", fieldValueExpressions);
        return this;
    }

    public void buildFieldData(boolean overwrite) throws Exception {
        if (!overwrite && this.preparedFieldData) {
            return;
        }
        if (this.ds != null) {
            this.ds.reportAmbiguousIncFrom();
        }
        this.resetAmbiguousIncFromFields();
        if (DataSource.isFetch(this.getOperationType())) {
            this.recordTimingData("groupBy processing", TimingLogType.START);
            this.buildSummaryFields();
            this.recordTimingData("groupBy processing", TimingLogType.END);
        }
        if (DataSource.isFetch(this.getOperationType()) || DataSource.isAddOrUpdate(this.getOperationType())) {
            this.recordTimingData("outputs processing", TimingLogType.START);
            this.buildConsolidatedOutputs();
            this.recordTimingData("outputs processing", TimingLogType.END);
        }
        if (DataSource.isFetch(this.getOperationType())) {
            this.recordTimingData("expressions processing", TimingLogType.START);
            this.buildExpressionFields();
            this.recordTimingData("expressions processing", TimingLogType.END);
        }
        if (DataSource.isFetch(this.getOperationType()) || DataSource.isAddOrUpdate(this.getOperationType())) {
            this.recordTimingData("includeFrom processing", TimingLogType.START);
            this.includeFrom = this.buildIncludeFromDefinitions(this.getDataSource(), true, null);
            this.recordTimingData("includeFrom processing", TimingLogType.END);
        }
        this.checkForBogusOutputs();
        this.preparedFieldData = true;
    }

    private void rebuildFieldDataIfNeeded() {
        if (this.beenThroughDMI) {
            try {
                this.buildFieldData(true);
            }
            catch (Exception ex) {
                this.preparedFieldData = false;
            }
        }
    }

    private void checkForBogusOutputs() {
        if (this.ds == null) {
            return;
        }
        List reqOutputs = this.getOutputs();
        if (reqOutputs != null && reqOutputs.isEmpty()) {
            reqOutputs = null;
        }
        List<String> obOutputs = null;
        DataTypeMap opBinding = this.ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        if (opBinding != null && opBinding.get("outputs") != null) {
            Object outputsObj = opBinding.get("outputs");
            obOutputs = outputsObj instanceof List ? (List<String>)outputsObj : DataTools.commaSeparatedStringToList(outputsObj.toString());
        }
        if (obOutputs == null && reqOutputs != null && !this.ds._getFieldNames().containsAll(reqOutputs)) {
            this.consolidatedOutputs = null;
        }
    }

    private void buildConsolidatedOutputs() {
        if (this.ds == null) {
            return;
        }
        List<String> reqOutputs = this.getOutputs();
        if (reqOutputs != null && reqOutputs.isEmpty()) {
            reqOutputs = null;
        }
        List<String> obOutputs = null;
        DataTypeMap opBinding = this.ds.getOperationBinding(this.getOperationType(), this.getOperationId());
        if (opBinding != null && opBinding.get("outputs") != null) {
            Object outputsObj = opBinding.get("outputs");
            obOutputs = outputsObj instanceof List ? (List<String>)outputsObj : DataTools.commaSeparatedStringToList(outputsObj.toString());
        }
        if (obOutputs != null) {
            this.consolidatedOutputs = new ArrayList(obOutputs);
            if (reqOutputs != null) {
                droppedFields = new StringBuffer();
                for (String fieldName : reqOutputs) {
                    if (obOutputs.contains(fieldName)) continue;
                    if (((StringBuffer)droppedFields).length() > 0) {
                        ((StringBuffer)droppedFields).append(", ");
                    }
                    ((StringBuffer)droppedFields).append(fieldName);
                }
                if (((StringBuffer)droppedFields).length() > 0) {
                    log.info("DataSource '" + this.ds.getName() + "', OperationBinding: '" + this.getOperationId() + "': A DSRequest.outputs attribute specified fields that are not included in the OperationBinding.outputs attribute.  Dropping the following disallowed fields: " + String.valueOf(droppedFields));
                }
            }
        } else {
            if (reqOutputs != null) {
                this.consolidatedOutputs = new ArrayList();
            }
            for (String fieldName : reqOutputs != null ? reqOutputs : this.ds._getFieldNames()) {
                String outputWhen;
                DSField field = this.ds.getField(fieldName);
                String string = outputWhen = field != null ? (String)field.get("outputWhen") : null;
                if ("never".equals(outputWhen)) {
                    if (this.skippedFields == null) {
                        this.skippedFields = new ArrayList();
                    }
                    this.skippedFields.add(fieldName);
                    continue;
                }
                if ("single".equals(outputWhen)) {
                    if (this.isCacheSyncRequest()) {
                        if (this.consolidatedOutputs == null) continue;
                        this.consolidatedOutputs.add(fieldName);
                        continue;
                    }
                    if (this.criteriaHasPKs(this.getCriteria(), this.ds.getPrimaryKeys(), true)) {
                        if (this.consolidatedOutputs == null) continue;
                        this.consolidatedOutputs.add(fieldName);
                        continue;
                    }
                    if (this.skippedFields == null) {
                        this.skippedFields = new ArrayList();
                    }
                    this.skippedFields.add(fieldName);
                    continue;
                }
                if ("whenPresent".equals(outputWhen)) {
                    if (this.isCacheSyncRequest()) {
                        Map values = null;
                        Map oldValues = null;
                        DSRequest primaryReq = this.getPrimaryDSRequest();
                        if (primaryReq != null) {
                            values = primaryReq.getValues();
                            oldValues = primaryReq.getOldValues();
                        }
                        if (values != null && values.containsKey(fieldName) || oldValues != null && oldValues.containsKey(fieldName)) {
                            if (this.consolidatedOutputs == null) continue;
                            this.consolidatedOutputs.add(fieldName);
                            continue;
                        }
                        if (this.skippedFields == null) {
                            this.skippedFields = new ArrayList();
                        }
                        this.skippedFields.add(fieldName);
                        continue;
                    }
                    if (this.skippedFields == null) {
                        this.skippedFields = new ArrayList();
                    }
                    this.skippedFields.add(fieldName);
                    continue;
                }
                if (this.consolidatedOutputs == null) continue;
                this.consolidatedOutputs.add(fieldName);
            }
            if (this.skippedFields != null && this.skippedFields.size() > 0 && reqOutputs != null && !reqOutputs.isEmpty()) {
                droppedFields = new StringBuffer();
                for (String skipped : this.skippedFields) {
                    if (((StringBuffer)droppedFields).length() > 0) {
                        ((StringBuffer)droppedFields).append(", ");
                    }
                    ((StringBuffer)droppedFields).append(skipped);
                }
                log.warn("DataSource '" + this.ds.getName() + "', OperationBinding: '" + this.getOperationId() + "': A DSRequest.outputs attribute specified fields that are not matching requirements of the DSField.outputWhen attribute. Dropping the following fields: " + String.valueOf(droppedFields));
            }
        }
        if (this.consolidatedOutputs != null && this.consolidatedOutputs.isEmpty()) {
            this.consolidatedOutputs = null;
        }
    }

    public List getSkippedFields() {
        return this.skippedFields;
    }

    public boolean skipField(String fieldName) {
        return this.skippedFields != null && this.skippedFields.contains(fieldName);
    }

    private void buildExpressionFieldsFromCriteria() throws Exception {
        if (this.ds == null) {
            return;
        }
        boolean unionMode = Boolean.TRUE.equals(this.getAttribute("unionMode"));
        UnionDataSource unionDs = (UnionDataSource)this.getAttribute("unionDataSource");
        DataSource ds = this.getDataSource();
        if (this.getCriteria() != null) {
            Iterator<Object> i = ds.isAdvancedCriteria(this.getCriteria()) ? ds.extractFieldNamesFromAdvancedCriteria(this.getCriteria()).iterator() : this.getCriteria().keySet().iterator();
            while (i.hasNext()) {
                DSField unionField;
                String fieldName = (String)i.next();
                DSField field = ds.getField(fieldName);
                if (field == null) continue;
                if (unionMode && (unionField = unionDs.getRenamedField(ds, field, this)) != null) {
                    field = unionField;
                }
                this.addExpressionField(field, false);
            }
        }
    }

    private void buildExpressionFields() throws Exception {
        DataTypeMap opBinding;
        String paging;
        if (this.ds == null) {
            return;
        }
        boolean unionMode = Boolean.TRUE.equals(this.getAttribute("unionMode"));
        UnionDataSource unionDs = (UnionDataSource)this.getAttribute("unionDataSource");
        DataSource ds = this.getDataSource();
        Iterator<String> fieldIterator = this.getOutputs() != null && Boolean.TRUE.equals(this.getAttribute("enforceOutputsFieldOrder")) ? this.getOutputs().iterator() : ds._getFieldNames().iterator();
        while (fieldIterator.hasNext()) {
            DSField unionField;
            String fieldName = fieldIterator.next();
            DSField field = ds.getField(fieldName);
            if (unionMode && (unionField = ds.getField(unionDs.getOriginalFieldName(ds, fieldName, this))) != null) {
                field = unionField;
            }
            if (field == null && !unionMode || (this.isSummary() ? !this.summaryFields.contains(fieldName) : this.consolidatedOutputs != null && !this.consolidatedOutputs.contains(fieldName))) continue;
            this.addExpressionField(field, false, fieldName);
        }
        this.buildExpressionFieldsFromCriteria();
        boolean sortClause = false;
        List sortBy = this.getSortByFields();
        if (sortBy != null && sortBy.size() != 0) {
            for (String fieldName : sortBy) {
                if ("-".equals(fieldName.substring(0, 1))) {
                    fieldName = fieldName.substring(1);
                }
                DSField field = ds.getField(fieldName);
                if (unionMode && field == null) {
                    field = ds.getField(unionDs.getOriginalFieldName(ds, fieldName, this));
                }
                if (field != null) {
                    this.addExpressionField(field, true);
                    sortClause = true;
                    continue;
                }
                String[] elements = fieldName.split("\\.");
                if (elements.length <= 1) continue;
                this.addExpressionField(fieldName);
                sortClause = true;
            }
        }
        if ((this.isPaged() || this.isValueOperation()) && ("sqlLimit".equals(paging = ds.getSQLPaging(this, (Map)((Object)(opBinding = ds.getOperationBinding(this))))) || this.isValueOperation()) && ds.shouldForceSort(this)) {
            List<String> sortFields;
            String dbType = ds.getDBType();
            if (!(sortClause && "sqlserver".equals(dbType) && config.getBoolean((Object)"sql.sqlserver.legacyLimitBehavior", false) || (sortFields = this.getForceSortFieldNames()) == null)) {
                for (int i = 0; i < sortFields.size(); ++i) {
                    this.addExpressionField(ds.getField(sortFields.get(i)), true);
                }
            }
        }
    }

    public List<String> getForceSortFieldNames() {
        ArrayList<String> sortBy = null;
        try {
            List<String> summaryFields;
            List<String> pkList = this.getDataSource().getPrimaryKeys();
            String defaultSortField = this.getDataSource().getConfig().getString("defaultSortField");
            if (defaultSortField != null) {
                sortBy = new ArrayList<String>();
                sortBy.add(defaultSortField);
            }
            List<String> list = summaryFields = this.isSummary() ? this.getSummaryFields() : null;
            if (sortBy == null && !pkList.isEmpty()) {
                for (String fieldName : pkList) {
                    if (fieldName == null || summaryFields != null && !summaryFields.contains(fieldName)) continue;
                    if (sortBy == null) {
                        sortBy = new ArrayList();
                    }
                    sortBy.add(fieldName);
                }
            }
            if (sortBy == null || sortBy.isEmpty()) {
                if (summaryFields != null && !summaryFields.isEmpty()) {
                    sortBy = new ArrayList();
                    sortBy.add(summaryFields.get(0));
                } else {
                    sortBy = new ArrayList();
                    sortBy.add(this.getDataSource()._getFieldNames().get(0));
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception trying to determine forceSort fields", e);
        }
        return sortBy;
    }

    public List<String> parseTemplate(DSField field) {
        int close;
        ArrayList<String> expressions = null;
        Object templateObj = field.get("template");
        if (templateObj == null) {
            return null;
        }
        String template = templateObj instanceof Map ? (String)((Map)templateObj).get("text") : (String)templateObj;
        int start = 0;
        int varIndex = template.indexOf("#{");
        while (varIndex >= 0 && (close = template.indexOf(SQL_PARAM_SUFFIX, varIndex + 2)) >= 0) {
            String var = template.substring(varIndex + 2, close).trim();
            if (!"".equals(var)) {
                if (expressions == null) {
                    expressions = new ArrayList<String>();
                }
                expressions.add(var);
            }
            start = varIndex + 2 + var.length() + 1;
            varIndex = template.indexOf("#{", start);
        }
        return expressions;
    }

    private DSRequest addExpressionField(String fieldName) {
        if (this.expressionFields == null) {
            this.expressionFields = new ArrayList<String>();
        }
        if (!this.expressionFields.contains(fieldName)) {
            this.expressionFields.add(fieldName);
        }
        return this;
    }

    private DSRequest addExpressionField(DSField field, boolean sorting) {
        return this.addExpressionField(field, sorting, null);
    }

    private DSRequest addExpressionField(DSField field, boolean sorting, String overrideFieldName) {
        if (field != null) {
            List<String> fields;
            this.addExpressionField(overrideFieldName == null ? field.getName() : overrideFieldName);
            if (sorting) {
                if (this.sortExpressionFields == null) {
                    this.sortExpressionFields = new ArrayList<String>();
                }
                this.sortExpressionFields.add(overrideFieldName == null ? field.getName() : overrideFieldName);
            }
            if ((fields = this.parseTemplate(field)) != null) {
                for (String f : fields) {
                    this.addExpressionField(f);
                    if (!sorting) continue;
                    if (this.sortExpressionFields == null) {
                        this.sortExpressionFields = new ArrayList<String>();
                    }
                    this.sortExpressionFields.add(f);
                }
            }
        }
        return this;
    }

    public List<String> getExpressionFields() {
        return this.expressionFields;
    }

    public Object getExpressions() {
        return this.expressions;
    }

    public DSRequest setExpressions(Object expressions) {
        this.expressions = expressions;
        return this;
    }

    public DSRequest addExpression(String fieldName, Object expression) {
        if (this.expressions == null) {
            this.expressions = new LinkedHashMap();
        }
        ((Map)this.expressions).put(fieldName, expression);
        return this;
    }

    public DSRequest removeExpression(String fieldName) {
        if (this.expressions != null && this.expressions instanceof Map) {
            ((Map)this.expressions).remove(fieldName);
        }
        return this;
    }

    public List<String> getSortExpressionFields() {
        return this.sortExpressionFields;
    }

    public DSRequest setSummaryFunction(boolean summaryFunction) {
        this.summaryFunction = summaryFunction;
        return this;
    }

    public boolean isSummaryFunction() {
        return this.summaryFunction;
    }

    public DSRequest setValueOperation(boolean valueOperation) {
        this.valueOperation = valueOperation;
        return this;
    }

    public boolean isValueOperation() {
        return this.valueOperation;
    }

    public Relation getSubqueryRelations() {
        return this.subqueryRelations;
    }

    public DSRequest setSubqueryRelations(Relation subqueryRelations) {
        this.subqueryRelations = subqueryRelations;
        return this;
    }

    public Relation getSubqueryConnector() {
        return this.subqueryConnector;
    }

    public DSRequest setSubqueryConnector(Relation subqueryConnector) {
        this.subqueryConnector = subqueryConnector;
        return this;
    }

    public String addQueryField(Map queryField) {
        Object criteria;
        if (this.queryFields == null) {
            this.queryFields = new HashMap<String, Map>();
        }
        if ((criteria = queryField.get("criteria")) instanceof List) {
            this.collectQueryFieldsRecursively((List)criteria);
        } else if (criteria instanceof Map) {
            this.collectQueryFieldsFromAdvancedCriteria((Map)criteria);
        }
        String queryFieldId = QUERY_FIELD_NAME_PREFIX + this.queryFields.size();
        this.queryFields.put(queryFieldId, queryField);
        return queryFieldId;
    }

    public Map<String, Map> getQueryFields() {
        return this.queryFields;
    }

    public boolean isQueryField(String fieldName) {
        return fieldName != null && fieldName.startsWith(QUERY_FIELD_NAME_PREFIX);
    }

    public String addStaticValueField(Map fieldStaticMap) {
        if (this.staticValueFields == null) {
            this.staticValueFields = new HashMap<String, Map>();
        }
        String staticValueFieldId = STATIC_VALUE_FIELD_NAME_PREFIX + this.staticValueFields.size();
        this.staticValueFields.put(staticValueFieldId, fieldStaticMap);
        return staticValueFieldId;
    }

    public Map<String, Map> getStaticValueFields() {
        return this.staticValueFields;
    }

    public boolean isStaticValueField(String fieldName) {
        return fieldName != null && fieldName.startsWith(STATIC_VALUE_FIELD_NAME_PREFIX);
    }

    public DSRequest copyExportSettingsToResponse(DSResponse dsResponse) {
        dsResponse.setExportResults(this.getExportResults());
        if (dsResponse.getExportAs() == null || dsResponse.getExportAs() == "") {
            dsResponse.setExportAs(this.getExportAs());
        }
        if (dsResponse.getExportFilename() == null || dsResponse.getExportFilename() == "") {
            dsResponse.setExportFilename(this.getExportFilename());
        }
        if (dsResponse.getExportPath() == null || dsResponse.getExportPath() == "") {
            dsResponse.setExportPath(this.getExportPath());
        }
        if (dsResponse.getExportDelimiter() == null || dsResponse.getExportDelimiter() == "") {
            dsResponse.setExportDelimiter(this.getExportDelimiter());
        }
        if (dsResponse.getExportDisplay() == null || dsResponse.getExportDisplay() == "") {
            dsResponse.setExportDisplay(this.getExportDisplay());
        }
        if (dsResponse.getLineBreakStyle() == null || dsResponse.getLineBreakStyle() == "") {
            dsResponse.setLineBreakStyle(this.getLineBreakStyle());
        }
        if (dsResponse.getExportFields() == null || dsResponse.getExportFields().isEmpty()) {
            dsResponse.setExportFields(this.getExportFields());
        }
        if (dsResponse.getExportFieldTitles() == null || dsResponse.getExportFieldTitles().isEmpty()) {
            dsResponse.setExportFieldTitles(this.getExportFieldTitles());
        }
        if (dsResponse.getExportHeader() == null || dsResponse.getExportHeader().length() == 0) {
            dsResponse.setExportHeader(this.getExportHeader());
        }
        if (!dsResponse.getExportHeaderless()) {
            dsResponse.setExportHeaderless(this.getExportHeaderless());
        }
        if (dsResponse.getExportFooter() == null || dsResponse.getExportFooter().length() == 0) {
            dsResponse.setExportFooter(this.getExportFooter());
        }
        if (dsResponse.getExportTitleSeparatorChar() == null) {
            dsResponse.setExportTitleSeparatorChar(this.getExportTitleSeparatorChar());
        }
        if (dsResponse.shouldExportToClient() == null) {
            dsResponse.setExportToClient(this.shouldExportToClient());
        }
        if (dsResponse.shouldExportToFilesystem() == null) {
            dsResponse.setExportToFilesystem(this.shouldExportToFilesystem());
        }
        if (dsResponse.getExportTo() == null) {
            dsResponse.setExportTo(this.getExportTo());
        }
        if (dsResponse.getParameter("exportHeaderSpans") == null) {
            dsResponse.setParameter("exportHeaderSpans", this.getParameter("exportHeaderSpans"));
        }
        if (dsResponse.getParameter("exportOtherFields") == null) {
            dsResponse.setParameter("exportOtherFields", this.getParameter("exportOtherFields"));
        }
        if (dsResponse.getExportDatesAsFormattedString() == null) {
            dsResponse.setExportDatesAsFormattedString(this.getExportDatesAsFormattedString());
        }
        if (dsResponse.getExportNumbersAsFormattedString() == null) {
            dsResponse.setExportNumbersAsFormattedString(this.getExportNumbersAsFormattedString());
        }
        if (dsResponse.getParameter("formulaFields") == null) {
            dsResponse.setParameter("formulaFields", this.getParameter("formulaFields"));
        }
        if (dsResponse.getParameter("formulaRemap") == null) {
            dsResponse.setParameter("formulaRemap", this.getParameter("formulaRemap"));
        }
        if (dsResponse.getParameter("exportDefaultBGColor") == null) {
            dsResponse.setParameter("exportDefaultBGColor", this.getParameter("exportDefaultBGColor"));
        }
        if (dsResponse.getParameter("exportAlternateRowBGColor") == null) {
            dsResponse.setParameter("exportAlternateRowBGColor", this.getParameter("exportAlternateRowBGColor"));
        }
        if (dsResponse.getParameter("exportRowBGColors") == null) {
            dsResponse.setParameter("exportRowBGColors", this.getParameter("exportRowBGColors"));
        }
        if (dsResponse.getParameter("exportColumnBGColors") == null) {
            dsResponse.setParameter("exportColumnBGColors", this.getParameter("exportColumnBGColors"));
        }
        if (dsResponse.getParameter("exportRawValues") == null) {
            dsResponse.setParameter("exportRawValues", this.getParameter("exportRawValues"));
        }
        if (dsResponse.getParameter("exportCurrencySymbol") == null) {
            dsResponse.setParameter("exportCurrencySymbol", this.getParameter("exportCurrencySymbol"));
        }
        if (dsResponse.getParameter("exportHeaderHeight") == null) {
            dsResponse.setParameter("exportHeaderHeight", this.getParameter("exportHeaderHeight"));
        }
        if (dsResponse.getParameter("exportFieldPixelWidths") == null) {
            dsResponse.setParameter("exportFieldPixelWidths", this.getParameter("exportFieldPixelWidths"));
        }
        if (dsResponse.getParameter("exportWidthScale") == null) {
            dsResponse.setParameter("exportWidthScale", this.getParameter("exportWidthScale"));
        }
        if (dsResponse.getParameter("exportWrapHeaderTitles") == null) {
            dsResponse.setParameter("exportWrapHeaderTitles", this.getParameter("exportWrapHeaderTitles"));
        }
        if (dsResponse.getParameter("exportAlignments") == null) {
            dsResponse.setParameter("exportAlignments", this.getParameter("exportAlignments"));
        }
        if (dsResponse.getParameter("exportStreaming") == null) {
            dsResponse.setParameter("exportStreaming", this.getParameter("exportStreaming"));
        }
        if (dsResponse.getParameter("exportPropertyIdentifier") == null) {
            dsResponse.setParameter("exportPropertyIdentifier", this.getParameter("exportPropertyIdentifier"));
        }
        if (dsResponse.getParameter("exportTZ") == null) {
            dsResponse.setParameter("exportTZ", this.getParameter("exportTZ"));
        }
        if (dsResponse.getParameter("exportValueFields") == null) {
            dsResponse.setParameter("exportValueFields", this.getParameter("exportValueFields"));
        }
        return this;
    }

    public Set<String> getSnippetNames() {
        HashSet<String> combined = new HashSet<String>(this.snippets);
        if (this.getDsTransaction() != null && this.getDsTransaction().getSnippetNames() != null) {
            combined.addAll(this.getDsTransaction().getSnippetNames());
        }
        return combined;
    }

    public DSRequest addToTemplateContext(String name, Object value) {
        this.addToTemplateContext(name, value, false);
        return this;
    }

    public DSRequest addToTemplateContext(String name, Object value, boolean isSnippet) {
        this.templateContext.put(name, value);
        if (isSnippet) {
            this.snippets.add(name);
        }
        return this;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public DSRequest addToScriptContext(String name, Object value) {
        this.scriptContext.put(name, value);
        return this;
    }

    public DSRequest removeFromScriptContext(String name) {
        this.scriptContext.remove(name);
        return this;
    }

    public Map getScriptContext() {
        return this.scriptContext;
    }

    public void finalize() throws Throwable {
        if (!this.resourcesFreed) {
            this.freeResources();
        }
    }

    public String getAppID() {
        return (String)this.getParameter("appID");
    }

    public DSRequest setAppID(String appID) {
        this.setParameter("appID", appID);
        this.app = null;
        return this;
    }

    public AppBase getApp() throws Exception {
        if (this.app == null) {
            this.app = AppBase.findByAppID(this.getAppID());
        }
        return this.app;
    }

    public DSRequest setAllowMultiUpdate(boolean newValue) {
        this._allowMultiUpdate = newValue;
        return this;
    }

    public boolean isAllowMultiUpdateExplicitlySet() {
        return this._allowMultiUpdate != null;
    }

    public boolean getAllowMultiUpdate() {
        Boolean multiUpdate;
        Object opBinding = null;
        try {
            opBinding = this.getDataSource().getOperationBinding(this.getOperationType(), this.getOperationId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (opBinding != null && (multiUpdate = (Boolean)opBinding.get("allowMultiUpdate")) != null) {
            return multiUpdate;
        }
        if (this._allowMultiUpdate != null) {
            return this._allowMultiUpdate;
        }
        String defaultMultiUpdatePolicy = null;
        try {
            defaultMultiUpdatePolicy = (String)this.getDataSource().getConfig().get("defaultMultiUpdatePolicy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultMultiUpdatePolicy == null || "".equals(defaultMultiUpdatePolicy.trim())) {
            defaultMultiUpdatePolicy = config.getString("datasources.defaultMultiUpdatePolicy", "rpcManager");
        }
        if ("never".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return true;
        }
        if ("clientRequest".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return !this.isClientRequest();
        }
        if ("rpcManager".equalsIgnoreCase(defaultMultiUpdatePolicy)) {
            return this.getRPCManager() == null;
        }
        if ("always".equals(defaultMultiUpdatePolicy)) {
            return false;
        }
        return false;
    }

    public DSRequest setAllowArbitrarySubqueries(boolean newValue) {
        this._allowArbitrarySubqueries = newValue;
        return this;
    }

    public boolean allowArbitrarySubqueries() {
        return this._allowArbitrarySubqueries;
    }

    public Object constraints() {
        return this.constraints;
    }

    public DSRequest addConstraints(Object obj) {
        List newConstraints;
        if (obj == null) {
            return this;
        }
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        if ((newConstraints = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.constraints = null;
            return this;
        }
        DataTools.addDisjunctionToSet((List)this.constraints, newConstraints);
        return this;
    }

    public List outputs() {
        return this.outputs;
    }

    public List getOutputs() {
        return this.outputs;
    }

    public DSRequest setOutputs(List outputs) {
        this.outputs = outputs;
        this.rebuildFieldDataIfNeeded();
        return this;
    }

    public DSRequest addOutputs(Object obj) {
        List addedOutputs;
        if (obj == null) {
            return this;
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        if ((addedOutputs = DataTools.makeListIfSingle(obj)).contains("*")) {
            this.outputs = null;
            return this;
        }
        DataTools.addDisjunctionToSet(this.outputs, addedOutputs);
        return this;
    }

    public List getAdditionalOutputs() {
        if (this.additionalOutputs == null) {
            this.additionalOutputs = new ArrayList();
            String additionalOutputsString = (String)this.getParameter("additionalOutputs");
            if (additionalOutputsString != null) {
                String[] additionalOutputsList;
                for (String singleAdditionalOutput : additionalOutputsList = additionalOutputsString.split(",")) {
                    if (!singleAdditionalOutput.contains("!")) continue;
                    String[] properties = singleAdditionalOutput.split("!");
                    HashMap<String, Object> fieldData = new HashMap<String, Object>();
                    fieldData.put("includeFrom", properties[1]);
                    if (properties[0] == null || properties[0].trim().equals("")) {
                        if (properties[1].contains(".")) {
                            fieldData.put("name", properties[1].substring(properties[1].lastIndexOf(".") + 1));
                        } else {
                            fieldData.put("name", properties[1]);
                        }
                    } else {
                        fieldData.put("name", properties[0]);
                    }
                    fieldData.put("type", "text");
                    fieldData.put("additionalOutput", true);
                    this.additionalOutputs.add(new DSField((Map)fieldData));
                }
            }
        }
        return this.additionalOutputs;
    }

    public DSField getAdditionalOutputsField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (DSField field : this.getAdditionalOutputs()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public Map operationConfig() {
        return this.operationConfig;
    }

    public DSRequest setOperationConfig(Map operationConfig) {
        this.operationConfig = operationConfig;
        return this;
    }

    public Map getOperationConfig() {
        return this.operationConfig;
    }

    public Object getOperationProperty(String property) {
        if (this.operationConfig == null || property == null) {
            return null;
        }
        return this.operationConfig.get(property);
    }

    public Object getOperationProperty(String property, Object defaultValue) {
        Object value = this.getOperationProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public DSRequest setOperationProperty(String property, Object value) {
        if (this.operationConfig == null) {
            this.operationConfig = new HashMap();
        }
        if (property != null) {
            this.operationConfig.put(property, value);
        }
        return this;
    }

    public boolean forceInvalidateCache() {
        return this.forceInvalidateCache;
    }

    public DSRequest forceInvalidateCache(boolean value) {
        this.forceInvalidateCache = value;
        return this;
    }

    public DSRequest setValidatedValues(Object values) {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            log.warn("setValidatedValues called more than once for this DSRequest object");
            return this;
        }
        this.requestData.put("_unvalidatedValues", this.getRawValues());
        this.setValues(values);
        return this;
    }

    public Object getUnvalidatedValues() {
        if (this.requestData.containsKey("_unvalidatedValues")) {
            return this.requestData.get("_unvalidatedValues");
        }
        return this.getRawValues();
    }

    public boolean getExportResults() {
        if (this.getParameter("exportResults") == null) {
            return false;
        }
        return (Boolean)this.getParameter("exportResults");
    }

    public DSRequest setExportResults(Boolean exportResults) {
        if (exportResults == null) {
            exportResults = Boolean.FALSE;
        }
        this.setParameter("exportResults", exportResults);
        return this;
    }

    public DSRequest setExportResults(boolean exportResults) {
        this.setParameter("exportResults", exportResults);
        return this;
    }

    public String getExportAs() {
        return (String)this.getParameter("exportAs");
    }

    public DSRequest setExportAs(String exportAs) {
        this.setParameter("exportAs", exportAs);
        return this;
    }

    public String getExportDelimiter() {
        return (String)this.getParameter("exportDelimiter");
    }

    public DSRequest setExportDelimiter(String exportDelimiter) {
        this.setParameter("exportDelimiter", exportDelimiter);
        return this;
    }

    public String getExportTitleSeparatorChar() {
        return (String)this.getParameter("exportTitleSeparatorChar");
    }

    public DSRequest setExportTitleSeparatorChar(String exportTitleSeparatorChar) {
        this.setParameter("exportTitleSeparatorChar", exportTitleSeparatorChar);
        return this;
    }

    public String getExportFilename() {
        return (String)this.getParameter("exportFilename");
    }

    public DSRequest setExportFilename(String exportFilename) {
        this.setParameter("exportFilename", exportFilename);
        return this;
    }

    public String getExportPath() {
        return (String)this.getParameter("exportPath");
    }

    public DSRequest setExportPath(String exportPath) {
        this.setParameter("exportPath", exportPath);
        return this;
    }

    public String getExportDisplay() {
        return (String)this.getParameter("exportDisplay");
    }

    public DSRequest setExportDisplay(String exportDisplay) {
        this.setParameter("exportDisplay", exportDisplay);
        return this;
    }

    public String getLineBreakStyle() {
        return (String)this.getParameter("lineBreakStyle");
    }

    public DSRequest setLineBreakStyle(String lineBreakStyle) {
        this.setParameter("lineBreakStyle", lineBreakStyle);
        return this;
    }

    public List getExportFields() {
        return (List)this.getParameter("exportFields");
    }

    public DSRequest setExportFields(List exportFields) {
        this.setParameter("exportFields", exportFields);
        return this;
    }

    public Map getExportFieldTitles() {
        return (Map)this.getParameter("exportFieldTitles");
    }

    public DSRequest setExportFieldTitles(Map exportFieldTitles) {
        this.setParameter("exportFieldTitles", exportFieldTitles);
        return this;
    }

    public List getHashedFields() {
        return (List)this.getParameter("hashedFields");
    }

    public DSRequest setHashedFields(List hashedFields) {
        this.setParameter("hashedFields", hashedFields);
        return this;
    }

    public String getExportHeader() {
        return (String)this.getParameter("exportHeader");
    }

    public DSRequest setExportHeader(String exportHeader) {
        this.setParameter("exportHeader", exportHeader);
        return this;
    }

    public boolean getExportHeaderless() {
        return DataTools.asBoolean(this.getParameter("exportHeaderless"), false);
    }

    public DSRequest setExportHeaderless(boolean exportHeaderless) {
        this.setParameter("exportHeaderless", exportHeaderless);
        return this;
    }

    public String getExportFooter() {
        return (String)this.getParameter("exportFooter");
    }

    public DSRequest setExportFooter(String exportFooter) {
        this.setParameter("exportFooter", exportFooter);
        return this;
    }

    public DSRequest setExportDatesAsFormattedString(boolean exportDatesAsFormattedString) {
        return this.setExportDatesAsFormattedString((Boolean)exportDatesAsFormattedString);
    }

    public DSRequest setExportDatesAsFormattedString(Boolean exportDatesAsFormattedString) {
        this.setParameter("exportDatesAsFormattedString", exportDatesAsFormattedString);
        return this;
    }

    public Boolean getExportDatesAsFormattedString() {
        return (Boolean)this.getParameter("exportDatesAsFormattedString");
    }

    public DSRequest setExportNumbersAsFormattedString(boolean exportNumbersAsFormattedString) {
        return this.setExportNumbersAsFormattedString((Boolean)exportNumbersAsFormattedString);
    }

    public DSRequest setExportNumbersAsFormattedString(Boolean exportNumbersAsFormattedString) {
        this.setParameter("exportNumbersAsFormattedString", exportNumbersAsFormattedString);
        return this;
    }

    public Boolean getExportNumbersAsFormattedString() {
        return (Boolean)this.getParameter("exportNumbersAsFormattedString");
    }

    public DSRequest setStreamResults(boolean streamResults) {
        this.setParameter("streamResults", streamResults);
        return this;
    }

    public boolean shouldStreamResults() {
        return DataTools.asBoolean(this.getParameter("streamResults"), false) && !DataTools.asBoolean(this.getAttribute(RUNNING_ROWCOUNT_QUERY_MARKER), false);
    }

    public DSRequest setExportToFilesystem(boolean exportToFilesystem) {
        this.setParameter("exportToFilesystem", exportToFilesystem);
        return this;
    }

    public boolean shouldExportToFilesystem() {
        return DataTools.asBoolean(this.getParameter("exportToFilesystem"), false);
    }

    public DSRequest setExportToClient(boolean exportToClient) {
        this.setParameter("exportToClient", exportToClient);
        return this;
    }

    public boolean shouldExportToClient() {
        return DataTools.asBoolean(this.getParameter("exportToClient"), true);
    }

    public DSRequest setExportDefaultBGColor(String exportDefaultBGColor) {
        this.setParameter("exportDefaultBGColor", exportDefaultBGColor);
        return this;
    }

    public String getExportDefaultBGColor() {
        return (String)this.getParameter("exportDefaultBGColor");
    }

    public DSRequest setExportAlternateRowBGColor(String exportAlternateRowBGColor) {
        this.setParameter("exportAlternateRowBGColor", exportAlternateRowBGColor);
        return this;
    }

    public String getExportAlternateRowBGColor() {
        return (String)this.getParameter("exportAlternateRowBGColor");
    }

    public DSRequest setExportRowBGColors(Map exportRowBGColors) {
        this.setParameter("exportRowBGColors", exportRowBGColors);
        return this;
    }

    public Map getExportRowBGColors() {
        return (Map)this.getParameter("exportRowBGColors");
    }

    public DSRequest setExportColumnBGColors(Map exportColumnBGColors) {
        this.setParameter("exportColumnBGColors", exportColumnBGColors);
        return this;
    }

    public Map getExportColumnBGColors() {
        return (Map)this.getParameter("exportColumnBGColors");
    }

    public OutputStream getExportTo() {
        return this.exportOutputStream;
    }

    public DSRequest setExportTo(OutputStream exportOutputStream) {
        this.exportOutputStream = exportOutputStream;
        if (exportOutputStream != null) {
            this.setExportToFilesystem(true);
        }
        return this;
    }

    public Boolean getREST() {
        return Boolean.TRUE.equals((Boolean)this.getParameter("REST"));
    }

    public DSRequest setREST(Boolean isREST) {
        this.setParameter("REST", isREST);
        return this;
    }

    public Boolean getRawREST() {
        return Boolean.TRUE.equals((Boolean)this.getParameter("rawREST"));
    }

    public DSRequest setRawREST(Boolean isRawREST) {
        this.setParameter("rawREST", isRawREST);
        return this;
    }

    public String getDataFormat() {
        return (String)this.getParameter("dataFormat");
    }

    public DSRequest setDataFormat(String dataFormat) {
        if (!"xml".equalsIgnoreCase(dataFormat) && !"json".equalsIgnoreCase(dataFormat)) {
            throw new IllegalArgumentException("Accepted values: xml, json. Passed value:" + dataFormat);
        }
        this.setParameter("dataFormat", dataFormat.toLowerCase());
        return this;
    }

    public Boolean getWrapJSONResponses() {
        return Boolean.TRUE.equals(this.getParameter("wrapJSONResponses"));
    }

    public DSRequest setWrapJSONResponses(Boolean wrapJSONResponses) {
        this.setParameter("wrapJSONResponses", wrapJSONResponses);
        return this;
    }

    public String getJsonPrefix() {
        return (String)this.getParameter("jsonPrefix");
    }

    public DSRequest setJsonPrefix(String jsonPrefix) {
        this.setParameter("jsonPrefix", jsonPrefix);
        return this;
    }

    public String getJsonSuffix() {
        return (String)this.getParameter("jsonSuffix");
    }

    public DSRequest setJsonSuffix(String jsonSuffix) {
        this.setParameter("jsonSuffix", jsonSuffix);
        return this;
    }

    public boolean passesSecurityChecks() throws Exception {
        return this.passesSecurityChecks(null, null);
    }

    boolean passesSecurityChecks(DataSource ds, String fieldName) throws Exception {
        return DeclarativeSecurity.dsRequestPassesSecurityChecks(this, ds, fieldName);
    }

    boolean checkRelatedSecurity(DataSource ds, String fieldName) throws Exception {
        List includeFromList = null;
        includeFromList = fieldName != null ? this.buildIncludeFromDefinitions(ds, false, fieldName) : this.includeFrom;
        for (IncludeFromDefinition incFrom : includeFromList) {
            if (incFrom.getDataSources() == null || incFrom.getDataSources().length == 0) continue;
            for (Relation r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
                DataSource relatedDS = r.getToDataSource();
                for (DSField toField : r.getToFields()) {
                    if (!this.passesSecurityChecks(relatedDS, toField.getName())) {
                        this.securityFailureMessage = "Security check on related DataSource '" + relatedDS.getName() + "', required for included field '" + toField.getName() + "', failed.  Failure message is: \"" + this.securityFailureMessage + "\"";
                        return false;
                    }
                    if (relatedDS.getName().equals(incFrom.getDataSourceName()) || this.checkedDataSources.contains(relatedDS.getName())) continue;
                    this.checkedDataSources.add(relatedDS.getName());
                }
            }
            if (!this.passesSecurityChecks(incFrom.getDataSource(), incFrom.getIncludedFieldName())) {
                this.securityFailureMessage = "Security check on related DataSource '" + ds.getName() + "', required for included field '" + incFrom.getThisFieldName() + "', failed.  Failure message is: \"" + this.securityFailureMessage + "\"";
                return false;
            }
            if (this.checkedDataSources.contains(incFrom.getDataSourceName())) continue;
            this.checkedDataSources.add(incFrom.getDataSourceName());
        }
        return true;
    }

    public DSRequest removeField(String fieldName, boolean isFetch) {
        return this.removeField(fieldName, isFetch, 0);
    }

    public DSRequest removeField(String fieldName, boolean isFetch, int valueSetIndex) {
        Object fieldValue = ((Map)this.getValueSets().get(valueSetIndex)).get(fieldName);
        if (this.droppedFieldValues == null) {
            this.droppedFieldValues = new ArrayList<Map>();
        }
        if (this.droppedFieldValues.size() <= valueSetIndex || this.droppedFieldValues.get(valueSetIndex) == null) {
            while (this.droppedFieldValues.size() < valueSetIndex) {
                this.droppedFieldValues.add(new HashMap());
            }
            this.droppedFieldValues.add(valueSetIndex, new HashMap());
        }
        if (!this.droppedFieldValues.get(valueSetIndex).keySet().contains(fieldName)) {
            this.droppedFieldValues.get(valueSetIndex).put(fieldName, fieldValue);
        }
        if (isFetch) {
            if (this.droppedFields == null) {
                this.droppedFields = new ArrayList();
            }
            if (!this.droppedFields.contains(fieldName)) {
                this.droppedFields.add(fieldName);
            }
            this.getCriteria(false).remove(fieldName);
            if (this.getOutputs() != null) {
                this.getOutputs().remove(fieldName);
            }
            if (this.getConsolidatedOutputs() != null) {
                this.getConsolidatedOutputs().remove(fieldName);
            }
            if (this.getSummaryFunctionFields() != null) {
                this.getSummaryFunctionFields().remove(fieldName);
            }
            if (this.getSummaryFunctions() != null) {
                this.getSummaryFunctions().remove(fieldName);
            }
            if (this.getGroupBy() != null) {
                this.getGroupBy().remove(fieldName);
            }
            if (this.getExpressionFields() != null) {
                this.getExpressionFields().remove(fieldName);
            }
            this.removeExpression(fieldName);
            Iterator i = this.includeFrom.iterator();
            while (i.hasNext()) {
                IncludeFromDefinition incFrom = (IncludeFromDefinition)i.next();
                if (!fieldName.equals(incFrom.getThisFieldName())) continue;
                i.remove();
                break;
            }
        } else {
            ((Map)this.getValueSets().get(valueSetIndex)).remove(fieldName);
        }
        return this;
    }

    public Boolean getAuthenticated() {
        if (this.getDsTransaction() != null) {
            return this.getDsTransaction().getAuthenticated();
        }
        return Boolean.TRUE;
    }

    public List<String> getUserRoles() {
        if (this.getDsTransaction() != null) {
            return this.getDsTransaction().getUserRoles();
        }
        return this.userRoles;
    }

    public DSRequest setUserRoles(String rolesString) {
        List<String> list = DataTools.commaSeparatedStringToList(rolesString);
        return this.setUserRoles(list);
    }

    public DSRequest setUserRoles(String ... roles) {
        List<String> list = Arrays.asList(roles);
        return this.setUserRoles(list);
    }

    public DSRequest setUserRoles(List<String> userRoles) {
        if (this.getDsTransaction() != null) {
            this.getDsTransaction().setUserRoles(userRoles);
        } else {
            this.userRoles = userRoles;
        }
        this.setClientRequest(true);
        return this;
    }

    public String getUserId() {
        if (this.getDsTransaction() != null) {
            if (this.getDsTransaction().getUserId() != null) {
                return this.getDsTransaction().getUserId();
            }
            if (this.getRPCManager() != null && this.getRPCManager().getContext() != null && this.getRPCManager().getContext().request != null) {
                return this.getRPCManager().getContext().request.getRemoteUser();
            }
        }
        return this.userId;
    }

    public DSRequest setUserId(String userId) {
        if (this.getDsTransaction() != null) {
            log.warn("setUserId() called on a DSRequest that has a DSTransaction.  User ID is managed at the transaction level for DSRequests like this");
        } else {
            this.userId = userId;
        }
        this.setClientRequest(true);
        return this;
    }

    public boolean isUserInRole(String roles, HttpServletRequest req) {
        List<String> userRoles = this.getUserRoles();
        if (userRoles == null && req == null) {
            return false;
        }
        String superUserRole = StringUtils.trim((String)config.getString("authentication.superuserRole"));
        if (StringUtils.isNotBlank((String)superUserRole) && (userRoles == null ? req.isUserInRole(superUserRole) : userRoles.contains(superUserRole))) {
            return true;
        }
        boolean requireAllRoles = config.getBoolean((Object)"authentication.requireAllRoles", false);
        List<String> rolesList = DataTools.commaSeparatedStringToList(roles);
        for (String role : rolesList) {
            boolean inRole = userRoles != null ? userRoles.contains(role) : req.isUserInRole(role);
            if (inRole) {
                return true;
            }
            if (!requireAllRoles) continue;
            return false;
        }
        return requireAllRoles;
    }

    public DSRequest inheritTemplateContext(RPCManager rpc) {
        this.setRPCManager(rpc);
        this.context = rpc.getContext();
        this.setClientRequest(false);
        return this;
    }

    public DSRequest inheritClientContext(DSRequest req) {
        if (req != null) {
            this.context = req.context;
            this.setTenantId(req.getTenantId());
            this.setRPCManager(req.getRPCManager());
            this.setClientRequest(req.isClientRequest());
        }
        return this;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.context == null ? null : this.context.request;
    }

    public ServletContext getServletContext() {
        return this.context == null ? null : this.context.servletContext;
    }

    @Deprecated
    public DSRequest setRequestContext(RequestContext context) {
        return (DSRequest)this.setContext(context);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public DSRequest setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public DSRequest removeAttribute(String key) {
        this.attributes.remove(key);
        return this;
    }

    public DSRequest setIsAuditRequest(boolean newValue) {
        this._isAuditRequest = newValue;
        return this;
    }

    public boolean isAuditRequest() {
        return this._isAuditRequest;
    }

    private DSRequest hashFieldValues() throws Exception {
        if (this.getDataSource() == null) {
            return this;
        }
        List hashed = this.getHashedFields();
        List<DSField> fields = this.getDataSource().getFields();
        for (DSField field : fields) {
            String fieldHash = field.getStoreWithHash();
            if (fieldHash == null) continue;
            String fieldName = field.getName();
            if (hashed != null && hashed.contains(fieldName)) continue;
            List valueSets = this.getValueSets();
            for (Map values : valueSets) {
                String value = (String)values.get(fieldName);
                if (value == null) continue;
                value = DataTools.hashValue(value, fieldHash);
                values.put(fieldName, value);
            }
        }
        return this;
    }

    protected DSRequest removeIllegalValues() throws Exception {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this;
        }
        for (DSField field : ds.getFields()) {
            if (!field.getBoolean("canSave", true)) {
                this.removeField(field.getName(), false);
            }
            if ("add".equals(this.getOperationType()) && !field.getBoolean("canInit", true)) {
                this.removeField(field.getName(), false);
            }
            if (!"update".equals(this.getOperationType()) || field.getBoolean("canUpdate", true)) continue;
            this.removeField(field.getName(), false);
        }
        return this;
    }

    private DSRequest populateModifierAndCreatorFields(boolean addMode) throws Exception {
        if (this.getDataSource() == null) {
            return this;
        }
        String modifier = this.getUserId();
        Date modifierTimestamp = this.getRPCManager() != null ? (Date)this.getRPCManager().getFromTemplateContext("transactionDate") : this.getCurrentDate();
        if (this.getValueSets().size() == 0) {
            this.setValues(new HashMap());
        }
        List<DSField> fields = this.getDataSource().getFields();
        for (DSField field : fields) {
            try {
                if ("modifier".equals(field.getType())) {
                    this.populateAllValueSets(field.getName(), modifier);
                    continue;
                }
                if ("modifierTimestamp".equals(field.getType())) {
                    this.populateAllValueSets(field.getName(), modifierTimestamp);
                    continue;
                }
                if ("creator".equals(field.getType())) {
                    if (addMode) {
                        this.populateAllValueSets(field.getName(), modifier);
                        continue;
                    }
                    this.removeFromAllValueSets(field.getName());
                    continue;
                }
                if (!"creatorTimestamp".equals(field.getType())) continue;
                if (addMode) {
                    this.populateAllValueSets(field.getName(), modifierTimestamp);
                    continue;
                }
                this.removeFromAllValueSets(field.getName());
            }
            catch (NullPointerException npe) {
                log.warn("Unable to overwrite modifier or timestamp on record due to passed values object not supporting null inserts");
            }
        }
        return this;
    }

    private void populateAllValueSets(String fieldName, Object value) {
        boolean alwaysOverwrite = !"modifiersAndTimestamps".equals(this.getParameter("writeToGeneratedFields"));
        List valueSets = this.getValueSets();
        for (int i = 0; i < valueSets.size(); ++i) {
            Map values = (Map)valueSets.get(i);
            if (values.get(fieldName) != null && !alwaysOverwrite) continue;
            values.put(fieldName, value);
        }
    }

    private void removeFromAllValueSets(String fieldName) {
        List valueSets = this.getValueSets();
        for (int i = 0; i < valueSets.size(); ++i) {
            Map values = (Map)valueSets.get(i);
            values.remove(fieldName);
        }
    }

    public Boolean shouldJoinTransaction() {
        return this.joinTransaction;
    }

    public DSRequest setJoinTransaction(Boolean newValue) throws DSRequestAlreadyStartedException {
        if (this.requestStarted) {
            throw new DSRequestAlreadyStartedException("Request processing has started;  join transactions setting cannot be changed");
        }
        this.joinTransaction = newValue;
        return this;
    }

    public boolean hasFreeResourcesHandler() {
        return this.getFreeResourcesHandler() != null;
    }

    public FreeResourcesHandler getFreeResourcesHandler() {
        return this.freeResourcesHandler;
    }

    public DSRequest registerFreeResourcesHandler(FreeResourcesHandler handler) {
        if (this.freeResourcesHandler == null || !(this.freeResourcesHandler instanceof DataSource) || handler instanceof DataSource) {
            if (this.freeResourcesHandler != null) {
                log.debug("Clobbering existing FreeResourcesHandler of type '" + this.freeResourcesHandler.getClass().getName() + "' with a '" + handler.getClass().getName() + "'");
            }
            this.freeResourcesHandler = handler;
        } else {
            log.debug("Ignored request to change the FreeResourcesHandler from a '" + this.freeResourcesHandler.getClass().getName() + "' to a '" + handler.getClass().getName() + "'");
        }
        return this;
    }

    @Override
    public DSRequest freeResources() {
        if (!this.resourcesFreed && this.freeResourcesHandler != null && this.getPrimaryDSRequest() == null) {
            this.freeResourcesHandler.freeResources(this);
        } else {
            log.debug("Ignoring freeResources call because " + (this.resourcesFreed ? "they have already been freed" : "this is not a primary request!"));
        }
        this.resourcesFreed = true;
        return this;
    }

    @Override
    public DSRequest freeQueueResources() {
        if (!this.queueResourcesFreed && this.freeResourcesHandler != null && this.getPrimaryDSRequest() == null) {
            this.freeResourcesHandler.freeQueueResources(this);
        } else {
            log.debug("Ignoring freeQueueResources call because " + (this.queueResourcesFreed ? "they have already been freed" : "this is not a primary request!"));
        }
        this.queueResourcesFreed = true;
        return this;
    }

    @Override
    public DSRequest freeAllResources() {
        if (!this.requestStarted) {
            log.warn("freeAllResources() called for a DSRequest that has not yet started processing - ignoring");
            return this;
        }
        this.freeResources();
        this.freeQueueResources();
        return this;
    }

    @Override
    public boolean shouldFreeOnExecute() {
        return this.getFreeOnExecute();
    }

    @Override
    public void commit(DSTransaction dsTransaction) throws Exception {
        log.debug("In commit(), 'usingSpringTransaction' is " + dsTransaction.isUsingSpringTransaction() + " for DSRequest " + this.hashCode());
        this.getDataSource().commit(dsTransaction);
    }

    @Override
    public void rollback(DSTransaction dsTransaction) throws Exception {
        this.getDataSource().rollback(dsTransaction);
    }

    public boolean getFreeOnExecute() {
        return this.freeOnExecute == null ? true : this.freeOnExecute;
    }

    public DSRequest setFreeOnExecute(boolean freeOnExecute) {
        this.freeOnExecute = freeOnExecute;
        return this;
    }

    public boolean isFreeOnExecuteSet() {
        return this.freeOnExecute != null;
    }

    public List getIncludeFrom() {
        return this.includeFrom;
    }

    public List getConsolidatedOutputs() {
        return this.consolidatedOutputs;
    }

    public List getDroppedFields() {
        return this.droppedFields != null ? new ArrayList(this.droppedFields) : null;
    }

    public Map getDroppedFieldValues(int index) {
        return this.droppedFieldValues != null ? new HashMap(this.droppedFieldValues.get(index)) : null;
    }

    private void resetAmbiguousIncFromFields() {
        this.validIncludeFromFields = null;
    }

    private void logIncFromIfAmbiguous(IncludeFromDefinition newDef) throws Exception {
        boolean ambiguous = this.getDataSource().isIncFromAmbiguous(newDef);
        String incFromKey = DataSource.buildIncFromKey(newDef);
        if (!ambiguous) {
            if (this.validIncludeFromFields == null) {
                this.validIncludeFromFields = new HashMap<String, IncludeFromDefinition>();
            }
            for (Map.Entry<String, IncludeFromDefinition> report : this.validIncludeFromFields.entrySet()) {
                IncludeFromDefinition existing = report.getValue();
                if (!incFromKey.equals(DataSource.buildIncFromKey(existing))) continue;
                if (newDef.isDynamic()) {
                    log.warn((newDef.isCriteria() ? "In criteria, dynamic " : (newDef.isSortBy() ? "In sortBy, dynamic " : "Dynamic ")) + "definition '" + newDef.getThisFieldName() + "' includes the same field from the same related DataSource as does the '" + existing.getThisFieldName() + "' field. This is not allowed, for more details see the 'Ambiguous includeFrom definitions and logging' section of includeVia docs in Smartclient reference.");
                }
                ambiguous = true;
                break;
            }
        }
        if (!ambiguous) {
            this.validIncludeFromFields.put(incFromKey, newDef);
        }
    }

    private List buildIncludeFromDefinitions(DataSource dataSource, boolean includeDynamics, String fieldName) throws Exception {
        Object incFrom;
        ArrayList<Object> includeFrom = new ArrayList<Object>();
        if (this.ds == null) {
            return includeFrom;
        }
        if (this.ds.getConfig().get("cacheRelations") != null) {
            if (!DataTools.getBoolean(this.ds.getConfig(), "cacheRelations")) {
                this.ds.clearCachedRelations();
            }
        } else if (!config.getBoolean((Object)"cacheRelations", true)) {
            this.ds.clearCachedRelations();
        }
        boolean unionMode = Boolean.TRUE.equals(this.getAttribute("unionMode"));
        UnionDataSource unionDS = (UnionDataSource)this.getAttribute("unionDataSource");
        for (DSField dSField : dataSource.getFields()) {
            String realFieldName;
            incFrom = dataSource.getIncludeFromInfo(dSField, this);
            if (incFrom == null) continue;
            String outputsFieldName = realFieldName = dSField.getName();
            if (realFieldName == null) {
                realFieldName = ((IncludeFromInfo)incFrom).getIncludedFieldName();
            }
            if (fieldName != null) {
                if (!fieldName.equals(realFieldName)) {
                    continue;
                }
            } else {
                UnionDataSource uds;
                DSField renamedField;
                boolean expressionNeeded = false;
                if (this.expressionFields != null) {
                    DSField unionField;
                    if (this.expressionFields.contains(dSField.getName())) {
                        expressionNeeded = true;
                    } else if (unionMode && unionDS != null && (unionField = unionDS.getRenamedField(this.ds, dSField, this)) != null) {
                        outputsFieldName = unionField.getName();
                        expressionNeeded = this.expressionFields.contains(unionField.getName());
                    }
                }
                if (this.isSummary() && !this.getSummaryFields().contains(dSField.getName()) ? !expressionNeeded : (this.consolidatedOutputs != null && !this.consolidatedOutputs.contains(outputsFieldName) || this.skipField(dSField.getName())) && (Boolean.TRUE.equals(this.getAttribute("unionMode")) ? (renamedField = (uds = (UnionDataSource)this.getAttribute("unionDataSource")).getRenamedField(dataSource, dSField, this)) == null || this.consolidatedOutputs != null && !this.consolidatedOutputs.contains(renamedField.getName()) || this.skipField(renamedField.getName()) : !expressionNeeded)) continue;
            }
            IncludeFromDefinition newDef = IncludeFromDefinition.create((IncludeFromInfo)incFrom, this);
            this.logIncFromIfAmbiguous(newDef);
            includeFrom.add(newDef);
        }
        if (includeDynamics) {
            Iterator<DSField> i = this.getAdditionalOutputs().iterator();
            while (i.hasNext()) {
                int i2;
                DSField dSField;
                DSField field = dSField = i.next();
                String fldName = field.getName();
                if (this.isSummary() && !this.getSummaryFields().contains(field.getName())) continue;
                IncludeFromDefinition incFrom2 = new IncludeFromDefinition(field, field.getProperty("includeFrom"), this);
                incFrom2.setDynamic(true);
                String thisFieldName = incFrom2.getThisFieldName();
                if (this.ds.getField(thisFieldName) != null) {
                    log.warn("In outputs, definition '" + fldName + "' refers to a field name ('" + thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this outputs entry.");
                    continue;
                }
                DataSource relatedDS = incFrom2.getDataSource();
                if (relatedDS == null) {
                    log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + incFrom2.getDataSourceName() + "') that does not exist.  Ignoring this outputs entry.");
                    continue;
                }
                if (relatedDS.getField(incFrom2.getIncludedFieldName()) == null) {
                    boolean ok = false;
                    if (this.ds == relatedDS) {
                        for (i2 = 0; i2 < includeFrom.size(); ++i2) {
                            IncludeFromDefinition otherIncFrom = (IncludeFromDefinition)includeFrom.get(i2);
                            if (!otherIncFrom.getThisFieldName().equals(incFrom2.getIncludedFieldName())) continue;
                            for (int j = 0; j < this.getAdditionalOutputs().size(); ++j) {
                                DSField addOutFld = (DSField)this.getAdditionalOutputs().get(j);
                                if (!addOutFld.getName().equals(incFrom2.getIncludedFieldName())) continue;
                                incFrom2.setIncludedField(addOutFld);
                                break;
                            }
                            ok = true;
                            break;
                        }
                    }
                    if (!ok) {
                        log.warn("In outputs, definition '" + fldName + "' refers to a field name ('" + incFrom2.getIncludedFieldName() + "') that does not exist on the related DataSurce ('" + relatedDS.getName() + "').  Ignoring this outputs entry.");
                        continue;
                    }
                }
                if (incFrom2.getDataSourceNames() != null && incFrom2.getDataSourceNames().length > 0) {
                    String[] stringArray = incFrom2.getDataSourceNames();
                    i2 = stringArray.length;
                    for (int j = 0; j < i2; ++j) {
                        String dsName = stringArray[j];
                        if (this.getCachedDataSourceInstance(dsName) != null) continue;
                        log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                        incFrom2.setInError(true);
                    }
                }
                incFrom2.setRelation(this.ds.getRelation(incFrom2.getDataSources(), field.getProperty("includeVia"), this));
                if (incFrom2.getRelation() == null) {
                    log.warn("In outputs, definition '" + fldName + "' refers to a related DataSource ('" + incFrom2.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                    continue;
                }
                this.logIncFromIfAmbiguous(incFrom2);
                includeFrom.add(incFrom2);
            }
            if (this.consolidatedOutputs != null) {
                i = this.consolidatedOutputs.iterator();
                while (i.hasNext()) {
                    String string = (String)((Object)i.next());
                    if (this.isSummary() && !this.getSummaryFields().contains(string) || !IncludeFromDefinition.isDynamicInclusion(string)) continue;
                    incFrom = new IncludeFromDefinition(string, this);
                    ((IncludeFromDefinition)incFrom).setDynamic(true);
                    String thisFieldName = ((IncludeFromDefinition)incFrom).getThisFieldName();
                    if (this.ds.getField(thisFieldName) != null) {
                        log.warn("In outputs, definition '" + string + "' refers to a field name ('" + thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    DataSource relatedDS = ((IncludeFromDefinition)incFrom).getDataSource();
                    if (relatedDS == null) {
                        log.warn("In outputs, definition '" + string + "' refers to a related DataSource ('" + ((IncludeFromDefinition)incFrom).getDataSourceName() + "') that does not exist.  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    if (relatedDS.getField(((IncludeFromDefinition)incFrom).getIncludedFieldName()) == null) {
                        log.warn("In outputs, definition '" + string + "' refers to a field name ('" + ((IncludeFromDefinition)incFrom).getIncludedFieldName() + "') that does not exist on the related DataSurce ('" + relatedDS.getName() + "').  Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    if (((IncludeFromDefinition)incFrom).getDataSourceNames() != null && ((IncludeFromDefinition)incFrom).getDataSourceNames().length > 0) {
                        for (String dsName : ((IncludeFromDefinition)incFrom).getDataSourceNames()) {
                            if (this.getCachedDataSourceInstance(dsName) != null) continue;
                            log.warn("In outputs, definition '" + string + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                            ((IncludeFromDefinition)incFrom).setInError(true);
                        }
                    }
                    ((IncludeFromDefinition)incFrom).setRelation(this.ds.getRelation(((IncludeFromDefinition)incFrom).getDataSources(), this));
                    if (((IncludeFromDefinition)incFrom).getRelation() == null) {
                        log.warn("In outputs, definition '" + string + "' refers to a related DataSource ('" + ((IncludeFromDefinition)incFrom).getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                        i.remove();
                        continue;
                    }
                    this.logIncFromIfAmbiguous((IncludeFromDefinition)incFrom);
                    includeFrom.add(incFrom);
                }
            }
            this.createIncludeFromDefinitionFromCriteria(includeFrom, false);
        }
        this.createIncludeFromDefinitionFromSortBy(includeFrom, fieldName, false);
        for (IncludeFromDefinition includeFromDefinition : includeFrom) {
            if (includeFromDefinition.isTargetInspected()) continue;
            DataSource includeDS = includeFromDefinition.getDataSource();
            DSField includedField = includeFromDefinition.getIncludedField();
            IncludeFromDefinition target = IncludeFromDefinition.create(includeDS.getIncludeFromInfo(includedField, this), this);
            includeFromDefinition.setTargetIncludeFrom(target);
        }
        for (IncludeFromDefinition includeFromDefinition : includeFrom) {
            if (includeFromDefinition.isPrepared()) continue;
            includeFromDefinition.prepareField();
        }
        return includeFrom;
    }

    public void collectQueryFieldsFromAdvancedCriteria(Map advancedCriteria) {
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        this.collectQueryFieldsRecursively(criteria);
        if (this.queryFields != null && this.queryFields.size() > 1) {
            LinkedHashMap<String, Map> sortedMap = new LinkedHashMap<String, Map>();
            ArrayList<String> sortedKeys = new ArrayList<String>(this.queryFields.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                sortedMap.put(key, this.queryFields.get(key));
            }
            this.queryFields = sortedMap;
        }
    }

    public void collectQueryFieldsRecursively(List criteria) {
        for (Map criterion : criteria) {
            if (criterion.containsKey("criteria")) {
                this.collectQueryFieldsRecursively((List)criterion.get("criteria"));
                continue;
            }
            if (criterion.containsKey("fieldQuery")) {
                String fieldName = this.addQueryField((Map)criterion.get("fieldQuery"));
                criterion.remove("fieldQuery");
                criterion.put("fieldName", fieldName);
            }
            if (!criterion.containsKey("valueQuery")) continue;
            Map criterionMap = (Map)criterion.get("valueQuery");
            criterionMap.put("_operator", criterion.get("operator"));
            String value = this.addQueryField(criterionMap);
            criterion.remove("valueQuery");
            criterion.put("value", value);
            if (!criterion.containsKey("fieldStaticValue")) continue;
            Object staticValue = criterion.get("fieldStaticValue");
            HashMap staticMap = new HashMap();
            staticMap.put("fieldStaticValue", staticValue);
            staticMap.put("valueQuery", criterionMap);
            String fieldName = this.addStaticValueField(staticMap);
            criterion.remove("fieldStaticValue");
            criterion.put("fieldName", fieldName);
        }
    }

    private void createIncludeFromDefinitionFromCriteria(List includeFrom, boolean checkForDuplicates) throws Exception {
        if (this.getCriteria(false) != null) {
            Iterator<Object> i = this.ds.isAdvancedCriteria(this.getCriteria(false)) ? this.ds.extractFieldNamesFromAdvancedCriteria(this.getCriteria(false), true).iterator() : this.getCriteria(false).keySet().iterator();
            while (i.hasNext()) {
                String fldName = (String)i.next();
                this.createIncludeFromDefinitionFromCriteria(fldName, includeFrom, checkForDuplicates);
            }
        }
    }

    private void createIncludeFromDefinitionFromCriteria(String fldName, List includeFrom, boolean checkForDuplicates) throws Exception {
        if (checkForDuplicates) {
            for (IncludeFromDefinition incFrom : includeFrom) {
                if (!fldName.equals(incFrom.getThisFieldName())) continue;
                return;
            }
        }
        if (IncludeFromDefinition.isDynamicInclusion(fldName)) {
            IncludeFromDefinition incFrom = new IncludeFromDefinition(fldName, this);
            incFrom.setCriteria(true);
            incFrom.setDynamic(true);
            String thisFieldName = incFrom.getThisFieldName();
            if (this.ds.getField(thisFieldName) != null) {
                log.warn("In criteria, definition '" + fldName + "' refers to a field name ('" + (String)thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this criteria entry.");
                return;
            }
            DataSource relatedDS = incFrom.getDataSource();
            if (relatedDS == null) {
                log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that does not exist.  Ignoring this criteria entry.");
                return;
            }
            if (relatedDS.getField(incFrom.getIncludedFieldName()) == null) {
                log.warn("In criteria, definition '" + fldName + "' refers to a field name ('" + incFrom.getIncludedFieldName() + "') that does not exist on the related DataSource ('" + relatedDS.getName() + "').  Ignoring this criteria entry.");
                return;
            }
            if (incFrom.getDataSourceNames() != null && incFrom.getDataSourceNames().length > 0) {
                for (String dsName : incFrom.getDataSourceNames()) {
                    if (this.getCachedDataSourceInstance(dsName) != null) continue;
                    log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                    incFrom.setInError(true);
                }
            }
            incFrom.setRelation(this.ds.getRelation(incFrom.getDataSources(), this));
            if (incFrom.getRelation() == null) {
                log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this criteria entry.");
                return;
            }
            this.logIncFromIfAmbiguous(incFrom);
            includeFrom.add(incFrom);
            this.addExpressionField(fldName);
        } else {
            boolean found = false;
            for (Object fieldObject : this.getAdditionalOutputs()) {
                DSField field = (DSField)fieldObject;
                if (!fldName.equals(field.getName())) continue;
                IncludeFromDefinition incFrom = new IncludeFromDefinition(field, field.getProperty("includeFrom"), this);
                incFrom.setCriteria(true);
                this.logIncFromIfAmbiguous(incFrom);
                includeFrom.add(incFrom);
                found = true;
                break;
            }
            if (!(found || this.consolidatedOutputs != null && this.consolidatedOutputs.contains(fldName))) {
                DSField field = this.ds.getField(fldName);
                if (field == null || field.get("includeFrom") == null) {
                    return;
                }
                IncludeFromDefinition incFrom = new IncludeFromDefinition(field, (String)field.get("includeFrom"), this);
                if (incFrom == null) {
                    return;
                }
                incFrom.setCriteria(true);
                incFrom.setRelation(this.ds.getRelation(incFrom.getDataSources(), field.getProperty("includeVia"), this));
                if (incFrom.getRelation() == null) {
                    log.warn("In criteria, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                    return;
                }
                this.logIncFromIfAmbiguous(incFrom);
                includeFrom.add(incFrom);
            }
        }
    }

    private void createIncludeFromDefinitionFromSortBy(List includeFrom, String fieldName, boolean checkForDuplicates) throws Exception {
        List sortBy;
        if (checkForDuplicates && fieldName != null) {
            for (IncludeFromDefinition incFrom : includeFrom) {
                if (!fieldName.equals(incFrom.getThisFieldName())) continue;
                return;
            }
        }
        if ((sortBy = this.getSortByFields()) != null && sortBy.size() != 0 && fieldName == null) {
            Iterator i = sortBy.iterator();
            while (i.hasNext()) {
                DSField field;
                String fldName = (String)i.next();
                if ("-".equals(fldName.substring(0, 1))) {
                    fldName = fldName.substring(1);
                }
                if (IncludeFromDefinition.isDynamicInclusion(fldName)) {
                    IncludeFromDefinition incFrom = new IncludeFromDefinition(fldName, this);
                    incFrom.setSortBy(true);
                    incFrom.setDynamic(true);
                    String thisFieldName = incFrom.getThisFieldName();
                    if (this.ds.getField(thisFieldName) != null) {
                        log.warn("In sortBy, definition '" + fldName + "' refers to a field name ('" + (String)thisFieldName + "') that is already declared on this dataSource ('" + this.ds.getName() + "').  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    DataSource relatedDS = incFrom.getDataSource();
                    if (relatedDS == null) {
                        log.warn("In sortBy, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that does not exist.  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    if (relatedDS.getField(incFrom.getIncludedFieldName()) == null) {
                        log.warn("In sortBy, definition '" + fldName + "' refers to a field name ('" + incFrom.getIncludedFieldName() + "') that does not exist on the related DataSource ('" + relatedDS.getName() + "').  Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    if (incFrom.getDataSourceNames() != null && incFrom.getDataSourceNames().length > 0) {
                        for (String dsName : incFrom.getDataSourceNames()) {
                            if (this.getCachedDataSourceInstance(dsName) != null) continue;
                            log.warn("In sortBy, definition '" + fldName + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                            incFrom.setInError(true);
                        }
                    }
                    incFrom.setRelation(this.ds.getRelation(incFrom.getDataSources(), this));
                    if (incFrom.getRelation() == null) {
                        log.warn("In sortBy, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this sortBy entry.");
                        i.remove();
                        continue;
                    }
                    this.logIncFromIfAmbiguous(incFrom);
                    incFrom.setExpressionId(fldName);
                    this.addExpressionField(fldName);
                    includeFrom.add(incFrom);
                    continue;
                }
                boolean found = false;
                for (Object fieldObject : this.getAdditionalOutputs()) {
                    DSField field2 = (DSField)fieldObject;
                    if (!fldName.equals(field2.getName())) continue;
                    IncludeFromDefinition incFrom = new IncludeFromDefinition(field2, field2.getProperty("includeFrom"), this);
                    incFrom.setSortBy(true);
                    this.logIncFromIfAmbiguous(incFrom);
                    includeFrom.add(incFrom);
                    found = true;
                    break;
                }
                if (found || this.consolidatedOutputs != null && this.consolidatedOutputs.contains(fldName) || (field = this.ds.getField(fldName)) == null || field.get("includeFrom") == null) continue;
                IncludeFromDefinition incFrom = new IncludeFromDefinition(field, (String)field.get("includeFrom"), this);
                incFrom.setSortBy(true);
                if (incFrom == null) continue;
                incFrom.setRelation(this.ds.getRelation(incFrom.getDataSources(), field.getProperty("includeVia"), this));
                if (incFrom.getRelation() == null) {
                    log.warn("In sortBy, definition '" + fldName + "' refers to a related DataSource ('" + incFrom.getDataSourceName() + "') that is not related to this dataSource ('" + this.ds.getName() + "'). You can only specify fields in related DataSources where a foreignKey property establishes the relation from this dataSource ('" + this.ds.getName() + "') to the related DataSource. Ignoring this outputs entry.");
                    continue;
                }
                this.logIncFromIfAmbiguous(incFrom);
                includeFrom.add(incFrom);
            }
        }
    }

    private DSRequest fetchRelatedValues(DSResponse response) throws Exception {
        DataSource ds;
        ArrayList mappedFieldNames = null;
        if (this.consolidatedOutputs != null) {
            mappedFieldNames = new ArrayList(this.consolidatedOutputs);
            this.mapRawOutputFieldNames(mappedFieldNames);
        }
        if (!(ds = this.getDataSource()).canJoinIncludedFields()) {
            ArrayList<String> includedDataSources = new ArrayList<String>();
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                if (incFrom.isInError() || incFrom.isCriteria() || mappedFieldNames != null && !mappedFieldNames.contains(incFrom.getThisFieldName()) || includedDataSources.contains(incFrom.getDataSourceName())) continue;
                includedDataSources.add(incFrom.getDataSourceName());
            }
            for (String dsName : includedDataSources) {
                Relation relation = null;
                ArrayList<String> outputs = new ArrayList<String>();
                ArrayList<String> mappedOutputs = new ArrayList<String>();
                for (IncludeFromDefinition incFrom : this.includeFrom) {
                    if (incFrom.isInError() || incFrom.isCriteria() || !dsName.equals(incFrom.getDataSourceName())) continue;
                    if (relation == null) {
                        relation = incFrom.getRelation();
                    }
                    mappedOutputs.add(incFrom.getThisFieldName());
                    outputs.add(incFrom.getIncludedFieldName());
                }
                this.applyRelatedDSRequest(dsName, outputs, mappedOutputs, relation, response);
            }
        } else {
            ArrayList<String> includedDataSources = new ArrayList<String>();
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                if (incFrom.isInError() || incFrom.isCriteria()) continue;
                while (incFrom != null && incFrom.getDataSource().canJoinIncludedFields()) {
                    incFrom = incFrom.getTargetIncludeFrom();
                }
                if (incFrom == null || mappedFieldNames != null && !mappedFieldNames.contains(incFrom.getThisFieldName()) || includedDataSources.contains(incFrom.getDataSourceName())) continue;
                includedDataSources.add(incFrom.getDataSourceName());
            }
            for (String dsName : includedDataSources) {
                Relation relation = null;
                ArrayList<String> outputs = new ArrayList<String>();
                ArrayList<String> mappedOutputs = new ArrayList<String>();
                for (IncludeFromDefinition incFrom : this.includeFrom) {
                    if (incFrom.isInError() || incFrom.isCriteria() || !dsName.equals(incFrom.getDataSourceName())) continue;
                    while (incFrom != null && incFrom.getDataSource().canJoinIncludedFields()) {
                        incFrom = incFrom.getTargetIncludeFrom();
                    }
                    if (incFrom == null) continue;
                    if (relation == null) {
                        relation = incFrom.getRelation();
                    }
                    mappedOutputs.add(incFrom.getThisFieldName());
                    outputs.add(incFrom.getIncludedFieldName());
                }
                this.applyRelatedDSRequest(dsName, outputs, mappedOutputs, relation, response);
            }
        }
        return this;
    }

    public boolean selectCriteriaFields() {
        return this.selectCriteriaFields;
    }

    public DSRequest setSelectCriteriaFields(boolean newVal) {
        this.selectCriteriaFields = newVal;
        return this;
    }

    public boolean selectSortByFields() {
        return this.selectSortByFields;
    }

    public DSRequest setSelectSortByFields(boolean newVal) {
        this.selectSortByFields = newVal;
        return this;
    }

    public boolean isSubquery() {
        return this.isSubquery;
    }

    public String getForcedAlias() {
        return this.forcedAlias;
    }

    public DSRequest setForcedAlias(String forcedAlias) {
        this.forcedAlias = forcedAlias;
        return this;
    }

    public String getQueryOutput() {
        return this.queryOutput;
    }

    public void setQueryOutput(String value) {
        this.queryOutput = value;
    }

    private DSRequest applyRelatedDSRequest(String dsName, List outputs, List mappedOutputs, Relation relation, DSResponse response) throws Exception {
        IncludeFromDefinition incFrom;
        List dataList = response.getRecords();
        if (dataList == null || dataList.size() == 0) {
            return this;
        }
        HashMap criteriaValuesMap = new HashMap();
        HashSet criteriaValuesSet = new HashSet();
        for (int i = 0; i < dataList.size(); ++i) {
            Map record = (Map)dataList.get(i);
            HashMap criteriaValue = new HashMap();
            ArrayList keyValues = new ArrayList();
            StringBuffer mapKey = new StringBuffer();
            if (relation.isComposite()) {
                for (int k = 0; k < relation.getFromFields().size(); ++k) {
                    DSField fromField = relation.getFromFields().get(k);
                    DSField toField = relation.getToFields().get(k);
                    String keyFrom = fromField.getName();
                    String keyTo = toField.getName();
                    Object value = record.get(keyFrom);
                    if (value == null && fromField.getJoinType() == 0) {
                        dataList.remove(i);
                        response.setData(dataList);
                        break;
                    }
                    keyValues.add(value);
                    if (mapKey.length() != 0) {
                        mapKey.append("_");
                    }
                    mapKey.append(value == null ? "" : value.toString());
                    criteriaValue.put(keyTo, value);
                }
                if (criteriaValuesMap.containsKey(mapKey.toString())) continue;
                criteriaValuesMap.put(mapKey.toString(), criteriaValue);
                continue;
            }
            Object value = record.get(relation.getFromFields().get(0).getName());
            if (value == null || criteriaValuesSet.contains(value)) continue;
            criteriaValuesSet.add(value);
        }
        DSRequest req = new DSRequest(dsName, "fetch", this.getRPCManager());
        req.setRPCManager(this.getRPCManager());
        int c = 0;
        for (DSField toField : relation.getToFields()) {
            if (!outputs.contains(toField.getName())) {
                outputs.add(toField.getName());
                mappedOutputs.add(relation.getFromFields().get(c).getName());
            }
            ++c;
        }
        for (String fieldName : this.getCriteria().keySet()) {
            incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, fieldName);
            if (incFrom == null || !incFrom.getDataSourceName().equals(dsName)) continue;
            outputs.add(incFrom.getIncludedFieldName());
            mappedOutputs.add(incFrom.getThisFieldName());
            req.setSelectCriteriaFields(true);
        }
        for (String fieldName : this.getSortByFields()) {
            incFrom = IncludeFromDefinition.forSortByField(this.includeFrom, fieldName, false);
            if (incFrom == null || !incFrom.getDataSourceName().equals(dsName)) continue;
            outputs.add(incFrom.getIncludedFieldName());
            mappedOutputs.add(incFrom.getThisFieldName());
            req.setSelectSortByFields(true);
        }
        req.setOutputs(outputs);
        DSResponse work = null;
        DataSource ds = req.getDataSource();
        if (relation.isComposite()) {
            if (ds.allowAdvancedCriteria()) {
                int cn = 0;
                Criterion[] crits = new Criterion[criteriaValuesMap.keySet().size()];
                Iterator i = criteriaValuesMap.keySet().iterator();
                while (i.hasNext()) {
                    Map rawCrit = (Map)criteriaValuesMap.get(i.next());
                    Criterion[] inner = new SimpleCriterion[rawCrit.keySet().size()];
                    int cn2 = 0;
                    for (String fieldName : rawCrit.keySet()) {
                        inner[cn2++] = new SimpleCriterion(fieldName, "equals", rawCrit.get(fieldName));
                    }
                    crits[cn++] = new AndCriterion(inner);
                }
                req.setAdvancedCriteria(new AdvancedCriteria("or", crits));
                req.isNestedSubRequest = true;
                work = req.execute();
            } else {
                work = this.fetchRecordByRecord(ds, criteriaValuesMap);
            }
        } else {
            HashMap criteria = new HashMap();
            criteria.put(relation.getToFields().get(0).getName(), new ArrayList(criteriaValuesSet));
            req.setCriteria(criteria);
            req.isNestedSubRequest = true;
            work = req.execute();
        }
        if (work == null) {
            return this;
        }
        Object responseData = work.getData();
        List<Map> responseList = null;
        if (responseData instanceof List) {
            responseList = (ArrayList<Object>)responseData;
        } else if (responseData instanceof Map) {
            responseList = new ArrayList<Object>();
            responseList.add((Map)responseData);
        } else if (responseData instanceof JSONFilter) {
            if ((responseData = ((JSONFilter)responseData).getObj()) instanceof List) {
                responseList = (List)responseData;
            } else if (responseData instanceof Map) {
                responseList = new ArrayList();
                responseList.add((Map)responseData);
            }
        }
        if (responseList == null) {
            log.warn("Unable to handle response data during processing of related DSRequests. The custom DataSource returned a data member of type '" + responseData.getClass().getName() + "'; we expect a List of Maps or a single Map, or a JSONFilter wrapping a List of Maps or a single Map");
            return this;
        }
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map record = (Map)dataList.get(i);
            String criteriaValue = relation.getFromFieldIndexValue(record);
            int indexEntry = -1;
            HashMap<String, Object> summarizedValues = new HashMap<String, Object>();
            for (int j = 0; j < mappedOutputs.size(); ++j) {
                SummaryFunctions.SummaryFunction func;
                String funcName;
                String fieldName = (String)mappedOutputs.get(j);
                DSField field = this.getDataSource().getField(fieldName);
                String string = funcName = field == null ? null : (String)field.get("includeSummaryFunction");
                if (funcName == null || (func = SummaryFunctions.getSummaryFunction(funcName.toLowerCase())) == null) continue;
                List<DSField> criteriaToFields = relation.getToFields();
                if (criteriaToFields == null) {
                    log.warn("Trying to manually filter related records for an aggregate function, we found no fields in the relation from dataSource " + relation.getFromDataSource().getName() + " to dataSource " + relation.getToDataSource().getName() + ".  This is an unexpected and unrecoverable state - bailing out");
                    return this;
                }
                if (criteriaToFields.size() > 1) {
                    log.warn("Trying to manually filter related records for an aggregate function, we found a composite key relation from dataSource " + relation.getFromDataSource().getName() + " to dataSource " + relation.getToDataSource().getName() + ".  Manually-resolved aggregate function relations are not currently supported with composite keys.  We will use just the first key - this may well give incorrect results");
                }
                HashMap<String, String> innerCrit = new HashMap<String, String>();
                innerCrit.put(criteriaToFields.get(0).getName(), criteriaValue);
                req.setCriteria(innerCrit);
                List<Map> matchingSubset = req.manuallyApplyRequestCriteria(responseList);
                String includingFieldName = (String)outputs.get(j);
                DSField includingField = req.getDataSource().getField(includingFieldName);
                summarizedValues.put(fieldName, func.apply(matchingSubset, req.getDataSource(), includingField));
            }
            Map subRecord = null;
            if (criteriaValue == null) continue;
            if (!index.containsKey(criteriaValue)) {
                for (int j = 0; j < responseList.size(); ++j) {
                    subRecord = (Map)responseList.get(j);
                    if (!criteriaValue.equals(relation.getToFieldIndexValue(subRecord))) continue;
                    index.put(criteriaValue, j);
                    indexEntry = j;
                    break;
                }
            } else {
                indexEntry = (Integer)index.get(criteriaValue);
                subRecord = (Map)responseList.get(indexEntry);
            }
            if (indexEntry == -1) {
                if (!relation.isComposite()) {
                    log.info("In response from related DataSource '" + dsName + "' we could not find a record where primary key field '" + relation.getToFields().get(0).getName() + "' matched the value of the foreign key field '" + relation.getFromFields().get(0).getName() + "' for value [" + criteriaValue + "]. Values from that related DS will be null");
                    continue;
                }
                log.info("In response from related DataSource '" + dsName + "' we encountered a record where primary key field values could not be matched with foreign key field values (in other words, there is a missing record in the response)");
                continue;
            }
            Iterator i2 = outputs.iterator();
            Iterator i3 = mappedOutputs.iterator();
            while (i2.hasNext()) {
                String includedFieldName = (String)i2.next();
                String thisFieldName = (String)i3.next();
                if (relation.isAToField(includedFieldName)) continue;
                if (summarizedValues.containsKey(thisFieldName)) {
                    record.put(thisFieldName, summarizedValues.get(thisFieldName));
                    continue;
                }
                record.put(thisFieldName, subRecord.get(includedFieldName));
            }
        }
        return this;
    }

    protected DSResponse fetchRecordByRecord(DataSource ds, Map criteriaValues) throws Exception {
        ArrayList dataList = new ArrayList();
        Iterator i = criteriaValues.keySet().iterator();
        while (i.hasNext()) {
            DSRequest req = new DSRequest(ds.getName(), "fetch");
            req.setCriteria(criteriaValues.get(i.next()));
            req.isNestedSubRequest = true;
            DSResponse resp = req.execute();
            List records = resp.getRecords();
            if (records == null || records.size() == 0) {
                log.warn("Got null or empty data from a fetch on DataSource " + ds.getName() + " with criteria: " + String.valueOf(req.getCriteria()));
                continue;
            }
            if (records.size() > 1) {
                log.warn("Got more than one record from a PK fetch on DataSource " + ds.getName() + "; ignoring all but the first.  Criteria was: " + String.valueOf(req.getCriteria()));
            }
            dataList.add(records.get(0));
        }
        DSResponse resp = new DSResponse();
        resp.setData(dataList);
        return resp;
    }

    public List<Map> manuallyApplyRequestCriteria(List<Map> data) throws Exception {
        HashMap crit = this.getCriteria();
        if (crit == null) {
            crit = new HashMap();
        }
        DSResponse resp = new DSResponse(data);
        this.applyManualFilter(resp, crit, true);
        return (List)resp.getData();
    }

    private void applyManualFilter(DSResponse response, Object pCriteria) throws Exception {
        this.applyManualFilter(response, pCriteria, false);
    }

    private void applyManualFilter(DSResponse response, Object pCriteria, boolean forceFilter) throws Exception {
        Map criteria;
        boolean processIncludeFromsOnly = pCriteria == null;
        Map map = criteria = pCriteria == null ? this.getCriteria() : this.getCriteria(false, pCriteria);
        if (processIncludeFromsOnly && (this.includeFrom == null || this.includeFrom.size() == 0)) {
            return;
        }
        if (!forceFilter && this.isNestedSubRequest) {
            return;
        }
        if (this.getEndRow() != -1L && this.getNonSqlCriteriaFields() != null) {
            log.warn("SmartClient/SmartGWT Server does not currently support sort or filter on fields from non-SQL DataSources when performing paged fetches. If you need to sort or filter on these fields, use a basic fetch (ie, do not specify endRow), but be aware that this may drastically affect performance.  The following fields have been dropped from the specified criteria: " + String.valueOf(this.getNonSqlCriteriaFields()));
            return;
        }
        DataSource ds = this.getDataSource();
        boolean isAdvanced = ds.isAdvancedCriteria(criteria);
        if (this.hasNonSqlCriteria() || !ds.canJoinIncludedFields()) {
            int removed = 0;
            AdvancedCriteria ac = null;
            SimpleCriteria sc = null;
            Evaluator evaluator = new Evaluator();
            String textMatchStyle = (String)this.getOperationProperty("textMatchStyle");
            if (textMatchStyle == null && "filter".equals(this.getOperationType())) {
                textMatchStyle = "substring";
            }
            if (isAdvanced) {
                HashMap workCrit = new HashMap(criteria);
                this.mapRawAdvancedCriteria(workCrit);
                ac = Evaluator.parseAdvancedCriteria(workCrit);
            } else {
                sc = new SimpleCriteria(criteria);
                this.mapSimpleCriteria(sc);
            }
            List<Object> criteriaFields = new ArrayList(criteria.keySet());
            if (isAdvanced) {
                criteriaFields = this.getDataSource().extractFieldNamesFromAdvancedCriteria(criteria);
            }
            this.mapRawCriteriaFieldNames(criteriaFields);
            List<Object> dataList = null;
            Object data = response.getData();
            if (data instanceof List) {
                dataList = (ArrayList<Object>)data;
            } else if (data instanceof Map) {
                dataList = new ArrayList<Object>();
                dataList.add(data);
            } else if (data instanceof JSONFilter) {
                if ((data = ((JSONFilter)data).getObj()) instanceof List) {
                    dataList = (List)data;
                } else if (data instanceof Map) {
                    dataList = new ArrayList();
                    dataList.add(data);
                }
            }
            if (dataList == null) {
                log.warn("DSResponse data was of unexpected type: " + data.getClass().getName() + ".  Abandoning manual filter/sort");
                return;
            }
            if (dataList.size() == 0) {
                log.debug("In manual filter/sort, primary resultset was empty so nothing to do");
                return;
            }
            Object recordObj = dataList.get(0);
            if (!(recordObj instanceof Map)) {
                recordObj = this.getDataSource().getProperties(recordObj);
            }
            Map record = (Map)recordObj;
            Object fieldList = "";
            for (String string : criteriaFields) {
                if (record.containsKey(string)) continue;
                if (((String)fieldList).length() > 0) {
                    fieldList = (String)fieldList + ", ";
                }
                fieldList = (String)fieldList + string;
            }
            if (((String)fieldList).length() > 0) {
                log.warn("In manual filter, we found filter values for which there is no corresponding field in the first record of the resultset.  This may be expected, but it may be an indicator that you are not fetching all required fields - manual (ie, non-SQL) sort and filter can only work if you actually fetch the criteria and sortBy fields from the database. Affected fields: " + (String)fieldList);
            }
            ArrayList _dataList = new ArrayList(response.getDataList());
            Iterator iterator = _dataList.iterator();
            while (iterator.hasNext()) {
                recordObj = iterator.next();
                if (!(recordObj instanceof Map)) {
                    recordObj = this.getDataSource().getProperties(recordObj);
                }
                record = (Map)recordObj;
                boolean matches = isAdvanced ? evaluator.valuesMatchCriteria(record, ac) : evaluator.valuesMatchCriteria(record, sc, textMatchStyle);
                if (matches) continue;
                ++removed;
                iterator.remove();
            }
            response.setData(_dataList);
            if (removed > 0) {
                response.setTotalRows(response.getTotalRows() - (long)removed);
                response.setEndRow(response.getEndRow() - (long)removed);
            }
        }
    }

    public boolean hasNonSqlCriteria() throws Exception {
        return this.getNonSqlCriteriaFields() != null;
    }

    public Set getNonSqlCriteriaFields() throws Exception {
        UnionDataSource unionDs = (UnionDataSource)this.getAttribute("unionDataSource");
        if (Boolean.TRUE.equals(this.getAttribute("unionMode")) && unionDs != null && unionDs.isSQLDataSource(unionDs)) {
            return null;
        }
        boolean isAdvanced = this.getDataSource().isAdvancedCriteria(this.getCriteria());
        List<Object> criteriaFields = new ArrayList(this.getCriteria().keySet());
        if (isAdvanced) {
            criteriaFields = this.getDataSource().extractFieldNamesFromAdvancedCriteria(this.getCriteria());
        }
        this.mapRawCriteriaFieldNames(criteriaFields);
        HashSet<String> nonSql = null;
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            String fromField = incFrom.getThisFieldName();
            if (!criteriaFields.contains(fromField)) continue;
            while (incFrom != null) {
                if (!incFrom.getDataSource().canJoinIncludedFields()) {
                    if (nonSql == null) {
                        nonSql = new HashSet<String>();
                    }
                    nonSql.add(fromField);
                }
                incFrom = incFrom.getTargetIncludeFrom();
            }
        }
        return nonSql;
    }

    public boolean criteriaIsDivisible() throws Exception {
        if (!this.getDataSource().isAdvancedCriteria(this.getCriteria())) {
            return true;
        }
        return this.testCriteriaDivisibilityRecursively(this.getCriteria(), false);
    }

    private boolean testCriteriaDivisibilityRecursively(Map criteria, boolean negated) {
        String operator = (String)criteria.get("operator");
        List subCriteria = (List)criteria.get("criteria");
        if (operator.equals("not")) {
            boolean bl = negated = !negated;
        }
        if (operator.equals("or") && !negated || operator.equals("and") && negated) {
            return false;
        }
        if (subCriteria == null) {
            return true;
        }
        for (int i = 0; i < subCriteria.size(); ++i) {
            Map subCrit = (Map)subCriteria.get(i);
            if (this.testCriteriaDivisibilityRecursively(subCrit, negated)) continue;
            return false;
        }
        return true;
    }

    public boolean canSortInQuery() throws Exception {
        ArrayList<String> sortByUndecorated = new ArrayList<String>();
        Iterator i = this.getSortByFields().iterator();
        while (i.hasNext()) {
            String fieldName = new String((String)i.next());
            if (fieldName.indexOf("-") == 0) {
                fieldName = fieldName.substring(1);
            }
            sortByUndecorated.add(fieldName);
        }
        for (IncludeFromDefinition incFrom : this.includeFrom) {
            if (!sortByUndecorated.contains(incFrom.getThisFieldName()) && !sortByUndecorated.contains(incFrom.getDataSourceName() + "." + incFrom.getIncludedFieldName())) continue;
            while (incFrom != null) {
                if (!incFrom.getDataSource().canJoinIncludedFields()) {
                    return false;
                }
                incFrom = incFrom.getTargetIncludeFrom();
            }
        }
        return true;
    }

    public DSRequest setComparator(Comparator comparator) {
        this.comparator = comparator;
        return this;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected DSRequest applyManualSort(DSResponse response) throws Exception {
        return this.applyManualSort(response, false);
    }

    protected DSRequest applyManualSort(DSResponse response, boolean force) throws Exception {
        if (force || !this.canSortInQuery()) {
            Collections.sort(response.getDataList(), this.comparator);
        }
        return this;
    }

    private boolean applyManualGroupByAndAggregation(DSResponse response) throws Exception {
        Map<String, SummaryFunctionType> functions;
        DataSource ds = this.getDataSource();
        if (!ds.shouldApplyManualAggregation()) {
            return false;
        }
        List<String> groupByFields = this.getGroupBy();
        if (groupByFields != null) {
            List<String> fieldNames = ds._getFieldNames();
            for (int i = 0; i < groupByFields.size(); ++i) {
                if (fieldNames.contains(groupByFields.get(i))) continue;
                log.warn("Ignoring request to groupBy unrecognized field '" + groupByFields.get(i) + "'");
            }
            groupByFields = DataTools.setIntersection(groupByFields, fieldNames);
        }
        if ((functions = this.getSummaryFunctions()) != null) {
            for (String functionFieldName : functions.keySet()) {
                SummaryFunctionType type = functions.get(functionFieldName);
                String functionName = type.getFunctionName().toLowerCase();
                if (SummaryFunctions.getSummaryFunction(functionName) != null) continue;
                log.warn("Ignoring unregistered summary function '" + functionName + "'");
            }
        }
        List baseData = response.getRecords();
        if (!(groupByFields != null && groupByFields.size() != 0 || functions != null && functions.size() != 0)) {
            return false;
        }
        ArrayList<Iterator<String>> groupedData = new ArrayList<Iterator<String>>();
        if (groupByFields != null && groupByFields.size() > 0) {
            for (int i = 0; i < baseData.size(); ++i) {
                Iterator<String> grouped = new HashMap();
                for (int j = 0; j < groupByFields.size(); ++j) {
                    String name = groupByFields.get(j);
                    Object value = ((Map)baseData.get(i)).get(name);
                    grouped.put(name, value);
                }
                if (groupedData.contains(grouped)) continue;
                groupedData.add(grouped);
            }
            if (functions == null || functions.size() == 0) {
                response.setData(groupedData);
                if (this.getEndRow() != -1L) {
                    long delta = (long)groupedData.size() - (response.getEndRow() - response.getStartRow());
                    response.setEndRow(response.getEndRow() + delta);
                    response.setTotalRows(response.getTotalRows() + delta);
                }
                return true;
            }
        }
        ArrayList summarizedData = new ArrayList();
        if (groupedData.size() == 0) {
            summarizedData.add(new HashMap());
        } else {
            for (Map map : groupedData) {
                summarizedData.add(new HashMap(map));
            }
        }
        for (String string : functions.keySet()) {
            for (int i = 0; i < summarizedData.size(); ++i) {
                List group = groupedData.size() == 0 ? baseData : DataTools.findAll(baseData, (Map)groupedData.get(i));
                String functionName = functions.get(string).getFunctionName().toLowerCase();
                Object value = SummaryFunctions.applySummaryFunction(group, ds, ds.getField(string), functionName);
                ((Map)summarizedData.get(i)).put(string, value);
            }
        }
        response.setData(summarizedData);
        if (this.getEndRow() != -1L) {
            long delta = (long)summarizedData.size() - (response.getEndRow() - response.getStartRow());
            response.setEndRow(response.getEndRow() + delta);
            response.setTotalRows(response.getTotalRows() + delta);
        }
        return true;
    }

    private DSRequest mapRawCriteriaFieldNames(List names) {
        for (int i = 0; i < names.size(); ++i) {
            String rawField = (String)names.get(i);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, rawField);
            if (incFrom == null) continue;
            names.set(i, incFrom.getThisFieldName());
        }
        return this;
    }

    private DSRequest mapRawOutputFieldNames(List names) {
        for (int i = 0; i < names.size(); ++i) {
            String rawField = (String)names.get(i);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forRelatedField(this.includeFrom, rawField, this.ds);
            if (incFrom == null) continue;
            names.set(i, incFrom.getThisFieldName());
        }
        return this;
    }

    private DSRequest mapSimpleCriteria(SimpleCriteria sc) {
        for (String key : sc.keySet()) {
            Object criteriaValue = sc.get(key);
            IncludeFromDefinition incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, key);
            if (incFrom == null) continue;
            sc.put(incFrom.getThisFieldName(), criteriaValue);
            sc.remove(key);
        }
        return this;
    }

    private DSRequest mapRawAdvancedCriteria(Map ac) {
        this.mapRawAdvancedCriteriaRecursively((List)ac.get("criteria"));
        return this;
    }

    private DSRequest mapRawAdvancedCriteriaRecursively(List criteria) {
        if (criteria == null || criteria.size() == 0) {
            return this;
        }
        for (Map criterion : criteria) {
            IncludeFromDefinition incFrom;
            String fieldName = (String)criterion.get("fieldName");
            if (fieldName != null && (incFrom = IncludeFromDefinition.forCriteriaField(this.includeFrom, fieldName)) != null) {
                criterion.put("fieldName", incFrom.getThisFieldName());
            }
            List subcriteria = (List)criterion.get("criteria");
            this.mapRawAdvancedCriteriaRecursively(subcriteria);
        }
        return this;
    }

    public DSRequest addToCriteria(String fieldName, Object value) throws Exception {
        String baseType;
        BasicDataSource bds;
        DSField field;
        if (!this.getIsAdvancedCriteria()) {
            this.getCriteria().put(fieldName, value);
            if (this.beenThroughDMI) {
                this.createIncludeFromDefinitionFromCriteria(fieldName, this.includeFrom, true);
            }
            this.addExpressionField(fieldName);
            return this;
        }
        DataSource ds = this.getDataSource();
        if (ds instanceof BasicDataSource && (field = (bds = (BasicDataSource)ds).getField(fieldName)) != null && ("text".equals(baseType = bds.getSimpleBaseType(field.getType())) || ("integer".equals(baseType) || "float".equals(baseType)) && value instanceof String)) {
            String textMatchStyle = this.getTextMatchStyle();
            String operatorId = null;
            if (textMatchStyle == null) {
                textMatchStyle = bds.getProperty("defaultTextMatchStyle");
            }
            if (textMatchStyle == null) {
                textMatchStyle = "exact";
            }
            operatorId = textMatchStyle.equals("exactCase") ? "equals" : (textMatchStyle.equals("exact") ? "iEquals" : (textMatchStyle.equals("startsWith") ? "iStartsWith" : "iContains"));
            return this.addToCriteria(fieldName, operatorId, (Object)value.toString());
        }
        return this.addToCriteria(fieldName, "equals", value);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value) throws Exception {
        return this.addToCriteria(fieldName, operator, value, null, null);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object[] value) throws Exception {
        return this.addToCriteria(new SetCriterion(fieldName, operator, value));
    }

    public DSRequest addToCriteria(String fieldName, OperatorBase operator, Object value) throws Exception {
        return this.addToCriteria(fieldName, operator.getID(), value, null, null);
    }

    public DSRequest addToCriteria(String fieldName, OperatorBase operator, Object[] value) throws Exception {
        return this.addToCriteria(new SetCriterion(fieldName, operator.getID(), value));
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value, Object start, Object end) throws Exception {
        return this.addToCriteria(fieldName, operator, value, start, end, null);
    }

    public DSRequest addToCriteria(String fieldName, String operator, Object value, Object start, Object end, List<Criterion> subCriteria) throws Exception {
        Map ac;
        String op;
        if (operator == null && subCriteria == null) {
            return this.addToCriteria(fieldName, value);
        }
        if (operator == null) {
            operator = "equals";
        }
        if (this.getCriteria() == null) {
            this.setCriteria(new HashMap());
        }
        if (!this.getIsAdvancedCriteria()) {
            this.setAdvancedCriteria(this.getAdvancedCriteria());
        }
        if ((op = (String)(ac = this.getCriteria()).get("operator")) == null) {
            throw new Exception("Top-level AdvancedCriteria has no operator specified");
        }
        Map<Object, Object> newClause = new HashMap<String, Object>();
        if (fieldName == null && subCriteria == null) {
            throw new Exception("Invalid parameters - both fieldName and criteria are null");
        }
        if (fieldName != null) {
            newClause.put("fieldName", fieldName);
        }
        if (subCriteria != null) {
            ArrayList<Map<String, Object>> convertedCriteria = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < subCriteria.size(); ++i) {
                convertedCriteria.add(AdvancedCriteria.getCriteriaAsMap(subCriteria.get(i)));
            }
            newClause.put("criteria", convertedCriteria);
        }
        newClause.put("operator", operator);
        if (value != null) {
            newClause.put("value", value);
        }
        if (start != null) {
            newClause.put("start", start);
        }
        if (end != null) {
            newClause.put("end", end);
        }
        if (!op.equals("and")) {
            HashMap<String, Object> topLevel = new HashMap<String, Object>(ac);
            topLevel.put("operator", "and");
            ArrayList<Map> crit = new ArrayList<Map>();
            crit.add(newClause);
            crit.add(ac);
            topLevel.put("criteria", crit);
            this.setCriteria(topLevel);
        } else {
            Object critObj = ac.get("criteria");
            if (!(critObj instanceof List) && critObj != null) {
                throw new Exception("Top-level AdvancedCriteria has 'criteria' property that is not a java.util.List");
            }
            ArrayList<HashMap<String, Object>> crit = (ArrayList<HashMap<String, Object>>)critObj;
            if (crit == null) {
                crit = new ArrayList<HashMap<String, Object>>();
                ac.put("criteria", crit);
            }
            if (Boolean.TRUE.equals(ac.get("__normalized"))) {
                AdvancedCriteria temp = DataSource.parseAdvancedCriteria(newClause);
                newClause = temp.getCriteriaAsMap();
                newClause.put("__normalized", true);
            }
            crit.add((HashMap<String, Object>)newClause);
        }
        if (!Boolean.TRUE.equals(ac.get("__normalized"))) {
            this.setAdvancedCriteria(this.getAdvancedCriteria());
        }
        if (this.beenThroughDMI) {
            if (fieldName != null) {
                this.createIncludeFromDefinitionFromCriteria(fieldName, this.includeFrom, true);
                this.addExpressionField(fieldName);
            } else {
                this.createIncludeFromDefinitionFromCriteria(this.includeFrom, true);
                this.buildExpressionFieldsFromCriteria();
            }
        }
        return this;
    }

    public DSRequest addToCriteria(Criterion criterion) throws Exception {
        if (criterion instanceof SimpleCriterion) {
            SimpleCriterion sc = (SimpleCriterion)criterion;
            return this.addToCriteria(sc.getFieldName(), sc.getOperatorId(), sc.getValue(), null, null);
        }
        if (criterion instanceof CustomCriterion) {
            CustomCriterion cc = (CustomCriterion)criterion;
            return this.addToCriteria(cc.getFieldName(), cc.getOperatorId(), cc.getValue(), null, null);
        }
        if (criterion instanceof IsNullCriterion) {
            IsNullCriterion ic = (IsNullCriterion)criterion;
            return this.addToCriteria(ic.getFieldName(), ic.getOperatorId(), ic.getValue(), null, null);
        }
        if (criterion instanceof NotNullCriterion) {
            NotNullCriterion nc = (NotNullCriterion)criterion;
            return this.addToCriteria(nc.getFieldName(), nc.getOperatorId(), nc.getValue(), null, null);
        }
        if (criterion instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criterion;
            return this.addToCriteria(lc.getFieldName(), lc.getOperatorId(), lc.getValue(), null, null, lc.getCriteria());
        }
        if (criterion instanceof OtherFieldCriterion) {
            OtherFieldCriterion oc = (OtherFieldCriterion)criterion;
            return this.addToCriteria(oc.getFieldName(), oc.getOperatorId(), oc.getOtherFieldName(), null, null);
        }
        if (criterion instanceof SetCriterion) {
            SetCriterion sc = (SetCriterion)criterion;
            return this.addToCriteria(sc.getFieldName(), sc.getOperatorId(), sc.getValues(), null, null);
        }
        RangeCriterion rc = (RangeCriterion)criterion;
        return this.addToCriteria(rc.getFieldName(), rc.getOperatorId(), rc.getValue(), rc.getMin(), rc.getMax());
    }

    public DSRequest addToCriteria(AdvancedCriteria criteria) throws Exception {
        return this.addToCriteria(criteria.asCriterion());
    }

    public Map getParentNode() {
        return (Map)this.getParameter("parentNode");
    }

    public String getResultTreeIdField() {
        return (String)this.getParameter("resultTreeIdField");
    }

    public String getResultTreeParentIdField() {
        return (String)this.getParameter("resultTreeParentIdField");
    }

    public boolean getKeepParentsOnFilter() {
        return DataTools.getBoolean(this.requestData, "keepParentsOnFilter", false);
    }

    public List getMissingPrimaryKeysForAdd() throws Exception {
        return this.getMissingPrimaryKeysForAdd(this.getValues());
    }

    public List getMissingPrimaryKeysForAdd(int valueSetIndex) throws Exception {
        Object valuesObj = this.getValueSets().get(valueSetIndex);
        if (!(valuesObj instanceof Map)) {
            throw new Exception("valueSets[" + valueSetIndex + "] is not a Map!");
        }
        Map valueMap = (Map)valuesObj;
        return this.getMissingPrimaryKeysForAdd(valueMap);
    }

    public List getMissingPrimaryKeysForAdd(Map values) throws Exception {
        if (!"add".equals(this.getOperationType()) || !config.getBoolean((Object)"validate.primaryKeys.for.add", true) || !this.isClientRequest() || this.getAllowMultiUpdate()) {
            return new ArrayList();
        }
        DataSource ds = this.getDataSource();
        ArrayList passedKeys = new ArrayList(values.keySet());
        List<String> keysPresent = DataTools.setIntersection(ds.getPrimaryKeys(), passedKeys);
        List keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), keysPresent);
        Iterator missing = keysMissing.iterator();
        while (missing.hasNext()) {
            DSField field = ds.getField((String)missing.next());
            if (field == null || !field.isAutoGenerated() && !field.containsKey("customInsertExpression")) continue;
            missing.remove();
        }
        return keysMissing;
    }

    public boolean trackTimings() {
        if (!config.getBoolean((Object)"DSRequest.allowReturnTimingData", true)) {
            return false;
        }
        Boolean shouldTrack = this.shouldTrackTimings();
        if (shouldTrack != null) {
            return Boolean.TRUE.equals(shouldTrack);
        }
        if (this.context != null && this.context.request != null) {
            Boolean track = null;
            try {
                track = (Boolean)this.context.request.getSession(false).getAttribute("__isc_trackServerTimings");
            }
            catch (Exception e) {
                return false;
            }
            if (Boolean.TRUE.equals(track)) {
                return true;
            }
            if (Boolean.FALSE.equals(track)) {
                return false;
            }
        }
        return config.getBoolean((Object)"DSRequest.returnTimingData", false);
    }

    protected Boolean shouldTrackTimings() {
        if (this._shouldTrackTimings != null) {
            return this._shouldTrackTimings;
        }
        RPCManager rpc = this.getRPCManager();
        if (rpc != null) {
            return rpc.shouldTrackTimings();
        }
        return Boolean.FALSE;
    }

    public void setShouldTrackTimings(Boolean newValue) {
        RPCManager rpc;
        this._shouldTrackTimings = newValue;
        if (newValue != null && (rpc = this.getRPCManager()) != null) {
            rpc.setShouldTrackTimings(newValue);
        }
    }

    public void recordTimingData(String description, TimingLogType type) {
        this.recordTimingData(description, type, Long.MIN_VALUE);
    }

    public void recordTimingData(String description, TimingLogType type, long millis) {
        Map<String, Long> timing;
        Stack<Map<String, Long>> timingStack;
        if (!this.trackTimings()) {
            return;
        }
        if (millis == Long.MIN_VALUE) {
            millis = System.currentTimeMillis();
        }
        if ((timingStack = (Stack<Map<String, Long>>)this.getAttribute("timingStack")) == null) {
            timingStack = new Stack<Map<String, Long>>();
            this.setAttribute("timingStack", timingStack);
        }
        if (timingStack.isEmpty()) {
            timing = new LinkedHashMap();
            timing.put("name", (Long)((Object)"Server processing"));
            timing.put("start", millis);
            ArrayList children = new ArrayList();
            timing.put("children", (Long)((Object)children));
            this.setAttribute("timing", timing);
            timingStack.push(timing);
        }
        timing = (Map)timingStack.peek();
        if (type == TimingLogType.START) {
            work = new LinkedHashMap<String, Object>();
            work.put("name", description);
            work.put("start", millis);
            ArrayList children = new ArrayList();
            work.put("children", children);
            ((List)timing.get("children")).add(work);
            timingStack.push(work);
        } else if (type == TimingLogType.END) {
            timing.put("end", millis);
            timingStack.pop();
        } else {
            work = new LinkedHashMap();
            work.put("name", description);
            work.put("millis", millis);
            ((List)timing.get("children")).add(work);
        }
    }

    public DSRequest copyTimingDataToResponse(DSResponse dsResponse) {
        if (dsResponse != null) {
            dsResponse.setParameter("timing", this.getAttribute("timing"));
        }
        return this;
    }

    public void setSkipCacheSync(boolean skipCacheSync) {
        this.skipCacheSync = skipCacheSync;
    }

    public boolean isCacheSyncSkipped() {
        return this.skipCacheSync;
    }

    public DSRequest setSkipAudit(boolean skipAudit) {
        this.skipAudit = skipAudit;
        return this;
    }

    public boolean isAuditSkipped() {
        if (this.skipAudit != null) {
            return this.skipAudit;
        }
        boolean reqSkipAudit = DataTools.getBoolean(this.getOperationConfig(), "skipAudit", false);
        try {
            DataSource ds = this.getDataSource();
            DataTypeMap opBinding = ds.getOperationBinding(this);
            return DataTools.getBoolean((Map)((Object)opBinding), "skipAudit", reqSkipAudit);
        }
        catch (Exception exception) {
            return reqSkipAudit;
        }
    }

    public void setAllowAnyRPC(boolean allowAnyRPC) {
        this.allowAnyRPC = allowAnyRPC;
    }

    public boolean getAllowAnyRPC() {
        return this.allowAnyRPC;
    }

    public void setCanSyncCache(boolean canSyncCache) {
        this.setOperationProperty("canSyncCache", canSyncCache);
    }

    public DSRequest setCallback(DSRequestCallback callback) {
        this.callback = callback;
        return this;
    }

    public DSRequestCallback getCallback() {
        return this.callback;
    }

    public String getMultiInsertStrategy() {
        DataTypeMap opBinding;
        String strategy = (String)this.getParameter("multiInsertStrategy");
        BasicDataSource dataSource = null;
        try {
            dataSource = (BasicDataSource)this.getDataSource();
        }
        catch (Exception e) {
            log.warn((Object)"Exception trying to getDataSource()", e);
        }
        if (strategy == null && dataSource != null && (opBinding = dataSource.getOperationBinding(this)) != null) {
            strategy = (String)opBinding.get("multiInsertStrategy");
        }
        if (strategy == null && dataSource != null) {
            strategy = dataSource.getMultiInsertStrategy();
        }
        return strategy != null ? strategy : config.getString("sql.multi.insert.strategy", "simple");
    }

    public Long getMultiInsertBatchSize() {
        DataTypeMap opBinding;
        Long batchSize = DataTools.getLong((Number)this.getParameter("multiInsertBatchSize"));
        BasicDataSource dataSource = null;
        try {
            dataSource = (BasicDataSource)this.getDataSource();
        }
        catch (Exception e) {
            log.warn((Object)"Exception trying to getDataSource()", e);
        }
        if (batchSize == null && dataSource != null && (opBinding = dataSource.getOperationBinding(this)) != null) {
            batchSize = DataTools.getLong((Map)((Object)opBinding), "multiInsertBatchSize");
        }
        if (batchSize == null && dataSource != null) {
            batchSize = dataSource.getMultiInsertBatchSize();
        }
        return batchSize != null ? batchSize.longValue() : config.getLong((Object)"sql.multi.insert.batchSize", 50L);
    }

    public String getMultiInsertNonMatchingStrategy() {
        DataTypeMap opBinding;
        String strategy = (String)this.getParameter("multiInsertNonMatchingStrategy");
        BasicDataSource dataSource = null;
        try {
            dataSource = (BasicDataSource)this.getDataSource();
        }
        catch (Exception e) {
            log.warn((Object)"Exception trying to getDataSource()", e);
        }
        if (strategy == null && dataSource != null && (opBinding = dataSource.getOperationBinding(this)) != null) {
            strategy = (String)opBinding.get("multiInsertNonMatchingStrategy");
        }
        if (strategy == null && dataSource != null) {
            strategy = dataSource.getMultiInsertNonMatchingStrategy();
        }
        return strategy != null ? strategy : config.getString("sql.multi.insert.non.matching.strategy", PAD_WITH_NULLS_STRATEGY);
    }

    public boolean shouldDeferCacheSync() throws Exception {
        if (this._deferCacheSync == null) {
            DataTypeMap opBinding;
            if (!(DataSource.isAdd(this.getOperationType()) || DataSource.isUpdate(this.getOperationType()) || DataSource.isRemove(this.getOperationType()))) {
                this._deferCacheSync = false;
                return false;
            }
            boolean isExplicit = true;
            String syncTiming = (String)this.getParameter("cacheSyncTiming");
            BasicDataSource dataSource = null;
            try {
                dataSource = (BasicDataSource)this.getDataSource();
            }
            catch (Exception e) {
                log.warn((Object)"Exception trying to getDataSource()", e);
            }
            if (syncTiming == null && dataSource != null && (opBinding = dataSource.getOperationBinding(this)) != null) {
                syncTiming = (String)opBinding.get("cacheSyncTiming");
            }
            if (syncTiming == null && dataSource != null) {
                syncTiming = dataSource.getCacheSyncTiming();
            }
            if (syncTiming == null) {
                isExplicit = false;
                syncTiming = dataSource.getDefaultCacheSyncTiming();
                if (syncTiming == null) {
                    syncTiming = config.getString("default.cache.sync.timing", "immediate");
                }
            }
            if (!"immediate".equals(syncTiming) && !dataSource.shouldDeferCacheSync(this)) {
                syncTiming = "immediate";
            }
            if (!"immediate".equals(syncTiming)) {
                boolean audit = dataSource.shouldAuditRequest(this);
                boolean childUpdates = dataSource.requestRequiresChildUpdates(this);
                if (audit || childUpdates) {
                    if (isExplicit) {
                        log.warn("DataSource '" + dataSource.getName() + "', operation '" + this.getOperationId() + "' is explicitly configured for lazy cache sync at the dataSource, operation or request level, but this cannot be allowed because " + (audit ? "automatic auditing is in place" : "relational integrity updates are required") + ".  The lazy cache sync request will be ignored");
                    }
                    syncTiming = "immediate";
                }
            }
            if (!isExplicit && this.ds.shouldAutoSwitchCacheSyncTiming() && (this.isClientRequest() || this.getRPCManager() != null && !Boolean.TRUE.equals(this.getRPCManager().getAttribute("__doNotForceImmediateCacheSync")))) {
                if (!"immediate".equals(syncTiming)) {
                    Object msg = "Switching cacheSyncTiming to 'immediate' because";
                    if (this.isClientRequest()) {
                        msg = (String)msg + " this is a client '" + this.getOperationType() + "' request";
                    } else if (this.getRPCManager() != null) {
                        msg = (String)msg + " this request is associated with an RPCManager";
                    }
                    if (dataSource.shouldAuditRequest(this)) {
                        if (!((String)msg).endsWith("because")) {
                            msg = (String)msg + " and";
                        }
                        msg = (String)msg + " this request is going to be automatically audited";
                    }
                    msg = (String)msg + " (dataSource is '" + dataSource.getName() + "')";
                    log.info(msg);
                }
                syncTiming = "immediate";
            }
            this._deferCacheSync = "lazy".equals(syncTiming);
        }
        return this._deferCacheSync;
    }

    public void setWarnIfFieldLevelSecurityFails(boolean value) {
        this._warnIfFieldLevelSecurityFails = value;
    }

    public boolean warnIfFieldLevelSecurityFails() {
        return this._warnIfFieldLevelSecurityFails;
    }

    public CacheSyncStrategy getCacheSyncStrategy() {
        if (this._discoveredCacheSyncStrategy == null) {
            CacheSyncStrategy strategy;
            List originalValueSets;
            DataTypeMap opBinding;
            BasicDataSource dataSource = null;
            try {
                dataSource = (BasicDataSource)this.getDataSource();
            }
            catch (Exception e) {
                log.warn((Object)"Exception trying to getDataSource()", e);
            }
            if (!(DataSource.isAdd(this.getOperationType()) || DataSource.isUpdate(this.getOperationType()) || DataSource.isRemove(this.getOperationType()) || dataSource == null)) {
                this._discoveredCacheSyncStrategy = dataSource.getCacheSyncStrategy("none");
                return this._discoveredCacheSyncStrategy;
            }
            boolean isExplicit = true;
            String strategyName = (String)this.getParameter("cacheSyncStrategy");
            if (strategyName == null && dataSource != null && (opBinding = dataSource.getOperationBinding(this)) != null) {
                strategyName = (String)opBinding.get("cacheSyncStrategy");
            }
            if (strategyName == null && dataSource != null) {
                strategyName = dataSource.getCacheSyncStrategyName();
            }
            if (strategyName == null) {
                isExplicit = false;
                strategyName = dataSource.getDefaultCacheSyncStrategyName();
                if (strategyName == null) {
                    strategyName = config.getString("default.cache.sync.strategy", "refetch");
                }
            }
            if (((originalValueSets = (List)this.getAttribute("originalValueSets")) != null && originalValueSets.size() > 1 || this.getValueSets().size() > 1) && !isExplicit && "none".equals(config.getString("default.multi.update.cache.sync.strategy", "none"))) {
                strategyName = "none";
            }
            if (!DataSource.isAdd(this.getOperationType()) && this.getAllowMultiUpdate() && !isExplicit) {
                Object rowsAffected = this.getAttribute("_affectedRows");
                boolean isMultiUpdate = false;
                if (rowsAffected != null && (Integer)rowsAffected > 1) {
                    isMultiUpdate = true;
                } else if (!config.getBoolean((Object)"suppressInvalidateCacheForMultiUpdatesWithMissingKeys", false)) {
                    try {
                        isMultiUpdate = !this.criteriaHasPKs(this.getCriteria(false), dataSource.getPrimaryKeys(), true);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Caught Exception trying to determine if all primaryKeys are present", e);
                    }
                }
                if (isMultiUpdate) {
                    log.info("An update request on dataSource '" + dataSource.getName() + "' for operationBinding '" + this.getOperationId() + "' is either marked allowMultiUpdate: true, or is defaulting to allowMultiUpdate because it is a server-side request, and is either updating more than one record, or does not have a value for the primaryKey field(s).  Because this update does not explicitly declare a cacheSyncStrategy on either the request or the operation, we are therefore switching to 'none'");
                    strategyName = "none";
                }
            }
            if (!isExplicit) {
                if (strategyName.equals("requestValuesPlusSequences")) {
                    String baseMessage = "Switching from default CacheSyncStrategy 'requestValuesPlusSequences' to 'refetch' because";
                    if (BasicDataSource.isUpdate(this.getOperationType())) {
                        boolean requiresChildUpdates = false;
                        try {
                            requiresChildUpdates = dataSource.requestRequiresChildUpdates(this);
                        }
                        catch (Exception e) {
                            log.warn((Object)"Encountered exception while checking if request requires child updates.  Assuming refetch is required", e);
                            requiresChildUpdates = true;
                        }
                        if (requiresChildUpdates) {
                            log.info(baseMessage + " this update request on dataSource '" + dataSource.getName() + "' involves updates to foreign keys to maintain relational integrity (aka child updates)");
                            strategyName = "refetch";
                        } else if (dataSource.hasGeneratedFieldValues(this)) {
                            log.info(baseMessage + " this update request is on a dataSource (" + dataSource.getName() + ") that has generated fields");
                            strategyName = "refetch";
                        } else if (dataSource.requestIsMissingRequiredValues(this)) {
                            log.info(baseMessage + " this update request is missing required values (dataSource is '" + dataSource.getName() + "')");
                            strategyName = "refetch";
                        } else if (!dataSource.requestHasUsableOldValues(this)) {
                            log.info(baseMessage + " this update request does not include 'oldValues', or the 'oldValues' are just a copy of the update data (dataSource is '" + dataSource.getName() + "')");
                            strategyName = "refetch";
                        }
                    } else if (BasicDataSource.isAdd(this.getOperationType())) {
                        if (dataSource.hasGeneratedFieldValues(this)) {
                            log.info(baseMessage + " this add request is on a dataSource (" + dataSource.getName() + ") that has generated fields");
                            strategyName = "refetch";
                        } else if (dataSource.isSequenceModeNone()) {
                            log.info(baseMessage + " this dataSource (" + this.getDataSourceName() + ") uses sequenceMode 'none' so cannot auto-retrieve keys");
                            strategyName = "refetch";
                        }
                    }
                } else if (strategyName.equals("responseValues")) {
                    Object respValuesObj = this.getParameter("_responseValues");
                    ArrayList<Object> respValues = null;
                    if (!(respValuesObj instanceof List)) {
                        if (respValuesObj != null) {
                            respValues = new ArrayList<Object>();
                            respValues.add(respValuesObj);
                        }
                    } else {
                        respValues = (ArrayList<Object>)respValuesObj;
                    }
                    if (BasicDataSource.isUpdate(this.getOperationType())) {
                        if (respValues == null || respValues.size() == 0) {
                            log.info("Default cacheSyncStrategy 'responseValues' is in force for DataSource '" + dataSource.getName() + "', but the responseValues are null or empty.  Switching to 'refetch'");
                            strategyName = "refetch";
                        } else if (respValues.size() > 1) {
                            log.info("Default cacheSyncStrategy 'responseValues' is in force for DataSource '" + dataSource.getName() + "', and there is more than one responseValues record; we will not check for missing values");
                        } else if (!(respValues.get(0) instanceof Map)) {
                            log.info("Default cacheSyncStrategy 'responseValues' is in force for DataSource '" + dataSource.getName() + "', but the responseValues record is not an instance of java.util.Map; we will not check for missing values");
                        } else if (dataSource.responseValuesMissingRequiredValue(this, (Map)respValues.get(0))) {
                            log.info("Default cacheSyncStrategy 'responseValues' is in force for DataSource '" + dataSource.getName() + "', but the responseValues record is missing a value for a required field.  Switching to 'refetch'");
                            strategyName = "refetch";
                        }
                    }
                }
            }
            if ((strategy = dataSource.getCacheSyncStrategy(strategyName)) == null) {
                log.warn("No registered CacheSyncStrategy for name '" + strategyName + "'.  If you have created a custom cacheSyncStrategy, be sure to register it with CacheSyncStrategy.registerStrategy(). Falling back to 'refetch'");
                strategy = dataSource.getCacheSyncStrategy("refetch");
            }
            this._discoveredCacheSyncStrategyName = strategyName;
            this._discoveredCacheSyncStrategy = strategy;
            if ("none".equals(strategyName)) {
                this.setSkipCacheSync(true);
            }
        }
        return this._discoveredCacheSyncStrategy;
    }

    public String getCacheSyncStrategyName() {
        if (this._discoveredCacheSyncStrategyName == null) {
            this.getCacheSyncStrategy();
        }
        return this._discoveredCacheSyncStrategyName;
    }

    public void setCacheSyncStrategy(String strategyName) {
        try {
            if (this.getDataSource().getCacheSyncStrategy(strategyName) == null) {
                log.warn("No registered CacheSyncStrategy for name '" + strategyName + "'.  If you have created a custom cacheSyncStrategy, be sure to register it with CacheSyncStrategy.registerStrategy()");
            } else {
                this.setParameter("cacheSyncStrategy", strategyName);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Encounctered error in DSRequest.setCacheSyncStrategy()", e);
        }
    }

    public Boolean shouldApplyArrayCriteriaForceExact() throws Exception {
        if (Boolean.TRUE.equals(this.getParameter("arrayCriteriaForceExact")) || Boolean.FALSE.equals(this.getParameter("arrayCriteriaForceExact"))) {
            return (Boolean)this.getParameter("arrayCriteriaForceExact");
        }
        DataTypeMap op = this.getDataSource().getOperationBinding(this);
        if (op != null && op.get("arrayCriteriaForceExact") != null) {
            return (Boolean)op.get("arrayCriteriaForceExact");
        }
        if (this.getDataSource().getConfig().getBoolean("arrayCriteriaForceExact") != null) {
            return this.getDataSource().getConfig().getBoolean("arrayCriteriaForceExact");
        }
        return null;
    }

    public Map getMaxRowsToFetch() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Integer maxRows = null;
        String reason = null;
        try {
            Object requestMaxRowsObj;
            DataSource ds = this.getDataSource();
            if (this.isClientRequest()) {
                Object clientRequestMaxRowsObj = ds.getConfig().get("clientRequestMaxRows");
                if (clientRequestMaxRowsObj != null) {
                    try {
                        maxRows = Integer.parseInt(clientRequestMaxRowsObj.toString());
                        reason = "DataSource clientRequestMaxRows";
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("Caught NumberFormatException attempting read clientRequestMaxRows setting for DataSource " + ds.getID() + ".  The value weread from config was '" + String.valueOf(clientRequestMaxRowsObj) + "'");
                        maxRows = null;
                    }
                } else {
                    maxRows = config.getInteger("sql.clientRequestMaxRows");
                    reason = "Global clientRequestMaxRows";
                }
                if (maxRows != null && maxRows != -1) {
                    result.put("maxRows", maxRows);
                    result.put("reason", reason);
                    return result;
                }
            }
            if ((requestMaxRowsObj = ds.getConfig().get("requestMaxRows")) != null) {
                try {
                    maxRows = Integer.parseInt(requestMaxRowsObj.toString());
                    reason = "DataSource requestMaxRows";
                }
                catch (NumberFormatException nfe) {
                    log.warn("Caught NumberFormatException attempting read requestMaxRows setting for DataSource " + ds.getID() + ".  The value weread from config was '" + String.valueOf(requestMaxRowsObj) + "'");
                    maxRows = null;
                }
            } else {
                maxRows = config.getInteger("sql.requestMaxRows");
                reason = "Global requestMaxRows";
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception trying to derive requestMaxRows", e);
        }
        result.put("maxRows", maxRows == null ? -1 : maxRows);
        result.put("reason", maxRows == null ? "Defaulted to -1" : reason);
        return result;
    }

    public boolean involvesSummaryFunctions() throws Exception {
        Iterator<String> fieldIter;
        if (this.getSummaryFunctions() != null && this.getSummaryFunctions().size() > 0) {
            return true;
        }
        DataSource ds = this.getDataSource();
        DataTypeMap opBinding = ds.getOperationBinding(this);
        if (opBinding != null && opBinding.getMap("summaryFunctions") != null && opBinding.getMap("summaryFunctions").size() > 0) {
            return true;
        }
        Iterator<String> iterator = fieldIter = this.consolidatedOutputs != null && this.consolidatedOutputs.size() > 0 ? this.consolidatedOutputs.iterator() : ds._getFieldNames().iterator();
        while (fieldIter.hasNext()) {
            DSField field = ds.getField(fieldIter.next());
            if (field == null || field.getString("includeSummaryFunction") == null) continue;
            return true;
        }
        return false;
    }

    public boolean isCriteriaTrimmed() {
        return this.criteriaTrimmed;
    }

    public void setCriteriaTrimmed(boolean value) {
        this.criteriaTrimmed = value;
    }

    static {
        boolean first = true;
        Iterator<String> i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responseDataRegex = responseDataRegex + "|";
            }
            responseDataRegex = responseDataRegex + String.valueOf(i.next());
            first = false;
        }
        responseDataRegex = responseDataRegex + ")'|\"(";
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responseDataRegex = responseDataRegex + "|";
            }
            responseDataRegex = responseDataRegex + String.valueOf(i.next());
            first = false;
        }
        responseDataRegex = responseDataRegex + ")\"))? *\\))?(\\[[0-9]+\\]|\\.allRecords)?\\.(last\\.)?[\\$_a-zA-Z][\\$_a-zA-Z0-9]*$";
        responseDataPattern = Pattern.compile(responseDataRegex);
        responsesRegex = "\\$responses\\.(last|first)(\\( *('[\\$_a-zA-Z][\\$_a-zA-Z0-9]*'|\"[\\$_a-zA-Z][\\$_a-zA-Z0-9]*\")( *, *('(";
        first = true;
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + String.valueOf(i.next());
            first = false;
        }
        responsesRegex = responsesRegex + ")'|\"(";
        i = DataSource.OPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + String.valueOf(i.next());
            first = false;
        }
        responsesRegex = responsesRegex + ")\"))? *\\))?\\.(";
        i = DataSource.RESPONSE_PROPS_VALID_FOR_FIELDVALUEEXPRESSION.iterator();
        while (i.hasNext()) {
            if (!first) {
                responsesRegex = responsesRegex + "|";
            }
            responsesRegex = responsesRegex + String.valueOf(i.next());
            first = false;
        }
        responsesRegex = responsesRegex + ")$";
        responsesPattern = Pattern.compile(responsesRegex);
    }

    public static enum TimingLogType {
        START,
        END,
        NORMAL;

    }
}

