/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthStatus;
import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.base.Reflection;
import com.isomorphic.mail.TemplatedMailMessage;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletFileUpload;

public abstract class Authenticator
extends Base
implements IAutoConfigurable,
IAuthenticator {
    public Boolean basicAuth = Boolean.FALSE;
    public String superuserRole = null;
    public List<String> clientSafeFields = new ArrayList<String>();
    public String usernameParameter;
    public String passwordParameter;
    public String passwordConfirmParameter;
    public String passwordResetRequestEmailTemplate;
    public String passwordResetCompleteEmailTemplate;
    public List<String> notify = null;
    protected final String userKey = "user";
    private String realmKey = "isc.auth.realm";
    private String loginCounterKey = "loginCounter";
    private String initialTargetKey = "initialTarget";
    private String jsCallbackKey = "jsCallback";

    @Override
    public void handleAuthStateChange(RequestContext context, String authState, String loginPageURI) throws Exception {
        Object authStatus = null;
        if (authState == null) {
            throw new Exception("No authState submitted");
        }
        int colonIndex = authState.indexOf(":");
        String authStateType = authState.substring(0, colonIndex);
        String authStateValue = authState.substring(colonIndex + 1);
        if ("reset".equals(authStateType)) {
            String resetId = authStateValue;
            if ("initial".equals(resetId)) {
                String username = this.getSubmittedUsername(context);
                if (username == null) {
                    throw new Exception("No username submitted as part of 'forgot password' form");
                }
                try {
                    AuthenticatedUser user = this.getUserById(username);
                    if (user == null) {
                        this.log.info(username + "isn't valid username; treating as email address");
                        user = this.getUserByEmail(username);
                    }
                    if (user == null) {
                        throw new Exception(username + " is neither a username nor email address for any valid account (for password reset request)");
                    }
                    String email = user.getEmail();
                    if (user != null) {
                        if (email == null) {
                            throw new Exception("Unable to acquire email for username (for password reset request): " + username);
                        }
                        resetId = UUID.randomUUID().toString();
                        this.setAuthState(context, user, "reset:" + resetId);
                        HashMap<String, String> templateContext = new HashMap<String, String>((Map<String, String>)((Object)user));
                        String vbt_baseURL = (String)context.request.getAttribute("vbt_baseURL");
                        if (vbt_baseURL == null) {
                            vbt_baseURL = config.getString("vbt_baseURL");
                        }
                        templateContext.put("vbt_baseURL", vbt_baseURL);
                        templateContext.put("loginPageURI", loginPageURI);
                        templateContext.put("resetId", resetId);
                        TemplatedMailMessage.sendSystemMail(templateContext, this.passwordResetRequestEmailTemplate);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error during password reset request for username: " + username), e);
                }
                this.setStatus(context, AuthStatus.RESET_REQUESTED);
                return;
            }
            AuthenticatedUser user = this.getUserByAuthState(context, authState);
            String password = this.getSubmittedPassword(context);
            String passwordConfirm = this.getSubmittedPasswordConfirm(context);
            if (user == null || password == null || passwordConfirm == null) {
                this.setStatus(context, AuthStatus.INVALID_REQUEST);
                return;
            }
            if (!password.equals(passwordConfirm)) {
                this.setStatus(context, AuthStatus.PASSWORDS_DO_NOT_MATCH);
                return;
            }
            this.setPassword(context, user, password);
            try {
                HashMap templateContext = new HashMap(user);
                TemplatedMailMessage.sendSystemMail(templateContext, this.passwordResetCompleteEmailTemplate);
            }
            catch (Exception e) {
                this.log.error((Object)"Password changed succesfully, but email send failed", e);
            }
            try {
                this.setAuthState(context, user, null);
            }
            catch (Exception e) {
                this.log.error((Object)("Error clearing authState for username: " + user.getUserName()), e);
            }
        } else {
            throw new Exception("Invalid authState type: " + authStateType);
        }
        this.setStatus(context, AuthStatus.PASSWORD_RESET_COMPLETE);
    }

    public AuthenticatedUser getUserByEmail(Object id) throws Exception {
        throw new Exception("No account exists for username (for password reset request): " + String.valueOf(id));
    }

    @Override
    public boolean containsCredentials(RequestContext context) throws Exception {
        return this.getSubmittedUsername(context) != null && this.getSubmittedPassword(context) != null;
    }

    @Override
    public String getSubmittedUsername(RequestContext context) throws Exception {
        if (this.basicAuth.booleanValue()) {
            List<String> authCreds = this.basicAuthCreds(context);
            if (authCreds != null) {
                return authCreds.get(0);
            }
            return null;
        }
        String username = this.getRequestParameter(this.usernameParameter, context);
        if (username != null) {
            return username;
        }
        List<String> authCreds = this.basicAuthCreds(context);
        if (authCreds != null) {
            return authCreds.get(0);
        }
        return null;
    }

    protected String getSubmittedPassword(RequestContext context) throws Exception {
        if (this.basicAuth.booleanValue()) {
            List<String> authCreds = this.basicAuthCreds(context);
            if (authCreds != null) {
                return authCreds.get(1);
            }
            return null;
        }
        String password = this.getRequestParameter(this.passwordParameter, context);
        if (password != null) {
            return password;
        }
        List<String> authCreds = this.basicAuthCreds(context);
        if (authCreds != null) {
            return authCreds.get(1);
        }
        return null;
    }

    protected String getSubmittedPasswordConfirm(RequestContext context) throws Exception {
        return this.getRequestParameter(this.passwordConfirmParameter, context);
    }

    protected List<String> basicAuthCreds(RequestContext context) throws Exception {
        String authHeader = context.request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(authHeader);
        if (st.hasMoreTokens()) {
            String basic = st.nextToken();
            if (basic.equalsIgnoreCase("Basic")) {
                String credentials = new String(DataTools.base64DecodeToBytes(st.nextToken()), "UTF-8");
                int p = credentials.indexOf(":");
                if (p != -1) {
                    String login = credentials.substring(0, p).trim();
                    String password = credentials.substring(p + 1).trim();
                    return DataTools.buildList(login, password);
                }
                throw new Exception("Invalid authentication token in Authorization header");
            }
            throw new Exception("Unsupported Authorization style '" + basic + "'");
        }
        return null;
    }

    protected String getRequestParameter(String parameterName, RequestContext context) {
        if (JakartaServletFileUpload.isMultipartContent((HttpServletRequest)context.request)) {
            Map<String, String> queryParams = null;
            try {
                queryParams = ServletTools.parseQueryString(context.request.getQueryString());
            }
            catch (Exception e) {
                RequestContext.staticLog.error((Object)"Authenticator can't parse queryParams", e);
                return null;
            }
            return queryParams.get(parameterName);
        }
        return context.request.getParameter(parameterName);
    }

    @Override
    public void logout(RequestContext context) throws Exception {
        if (this.notify != null) {
            for (String clazz : this.notify) {
                try {
                    Reflection.invokeStaticMethod(clazz, "authenticationEvent", "logout", context);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error while firing " + clazz + ".notify(\"logout\")"), e);
                }
            }
        }
        this.clearAuthInfo(context);
    }

    @Override
    public Principal authenticate(RequestContext context) throws Exception {
        throw new Exception("Attempt to call authenticate() on base Authenticator class - invalid");
    }

    @Override
    public void setUser(RequestContext context, Principal user) throws Exception {
        this.setContextValue(context, "user", user);
        if (context.request instanceof ISCHttpServletRequest) {
            context.request.setUserPrincipal(user);
        }
        if (this.notify != null) {
            for (String clazz : this.notify) {
                try {
                    Reflection.invokeStaticMethod(clazz, "authenticationEvent", "login", context);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error while firing " + clazz + ".notify(\"login\")"), e);
                }
            }
        }
    }

    @Override
    public Principal getUser(RequestContext context) throws Exception {
        return (Principal)this.getContextValue(context, "user");
    }

    @Override
    public void setRealm(RequestContext context, String realm) throws Exception {
        context.request.setAttribute(this.realmKey, realm);
    }

    @Override
    public String getRealm(RequestContext context) throws Exception {
        return (String)context.request.getAttribute(this.realmKey);
    }

    @Override
    public void setLoginCounter(RequestContext context, int counter) throws Exception {
        this.setContextValue(context, this.loginCounterKey, counter);
    }

    @Override
    public int getLoginCounter(RequestContext context) throws Exception {
        Integer counter = (Integer)this.getContextValue(context, this.loginCounterKey);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    @Override
    public String getInitialTarget(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.initialTargetKey);
    }

    @Override
    public void setInitialTarget(RequestContext context, String initialTarget) throws Exception {
        if (ServletTools.isRealtimeMessaging(initialTarget)) {
            return;
        }
        this.setContextValue(context, this.initialTargetKey, initialTarget);
    }

    @Override
    public String getInitialTargetJsCallback(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.jsCallbackKey);
    }

    @Override
    public void setInitialTargetJsCallback(RequestContext context, String jsCallback) throws Exception {
        this.setContextValue(context, this.jsCallbackKey, jsCallback);
    }

    public String getAuthStateKey(RequestContext context) {
        String realm = (String)context.request.getAttribute(this.realmKey);
        if (realm == null) {
            return null;
        }
        return "isc.auth.state." + realm;
    }

    public void clearAuthInfo(RequestContext context) throws Exception {
        String authStateKey = this.getAuthStateKey(context);
        if (authStateKey == null) {
            return;
        }
        if (context.session != null) {
            context.session.setAttribute(authStateKey, null);
        }
    }

    protected Object getContextValue(RequestContext context, String key) throws Exception {
        String authStateKey = this.getAuthStateKey(context);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(false);
        }
        if (context.session == null) {
            return null;
        }
        Map contextStore = (Map)context.session.getAttribute(authStateKey);
        if (contextStore == null) {
            return null;
        }
        return contextStore.get(key);
    }

    protected void setContextValue(RequestContext context, String key, Object value) throws Exception {
        HashMap<String, Object> contextStore;
        String authStateKey = this.getAuthStateKey(context);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (HashMap<String, Object>)context.session.getAttribute(authStateKey)) == null) {
            contextStore = new HashMap<String, Object>();
            context.session.setAttribute(authStateKey, contextStore);
        }
        contextStore.put(key, value);
    }

    @Override
    public Object getUserId(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Override
    public String getUserName(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user != null) {
            if (user instanceof AuthenticatedUser) {
                return ((AuthenticatedUser)user).getUserName();
            }
            String o = user.getName();
            if (o == null) {
                return null;
            }
            return o.toString();
        }
        return null;
    }

    @Override
    public void track(RequestContext context) throws Exception {
        if (this.notify != null) {
            for (String clazz : this.notify) {
                try {
                    Reflection.invokeStaticMethod(clazz, "authenticationEvent", "track", context);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error while firing " + clazz + ".notify(\"logout\")"), e);
                }
            }
        }
    }

    @Override
    public List<String> getUserRoles(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user instanceof Map) {
            return this.getUserRoles((Map)((Object)user));
        }
        if (user == null) {
            return new ArrayList<String>();
        }
        throw new Exception("Expected the user to implement Map, but got: " + user.getClass().getName());
    }

    @Override
    public List<String> getUserRoles(Map userData) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public String getSuperUserRole() {
        return this.superuserRole;
    }

    @Override
    public List<String> getClientSafeFields() {
        return this.clientSafeFields;
    }

    @Override
    public void setStatus(RequestContext context, AuthStatus status) throws Exception {
        context.request.setAttribute("isc_auth_status", (Object)status);
    }

    @Override
    public AuthStatus getStatus(RequestContext context) throws Exception {
        return (AuthStatus)((Object)context.request.getAttribute("isc_auth_status"));
    }
}

