/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class TempByteHolder {
    byte[] _memory_buffer = null;
    boolean _file_mode = false;
    int _window_size = 0;
    int _window_low = 0;
    int _window_high = 0;
    int _file_high = 0;
    int _write_pos = 0;
    int _read_pos = 0;
    int _file_pos = -1;
    int _mark_pos = 0;
    OutputStream _output_stream = new OutputStream();
    InputStream _input_stream = null;
    File _temp_directory = null;
    File _tempfilef = null;
    RandomAccessFile _tempfile = null;

    public TempByteHolder(int in_memory_capacity) {
        this(new byte[in_memory_capacity], 0, 0);
    }

    public TempByteHolder(byte[] byte_array) {
        this(byte_array, 0, 0);
    }

    public TempByteHolder(byte[] byte_array, int offset, int prefilled_data_size) {
        if (byte_array == null) {
            throw new NullPointerException();
        }
        this._window_size = byte_array.length;
        if (offset < 0 || offset > this._window_size) {
            throw new IllegalArgumentException("Bad prefilled data offset");
        }
        if (offset + prefilled_data_size > this._window_size || prefilled_data_size < 0) {
            throw new IllegalArgumentException("Bad prefilled data size");
        }
        this._memory_buffer = byte_array;
        this._write_pos = prefilled_data_size;
        this._window_low = -offset;
        this._window_high = this._window_size - offset;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public void clear() {
        this._file_mode = false;
        this._write_pos = 0;
        this._read_pos = 0;
        this._window_low = 0;
        this._window_high = this._window_size;
        this._file_high = 0;
        this._mark_pos = 0;
    }

    public void close() throws IOException {
        this.clear();
        if (this._tempfile != null) {
            this._tempfile.close();
            this._tempfile = null;
            this._tempfilef.delete();
            this._tempfilef = null;
        }
    }

    public void seek(int offset) throws IOException {
        if (offset > this._write_pos || offset < 0) {
            throw new IOException("bad seek offset");
        }
        this._read_pos = offset;
    }

    public void truncate(int offset) throws IOException {
        if (offset < 0 || offset > this._write_pos) {
            throw new IOException("bad truncate offset");
        }
        if (this._read_pos > offset) {
            this._read_pos = offset;
        }
        if (this._mark_pos > offset) {
            this._mark_pos = offset;
        }
        this._write_pos = offset;
        if (this._file_high > offset) {
            this._file_high = offset;
        }
        this.moveWindow(this._write_pos);
    }

    public void setTempDirectory(File dir) throws IOException {
        File td = dir.getCanonicalFile();
        if (td.isDirectory()) {
            this._temp_directory = td;
        }
    }

    public int getLength() {
        return this._write_pos;
    }

    public boolean isLarge() {
        return this._file_mode;
    }

    public byte[] getBytes() {
        if (this._file_mode) {
            throw new IllegalStateException("data too large");
        }
        return this._memory_buffer;
    }

    public String getString(String character_encoding) throws UnsupportedEncodingException {
        if (this._file_mode) {
            throw new IllegalStateException("data too large");
        }
        return new String(this._memory_buffer, 0, this._write_pos, character_encoding);
    }

    public java.io.OutputStream getOutputStream() {
        return this._output_stream;
    }

    public java.io.InputStream getInputStream() {
        if (this._input_stream == null) {
            this._input_stream = new InputStream();
        }
        return this._input_stream;
    }

    public void writeTo(java.io.OutputStream os) throws IOException {
        this.writeTo(os, 0, this.getLength());
    }

    public void writeTo(java.io.OutputStream os, int start_offset, int length) throws IOException {
        int towrite = TempByteHolder.min(length, this._write_pos - start_offset);
        int writeoff = start_offset;
        if (towrite > 0) {
            while (towrite >= this._window_size) {
                this.moveWindow(writeoff);
                os.write(this._memory_buffer, 0, this._window_size);
                towrite -= this._window_size;
                writeoff += this._window_size;
            }
            if (towrite > 0) {
                this.moveWindow(writeoff);
                os.write(this._memory_buffer, 0, towrite);
            }
        }
    }

    public void readFrom(java.io.InputStream is) throws IOException {
        int howmuch = 0;
        do {
            this._write_pos += howmuch;
            this.moveWindow(this._write_pos);
        } while ((howmuch = is.read(this._memory_buffer)) != -1);
    }

    private void createTempFile() throws IOException {
        this._tempfilef = File.createTempFile("org.openqa.jetty.util.TempByteHolder-", ".tmp", this._temp_directory).getCanonicalFile();
        this._tempfilef.deleteOnExit();
        this._tempfile = new RandomAccessFile(this._tempfilef, "rw");
    }

    private void writeToTempFile(int at_offset, byte[] data, int offset, int len) throws IOException {
        if (this._tempfile == null) {
            this.createTempFile();
            this._file_pos = -1;
        }
        this._file_mode = true;
        if (at_offset != this._file_pos) {
            this._tempfile.seek(at_offset);
        }
        this._tempfile.write(data, offset, len);
        this._file_pos = at_offset + len;
        this._file_high = TempByteHolder.max(this._file_high, this._file_pos);
    }

    private void readFromTempFile(int at_offset, byte[] data, int offset, int len) throws IOException {
        if (this._file_pos != at_offset) {
            this._tempfile.seek(at_offset);
        }
        this._tempfile.readFully(data, offset, len);
        this._file_pos = at_offset + len;
    }

    private void moveWindow(int start_offset) throws IOException {
        if (start_offset != this._window_low) {
            int toread_size;
            int toread_high;
            int toread_low;
            int end_offset = start_offset + this._window_size;
            int dirty_low = this._file_high;
            int dirty_high = this._write_pos;
            int dirty_len = this._write_pos - this._file_high;
            if (dirty_len > 0 && (dirty_low < start_offset || dirty_high > end_offset)) {
                this.writeToTempFile(dirty_low, this._memory_buffer, dirty_low - this._window_low, dirty_len);
            }
            int stay_low = TempByteHolder.max(start_offset, this._window_low);
            int stay_high = TempByteHolder.min(this._write_pos, this._window_high, end_offset);
            int stay_size = stay_high - stay_low;
            if (stay_size > 0) {
                System.arraycopy(this._memory_buffer, stay_low - this._window_low, this._memory_buffer, stay_low - start_offset, stay_size);
            }
            if (stay_low > start_offset) {
                toread_low = start_offset;
                toread_high = TempByteHolder.min(stay_low, end_offset);
                toread_size = toread_high - toread_low;
                if (toread_size > 0) {
                    this.readFromTempFile(toread_low, this._memory_buffer, toread_low - start_offset, toread_size);
                }
            }
            if (stay_high < end_offset) {
                toread_low = TempByteHolder.max(stay_high, start_offset);
                toread_high = TempByteHolder.min(end_offset, this._file_high);
                toread_size = toread_high - toread_low;
                if (toread_size > 0) {
                    this.readFromTempFile(toread_low, this._memory_buffer, toread_low - start_offset, toread_size);
                }
            }
            this._window_low = start_offset;
            this._window_high = end_offset;
        }
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int min(int a, int b, int c) {
        int r = a;
        if (r > b) {
            r = b;
        }
        if (r > c) {
            r = c;
        }
        return r;
    }

    private static boolean contained(int range1_low, int range1_high, int range2_low, int range2_high) {
        return range1_low >= range2_low && range1_high <= range2_high;
    }

    class InputStream
    extends java.io.InputStream {
        InputStream() {
        }

        @Override
        public int read() throws IOException {
            int ret = -1;
            if (!TempByteHolder.contained(TempByteHolder.this._read_pos, TempByteHolder.this._read_pos + 1, TempByteHolder.this._window_low, TempByteHolder.this._window_high)) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._read_pos);
            }
            if (TempByteHolder.this._write_pos > TempByteHolder.this._read_pos) {
                ret = TempByteHolder.this._memory_buffer[TempByteHolder.this._read_pos - TempByteHolder.this._window_low] & 0xFF;
                ++TempByteHolder.this._read_pos;
            }
            return ret;
        }

        @Override
        public int read(byte[] buff) throws IOException {
            return this.read(buff, 0, buff.length);
        }

        @Override
        public int read(byte[] buff, int off, int len) throws IOException {
            int read_size = TempByteHolder.min(len, TempByteHolder.this._write_pos - TempByteHolder.this._read_pos);
            if (read_size > 0) {
                if (read_size >= TempByteHolder.this._window_size) {
                    TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    TempByteHolder.this.readFromTempFile(TempByteHolder.this._read_pos, buff, off, read_size);
                } else {
                    int read_low = TempByteHolder.this._read_pos;
                    int read_high = read_low + read_size;
                    if (!TempByteHolder.contained(read_low, read_high, TempByteHolder.this._window_low, TempByteHolder.this._window_high)) {
                        TempByteHolder.this.moveWindow(TempByteHolder.this._read_pos);
                    }
                    System.arraycopy(TempByteHolder.this._memory_buffer, TempByteHolder.this._read_pos - TempByteHolder.this._window_low, buff, off, read_size);
                }
                TempByteHolder.this._read_pos += read_size;
            }
            return read_size;
        }

        @Override
        public long skip(long bytes) throws IOException {
            if (bytes < 0L || bytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            int len = (int)bytes;
            if (len + TempByteHolder.this._read_pos > TempByteHolder.this._write_pos) {
                len = TempByteHolder.this._write_pos - TempByteHolder.this._read_pos;
            }
            TempByteHolder.this._read_pos += len;
            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            return len;
        }

        @Override
        public int available() throws IOException {
            return TempByteHolder.this._write_pos - TempByteHolder.this._read_pos;
        }

        @Override
        public void mark(int readlimit) {
            TempByteHolder.this._mark_pos = TempByteHolder.this._read_pos;
        }

        @Override
        public void reset() throws IOException {
            TempByteHolder.this._read_pos = TempByteHolder.this._mark_pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }

    class OutputStream
    extends java.io.OutputStream {
        OutputStream() {
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            boolean end_of_data_in_window;
            boolean write_pos_in_window;
            int new_write_pos = TempByteHolder.this._write_pos + len;
            boolean bl = write_pos_in_window = TempByteHolder.this._write_pos >= TempByteHolder.this._window_low && TempByteHolder.this._write_pos < TempByteHolder.this._window_high;
            if (!write_pos_in_window) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            }
            boolean bl2 = end_of_data_in_window = new_write_pos <= TempByteHolder.this._window_high;
            if (end_of_data_in_window) {
                System.arraycopy(data, off, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, len);
                TempByteHolder.this._write_pos = new_write_pos;
            } else {
                int out_of_window = new_write_pos - TempByteHolder.this._window_high;
                if (out_of_window < TempByteHolder.this._window_size) {
                    int part1_len = TempByteHolder.this._window_high - TempByteHolder.this._write_pos;
                    int part2_len = len - part1_len;
                    System.arraycopy(data, off, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, part1_len);
                    TempByteHolder.this._write_pos = TempByteHolder.this._window_high;
                    TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    System.arraycopy(data, off + part1_len, TempByteHolder.this._memory_buffer, 0, part2_len);
                    TempByteHolder.this._write_pos = new_write_pos;
                } else {
                    int part1_size = TempByteHolder.this._window_high - TempByteHolder.this._write_pos;
                    int part2_size = len - part1_size;
                    if (part1_size == TempByteHolder.this._window_size) {
                        TempByteHolder.this.writeToTempFile(TempByteHolder.this._write_pos, data, off, len);
                        TempByteHolder.this._write_pos = new_write_pos;
                        TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    } else {
                        if (part1_size > 0) {
                            System.arraycopy(data, off, TempByteHolder.this._memory_buffer, TempByteHolder.this._write_pos - TempByteHolder.this._window_low, part1_size);
                            TempByteHolder.this._write_pos += part1_size;
                            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                        }
                        TempByteHolder.this.writeToTempFile(TempByteHolder.this._write_pos, data, off + part1_size, part2_size);
                        TempByteHolder.this._write_pos = new_write_pos;
                        TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
                    }
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (TempByteHolder.this._write_pos >= TempByteHolder.this._window_high || TempByteHolder.this._write_pos < TempByteHolder.this._window_low) {
                TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
            }
            TempByteHolder.this._memory_buffer[TempByteHolder.this._write_pos - TempByteHolder.this._window_low] = (byte)(b & 0xFF);
            ++TempByteHolder.this._write_pos;
        }

        @Override
        public void flush() throws IOException {
            TempByteHolder.this.moveWindow(TempByteHolder.this._write_pos);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

