/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLJoinWhereClause
extends Base {
    private static Logger log = new Logger(SQLJoinWhereClause.class.getName());
    List dataSources = null;
    DSRequest dsRequest = null;
    boolean keepUndeclaredFields = false;
    private List includeFrom = null;
    private Boolean useAnsiJoins = null;
    private boolean firstDSJoined = false;
    private List customValueFields = null;
    private List customCriteriaFields = null;
    private Relation sqConnector;
    private Relation sqRelations;
    List joinedDataSources;

    public SQLJoinWhereClause(DSRequest dsRequest, SQLDataSource ds) throws Exception {
        this(dsRequest, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLJoinWhereClause(DSRequest dsRequest, List dataSources) throws Exception {
        this.dataSources = dataSources;
        this.dsRequest = dsRequest;
        this.includeFrom = dsRequest.getIncludeFrom();
        if (dsRequest.isValueOperation()) {
            this.sqConnector = dsRequest.getSubqueryConnector();
            this.sqRelations = dsRequest.getSubqueryRelations();
        }
    }

    public boolean isEmpty() {
        return this.includeFrom == null && this.sqRelations == null && this.sqConnector == null;
    }

    public int size() {
        return this.includeFrom.size();
    }

    public String getSQLString() throws Exception {
        SQLDriver driver;
        String expression;
        if (this.isEmpty()) {
            return "";
        }
        this.useAnsiJoins = DataTools.asBooleanObject((Object)this.dsRequest.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (this.useAnsiJoins == null) {
            this.useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
        this.joinedDataSources = new ArrayList();
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        Object clause = "";
        if (this.includeFrom != null && (!this.useAnsiJoins.booleanValue() || this.dsRequest.isSummaryFunction())) {
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                String expression2;
                Relation relation;
                String includeSummaryFunction;
                if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource) || incFrom.isSummaryFunction() && !this.dsRequest.isSummaryFunction() && !this.dsRequest.isConcatFetchRequest() || incFrom.isValueOperation() && !this.dsRequest.isValueOperation()) continue;
                boolean skip = false;
                for (IncludeFromDefinition _incFrom = incFrom.getTargetIncludeFrom(); _incFrom != null; _incFrom = _incFrom.getTargetIncludeFrom()) {
                    if ((!_incFrom.isSummaryFunction() || this.dsRequest.isSummaryFunction() || this.dsRequest.isConcatFetchRequest()) && (!_incFrom.isValueOperation() || this.dsRequest.isValueOperation())) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                String string = includeSummaryFunction = incFrom.getThisField() == null ? null : incFrom.getThisField().getProperty("includeSummaryFunction");
                if (!this.dsRequest.isSummary() && !this.dsRequest.isSummaryFunction() && includeSummaryFunction != null && (!"CONCAT".equalsIgnoreCase(includeSummaryFunction) || !this.dsRequest.isConcatFetchRequest())) continue;
                DSField thisField = incFrom.getThisField();
                if (thisField != null && thisField.getBoolean("customSQL")) {
                    Iterator j;
                    String thisFieldName = incFrom.getThisFieldName();
                    boolean skipField = true;
                    if (this.customValueFields != null) {
                        j = this.customValueFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField && this.customCriteriaFields != null) {
                        j = this.customCriteriaFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField) continue;
                }
                if ((relation = incFrom.getRelation()) != null && (expression2 = this.buildExpression(relation, firstDS.getDriver())) != null && !"".equals(expression2)) {
                    if (((String)clause).length() > 0) {
                        clause = (String)clause + " AND ";
                    }
                    clause = (String)clause + expression2;
                }
                IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
                while (target != null) {
                    String expression3;
                    DataSource rds = target.getDataSource();
                    relation = target.getRelation();
                    if (relation == null) {
                        thisField = incFrom.getThisField();
                        String includeVia = null;
                        if (thisField != null) {
                            includeVia = thisField.getProperty("includeVia");
                        }
                        relation = incFrom.getDataSource().getRelation(rds, includeVia);
                    }
                    if (relation != null && (expression3 = this.buildExpression(relation, firstDS.getDriver())) != null && !"".equals(expression3)) {
                        if (((String)clause).length() > 0) {
                            clause = (String)clause + " AND ";
                        }
                        clause = (String)clause + expression3;
                    }
                    incFrom = target;
                    target = incFrom.getTargetIncludeFrom();
                }
            }
        }
        if (this.sqRelations != null && !this.useAnsiJoins.booleanValue() && (expression = this.buildExpression(this.sqRelations, driver = ((SQLDataSource)this.dsRequest.getDataSource()).getDriver())) != null && !"".equals(expression)) {
            if (((String)clause).length() > 0) {
                clause = (String)clause + " AND ";
            }
            clause = (String)clause + expression;
        }
        if (this.sqConnector != null && (expression = this.buildExpression(this.sqConnector, driver = ((SQLDataSource)this.dsRequest.getDataSource()).getDriver())) != null && !"".equals(expression)) {
            if (((String)clause).length() > 0) {
                clause = (String)clause + " AND ";
            }
            clause = (String)clause + expression;
        }
        return clause;
    }

    private String buildExpression(Relation relation, SQLDriver driver) throws Exception {
        if (this.useAnsiJoins.booleanValue()) {
            if (!this.dsRequest.isSummaryFunction() && !this.dsRequest.isValueOperation()) {
                return null;
            }
            if (this.firstDSJoined && !this.dsRequest.isConcatFetchRequest()) {
                return null;
            }
        }
        Object overrideTableName = null;
        StringBuffer joinClause = new StringBuffer();
        List fromFields = relation.getFromFields();
        List toFields = relation.getToFields();
        if (toFields.size() != fromFields.size()) {
            throw new Exception("Cannot join DataSources " + relation.getFromDataSource().getName() + " and " + relation.getToDataSource().getName() + " - are your foreignKey definitions correct?");
        }
        String toAlias = relation.getToAlias();
        Object joinedDSKey = relation.getToDataSource().getName();
        if (!this.joinedDataSources.contains(joinedDSKey = (String)joinedDSKey + (String)(toAlias != null ? "*" + toAlias : ""))) {
            SQLDataSource relatedDS = (SQLDataSource)relation.getToDataSource();
            String toTable = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
            if (toAlias != null) {
                toTable = toAlias;
            }
            relatedDS = (SQLDataSource)relation.getFromDataSource();
            String fromTable = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
            String fromAlias = relation.getFromAlias();
            if (fromAlias != null) {
                fromTable = fromAlias;
            }
            for (int i = 0; i < fromFields.size(); ++i) {
                String to = this.getColumnNameForField((DSField)toFields.get(i));
                String from = this.getColumnNameForField((DSField)fromFields.get(i));
                Object escapedTo = relatedDS.getDriver().escapeColumnName(to);
                escapedTo = toTable + "." + (String)escapedTo;
                Object escapedFrom = driver.escapeColumnName(from);
                escapedFrom = fromTable + "." + (String)escapedFrom;
                if (((DSField)fromFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)fromFields.get(i)).get((Object)"customSQLExpression") != null) {
                    escapedFrom = this.getCustomSelectExpression((DSField)fromFields.get(i));
                }
                if (((DSField)toFields.get(i)).get((Object)"customSelectExpression") != null || ((DSField)toFields.get(i)).get((Object)"customSQLExpression") != null) {
                    escapedTo = this.getCustomSelectExpression((DSField)toFields.get(i));
                }
                if (joinClause.length() > 0) {
                    joinClause.append(" AND ");
                }
                joinClause.append(driver.generateJoinClause((String)escapedTo, (String)escapedFrom, relation));
            }
            this.firstDSJoined = true;
            this.joinedDataSources.add(joinedDSKey);
        }
        while (relation.getNextRelation() != null) {
            String expression;
            if (!(relation = relation.getNextRelation()).isValid() || (expression = this.buildExpression(relation, driver)) == null || "".equals(expression)) continue;
            if (joinClause.length() > 0) {
                joinClause.append(" AND ");
            }
            joinClause.append(expression);
        }
        return joinClause.toString();
    }

    private String getColumnNameForField(DSField field) {
        if (field.getNativeName() != null) {
            return field.getNativeName();
        }
        return field.getName();
    }

    private String getCustomSelectExpression(DSField field) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        String expr = (String)field.get((Object)"customSelectExpression");
        if (expr == null) {
            expr = (String)field.get((Object)"customSQLExpression");
        }
        return Velocity.evaluateWithSnippets((String)expr, (Map)context, (String)"customSelectExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }
}

