/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCFileSourceFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ProcessedFileCache {
    private static Logger log = new Logger(ProcessedFileCache.class.getName());
    private static Config config = Config.getGlobal();
    public static final String FALLBACK_TENANT_ID_RECORD = "_fallbackTenantId";
    private static boolean enableUpToDateCheck = false;
    private long stalenessCheckInterval = Config.getGlobal().getLong((Object)"file.stalenessCheckInterval", 0L);
    Map cache = Collections.synchronizedMap(new HashMap());

    protected ProcessedFileCache() {
        enableUpToDateCheck = config.getBoolean((Object)"datasources.enableUpToDateCheck", false);
    }

    public void setStalenessCheckInterval(long millis) {
        this.stalenessCheckInterval = millis;
    }

    public long getStalenessCheckInterval() {
        return this.stalenessCheckInterval;
    }

    public void clearCacheEntry(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public Object getObjectFromFile(ISCFile file) throws Exception {
        return this.getObjectFromFile(file, null);
    }

    public Object getObjectFromFile(ISCFile file, Map flags) throws Exception {
        boolean bypassCache = false;
        if (flags != null && flags.containsKey("bypassCache")) {
            bypassCache = DataTools.asBoolean(flags.get("bypassCache"));
        }
        if (!bypassCache) {
            String name = file.getCanonicalPath();
            String tenantId = this.getFileTenantId(file);
            CacheEntry entry = this.getCachedObject(name, tenantId);
            long timeStamp = -1L;
            if (entry != null) {
                long currentTime = System.currentTimeMillis();
                if (!enableUpToDateCheck || currentTime - entry.lastStalenessCheck <= this.stalenessCheckInterval) {
                    return entry.cachedObject;
                }
                timeStamp = file.lastModified();
                if (timeStamp == 0L) {
                    log.warning("Can't perform staleness checking for " + name);
                }
                if (entry.timeStamp == timeStamp) {
                    entry.lastStalenessCheck = currentTime;
                    return entry.cachedObject;
                }
                if (log.isDebugEnabled()) {
                    log.debug("STALE object for file '" + name + "', reloading (file timestamp " + timeStamp + ", cache timestamp " + entry.timeStamp + ")");
                }
                if (flags != null) {
                    flags.put("objectWasStale", Boolean.TRUE);
                }
            }
            if (timeStamp == -1L && enableUpToDateCheck) {
                timeStamp = file.lastModified();
            }
            CachingConfig cachingConfig = tenantId != null ? new CachingConfig() : null;
            Object loadedObject = this.loadAndUnwrapObjectFromFile(file, cachingConfig);
            if (timeStamp > 0L || !enableUpToDateCheck) {
                boolean isDSPath = name.startsWith("ds://");
                if (isDSPath && DataSource.isSandboxEligible(DataSource.parentDataSourceId(name))) {
                    log.debug((Object)"Not cacheable: ", name);
                } else {
                    this.cacheObject(name, loadedObject, timeStamp, tenantId, cachingConfig);
                }
            }
            return loadedObject;
        }
        return this.loadAndUnwrapObjectFromFile(file);
    }

    public Object getObjectFromFile(String fileName) throws Exception {
        return this.getObjectFromFile(ISCFile.newInstance(fileName));
    }

    protected String getFileTenantId(ISCFile file) {
        DSFileSpec fileSpec;
        if (file instanceof ISCFileSourceFile && (fileSpec = (DSFileSpec)file.getNativeHandler()).hasFileTenantIdField()) {
            return fileSpec.getFileTenantId();
        }
        return null;
    }

    public abstract Object loadObjectFromFile(ISCFile var1) throws Exception;

    protected Object loadAndUnwrapObjectFromFile(ISCFile file, CachingConfig config) throws Exception {
        Object object = this.loadObjectFromFile(file);
        if (object instanceof Map && ((Map)object).containsKey(FALLBACK_TENANT_ID_RECORD)) {
            if (config != null) {
                config.isFallbackTenantId = true;
            }
            Map dsConfig = (Map)object;
            for (Object key : dsConfig.keySet()) {
                if (FALLBACK_TENANT_ID_RECORD.equals(key)) continue;
                return dsConfig.get(key);
            }
        }
        return object;
    }

    protected Object loadAndUnwrapObjectFromFile(ISCFile file) throws Exception {
        return this.loadAndUnwrapObjectFromFile(file, null);
    }

    public void cacheObject(String name, Object object, long timeStamp, String tenantId, CachingConfig config) {
        CacheEntry entry = null;
        if (tenantId != null) {
            if (config != null && config.isFallbackTenantId) {
                CacheEntry nullEntry = (CacheEntry)this.cache.get(name);
                if (nullEntry != null) {
                    entry = nullEntry;
                } else {
                    entry = new CacheEntry();
                    this.cache.put(name, entry);
                }
            }
            name = (String)name + "," + tenantId;
        }
        if (entry == null) {
            entry = new CacheEntry();
        }
        if (entry.cachedObject == null) {
            entry.timeStamp = timeStamp;
            entry.cachedObject = object;
            entry.lastStalenessCheck = System.currentTimeMillis();
        }
        this.cache.put(name, entry);
    }

    protected CacheEntry getCachedObject(String name, String tenantId) {
        if (tenantId != null) {
            name = (String)name + "," + tenantId;
        }
        return (CacheEntry)this.cache.get(name);
    }

    static class CacheEntry {
        public Object cachedObject;
        public long timeStamp;
        public long lastStalenessCheck;

        CacheEntry() {
        }
    }

    static class CachingConfig {
        public boolean isFallbackTenantId;

        CachingConfig() {
        }
    }
}

