/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.IInstanceSingleton;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.Compression;
import com.isomorphic.servlet.ProxyPrintWriter;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class ServletCompression
implements IServletCompression,
IInstanceSingleton {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Compression.class.getName());
    public ByteArrayOutputStream wrapBuf = null;
    public OutputStream servletOutputStream = null;
    public boolean compressing = false;

    @Override
    public boolean canCompress(RequestContext context) {
        return ServletTools.compressionEnabled() && ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) && !ServletTools.contextIsIncluded(context);
    }

    @Override
    public boolean compressIfPossible(RequestContext context) {
        if (!this.canCompress(context)) {
            return false;
        }
        if (context.out != null) {
            return false;
        }
        try {
            this.servletOutputStream = context.response.getOutputStream();
        }
        catch (Exception e) {
            String logPrefix = context.requestPath + ": ";
            log.error(logPrefix + "Can't compress response because the servlet output stream is already in use: " + e.toString());
            return false;
        }
        this.wrapBuf = new ByteArrayOutputStream();
        String charset = context.response.getCharacterEncoding();
        OutputStreamWriter osw = null;
        if (charset == null) {
            osw = new OutputStreamWriter(this.wrapBuf);
            log.debug("Using default charset");
        } else {
            try {
                osw = new OutputStreamWriter((OutputStream)this.wrapBuf, charset);
                log.debug("Using charset: " + charset);
            }
            catch (UnsupportedEncodingException e) {
                log.debug("Can't compress response: " + e.getMessage());
            }
        }
        if (osw != null) {
            ProxyPrintWriter printWriter = new ProxyPrintWriter(new PrintWriter(osw));
            try {
                context.setOut(printWriter);
                this.compressing = true;
            }
            catch (IOException e) {
                log.debug("Can't compress response: " + e.getMessage());
            }
        }
        return this.compressing;
    }

    @Override
    public void completeResponse(RequestContext context) throws Exception {
        if (!this.compressing) {
            return;
        }
        try {
            context.out().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.out().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.compressAndSend(context, this.wrapBuf);
    }

    @Override
    public void compressAndSend(RequestContext context, ByteArrayOutputStream wrapBuf) throws Exception {
        this.compressAndSend(context, wrapBuf, -1);
    }

    @Override
    public void compressAndSend(RequestContext context, ByteArrayOutputStream wrapBuf, int compressThreshold) throws Exception {
        int wrapBufSize;
        String logPrefix = context.requestPath + ": ";
        if (this.servletOutputStream == null) {
            this.servletOutputStream = context.response.getOutputStream();
        }
        if (compressThreshold == -1) {
            compressThreshold = config.getInt("compression.compressThreshold", -1);
        }
        if (compressThreshold == -1) {
            compressThreshold = config.getInt("compressionFilter.compressThreshold", 250);
        }
        if ((wrapBufSize = wrapBuf.size()) == 0 || wrapBufSize < compressThreshold) {
            context.response.setContentLength(wrapBufSize);
            if (wrapBufSize == 0) {
                log.debug(logPrefix + "Result is zero length - not compressing");
            } else {
                log.debug(logPrefix + "Result data size of " + wrapBufSize + " bytes is less than set threshold of " + compressThreshold + " bytes - not compressing");
                wrapBuf.writeTo(this.servletOutputStream);
            }
            try {
                this.servletOutputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context.response.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        ByteArrayOutputStream compressedBuf = new Compression().compressBuffer(wrapBuf, context.contentType);
        if (log.isInfoEnabled()) {
            log.info(logPrefix + DataTypeMap.humanReadableByteCount(wrapBufSize) + " -> " + DataTypeMap.humanReadableByteCount(compressedBuf.size()));
        }
        context.response.setHeader("Content-Encoding", "gzip");
        if (!ServletTools.compressionReadyCookieIsSet(context)) {
            ServletTools.setCompressionReadyCookie(context);
        }
        context.response.setContentLength(compressedBuf.size());
        compressedBuf.writeTo(this.servletOutputStream);
        try {
            this.servletOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.response.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object staticInstance() throws Exception {
        return new ServletCompression();
    }
}

