/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.callbacks;

import com.smartgwt.client.ai.AIContext;
import com.smartgwt.client.ai.AIProgressMessage;

public interface AIProgressCallback {

    /** 
     * Callback called with progress information about an ongoing AI process.
     *
     * @param context 
     * @param numStepsCompleted 
     * @param estimatedNumTotalSteps 
     * @param newMessages Any additional messages about the progress that has been made since the last invocation of the progress callback. This
     * may be <code>null</code> or an empty array, if, for example, only the <code>numStepsCompleted</code> is being updated.
     */
	public void execute(AIContext context, Integer numStepsCompleted, Integer estimatedNumTotalSteps, AIProgressMessage... newMessages);
} 
