/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-10-18/LGPL Deployment (2025-10-18)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class ToggleItem
// FormItem that uses a +link{class:ToggleSwitch} component to present an interface for picking
// from either a continuous range or a range with a small number of discrete values.
//
// @inheritsFrom CanvasItem
// @visibility external
//<
isc.ClassFactory.defineClass("ToggleItem", "CanvasItem");

//----------  Define instance properties  ----------
isc.ToggleItem.addProperties({

    width: 60,

    //> @attr toggleItem.toggleConstructor (Class : ToggleSwitch : IR)
    // Constructor class for this item's +link{toggleSwitch}.
    // @visibility external
    //<
    toggleConstructor:"ToggleSwitch",
    shouldSaveValue: true,

    toggleDefaults : {
        autoDraw:false,
        overflow: "visible",
        hover : function () {
            var item = this.canvasItem;
            if (item != null) {
                item._handleHover();
                return false;
            }
        },
        valueChanged : function () {
            var item = this.canvasItem;
            if (item != null) item.toggleChange();
        }
    },
    autoDestroy:true
});


isc.ToggleItem.addMethods({
    init : function () {
        this.Super("init", arguments);
        // used for change detection
        this._currentValue = this.getDefaultValue();
    },

    // Override _createCanvas to set up a ToggleSwitch as this item's canvas, and set up appropriate
    // set of properties.
    _createCanvas : function () {
        // create our toggle based on our toggleDefaults, and appropriate instance properties.

        // include default canvasProperties, as well the documented toggleProperties
        const props = isc.addProperties({}, this.canvasProperties);
        // Use 'addAutoChild' - this will handle applying the various levels of defaults
        var toggle = this.canvas = this.addAutoChild("toggle", props, 
                this.toggleConstructor, this.container);

        this.Super("_createCanvas", arguments);        
    },

    // Override setValue to update the value on the toggle
    setValue : function (value) {
        this._setValueCalled = true;

        var defaultVal;
        if (value == null) {
            defaultVal = this.getDefaultValue();
            // don't apply the default value if it's not set - this allows for the distinction 
            // between setting the value to 'null' vs 'undefined'
            if (defaultVal != null) value = defaultVal;
        }
        // update the previous value so we don't fire a change handler on 'toggleChange'
        this._currentValue = value;
        // update the canvas
        this.canvas.setValue(value, (defaultVal != null));
        // calls to canvas.setValue() no longer fire canvas.valueChanged()->toggleChange(), so 
        // call toggleChange() directly to save as necessary
        this.toggleChange();
    },
    
    // Override getValue to return true or false according to the toggle's status
    getValue : function () {
        return this.canvas.getValue() == 1;
    },

    // Define a toggleChange function to handle value changes
    toggleChange : function() {
        
        // Note: the toggle.valueChanged method doesn't inform us what the old value was, so
        // we need to track this ourselves in order to pass it to any item level change handler.
        var val = this.canvas.getValue();

        if (this._currentValue != val) {
            // if changeOnDrag is false, don't update anything until the user is done dragging
            // the toggle around

            // no dragging i nthis implementation - may be needed
            //if (true || this.changeOnDrag || !this.canvas.valueIsChanging()) {
                this._updateValue(val);
                this._currentValue = val;
            //}

        // catch the case where there was an explicit setValue() call, and save out the new
        // value from the toggle.
        } else {
            this.saveValue(val);
        }
    },
    
    // only disable the child ToggleSwitch when disabled, not when readOnly
    shouldDisableCanvas : function () {
        return this.isDisabled();
    }
});
