/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Settings that configure requests to AI to generate the values for a field.
 * @see com.smartgwt.client.ai.AI#buildAIFieldRequest
 */
@BeanFactory.FrameworkClass
public class AIFieldRequest extends SingleSourceAIRequest {

    public static AIFieldRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof AIFieldRequest) {
            existingObj.setJsObj(jsObj);
            return (AIFieldRequest)existingObj;
        } else

        {
            return new AIFieldRequest(jsObj);
        }
    }
        


    public AIFieldRequest(){
        
    }

    public AIFieldRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  CATEGORICAL or ORDINAL, the list of
     * available categories.
     *
     * @param categories New categories value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     */
    public AIFieldRequest setCategories(String... categories) {
        return (AIFieldRequest)setAttribute("categories", categories);
    }

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  CATEGORICAL or ORDINAL, the list of
     * available categories.
     *
     * @return Current categories value. Default value is null
     */
    public String[] getCategories()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("categories"));
    }
    

    /**
     * When generating values for a list of records that are split into batches, the maximum number of records per batch.
     *
     * @param maxRecordsPerBatch New maxRecordsPerBatch value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     */
    public AIFieldRequest setMaxRecordsPerBatch(Integer maxRecordsPerBatch) {
        return (AIFieldRequest)setAttribute("maxRecordsPerBatch", maxRecordsPerBatch);
    }

    /**
     * When generating values for a list of records that are split into batches, the maximum number of records per batch.
     *
     * @return Current maxRecordsPerBatch value. Default value is null
     */
    public Integer getMaxRecordsPerBatch()  {
        return getAttributeAsInt("maxRecordsPerBatch");
    }
    

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  INTERVAL or RATIO, the maximum value
     * that can be generated. If <code>null</code>, then there is no maximum.
     *
     * @param maxValue New maxValue value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     */
    public AIFieldRequest setMaxValue(Integer maxValue) {
        return (AIFieldRequest)setAttribute("maxValue", maxValue);
    }

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  INTERVAL or RATIO, the maximum value
     * that can be generated. If <code>null</code>, then there is no maximum.
     *
     * @return Current maxValue value. Default value is null
     */
    public Integer getMaxValue()  {
        return getAttributeAsInt("maxValue");
    }
    

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  INTERVAL or RATIO, the minimum value
     * that can be generated. If <code>null</code>, then there is no minimum.
     *
     * @param minValue New minValue value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     */
    public AIFieldRequest setMinValue(Integer minValue) {
        return (AIFieldRequest)setAttribute("minValue", minValue);
    }

    /**
     * If the {@link com.smartgwt.client.ai.AIFieldRequest#getValueClass valueClass} is  INTERVAL or RATIO, the minimum value
     * that can be generated. If <code>null</code>, then there is no minimum.
     *
     * @return Current minValue value. Default value is null
     */
    public Integer getMinValue()  {
        return getAttributeAsInt("minValue");
    }
    

    /**
     * The names of fields that are relevant to each {@link com.smartgwt.client.ai.SummarizeRecordsRequest}.
     *
     * @param relevantFieldNames New relevantFieldNames value. Default value is null
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public AIFieldRequest setRelevantFieldNames(String... relevantFieldNames) {
        return (AIFieldRequest)setAttribute("relevantFieldNames", relevantFieldNames);
    }

    /**
     * The names of fields that are relevant to each {@link com.smartgwt.client.ai.SummarizeRecordsRequest}.
     *
     * @return Current relevantFieldNames value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String[] getRelevantFieldNames()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("relevantFieldNames"));
    }
    

    /**
     * The class of value that AI will be asked to generate for the field.
     *
     * @param valueClass New valueClass value. Default value is "general"
     * @return {@link com.smartgwt.client.ai.AIFieldRequest AIFieldRequest} instance, for chaining setter calls
     */
    public AIFieldRequest setValueClass(ValueClass valueClass) {
        return (AIFieldRequest)setAttribute("valueClass", valueClass == null ? null : valueClass.getValue());
    }

    /**
     * The class of value that AI will be asked to generate for the field.
     *
     * @return Current valueClass value. Default value is "general"
     */
    public ValueClass getValueClass()  {
        return EnumUtil.getEnum(ValueClass.values(), getAttribute("valueClass"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
