/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML.applications;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class SupplyCatalogSampleXML extends ShowcasePanel {

    private static final String DESCRIPTION =
        "Demonstrates a range of SmartGWT GUI components, data binding operations, and "+
        "layout managers in a single-page application."+
        "<P>"+
        "Select a folder in the Supply Categories tree to display items in that category. "+
        "Select any item in the Supply Items list to view or edit that item's details. Edit "+
        "information in the Edit tab and click 'Save Item' to save your changes; or double-click "+
        "on Item Name, Description, Units, or Unit Cost to edit information in place in the Supply Items list."+
        "<P>"+
        "Right-click on any item in the Office Supply Items list to Show Details, Edit, or Delete that item."+
        "<P>"+
        "Drag an item from the Office Supply Items list to a folder in the Office Supply Categories tree to "+
        "recategorize the item."+
        "<P>"+
        "Click and drag the vertical bar to resize the left and right halves of the application or click and "+
        "drag the horizontal resize bar to adjust the height of the panels on the right.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            SupplyCatalogSampleXML panel = new SupplyCatalogSampleXML();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        layout.setHeight100();
        layout.setWidth100();
        RPCManager.loadScreen("supplyCatalog", new LoadScreenCallback() {
            @Override
            public void execute() {
                layout.addChild(this.getScreen());
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
    
    @Override
    protected boolean isFullscreenMode() {
        return true;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("supplyCatalog.ui.xml", XML, "source/supplyCatalog.ui.xml.html", true),
            new SourceEntity("supplyItem.ds.xml", XML, "source/supplyItem.ds.xml.html", true),
            new SourceEntity("supplyCategory.ds.xml", XML, "source/supplyCategory.ds.xml.html", true)
        };
    }
}
