/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Region;
import org.hibernate.cfg.Settings;

public abstract class BaseRegionAdapter
implements Region {
    protected final Cache underlyingCache;
    protected final Settings settings;

    protected BaseRegionAdapter(Cache underlyingCache, Settings settings) {
        this.underlyingCache = underlyingCache;
        this.settings = settings;
    }

    public String getName() {
        return this.underlyingCache.getRegionName();
    }

    public void clear() throws CacheException {
        this.underlyingCache.clear();
    }

    public void destroy() throws CacheException {
        this.underlyingCache.destroy();
    }

    public boolean contains(Object key) {
        return this.underlyingCache.toMap().containsKey(key);
    }

    public long getSizeInMemory() {
        return this.underlyingCache.getSizeInMemory();
    }

    public long getElementCountInMemory() {
        return this.underlyingCache.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this.underlyingCache.getElementCountOnDisk();
    }

    public Map toMap() {
        return this.underlyingCache.toMap();
    }

    public long nextTimestamp() {
        return this.underlyingCache.nextTimestamp();
    }

    public int getTimeout() {
        return this.underlyingCache.getTimeout();
    }
}

