/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class HikariConnectionManager
extends Base {
    private static Logger log = new Logger(HikariConnectionManager.class.getName());
    private static Config config = Config.getGlobal();
    private static Map<String, HikariDataSource> hikariDataSources;

    private static HikariDataSource registerHikariDataSource(String dbName) {
        HikariConfig hc = HikariConnectionManager.getHikariConfig(dbName);
        HikariDataSource hikariDS = new HikariDataSource(hc){

            public void evictConnection(Connection conn) {
                log.debug((Object)("About to evict connection '" + conn.hashCode() + "' from Hikari pool '" + this.getPoolName() + "'"));
                super.evictConnection(conn);
            }

            public Connection getConnection() throws SQLException {
                Connection conn = super.getConnection();
                log.debug((Object)("About to return connection '" + conn.hashCode() + "' from Hikari pool '" + this.getPoolName() + "'"));
                return conn;
            }
        };
        if (hikariDataSources == null) {
            hikariDataSources = new HashMap<String, HikariDataSource>();
        }
        hikariDataSources.put(dbName, hikariDS);
        return hikariDS;
    }

    private static synchronized HikariDataSource getHikariDataSource(String dbName) {
        HikariDataSource hikariDS = hikariDataSources.get(dbName);
        if (hikariDS == null) {
            hikariDS = HikariConnectionManager.registerHikariDataSource(dbName);
        }
        return hikariDS;
    }

    private static HikariConfig getHikariConfig(String dbName) {
        try {
            Config sqlConfig = SQLDriver.isConfigured(dbName) ? SQLDriver.globalSqlConfig.get(dbName) : SQLDriver.initSqlConfig(dbName);
            Config driverConfig = sqlConfig.getSubtree("driver");
            DataSource ds = (DataSource)sqlConfig.get((Object)"_ds");
            String jdbcUrl = sqlConfig.getString((Object)"_jdbcURL");
            Properties props = new Properties();
            Config hikariSubtree = sqlConfig.getSubtree("hikari");
            for (String key : hikariSubtree.keySet()) {
                Object value = hikariSubtree.get((Object)key);
                if (value == null) continue;
                props.setProperty(key, value.toString());
            }
            HikariConfig hc = new HikariConfig(props);
            if (ds != null) {
                hc.setDataSource(ds);
            } else {
                hc.setJdbcUrl(jdbcUrl);
                if (sqlConfig.getString((Object)"driver") != null) {
                    hc.setDriverClassName(sqlConfig.getString((Object)"driver"));
                }
            }
            Boolean credentialsInURL = sqlConfig.getBoolean((Object)"_credentialsInURL");
            if (credentialsInURL == null) {
                credentialsInURL = Boolean.FALSE;
            }
            if (!credentialsInURL.booleanValue()) {
                hc.setUsername(driverConfig.getString((Object)"user"));
                hc.setPassword(driverConfig.getString((Object)"password"));
            }
            hc.setPoolName(dbName);
            log.info((Object)("Created Hikari config for dbName '" + dbName + "': " + hikariSubtree));
            return hc;
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception trying to derive Hikari config", (Throwable)e);
            return null;
        }
    }

    public static Connection getConnection(String poolName) throws Exception {
        return HikariConnectionManager.getHikariDataSource(poolName).getConnection();
    }

    public static void evictConnection(String poolName, Connection conn) throws Exception {
        HikariConnectionManager.getHikariDataSource(poolName).evictConnection(conn);
    }

    static {
        HikariConnectionManager.registerHikariDataSource(config.getString((Object)"sql.defaultDatabase"));
    }
}

