/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util.xml;

import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.hibernate.InvalidMappingException;
import org.hibernate.util.xml.ErrorLogger;
import org.hibernate.util.xml.Origin;
import org.hibernate.util.xml.XmlDocument;
import org.hibernate.util.xml.XmlDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingReader {
    private static final Logger log = LoggerFactory.getLogger(MappingReader.class);
    public static final String ASSUMED_ORM_XSD_VERSION = "2.0";
    public static final MappingReader INSTANCE = new MappingReader();

    private MappingReader() {
    }

    public XmlDocument readMappingDocument(EntityResolver entityResolver, InputSource source, Origin origin) {
        ErrorLogger errorHandler = new ErrorLogger();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler((ErrorHandler)errorHandler);
        saxReader.setMergeAdjacentText(true);
        saxReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(saxReader, "orm_2_0.xsd");
            document = saxReader.read(source);
            if (errorHandler.getError() != null) {
                throw errorHandler.getError();
            }
            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
        }
        catch (Exception orm2Problem) {
            log.debug("Problem parsing XML using orm 2 xsd : {}", (Object)orm2Problem.getMessage());
            Exception failure = orm2Problem;
            errorHandler.reset();
            if (document != null) {
                try {
                    this.setValidationFor(saxReader, "orm_1_0.xsd");
                    document = saxReader.read((Reader)new StringReader(document.asXML()));
                    if (errorHandler.getError() != null) {
                        throw errorHandler.getError();
                    }
                    return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                }
                catch (Exception orm1Problem) {
                    log.debug("Problem parsing XML using orm 1 xsd : {}", (Object)orm1Problem.getMessage());
                }
            }
            throw new InvalidMappingException("Unable to read XML", origin.getType(), origin.getName(), failure);
        }
    }

    private void setValidationFor(SAXReader saxReader, String xsd) {
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://java.sun.com/xml/ns/persistence/orm " + xsd));
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
    }
}

