/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.shuttles;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.form.fields.MultiPickerItem;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.types.MultiPickerSelectionStyle;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class InlineShuttleSample extends ShowcasePanel {
    private static final String DESCRIPTION = 
        " This sample demonstrates how a shuttle interface can be used to edit a many-to-many "+
        "relationship in a ListGrid between Employees and Teams."+
        "<p>"+
        "The grid shows a list of teams, each of which has a number of members. Double click "+
        "the Employee field to edit it. You can use the drop-down shuttle interface to add or "+
        "remove team members."+
        "<p>"+
        "The data for this sample is stored in three database tables - an Employee table, a Teams "+
        "table and a pivot table with entries connecting Employees to Teams, with a DataSource defined "+
        "for each table."+
        "<p>"+
        "The Teams dataSource contains an EmployeeId field with multiple set to true and a foreignKey "+
        "declaration which maps through the dataSource for the pivot table to the related Employees "+
        "dataSource. The Employees DataSource has a similar TeamId field with the reciprocal mapping "+
        "through the pivot table back to the Teams dataSource."+
        "<p>"+
        "On fetch, the SmartClient server will dynamically populate these field with an appropriate array "+
        "of values from the entries in the pivot table, so each Team record will have EmployeeId set to "+
        "the array of TeamIds the employee is associated with."+
        "<p>"+
        "When the user modifies these values and saves the changes, the SmartClient server will update "+
        "the pivot table to reflect the new set of employees for the team.";
        
    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            InlineShuttleSample panel = new InlineShuttleSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }
    
    public Canvas getViewPanel() {
        DataSource ds = DataSource.get("teams_relation");
        
        ListGrid teamsGrid = new ListGrid();
        teamsGrid.setDataSource(ds);
        teamsGrid.setWidth100();
        teamsGrid.setHeight100();
        teamsGrid.setAutoFetchData(true);
        teamsGrid.setCanEdit(true);
        
        ListGridField teamNameField = new ListGridField("TeamName");
        ListGridField employeeIdField = new ListGridField("EmployeeId");
        employeeIdField.setCanEdit(true);
        //employeeIdField.setEditorType("MultiPickerItem");
        MultiPickerItem editorProperties = new MultiPickerItem();
        editorProperties.setSelectionStyle(MultiPickerSelectionStyle.SHUTTLE);
        employeeIdField.setEditorProperties(editorProperties);
        
        teamsGrid.setFields(teamNameField, employeeIdField);
    	
        return teamsGrid;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("teamMembers_relation.ds.xml", XML, "source/teamMembers_relation.ds.xml.html", true),
            new SourceEntity("employees_relation.ds.xml", XML, "source/employees_relation.ds.xml.html", true)
        };
    }
    
}
