package com.smartgwt.sample.client;

import java.util.*;

import com.smartgwt.client.types.*;
import com.smartgwt.client.util.PageKeyHandler;
import com.smartgwt.client.util.Page;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.data.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.form.fields.events.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.browser.window.events.*;

public class WindowEventForm extends HLayout {

    ListGrid eventPickerGrid;
    EventOutputForm eventOutputForm;

    public WindowEventForm() {
        setIsGroup(true);
        setGroupTitle("Select & Monitor Window Events");

        setLayoutTopMargin(10);
        setLayoutBottomMargin(10);
        setMembersMargin(10);

        eventPickerGrid = new WindowEventGrid();
        eventOutputForm = new EventOutputForm();
        setMembers(eventPickerGrid, eventOutputForm);
    }

    public static class EventOutputForm extends DynamicForm
                                        implements MultiWindowEventCallback
    {
        TextAreaItem eventOutputItem;
        ButtonItem clearOutputItem;

        String outputBuffer;
        String lastEventOutput;
        int lastEventCount;

        public EventOutputForm() {
            setNumCols(1);
            
            eventOutputItem = new TextAreaItem("output", "Window Events");
            eventOutputItem.setTitleOrientation(TitleOrientation.TOP);
            eventOutputItem.setHeight("100%");
            eventOutputItem.setWidth("100%");
            clearOutputBuffer();

            clearOutputItem = new ButtonItem("clear", "Clear History");
            clearOutputItem.setAlign(Alignment.RIGHT);
            clearOutputItem.addClickHandler(new ClickHandler() {
                public void onClick(ClickEvent event) {
                    clearOutputBuffer();
                }
            });

            setItems(eventOutputItem, clearOutputItem);
        }

        void clearOutputBuffer() {
            if (eventOutputItem.isCreated()) {
                eventOutputItem.clearValue();
            }
            lastEventOutput = null;
            lastEventCount = 1;
            outputBuffer = "";
        }

        String getLastEventOutput() {
            String result = lastEventOutput;
            if (lastEventCount > 1) result += " [X " + lastEventCount + "]";
            return result;
        }

        public void execute(RemoteWindow remoteWindow, MultiWindowEvent eventType, Map event) {
            String windowName = (String)event.get("name");

            String output = "Received event " + eventType.getValue() + " from window " +
                windowName;

            if (output.equals(lastEventOutput)) {
                lastEventCount++;
            } else {
                if (lastEventOutput != null) outputBuffer += getLastEventOutput() + "\n";
                lastEventOutput = output;
                lastEventCount = 1;
            }
            eventOutputItem.setValue(outputBuffer + getLastEventOutput());
        }

    }

    public static class WindowEventGrid extends ListGrid {

        public WindowEventGrid() {
            setWidth(225);
            setSelectionAppearance(SelectionAppearance.CHECKBOX);
            addSelectionChangedHandler(new SelectionChangedHandler() {
                public void onSelectionChanged(SelectionEvent event) {
                    WindowEventRecord record = (WindowEventRecord)event.getRecord();
                    if (event.getState()) {
                        MultiWindowEventCallback eventHandler = getWindowEventHandler();
                        int regID = MultiWindow.setEvent(record.getEventType(), eventHandler);
                        record.setEventRegistrationID(regID);
                    } else {
                        int regID = record.getEventRegistrationID();
                        MultiWindow.clearEvent(record.getEventType(), regID);
                    }
                }
            });

            ListGridField eventNameField = new ListGridField("eventName", "Window Event Name");
            ListGridField registeredIdField = new ListGridField("registeredID");
            registeredIdField.setType(ListGridFieldType.INTEGER);
            registeredIdField.setHidden(true);
            setFields(eventNameField, registeredIdField);

            ListGridRecord[] records = {
                new WindowEventRecord(MultiWindowEvent.LOAD),
                new WindowEventRecord(MultiWindowEvent.UNLOAD),
                new WindowEventRecord(MultiWindowEvent.RESIZE),
                new WindowEventRecord(MultiWindowEvent.MOVE),
                new WindowEventRecord(MultiWindowEvent.CLOSE),
                new WindowEventRecord(MultiWindowEvent.ACTIVATE),
                new WindowEventRecord(MultiWindowEvent.DEACTIVATE),
            };
            setData(records);
        }

        MultiWindowEventCallback getWindowEventHandler() {
            return ((WindowEventForm)getParentCanvas()).eventOutputForm;
        }
    }

}

