/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Configuration object for {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()}
 */
@BeanFactory.FrameworkClass
public class ElementWaitConfig extends SystemWaitConfig {

    public static ElementWaitConfig getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new ElementWaitConfig(jsObj);
    }
        


    public ElementWaitConfig(){
        
    }

    public ElementWaitConfig(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Timeout for {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} in ms. If this is
     * exceeded the callback will be fired  with element set to <code>null</code>, and the callback will be passed
     * <code>false</code> as  its <code>"done"</code> parameter. <P> Note that {@link
     * com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} can return a valid element but this method can still
     * timeout if the element is not clickable or the system is busy. <P> If unset a default timeout of 30 seconds will be
     * used.
     *
     * @param timeout New timeout value. Default value is null
     * @return {@link com.smartgwt.client.util.ElementWaitConfig ElementWaitConfig} instance, for chaining setter calls
     */
    public ElementWaitConfig setTimeout(Integer timeout) {
        return (ElementWaitConfig)setAttribute("timeout", timeout);
    }

    /**
     * Timeout for {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} in ms. If this is
     * exceeded the callback will be fired  with element set to <code>null</code>, and the callback will be passed
     * <code>false</code> as  its <code>"done"</code> parameter. <P> Note that {@link
     * com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} can return a valid element but this method can still
     * timeout if the element is not clickable or the system is busy. <P> If unset a default timeout of 30 seconds will be
     * used.
     *
     * @return Current timeout value. Default value is null
     */
    public Integer getTimeout()  {
        return getAttributeAsInt("timeout");
    }
    

    /**
     * This attribute configures how <code>waitForElement()</code> determines  that the application is read to retrieve the
     * element. See {@link com.smartgwt.client.types.ElementWaitStyle} for options. <P> If not explicitly set, the {@link
     * com.smartgwt.client.util.AutoTest#defaultElementWaitStyle defaultElementWaitStyle} will be used.
     *
     * @param waitStyle New waitStyle value. Default value is null
     * @return {@link com.smartgwt.client.util.ElementWaitConfig ElementWaitConfig} instance, for chaining setter calls
     */
    public ElementWaitConfig setWaitStyle(ElementWaitStyle waitStyle) {
        return (ElementWaitConfig)setAttribute("waitStyle", waitStyle == null ? null : waitStyle.getValue());
    }

    /**
     * This attribute configures how <code>waitForElement()</code> determines  that the application is read to retrieve the
     * element. See {@link com.smartgwt.client.types.ElementWaitStyle} for options. <P> If not explicitly set, the {@link
     * com.smartgwt.client.util.AutoTest#defaultElementWaitStyle defaultElementWaitStyle} will be used.
     *
     * @return Current waitStyle value. Default value is null
     */
    public ElementWaitStyle getWaitStyle()  {
        return EnumUtil.getEnum(ElementWaitStyle.values(), getAttribute("waitStyle"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
