/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class EntityAction
implements Executable,
Serializable,
Comparable,
AfterTransactionCompletionProcess {
    private final String entityName;
    private final Serializable id;
    private final Object instance;
    private final SessionImplementor session;
    private transient EntityPersister persister;

    protected EntityAction(SessionImplementor session, Serializable id, Object instance, EntityPersister persister) {
        this.entityName = persister.getEntityName();
        this.id = id;
        this.instance = instance;
        this.session = session;
        this.persister = persister;
    }

    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.needsAfterTransactionCompletion() ? this : null;
    }

    protected abstract boolean hasPostCommitEventListeners();

    public boolean needsAfterTransactionCompletion() {
        return this.persister.hasCache() || this.hasPostCommitEventListeners();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public final Serializable getId() {
        if (this.id instanceof DelayedPostInsertIdentifier) {
            return this.session.getPersistenceContext().getEntry(this.instance).getId();
        }
        return this.id;
    }

    public final Object getInstance() {
        return this.instance;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final EntityPersister getPersister() {
        return this.persister;
    }

    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    public int compareTo(Object other) {
        EntityAction action = (EntityAction)other;
        int roleComparison = this.entityName.compareTo(action.entityName);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getIdentifierType().compare(this.id, action.id, this.session.getEntityMode());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.persister = this.session.getFactory().getEntityPersister(this.entityName);
    }
}

