/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-20/LGPL Deployment (2026-02-20)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @type SortDirection
// @value "ascending" Sort in ascending order (e.g. A-Z; larger values later in the list)
// @value "descending" Sort in descending order (e.g. Z-A; larger values earlier in the list)
// @group sorting
// @visibility external
//<


//> @object SortSpecifier
// An object that defines the details of a single sort operation.
// <P>
// For simple sort specifiers, you can convert between a <code>SortSpecifier</code> and the
// corresponding string format required by +link{DSRequest.sortBy} by calling +link{DataSource.getSortBy()}
// and +link{DataSource.getSortSpecifiers()}.
//
// @treeLocation Client Reference/Data Binding
// @visibility external
//<

//> @attr SortSpecifier.property (Identifier : null : IR)
// Unless a +link{SortSpecifier.sortByProperty} is set, the property name of the records to sort by.
// @visibility external
//<

//> @attr SortSpecifier.sortByProperty (Identifier : null : IR)
// If set, the property name of the records to sort by.
// @see DataSourceField.sortByField
// @visibility external
//<

//> @attr SortSpecifier.direction (SortDirection : null : IR)
// The direction in which to sort.
// @visibility external
//<

//> @attr SortSpecifier.normalizer (Function : null : IR)
// A normalizer function which will be used to transform the property values. The sort is then
// by the normalized values.
// @visibility external
//<

//> @attr SortSpecifier.context (DataBoundComponent : null : IR)
// The context <code>DataBoundComponent</code> for the +link{SortSpecifier.normalizer}.
// @visibility external
//<


//> @class SortSpecifierUtil
// Utilities for working with +link{SortSpecifier} objects.
// @treeLocation Client Reference/Data Binding
// @visibility external
//<
isc.defineClass("SortSpecifierUtil").addClassProperties({

    _getSortByProperty : function (sortSpecifier) {
        return isc.isA.nonemptyString(sortSpecifier.sortByProperty) ? sortSpecifier.sortByProperty : sortSpecifier.property;
    },

    getSortSpecifier : function (sortByString, fieldContainer) {
        var direction = "ascending",
            property = String(sortByString);
        if (sortByString.substring(0, 1) == "-") {
            direction = "descending";
            property = sortByString.substring(1);
        }

        var sortSpecifier = {
            property: property,
            direction: direction
        };

        if (fieldContainer) {
            var field = fieldContainer.getUnderlyingField(property);
            if (field && isc.isA.nonemptyString(field.sortByField)) {
                sortSpecifier.sortByProperty = field.sortByField;
            }
        }

        return sortSpecifier;
    },

    //> @classAttr SortSpecifierUtil.valueMapNormalizationDescription (HTMLString : "valueMap normalization" : IRW)
    // Description of sort value normalization using a +link{ValueMap}.
    // @group i18nMessages
    // @visibility external
    //<
    valueMapNormalizationDescription: "valueMap normalization",

    //> @classAttr SortSpecifierUtil.customNormalizationDescription (HTMLString : "custom normalization" : IRW)
    // Description of sort value normalization provided by a non-default normalizer.
    // @group i18nMessages
    // @visibility external
    //<
    customNormalizationDescription: "custom normalization",

    //> @classMethod SortSpecifierUtil.getNormalizationDescription()
    // Returns a human-readable description of the sort value normalization provided by the
    // given normalizer. Applications may replace this with their own implementation.
    // @param [normalizer] (Any) The sort value normalizer.
    // @return (HTMLString) A human-readable description of the sort value normalization
    // provided by the given normalizer, or <code>null</code> or an empty string if the
    // normalization should not be described.
    // @group i18nMessages
    // @visibility external
    //<
    getNormalizationDescription : function (normalizer) {
        if (normalizer == null || isc.isA.String(normalizer)) return null;
        else if (isc.isA.Function(normalizer)) return this.customNormalizationDescription;
        return this.valueMapNormalizationDescription;
    },

    //> @classAttr SortSpecifierUtil.normalizationDescriptionSuffix (HTMLString : ", with ${normalizationDescription}" : IRW)
    // A suffix applied to the end of the sort specifier description generated by
    // +link{SortSpecifierUtil.getDescription()} when the sort specifier specifies a
    // +link{SortSpecifier.normalizer, normalizer} and +link{SortSpecifierUtil.getNormalizationDescription()}
    // returns a non-<code>null</code> normalization description.
    // @group i18nMessages
    // @visibility external
    //<
    normalizationDescriptionSuffix: ", with ${normalizationDescription}",

    //> @classAttr SortSpecifierUtil.ascendingSortDescription (HTMLString : "${propertyTitle} in ascending order" : IRW)
    // The description of
    // @group i18nMessages
    // @visibility external
    //<
    ascendingSortDescription: "${propertyTitle} in ascending order",

    //> @classAttr SortSpecifierUtil.descendingSortDescription (HTMLString : "${propertyTitle} in descending order" : IRW)
    // The description of
    // @group i18nMessages
    // @visibility external
    //<
    descendingSortDescription: "${propertyTitle} in descending order",

    //> @classMethod SortSpecifierUtil.getDescription()
    // Returns a human-readable description of the given sort specifier.
    //
    // @param sortSpecifier (SortSpecifier | String) The sort specifier. This may be a sortBy string.
    // @param [fieldContainer] (DataBoundComponent) The field container for context.
    // @return (HTMLString) A human-readable description of the sort specifier.
    // @visibility external
    //<
    
    getDescription : function (sortSpecifier, fieldContainer) {
        if (!sortSpecifier) return null;

        if (isc.isA.String(sortSpecifier)) {
            sortSpecifier = this.getSortSpecifier(sortSpecifier, fieldContainer);
        } else if (isc.isA.FieldContainer(sortSpecifier.context)) {
            fieldContainer = sortSpecifier.context;
        }

        var property = this._getSortByProperty(sortSpecifier),
            propertyTitle = isc.FieldContainerUtil._getFieldTitleForMessages(property, fieldContainer),
            dynamicString = Array.shouldSortAscending(sortSpecifier.direction)
                            ? this.ascendingSortDescription
                            : this.descendingSortDescription;
        var description = dynamicString.evalDynamicString(sortSpecifier, {
            propertyTitle: propertyTitle
        });

        var normalizationDescription = this.getNormalizationDescription(sortSpecifier.normalizer);
        if (isc.isA.nonemptyString(normalizationDescription)) {
            description += this.normalizationDescriptionSuffix.evalDynamicString(sortSpecifier, {
                normalizationDescription: normalizationDescription
            });
        }

        return description;
    }
});
