
package com.smartgwt.client.docs;

/**
 * <h3>Generating Reliable AutoTestLocators</h3>
 * The {@link com.smartgwt.client.docs.AutoTestLocator locators} generated by {@link
 * com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} will always resolve
 * uniquely back to the target element in a live application when they are first generated.
 * However, changes to the structure of the application on subsequent visits, due to small changes
 * to the application or  certain types of dynamically generated UI can make some locator
 * strategies less reliable than others. Most notably, if a locator is relying on  simple
 * parent-child (or layout-member) hierarchy to identify a component,  any change to that
 * hierarchy will break it, and if a locator is identifying a component by index, this locator can
 * resolve incorrectly if the other children or members of the parent are modified,  even with
 * {@link com.smartgwt.client.docs.AutoTestLocator fallback locator attributes}. <P> There are a
 * few simple things a developer can do to allow the AutoTest system to generate reliable locators
 * <P> <h2>Explicit IDs</h2> If a component has an explicitly specified {@link
 * com.smartgwt.client.widgets.Canvas#getID ID}, it will be used to identify the target
 * component's UI elements, regardless of where it sits within an application widget hierarchy. By
 * giving key components explicit IDs, you can ensure they will be found by recorded test scripts
 * even if the application layout changes. <P> Exception: note that if {@link
 * com.smartgwt.client.util.AutoTest#testRoot testRoot} is set, the ID will be ignored when
 * generating locators in favor of identifying their position within the designated test root. You
 * can explicitly override this by setting  {@link
 * com.smartgwt.client.widgets.Canvas#getLocateByIDOnly Canvas.locateByIDOnly}. <P>  <h2>Explicit
 * locator parents</h2> Any component can designate itself as a named locatorChild of some parent
 * via {@link com.smartgwt.client.widgets.Canvas#setLocatorParent Canvas.setLocatorParent()}. <P>
 * As long as this relationship has been defined, locators will  directly use the specified
 * locator name to identify the child  when generating or resolving locators from the parent. <P>
 * Note that a widget does not need to be a true descendant of another widget to mark it as its
 * locator parent. <h2>Defining properties and search segments</h2> As described in the {@link
 * com.smartgwt.client.docs.AutoTestLocator AutoTestLocator overview}, locators can include search
 * segments to find descendants by  {@link
 * com.smartgwt.client.widgets.Canvas#getDefiningPropertyName defining property value}. Developers
 * may choose to set an explicit defining property for some component or custom class to take
 * advantage of this capability. Locators with  search segments will reliably find their targets
 * within their parent even if the intervening widget hierarchy has changed. <P> The Smart GWT
 * AutoTest system also provides capabilities for recording automated test scripts for playback on
 * different environments with significant changes. See {@link
 * com.smartgwt.client.docs.PortableAutoTests} for details.
 */
public interface ReliableLocators {
}
