
package com.smartgwt.client.docs;

/**
 * <h3>Experimental Features</h3>
 * Smart GWT includes certain features which are marked as "Experimental" because, while they 
 * have been added to the core framework in a way that may be usable for many customers, there  is
 * not a clear enough need for the features for Isomorphic to commit to long-term,  cross-browser
 * support (as with all other features). <P> Experimental features are subject to the following
 * limitations: <ul> <li>Experimental features are not covered by normal Support.<br>     If an
 * experimental feature isn't working as expected we'd like to know,      but unlike core
 * framework features, our support contracts do not guarantee     that every question will be
 * answered, every issue investigated, patches     created for high priority bugs, phone support
 * or remote assistance for production     issues, etc.</li> <li>Functionality may not be
 * feature-complete. In some cases certain     common use cases may not be addressed.</li>
 * <li>Experimental features are "use at your own risk". They could stop working entirely,     
 * for example if they involve 3rd-party functionality that fails to maintain backwards
 * compatibility,      or involve browser-specific capabilities that have not been
 * standardized.</li> <li>Experimental features are valid candidates for      <a
 * href='https://www.smartclient.com/services/index.jsp' target='_blank'>Feature
 * Sponsorship</a>.<br>     You can pay Feature Sponsorship rates to enhance any experimental
 * feature further.</li> </ul>
 * @see com.smartgwt.client.tools.stream.EventStream#getAsSeleneseHTML
 * @see com.smartgwt.client.tools.stream.EventStream#getAsSeleneseCommands
 * @see com.smartgwt.client.tools.SeleneseRecorder
 * @see com.smartgwt.client.tools.stream.EventStream
 * @see com.smartgwt.client.tools.stream.SeleniumCommand
 * @see com.smartgwt.client.tools.stream.SeleneseSettings
 * @see com.smartgwt.client.tools.stream.EventStreamData
 * @see com.smartgwt.client.tools.stream.EventStreamEvent
 * @see com.smartgwt.client.browser.window.MultiWindow
 * @see com.smartgwt.client.browser.window.RemoteWindow
 * @see com.smartgwt.client.browser.window.OpenFinWindow
 */
public interface Experimental {
}
