/*

  SmartClient Ajax RIA system
  Version v13.1p_2025-11-19/LGPL Deployment (2025-11-19)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// ----------------------------------------------------------------------------------------

// If ListGrid, or DynamicForm isn't loaded don't attempt to create this class - it's a requirement.
if (isc.ListGrid != null && isc.DynamicForm != null) {


//> @class RelationEditor
// Provides a UI for creating and editing +link{DataSource, DataSources) relationships.
// 
// @inheritsFrom VLayout
// @treeLocation Client Reference/Tools
// @visibility devTools
//<
isc.ClassFactory.defineClass("RelationEditor", "VLayout");

isc.RelationEditor.addClassProperties({
    helpText: "Relations are links between records of different DataSources, such as a link " +
              "from an Order to the Customer that ordered it.<P>" +
              "To create a relation, you add a special field to a DataSource, which stores a " +
              "unique identifier for records from another DataSource.<P>" +
              "For example, an Order record could have a field that stores the unique " +
              "customer number of the Customer that placed the order.<P>" +
              "When you create a relation field, Reify automatically uses a select or combo " +
              "box when editing the field, so your users can pick a record from the related " +
              "DataSource.<P>" +
              "When building a screen that uses related DataSources, you can also use the " +
              "<i>Fetch Related Data</i> action to populate a grid with records that are " +
              "related to another record.",
    shortHelpText: "Relations are links between records of different DataSources, such as a link " +
              "from an Order to the Customer that ordered it.<P>" +
              "To create a relation, you add a special field to a DataSource, which stores a " +
              "unique identifier for records from another DataSource.<P>" +
              "For example, an Order record could have a field that stores the unique " +
              "customer number of the Customer that placed the order.<P>" +
              "When you create a relation field, Reify automatically uses a select or combo " +
              "box when editing the field, so your users can pick a record from the related " +
              "DataSource."
});

isc.RelationEditor.addClassMethods({
    addGeneratedField : function (ds, fieldName) {
        var fields = isc.RelationEditor.generatedFields;
        if (!fields) {
            fields = isc.RelationEditor.generatedFields = {};
        }
        if (!fields[ds.ID]) {
            fields[ds.ID] = {};
        }
        fields[ds.ID][fieldName] = true;
    },

    removeGeneratedField : function (ds, fieldName) {
        var fields = isc.RelationEditor.generatedFields;
        if (fields && fields[ds.ID]) {
            delete fields[ds.ID][fieldName];
        }
    },

    isGeneratedField : function (ds, fieldName) {
        var fields = isc.RelationEditor.generatedFields;
        return (fields && fields[ds.ID] && fields[ds.ID][fieldName]);
    }
});

isc.RelationEditor.addProperties({
    // attributes 
    overflow: "visible",
    membersMargin: 10,

    // properties

    //> @attr relationEditor.dsDataSource (DataSource | ID : null : IRW)
    // +link{dataSource} to be used to load and save ds.xml files, via
    // +link{group:fileSource,fileSource operations}.
    //
    // @visibility devTools
    //<

    //> @attr relationEditor.knownDataSources (Array of PaletteNode : null : IR)
    // A list of all known DataSources, as +link{paletteNode,PaletteNodes}, to be used when 
    // build relations.
    // <p>
    // Note that an existing relation to a DataSource not included in this list cannot
    // be edited.
    //
    // @visibility devTools
    //<

    //> @attr relationEditor.useLiveDataSources (Boolean : null : IR)
    // Unless set to <code>false</code> live DataSource instances will be used
    // as obtained from +link{dataSource.get}, otherwise, a temporary DataSource
    // will be created as needed from defaults that will not conflict with any
    // live instance.
    // <P>
    // This property is applied to a created +link{session}.
    // If a <code>session</code> is provided directly, this property is ignored.
    //
    // @visibility devTools
    //<

    //> @attr relationEditor.session (DataSourceEditorSession : null : IR)
    // The editor "session" that maintains the pending DataSource changes. A new session
    // is automatically created during init if not provided.
    // <P>
    // When creating the initial session, the following RelationEditor properties
    // are passed to the new session:
    // <ul>
    //   <li>+link{dsDataSource}</li>
    //   <li>+link{knownDataSources} as +link{dataSourceEditorSession.dataSources}</li>
    //   <li>+link{useLiveDataSources}</li>
    // </ul>
    //
    // @visibility devTools
    //<

    //> @attr relationEditor.canNavigateToDataSource (Boolean : null : IRW)
    // In the relation list, should a link be shown to navigate to the referenced DataSource?
    // <P>
    // If a relationship link is clicked, +link{navigateToDataSource} is called.
    //
    // @visibility devTools
    //<

    //> @attr relationEditor.readOnly (Boolean : null : IRW)
    // Is this editor in read-only mode?
    // <P>
    // Normal interactions in the editor continue as usual.
    //
    // @visibility devTools
    //<

    // Mappings for relationsList description field and choices for type selection.
    // Type selection will always exclude "Self" option since the DS choice dictates self
    relationTypeDescriptions: {
        "1-M": "Each \"${currentDS}\" record may have multiple \"${relatedDS}\" records (1-to-many)",
        "M-1": "Each \"${relatedDS}\" record may have multiple \"${currentDS}\" records (many-to-1)",
        "Self": "Each \"${currentDS}\" record may have multiple other \"${relatedDS}\" records, in a tree"
    },

    // Component properties

    instructionsPanelDefaults: {
        _constructor: "InstructionsPanel",
        instructions: isc.RelationEditor.helpText,
        helpDialogId: "RelationEditorInstructions"
    },

    outerLayoutDefaults: {
        _constructor: "VLayout",
        autoDraw: false,
        isGroup: true,
        showGroupLabel: false,
        membersMargin: 10,
        layoutMargin: 10
    },

    //> @attr relationEditor.relationsList (AutoChild ListGrid : null : IR)
    //
    // @visibility devTools
    //<
    relationsListDefaults: {
        _constructor: "ListGrid",
        autoDraw:false,
        autoParent: "outerLayout",
        autoFocus:true,
        saveLocally:true,
        width: "100%",
        height: "*",
        showClippedValuesOnHover: true,
        defaultFields: [
            { name: "type", title: "Relation Type", width: 150,
                valueMap: {
                    "1-M": "1-to-many",
                    "M-1": "many-to-1",
                    "Self": "tree self-relation"
                }
            },
            { name: "dsId", title: "DataSource", width: 200,
                formatCellValue : function (value, record, rowNum, colNum, grid) {
                    if (!record || !value) return;
                    var relationEditor = grid.creator,
                        ds = relationEditor.session.get(value),
                        editingDS = (ds && ds.ID == relationEditor.dataSource.ID)
                    ;
                    value = (ds && !editingDS ? grid.createDSLink(value) : value);
                    return value + (ds ? "" : " (not present)");
                }
            },
            { name: "description", title: "Description", width: "*",
                formatCellValue : function (value, record, rowNum, colNum, grid) {
                    if (!record) return;
                    var type = record.type,
                        description = grid.creator.relationTypeDescriptions[type]
                    ;
                    description = description.evalDynamicString(grid, {
                        currentDS: grid.creator.dataSource.ID,
                        relatedDS: record.dsId
                    });
                    return description;
                }
            }
        ],

        selectionType:"single",
        selectionUpdated : function (record) {
            if (record) this.creator.editRelation(record);
        },

        canRemoveRecords:true,
        removeRecordClick : function (rowNum, colNum) {
            var grid = this,
                record = this.getRecord(rowNum)
            ;
            // if there's no record, nothing to do
            if (!record) return;

            if (!this.recordMarkedAsRemoved(rowNum) &&
                rowNum < this.originalRelationsCount &&
                !isc.RelationEditor.isGeneratedField(record.dsId))
            {
                var message = "Removing this relationship will remove all existing links between " +
                    "'${currentDS}' records and '${relatedDS}' records if you save. " +
                    "This cannot be undone. Proceed?";
                message = message.evalDynamicString(this, {
                    currentDS: this.creator.dataSource.ID,
                    relatedDS: record.dsId
                });
                isc.ask(message, function (value) {
                    if (value) grid.creator.removeRelation(record);
                }, {
                    buttons: [isc.Dialog.NO, isc.Dialog.YES]
                });
            } else {
                grid.creator.removeRelation(record);
            }
        },

        canHover:true,
        hoverWrap:false,

        hoverAutoFitWidth:false,
        hoverStyle: "vbLargeHover",
        cellHoverHTML : function (record, rowNum, colNum) {
            var field = this.getField(colNum);
            if (field.isRemoveField) {
                if (this.recordMarkedAsRemoved(rowNum)) {
                    return "Restore this relation";
                }
                return "Remove this relation";
            }
            var relationEditor = this.creator;
            if (!relationEditor.session.get(record.dsId)) {
                return "Related DataSource '" + record.dsId +
                    "' is not included in the project.<p>"+
                    "DataSources will be connected automatically if a DataSource '" + 
                    record.dsId + "' is added later.";
            }
        },

        _$linkTemplate:[
            "<a href='",
            ,   // 1: HREF
            "' target='",
            ,   // 3: name of target window
            // onclick handler enables us to prevent popping a window if (EG) we're masked.
            //                      5: ID
            "' onclick='if(window.",     ,") return ",
                    //  7:ID                               9:dsName,
                             ,"._linkToDataSourceClicked(\"",        ,"\");'>",
            ,   // 11: link text
            "</a>"
        ],

        createDSLink : function (dsName) {
            var relationEditor = this.creator;
            if (!relationEditor.canNavigateToDataSource) {
                return dsName;
            }

            var ID = this.getID(),
                template = this._$linkTemplate
            ;
            template[1] = "javascript:void";
            template[3] = "javascript";
            template[5] = ID;
            template[7] = ID;
            template[9] = dsName;
            template[11] = dsName;

            return template.join(isc.emptyString);
        },

        _linkToDataSourceClicked : function (dsName) {
            var relationEditor = this.creator;
            if (!relationEditor.addRelationButton.isDisabled()) {
                isc.ask("Save without adding the relationship?", function(value) {
                    if (value) {
                        relationEditor.openDataSource(dsName);
                    }
                });
            } else {
                relationEditor.openDataSource(dsName);
            }

            // Called from an <a href .../> onclick so return false to cancel action
            return false;
        }
    },

    addNewButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        autoParent: "outerLayout",
        title: "Add New",
        width: 75,
        layoutAlign: "right",
        click: function() {
            this.creator.addRelation();
        }
    },

    //> @attr relationEditor.relationForm (AutoChild DynamicForm : null : IRW)
    //
    // @visibility devTools
    //<
    relationFormDefaults: {
        _constructor: "DynamicForm",
        autoDraw:false,
        autoParent: "outerLayout",
        height: 225,
        wrapItemTitles:false,
        numCols: 4,
        colWidths: [ 125, 25, 50, "*" ],
        fields: [
            { name: "dsId", type: "SelectItem", title: "Related DataSource", colSpan: 3,
                change : function (form, item, value, oldValue) {
                    var relationEditor = form.creator,
                        result = true
                    ;
                    if (value) {
                        var ds = (value == relationEditor.dataSource.ID ? relationEditor.dataSource : relationEditor.session.get(value));
                        if (ds && isc.isA.MockDataSource(ds) && !ds.hasExplicitFields()) {
                            var defaults = relationEditor.session.getDataSourceDefaults(value);
                            if (!relationEditor.session.isUpdated(value) || !defaults.fields) {
                                // Don't accept user value yet. If confirm change it will
                                // be put back.
                                result = false;

                                relationEditor.confirmConvertSampleDataMockDataSource(ds,
                                    function (defaults) {
                                        // User-selected value is now confirmed valid
                                        item.changeToValue(value, true);
                                    }
                                );
                            }
                        }
                    }
                    return result;
                },
                mapValueToDisplay : function (value) {
                    var relationEditor = this.form.creator;
                    return (value && !relationEditor.session.get(value) ? value + " (not present)" : value);
                },
                pickListProperties: {
                    formatCellValue : function (value, record, rowNum, colNum) {
                        // Format a value that doesn't match an existing DS and that isn't
                        // already pre-formatted (i.e. tree relation)
                        var relationEditor = this.formItem.form.creator;
                        if (value && !relationEditor.session.get(value) && value.indexOf(" ") < 0) {
                            return value + " (not present)";
                        }
                        return value;
                    }
                }
            },
            { name: "type", type: "RadioGroup", title: "Relation Type", colSpan: 3,
                valueMap: {
                    "1-M": "1-to-many",
                    "M-1": "many-to-1"
                    // "1-1": "1-1"
                    
                },
                defaultValue: "1-M",
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [
                        { fieldName: "notPresentDS", operator: "equals", value: true }
                    ]
                }
            },
            { name: "treeMessageSpacer", type: "SpacerItem", visible: false },
            { name: "treeMessage", type: "staticText", showTitle: false, title: "&nbsp;", visible: false,  colSpan: 3 },

            
            { name: "required", type: "boolean", title: "Required?",
                //showTitle: false, 
                labelAsTitle: true, startRow: true,
                prompt: "If checked, records that have no related records are hidden.",
                hoverStyle: "vbLargeHover",
                change : function (form, item, value, oldValue) {
                    form.setValue("joinType", (value ? null : "outer"));
                },
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [
                        { fieldName: "notPresentDS", operator: "equals", value: true }
                    ]
                }
            },
            { name: "storedOnMessage", type: "staticText", showTitle: false, title: "&nbsp;", colSpan: 4,
                height: 20,
                hoverStyle: "vbLargeHover",
                hoverWidth: 400
            },
            { name: "fieldName", type: "text", title: "Stored as", required: true, colSpan: 3,
                editorType: "ComboBoxItem", addUnknownValues: true,
                hoverStyle: "vbLargeHover",
                hoverWidth: 400,
                titleHoverHTML : function () {
                    var pkDS = this.form.getSelectedDS(this.form.getValues()),
                        dsId = (pkDS ? pkDS.getID() : "related"),
                        message = "The field where the relation is stored.  This field will " +
                           "store the unique IDs of related Records from the <i>${dsId}</i> " + 
                           "DataSource."
                    ;
                    message = message.evalDynamicString(this, { dsId: dsId });
                    return message;
                },
                getTitleHTML : function () {
                    var title = this.Super("getTitleHTML", arguments);
                    return title + "&nbsp;" + this.form.helpImgHTML
                },
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [
                        { fieldName: "notPresentDS", operator: "equals", value: true }
                    ]
                },
                validateOnChange: true,
                validators: [
                    {
                        type:"custom",
                        condition: function (item, validator, value, record, additionalContext) {
                            if (!value || (record.origFieldName && record.origFieldName == value)) return true;

                            // Validate that if the field name is an existing field that it
                            // has the same type as the target PK and that the field name
                            // is not the PK of a Self relation (invalid relation).
                            var fkDS = item.form.getForeignKeyDS(record),
                                pkDS = item.form.getPrimaryKeyDS(record),
                                field = fkDS && fkDS.getField(value),
                                valid = true
                            ;
                            if (field && pkDS && fkDS.ID == pkDS.ID && field.primaryKey) {
                                validator.defaultErrorMessage 
                                    = "The Primary Key cannot relate to it itself in a tree relation";
                                valid = false;
                            }

                            if (field && pkDS && valid) {
                                var fieldType = field.type,
                                    pkField = pkDS.getPrimaryKeyField(),
                                    pkFieldType = pkField.type
                                ;
                                if ((fieldType == "sequence" ? "integer" : fieldType) !=
                                    (pkFieldType == "sequence" ? "integer" : pkFieldType))
                                {
                                    validator.defaultErrorMessage 
                                        = "Value matches an existing field in '" + fkDS.ID + "' which has a type " +
                                            "that differs from the target primary key in " + pkDS.ID +
                                            ". Please choose another field name.";
                                    valid = false;
                                }
                            }

                            return valid;
                        }
                    }
                ]
            },
            { name: "fieldTitle", type: "text", title: "Title as",  colSpan: 3,
                hoverStyle: "vbLargeHover",
                hoverWidth: 400,
                titleHoverHTML : function () {
                    return "Title for the field that stores the relation.  This is how the " +
                           "field will be labeled when viewed in a grid or form.<p>" +
                           "Usually, this is just the name of the related DataSource, for " +
                           "example, \"Employee\".  However, you can give it a more specific " +
                           "name to clarify what the relation means.  For example, an Order " +
                           "might store the Employee number of the salesman that made the " +
                           "sale.  It would be good to title that field \"Sales " +
                           "Representative\" rather than just \"Employee\", so that when " +
                           "you are viewing an Order, you know why it has a related Employee.";
                },
                getTitleHTML : function () {
                    var title = this.Super("getTitleHTML", arguments);
                    return title + "&nbsp;" + this.form.helpImgHTML
                },
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "or",
                    criteria: [
                        { fieldName: "dsId", operator: "isNull" },
                        { fieldName: "notPresentDS", operator: "equals", value: true }
                    ]
                }
            },
            { name: "enableDisplayAs", type: "boolean", align: "right", width: 125,
                showTitle: false, labelAsTitle: true, startRow: true,
                visibleWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [ { fieldName: "type", operator: "notEqual", value: "Self" } ]
                },
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [
                        { fieldName: "notPresentDS", operator: "equals", value: true }
                    ]
                }
            },
            { name: "displayField", type: "text", editorType: "SelectItem", title: "Display as",  colSpan: 2,
                allowEmptyValue: true,
                hint: "from dsID",
                hoverStyle: "vbLargeHover",
                hoverWidth: 400,
                titleHoverHTML : function () {
                    var pkDS = this.form.getPrimaryKeyDS(this.form.getValues()),
                        pkDSId = (pkDS ? pkDS.getID() : "related"),
                        fkDS = this.form.getForeignKeyDS(this.form.getValues()),
                        fkDSId = (fkDS ? fkDS.getID() : "related"),
                        message = "When you view the relation field stored on the <i>${fkDSId}</i> " +
                           "DataSource, you can show a field from the <i>${pkDSId}</i> " +
                           "DataSource (instead of showing the unique ID of the related " +
                           "record, which is just a number).<P>" +
                           "For example, if you have a relation field \"customerNumber\" on " +
                           "Order that stores the Customer that placed the order, you would " +
                           "set \"Display as\" to the <i>customerName</i> field, so that " +
                           "when you view an order, the Customer name is shown.<P>" +
                           "This is done via creating an <i>included field</i>.  Included " +
                           "fields don't really store data, instead they just <i>include</i> " +
                           "data from a related DataSource, dynamically, whenever a user is " +
                           "viewing records from the primary DataSource.  You can also add " +
                           "included fields later for any relation."
                    ;
                    message = message.evalDynamicString(this, {
                        fkDSId: fkDSId,
                        pkDSId: pkDSId
                    });
                    return message;
                },
                getTitleHTML : function () {
                    var title = this.Super("getTitleHTML", arguments);
                    return title + "&nbsp;" + this.form.helpImgHTML
                },
                visibleWhen: {
                    _constructor: "AdvancedCriteria", operator: "and",
                    criteria: [ { fieldName: "type", operator: "notEqual", value: "Self" } ]
                },
                readOnlyWhen: {
                    _constructor: "AdvancedCriteria", operator: "or",
                    criteria: [
                        { fieldName: "dsId", operator: "isNull" },
                        { fieldName: "notPresentDS", operator: "equals", value: true },
                        { fieldName: "enableDisplayAs", operator: "notEqual", value: true }
                    ]
                }
            }
        ],
        initWidget : function () {
            var helpImgURL = this.getImgURL("[SKINIMG]actions/help.png");
            this.helpImgHTML = "<img src='" + helpImgURL + "' width='12' height='12' valign='center'/>";

            this.Super("initWidget", arguments);
        },
        editRecord : function (record) {
            this.creator.addRelationButton.disable();
            record.origFieldName = record.fieldName;
            if (!record.origIncludeField) {
                record.origIncludeField = record.includeField || record.displayField;
            }
            record.enableDisplayAs = (record.displayField != null);
            record.required = (record.joinType != "outer");
            this.updateDataSourceChoices(record);
            this.updateTypeChoices(record);
            this.updateFieldNameHint(record);
            this.updateFieldNameChoices(record);
            this.updateDisplayAsChoices(record);
            this.updateDisplayAsHint(record);
            this.Super("editRecord", arguments);
            this.updateTreeMessage(record);
            this.updateStoredOnMessage(record);
            this.setFieldDefaults();
        },
        editNewRecord : function (record) {
            this.creator.addRelationButton.disable();
            if (record) record.joinType = "outer";
            this.updateDataSourceChoices(record);
            this.updateTypeChoices(record);
            this.updateFieldNameHint(record);
            this.updateFieldNameChoices(record);
            this.updateDisplayAsChoices(record);
            this.updateDisplayAsHint(record);
            this.Super("editNewRecord", arguments);
            this.updateTreeMessage(record);
            this.updateStoredOnMessage(record);
            this.setFieldDefaults();
        },
        itemChanged : function (item, newValue) {
            var relationEditor = this.creator,
                record = this.getValues()
            ;
            if ("dsId" == item.name) {
                var currentDSId = (relationEditor.dataSource ? relationEditor.dataSource.ID : null);
                if (relationEditor.session.get(newValue) || newValue == currentDSId) {
                    this.updateTypeChoices(record);
                    this.updateFieldNameHint(record);
                    this.updateFieldNameValue();
                    this.updateFieldNameChoices(record, true);
                    this.updateDisplayAsChoices(record, true);
                    this.updateDisplayAsHint(record);
                    this.updateFieldTitleValue();
                    this.updateTreeMessage(record);
                    this.updateStoredOnMessage(record);
                    this.setValue("notPresentDS", false);
                    this.setValue("relatedFieldName", null);
                } else {
                    this.setValue("notPresentDS", true);
                }
            } else if ("type" == item.name) {
                this.updateFieldNameHint(record);
                this.updateFieldNameValue();
                this.updateFieldNameChoices(record);
                this.updateDisplayAsChoices(record, true);  // Force update to current value
                this.updateDisplayAsHint(record);
                this.updateFieldTitleValue();
                this.updateTreeMessage(record);
                this.updateStoredOnMessage(record);
                // The following fields need to be cleared in case changing an existing
                // relation type so they will be re-assigned
                this.setValue("includeField", null);
                this.setValue("relatedFieldName", null);
            } else if ("fieldName" == item.name) {
                this.updateFieldNameHint(record);
            } else if ("enableDisplayAs" == item.name || "displayField" == item.name) {
                this.updateFieldTitleValue();
            }
            if (this.valuesAreValid(false)) {
                var isNew = (this.saveOperationType == "add");
                if (!isNew) {
                    relationEditor.saveRelation(this.getValues(), isNew);
                } else {
                    relationEditor.addRelationButton.enable();
                }
            } else {
                relationEditor.addRelationButton.disable();
            }
        },
        setFieldDefaults : function () {
            var relationEditor = this.creator,
                isNew = (this.saveOperationType == "add")
            ;
            if (isNew || this.getValue("displayField")) {
                this.setValue("enableDisplayAs", true);
            }
            var dsId = this.getValue("dsId");
            if (isNew) {
                var currentDSId = (relationEditor.dataSource ? relationEditor.dataSource.ID : null);
                if (dsId && dsId == currentDSId) {
                    this.setValue("type", "Self");
                } else { 
                    this.setValue("type", "1-M");
                }
                this.setValue("joinType", "outer");
            }
            if (!isNew && dsId && !relationEditor.session.get(dsId)) {
                this.setValue("notPresentDS", true);
            } else {
                this.setValue("notPresentDS", false);
            }
        },
        updateDataSourceChoices : function (record) {
            if (!this.creator.knownDataSources) return;
            var relationEditor = this.creator,
                dataSourceIds = relationEditor.knownDataSources.getProperty("ID"),
                currentDSId = (relationEditor.dataSource ? relationEditor.dataSource.ID : null),
                valueMap = {}
            ;
            // If the DS being edited is not part of the knownDataSources add it now
            // so that a tree relations can be defined.
            if (currentDSId && !dataSourceIds.contains(currentDSId)) {
                dataSourceIds.add(currentDSId);
            }

            // Sort case-insensitive
            dataSourceIds.sort(function (a, b) {
                a = a.toLowerCase();
                b = b.toLowerCase();
                return (a < b ? -1 : a == b ? 0 : 1);
            });

            for (var i = 0; i < dataSourceIds.length; i++) {
                var id = dataSourceIds[i];
                valueMap[id] = (id == currentDSId ?
                                id + " (tree via self-relation)" :
                                (!relationEditor.session.get(id) ? id + " (not present)" : id));
            }
            this.getField("dsId").setValueMap(valueMap);
        },
        updateTypeChoices : function (record) {
            var dsId = (record ? record.dsId : null),
                currentDSId = (this.creator.dataSource ? this.creator.dataSource.ID : null),
                descriptions = this.creator.relationTypeDescriptions,
                typeField = this.getField("type"),
                valueMap = {}
            ;

            if (dsId && dsId == currentDSId) {
                // For the type RadioGroupItem to accept the "Self" value it must be in valueMap
                valueMap = { "Self": "Tree self-relation" };
                typeField.hide();
                typeField.setValueMap(valueMap);
                // Value has to be "Self" since that's the only choice
                typeField.setValue("Self");
            } else {
                for (var type in descriptions) {
                    if (type == "Self") continue;
                    var description = descriptions[type];
                    description = description.evalDynamicString(this, {
                        currentDS: currentDSId,
                        relatedDS: dsId || "&lt;related&gt;"
                    });
                    valueMap[type] = description;
                }
                typeField.setValueMap(valueMap);
                if (typeField.getValue() == "Self") {
                    // Switching from "Self" to whatever the defaultValue is for the group
                    typeField.setValue(null);
                }
                typeField.show();
            }
        },
        updateFieldNameHint : function (record) {
            var hint;
            if (record) {
                var fkDS = this.getForeignKeyDS(record),
                    value = record.fieldName,
                    existingField = fkDS && (fkDS.getField(value) != null)
                ;
                if (fkDS) {
                    hint = " on <i>" + fkDS.ID + "</i> "
                    if (!existingField && record.origFieldName && value != record.origFieldName) {
                        hint += "[rename field from <i>" + record.origFieldName + "</i>]";
                    } else {
                        hint += (existingField ? "[existing field] with title:" : "[new field]");
                    }
                }
            }
            this.getField("fieldName").setHint(hint);
        },
        updateFieldNameValue : function () {
            var relationEditor = this.creator,
                relatedDSId = this.getValue("dsId"),
                currentDSId = (relationEditor.dataSource ? relationEditor.dataSource.ID : null),
                type = this.getValue("type"),
                ds = (type == "1-M" ? relationEditor.dataSource : relationEditor.session.get(relatedDSId))
            ;
            if (ds) {
                // A title is likely singular so use it if defined
                var dsTitle = (ds.title || ds.ID).replace(/ /g, ""),
                    value = dsTitle.substring(0, 1).toLowerCase() + dsTitle.substring(1) + "Id"
                ;
                // A tree relation (self) uses a "parent" field
                if (relatedDSId && relatedDSId == currentDSId) {
                    value = "parent" + dsTitle.substring(0, 1).toUpperCase() + dsTitle.substring(1) + "Id";
                }
                this.setValue("fieldName", value);
            }
        },
        updateFieldNameChoices : function (record, dsChanged) {
            var relationEditor = this.creator,
                type = record && record.type,
                relatedDSId = type && record.dsId
            ;
            if (!relatedDSId || !relationEditor.session.get(relatedDSId)) {
                this.getField("fieldName").setValueMap(null);
                return;
            }

            // Populate the comboBox with existing field names from DS where the FK will
            // be stored. Only show fields that have the same type as the PK of the related
            // DS and are not already foreign keys. For a tree relation (self) don't provide
            // the PK field as an option. The PK cannot reference itself - the relation is invalid.
            var fkDS = this.getForeignKeyDS(record),
                pkDS = this.getPrimaryKeyDS(record),
                dsFieldNames = fkDS.getFieldNames(),
                pkField = pkDS.getPrimaryKeyField(),
                pkFieldType = pkField.type,
                allowPK = (fkDS.ID != pkDS.ID),
                valueMap = []
            ;
            if (pkFieldType == "sequence") pkFieldType = "integer";

            for (var i = 0; i < dsFieldNames.length; i++) {
                var dsFieldName = dsFieldNames[i],
                    field = fkDS.getField(dsFieldName),
                    fieldType = (field.type == "sequence" ? "integer" : field.type)
                ;
                if (fieldType == pkFieldType && (allowPK || !field.primaryKey) && !field.foreignKey) {
                    valueMap.add(field.name);
                }
            }
            this.getField("fieldName").setValueMap(valueMap);
        },
        updateFieldTitleValue : function () {
            var relationEditor = this.creator,
                enableAsValue = this.getValue("enableDisplayAs"),
                displayAsValue = (enableAsValue ? this.getValue("displayField") : null),
                relatedDSId = this.getValue("dsId"),
                relatedDS = relationEditor.session.get(relatedDSId),
                relatedTitle = (relatedDS ? relatedDS.title || relatedDS.ID.replace(/\d+$/, "") : null),
                title = relatedTitle
            ;
            if (displayAsValue) {
                var type = this.getValue("type"),
                    targetDS = (type == "1-M" ? relationEditor.dataSource : relationEditor.session.get(relatedDSId)),
                    field = targetDS.getField(displayAsValue)
                ;
                title = field && (field.title || isc.DS.getAutoTitle(displayAsValue));
                if (!title || !title.toLowerCase().contains(relatedTitle.toLowerCase())) {
                    title = relatedTitle;
                }
            }

            this.setValue("fieldTitle", title);
            this.setValue("_generatedFieldTitle", title);
        },
        updateDisplayAsChoices : function (record, dsChanged) {
            if (!record) return;
            var relationEditor = this.creator,
                sourceDSId = (record.type == "M-1" ? record.dsId : relationEditor.dataSource.ID),
                displayAsValue = record.displayField,
                displayAsField = this.getField("displayField"),
                clearValue = dsChanged,
                valueMap
            ;
            if (sourceDSId) {
                var currentDSId = (relationEditor.dataSource ? relationEditor.dataSource.ID : null),
                    sourceDS = (sourceDSId == currentDSId ? relationEditor.dataSource : relationEditor.session.get(sourceDSId))
                ;
                if (sourceDS) {
                    valueMap = sourceDS.getFieldNames();

                    if (!displayAsValue || dsChanged) {
                        var defaultTitleField = sourceDS.getTitleField();
                        if (defaultTitleField) {
                            displayAsField.setValue(defaultTitleField);
                            clearValue = false;
                        }
                    }
                }
            }
            if (clearValue) displayAsField.clearValue();
            displayAsField.setValueMap(valueMap);
        },
        updateDisplayAsHint : function (record) {
            var hint;
            if (record && record.dsId) {
                hint = "from <i>" + 
                        (record.type == "M-1" ? record.dsId : this.creator.dataSource.ID) +
                        "</i>";
            }
            this.getField("displayField").setHint(hint);
        },
        updateTreeMessage : function (record) {
            var dsId = (record ? record.dsId : null),
                currentDSId = (this.creator.dataSource ? this.creator.dataSource.ID : null),
                treeMessageSpacerField = this.getField("treeMessageSpacer"),
                treeMessageField = this.getField("treeMessage")
            ;

            if (dsId && dsId == currentDSId) {
                treeMessageSpacerField.show();
                treeMessageField.show();
                treeMessageField.setValue("Each '" + currentDSId +
                    "' record may have multiple other '" + currentDSId + "' records, in a tree.");
            } else {
                treeMessageSpacerField.hide();
                treeMessageField.hide();
            }
        },
        updateStoredOnMessage : function (record) {
            var fkDS = this.getForeignKeyDS(record),
                storedOnMessageField = this.getField("storedOnMessage"),
                message,
                prompt
            ;
            if (fkDS) {
                message = "Relation data will be stored on the <i>" + fkDS.ID + "</i> DataSource";
                prompt = isc.RelationEditor.shortHelpText
            }
            storedOnMessageField.setValue(message);
            storedOnMessageField.setPrompt(prompt);
        },
        getSelectedDS : function (record) {
            if (!record) return null;
            var relationEditor = this.creator;
            return (record.dsId == relationEditor.dataSource.ID ?
                        relationEditor.dataSource :
                        relationEditor.session.get(record.dsId));
        },
        getForeignKeyDS : function (record) {
            if (!record) return null;
            return (record.type == "1-M" ? this.getSelectedDS(record) : this.creator.dataSource);
        },
        getPrimaryKeyDS : function (record) {
            if (!record) return null;
            return (record.type == "1-M" ? this.creator.dataSource : this.getSelectedDS(record));
        }
    },

    addRelationButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        autoParent: "outerLayout",
        title: "Add Relation",
        wrap: false,
        autoFit: true,
        layoutAlign: "right",
        click: function() {
            this.creator.saveNewRelation();
        }
    },


    buttonLayoutDefaults: {
        _constructor: "HLayout",
        autoDraw: false,
        width: "100%",
        height:42,
        layoutMargin:10,
        membersMargin:10,
        align: "right"
    },

    cancelButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        title: "Cancel",
        width: 75,
        autoParent: "buttonLayout",
        click: function() {
            this.creator.cancelClick();
        }
    },

    saveButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        title: "Save",
        width: 75,
        autoParent: "buttonLayout",
        click: function() {
            this.creator.saveClick();
        }
    },

    bodyProperties:{
        overflow:"auto",
        layoutMargin:10
    },

    // methods

    initWidget : function () {
        this.Super('initWidget', arguments);

        // Add instruction section at top
        this.addAutoChild("instructionsPanel");

        this.addAutoChildren(["outerLayout","relationsList","addNewButton","relationForm","addRelationButton","buttonLayout"]);
        this.buttonLayout.addMember(this.createAutoChild("cancelButton"));
        this.buttonLayout.addMember(this.createAutoChild("saveButton"));

        // Create an editor session if not already provided
        if (!this.session) {
            this.session = isc.DataSourceEditorSession.create({
                dsDataSource: this.dsDataSource,
                dataSources: this.knownDataSources,
                useLiveDataSources: this.useLiveDataSources
            });
            // Make note that we created the session so it can be destroyed when we are
            this._createdSession = true;
        } else if (!this.knownDataSources) {
            // grab list of up-to-date known datasources from session
            var session = this.session;
            this.knownDataSources = session.getDataSources().map(function (node) {
                return session.get(node.ID);
            });
        }

        this.addRelation();
    },

    destroy : function () {
        // Destroy our editor session if we created it
        if (this.session && this._createdSession) this.session.destroy(); 
        this.Super("destroy", arguments);
    },
    
    // api

    //> @method relationEditor.edit()
    // Start editing relations for a DataSource.
    // <p>
    // The Save and Cancel buttons will call +link{editComplete} by default
    // (see +link{saveClick} and +link{cancelClick}). The caller can then determine what
    // to do with the changes, if any. See +link{editComplete} for details.
    //
    // @param dataSource (DataSource | Object) the dataSource or defaults to edit relations
    // @param [selectForeignKey] (FieldName) the name of a foreign key field for which
    //                                       the relation should be selected initially
    // 
    // @visibility devTools
    //<
    edit : function (dataSource, selectForeignKey) {
        if (!this.knownDataSources && !this.session) {
            this.logWarn("'knownDataSources' not populated - ignoring relations edit")
            return;
        }

        if (this.knownDataSources && !this.session.dataSources) {
            this.session.setDataSources(this.knownDataSources);
        }
    
        var defaults;
        if (!isc.isA.DataSource(dataSource)) {
            // Create a temporary live DS instance from the defaults for editing.
            // Defaults can be provided via editNode/paletteNode or a just a defaults object
            defaults = dataSource.defaults || dataSource;
            var dsName = defaults && defaults.ID;
            this.session.add(dsName, defaults, true);
            dataSource = this.session.get(dsName);
        }
    
        this.dataSource = null;
        this.dsDefaults = null;

        this.start(dataSource, selectForeignKey);
    },

    newRelationMessage: "New ${type} relation added from ${sourceDSId} to ${targetDSId}.",
    newRelationActionTitle: "Click to view new fields on ${sourceDSId} DataSource",

    // Show added relations as notifications @ (x,y) if specified.
    // Callback will be made if the user clicks on message link passing the dsId as argument
    showNewRelationNotifications : function (x, y, actionCallback, excludeLocalRelations, width) {
        // Save callback for use by notificationActionClicked()
        this._notificationCallback = actionCallback;
        var newRelations = this._newRelations;
        if (!isc.isAn.emptyObject(newRelations)) {
            // Show a message for each new relation via the Notify system
            for (var dsId in newRelations) {
                var relation = newRelations[dsId],
                    type = relation.type,
                    sourceDSId = this.dataSource.ID,
                    targetDSId = relation.dsId
                ; 

                if ("M-1" == type || "Self" == type) {
                    // Don't show relations that are defined in this.dataSource
                    if (excludeLocalRelations) continue;
                    type = ("M-1" == type ? "Many-to-1" : type);
                } else if ("1-M" == type) {
                    type = "1-to-many";
                    sourceDSId = relation.dsId;
                    targetDSId = this.dataSource.ID;
                }

                var message = this.newRelationMessage.evalDynamicString(this, {
                    type: type,
                    sourceDSId: sourceDSId,
                    targetDSId: targetDSId
                });
                var actionTitle = this.newRelationActionTitle.evalDynamicString(this, {
                    type: type,
                    sourceDSId: sourceDSId,
                    targetDSId: targetDSId
                });
                var settings = {
                    duration: 7000,
                    canDismiss: true, 
                    messageIcon: "[SKIN]/Notify/checkmark.png",
                    autoFitWidth: (width == null),
                    autoFitMaxWidth: 550,
                    appearMethod: "fade",
                    disappearMethod: "fade",
                    x: x,
                    y: y
                };
                if (width != null) {
                    settings.labelProperties = { width: width };
                }

                isc.Notify.addMessage(
                    message,
                    [{
                        separator: "<BR>",
                        title: actionTitle,
                        target: this, methodName: "notificationActionClicked",
                        args: [sourceDSId]
                    }],
                    null,
                    settings
                );
            }
        }
    },

    // Call callback saved in showNewRelationNotifications() with selected target dsId
    notificationActionClicked : function (dsId) {
        if (this._notificationCallback) {
            this.fireCallback(this._notificationCallback, ["dsId"], [dsId]);
        }
    },

    //> @method relationEditor.save
    // Saves all pending DataSource changes to +link{dsDataSource}. The +link{dataSourceSaved}
    // method is called after each DataSource is saved.
    // <P>
    // The callback will be called even if there are no pending changes to save.
    //
    // @param [callback] (Callback) the callback function to be called when all saves complete
    //
    // @visibility devTools
    //<
    save : function (callback) {
        // Save editor changes to session
        this.pushEditsToSession();

        // Save session changed to dsDataSource
        this.session.saveChanges(callback, { target: this, methodName:"dataSourceSaved" });
    },

    getDefaults : function (name) {
        return this.session.getDataSourceDefaults(name);
    },
    
    getFieldRenames : function (name) {
        return this.session.getRenamedFields(name);
    },
    
    getFieldAdds : function (name) {
        return this.session.getAddedFields(name);
    },
    
    getFieldDeletes : function (name) {
        return this.session.getRemovedFields(name);
    },

    waitUntilDrawn : function (callback, params) {
        if (!this.isDrawn()) {
            this._untilDrawnDetails = {
                callback: callback,
                params: params
            };
            this.observe(this, "drawn", "observer._waitUntilDrawn();");
            return;
        }
        this.fireCallback(callback, null, params);
    },

    _waitUntilDrawn : function () {
        if (this.isObserving(this, "drawn")) this.ignore(this, "drawn");
        var callback = this._untilDrawnDetails.callback,
            params = this._untilDrawnDetails.params
        ;
        delete this._untilDrawnDetails;

        this.fireCallback(callback, null, params);
    },

    confirmConvertSampleDataMockDataSource : function (dataSource, callback) {
        var _this = this,
            dsId = dataSource.ID
        ;
        var message = "To create a relation with this DataSource, it must be converted " +
            "from sample data to editing fields and data separately.  Do this now?"

        isc.ask(message, function(response) {
            if (response) {
                var defaults = _this.switchToEditFieldsAndDataSeparately(dataSource);
                callback(defaults);
            } else {
                _this.cancelClick();
            }
        }, {
            buttons: [
                isc.Dialog.NO,
                isc.Dialog.YES
            ]
        });
        // Make sure dialog is above editor window
        isc.Dialog.Warn.delayCall("bringToFront");
    },

    start : function (dataSource, selectForeignKey) {
        var relationEditor = this,
            session = this.session
        ;

        // Make sure editor session has loaded all known DataSource and is ready for use
        if (!session.isReady()) {
            session.waitForReady(function () {
                relationEditor.start(dataSource, selectForeignKey);
            });
            return;
        }

        this.relationsList.emptyMessage = "Inspecting relations for " + dataSource.ID;
        this.relationsList.setData([]);

        // A MockDataSource with mockData cannot be edited. Offer to convert the DS
        // to a standard MockDataSource with fields and sample data or exit.
        if (isc.isA.MockDataSource(dataSource) && !dataSource.hasExplicitFields()) {
            var defaults = session.getDataSourceDefaults(dataSource.ID);
            if (!session.isUpdated(dataSource.ID) || !defaults.fields || defaults.fields.length == 0) {
                this.waitUntilDrawn(function (dataSource, selectForeignKey) {
                    relationEditor.confirmConvertSampleDataMockDataSource(dataSource, function (defaults) {
                        // Pull updated DS from the session and start editing again
                        relationEditor.start(session.get(dataSource.ID), selectForeignKey);
                    });
                }, [dataSource, selectForeignKey]);
                return;
            }
        }

        this.dataSource = dataSource;
        if (!this.dsDefaults) {
            this.dsDefaults = session.getDataSourceDefaults(dataSource.ID);
        }

        // this.dsDefaults and this.dataSource are both populated at this point
        this.relationForm.updateDataSourceChoices();

        // Get relations from the perspective of this.dataSource
        var relations = session.getRelations(),
            dsRelations = this.dsDefaults && relations.getRelationsForDataSource(this.dsDefaults.ID)
        ;

        

        // Save original relations to determine added records and correct data to remove
        this.originalRelations = isc.clone(dsRelations);
        this.originalRelationsCount = dsRelations.length;

        // These are the relations to edit
        this.relationsList.emptyMessage = "No relations defined for " + dataSource.ID;
        this.relationsList.setData(dsRelations);

        if (selectForeignKey) {
            // Select relation for foreignKey
            var field = { foreignKey: selectForeignKey },
                relatedFieldName = isc.DS.getForeignFieldName(field),
                relatedDSName = isc.DS.getForeignDSName(field, this.dataSource)
            ;
            for (var i = 0; i < relations.length; i++) {
                var relation = relations[i];
                if (relation.dsId == relatedDSName && relation.relatedFieldName == relatedFieldName) {
                    this.relationsList.selectSingleRecord(relation);
                    break;
                }
            }
        } else {
            // Always start with editing a new relation in the lower form
            this.addRelation();
        }
    },

    // Does the target DS have a field <fieldName> already?
    // Determining this is a not as easy as checking getField() for non-null.
    // If a pending relation will be adding the field, that should report as existing.
    // Additionally, if there is a pending relation removal that will be removing the
    // field, it should be reported as not existing.
    dsHasExistingField : function (ds, fieldName, ignoreRelation) {
        var dsId = ds.ID;
        ds = this.session.get(dsId);

        var recordsAreEqual = function (record1, record2) {
            var fieldNames = (isc.isA.DataSource(ds) ? ds.getFieldNames() : ds.fields.getProperty("name"));
            for (var i = 0; i <  fieldNames.length; i++) {
                // No need for special compare method because all types are simple and no dates
                if (record1[ fieldNames[i] ] != record2[ fieldNames[i] ]) {
                    return false;
                }
            }
            return true;
        };

        var relationsList = this.relationsList,
            relations = relationsList.data,
            isRemovedField,
            localField
        ;
        for (var i = 0; i < relations.length; i++) {
            var relation = relations[i];
            if (relation.dsId != ds.ID &&
                relation.type == "M-1" &&
                ((relation.includeField != null && relation.includeField == fieldName) ||
                 (relation.includeField == null && relation.displayField == fieldName) ||
                 (relation.origIncludeField != null && relation.origIncludeField == fieldName)))
            {
                if (relationsList.recordMarkedAsRemoved(i)) {
                    isRemovedField = true;
                } else {
                    if (ignoreRelation && recordsAreEqual(relation, ignoreRelation)) {
                        // Found matching field in the relations but it happens to be
                        // the relation being validated so we will assume that the field
                        // is not in use elsewhere.
                        return;   
                    }
                    localField = true;
                }
            }
        }

        if (!localField) {
            var getField = function (ds, fieldName) {
                if (isc.isA.DataSource(ds)) return ds.getField(fieldName);
                return ds.fields.find("name", fieldName);
            }
            localField = !isRemovedField && (getField(ds, fieldName) != null);
        }

        return localField;
    },

    addRelation : function () {
        // Start editing a new relation. No record in list yet.
        this.relationsList.deselectAllRecords();
        this.relationForm.editNewRecord();
    },

    saveNewRelation : function () {
        if (!this.relationForm.valuesAreValid(false)) return;

        this.saveRelation(this.relationForm.getValues(), true);
    },

    removeRelation : function (record) {
        var rowNum = this.relationsList.getRecordIndex(record);
        if (this.relationsList.recordMarkedAsRemoved(rowNum)) {
            // Restoring a removed relation could cause a conflict with another relation
            // fieldName. 
            if (record.dsId != this.dataSource.ID && record.type == "M-1") {
                var includeField = record.includeField || record.displayField;
                if (this.dsHasExistingField(this.dataSource, includeField)) {
                    // Existing field using the same name. It must have been added in another
                    // pending relation. Update either this relation if it not an original
                    // relation or the other relation to prevent the conflict.
                    if (rowNum < this.originalRelationsCount) {
                        // This restored relation is an original relation. It should continue
                        // to use the includeField value so the newer, added relation should
                        // be updated to use an alias.
                        var relationsList = this.relationsList,
                            relations = relationsList.data
                        ;
                        for (var i = 0; i < relations.length; i++) {
                            var relation = relations[i];
                            if (!relationsList.recordMarkedAsRemoved(i) &&
                                relation.dsId != this.dataSource.ID &&
                                relation.type == "M-1" &&
                                ((relation.includeField != null && relation.includeField == includeField) ||
                                (relation.includeField == null && relation.displayField == includeField) ||
                                (relation.origIncludeField != null && relation.origIncludeField == includeField)))
                            {
                                record = relation;
                                break;
                            }
                        }
                    } else {
                        // This restored relation has been added during this session so its
                        // alias can be changed directly.
                    }

                    // Create a new alias and assign it
                    var newIncludeField = record.dsId +
                            record.displayField.substring(0, 1).toUpperCase() +
                            record.displayField.substring(1),
                        baseIncludeField = newIncludeField,
                        count = 2
                    ;
                    while (this.dsHasExistingField(this.dataSource, newIncludeField)) {
                        newIncludeField = baseIncludeField + count++;
                    }
                    record.includeField = newIncludeField;

                    // If the updated relation is currently selected, refresh the selection
                    // so the edit form has updated values
                    if (this.relationsList.isSelected(record)) {
                        this.relationsList.deselectRecord(record);
                        this.relationsList.selectSingleRecord(record);
                    }
                }
            }
            this.relationsList.unmarkRecordRemoved(rowNum);
        } else {
            this.relationsList.markRecordRemoved(rowNum);
            this.addRelation();
        }
    },

    editRelation : function (record) {
        this.relationForm.editRecord(record);
    },

    saveRelation : function (record, isNew) {
        if (isNew) {
            // In saveLocally:true mode addData() is synchronous
            this.relationsList.addData(isc.addProperties({}, record));
            // Start a new relation to clear form entry. No relation is selected.
            this.addRelation();
        } else {
            var gridRecord = this.relationsList.getSelectedRecord(),
                rowNum = this.relationsList.getRecordIndex(gridRecord)
            ;
            // Update record in place
            isc.addProperties(gridRecord, record);
            if (!record.enableDisplayAs) delete gridRecord.displayField;
            delete gridRecord.enableDisplayAs;
            delete gridRecord.required;
            this.relationsList.refreshRow(rowNum);
        }
    },

    //> @method relationEditor.cancelClick
    // Method called when the cancel button is clicked. By default +link{editComplete} is
    // called with the <code>canceled</code> argument set to <code>true</code>.
    //
    // @visibility devTools
    //<
    cancelClick : function () {
        if (this.editComplete) {
            this.editComplete(true);
        }
    },

    //> @method relationEditor.saveClick
    // Method called when the save button is clicked. By default the user is prompted to
    // save a work-in-progress relation if applicable and then +link{editComplete}
    // is called with the <code>canceled</code> argument set to <code>true</code> if no changes
    // were made are pending for the current DataSource or any others that have been edited from this
    // session. Otherwise editComplete() is called to allow the caller to determine the next
    // steps.
    // <P>
    // It is the responsibility of the caller to call +link{save} to persist changes if desired.
    // See +link{editComplete} for a description of the save process.
    // <P>
    // Note that if the +link{session} is being shared with another component, the changes are
    // reflected there and can be saved by any of the components.
    //
    // @visibility devTools
    //<
    saveClick : function () {
        if (this.readOnly) {
            // Nothing to save - same as canceling
            this.editComplete(true);
        }

        // First, warn if you have defined a new relation but not yet clicked "Add Relation"
        var _this = this;
        if (!this.addRelationButton.isDisabled()) {
            isc.ask("Save without adding the relationship?", function(value) {
                if (value) {
                    _this._saveClick();
                }
            });
        } else {
            this._saveClick();
        }
    },

    _saveClick : function () {
        // Save edits to session
        var changed = this.pushEditsToSession();

        // If the session was updated with changes or there are already outstanding changes
        // due to a DS conversion (already in the session), notify caller to save.
        var canceled = !changed && !this._convertedDataSource;
        this.editComplete(canceled);
    },

    openDataSource : function (dsName) {
        var session = this.session;
    
        // Save any local changes to session
        this.pushEditsToSession();
    
        var liveDS = session.get(dsName),
            defaults = session.getDataSourceDefaults(dsName)
        ;
        if (this.navigateToDataSource) {
            this.navigateToDataSource(dsName, liveDS, defaults);
        } else {
            this.logWarn("Attempt to navigate to DataSource '" + dsName +
                "' but method navigateToDataSource() is not defined. Ignoring.");
        }
    },
    
    pushEditsToSession : function () {
        // Accumulate list of FK field changes grouped by DataSource so they
        // can be applied together
        var relations = this.relationsList.data,
            changesByDataSource = {}
        ;

        // Determine if there are multiple relations that target the same DataSource.
        // For example Tasks->User (reportedBy) and Tasks->User (assignedTo).
        // In those cases, the includeFrom field but use an includeVia property to identify
        // the correct relation.
        var targetDSCounts = {};
        for (var i = 0; i < relations.length; i++) {
            var relation = relations[i],
                deleted = this.relationsList.recordMarkedAsRemoved(i)
            ;
            if (!deleted && relation.type == "M-1") {
                var targetDSId = relation.dsId;
                targetDSCounts[targetDSId] = (targetDSCounts[targetDSId] || 0) + 1;
            }
        }
        var isMultiTargetDS = function (dsId) {
            return (targetDSCounts[dsId] != null && targetDSCounts[dsId] > 1);
        };

        for (var i = 0; i < relations.length; i++) {
            var relation = relations[i];
            // Don't ignore read-only relations because a relation that targets a
            // non-existing DataSource should still be allowed to be removed.

            var deleted = this.relationsList.recordMarkedAsRemoved(i),
                changed = false
            ;
            if (deleted) {
                // If the relation to be deleted was added during this edit session
                // there is nothing else to do
                if (i >= this.originalRelationsCount) continue;

                relation = this.originalRelations[i];
            } else if (i < this.originalRelationsCount) {
                var origRelation = this.originalRelations[i];
                changed = (!this.relationsMatch(origRelation, relation) ||
                            (relation.type == 'M-1' && isMultiTargetDS(relation.dsId)));
                if (changed) {
                    // Determine if the change is a foreignKey field rename. If so, we don't
                    // want to remove the FK field completely and add a new one, but rather
                    // have the caller rename the field so values remain.
                    if (origRelation.type == relation.type && origRelation.fieldName != relation.fieldName) {
                        var dsId = relation.dsId,
                            ds = (dsId == this.dataSource.ID ? this.dataSource : this.session.get(dsId))
                        ;
                        if (!ds.getField(relation.fieldName)) {
                            relation.renameFrom = origRelation.fieldName;
                        }
                    }

                    if (!relation.renameFrom) {
                        // Remove the relation and add it back correctly if changed
                        // except for just a joinType change (i.e. required)
                        if (origRelation.dsId != relation.dsId ||
                            origRelation.type != relation.type ||
                            origRelation.fieldName != relation.fieldName ||
                            (relation.type == 'M-1' && isMultiTargetDS(relation.dsId)))
                        {
                            // Changed relation - register a change to remove the original relation
                            this.saveRelationChange(changesByDataSource, origRelation, true);
                            changed = true;
                        }
                    }
                }

                // If relation didn't change and no extra fields did either, go to next change
                if (!changed && this.relationExtrasMatch(origRelation, relation)) continue;
                changed = true;
            }

            this.saveRelationChange(changesByDataSource, relation, deleted, isMultiTargetDS(relation.dsId));

            // Save list of new relations for later notifications
            if (!changed && !deleted) {
                if (!this._newRelations) this._newRelations = {};
                this._newRelations[relation.dsId] = relation;
            }
        }

        if (!isc.isAn.emptyObject(changesByDataSource)) {
            var session = this.session;
            for (var sourceDSId in changesByDataSource) {
                var changes = changesByDataSource[sourceDSId];

                this.updateForeignKeys(sourceDSId, changes, function (dsId, defaults) {
                    if (defaults) {
                        // Push updated DS defaults into the session for later saving
                        session.set(dsId, defaults);
                    }
                });
            }
        }
        return !isc.isAn.emptyObject(changesByDataSource);
    },
    
    relationsMatch : function (origRelation, relation) {
        var match = (origRelation.dsId == relation.dsId &&
            origRelation.type == relation.type &&
            origRelation.fieldName == relation.fieldName &&
            origRelation.joinType == relation.joinType);
        return match;
    },

    relationExtrasMatch : function (origRelation, relation) {
        var match = (origRelation.fieldTitle == relation.fieldTitle &&
            origRelation.displayField == relation.displayField &&
            origRelation.includeField == relation.includeField);
        return match;
    },

    saveRelationChange : function (changesByDataSource, relation, deleted, forceIncludeVia) {
        var type = relation.type,
            sourceDSId = ("1-M" == type ? relation.dsId : this.dataSource.ID),
            targetDSId = (type == "1-M" ? this.dataSource.ID : relation.dsId),
            sourceFieldTitle = relation.fieldTitle,
            includeField = relation.includeField,
            includeVia
        ;
        if (!deleted && relation.displayField) {
            var sourceDS = (sourceDSId == this.dataSource.ID ? this.dataSource : this.session.get(sourceDSId)),
                baseIncludeField
            ;

            // Assign the includeField "name" based on a number of potential algorithms
            // before falling back to adding a numeric counter on the end.
            //
            // Previously the "name" might have been left blank to pick up from the
            // target field but that can result in a strange field in the source DS.
            // Like includeFrom="employee.firstName" resulting in a SourceDS.firstName
            // field. It is unique but not helpful.

            // If the user edited the title, use that as the basis for the includeField
            if (sourceFieldTitle && relation._generatedFieldTitle && sourceFieldTitle != relation._generatedFieldTitle) {
                includeField = isc.DataSourceEditor.createNameFromTitle(sourceFieldTitle);
                baseIncludeField = includeField;

                if (this.dsHasExistingField(sourceDS, includeField, relation) ||
                    (sourceDSId == this.dataSource.ID && relation.fieldName == includeField))
                {
                    // Conflict with existing field so reset to try next naming algorithm
                    includeField = null;
                }
            }
            if (!includeField) {
                // Attempt to name includeField based on targetDS and displayField

                // If include is by includeVia force an alias for the includeField and mark it as such
                if (forceIncludeVia) {
                    includeField = relation.fieldName +
                        relation.displayField.substring(0, 1).toUpperCase() +
                        relation.displayField.substring(1);
                    includeVia = relation.fieldName;
                } else {
                    // Introduce an alias based on the target DS and field name
                    includeField = targetDSId.substring(0, 1).toLowerCase() +
                                    targetDSId.substring(1) +
                                    relation.displayField.substring(0, 1).toUpperCase() +
                                    relation.displayField.substring(1);
                }
                if (!baseIncludeField) {
                    baseIncludeField = includeField;
                }

                if (this.dsHasExistingField(sourceDS, includeField, relation) ||
                    (sourceDSId == this.dataSource.ID && relation.fieldName == includeField))
                {
                    // Conflict with existing field so reset to try next naming algorithm
                    includeField = null;
                }
            }
            if (!includeField) {
                // Attempt to name includeField based on targetDS
                includeField = targetDSId.substring(0, 1).toLowerCase() + targetDSId.substring(1);

                if (this.dsHasExistingField(sourceDS, includeField, relation) ||
                    (sourceDSId == this.dataSource.ID && relation.fieldName == includeField))
                {
                    // Conflict with existing field so reset to try next naming algorithm
                    includeField = null;
                }
            }
            // If we still don't have a unique includeField, fall back on the first or
            // second attempt above and append a counter to get something unique
            if (!includeField) {
                includeField = baseIncludeField;

                var count = 2;
                while (this.dsHasExistingField(sourceDS, includeField, relation)) {
                    includeField = baseIncludeField + count++;
                }
            }
        } else if (!deleted && !relation.displayField && includeField) {
            // There is no displayField on the relation so we don't need an includeFrom field
            includeField = null;
        }

        if (!changesByDataSource[sourceDSId]) changesByDataSource[sourceDSId] = [];
        changesByDataSource[sourceDSId].add({
            sourceDSId: sourceDSId,
            sourceFieldName: relation.fieldName,
            sourceFieldTitle: relation.fieldTitle,
            targetDSId: targetDSId,
            targetFieldName: relation.relatedFieldName,
            displayField: relation.displayField,
            includeField: includeField,
            includeVia: (forceIncludeVia ? relation.fieldName : includeVia),
            joinType: relation.joinType,
            deleted: deleted,
            renameFrom: relation.renameFrom
        });
    },

    // callback(<sourceDSId>, <defaults>)
    // returns true if any DS changed
    updateForeignKeys : function (sourceDSId, changes, callback) {
        var session = this.session,
            // clone defaults so changes are not applied to session until explicitly set
            defaults = isc.clone(session.getDataSourceDefaults(sourceDSId)),
            sourceDS = session.get(sourceDSId),
            changed = false
        ;

        // Determine if there are multiple relations that target the same DataSource.
        // For example Tasks->User (reportedBy) and Tasks->User (assignedTo).
        // In those cases, the includeFrom field but use an includeVia property to identify
        // the correct relation.
        var targetDSCounts = {};
        for (var i = 0; i < changes.length; i++) {
            var change = changes[i],
                targetDSId = change.targetDSId
            ;
            if (!change.deleted && (change.includeField || change.displayField)) {
                targetDSCounts[targetDSId] = (targetDSCounts[targetDSId] || 0) + 1;
            }
        }
        var isMultiTargetDS = function (dsId) {
            return (targetDSCounts[dsId] != null && targetDSCounts[dsId] > 1);
        };

        for (var i = 0; i < changes.length; i++) {
            var change = changes[i],
                sourceFieldName = change.sourceFieldName,
                sourceFieldTitle = change.sourceFieldTitle,
                renameFrom = change.renameFrom,
                targetDSId = change.targetDSId,
                targetFieldName = change.targetFieldName,
                targetDS = this.session.get(targetDSId),
                joinType = change.joinType
            ;
            var targetPK = targetDS && targetDS.getPrimaryKeyField(),
                targetPKName = targetDS && targetDS.getPrimaryKeyFieldName()
            ;
            if (!targetFieldName) targetFieldName = targetPKName;

            // foreignKey value - doesn't need <dataSourceId> for self-relation
            var fk = (sourceDSId != targetDSId ? targetDSId + "." : "") + targetFieldName;

            // See if sourceFieldName exists
            var sourceField = defaults.fields.find("name", renameFrom || sourceFieldName);
            if (!sourceField) {
                // Need to create the sourceField FK
                var type = targetPK.type;
                if (type == "sequence") type = "integer";
                var field = { name: sourceFieldName, type: type, foreignKey: fk };
                if (sourceFieldTitle) field.title = sourceFieldTitle;
                if (joinType) field.joinType = joinType;
                defaults.fields.add(field);
                session.recordAddedField(sourceDSId, field.name);
                sourceField = field;
                changed = true;
                // record the newly generated field
                isc.RelationEditor.addGeneratedField(sourceDS, sourceFieldName);
            } else {
                // sourceField exists. See if FK needs to be updated or removed
                if (change.deleted && sourceField.foreignKey == fk) {
                    // only delete field if it was added during this Reify "session".
                    // otherwise, drop the foreignKey property only.
                    if (isc.RelationEditor.isGeneratedField(sourceDS, sourceField.name)) {
                        // defaults.fields.remove(sourceField);
                        session.removeField(sourceDSId, sourceField.name, null, defaults);
                        isc.RelationEditor.removeGeneratedField(sourceDS, sourceField.name);
                    } else {
                        var foreignKey = sourceField.foreignKey;
                        delete sourceField.foreignKey;
                        delete sourceField.foreignDisplayField;
                        delete sourceField.useLocalDisplayFieldValue;
                        delete sourceField.joinType;
                        // FK is no longer a FK so remove any includeFrom fields that use
                        // the old relation
                        session.removeIncludeFieldsForForeignKey(sourceDSId, foreignKey, defaults);
                        if (sourceField.displayField && defaults.fields.find("name", sourceField.displayField) == null) {
                            delete sourceField.displayField;
                        }
                    }
                    changed = true;
                } else if (change.deleted) {
                    // relation doesn't exist anymore
                } else if (!sourceField.foreignKey ||
                    sourceField.foreignKey != fk ||
                    sourceField.joinType != joinType)
                {
                    var type = targetPK.type;
                    if (type == "sequence") type = "integer";
                    if (sourceField.type != type) {
                        // Update type on field. This also updates sample data as needed
                        session.changeFieldType(sourceDSId, sourceField.name, type, defaults);
                    }
                    sourceField.foreignKey = fk;
                    if (!joinType) delete sourceField.joinType;
                    else sourceField.joinType = joinType;
                    changed = true;
                }
                if (sourceField.title != sourceFieldTitle) {
                    sourceField.title = sourceFieldTitle;
                    changed = true;
                }
                if (sourceField.name != sourceFieldName) {
                    sourceField.name = sourceFieldName;
                    session.renameField(sourceDSId, sourceField.name, sourceFieldName, defaults);
                    changed = true;
                }
                if (sourceField.displayField != (change.includeField || change.displayField)) {
                    var oldDisplayFieldIndex = defaults.fields.findIndex("name", sourceField.displayField);
                    if (oldDisplayFieldIndex >= 0) {
                        // Remove field in the current defaults
                        session.removeField(sourceDSId, sourceField.displayField, null, defaults);
                        changed = true;
                    }
                }
            }

            // Create/update FK displayField and/or includeFrom fields
            if (!change.deleted && (change.includeField || change.displayField)) {
                var displayField = change.includeField || change.displayField,
                    includeFrom = targetDSId + "." + change.displayField
                ;
                if (change.displayField) {
                    if (sourceField.displayField != displayField) {
                        sourceField.displayField = displayField;
                        changed = true;
                    }
                } else if (sourceField.displayField) {
                    delete sourceField.displayField;
                    changed = true;
                }

                var includeFromField = defaults.fields.find("name", displayField);
                if (!includeFromField && !isMultiTargetDS(targetDSId)) {
                    // An includeFrom field may not have a "name" attribute so we
                    // need to look for includeFrom="<targetDSId>.<name>" as well.
                    includeFromField = defaults.fields.find("includeFrom", includeFrom);
                }
                if (includeFromField) {
                    // includeFrom field already exists. Leave it as-is or update the name.
                    if (change.includeField) {
                        if (includeFromField.name != change.includeField) {
                            includeFromField.name = change.includeField;
                            changed = true;
                        }
                    } else if (includeFromField.name) {
                        delete includeFromField.name;
                        changed = true;
                    }
                    if (includeFromField.includeFrom != includeFrom) {
                        includeFromField.includeFrom = includeFrom;
                        changed = true;
                    }
                } else {
                    // Create includeFrom field for the displayField. Since the includeFrom
                    // is used as displayField for the FK default it to hidden.
                    var field = { includeFrom: includeFrom, hidden: true };
                    if (change.includeField) {
                        field.name = change.includeField;
                    }
                    if (change.includeVia) {
                        field.includeVia = change.includeVia;
                    }
                    defaults.fields.add(field);
                    session.recordAddedField(sourceDSId, field.name);
                    sourceField = field;
                    changed = true;
                }
            }
            
        }
        callback(sourceDS.ID, (changed ? defaults : null));
        return changed;
    },

    switchToEditFieldsAndDataSeparately : function (dataSource) {
        var defaults = this.session.standardizeMockDataSource(dataSource.ID);
        this._convertedDataSource = true;
        return defaults;
    }
}); // end RelationEditor.addProperties

isc.RelationEditor.registerStringMethods({
    //> @method relationEditor.editComplete
    // Method called by default from +link{saveClick} or +link{cancelClick} in response to a
    // user clicking the save or cancel buttons.
    // <P>
    // It is the responsibility of the caller to respond accordingly to save any pending changes
    // and/or close or hide the editor.
    // <P>
    // Assuming the edit is not canceled, a typical handler will call +link{save} to have
    // pending changes saved to the +link{dsDataSource}. Individual DataSource saves can
    // be handled with +link{dataSourceSaved}.
    //
    // @param canceled (Boolean) true if the edit is being canceled (i.e. nothing to save)
    //
    // @visibility devTools
    //<
    editComplete: "canceled",

    //> @method relationEditor.dataSourceSaved
    // Method called by +link{save} after each DataSource is saved.
    // <P>
    // There is no default implementation.
    //
    // @param name (Identifier) ID of the DataSource that was saved
    // @param ds (DataSource) Live instance of DataSource
    // @param isNew (Boolean) Is the save DataSource new? Value is always <code>null</code>.
    // @param originalName (Identifier) the original DataSource ID if the DataSource was renamed
    //
    // @visibility devTools
    //<
    dataSourceSaved: "name,ds,isNew,originalName",

    //> @method relationEditor.dataSourceChanged
    // Notification method fired when a DataSource is changed.
    //
    // @param name (String) the DataSource ID that changed. null for the currently editing one.
    // @param defaults (Properties) the updated DataSource defaults
    // @visibility devTools
    //<
    dataSourceChanged: "name",

    //> @method relationEditor.navigateToDataSource
    // Method called when the user requests to edit another DataSource, typically from
    // clicking a link in a relation shown when +link{canNavigateToDataSource} is enabled.
    // <P>
    // There is no default implementation to show the selected DataSource. The caller must
    // implement this to determine how navigation occurs. For example, a
    // +link{DataSourceEditor} instance might be opened with the selected DataSource.
    //
    // @param dsName (String) the DataSource ID to be shown
    // @param liveDS (DataSource) the live DS to be shown. This may be a temporary instance.
    // @param defaults (Properties) the defaults use to create an instance of the target DataSource
    //
    // @visibility devTools
    //<
    navigateToDataSource: "dsName,liveDS,defaults"
});

//> @class SimpleTreeRelationEditor
// Provides a UI for editing a +link{DataSource, DataSource's) tree relationship.
// 
// @inheritsFrom VLayout
// @treeLocation Client Reference/Tools
// @visibility devTools
//<
isc.ClassFactory.defineClass("SimpleTreeRelationEditor", "VLayout");

isc.SimpleTreeRelationEditor.addProperties({
    // attributes 
    overflow: "visible",
    membersMargin: 10,
    layoutTopMargin: 5,
    layoutLeftMargin: 5,
    layoutRightMargin: 5,
    // Not setting bottom margin so buttons are placed to match other windows

    // properties

    //> @attr simpleTreeRelationEditor.dsDataSource (DataSource | ID : null : IRW)
    // DataSource to be used to load and save ds.xml files, via fileSource operations.
    //
    // @visibility devTools
    //<

    // Component properties

    //> @attr simpleTreeRelationEditor.relationForm (AutoChild DynamicForm : null : IRW)
    //
    // @visibility devTools
    //<
    relationFormDefaults: {
        _constructor: "DynamicForm",
        autoDraw:false,
        autoFocus:true,
        wrapItemTitles:false,
        colWidths: [ 250, "*" ],
        fields: [
           { name: "fieldName", type: "text", title: "Relation will be stored on<br>DataSource under field",
                wrapTitle: true, required: true, selectOnFocus: true,
                editorType: "ComboBoxItem", addUnknownValues: true,
                validators: [
                    {
                        type:"custom",
                        condition: function (item, validator, value, record, additionalContext) {
                            if (!value || (record.origFieldName && record.origFieldName == value)) return true;

                            // Validate that if the field name is an existing field that it
                            // has the same type as the target PK and that the field name
                            // is not the PK of a Self relation (invalid relation).
                            var ds = item.form.creator.dataSource,
                                field = ds.getField(value),
                                valid = true
                            ;
                            if (field && field.primaryKey) {
                                validator.defaultErrorMessage 
                                    = "The Primary Key cannot relate to it itself in a tree relation";
                                valid = false;
                            }

                            if (field && valid) {
                                var fieldType = field.type,
                                    pkField = ds.getPrimaryKeyField(),
                                    pkFieldType = pkField.type
                                ;
                                if ((fieldType == "sequence" ? "integer" : fieldType) !=
                                    (pkFieldType == "sequence" ? "integer" : pkFieldType))
                                {
                                    validator.defaultErrorMessage 
                                        = "Value matches an existing field that has a type " +
                                            "that differs from the target primary key in " + ds.ID +
                                            ". Please choose another field name.";
                                    valid = false;
                                }
                            }

                            return valid;
                        }
                    }
                ]
            }
        ],
        editNewRecord : function () {
            this.Super("editNewRecord", arguments);
            this.updateFieldNameTitle();
            this.updateFieldNameChoices();
            this.updateFieldNameValue();
        },
        fieldNameTitle: "Relation will be stored on<br>DataSource '${dsId}' under field",
        updateFieldNameTitle : function () {
            var dsId = this.creator.dataSource.ID,
                title = this.fieldNameTitle.evalDynamicString(this, { dsId: dsId })
            ;
            this.getField("fieldName").title = title;
            this.getField("fieldName").redraw();
        },
        updateFieldNameChoices : function () {
            // Populate the comboBox with existing field names from DS. Only show fields
            // that have the same type as the DS and are not already foreign keys. Don't
            // provide the PK field as an option. The PK cannot reference itself - 
            // the relation is invalid.
            var ds = this.creator.dataSource,
                dsFieldNames = ds.getFieldNames(),
                pkField = ds.getPrimaryKeyField(),
                pkFieldType = pkField.type,
                valueMap = []
            ;
            if (pkFieldType == "sequence") pkFieldType = "integer";

            for (var i = 0; i < dsFieldNames.length; i++) {
                var dsFieldName = dsFieldNames[i],
                    field = ds.getField(dsFieldName),
                    fieldType = (field.type == "sequence" ? "integer" : field.type)
                ;
                if (fieldType == pkFieldType && !field.primaryKey && !field.foreignKey) {
                    valueMap.add(field.name);
                }
            }
            this.getField("fieldName").setValueMap(valueMap);
        },
        updateFieldNameValue : function () {
            var ds = this.creator.dataSource;

            // A title is likely singular so use it if defined
            var dsTitle = (ds.title || ds.ID).replace(/ /g, ""),
                baseValue = "parent" + dsTitle.substring(0, 1).toUpperCase() + dsTitle.substring(1) + "Id",
                value = baseValue,
                count = 2
            ;
            // Make sure default field name is unique
            while (ds.getField(value) != null) {
                value = baseValue + count;
                count++;
            }
            this.setValue("fieldName", value);
        }
    },

    buttonLayoutDefaults: {
        _constructor: "HLayout",
        width: "100%",
        height:42,
        layoutMargin:10,
        membersMargin:10,
        align: "right"
    },

    cancelButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        title: "Cancel",
        width: 75,
        autoParent: "buttonLayout",
        click: function() {
            this.creator.cancelClick();
        }
    },

    saveButtonDefaults: {
        _constructor: "IButton",
        autoDraw: false,
        title: "Save",
        width: 75,
        autoParent: "buttonLayout",
        click: function() {
            this.creator.saveClick();
        }
    },

    bodyProperties:{
        overflow:"auto",
        layoutMargin:10
    },

    // methods

    initWidget : function () {
        this.Super('initWidget', arguments);

        this.addAutoChildren(["relationForm","buttonLayout"]);
        this.buttonLayout.addMember(this.createAutoChild("cancelButton"));
        this.buttonLayout.addMember(this.createAutoChild("saveButton"));

        // Create an editor session if not already provided
        if (!this.session) {
            this.session = isc.DataSourceEditorSession.create({
                dsDataSource: this.dsDataSource
            });
            // Make note that we created the session so it can be destroyed when we are
            this._createdSession = true;
        }        
    },

    destroy : function () {
        // Destroy our editor session if we created it
        if (this.session && this._createdSession) this.session.destroy(); 
        this.Super("destroy", arguments);
    },
    
    // api

    //> @method simpleTreeRelationEditor.edit()
    // Start editing tree relation for a DataSource.
    // <p>
    // The Save and Cancel buttons will call +link{editComplete} by default
    // (see +link{saveClick} and +link{cancelClick}). The caller can then determine what
    // to do with the changes, if any. See +link{editComplete} for details.
    // 
    // @param dataSource (Object | DataSource | ID) dataSource or defaults to edit relation
    // @visibility devTools
    //<
    edit : function (dataSource) {
        var defaults;
        if (!isc.isA.DataSource(dataSource)) {
            // Create a temporary live DS instance from the defaults for editing.
            // Defaults can be provided via editNode/paletteNode or a just a defaults object
            defaults = dataSource.defaults || dataSource;
            var dsName = defaults && defaults.ID;
            this.session.add(dsName, defaults, true);
            dataSource = this.session.get(dsName);
        }
    
        this.dataSource = dataSource;
        this.dsDefaults = defaults;

        if (!this.dsDefaults) {
            // If we have no defaults, we want the session to load them. It will only 
            // do that for known DataSources that have a partial paletteNode with
            // defaults of ID and a loadData() function.
            var editor = this;
            var dsNode = {
                ID: dataSource.ID,
                defaults: { ID: dataSource.ID },
                loadData : function () { /* placeholder */ }
            };
            this.session.setDataSources([dsNode], function () {
                var defaults = editor.session.getDataSourceDefaults(dataSource.ID);
                editor.edit({
                    ID: dataSource.ID,
                    defaults: defaults
                });
            });
            return;
        }

        if (isc.isA.MockDataSource(dataSource) && !dataSource.hasExplicitFields()) {
            var _this = this;
            this.waitUntilDrawn(function (dataSource) {
                // Either convert the MockDataSource or cancel the edit
                _this.confirmConvertSampleDataMockDataSource(dataSource, function (defaults) {
                    _this.edit(defaults);
                });
            }, [dataSource]);
            return;
        }


        this.start();
    },

    //> @method simpleTreeRelationEditor.save
    // Saves all pending DataSource changes to +link{dsDataSource}. The +link{dataSourceSaved}
    // method is called after each DataSource is saved.
    // <P>
    // The callback will be called even if there are no pending changes to save.
    //
    // @param [callback] (Callback) the callback function to be called when all saves complete
    //
    // @visibility devTools
    //<
    save : function (callback) {
        // Save editor changes to session
        this.pushEditsToSession();

        // Save session changed to dsDataSource
        this.session.saveChanges(callback, { target: this, methodName:"dataSourceSaved" });
    },

    waitUntilDrawn : function (callback, params) {
        if (!this.isDrawn()) {
            this._untilDrawnDetails = {
                callback: callback,
                params: params
            };
            this.observe(this, "drawn", "observer._waitUntilDrawn();");
            return;
        }
        this.fireCallback(callback, null, params);
    },

    _waitUntilDrawn : function () {
        if (this.isObserving(this, "drawn")) this.ignore(this, "drawn");
        var callback = this._untilDrawnDetails.callback,
            params = this._untilDrawnDetails.params
        ;
        delete this._untilDrawnDetails;

        this.fireCallback(callback, null, params);
    },

    confirmConvertSampleDataMockDataSource : function (dataSource, callback) {
        var _this = this,
            dsId = dataSource.ID
        ;
        var message = "To create a relation with this DataSource, it must be converted " +
            "from sample data to editing fields and data separately.  Do this now?"

        isc.ask(message, function(response) {
            if (response) {
                var defaults = _this.switchToEditFieldsAndDataSeparately(dataSource);
                callback(defaults);
            } else {
                _this.cancelClick();
            }
        }, {
            buttons: [
                isc.Dialog.NO,
                isc.Dialog.YES
            ]
        });
        // Make sure dialog is above editor window
        isc.Dialog.Warn.delayCall("bringToFront");
    },

    start : function () {
        // this.dsDefaults and this.dataSource are both populated at this point
        var relationEditor = this,
            session = this.session
        ;

        // Make sure editor session has loaded all known DataSource and is ready for use
        if (!session.isReady()) {
            session.waitForReady(function () {
                relationEditor.start();
            });
            return;
        }

        // Always start with editing a new relation in the lower form
        this.relationForm.editNewRecord();
    },

    //> @method simpleTreeRelationEditor.cancelClick
    // Method called when the cancel button is clicked. By default +link{editComplete} is
    // called with the <code>canceled</code> argument set to <code>true</code>.
    //
    // @visibility devTools
    //<
    cancelClick : function () {
        if (this.editComplete) {
            this.editComplete(true);
        }
    },

    //> @method simpleTreeRelationEditor.saveClick
    // Method called when the save button is clicked. editComplete() is called to allow
    // the caller to determine the next steps.
    // <P>
    // It is the responsibility of the caller to call +link{save} to persist changes if desired.
    // See +link{editComplete} for a description of the save process.
    //
    // @visibility devTools
    //<
    saveClick : function () {
        if (!this.relationForm.validate()) return;

        // Save edits to session
        var changed = this.pushEditsToSession();

        // If the session was updated with changes or there are already outstanding changes
        // due to a DS conversion (already in the session), notify caller to save.
        var canceled = !changed && !this._convertedDataSource;
        this.editComplete(canceled);
    },

    pushEditsToSession : function () {
        if (!this.relationForm.validate()) return;

        var session = this.session,
            relation = this.relationForm.getValues(),
            sourceDS = this.dataSource,
            targetDS = this.dataSource,
            targetPK = targetDS.getPrimaryKeyField(),
            targetPKName = targetDS.getPrimaryKeyFieldName(),
            targetFieldName = targetPKName,
            sourceDSId = sourceDS.ID,
            sourceFieldName = relation.fieldName,
            targetDSId = targetDS.ID
        ;

        // Grab current defaults so they can be updated
        var defaults = session.getDataSourceDefaults(sourceDSId);

        // If the relation field doesn't exist, create it
        if (defaults.fields.find("name", sourceFieldName) == null) {
            // clone defaults so session.set() will see the change
            defaults = isc.clone(defaults);

            // Add relation field
            var fk = targetDSId + "." + targetFieldName,
                type = targetPK.type;
            if (type == "sequence") type = "integer";
            var field = { name: sourceFieldName, type: type, foreignKey: fk, hidden: true };
            defaults.fields.add(field);

            // Save changes to session
            session.set(sourceDSId, defaults);
        }

        return session.isUpdated(sourceDSId);
    },

    switchToEditFieldsAndDataSeparately : function (dataSource) {
        var defaults = this.session.standardizeMockDataSource(dataSource.ID);
        this._convertedDataSource = true;
        return defaults;
    }
}); // end SimpleTreeRelationEditor.addProperties

isc.RelationEditor.registerStringMethods({
    //> @method simpleTreeRelationEditor.editComplete
    // Method called by default from +link{saveClick} or +link{cancelClick} in response to a
    // user clicking the save or cancel buttons.
    // <P>
    // It is the responsibility of the caller to respond accordingly to save any pending changes
    // and/or close or hide the editor.
    // <P>
    // Assuming the edit is not canceled, a typical handler will call +link{save} to have
    // pending changes saved to the +link{dsDataSource}. Individual DataSource saves can
    // be handled with +link{dataSourceSaved}.
    //
    // @param canceled (Boolean) true if the edit is being canceled (i.e. nothing to save)
    //
    // @visibility devTools
    //<
    editComplete: "canceled",

    //> @method simpleTreeRelationEditor.dataSourceSaved
    // Method called by +link{save} after each DataSource is saved.
    // <P>
    // There is no default implementation.
    //
    // @param name (Identifier) ID of the DataSource that was saved
    // @param ds (DataSource) Live instance of DataSource
    //
    // @visibility devTools
    //<
    dataSourceSaved: "name,ds"
});

}

isc.ClassFactory.defineClass("DSRelations");

isc.DSRelations.addClassProperties({
    relationTypeDescriptionMap: {
        "1-M": "1-to-many",
        "M-1": "many-to-1",
        "Self": "tree self-relation"
    }
});

isc.DSRelations.addMethods({

    //> @attr dsRelations.dsDataSource (DataSource | ID : null : IRW)
    // DataSource to be used to load and save ds.xml files, via fileSource operations.
    //<

    //> @attr dsRelations.dataSources (Array of DataSource : null : IRW)
    // List of DataSources from which to determine relations.
    //<
    setDataSources : function (dsList) {
        this.dataSources = dsList;
        this.reset();
    },

    // Clear relations cache so it will be rebuilt on next request
    reset : function () {
        delete this._rawRelations;
    },

    getRelationsForDataSource : function (name) {
        this.buildRelations();

        // grab list of direct FKs and build a map of indirect FKs
        var rawRelations = this._rawRelations,
            directFKs = rawRelations[name],
            indirectFKs = {}
        ;
        for (var dsName in rawRelations) {
            if (dsName == name) continue;
            var fks = rawRelations[dsName];
            for (var i = 0; i < fks.length; i++) {
                var fk = fks[i];
                if (fk.relatedDS == name) {
                    if (!indirectFKs[dsName]) indirectFKs[dsName] = [];
                    indirectFKs[dsName].add(fk);
                }
            }
        }

        var relations = [];

        // For direct FKs, define specified relationships
        if (directFKs) {
            for (var i = 0; i < directFKs.length; i++) {
                var fk = directFKs[i],
                    type = (name == fk.relatedDS ? "Self" : "M-1"),
                    displayField = fk.displayField
                ;

                relations.add({
                    type: type,
                    fieldName: fk.fieldName,
                    fieldTitle: fk.fieldTitle,
                    dsId: fk.relatedDS,
                    relatedFieldName: fk.relatedFieldName,
                    displayField: displayField,
                    joinType: fk.joinType
                })
            }
        }

        // Define relationships for indirect FKs
        for (var dsName in indirectFKs) {
            var fks = indirectFKs[dsName];
            for (var i = 0; i < fks.length; i++) {
                var fk = fks[i];
                relations.add({
                    type: "1-M",
                    fieldName: fk.fieldName,
                    fieldTitle: fk.fieldTitle,
                    dsId: dsName,
                    relatedFieldName: fk.relatedFieldName,
                    displayField: fk.displayField,
                    joinType: fk.joinType
                })
            }
        }
        return relations;
    },

    getAllRelationsForDataSource : function (name) {
        this.buildRelations();

        var relations = this.getRelationsForDataSource(name);
        do {
            var newRelations = [];
            for (var i = 0; i < relations.length; i++) {
                var relation = relations[i],
                    subRelations = this.getRelationsForDataSource(relation.dsId)
                ;
                if (subRelations && subRelations.length > 0) {
                    // Make sure to exclude sub-relations that point back to a this DS or
                    // that have already been added.
                    for (var j = 0; j < subRelations.length; j++) {
                        var subRelation = subRelations[j];
                        if (subRelation.dsId != name &&
                            !relations.find("dsId", subRelation.dsId) &&
                            !newRelations.find("dsId", subRelation.dsId))
                        {
                            subRelation.parentDsId = relation.dsId;
                            newRelations.add(subRelation);
                        }
                    }
                }
                if (!relation.parentDsId) relation.parentDsId = name;
            }
            relations.addList(newRelations);
        } while (newRelations.length > 0);

        return relations;
    },

    getIncludeFromDependencyTree : function () {
        var dsList = this.dataSources,
            dependsOn = {}
        ;
        for (var i = 0; i < dsList.length; i++) {
            var ds = dsList[i],
                dsName = ds.ID,
                fieldNames = ds.getFieldNames()
            ;
            var dependencies = dependsOn[dsName] = [];
            for (var j = 0; j < fieldNames.length; j++) {
                var fieldName = fieldNames[j],
                    field = ds.getField(fieldName)
                ;
                if (field && field.includeFrom) {
                    var split = field.includeFrom.split(".");
                    if (split && split.length >= 2) {
                        dependencies.add(split[0]);
                    }
                }
            }
        }

        var nodes = [];
        for (var i = 0; i < dsList.length; i++) {
            var dsName = dsList[i].ID,
                dependencies = dependsOn[dsName]
            ;
            if (!dependencies || dependencies.length == 0) {
                nodes.add({ id: dsName });
                this._addDependenciesToNode(nodes, dsName, dependsOn);
            } else {
                var foundDS = false;
                for (var j = 0; j < dependencies.length; j++) {
                    if (isc.DS.get(dependencies[j])) {
                        foundDS = true;
                        break;
                    }
                }
                if (!foundDS) {
                    nodes.add({ id: dsName });
                    this._addDependenciesToNode(nodes, dsName, dependsOn);
                }
            }
        }

        return isc.Tree.create({
            data: nodes
        });
    },

    // Get list of fields { dsId, fieldName } that reference the specified field
    getFieldReferences : function (name, fieldName) {
        var relations = this.getAllRelationsForDataSource(name),
            includeFromEnding = name + "." + fieldName,
            references = []
        ;

        for (var i = 0; i < relations.length; i++) {
            var relation = relations[i],
                dsId = relation.dsId,
                ds = this.dataSources.find("ID", dsId),
                dsFieldNames = ds && ds.getFieldNames()
            ;
            if (ds) {
                for (var j = 0; j < dsFieldNames.length; j++) {
                    var dsFieldName = dsFieldNames[j],
                        dsField = ds.getField(dsFieldName)
                    ;
                    if (dsField.includeFrom && dsField.includeFrom.endsWith(includeFromEnding)) {
                        references.add({
                            dsId: dsId,
                            fieldName: dsField.name || dsField.includeFrom
                        });
                    }
                }
            }
        }
        return references;
    },

    _addDependenciesToNode : function (nodes, parentId, dependsOn) {
        for (var key in dependsOn) {
            var list = dependsOn[key];
            if (list && list.contains(parentId) && !nodes.containsProperty("id", key)) {
                nodes.add({ id: key, parentId: parentId });
                this._addDependenciesToNode(nodes, key, dependsOn);
            }
        }
    },

    // Update includeFrom field references to <dsName>.<fieldRenames>.
    // callback(updatedDataSourceNames) is called after updates have been saved
    // and the affected DataSources have been recreated.
    updateIncludeFromReferences : function (dsName, fieldRenames, callback) {
        var dsList = this.dataSources,
            changes = {}
        ;
        for (var i = 0; i < dsList.length; i++) {
            var ds = dsList[i],
                fieldNames = ds.getFieldNames()
            ;
            for (var j = 0; j < fieldNames.length; j++) {
                var fieldName = fieldNames[j],
                    field = ds.getField(fieldName)
                ;
                if (field && field.includeFrom) {
                    for (var fromName in fieldRenames) {
                        if (dsName == ds.ID && field.includeFrom == fromName) {
                            if (changes[ds.ID] == null) changes[ds.ID] = {};
                            changes[ds.ID][fieldName] = fieldRenames[fromName];
                        } else if (field.includeFrom == dsName + "." + fromName) {
                            if (changes[ds.ID] == null) changes[ds.ID] = {};
                            changes[ds.ID][fieldName] = dsName + "." + fieldRenames[fromName];
                        }
                    }
                }
            }
        }
        if (changes && !isc.isAn.emptyObject(changes)) {
            var self = this,
                updatedDataSourceNames = isc.getKeys(changes),
                pendingChangeCount = updatedDataSourceNames.length
            ;
            for (var dsName in changes) {
                this.getDataSourceDefaults(dsName, function (dsId, defaults) {
                    var fieldChanges = changes[dsId],
                        fields = defaults.fields
                    ;
                    for (var i = 0; i < fields.length; i++) {
                        var field = fields[i],
                            fieldName = field.name
                        ;
                        // if includeFrom is set, but name isn't pick up name from includeFrom property
                        if (!fieldName && field.includeFrom != null) {
                            var split = field.includeFrom.split(".");
                            if (split != null && split.length >= 2) {
                                fieldName = split.last();
                            }
                        }

                        if (!fieldName) continue;

                        if (fieldChanges[fieldName] != null && field.includeFrom) {
                            field.includeFrom = fieldChanges[fieldName];
                        }
                    }

                    // Save the update DS configuration
                    self.saveDataSource(defaults, function () {
                        // Create a new live instance with changes applied
                        self.createLiveInstance(defaults);

                        if (--pendingChangeCount == 0) {
                            if (callback) callback(updatedDataSourceNames);
                        }
                    });
                });
            }
        } else {
            if (callback) callback();
        }
    },

    removeRelationsToDataSource : function (sourceDS, targetDSId, removeFKField, callback) {
        var fkFields = this.getForeignKeyFields(sourceDS),
            isRelatedToTarget = false
        ;
        // Confirm that sourceDS has relations to targetDSId before loading defaults
        // which requires a server round-trip
        if (!isc.isAn.emptyObject(fkFields)) {
            for (var fieldName in fkFields) {
                var fkField = fkFields[fieldName],
                    foreignKey = fkField.foreignKey
                ;
                if (foreignKey.indexOf(".") >= 0) foreignKey = foreignKey.split(".")[0];
                if (foreignKey == targetDSId) {
                    isRelatedToTarget = true;
                    break;
                }
            }
        }
        if (!isRelatedToTarget) {
            callback();
            return;
        }

        // source is related to target
        var self = this;
        this.getDataSourceDefaults(sourceDS.ID, function (dsId, defaults) {
            var fieldsToRemove = [],
                removedFKProperties;

            // Remove foreignKey and includeFrom field references to target
            var fields = defaults.fields;
            for (var i = 0; i < fields.length; i++) {
                var field = fields[i];
                if (field.foreignKey) {
                    var name = field.foreignKey;
                    if (name.indexOf(".") >= 0) name = name.split(".")[0];
                    if (name == targetDSId) {
                        if (removeFKField) {
                            fieldsToRemove.add(field);
                        } else {
                            delete field.foreignKey;
                            delete field.foreignDisplayField;
                            delete field.useLocalDisplayFieldValue;
                            delete field.joinType;
                            removedFKProperties = true;
                        }
                    }
                }
                if (field.includeFrom) {
                    var name = field.includeFrom,
                        split = name.split(".")
                    ;
                    if (split && split.length >= 2) {
                        name = split[split.length-2];
                    }
                    if (name == targetDSId) {
                        fieldsToRemove.add(field);
                    }
                }
            }
            // Shouldn't occur but if no field was removed we are done
            if (fieldsToRemove.length == 0) {
                callback();
                return;
            }

            fields.removeList(fieldsToRemove);
            self.saveDataSource(defaults, callback);
        });
    },

    buildRelations : function () {
        if (this._rawRelations) return;

        var dsList = this.dataSources || [],
            rawRelations = {}
        ;
        // build map of all known DataSources and FK relations
        var self = this;
        dsList.map(function (ds) {
            if (!ds) return;
            var fkFields = self.getForeignKeyFields(ds);
            if (!isc.isAn.emptyObject(fkFields)) {
                for (var fieldName in fkFields) {
                    var field = fkFields[fieldName],
                        fieldTitle = (field.title && field.title != isc.DS.getAutoTitle(fieldName) ? field.title : null),
                        relatedFieldName = isc.DS.getForeignFieldName(field),
                        relatedDS = isc.DS.getForeignDSName(field, ds)
                    ;
                    if (!rawRelations[ds.ID]) rawRelations[ds.ID] = [];
                    rawRelations[ds.ID].add({
                        fieldName: fieldName,
                        fieldTitle: fieldTitle,
                        foreignKey: field.foreignKey,
                        relatedDS: (relatedDS ? relatedDS : null),
                        relatedFieldName: relatedFieldName,
                        displayField: field.displayField,
                        joinType: field.joinType
                    });
                }
            }
        });

        this._rawRelations = rawRelations;
    },

    getForeignKeyFields : function (ds) {
        var fields = ds.fields,
            foreignKeyFields = {}
        ;
        for (var fieldName in fields) {
            var field = fields[fieldName];
            if (field.foreignKey) {
                foreignKeyFields[field.name] = field;
            }
        }
        return foreignKeyFields;
    },

    getDataSourceDefaults : function (dsName, callback) {
        isc.DataSourceEditor.fetchDataSourceDefaults(this.dsDataSource, dsName, callback);
    },

    saveDataSource : function (defaults, callback) {
        // handle custom subclasses of DataSource for which there is no schema defined by
        // serializing based on the DataSource schema but adding the _constructor property to
        // get the correct class.
        // XXX problem: if you ask an instance to serialize itself, and there is no schema for
        // it's specific class, it uses the superClass schema but loses it's Constructor
        // XXX we to preserve the class, we need to end up with the "constructor" property set
        // in XML, but this has special semantics in JS
        var dsClass = defaults._constructor || "DataSource",
            schema;
        if (isc.DS.isRegistered(dsClass)) {
            schema = isc.DS.get(dsClass);
        } else {
            schema = isc.DS.get("DataSource");
            defaults._constructor = dsClass;
        }

        // serialize to XML and save to server
        var xml = schema.xmlSerialize(defaults);
        // this.logWarn("saving DS with XML: " + xml);

        this.dsDataSource.saveFile({
            fileName: defaults.ID,
            fileType: "ds",
            fileFormat: "xml"
        }, xml, function() {
            callback();
        }, {
            // DataSources are always shared across users - check for existing file to
            // overwrite without regard to ownerId
            operationId: "allOwners"
        });
    },

    createLiveInstance : function (defaults) {
        // Create a new live instance with changes applied
        var dsClass = defaults._constructor || "DataSource";
        isc.ClassFactory.getClass(dsClass).create(defaults, {
            sourceDataSourceID: this.dsDataSource.ID
        });
    }

    
});
