/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.dataintegration.java.sql;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridEditEvent;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class MultipleForeignKeySample extends ShowcasePanel {

    private static final String DESCRIPTION =
            "A DataSource is sometimes related to multiple other DataSources via the same field, for example "+
            "a \"moneyTransfer\" DataSource may be related to \"receipt\" and \"invoice\" DataSources joined via the "+
            "\"id\" field in the \"moneyTransfer\" DataSource."+
            "<p>"+
            "In order to use <code>includeFrom</code> feature to include fields from both \"receipt\" and \"invoice\" "+
            "related DataSources you need to use regular <code>foreignKey</code> property together with additional "+
            "<code>otherFKs</code> property to specify all the foreign keys involved."+
            "<p>"+
            "Note this is a simple example showcasing general usage, it is possible to achieve same result by just "+
            "declaring foreign keys on the \"other-side\", i.e. in \"receipt\" and \"invoice\" DataSources. "+
            "<code>otherFKs</code> feature is meant to use in more complex scenarios, especially in combination with "+
            "<code>includeVia</code> feature showcased in <code>Multiple Field Include</code> example.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            MultipleForeignKeySample panel = new MultipleForeignKeySample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

        ListGrid moneyTransferList = new ListGrid();
        moneyTransferList.setDataSource(DataSource.get("moneyTransferFK"));
        moneyTransferList.setWidth(700);
        moneyTransferList.setHeight(224);
        moneyTransferList.setShowFilterEditor(true);
        moneyTransferList.setAutoFetchData(true);
        moneyTransferList.setDataPageSize(50);
        moneyTransferList.setCanEdit(true);
        moneyTransferList.setEditEvent(ListGridEditEvent.CLICK);
        moneyTransferList.setCanRemoveRecords(true);
            
        ListGridField nameField = new ListGridField("name", 200);
        ListGridField paymentAmountField = new ListGridField("paymentAmount", 150);
        paymentAmountField.setType(ListGridFieldType.FLOAT);
        ListGridField receiptInfoField = new ListGridField("receiptInfo");
        ListGridField invoiceInfoField = new ListGridField("invoiceInfo");
            
        moneyTransferList.setFields(nameField, paymentAmountField, receiptInfoField, invoiceInfoField);

        return moneyTransferList;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

}