/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRInputStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRReaderStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenRewriteStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.internal.oxm.record.json.JSONLexer;
import org.eclipse.persistence.internal.oxm.record.json.JSONParser;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSONReader
extends XMLReaderAdapter {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private Properties properties;
    private String attributePrefix = null;
    private NamespaceResolver namespaces = null;
    private boolean includeRoot;
    private String textWrapper;
    private Class unmarshalClass;
    private JSONAttributes attributes = new JSONAttributes();

    public JSONReader(String attrPrefix, NamespaceResolver nr, boolean namespaceAware, boolean includeRoot, Character namespaceSeparator, ErrorHandler errorHandler, String textWrapper) {
        this(attrPrefix, nr, namespaceAware, includeRoot, namespaceSeparator, errorHandler, textWrapper, null);
    }

    public JSONReader(String attrPrefix, NamespaceResolver nr, boolean namespaceAware, boolean includeRoot, Character namespaceSeparator, ErrorHandler errorHandler, String textWrapper, Class unmarshalClass) {
        this.attributePrefix = attrPrefix;
        if (this.attributePrefix == "") {
            this.attributePrefix = null;
        }
        this.namespaces = nr;
        this.namespaceAware = namespaceAware;
        this.namespaceSeparator = namespaceSeparator == null ? (char)46 : namespaceSeparator.charValue();
        this.includeRoot = includeRoot;
        this.setErrorHandler(errorHandler);
        this.textWrapper = textWrapper;
        this.unmarshalClass = unmarshalClass;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            ANTLRReaderStream charStream;
            InputStream inputStream = null;
            if (input.getByteStream() != null) {
                charStream = new ANTLRInputStream(input.getByteStream());
            } else if (input.getCharacterStream() != null) {
                charStream = new ANTLRReaderStream(input.getCharacterStream());
            } else {
                try {
                    URL url = new URL(input.getSystemId());
                    inputStream = url.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        inputStream = new FileInputStream(input.getSystemId());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw malformedURLException;
                    }
                }
                charStream = new ANTLRInputStream(inputStream);
            }
            JSONLexer lexer = new JSONLexer(charStream);
            TokenRewriteStream tokens = new TokenRewriteStream(lexer);
            ExtendedJSONParser parser = new ExtendedJSONParser(tokens, input, this.getErrorHandler());
            CommonTree commonTree = (CommonTree)parser.message().getTree();
            this.parseRoot(commonTree);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (RecognitionException e) {
            SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), input.getPublicId(), input.getSystemId(), e.line, e.index, e);
            this.getErrorHandler().fatalError(saxParseException);
        }
        catch (SAXExceptionWrapper e) {
            throw e.getCause();
        }
    }

    @Override
    public void parse(String systemId) {
        try {
            this.parse(new InputSource(systemId));
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    private void parseRoot(Tree tree) throws SAXException {
        if (this.namespaces != null) {
            Map<String, String> namespacePairs = this.namespaces.getPrefixesToNamespaces();
            for (String nextKey : namespacePairs.keySet()) {
                this.contentHandler.startPrefixMapping(nextKey, namespacePairs.get(nextKey));
            }
        }
        if (tree.getType() == 16) {
            this.contentHandler.startDocument();
            int children = tree.getChildCount();
            if (children == 0 && this.unmarshalClass == null) {
                return;
            }
            if (this.includeRoot) {
                this.parse((CommonTree)tree.getChild(0));
            } else {
                this.contentHandler.startElement("", "", null, this.attributes.setTree(tree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                int x = 0;
                int size = children;
                while (x < size) {
                    this.parse((CommonTree)tree.getChild(x));
                    ++x;
                }
                this.contentHandler.endElement("", "", null);
            }
            this.contentHandler.endDocument();
        } else if (tree.getType() == 4) {
            SAXUnmarshallerHandler rootContentHandler = null;
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                rootContentHandler = (SAXUnmarshallerHandler)this.getContentHandler();
            }
            int size = tree.getChildCount();
            ArrayList<Object> list = new ArrayList<Object>(size);
            int x = 0;
            while (x < size) {
                this.parseRoot(tree.getChild(x));
                if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = (SAXUnmarshallerHandler)this.contentHandler;
                    list.add(saxUnmarshallerHandler.getObject());
                    saxUnmarshallerHandler.setObject(null);
                } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                    UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.contentHandler;
                    Object unmarshalledObject = unmarshalRecord.getCurrentObject();
                    if (this.includeRoot && this.unmarshalClass != null && !(unmarshalledObject instanceof XMLRoot)) {
                        XMLRoot xmlRoot = new XMLRoot();
                        xmlRoot.setNamespaceURI(unmarshalRecord.getRootElementNamespaceUri());
                        xmlRoot.setLocalName(unmarshalRecord.getLocalName());
                        xmlRoot.setObject(unmarshalledObject);
                        unmarshalledObject = xmlRoot;
                    }
                    list.add(unmarshalledObject);
                    unmarshalRecord.setCurrentObject(null);
                    unmarshalRecord.setRootElementName(null);
                    unmarshalRecord.setLocalName(null);
                }
                ++x;
            }
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                ((SAXUnmarshallerHandler)this.getContentHandler()).setObject(list);
            } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                ((UnmarshalRecord)this.getContentHandler()).setCurrentObject(list);
                ((UnmarshalRecord)this.getContentHandler()).setRootElementName("");
                ((UnmarshalRecord)this.getContentHandler()).setLocalName("");
                if (rootContentHandler != null) {
                    rootContentHandler.setObject(list);
                }
            }
        }
    }

    private void parse(Tree tree) throws SAXException {
        if (tree == null) {
            return;
        }
        switch (tree.getType()) {
            case 17: {
                String qualifiedName;
                Tree valueTree = tree.getChild(1);
                if (valueTree.getType() == 4) {
                    this.parse(valueTree);
                    break;
                }
                Tree stringTree = tree.getChild(0);
                String localName = qualifiedName = stringTree.getText().substring(1, stringTree.getText().length() - 1);
                if (this.attributePrefix != null && qualifiedName.startsWith(this.attributePrefix)) break;
                String uri = "";
                if (this.namespaceAware && this.namespaces != null) {
                    int nsIndex = localName.indexOf(this.namespaceSeparator);
                    if (nsIndex > -1) {
                        String prefix = localName.substring(0, nsIndex);
                        localName = localName.substring(nsIndex + 1);
                        uri = this.namespaces.resolveNamespacePrefix(prefix);
                    }
                    if (localName.equals("type") && uri.equals("http://www.w3.org/2001/XMLSchema-instance")) break;
                }
                if (this.contentHandler instanceof XMLRootRecord || this.contentHandler instanceof DeferredContentHandler) {
                    if (!this.namespaceAware && localName.equals("type")) break;
                    if (this.textWrapper != null && this.textWrapper.equals(localName)) {
                        this.parse(valueTree);
                        break;
                    }
                } else if (this.contentHandler instanceof UnmarshalRecord && ((UnmarshalRecord)this.contentHandler).getXPathNode() != null) {
                    if (!this.namespaceAware && localName.equals("type") && !((UnmarshalRecord)this.contentHandler).getXPathNode().hasTypeChild()) break;
                    boolean isTextValue = this.isTextValue(localName);
                    if (isTextValue) {
                        this.parse(valueTree);
                        break;
                    }
                }
                this.contentHandler.startElement(uri, localName, localName, this.attributes.setTree(valueTree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                this.parse(valueTree);
                this.contentHandler.endElement(uri, localName, localName);
                break;
            }
            case 18: {
                String string = JSONReader.string(tree.getChild(0).getText());
                this.contentHandler.characters(string);
                break;
            }
            case 14: {
                this.contentHandler.characters(tree.getChild(0).getText());
                break;
            }
            case 20: {
                this.contentHandler.characters(TRUE);
                break;
            }
            case 9: {
                this.contentHandler.characters(FALSE);
                break;
            }
            case 13: {
                break;
            }
            case 4: {
                UnmarshalRecord ur;
                XPathNode node;
                int nsIndex;
                Tree parentStringTree = tree.getParent().getChild(0);
                String parentLocalName = parentStringTree.getText().substring(1, parentStringTree.getText().length() - 1);
                if (this.attributePrefix != null && parentLocalName.startsWith(this.attributePrefix)) break;
                String uri = "";
                if (this.namespaceAware && this.namespaces != null && (nsIndex = parentLocalName.indexOf(this.namespaceSeparator)) > -1) {
                    String prefix = parentLocalName.substring(0, nsIndex);
                    parentLocalName = parentLocalName.substring(nsIndex + 1);
                    uri = this.namespaces.resolveNamespacePrefix(prefix);
                }
                boolean isTextValue = this.isTextValue(parentLocalName);
                int size = tree.getChildCount();
                if (size == 0 && this.contentHandler instanceof UnmarshalRecord && (node = (ur = (UnmarshalRecord)this.contentHandler).getNonAttributeXPathNode(uri, parentLocalName, parentLocalName, null)) != null) {
                    NodeValue nv = node.getNodeValue();
                    if (nv == null && node.getTextNode() != null) {
                        nv = node.getTextNode().getUnmarshalNodeValue();
                    }
                    if (nv != null && nv.isContainerValue()) {
                        ur.getContainerInstance((ContainerValue)((Object)nv));
                    }
                }
                int x = 0;
                while (x < size) {
                    CommonTree nextChildTree = (CommonTree)tree.getChild(x);
                    if (!isTextValue) {
                        this.contentHandler.startElement(uri, parentLocalName, parentLocalName, this.attributes.setTree(nextChildTree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                    }
                    this.parse(nextChildTree);
                    if (!isTextValue) {
                        this.contentHandler.endElement(uri, parentLocalName, parentLocalName);
                    }
                    ++x;
                }
                break;
            }
            default: {
                int x = 0;
                int size = tree.getChildCount();
                while (x < size) {
                    this.parse((CommonTree)tree.getChild(x));
                    ++x;
                }
                break block0;
            }
        }
    }

    private boolean isTextValue(String localName) {
        XPathNode currentNode = ((UnmarshalRecord)this.contentHandler).getXPathNode();
        if (currentNode == null) {
            return this.textWrapper != null && this.textWrapper.equals(localName);
        }
        return (currentNode.getNonAttributeChildrenMap() == null || currentNode.getNonAttributeChildrenMap().size() == 0 || currentNode.getNonAttributeChildrenMap().size() == 1 && currentNode.getTextNode() != null) && this.textWrapper != null && this.textWrapper.equals(localName);
    }

    private static String string(String string) {
        String subString;
        string = string.substring(1, string.length() - 1);
        string = string.replace("\r\n", "\n");
        String returnString = "";
        int slashIndex = string.indexOf(92);
        if (slashIndex == -1) {
            return string;
        }
        int position = 0;
        while (slashIndex > -1) {
            subString = string.substring(position, slashIndex);
            returnString = String.valueOf(returnString) + subString;
            position = slashIndex;
            char nextChar = string.charAt(slashIndex + 1);
            switch (nextChar) {
                case 'b': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\b';
                    break;
                }
                case 'r': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\r';
                    break;
                }
                case 'f': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\f';
                    break;
                }
                case 'n': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\n';
                    break;
                }
                case 't': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\t';
                    break;
                }
                case '\"': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\"';
                    break;
                }
                case '\\': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\\';
                    break;
                }
                case '/': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '/';
                    break;
                }
                case 'u': {
                    position += 6;
                    String hexValue = string.substring(slashIndex + 2, slashIndex + 6);
                    returnString = String.valueOf(returnString) + Character.toString((char)Integer.parseInt(hexValue, 16));
                }
            }
            slashIndex = string.indexOf(92, position);
        }
        if (position < string.length()) {
            subString = string.substring(position, string.length());
            returnString = String.valueOf(returnString) + subString;
        }
        return returnString;
    }

    @Override
    public Object convertValueBasedOnSchemaType(XMLField xmlField, Object value, XMLConversionManager xmlConversionManager, XMLRecord record) {
        if (xmlField.getSchemaType() != null) {
            if (XMLConstants.QNAME_QNAME.equals(xmlField.getSchemaType())) {
                String stringValue = (String)value;
                int indexOpen = stringValue.indexOf(123);
                int indexClose = stringValue.indexOf(125);
                String uri = null;
                String localName = null;
                if (indexOpen > -1 && indexClose > -1) {
                    uri = stringValue.substring(indexOpen + 1, indexClose);
                    localName = stringValue.substring(indexClose + 1);
                } else {
                    localName = stringValue;
                }
                if (uri != null) {
                    return new QName(uri, localName);
                }
                return new QName(localName);
            }
            Class fieldType = xmlField.getType();
            if (fieldType == null) {
                fieldType = xmlField.getJavaClass(xmlField.getSchemaType());
            }
            return xmlConversionManager.convertObject(value, fieldType, xmlField.getSchemaType());
        }
        return value;
    }

    private static class ExtendedJSONParser
    extends JSONParser {
        private InputSource inputSource;
        private ErrorHandler errorHandler;

        public ExtendedJSONParser(TokenStream input, InputSource inputSource, ErrorHandler errorHandler) {
            super(input);
            this.inputSource = inputSource;
            this.errorHandler = errorHandler;
        }

        @Override
        public void displayRecognitionError(String[] tokenNames, RecognitionException re) {
            super.displayRecognitionError(tokenNames, re);
            SAXParseException saxParseException = new SAXParseException(re.getLocalizedMessage(), this.inputSource.getPublicId(), this.inputSource.getSystemId(), re.line, re.index, re);
            try {
                this.errorHandler.fatalError(saxParseException);
            }
            catch (SAXException e) {
                throw new SAXExceptionWrapper(e);
            }
        }
    }

    private static class JSONAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private Tree tree;
        private String attributePrefix;
        private char namespaceSeparator;
        private NamespaceResolver namespaces;
        private boolean namespaceAware;

        private JSONAttributes() {
        }

        public JSONAttributes setTree(Tree tree, String attributePrefix, NamespaceResolver nr, char namespaceSeparator, boolean namespaceAware) {
            this.reset();
            this.tree = tree;
            this.attributePrefix = attributePrefix;
            this.namespaces = nr;
            this.namespaceSeparator = namespaceSeparator;
            this.namespaceAware = namespaceAware;
            return this;
        }

        private void addSimpleAttribute(List attributes, String uri, String attributeLocalName, Tree childValueTree) {
            switch (childValueTree.getType()) {
                case 18: {
                    String stringValue = JSONReader.string(childValueTree.getChild(0).getText());
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, stringValue));
                    break;
                }
                case 14: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, childValueTree.getChild(0).getText()));
                    break;
                }
                case 20: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JSONReader.TRUE));
                    break;
                }
                case 9: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JSONReader.FALSE));
                    break;
                }
                case 13: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
                }
            }
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (localName == null) {
                return -1;
            }
            int index = 0;
            XMLReaderAdapter.Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLReaderAdapter.Attribute attribute = attributeArray[n2];
                if (this.namespaceAware) {
                    new QName(uri, localName);
                    if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                        return index;
                    }
                } else if (attribute.getName().equals(localName)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                if (this.tree.getType() == 13) {
                    this.attributes = new XMLReaderAdapter.Attribute[1];
                    this.attributes[0] = new XMLReaderAdapter.Attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "nil", JSONReader.TRUE);
                    return this.attributes;
                }
                if (this.tree.getType() == 16) {
                    ArrayList<XMLReaderAdapter.Attribute> attributesList = new ArrayList<XMLReaderAdapter.Attribute>(this.tree.getChildCount());
                    int x = 0;
                    while (x < this.tree.getChildCount()) {
                        Tree childValueTree;
                        int nsIndex;
                        Tree childTree = this.tree.getChild(x);
                        String attributeLocalName = childTree.getChild(0).getText().substring(1, childTree.getChild(0).getText().length() - 1);
                        if (this.attributePrefix != null) {
                            if (!attributeLocalName.startsWith(this.attributePrefix)) break;
                            attributeLocalName = attributeLocalName.substring(this.attributePrefix.length());
                        }
                        String uri = "";
                        if (this.namespaceAware && this.namespaces != null && (nsIndex = attributeLocalName.indexOf(this.namespaceSeparator)) > -1) {
                            String prefix = attributeLocalName.substring(0, nsIndex);
                            attributeLocalName = attributeLocalName.substring(nsIndex + 1);
                            uri = this.namespaces.resolveNamespacePrefix(prefix);
                        }
                        if ((childValueTree = childTree.getChild(1)).getType() == 4) {
                            int size = childValueTree.getChildCount();
                            if (size == 0) {
                                attributesList.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
                            }
                            int y = 0;
                            while (y < size) {
                                CommonTree nextChildTree = (CommonTree)childValueTree.getChild(y);
                                this.addSimpleAttribute(attributesList, uri, attributeLocalName, nextChildTree);
                                ++y;
                            }
                        } else {
                            this.addSimpleAttribute(attributesList, uri, attributeLocalName, childValueTree);
                        }
                        ++x;
                    }
                    this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                } else {
                    this.attributes = NO_ATTRIBUTES;
                }
            }
            return this.attributes;
        }
    }

    private static class SAXExceptionWrapper
    extends RuntimeException {
        SAXExceptionWrapper(SAXException e) {
            super(e);
        }

        @Override
        public SAXException getCause() {
            return (SAXException)super.getCause();
        }
    }
}

