/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.DataImport;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUpload
extends Base {
    private static Logger log = new Logger(BatchUpload.class.getName());
    private static final int STATUS_EXCEL_FILE_DETECTED = -6;
    private boolean checkURL = false;
    private DSRequest dsRequest = null;
    private DataImport dataImport = null;

    public DSResponse batchUpload(DSRequest dsRequest) throws Exception {
        return this.uploadData(dsRequest);
    }

    public static DSResponse internalBatchUpload(DSRequest dsRequest, boolean checkURL) throws Exception {
        BatchUpload bu = new BatchUpload();
        bu.checkURL = checkURL;
        return bu.uploadData(dsRequest);
    }

    private DSResponse uploadData(DSRequest dsRequest) throws Exception {
        DSResponse response = this.parseUploadData(dsRequest);
        Map respData = response.getDataMap();
        if (respData.containsKey("errorMessage")) {
            return response;
        }
        return this.validateUploadData(response);
    }

    public DSResponse parseUploadData(DSRequest dsRequest) throws Exception {
        int errorOffset;
        String errorCode;
        String errorMessage;
        List rows;
        InputStream is;
        boolean fileIsExcel;
        DataSource ds;
        block27: {
            String quoteString;
            this.dsRequest = dsRequest;
            this.dataImport = null;
            Map values = dsRequest.getValues();
            String dsName = (String)values.get("dsName");
            ds = DataSourceManager.getDataSource((String)dsName, (DSRequest)dsRequest);
            if (ds == null) {
                throw new Exception("Unable to find dataSource: " + dsName);
            }
            String delimiter = (String)values.get("delimiter");
            if (delimiter == null) {
                delimiter = ",";
            }
            if ((quoteString = (String)values.get("quoteString")) == null) {
                quoteString = "\"";
            }
            String dataFormat = (String)values.get("dataFormat");
            DataImport.ImportFormat importFormat = DataImport.ImportFormat.CSV;
            if (dataFormat != null) {
                try {
                    importFormat = DataImport.ImportFormat.valueOf(dataFormat.toUpperCase());
                }
                catch (Exception e) {
                    log.warn((Object)("Wrong ImportFormat: '" + dataFormat + "', csv will be used."), (Throwable)e);
                }
            }
            this.dataImport = new DataImport(importFormat, delimiter, quoteString);
            this.dataImport.setCrashIfTranslationFails(false);
            this.dataImport.setPopulateDisplayFields(true);
            this.dataImport.setAutoInterpretBooleans(DataTools.getBoolean((Map)values, (Object)"autoInterpretBooleans", (boolean)true));
            String encoding = (String)values.get("encoding");
            if (encoding == null) {
                encoding = dsRequest.getHttpServletRequest().getCharacterEncoding();
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            fileIsExcel = false;
            String fileName = (String)values.get("file");
            is = null;
            if (fileName != null && (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx"))) {
                fileIsExcel = true;
            } else if (values.containsKey("file")) {
                is = dsRequest.getUploadedFileStream("file");
            } else if (values.containsKey("pasteData")) {
                String pasteData = (String)values.get("pasteData");
                is = new ByteArrayInputStream(pasteData.getBytes(encoding));
            } else if (values.containsKey("fileURL")) {
                if (!this.checkURL) {
                    throw new Exception("URL based retrieval of files is insecure operation and it is disabled.");
                }
                URL url = new URL((String)values.get("fileURL"));
                is = url.openStream();
            } else if (values.containsKey("fileName")) {
                if (!this.checkURL) {
                    throw new Exception("References to files under webroot is insecure operation and it is disabled.");
                }
                String webRoot = config.getPath("webRoot");
                is = new FileInputStream(webRoot + (String)values.get("fileName"));
            }
            rows = new ArrayList();
            errorMessage = null;
            errorCode = null;
            errorOffset = 0;
            try {
                if (is != null) {
                    rows = this.dataImport.importDSRows(new InputStreamReader(is, encoding), ds, importFormat, delimiter, dsRequest);
                }
            }
            catch (Throwable e) {
                log.error((Object)"An exception occurred during the uploading process", e);
                String[] errors = e.getMessage().split(":ErrorCode:");
                errorMessage = errors[0];
                String string = errorCode = errors.length == 2 ? errors[1] : null;
                if (!(e instanceof ParseException)) break block27;
                errorOffset = ((ParseException)e).getErrorOffset();
            }
        }
        if (is != null) {
            is.close();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        log.debug((Object)("Rows: " + DataTools.prettyPrint(rows)));
        data.put("gridRows", rows);
        data.put("discardedColumns", this.dataImport.getDiscardedColumns());
        DSResponse dsResponse = new DSResponse(ds);
        if (this.dataImport.getErrors().size() > 0) {
            data.put("errorMapOfRowsNotParsed", this.dataImport.getErrors());
        }
        if (errorMessage != null) {
            data.put("errorMessage", errorMessage);
            dsResponse.setProperty("batchUploadErrorCode", (Object)errorCode);
            dsResponse.setProperty("batchUploadErrorOffset", (Object)errorOffset);
        } else if (fileIsExcel) {
            data.put("errorMessage", "Excel file detected");
            dsResponse.setProperty("batchUploadErrorCode", (Object)-6);
        }
        dsResponse.setData(data);
        return dsResponse;
    }

    public DSResponse validateUploadData(DSResponse dsResponse) throws Exception {
        if (dsResponse == null || this.dsRequest == null || this.dataImport == null) {
            throw new Exception("Cannot proceed without a DSRequest, call parseUploadData(dsRequest) first.");
        }
        Map data = dsResponse.getDataMap();
        if (data.get("errorMessage") != null) {
            log.warn((Object)"Provided DSResponse has critical parsing error, validation will be skipped.");
            return dsResponse;
        }
        this.dataImport.validateDSRows(DataTools.makeListIfSingle(data.get("gridRows")), dsResponse.getDataSource(), this.dsRequest);
        log.debug((Object)("Errors: " + DataTools.prettyPrint(this.dataImport.getValidationErrors())));
        List errors = BatchUpload.toBatchUploaderErrorForm(this.dataImport.getValidationErrors());
        log.debug((Object)("Errors after conversion: " + DataTools.prettyPrint((Object)errors)));
        if (errors.size() != 0) {
            data.put("errors", errors);
        }
        dsResponse.setData((Object)data);
        return dsResponse;
    }

    private static List toBatchUploaderErrorForm(List errors) {
        ArrayList<ErrorReport> converted = new ArrayList<ErrorReport>();
        if (errors == null) {
            return converted;
        }
        HashMap collected = new HashMap();
        for (int i = 0; i < errors.size(); ++i) {
            HashMap inner;
            Map error = (Map)errors.get(i);
            ErrorReport errorReport = null;
            boolean newReport = true;
            for (ErrorReport seen : converted) {
                if (seen.get((Object)"rowNum") != error.get("rowNum")) continue;
                errorReport = seen;
                newReport = false;
                break;
            }
            if (errorReport == null) {
                errorReport = new ErrorReport();
            }
            if ((inner = (HashMap)errorReport.get((Object)"errors")) == null) {
                inner = new HashMap();
            }
            for (String errorField : error.keySet()) {
                if ("recordPath".equals(errorField) || "rowNum".equals(errorField)) continue;
                ArrayList errorList = null;
                if (error.get(errorField) instanceof Map) {
                    errorList = DataTools.makeListIfSingle(((Map)error.get(errorField)).get("errorMessage"));
                } else if (error.get(errorField) instanceof List) {
                    List from = (List)error.get(errorField);
                    ArrayList to = new ArrayList();
                    for (int j = 0; j < from.size(); ++j) {
                        to.add(((Map)from.get(j)).get("errorMessage"));
                    }
                    errorList = to;
                } else {
                    log.warn((Object)"Encountered an errorMessage structure that is not a List or a Map");
                }
                errorList.addAll(DataTools.makeListIfSingle(inner.get(errorField)));
                errorList = DataTools.removeDuplicates((List)errorList);
                inner.put(errorField, errorList);
            }
            if (!newReport) continue;
            errorReport.put((Object)"errors", inner);
            errorReport.put((Object)"rowNum", error.get("rowNum"));
            converted.add(errorReport);
        }
        return converted;
    }

    public DSResponse wipeData(DSRequest dsRequest) throws Exception {
        Map values = dsRequest.getValues();
        dsRequest.setOperationType("remove");
        String dsName = (String)values.get("dsName");
        dsRequest.setAllowMultiUpdate(true);
        DataSource ds = DataSourceManager.getDataSource((String)dsName, (DSRequest)dsRequest);
        ds.remove(new HashMap());
        dsRequest.setDataSource(ds);
        return dsRequest.execute();
    }
}

