/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;

public class Charset
implements SchemaObject {
    public static final int[][] uppercaseLetters = new int[][]{{65, 90}};
    public static final int[][] unquotedIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}};
    public static final int[][] basicIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}, {97, 122}};
    public static final Charset SQL_TEXT;
    public static final Charset SQL_IDENTIFIER_CHARSET;
    public static final Charset SQL_CHARACTER;
    public static final Charset ASCII_GRAPHIC;
    public static final Charset GRAPHIC_IRV;
    public static final Charset ASCII_FULL;
    public static final Charset ISO8BIT;
    public static final Charset LATIN1;
    public static final Charset UTF32;
    public static final Charset UTF16;
    public static final Charset UTF8;
    final HsqlNameManager.HsqlName name;
    public final HsqlNameManager.HsqlName base;
    int[][] ranges;

    private Charset(HsqlNameManager.HsqlName hsqlName) {
        this.name = hsqlName;
        this.base = null;
    }

    public Charset(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.name = hsqlName;
        this.base = hsqlName2;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.base != null) {
            orderedHashSet.add(this.base);
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ').append("CHARACTER").append(' ').append("SET").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.name.schema.name)) {
            stringBuilder.append(this.name.getStatementName());
        } else {
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
        }
        if (this.base != null) {
            stringBuilder.append(' ').append("AS").append(' ').append("GET");
            stringBuilder.append(' ');
            if ("INFORMATION_SCHEMA".equals(this.base.schema.name)) {
                stringBuilder.append(this.base.getStatementName());
            } else {
                stringBuilder.append(this.base.getSchemaQualifiedStatementName());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public static boolean isInSet(String string, int[][] nArray) {
        int n = string.length();
        block0: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (c > nArray[j][1]) continue;
                if (c >= nArray[j][0]) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean startsWith(String string, int[][] nArray) {
        char c = string.charAt(0);
        for (int i = 0; i < nArray.length; ++i) {
            if (c > nArray[i][1]) continue;
            return c >= nArray[i][0];
        }
        return false;
    }

    public static Charset getDefaultInstance() {
        return SQL_TEXT;
    }

    static {
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_TEXT", false, 14);
        SQL_TEXT = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_IDENTIFIER", false, 14);
        SQL_IDENTIFIER_CHARSET = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("SQL_CHARACTER", false, 14);
        SQL_CHARACTER = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("LATIN1", false, 14);
        LATIN1 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ASCII_GRAPHIC", false, 14);
        ASCII_GRAPHIC = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("GRAPHIC_IRV", false, 14);
        GRAPHIC_IRV = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ASCII_FULL", false, 14);
        ASCII_FULL = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("ISO8BIT", false, 14);
        ISO8BIT = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF32", false, 14);
        UTF32 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF16", false, 14);
        UTF16 = new Charset(hsqlName);
        hsqlName = HsqlNameManager.newInfoSchemaObjectName("UTF8", false, 14);
        UTF8 = new Charset(hsqlName);
    }
}

