/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a request to AI to generate a summary of an individual value.
 */
@BeanFactory.FrameworkClass
public class SummarizeValueRequest extends DataBoundAIRequest {

    public static SummarizeValueRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SummarizeValueRequest) {
            existingObj.setJsObj(jsObj);
            return (SummarizeValueRequest)existingObj;
        } else

        {
            return new SummarizeValueRequest(jsObj);
        }
    }
        


    public SummarizeValueRequest(){
        
    }

    public SummarizeValueRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The natural language description of how to summarize the value, which may include a request for relevant supplemental
     * information. <p> Note: For more consistently-formatted AI-generated summaries of values, it is often helpful to specify
     * {@link com.smartgwt.client.ai.SummarizeValueRequest#getExamples examples} that include the desired output form.
     *
     * @param aiRequest New aiRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setAIRequest(SingleSourceAIRequest aiRequest) {
        return (SummarizeValueRequest)setAttribute("aiRequest", aiRequest == null ? null : aiRequest.getJsObj());
    }

    /**
     * The natural language description of how to summarize the value, which may include a request for relevant supplemental
     * information. <p> Note: For more consistently-formatted AI-generated summaries of values, it is often helpful to specify
     * {@link com.smartgwt.client.ai.SummarizeValueRequest#getExamples examples} that include the desired output form.
     *
     * @return Current aiRequest value. Default value is null
     */
    public SingleSourceAIRequest getAIRequest()  {
        return SingleSourceAIRequest.getOrCreateRef(getAttributeAsJavaScriptObject("aiRequest"));
    }
    

    /**
     * The source of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getAIRequest aiRequest}.
     *
     * @param aiRequestSource New aiRequestSource value. Default value is "system"
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setAIRequestSource(AIMessageSource aiRequestSource) {
        return (SummarizeValueRequest)setAttribute("aiRequestSource", aiRequestSource == null ? null : aiRequestSource.getValue());
    }

    /**
     * The source of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getAIRequest aiRequest}.
     *
     * @return Current aiRequestSource value. Default value is "system"
     */
    public AIMessageSource getAIRequestSource()  {
        return EnumUtil.getEnum(AIMessageSource.values(), getAttribute("aiRequestSource"));
    }
    

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} displaying the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}. <p> If {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getDataSource dataSource} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @param component New component value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setComponent(DataBoundComponent component) {
        return (SummarizeValueRequest)setAttribute("component", component == null ? null : ((Canvas)component).getOrCreateJsObj());
    }

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} displaying the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}. <p> If {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getDataSource dataSource} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @return Current component value. Default value is null
     */
    public DataBoundComponent getComponent()  {
        return (DataBoundComponent)Canvas.getByJSObject(getAttributeAsJavaScriptObject("component"));
    }
    

    /**
     * If specified, the {@link com.smartgwt.client.data.DataSource} where the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value} originated. <p> If {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setDataSource(DataSource dataSource) {
        return (SummarizeValueRequest)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj());
    }

    /**
     * If specified, the {@link com.smartgwt.client.data.DataSource} where the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value} originated. <p> If {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @return Current dataSource value. Default value is null
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }
    

    /**
     * If specified, examples to provide to AI. <p> Examples that include the desired output form often help to make the
     * formatting of AI-generated summaries of values more consistent.
     *
     * @param examples New examples value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setExamples(SummarizeValueExample... examples) {
        return (SummarizeValueRequest)setAttribute("examples", examples);
    }

    /**
     * If specified, examples to provide to AI. <p> Examples that include the desired output form often help to make the
     * formatting of AI-generated summaries of values more consistent.
     *
     * @return Current examples value. Default value is null
     */
    public SummarizeValueExample[] getExamples()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSummarizeValueExample(getAttributeAsJavaScriptObject("examples"));
    }
    

    /**
     * If specified, the name of the field containing the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @param fieldName New fieldName value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public SummarizeValueRequest setFieldName(String fieldName) {
        return (SummarizeValueRequest)setAttribute("fieldName", fieldName);
    }

    /**
     * If specified, the name of the field containing the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @return Current fieldName value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String getFieldName()  {
        return getAttributeAsString("fieldName");
    }
    

    /**
     * If specified, the {@link com.smartgwt.client.data.Record} containing the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}. <p> If supplying the record, then the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} and/or {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getDataSource dataSource} must be specified as well.
     *
     * @param record New record value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setRecord(Record record) {
        return (SummarizeValueRequest)setAttribute("record", record == null ? null : record.getJsObj());
    }

    /**
     * If specified, the {@link com.smartgwt.client.data.Record} containing the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}. <p> If supplying the record, then the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} and/or {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getDataSource dataSource} must be specified as well.
     *
     * @return Current record value. Default value is null
     */
    public Record getRecord()  {
        return Record.getOrCreateRef(getAttributeAsJavaScriptObject("record"));
    }
    

    /**
     * If specified, the names of the {@link com.smartgwt.client.data.DBCField}s of the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} (or {@link
     * com.smartgwt.client.data.DataSourceField}s of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getDataSource
     * dataSource}) that are relevant to the request to summarize the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @param relevantFieldNames New relevantFieldNames value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public SummarizeValueRequest setRelevantFieldNames(String... relevantFieldNames) {
        return (SummarizeValueRequest)setAttribute("relevantFieldNames", relevantFieldNames);
    }

    /**
     * If specified, the names of the {@link com.smartgwt.client.data.DBCField}s of the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getComponent component} (or {@link
     * com.smartgwt.client.data.DataSourceField}s of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getDataSource
     * dataSource}) that are relevant to the request to summarize the {@link
     * com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @return Current relevantFieldNames value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String[] getRelevantFieldNames()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("relevantFieldNames"));
    }
    

    /**
     * The value to summarize. Its type is specified by the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValueType
     * valueType}.
     *
     * @param value New value value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setValue(Object value) {
        return (SummarizeValueRequest)setAttribute("value", value);
    }

    /**
     * The value to summarize. Its type is specified by the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValueType
     * valueType}.
     *
     * @return Current value value. Default value is null
     */
    public Object getValue()  {
        return getAttributeAsObject("value");
    }
    

    /**
     * The type of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @param valueType New valueType value. Default value is "text"
     * @return {@link com.smartgwt.client.ai.SummarizeValueRequest SummarizeValueRequest} instance, for chaining setter calls
     */
    public SummarizeValueRequest setValueType(AIContentType valueType) {
        return (SummarizeValueRequest)setAttribute("valueType", valueType == null ? null : valueType.getValue());
    }

    /**
     * The type of the {@link com.smartgwt.client.ai.SummarizeValueRequest#getValue value}.
     *
     * @return Current valueType value. Default value is "text"
     */
    public AIContentType getValueType()  {
        return EnumUtil.getEnum(AIContentType.values(), getAttribute("valueType"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
