package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the timing strategy to be used for  {@link com.smartgwt.client.docs.CacheSynchronization automatic cache
 * synchronization}, for a given {@link com.smartgwt.client.data.DataSource#getCacheSyncTiming DataSource},  {@link
 * com.smartgwt.client.data.OperationBinding#getCacheSyncTiming OperationBinding} or  {@link
 * com.smartgwt.client.data.DSRequest#getCacheSyncTiming DSRequest}.  This property controls the "when" of cache 
 * synchronization; the "how" is controlled by {@link com.smartgwt.client.types.CacheSyncStrategy}. <P> <b>NOTE:</b>
 * <code>CacheSyncTiming</code> is intended to allow applications to defer cache synchronization to the point where
 * response data is actually requested; the primary aim of this is to avoid doing cache sync altogether in cases where the
 * response data is never requested.  There are some mainstream types of request where we know that the response data
 * unequivocally <i>is</i> required, and for these requests a global  default <code>CacheSyncTiming</code> will be
 * overridden to "immediate" by Smart GWT  because there is no point in deferring cache sync when we know for sure it will
 * eventually be needed.  Thus, cache sync will always run immediately regardless of the default
 * <code>cacheSyncTiming</code> setting in these cases:<ul> <li>Requests sent from a client</li> <li>Server-created
 * requests that copy an <code>RPCManager</code> across from a      client-originated request, either by specifying it in
 * the <code>DSRequest</code>     constructor, or by calling <code>dsRequest.setRPCManager()</code></li> </ul> <p> The
 * above only applies to the global default <code>cacheSyncTiming</code>: a  <code>cacheSyncTiming</code> set explicitly at
 * the {@link com.smartgwt.client.data.DataSource#getCacheSyncTiming DataSource}, {@link
 * com.smartgwt.client.data.OperationBinding#getCacheSyncTiming operation} or {@link
 * com.smartgwt.client.data.DSRequest#getCacheSyncTiming request} level will usually be honored.  However, even an explicit
 * <code>cacheSyncTiming</code>  setting on the DataSource, operation or request will be ignored in situations where it
 * could break a framework feature if we honored it.  These situations are: <ul> <li>Requests where {@link
 * com.smartgwt.client.docs.serverds.DataSource#audit automatic auditing} is in force</li> <li>Requests on a dataSource
 * with one-to-many or many-to-many relations, where the update     means that Smart GWT must update foreign keys on the
 * related dataSources to maintain     relation integrity</li> </ul> In both these cases, we cannot allow the cache sync to
 * be deferred because it is possible  that a deferred cache sync fetch would never be invoked - indeed, that is the whole
 * point  of allowing cache sync to be deferred - and in that case, key processes would fail to run. <P>
 */
public enum CacheSyncTiming implements ValueEnum {
    /**
     * Obtain cache sync values immediately after the update operation returns
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "immediate".
     */
    IMMEDIATE("immediate"),
    /**
     * Defer running cache sync until the first time <code>getData()</code> is called on the server-side
     * <code>DSResponse</code>. As described above, the point of deferring cache  sync is to avoid running it at all in cases
     * where nothing needs the response data (and thus nothing calls <code>getData()</code>). In addition to the above-listed
     * cases where we know that cache sync is <i>always</i> going to be required, there are other cases where
     * <code>getData()</code> will be called, even if your application code doesn't do so. Some  examples:<ul> <li>If logging
     * levels are set such that the framework is logging response data</li> <li>If you have a {@link
     * com.smartgwt.client.data.DataSourceField#getMultiple multiple} field in your dataSource and its  value requires
     * transformation because of {@link com.smartgwt.client.docs.serverds.DataSourceField#multipleStorage multipleStorage} or
     * {@link com.smartgwt.client.docs.serverds.DataSource#transformMultipleFields transformMultipleFields} settings</li> </ul>
     * In these cases, and others where the response data is required, the cache sync process will be deferred to later in the
     * process, but it will run.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "lazy".
     */
    LAZY("lazy");
    private String value;

    CacheSyncTiming(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
