/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.gwt.dev.util.Name;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.shared.JsonRpcProxy;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

class ProxyScanner
extends ScannerBase<Void> {
    private TypeElement checkedElement;

    ProxyScanner() {
    }

    @Override
    public Void visitExecutable(ExecutableElement x, State state) {
        if (this.shouldIgnore(x, state)) {
            return null;
        }
        ExecutableType xType = ProxyScanner.viewIn(this.checkedElement, x, state);
        if (this.isGetter(x, state)) {
            TypeMirror returnType = xType.getReturnType();
            if (!state.isTransportableType(returnType)) {
                state.poison(x, Messages.untransportableType(returnType));
            }
        } else if (!this.isSetter(x, state)) {
            state.poison(x, Messages.proxyOnlyGettersSetters());
        }
        int i = 0;
        for (TypeMirror typeMirror : xType.getParameterTypes()) {
            if (!state.isTransportableType(typeMirror)) {
                state.poison(x.getParameters().get(i), Messages.untransportableType(typeMirror));
            }
            ++i;
        }
        return null;
    }

    @Override
    public Void visitType(TypeElement x, State state) {
        this.checkedElement = x;
        ProxyFor proxyFor = x.getAnnotation(ProxyFor.class);
        ProxyForName proxyForName = x.getAnnotation(ProxyForName.class);
        JsonRpcProxy jsonRpcProxy = x.getAnnotation(JsonRpcProxy.class);
        if (proxyFor != null) {
            ProxyScanner.poisonIfAnnotationPresent(state, x, proxyForName, jsonRpcProxy);
            try {
                proxyFor.value();
                throw new RuntimeException("Should not reach here");
            }
            catch (MirroredTypeException expected) {
                TypeMirror type = expected.getTypeMirror();
                state.addMapping(x, (TypeElement)state.types.asElement(type));
            }
        }
        if (proxyForName != null) {
            ProxyScanner.poisonIfAnnotationPresent(state, x, jsonRpcProxy);
            TypeElement domain = state.elements.getTypeElement(Name.BinaryName.toSourceName(proxyForName.value()));
            if (domain == null) {
                state.warn(x, Messages.proxyMissingDomainType(proxyForName.value()));
            }
            state.addMapping(x, domain);
        }
        this.scanAllInheritedMethods(x, state);
        state.checkExtraTypes(x);
        return null;
    }

    @Override
    public Void visitVariable(VariableElement x, State state) {
        if (!state.isTransportableType(x.asType())) {
            state.poison(x, Messages.untransportableType(x.asType()));
        }
        return (Void)super.visitVariable(x, state);
    }

    @Override
    protected boolean shouldIgnore(ExecutableElement x, State state) {
        if (x.getSimpleName().contentEquals("stableId") && x.getParameters().isEmpty()) {
            return true;
        }
        return super.shouldIgnore(x, state);
    }
}

