
package com.smartgwt.client.docs;

/**
 * <h3>Dynamic Strings</h3>
 * A dynamic string is a simple but powerful template format. Its contents are treated literally,
 * except that the result of evaluating a JavaScript expression may be substituted into the string
 * using the syntax:<br> <code>&#36;{<i>[JavaScript to evaluate]</i>}</code> <p> To include the
 * literal string "<code>&#36;{</code>", place a backslash before it to escape. <p> To include a
 * backslash before the result of an evaluated expression, the backslash must be in the result of
 * an evaluated expression; either the subsequent evaluated expression may additionally output the
 * backslash or the backslash may be replaced by its own evaluated expression, such as:<br>
 * <code>&#36;{String.fromCharCode(92)}</code> <p> A separate context {@link
 * com.smartgwt.client.types.ValueMap} can be provided to make variables in-scope for the
 * evaluated expressions within the dynamic string. For instance, expressions within the {@link
 * com.smartgwt.client.widgets.Canvas#getContents Canvas.contents} string (when {@link
 * com.smartgwt.client.widgets.Canvas#getDynamicContents dynamicContents} is <code>true</code>)
 * can use values from the {@link com.smartgwt.client.widgets.Canvas#getDynamicContentsVars
 * Canvas.dynamicContentsVars} ValueMap. <p> <strong>Important:</strong> As with any
 * dynamically-evaluated content, never concatenate an untrusted or user-provided string into a
 * dynamic string, because malicious input could execute arbitrary logic or exfiltrate sensitive
 * data. "Escaping" an arbitrary, user-provided string for concatenation into a dynamic string is
 * complicated and inherently unsafe, as it depends on which characters will precede and follow
 * the escaped string. Rather than escaping, a better approach is to simply include the string via
 * an expression. For example, rather than something like:<br> <code>"DataSource " + dataSourceId
 * + " could not be loaded."</code><br> .. you can use an expression for the string that should be
 * added within, as with:<br> <code>"DataSource &#36;{dataSourceId} could not be loaded."</code> 
 * &nbsp;and adding a 'dataSourceId' mapping to the context ValueMap. <p> Note: If the resulting
 * string, after evaluating the dynamic string, will be used as HTML, then it is also important to
 * HTML-escape expression results (see String), or use trusted HTML as the results of expressions.
 * @see com.smartgwt.client.docs.DynamicString
 * @see com.smartgwt.client.ai.AI#sendPrompt
 * @see com.smartgwt.client.widgets.Canvas#getDynamicContents
 * @see com.smartgwt.client.widgets.HTMLFlow#getDynamicContents
 * @see com.smartgwt.client.widgets.Label#getDynamicContents
 */
public interface DynamicStrings {
}
