/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.interfaces;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.IInstanceSingleton;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InterfaceProvider {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(InterfaceProvider.class.getName());
    private static boolean failOnMissingInterface = config.getBoolean((Object)"InterfaceProvider.failOnMissingInterface", false);
    private static Map configCache = new DataTypeMap();
    private static Map instanceCache = new DataTypeMap();
    private static Map<String, Class> implCache = new HashMap<String, Class>();

    public static Object load(String interfaceName) throws Exception {
        Object instance = instanceCache.get(interfaceName);
        if (instance != null) {
            return ((IInstanceSingleton)instance).staticInstance();
        }
        DataTypeMap interfaceConfig = InterfaceProvider.configForInterface(interfaceName);
        if (interfaceConfig == null || interfaceConfig.size() == 0) {
            throw new Exception("Unable to look up interface configuration for interface '" + interfaceName + "'");
        }
        String implementer = interfaceConfig.getString("implementer");
        String module = interfaceConfig.getString("module");
        try {
            log.debug("Instantiating " + implementer + " to satisfy request for an " + interfaceName);
            instance = Reflection.instantiateClass(implementer);
            if (instance instanceof IInstanceSingleton) {
                instanceCache.put(interfaceName, instance);
                instance = ((IInstanceSingleton)instance).staticInstance();
            }
            return instance;
        }
        catch (Exception e) {
            List requiredModules = interfaceConfig.getList("requiresModules", new ArrayList());
            List requiredLibs = interfaceConfig.getList("requiresLibs", new ArrayList());
            if (!config.getBoolean((Object)"devenv", false)) {
                Iterator i = requiredLibs.iterator();
                while (i.hasNext()) {
                    String requiredLib = (String)i.next();
                    if (!requiredLib.startsWith("devenv/")) continue;
                    i.remove();
                }
            }
            ArrayList dependencyList = new ArrayList();
            dependencyList.addAll(requiredModules);
            dependencyList.addAll(requiredLibs);
            String dependencies = "";
            Iterator i = dependencyList.iterator();
            while (i.hasNext()) {
                dependencies = dependencies + i.next().toString() + ".jar";
                if (!i.hasNext()) continue;
                dependencies = dependencies + ", ";
            }
            log.error("Unable to instantiate class '" + implementer + "' - check to make sure you have " + module + ".jar" + (dependencies.equals("") ? "" : " (and its dependencies: " + dependencies + ")") + " in your CLASSPATH");
            throw e;
        }
    }

    public static boolean exists(String interfaceName) {
        return InterfaceProvider.exists(interfaceName, true);
    }

    public static boolean exists(String interfaceName, boolean exceptionIfMissing) {
        Class theClass;
        block10: {
            if (implCache.containsKey(interfaceName)) {
                return implCache.get(interfaceName) != null;
            }
            theClass = null;
            try {
                DataTypeMap interfaceConfig = InterfaceProvider.configForInterface(interfaceName);
                if (interfaceConfig == null) {
                    throw new Exception("Unable to look up interface configuration for interface '" + interfaceName + "'");
                }
                String implementer = interfaceConfig.getString("implementer");
                try {
                    theClass = Reflection.classForName(implementer);
                }
                catch (Exception e) {
                    String msg = "Failed to load implementer for interface '" + interfaceName + "'.  This will now be negative-cached to prevent future lookup attempts";
                    if (log.isDebugEnabled()) {
                        log.info((Object)msg, e);
                        break block10;
                    }
                    log.info(msg);
                }
            }
            catch (Throwable t) {
                String error = "Configuration error - cannot find provider for interface: " + interfaceName;
                if (exceptionIfMissing) {
                    log.warn((Object)error, t);
                } else {
                    log.warn("Warning - no provider found for interface: " + interfaceName);
                }
                if (failOnMissingInterface && exceptionIfMissing) {
                    throw new Error(error + " - " + t.toString());
                }
                return false;
            }
        }
        implCache.put(interfaceName, theClass);
        return theClass != null;
    }

    private static DataTypeMap configForInterface(String interfaceName) throws Exception {
        DataTypeMap interfaceConfig = (DataTypeMap)((Object)configCache.get(interfaceName));
        if (interfaceConfig == null) {
            interfaceConfig = config.getSubtree("interfaces." + interfaceName);
            configCache.put(interfaceName, interfaceConfig);
        }
        return interfaceConfig;
    }
}

