/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

public class CheckboxCell
extends AbstractEditableCell<Boolean, Boolean> {
    private static final SafeHtml INPUT_CHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\" checked/>");
    private static final SafeHtml INPUT_UNCHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\"/>");
    private final boolean dependsOnSelection;
    private final boolean handlesSelection;

    public CheckboxCell() {
        this(false);
    }

    @Deprecated
    public CheckboxCell(boolean isSelectBox) {
        this(isSelectBox, isSelectBox);
    }

    public CheckboxCell(boolean dependsOnSelection, boolean handlesSelection) {
        super("change", "keydown");
        this.dependsOnSelection = dependsOnSelection;
        this.handlesSelection = handlesSelection;
    }

    @Override
    public boolean dependsOnSelection() {
        return this.dependsOnSelection;
    }

    @Override
    public boolean handlesSelection() {
        return this.handlesSelection;
    }

    @Override
    public boolean isEditing(Cell.Context context, Element parent, Boolean value) {
        return false;
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, Boolean value, NativeEvent event, ValueUpdater<Boolean> valueUpdater) {
        boolean enterPressed;
        String type = event.getType();
        boolean bl = enterPressed = "keydown".equals(type) && event.getKeyCode() == 13;
        if ("change".equals(type) || enterPressed) {
            InputElement input = (InputElement)parent.getFirstChild().cast();
            Boolean isChecked = input.isChecked();
            if (enterPressed && (this.handlesSelection() || !this.dependsOnSelection())) {
                isChecked = isChecked == false;
                input.setChecked(isChecked);
            }
            if (value != isChecked && !this.dependsOnSelection()) {
                this.setViewData(context.getKey(), isChecked);
            } else {
                this.clearViewData(context.getKey());
            }
            if (valueUpdater != null) {
                valueUpdater.update(isChecked);
            }
        }
    }

    @Override
    public void render(Cell.Context context, Boolean value, SafeHtmlBuilder sb) {
        Object key = context.getKey();
        Boolean viewData = (Boolean)this.getViewData(key);
        if (viewData != null && viewData.equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        if (value != null && (viewData != null ? viewData : value).booleanValue()) {
            sb.append(INPUT_CHECKED);
        } else {
            sb.append(INPUT_UNCHECKED);
        }
    }
}

