/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.dataintegration.java.sql;

import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridEditEvent;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class AutoDeriveSQLSample extends ShowcasePanel {
    private static final String DESCRIPTION =
            "The SmartGWT autoDeriveSchema feature allows you to specify that your DataSource's schema (field " +
            "definitions) should be automatically derived from some kind of metadata.  In this example, we generate " +
            "field definitions from the underlying database table metadata, and augment that metadata with some of " +
            "our own." +
            "<p>" +
            "Note that 5 of the 6 fields defined on the ListGrid below required no entry in the ds.xml file, where " +
            "autoDeriveSchema is specified.  We defined the 6th (SALESREPEMPLOYEENUMBER) so that we could provide " +
            "the server with instructions for generating SQL Joins (e.g., foreignKey, joinType) and the client with " +
            "instructions for display of the result (displayField, title)." +
            "<p>" +
            "Double click on any row to edit, and try to make an update using illegal values.  Providing" +
            "text values for (integer) CUSTOMERNUMBER will yield the standard type validation error, and text input " +
            "for (varchar(15)) POSTALCODE is limited to 15 characters, as you'd expect.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            AutoDeriveSQLSample panel = new AutoDeriveSQLSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

        final ListGrid listGrid = new ListGrid();
        listGrid.setWidth(850);
        listGrid.setHeight(400);
        listGrid.setAutoFetchData(true);
        listGrid.setDataSource(DataSource.get("AutoDerivedCustomer"));
        listGrid.setInitialCriteria(new Criteria("COUNTRY", "USA"));
        listGrid.setCanEdit(true);
        listGrid.setCanRemoveRecords(true);
        // override titles in a few cases, to include a space where needed
        listGrid.setFields(
                new ListGridField("CUSTOMERNUMBER", "Customer Number"),
                new ListGridField("CUSTOMERNAME", "Customer Name"),
                new ListGridField("CITY"),
                new ListGridField("STATE"),
                new ListGridField("POSTALCODE", "Postal Code"),
                new ListGridField("salesRepEmployeeNumber")
        );

        return listGrid;
    }

    public String getIntro() {
        return DESCRIPTION;
    }
}