package com.smartgwt.sample.showcase.client.dataintegration.java.sortfilter;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.DataSource; 
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.sample.showcase.client.AdvancedPanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.Showcase;

public class GridFilterWindowSample extends ShowcasePanel {
    private static final String DESCRIPTION = "All grids automatically support the <code>FilterBuilder</code>'s powerful, "+
    "flexible filtering interface by default, even if the filter row interface is also enabled."+
    "<p>"+
    "Click the \"Show Filter Window\" button to see a pop-up window where you can edit arbitrarily nested advanced criteria."+
    "<p>"+
    "You can reach this interface from <code>any grid</code> in multiple ways: right click in the filter row and pick "+
    "\"Advanced filtering...\", or right click on any header and pick the same.";

    public static class Factory extends AdvancedPanelFactory {
        @Override
        public String getDescription() {
            return DESCRIPTION;
        }

        @Override
        public com.smartgwt.client.widgets.HTMLFlow getDisabledViewPanel() {
            final com.smartgwt.client.widgets.HTMLFlow htmlFlow = new com.smartgwt.client.widgets.HTMLFlow("<div class='explorerCheckErrorMessage'><p>This example is disabled because it requires the Server Advanced filtering feature of " +
                    "<a href=\"http://www.smartclient.com/product/index.jsp\" target=\"_blank\">Smart GWT Power Edition</a>.</p>" +
                    "<p>Click <a href=\"http://www.smartclient.com/smartgwtee/showcase/#filterbuilder_sql\" target=\"\">here</a> to see this example on SmartClient.com.</p></div>");
            htmlFlow.setWidth100();
            return htmlFlow;
        }

        @Override
        public boolean isEnabled() {
            return Showcase.hasServerAdvancedFiltering();
        }

        @Override
        public ShowcasePanel createShowcasePanel() {
            return new GridFilterWindowSample();
        }
    }

    public Canvas getViewPanel() {

        VLayout vLayout = new VLayout();
        vLayout.setMembersMargin(5);
        
        final ListGrid countryGrid = new ListGrid();
        countryGrid.setWidth(700);
        countryGrid.setHeight(300);
        countryGrid.setAlternateRecordStyles(true);
        countryGrid.setDataSource(DataSource.get("worldDS"));

        ListGridField countryCodeField = new ListGridField("countryCode", "Code", 50);
        ListGridField nameField = new ListGridField("countryName", "Country");
        ListGridField capitalField = new ListGridField("capital", "Capital");
        ListGridField continentField = new ListGridField("continent", "Continent");
        ListGridField areaField = new ListGridField("area", "Area (km²)");
        ListGridField populationField = new ListGridField("population", "Population");

        countryGrid.setFields(countryCodeField, nameField, capitalField, continentField, areaField, populationField);

        countryGrid.setAutoFetchData(true);
        countryGrid.setShowFilterEditor(true);

        AdvancedCriteria criteria = new AdvancedCriteria(OperatorId.AND, new AdvancedCriteria[] {  
            new AdvancedCriteria("countryName", OperatorId.INOT_CONTAINS, "i"),  
            new AdvancedCriteria("capital", OperatorId.INOT_STARTS_WITH, "p")  
        });
        countryGrid.setAllowFilterOperators(true);
        countryGrid.setCriteria(criteria);

        IButton fwButton = new IButton();
        fwButton.setTitle("Show Filter Window");
        fwButton.setWidth(150);
        fwButton.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                countryGrid.showFilterWindow();
            }
            
        });

        vLayout.addMember(countryGrid);
        vLayout.addMember(fwButton);
    
        return vLayout;
    }

    protected boolean isTopIntro() {
        return true;
    }
    
    public String getIntro() {
        return DESCRIPTION;
    }
}
