package com.smartgwt.sample.client;

import com.smartgwt.client.types.*;
import com.smartgwt.client.util.PageKeyHandler;
import com.smartgwt.client.util.Page;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.data.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.form.fields.events.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.browser.window.events.*;

public class CreateNewWindowForm extends DynamicForm {
    ButtonItem createButton;
    TextItem windowName;

    public CreateNewWindowForm() {
        setNumCols(3);
        setColWidths(100, 150, "*");
            
        windowName = new TextItem("name", "Window Name");
        windowName.addKeyPressHandler(new KeyPressHandler() {
            public void onKeyPress(KeyPressEvent event) {
                String keyName = event.getKeyName();
                if ("Enter".equals(keyName) && windowName.getValue() == null) {
                    updateChildWindowName();
                    event.cancel();
                }
            }
        });

        Validator validator = new Validator();
        validator.setType(ValidatorType.REQUIRED);
        windowName.setValidateOnChange(true);
        windowName.setValidators(validator);

        createButton = new ButtonItem("create", "Create Window");
        createButton.setStartRow(false);
        createButton.setEnableWhen(new AdvancedCriteria(OperatorId.AND, new Criterion[]{
            new Criterion("name", OperatorId.NOT_NULL)
        }));
        createButton.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                BrowserWindowSettings settings = new BrowserWindowSettings();
                settings.setDefaultWidth(700); settings.setDefaultHeight(700);

                MultiWindow.open(null, windowName.getValueAsString(),
                                 MultiWindow.getDataContext(), null, settings);
                ApplicationContext.getSharedInstance().childWindowCounter++;
            }
        });

        setItems(windowName, createButton);
        updateChildWindowName();
    }

    void updateChildWindowName() {
        ApplicationContext appContext = ApplicationContext.getSharedInstance();
        if (appContext != null) {
            windowName.setDefaultValue("child" + appContext.childWindowCounter);
        }
        if (windowName.isCreated()) {
            windowName.clearValue();
            windowName.validate();
        }
    }
}
