/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * A ListGrid is a {@link com.smartgwt.client.widgets.DataBoundComponent} that displays a list of objects in a grid, where
 * each row represents one object and each cell in the row represents one property.
 * @see com.smartgwt.client.docs.GridFiltering GridFiltering overview and related methods
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("ListGrid")
public class ListGrid extends VLayout implements DataBoundComponent, com.smartgwt.client.widgets.grid.events.HasCellSavedHandlers, com.smartgwt.client.widgets.grid.events.HasCellClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconOutHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconOverHandlers, com.smartgwt.client.widgets.grid.events.HasCellHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasCellOutHandlers, com.smartgwt.client.widgets.grid.events.HasCellOverHandlers, com.smartgwt.client.widgets.grid.events.HasCellSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasCellValueHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCriteriaChangedHandlers, com.smartgwt.client.widgets.grid.events.HasDataArrivedHandlers, com.smartgwt.client.widgets.grid.events.HasDataChangedHandlers, com.smartgwt.client.widgets.grid.events.HasDrawAreaChangedHandlers, com.smartgwt.client.widgets.grid.events.HasEditCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasEditFailedHandlers, com.smartgwt.client.widgets.grid.events.HasEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasFieldStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasFilterEditorSubmitHandlers, com.smartgwt.client.widgets.events.HasFormulaUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasGroupStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupTreeChangedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByHandlers, com.smartgwt.client.widgets.grid.events.HasRegroupHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderHoverHandlers, com.smartgwt.client.widgets.grid.events.HasHilitesChangedHandlers, com.smartgwt.client.widgets.grid.events.HasBodyKeyPressHandlers, com.smartgwt.client.widgets.grid.events.HasRecordCollapseHandlers, com.smartgwt.client.widgets.grid.events.HasRecordExpandHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDropHandlers, com.smartgwt.client.widgets.grid.events.HasRemoveRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasRowHoverHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasRowOutHandlers, com.smartgwt.client.widgets.grid.events.HasRowOverHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasSetSortHandlers, com.smartgwt.client.widgets.grid.events.HasSortChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSorterClickHandlers, com.smartgwt.client.widgets.grid.events.HasSorterContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasViewStateChangedHandlers {

    public static ListGrid getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new ListGrid(jsObj);
        } else {
            assert refInstance instanceof ListGrid;
            return (ListGrid)refInstance;
        }
    }

    private static final ListGrid TEST_INSTANCE = new ListGrid();
    static {
        TEST_INSTANCE.setID("isc_ListGrid_testInstance");
    }

    @Override
    protected ListGrid getTestInstance() {
        return TEST_INSTANCE;
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ListGrid.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ListGrid.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public ListGrid(){
        setModalEditing(true);scClassName = "ListGrid";
    }

    public ListGrid(JavaScriptObject jsObj){
        scClassName = "ListGrid";
        setJavaScriptObject(jsObj);
    }


    public ListGrid(DataSource dataSource) {
        setDataSource(dataSource);
                setModalEditing(true);scClassName = "ListGrid";
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;

    // ********************* Properties / Attributes ***********************

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @param advancedFieldPickerThreshold New advancedFieldPickerThreshold value. Default value is 25
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAdvancedFieldPickerThreshold(int advancedFieldPickerThreshold)  throws IllegalStateException {
        return (ListGrid)setAttribute("advancedFieldPickerThreshold", advancedFieldPickerThreshold, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @return Current advancedFieldPickerThreshold value. Default value is 25
     */
    public int getAdvancedFieldPickerThreshold()  {
        return getAttributeAsInt("advancedFieldPickerThreshold");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow} is enabled, this attribute will be
     * shown as the menu item title to configure advanced filtering.  This menu-item is displayed in the context menu for the
     * sorter button and in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators filter using}
     * operators menu.
     *
     * @param advancedFilteringText New advancedFilteringText value. Default value is "Advanced filtering..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAdvancedFilteringText(String advancedFilteringText) {
        return (ListGrid)setAttribute("advancedFilteringText", advancedFilteringText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow} is enabled, this attribute will be
     * shown as the menu item title to configure advanced filtering.  This menu-item is displayed in the context menu for the
     * sorter button and in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators filter using}
     * operators menu.
     *
     * @return Current advancedFilteringText value. Default value is "Advanced filtering..."
     */
    public String getAdvancedFilteringText()  {
        return getAttributeAsString("advancedFilteringText");
    }
    

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions DynamicForm.allowExpressions} were true. <P> This
     * attribute can also be set at the {@link com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterExpressions field
     * level}.
     *
     * @param allowFilterExpressions New allowFilterExpressions value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.AdvancedFilter AdvancedFilter overview and related methods
     */
    public ListGrid setAllowFilterExpressions(Boolean allowFilterExpressions)  throws IllegalStateException {
        return (ListGrid)setAttribute("allowFilterExpressions", allowFilterExpressions, false);
    }

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions DynamicForm.allowExpressions} were true. <P> This
     * attribute can also be set at the {@link com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterExpressions field
     * level}.
     *
     * @return Current allowFilterExpressions value. Default value is null
     * @see com.smartgwt.client.docs.AdvancedFilter AdvancedFilter overview and related methods
     */
    public Boolean getAllowFilterExpressions()  {
        return getAttributeAsBoolean("allowFilterExpressions");
    }
    

    /**
     * Causes a menu item titled {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} to appear
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end
     * user to pick an advanced {@link com.smartgwt.client.types.OperatorId search operator} to use for this field. <p> Once an
     * operator has been chosen, the active operator is indicated by an {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} placed within the field (you can alternatively
     * cause the icon to {@link com.smartgwt.client.widgets.grid.ListGrid#getAlwaysShowOperatorIcon always be present}).  The
     * <code>operatorIcon</code>  shows the same textual representation of the search operator as is used by the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getAllowExpressions FormItem.allowExpressions} feature.  Clicking on
     * the icon provides a second way to  modify the search operator.   <p> This feature is enabled by default if {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} is true,  for all
     * fields where it is normally possible to filter by typing in a search string.  This  excludes field types such as "date"
     * or "boolean" which show specialized filter controls.   Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterOperators ListGridField.allowFilterOperators} to disable
     * this interface for individual  fields, or set {@link com.smartgwt.client.data.DataSourceField#getCanFilter
     * DataSourceField.canFilter} to false to disallow filtering entirely for  a field. <p> Note that this feature is similar
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions}, which allows  the
     * end users to directly type in characters such as "&gt;" to control filtering. <code>allowFilterOperators</code> is
     * easier to use and more discoverable than <code>allowFilterExpressions</code>, and also avoids the drawback where special
     * characters  like "&gt;" cannot be used in filter values.  However, <code>allowFilterExpressions</code>  allows users to
     * make use of certain operators that <code>allowFilterOperators</code> does  not support, such as using the
     * "betweenInclusive" operator by typing "5...10". <P> When both <code>allowfilterExpressions</code> and
     * <code>allowFilterOperators</code> are set, filter expressions entered in to the edit-area are parsed and the operator
     * automatically  applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon}. <P> If
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow} is enabled another option,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFilteringText "Advanced Filtering"}, is added to the "Filter
     * using" menu.
     *
     * @param allowFilterOperators New allowFilterOperators value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAllowFilterWindow
     */
    public ListGrid setAllowFilterOperators(Boolean allowFilterOperators)  throws IllegalStateException {
        return (ListGrid)setAttribute("allowFilterOperators", allowFilterOperators, false);
    }

    /**
     * Causes a menu item titled {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} to appear
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end
     * user to pick an advanced {@link com.smartgwt.client.types.OperatorId search operator} to use for this field. <p> Once an
     * operator has been chosen, the active operator is indicated by an {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} placed within the field (you can alternatively
     * cause the icon to {@link com.smartgwt.client.widgets.grid.ListGrid#getAlwaysShowOperatorIcon always be present}).  The
     * <code>operatorIcon</code>  shows the same textual representation of the search operator as is used by the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getAllowExpressions FormItem.allowExpressions} feature.  Clicking on
     * the icon provides a second way to  modify the search operator.   <p> This feature is enabled by default if {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} is true,  for all
     * fields where it is normally possible to filter by typing in a search string.  This  excludes field types such as "date"
     * or "boolean" which show specialized filter controls.   Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterOperators ListGridField.allowFilterOperators} to disable
     * this interface for individual  fields, or set {@link com.smartgwt.client.data.DataSourceField#getCanFilter
     * DataSourceField.canFilter} to false to disallow filtering entirely for  a field. <p> Note that this feature is similar
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions}, which allows  the
     * end users to directly type in characters such as "&gt;" to control filtering. <code>allowFilterOperators</code> is
     * easier to use and more discoverable than <code>allowFilterExpressions</code>, and also avoids the drawback where special
     * characters  like "&gt;" cannot be used in filter values.  However, <code>allowFilterExpressions</code>  allows users to
     * make use of certain operators that <code>allowFilterOperators</code> does  not support, such as using the
     * "betweenInclusive" operator by typing "5...10". <P> When both <code>allowfilterExpressions</code> and
     * <code>allowFilterOperators</code> are set, filter expressions entered in to the edit-area are parsed and the operator
     * automatically  applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon}. <P> If
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow} is enabled another option,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFilteringText "Advanced Filtering"}, is added to the "Filter
     * using" menu.
     *
     * @return Current allowFilterOperators value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
     */
    public Boolean getAllowFilterOperators()  {
        return getAttributeAsBoolean("allowFilterOperators");
    }
    

    /**
     * Adds the ability for a user to define additional criteria above and beyond those expressed in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} via a {@link
     * com.smartgwt.client.widgets.form.FilterBuilder} which appears in a modal Window over the grid and can be accessed by
     * various menus within the grid or triggered by external controls. <p> Causes a menu item titled {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFilteringText "Advanced Filtering"} to appear in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} menu show in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end user to
     * configure an advanced filter on the grid that can supplement the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}. Note that the menu option will show even
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators filter operators} is disabled. <p> To use
     * this feature, the grid must be configured with a {@link com.smartgwt.client.data.DataSource}. In fact, this feature is
     * enabled by default if the grid has a {@link com.smartgwt.client.data.DataSource} and both {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are true. This default can be
     * disabled by setting <code>allowFilterWindow</code> to <code>false</code>.  <p> <a
     * href='https://www.smartclient.com/smartclient-latest/showcase/?id=filterWindow' target='_blank'>This example</a> shows
     * the <code>allowFilterWindow</code> setting in use. <p> <b>Note:</b> this feature requires <a
     * href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
     *
     * @param allowFilterWindow New allowFilterWindow value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAllowFilterOperators
     */
    public ListGrid setAllowFilterWindow(Boolean allowFilterWindow)  throws IllegalStateException {
        return (ListGrid)setAttribute("allowFilterWindow", allowFilterWindow, false);
    }

    /**
     * Adds the ability for a user to define additional criteria above and beyond those expressed in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} via a {@link
     * com.smartgwt.client.widgets.form.FilterBuilder} which appears in a modal Window over the grid and can be accessed by
     * various menus within the grid or triggered by external controls. <p> Causes a menu item titled {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFilteringText "Advanced Filtering"} to appear in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} menu show in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end user to
     * configure an advanced filter on the grid that can supplement the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}. Note that the menu option will show even
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators filter operators} is disabled. <p> To use
     * this feature, the grid must be configured with a {@link com.smartgwt.client.data.DataSource}. In fact, this feature is
     * enabled by default if the grid has a {@link com.smartgwt.client.data.DataSource} and both {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are true. This default can be
     * disabled by setting <code>allowFilterWindow</code> to <code>false</code>.  <p> <a
     * href='https://www.smartclient.com/smartclient-latest/showcase/?id=filterWindow' target='_blank'>This example</a> shows
     * the <code>allowFilterWindow</code> setting in use. <p> <b>Note:</b> this feature requires <a
     * href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
     *
     * @return Current allowFilterWindow value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators
     */
    public Boolean getAllowFilterWindow()  {
        return getAttributeAsBoolean("allowFilterWindow");
    }
    

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} method will be called for every cell when rendering
     * out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} for more details
     *
     * @param allowRowSpanning New allowRowSpanning value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAllowRowSpanning(Boolean allowRowSpanning)  throws IllegalStateException {
        return (ListGrid)setAttribute("allowRowSpanning", allowRowSpanning, false);
    }

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} method will be called for every cell when rendering
     * out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} for more details
     *
     * @return Current allowRowSpanning value. Default value is false
     */
    public Boolean getAllowRowSpanning()  {
        Boolean result = getAttributeAsBoolean("allowRowSpanning");
        return result == null ? false : result;
    }
    

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateBodyStyleName alternateBodyStyleName} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param alternateBodyStyleName new body style name when showing alternateRecordStyles. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setAlternateBodyStyleName(String alternateBodyStyleName) {
        return (ListGrid)setAttribute("alternateBodyStyleName", alternateBodyStyleName, true);
    }

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * @return Current alternateBodyStyleName value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getAlternateBodyStyleName()  {
        return getAttributeAsString("alternateBodyStyleName");
    }
    

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @param alternateFieldFrequency New alternateFieldFrequency value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAlternateFieldFrequency(int alternateFieldFrequency) {
        return (ListGrid)setAttribute("alternateFieldFrequency", alternateFieldFrequency, true);
    }

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @return Current alternateFieldFrequency value. Default value is 1
     */
    public int getAlternateFieldFrequency()  {
        return getAttributeAsInt("alternateFieldFrequency");
    }
    

    /**
     * Whether alternating columns (or blocks of columns, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnFrequency GridRenderer.alternateColumnFrequency}) should
     * be drawn in alternating styles, in order to create a vertical "ledger" effect for easier reading. <P> If enabled, the
     * cell style for alternate rows will have the {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnSuffix GridRenderer.alternateColumnSuffix} appended to
     * it. See also {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles
     * GridRenderer.alternateRowStyles}.
     *
     * @param alternateFieldStyles New alternateFieldStyles value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAlternateFieldStyles(boolean alternateFieldStyles) {
        return (ListGrid)setAttribute("alternateFieldStyles", alternateFieldStyles, true);
    }

    /**
     * Whether alternating columns (or blocks of columns, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnFrequency GridRenderer.alternateColumnFrequency}) should
     * be drawn in alternating styles, in order to create a vertical "ledger" effect for easier reading. <P> If enabled, the
     * cell style for alternate rows will have the {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnSuffix GridRenderer.alternateColumnSuffix} appended to
     * it. See also {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles
     * GridRenderer.alternateRowStyles}.
     *
     * @return Current alternateFieldStyles value. Default value is false
     */
    public boolean getAlternateFieldStyles()  {
        Boolean result = getAttributeAsBoolean("alternateFieldStyles");
        return result == null ? false : result;
    }
    

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternate columns}.
     * Note that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles GridRenderer.alternateRowStyles}
     * is enabled, cells which fall into both an alternate row and column will have both suffixes appended - for example
     * <code>"cellDarkAltCol"</code>.
     *
     * @param alternateFieldSuffix New alternateFieldSuffix value. Default value is "AltCol"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAlternateFieldSuffix(String alternateFieldSuffix) {
        return (ListGrid)setAttribute("alternateFieldSuffix", alternateFieldSuffix, true);
    }

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternate columns}.
     * Note that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles GridRenderer.alternateRowStyles}
     * is enabled, cells which fall into both an alternate row and column will have both suffixes appended - for example
     * <code>"cellDarkAltCol"</code>.
     *
     * @return Current alternateFieldSuffix value. Default value is "AltCol"
     */
    public String getAlternateFieldSuffix()  {
        return getAttributeAsString("alternateFieldSuffix");
    }
    

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @param alternateRecordFrequency New alternateRecordFrequency value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAlternateRecordFrequency(int alternateRecordFrequency) {
        return (ListGrid)setAttribute("alternateRecordFrequency", alternateRecordFrequency, true);
    }

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @return Current alternateRecordFrequency value. Default value is 1
     */
    public int getAlternateRecordFrequency()  {
        return getAttributeAsInt("alternateRecordFrequency");
    }
    

    /**
     * Whether alternating rows (or blocks of rows, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowFrequency GridRenderer.alternateRowFrequency}) should be
     * drawn in alternating styles, in order to create a "ledger" effect for easier reading. <P> If enabled, the cell style for
     * alternate rows will have the {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowSuffix
     * GridRenderer.alternateRowSuffix} appended to it. See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles GridRenderer.alternateColumnStyles}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}
     *
     * @param alternateRecordStyles New value for <code>this.alternateRecordStyles</code>. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public ListGrid setAlternateRecordStyles(Boolean alternateRecordStyles) {
        return (ListGrid)setAttribute("alternateRecordStyles", alternateRecordStyles, true);
    }

    /**
     * Whether alternating rows (or blocks of rows, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowFrequency GridRenderer.alternateRowFrequency}) should be
     * drawn in alternating styles, in order to create a "ledger" effect for easier reading. <P> If enabled, the cell style for
     * alternate rows will have the {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowSuffix
     * GridRenderer.alternateRowSuffix} appended to it. See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles GridRenderer.alternateColumnStyles}.
     *
     * @return Current alternateRecordStyles value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public Boolean getAlternateRecordStyles()  {
        Boolean result = getAttributeAsBoolean("alternateRecordStyles");
        return result == null ? false : result;
    }
    

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternate rows}. Note
     * that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles
     * GridRenderer.alternateColumnStyles} is enabled, cells which fall into both an alternate row and column will have both
     * suffixes appended - for example <code>"cellDarkAltCol"</code>.
     *
     * @param alternateRecordSuffix New alternateRecordSuffix value. Default value is "Dark"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public ListGrid setAlternateRecordSuffix(String alternateRecordSuffix) {
        return (ListGrid)setAttribute("alternateRecordSuffix", alternateRecordSuffix, true);
    }

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternate rows}. Note
     * that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles
     * GridRenderer.alternateColumnStyles} is enabled, cells which fall into both an alternate row and column will have both
     * suffixes appended - for example <code>"cellDarkAltCol"</code>.
     *
     * @return Current alternateRecordSuffix value. Default value is "Dark"
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public String getAlternateRecordSuffix()  {
        return getAttributeAsString("alternateRecordSuffix");
    }
    

    /**
     * When this attribute is set, editors will be appear to be present in every row of the  grid, allowing the user to
     * immediately start editing any cell, rather than showing  up in a single record at a time.<br> This attribute is only
     * valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell} is false. <P> This setting has
     * some limitations and is typically only used for simple grids with  a limited set of fields and standard editors. <ul>
     * <li>Not all formItem types are supported. Default editors for standard data types   (text, boolean, date, datetime,
     * integer and float) are all supported, but custom   editorType, including CanvasItem based editors are not. Fields with
     * an unsupported   editor type will show static values for all rows other than the current edit row, though   users can
     * start editing these with a single click</li>  <li><code>alwaysShowEditors:true</code> grids do not support showing
     * different   editor types for the same field in different rows</li> <li>In some cases there may be visual differences
     * between the editor displayed in the   edit row and the editor displayed in other rows.</li> <li>From a design
     * perspective, this mode presents a very "busy-looking" UI,     which can made it harder to read the actual data.
     * Functionally having      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} set to "click"
     * provides the same single-click to edit     any cell user experience without the busy UI.</li> <li>In some cases there
     * may be a performance penalty for writing out so many controls     (editors for every cell of the grid).</li> </ul> Note
     * that in addition to alwaysShowEditors, listGrid support single-click editing via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent:"click"}, and, for boolean fields,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanToggle ListGridField.canToggle}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param alwaysShowEditors New alwaysShowEditors value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setAlwaysShowEditors(Boolean alwaysShowEditors)  throws IllegalStateException {
        return (ListGrid)setAttribute("alwaysShowEditors", alwaysShowEditors, false);
    }

    /**
     * When this attribute is set, editors will be appear to be present in every row of the  grid, allowing the user to
     * immediately start editing any cell, rather than showing  up in a single record at a time.<br> This attribute is only
     * valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell} is false. <P> This setting has
     * some limitations and is typically only used for simple grids with  a limited set of fields and standard editors. <ul>
     * <li>Not all formItem types are supported. Default editors for standard data types   (text, boolean, date, datetime,
     * integer and float) are all supported, but custom   editorType, including CanvasItem based editors are not. Fields with
     * an unsupported   editor type will show static values for all rows other than the current edit row, though   users can
     * start editing these with a single click</li>  <li><code>alwaysShowEditors:true</code> grids do not support showing
     * different   editor types for the same field in different rows</li> <li>In some cases there may be visual differences
     * between the editor displayed in the   edit row and the editor displayed in other rows.</li> <li>From a design
     * perspective, this mode presents a very "busy-looking" UI,     which can made it harder to read the actual data.
     * Functionally having      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} set to "click"
     * provides the same single-click to edit     any cell user experience without the busy UI.</li> <li>In some cases there
     * may be a performance penalty for writing out so many controls     (editors for every cell of the grid).</li> </ul> Note
     * that in addition to alwaysShowEditors, listGrid support single-click editing via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent:"click"}, and, for boolean fields,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanToggle ListGridField.canToggle}
     *
     * @return Current alwaysShowEditors value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAlwaysShowEditors()  {
        return getAttributeAsBoolean("alwaysShowEditors");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled, whether
     * to show the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} for all filterable fields, or
     * only for fields where the user has explicitly chosen a search operator different from the default operator for the
     * field. <p> The default operator for a field is determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} or by setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator} for a specific field.
     *
     * @param alwaysShowOperatorIcon New alwaysShowOperatorIcon value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAlwaysShowOperatorIcon(Boolean alwaysShowOperatorIcon)  throws IllegalStateException {
        return (ListGrid)setAttribute("alwaysShowOperatorIcon", alwaysShowOperatorIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled, whether
     * to show the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} for all filterable fields, or
     * only for fields where the user has explicitly chosen a search operator different from the default operator for the
     * field. <p> The default operator for a field is determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} or by setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator} for a specific field.
     *
     * @return Current alwaysShowOperatorIcon value. Default value is null
     */
    public Boolean getAlwaysShowOperatorIcon()  {
        return getAttributeAsBoolean("alwaysShowOperatorIcon");
    }
    

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolderEffect New animateFolderEffect value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAnimateFolderEffect(AnimationAcceleration animateFolderEffect) {
        return (ListGrid)setAttribute("animateFolderEffect", animateFolderEffect == null ? null : animateFolderEffect.getValue(), true);
    }

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return Current animateFolderEffect value. Default value is null
     */
    public AnimationAcceleration getAnimateFolderEffect()  {
        return EnumUtil.getEnum(AnimationAcceleration.values(), getAttribute("animateFolderEffect"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderMaxRows New animateFolderMaxRows value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public ListGrid setAnimateFolderMaxRows(Integer animateFolderMaxRows) {
        return (ListGrid)setAttribute("animateFolderMaxRows", animateFolderMaxRows, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return Current animateFolderMaxRows value. Default value is null
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public Integer getAnimateFolderMaxRows()  {
        return getAttributeAsInt("animateFolderMaxRows");
    }
    

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolders New animateFolders value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAnimateFolders(Boolean animateFolders) {
        return (ListGrid)setAttribute("animateFolders", animateFolders, true);
    }

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return Current animateFolders value. Default value is true
     */
    public Boolean getAnimateFolders()  {
        Boolean result = getAttributeAsBoolean("animateFolders");
        return result == null ? true : result;
    }
    

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * TreeGrid.animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a
     * speed. <P> For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * grouping} is enabled.
     *
     * @param animateFolderSpeed New animateFolderSpeed value. Default value is 3000
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderTime
     */
    public ListGrid setAnimateFolderSpeed(int animateFolderSpeed) {
        return (ListGrid)setAttribute("animateFolderSpeed", animateFolderSpeed, true);
    }

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * TreeGrid.animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a
     * speed. <P> For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * grouping} is enabled.
     *
     * @return Current animateFolderSpeed value. Default value is 3000
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderTime
     */
    public int getAnimateFolderSpeed()  {
        return getAttributeAsInt("animateFolderSpeed");
    }
    

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * TreeGrid.animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderTime New animateFolderTime value. Default value is 100
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderSpeed
     */
    public ListGrid setAnimateFolderTime(int animateFolderTime) {
        return (ListGrid)setAttribute("animateFolderTime", animateFolderTime, true);
    }

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * TreeGrid.animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return Current animateFolderTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderSpeed
     */
    public int getAnimateFolderTime()  {
        return getAttributeAsInt("animateFolderTime");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @param animateRemoveRecord New animateRemoveRecord value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAnimateRemoveRecord(Boolean animateRemoveRecord) {
        return (ListGrid)setAttribute("animateRemoveRecord", animateRemoveRecord, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @return Current animateRemoveRecord value. Default value is true
     */
    public Boolean getAnimateRemoveRecord()  {
        Boolean result = getAttributeAsBoolean("animateRemoveRecord");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @param animateRemoveSpeed New animateRemoveSpeed value. Default value is 200
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public ListGrid setAnimateRemoveSpeed(int animateRemoveSpeed) {
        return (ListGrid)setAttribute("animateRemoveSpeed", animateRemoveSpeed, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @return Current animateRemoveSpeed value. Default value is 200
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveSpeed()  {
        return getAttributeAsInt("animateRemoveSpeed");
    }
    

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @param animateRemoveTime New animateRemoveTime value. Default value is 100
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public ListGrid setAnimateRemoveTime(int animateRemoveTime) {
        return (ListGrid)setAttribute("animateRemoveTime", animateRemoveTime, true);
    }

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @return Current animateRemoveTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveTime()  {
        return getAttributeAsInt("animateRemoveTime");
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollOver New animateRollOver value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAnimateRollOver(Boolean animateRollOver) {
        return (ListGrid)setAttribute("animateRollOver", animateRollOver, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     *
     * @return Current animateRollOver value. Default value is false
     */
    public Boolean getAnimateRollOver()  {
        Boolean result = getAttributeAsBoolean("animateRollOver");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollUnder New animateRollUnder value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public ListGrid setAnimateRollUnder(Boolean animateRollUnder) {
        return (ListGrid)setAttribute("animateRollUnder", animateRollUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     *
     * @return Current animateRollUnder value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateRollUnder()  {
        Boolean result = getAttributeAsBoolean("animateRollUnder");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelection New animateSelection value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelectionUnder
     */
    public ListGrid setAnimateSelection(Boolean animateSelection) {
        return (ListGrid)setAttribute("animateSelection", animateSelection, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     *
     * @return Current animateSelection value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelectionUnder
     */
    public Boolean getAnimateSelection()  {
        Boolean result = getAttributeAsBoolean("animateSelection");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * Canvas.animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and
     * {@link com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelectionUnder New animateSelectionUnder value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public ListGrid setAnimateSelectionUnder(Boolean animateSelectionUnder) {
        return (ListGrid)setAttribute("animateSelectionUnder", animateSelectionUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * Canvas.animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and
     * {@link com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     *
     * @return Current animateSelectionUnder value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateSelectionUnder()  {
        Boolean result = getAttributeAsBoolean("animateSelectionUnder");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} is set for some
     * field, and this grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field
     * value should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary
     * ListGridField.applyAfterSummary}
     *
     * @param applyFormulaAfterSummary New applyFormulaAfterSummary value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setApplyFormulaAfterSummary(Boolean applyFormulaAfterSummary) {
        return (ListGrid)setAttribute("applyFormulaAfterSummary", applyFormulaAfterSummary, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} is set for some
     * field, and this grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field
     * value should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary
     * ListGridField.applyAfterSummary}
     *
     * @return Current applyFormulaAfterSummary value. Default value is false
     */
    public Boolean getApplyFormulaAfterSummary()  {
        Boolean result = getAttributeAsBoolean("applyFormulaAfterSummary");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param applyRowNumberStyle New applyRowNumberStyle value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setApplyRowNumberStyle(boolean applyRowNumberStyle) {
        return (ListGrid)setAttribute("applyRowNumberStyle", applyRowNumberStyle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     *
     * @return Current applyRowNumberStyle value. Default value is true
     */
    public boolean getApplyRowNumberStyle()  {
        Boolean result = getAttributeAsBoolean("applyRowNumberStyle");
        return result == null ? true : result;
    }
    

    /**
     * ARIA role for this ListGrid if {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled.
     * <P> The <a href='https://www.w3.org/WAI/standards-guidelines/aria/' target='_blank'>WAI-Aria standards</a> contain a
     * number of roles and related attributes that could apply to data presented in a ListGrid or its subclasses. In order to
     * make screenreader support as straightforward as possible we have built-in support for writing out appropriate aria roles
     * and  attributes on the listGrid and its component elements for a couple of standard modes, as well as providing override
     * points allowing developers to explicitly specify the  properties that get written out. <P> The two "standard" ariaRoles
     * supported for ListGrids are  <a href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/Grid_Role'
     * target='_blank'>"grid"</a> and <a href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/List_role'
     * target='_blank'>"list"</a>. <P> When <i>ariaRole</i> is set to <code>"list"</code> we write out the following  standard
     * properties by default: <ul> <li>rows have role set to <code>"listitem"</code></li> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()} will return aria properties for     
     * <code>setsize</code>, <code>posinset</code>,      <code>selected</code> (for selected rows) and     
     * <code>expanded</code> (for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanded} rows)</li>
     * <li>Additionally, if {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderWriteRowLabelledBy
     * screenReaderWriteRowLabelledBy} is  true,      rows will write out an <code>aria-labelldby</code> that will cause
     * ScreenReaders     to read the column header and cell / row separators in addition to the cell     content for the
     * row</li> </ul> <P> When <i>ariaRole</i> is set to <code>"grid"</code> we write out the following  standard properties by
     * default: <ul> <li><code>aria-rowcount</code> and <code>aria-colcount</code> will be specified on     the listGrid
     * itself</li> <li>The {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader header} will have role <code>row</code>  
     * and <code>aria-rowindex</code> set to 1</li> <li>Column header buttons will have role <code>columnheader</code>, and    
     * <code>aria-colindex</code> set to the appropriate value for the column.    Additionally <code>aria-sort</code> will be
     * specified to reflect the current sort-state    for the field, and if the header menu is enabled,
     * <code>aria-haspopup</code> will be    <code>true</code></li> <li>Rows within the grid body will have role
     * <code>row</code></li> <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()} will
     * return aria properties for      <code>rowindex</code>, <code>selected</code> (for selected rows) and     
     * <code>expanded</code> (for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanded} rows)</li>
     * <li>Cells within rows will have role <code>gridcell</code></li> </ul> Developers may configure different ARIA HTML roles
     * and attributes by modifying  this attribute (<code>listGrid.ariaRole</code>) and implementing custom handling for the
     * following APIs: <table border=1>  <tr>   <td>ListGrid</td>   <td><code>listGrid.ariaRole</code>, {@link
     * com.smartgwt.client.widgets.Canvas#getAriaState ariaState},        .</td>  </tr><tr>   <td>header / header buttons</td> 
     * <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAriaRole headerAriaRole},       {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaRole headerButtonAriaRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaRole ListGridField.headerButtonAriaRole}      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaState headerButtonAriaState}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaState ListGridField.headerButtonAriaState}</td> 
     * </tr><tr>   <td>rows</td>   <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getRowRole rowRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordRowRoleProperty recordRowRoleProperty},    {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState rowAriaState}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordRowAriaStateProperty recordRowAriaStateProperty}    .     To update
     * row state    at runtime, developers may redraw the grid or its body.</td>  </tr><tr>   <td>cells</td>   <td>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRole cellRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCellRoleProperty recordCellRoleProperty}    .     To update cell
     * state    at runtime, developers may redraw the grid or its body.</td>  </tr> </table>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param ariaRole New ariaRole value. Default value is "list"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setAriaRole(String ariaRole) {
        return (ListGrid)setAttribute("ariaRole", ariaRole, true);
    }

    /**
     * ARIA role for this ListGrid if {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled.
     * <P> The <a href='https://www.w3.org/WAI/standards-guidelines/aria/' target='_blank'>WAI-Aria standards</a> contain a
     * number of roles and related attributes that could apply to data presented in a ListGrid or its subclasses. In order to
     * make screenreader support as straightforward as possible we have built-in support for writing out appropriate aria roles
     * and  attributes on the listGrid and its component elements for a couple of standard modes, as well as providing override
     * points allowing developers to explicitly specify the  properties that get written out. <P> The two "standard" ariaRoles
     * supported for ListGrids are  <a href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/Grid_Role'
     * target='_blank'>"grid"</a> and <a href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/List_role'
     * target='_blank'>"list"</a>. <P> When <i>ariaRole</i> is set to <code>"list"</code> we write out the following  standard
     * properties by default: <ul> <li>rows have role set to <code>"listitem"</code></li> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()} will return aria properties for     
     * <code>setsize</code>, <code>posinset</code>,      <code>selected</code> (for selected rows) and     
     * <code>expanded</code> (for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanded} rows)</li>
     * <li>Additionally, if {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderWriteRowLabelledBy
     * screenReaderWriteRowLabelledBy} is  true,      rows will write out an <code>aria-labelldby</code> that will cause
     * ScreenReaders     to read the column header and cell / row separators in addition to the cell     content for the
     * row</li> </ul> <P> When <i>ariaRole</i> is set to <code>"grid"</code> we write out the following  standard properties by
     * default: <ul> <li><code>aria-rowcount</code> and <code>aria-colcount</code> will be specified on     the listGrid
     * itself</li> <li>The {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader header} will have role <code>row</code>  
     * and <code>aria-rowindex</code> set to 1</li> <li>Column header buttons will have role <code>columnheader</code>, and    
     * <code>aria-colindex</code> set to the appropriate value for the column.    Additionally <code>aria-sort</code> will be
     * specified to reflect the current sort-state    for the field, and if the header menu is enabled,
     * <code>aria-haspopup</code> will be    <code>true</code></li> <li>Rows within the grid body will have role
     * <code>row</code></li> <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()} will
     * return aria properties for      <code>rowindex</code>, <code>selected</code> (for selected rows) and     
     * <code>expanded</code> (for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanded} rows)</li>
     * <li>Cells within rows will have role <code>gridcell</code></li> </ul> Developers may configure different ARIA HTML roles
     * and attributes by modifying  this attribute (<code>listGrid.ariaRole</code>) and implementing custom handling for the
     * following APIs: <table border=1>  <tr>   <td>ListGrid</td>   <td><code>listGrid.ariaRole</code>, {@link
     * com.smartgwt.client.widgets.Canvas#getAriaState ariaState},        .</td>  </tr><tr>   <td>header / header buttons</td> 
     * <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAriaRole headerAriaRole},       {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaRole headerButtonAriaRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaRole ListGridField.headerButtonAriaRole}      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaState headerButtonAriaState}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaState ListGridField.headerButtonAriaState}</td> 
     * </tr><tr>   <td>rows</td>   <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getRowRole rowRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordRowRoleProperty recordRowRoleProperty},    {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState rowAriaState}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordRowAriaStateProperty recordRowAriaStateProperty}    .     To update
     * row state    at runtime, developers may redraw the grid or its body.</td>  </tr><tr>   <td>cells</td>   <td>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRole cellRole}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCellRoleProperty recordCellRoleProperty}    .     To update cell
     * state    at runtime, developers may redraw the grid or its body.</td>  </tr> </table>
     *
     * @return Current ariaRole value. Default value is "list"
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getAriaRole()  {
        return getAttributeAsString("ariaRole");
    }
    

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the arrow keys to
     * navigate around the grid. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is
     * true, navigation occurs by cell - the user can move to a new cell in any direction.<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is false, navigation typically occurs by row
     * - the user can move up or down throw the rows in the grid. <P> For actions that fire events (click or doubleClick), both
     * cell and record level events are fired (for example for arrowKeyAction <code>"activate"</code>, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addCellDoubleClickHandler ListGrid.cellDoubleClick()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addRecordDoubleClickHandler ListGrid.recordDoubleClick()} are fired for the
     * new position.<br> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is
     * false, the events will be fired as if a click or double click had occurred on the first cell where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIgnoreKeyboardClicks ListGridField.ignoreKeyboardClicks} is not true.
     * <P> Possible actions are: <ul> <li><code>"select"</code> : select the next row or cell in the grid and call      click
     * handlers.</li> <li><code>"selectOnly"</code> : select the next row or cell in the grid without firing       click
     * handlers.</li> <li><code>"focus"</code> : move focus to the next row or cell in the grid without      changing the
     * selection or calling click handlers.</li> <li><code>"activate"</code> : select and activate the next row or cell in the
     * list (calls  <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li>
     * <code>null</code> : if {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is
     * "checkbox", behaves as if set  to "focus"; otherwise, behaves as if set to "select"</li> </ul> <P> Note: If this grid is
     * editable, behavior while editing is governed by the result of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyEditAction getArrowKeyEditAction()}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter generateClickOnEnter}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace generateClickOnSpace}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter generateDoubleClickOnEnter} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace generateDoubleClickOnSpace}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param arrowKeyAction New arrowKeyAction value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setArrowKeyAction(String arrowKeyAction) {
        return (ListGrid)setAttribute("arrowKeyAction", arrowKeyAction, true);
    }

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the arrow keys to
     * navigate around the grid. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is
     * true, navigation occurs by cell - the user can move to a new cell in any direction.<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is false, navigation typically occurs by row
     * - the user can move up or down throw the rows in the grid. <P> For actions that fire events (click or doubleClick), both
     * cell and record level events are fired (for example for arrowKeyAction <code>"activate"</code>, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addCellDoubleClickHandler ListGrid.cellDoubleClick()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addRecordDoubleClickHandler ListGrid.recordDoubleClick()} are fired for the
     * new position.<br> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is
     * false, the events will be fired as if a click or double click had occurred on the first cell where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIgnoreKeyboardClicks ListGridField.ignoreKeyboardClicks} is not true.
     * <P> Possible actions are: <ul> <li><code>"select"</code> : select the next row or cell in the grid and call      click
     * handlers.</li> <li><code>"selectOnly"</code> : select the next row or cell in the grid without firing       click
     * handlers.</li> <li><code>"focus"</code> : move focus to the next row or cell in the grid without      changing the
     * selection or calling click handlers.</li> <li><code>"activate"</code> : select and activate the next row or cell in the
     * list (calls  <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li>
     * <code>null</code> : if {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is
     * "checkbox", behaves as if set  to "focus"; otherwise, behaves as if set to "select"</li> </ul> <P> Note: If this grid is
     * editable, behavior while editing is governed by the result of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyEditAction getArrowKeyEditAction()}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter generateClickOnEnter}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace generateClickOnSpace}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter generateDoubleClickOnEnter} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace generateDoubleClickOnSpace}
     *
     * @return Current arrowKeyAction value. Default value is null
     */
    public String getArrowKeyAction()  {
        return getAttributeAsString("arrowKeyAction");
    }
    

    /**
     * What to do when a user hits arrow key while editing a field?<br> If not explicitly specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyEditAction getArrowKeyEditAction()}  will return an appropriate
     * action depending on the field type.
     *
     * @param arrowKeyEditAction New arrowKeyEditAction value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setArrowKeyEditAction(ArrowKeyEditAction arrowKeyEditAction) {
        return (ListGrid)setAttribute("arrowKeyEditAction", arrowKeyEditAction == null ? null : arrowKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits arrow key while editing a field?<br> If not explicitly specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyEditAction getArrowKeyEditAction()}  will return an appropriate
     * action depending on the field type.
     *
     * @return How should "Up" and "Down" arrow keypresses be handled when the user is editing an item in the grid. <P> Returning
     * "none" will cause the grid to take no action and allow default up/down arrow key behavior within the editor to proceed.
     * Returning "editNext" will create an appropriate {@link com.smartgwt.client.types.EditCompletionEvent} (<i>"arrow_up"</i>
     * or <i>"arrow_down"</i> and cause the grid to start editing the previous or next row). <P> Default behavior varies by
     * item type. For items where up and down arrows have significant functionality to the editor this method returns
     * <i>"none"</i>, allowing that standard behavior to proceed. This includes:<br> - Multi line editors (such as
     * TextAreaItems)<br> - SelectItems<br> - SpinnerItems<br> For other items, the default return value will be
     * <i>"edit_next"</i> <P> To override these defaults, developers may specify an explicit arrowKeyEditAction at the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyEditAction grid}, or  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getArrowKeyEditAction field} level. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ArrowKeyEditAction getArrowKeyEditAction()  {
        return EnumUtil.getEnum(ArrowKeyEditAction.values(), getAttribute("arrowKeyEditAction"));
    }
    

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @param asynchGroupingPrompt New asynchGroupingPrompt value. Default value is "${loadingImage}&amp;nbsp;Grouping data..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setAsynchGroupingPrompt(String asynchGroupingPrompt)  throws IllegalStateException {
        return (ListGrid)setAttribute("asynchGroupingPrompt", asynchGroupingPrompt, false);
    }

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @return Current asynchGroupingPrompt value. Default value is "${loadingImage}&amp;nbsp;Grouping data..."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getAsynchGroupingPrompt()  {
        return getAttributeAsString("asynchGroupingPrompt");
    }
    

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete ListGridField.autoComplete} if specified. If unset picks
     * up the default from the appropriate editor class (subclass of FormItem).
     *
     * @param autoComplete New autoComplete value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoComplete
     */
    public ListGrid setAutoComplete(AutoComplete autoComplete) {
        return (ListGrid)setAttribute("autoComplete", autoComplete == null ? null : autoComplete.getValue(), true);
    }

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete ListGridField.autoComplete} if specified. If unset picks
     * up the default from the appropriate editor class (subclass of FormItem).
     *
     * @return Current autoComplete value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete
     */
    public AutoComplete getAutoComplete()  {
        return EnumUtil.getEnum(AutoComplete.values(), getAttribute("autoComplete"));
    }
    

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded by
     * default. This flag determines whether we should save such edits automatically in this case.  See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits}, which  allows the user to choose
     * whether to save or discard the unsaved edits.
     *
     * @param autoConfirmSaveEdits New autoConfirmSaveEdits value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setAutoConfirmSaveEdits(Boolean autoConfirmSaveEdits) {
        return (ListGrid)setAttribute("autoConfirmSaveEdits", autoConfirmSaveEdits, true);
    }

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded by
     * default. This flag determines whether we should save such edits automatically in this case.  See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits}, which  allows the user to choose
     * whether to save or discard the unsaved edits.
     *
     * @return Current autoConfirmSaveEdits value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAutoConfirmSaveEdits()  {
        Boolean result = getAttributeAsBoolean("autoConfirmSaveEdits");
        return result == null ? false : result;
    }
    
    

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource} is specified, a valueMap will be automatically created by making a {@link
     * com.smartgwt.client.data.DataSource#fetchData DataSource.fetchData()} call against the specified dataSource and
     * extracting a valueMap from the returned records based on the displayField and valueField. <P> If set to false, valueMaps
     * will not be automatically fetched.  In this case, setting field.optionDataSource is effectively a shortcut for setting
     * optionDataSource on the editor via {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties
     * ListGridField.editorProperties}. <P> Can also be disabled on a per-field basis with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap ListGridField.autoFetchDisplayMap}.
     *
     * @param autoFetchDisplayMap New autoFetchDisplayMap value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#setOptionDataSource
     */
    public ListGrid setAutoFetchDisplayMap(Boolean autoFetchDisplayMap) {
        return (ListGrid)setAttribute("autoFetchDisplayMap", autoFetchDisplayMap, true);
    }

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource} is specified, a valueMap will be automatically created by making a {@link
     * com.smartgwt.client.data.DataSource#fetchData DataSource.fetchData()} call against the specified dataSource and
     * extracting a valueMap from the returned records based on the displayField and valueField. <P> If set to false, valueMaps
     * will not be automatically fetched.  In this case, setting field.optionDataSource is effectively a shortcut for setting
     * optionDataSource on the editor via {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties
     * ListGridField.editorProperties}. <P> Can also be disabled on a per-field basis with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap ListGridField.autoFetchDisplayMap}.
     *
     * @return Current autoFetchDisplayMap value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     */
    public Boolean getAutoFetchDisplayMap()  {
        Boolean result = getAttributeAsBoolean("autoFetchDisplayMap");
        return result == null ? true : result;
    }
    
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()} method.
     *
     * @param autoFitAllText New autoFitAllText value. Default value is "Auto Fit All Columns"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitAllText(String autoFitAllText) {
        return (ListGrid)setAttribute("autoFitAllText", autoFitAllText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()} method.
     *
     * @return Current autoFitAllText value. Default value is "Auto Fit All Columns"
     */
    public String getAutoFitAllText()  {
        return getAttributeAsString("autoFitAllText");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @param autoFitClipFields New autoFitClipFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoFitClipFields(String... autoFitClipFields)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoFitClipFields", autoFitClipFields, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @return Current autoFitClipFields value. Default value is null
     */
    public String[] getAutoFitClipFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("autoFitClipFields"));
    }
    

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData}.
     *
     * @param autoFitData One of <code>"vertical"</code>, <code>"horizontal"</code>  or <code>"both"</code>. To disable auto fit behavior, pass in
     * <code>null</code>. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitData(Autofit autoFitData) {
        return (ListGrid)setAttribute("autoFitData", autoFitData == null ? null : autoFitData.getValue(), true);
    }

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * @return Current autoFitData value. Default value is null
     */
    public Autofit getAutoFitData()  {
        return EnumUtil.getEnum(Autofit.values(), getAttribute("autoFitData"));
    }
    

    /**
     * Should listGrids automatically size date fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type date will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth defaultDateFieldWidth},  (or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth defaultEditableDateFieldWidth} for editable
     * fields). This static value is appropriate for dates rendered with the standard short-date formatter. If set to
     * <code>"title"</code> or <code>"both"</code>, the drawn width of the title will be taken into account when sizing the
     * column. <P> This is achieved by enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * autoFitWidth:true} on date fields when this property is set to anything other than <code>"none"</code>, setting the
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the
     * value specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth
     * defaultDateFieldWidth} or {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth
     * defaultEditableDateFieldWidth} if appropriate.
     *
     * @param autoFitDateFields New autoFitDateFields value. Default value is "value"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitDateFields(AutoFitWidthApproach autoFitDateFields) {
        return (ListGrid)setAttribute("autoFitDateFields", autoFitDateFields == null ? null : autoFitDateFields.getValue(), true);
    }

    /**
     * Should listGrids automatically size date fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type date will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth defaultDateFieldWidth},  (or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth defaultEditableDateFieldWidth} for editable
     * fields). This static value is appropriate for dates rendered with the standard short-date formatter. If set to
     * <code>"title"</code> or <code>"both"</code>, the drawn width of the title will be taken into account when sizing the
     * column. <P> This is achieved by enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * autoFitWidth:true} on date fields when this property is set to anything other than <code>"none"</code>, setting the
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the
     * value specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth
     * defaultDateFieldWidth} or {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth
     * defaultEditableDateFieldWidth} if appropriate.
     *
     * @return Current autoFitDateFields value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitDateFields()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitDateFields"));
    }
    

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength DataSourceField.length} if length is set, otherwise, the first
     * text field with no width specified. <P> Note that expanding {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} is not supported.
     *
     * @param autoFitExpandField New autoFitExpandField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoFitExpandField(String autoFitExpandField)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoFitExpandField", autoFitExpandField, false);
    }

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength DataSourceField.length} if length is set, otherwise, the first
     * text field with no width specified. <P> Note that expanding {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} is not supported.
     *
     * @return Current autoFitExpandField value. Default value is null
     */
    public String getAutoFitExpandField()  {
        return getAttributeAsString("autoFitExpandField");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code>, setting this property will cause the ListGrid body to size large enough to accommodate the actual
     * data and also leave this many extra rows' worth of blank space below the last record. If a maximum size is specified via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, it will still be respected. Once the
     * data set is large enough to fill or exceed that space, this property no longer has an effect.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExtraRecords autoFitExtraRecords}.
     *
     * @param autoFitExtraRecords Number of extra rows beyond the data-size we'll expand to accommodate if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is enabled vertically. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitExtraRecords(Integer autoFitExtraRecords) {
        return (ListGrid)setAttribute("autoFitExtraRecords", autoFitExtraRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code>, setting this property will cause the ListGrid body to size large enough to accommodate the actual
     * data and also leave this many extra rows' worth of blank space below the last record. If a maximum size is specified via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, it will still be respected. Once the
     * data set is large enough to fill or exceed that space, this property no longer has an effect.
     *
     * @return Current autoFitExtraRecords value. Default value is null
     */
    public Integer getAutoFitExtraRecords()  {
        return getAttributeAsInt("autoFitExtraRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @param autoFitFieldsFillViewport New autoFitFieldsFillViewport value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoFitFieldsFillViewport(Boolean autoFitFieldsFillViewport)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoFitFieldsFillViewport", autoFitFieldsFillViewport, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @return Current autoFitFieldsFillViewport value. Default value is true
     */
    public Boolean getAutoFitFieldsFillViewport()  {
        Boolean result = getAttributeAsBoolean("autoFitFieldsFillViewport");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and user-driven auto fit of fields is enabled via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields}, this attribute will be shown as the
     * menu item title for an item to perform a one-time autoFit of the field to its title or content via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()}.
     *
     * @param autoFitFieldText New autoFitFieldText value. Default value is "Auto Fit"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitFieldText(String autoFitFieldText) {
        return (ListGrid)setAttribute("autoFitFieldText", autoFitFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and user-driven auto fit of fields is enabled via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields}, this attribute will be shown as the
     * menu item title for an item to perform a one-time autoFit of the field to its title or content via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()}.
     *
     * @return Current autoFitFieldText value. Default value is "Auto Fit"
     */
    public String getAutoFitFieldText()  {
        return getAttributeAsString("autoFitFieldText");
    }
    

    /**
     * Should ListGrid fields autofit their widths to titles or content? This property may be overridden on a per-field basis
     * via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}. Developers may
     * wish to consider disabling autoFit for fields known to have  exceptionally long content as this can lead to large
     * horizontal scrollbars and unwieldy UI. <P> The {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach
     * autoFitWidthApproach} controls whether fitting is to values, titles or both. This property may also be overridden on a
     * per field basis. <P> If {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the
     * field, it will be taken as a minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     * minFieldWidth} will also be respected. <P> By default, the entire available width of the grid will still be used, by
     * allocating any "extra" space to specific columns - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} for details on
     * controlling this behavior. <P> When this feature is enabled, autofitting is active on an ongoing basis. Autofitting will
     * be performed: <ul>  <li> whenever the dataset is completely changed or rows are added or removed  <li> whenever a field
     * which is autofitting is changed  <li> on a manual call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField
     * autoFitField()} or       {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitFields autoFitFields()} </ul>
     * Auto-fitting behavior continues until the user resizes the field manually, at which point it stops. The user can also
     * perform a one-time auto-fit of fields via the header context menu if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is enabled. <P> When autofitting to
     * column values, {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} will be
     * called to determine the space required for a field's values. This method uses values from the rendered set of rows to
     * calculate the required column width, which means the field width may still be smaller than values from non-rendered
     * rows.  See {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} having to render out the data set
     * offscreen and measure the rendered content - it does not apply for cases where this method can return a simple fixed
     * values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid. <P> Interaction with wrapping: If
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapping of cell values} is  enabled, autoFit behavior
     * based on {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach cell content} will render fields wide
     * enough to contain the <i>unwrapped</i> cell values. If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * wrapping of field titles} is enabled, when fitting to  a title, a field will render wide enough to accommodate the
     * <i>wrapped</i> title without clipping (so wide enough for the natural wrap-point / longest word or unwrappable string).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}. Modifies the default auto-fit-width behavior for fields in this grid. Note that this may be overridden at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}.
     *
     * @param autoFitFieldWidths New value for autoFitFieldWidths. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoFitFieldWidths(Boolean autoFitFieldWidths)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoFitFieldWidths", autoFitFieldWidths, false);
    }

    /**
     * Should ListGrid fields autofit their widths to titles or content? This property may be overridden on a per-field basis
     * via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}. Developers may
     * wish to consider disabling autoFit for fields known to have  exceptionally long content as this can lead to large
     * horizontal scrollbars and unwieldy UI. <P> The {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach
     * autoFitWidthApproach} controls whether fitting is to values, titles or both. This property may also be overridden on a
     * per field basis. <P> If {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the
     * field, it will be taken as a minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     * minFieldWidth} will also be respected. <P> By default, the entire available width of the grid will still be used, by
     * allocating any "extra" space to specific columns - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} for details on
     * controlling this behavior. <P> When this feature is enabled, autofitting is active on an ongoing basis. Autofitting will
     * be performed: <ul>  <li> whenever the dataset is completely changed or rows are added or removed  <li> whenever a field
     * which is autofitting is changed  <li> on a manual call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField
     * autoFitField()} or       {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitFields autoFitFields()} </ul>
     * Auto-fitting behavior continues until the user resizes the field manually, at which point it stops. The user can also
     * perform a one-time auto-fit of fields via the header context menu if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is enabled. <P> When autofitting to
     * column values, {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} will be
     * called to determine the space required for a field's values. This method uses values from the rendered set of rows to
     * calculate the required column width, which means the field width may still be smaller than values from non-rendered
     * rows.  See {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} having to render out the data set
     * offscreen and measure the rendered content - it does not apply for cases where this method can return a simple fixed
     * values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid. <P> Interaction with wrapping: If
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapping of cell values} is  enabled, autoFit behavior
     * based on {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach cell content} will render fields wide
     * enough to contain the <i>unwrapped</i> cell values. If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * wrapping of field titles} is enabled, when fitting to  a title, a field will render wide enough to accommodate the
     * <i>wrapped</i> title without clipping (so wide enough for the natural wrap-point / longest word or unwrappable string).
     *
     * @return Current autoFitFieldWidths value. Default value is null
     */
    public Boolean getAutoFitFieldWidths()  {
        return getAttributeAsBoolean("autoFitFieldWidths");
    }
    

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically.  This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is set to true such that you end up with
     * several lines of text - the button will render large enough to accommodate it.  If necessary this will cause the header
     * for the grid as a whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight}. <P> Note that you need not set {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight
     * HeaderSpan.height} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanHeight headerSpanHeight} if you set
     * this property, but if you do, they will be used as minimum values.
     *
     * @param autoFitHeaderHeights New autoFitHeaderHeights value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoFitHeaderHeights(Boolean autoFitHeaderHeights)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoFitHeaderHeights", autoFitHeaderHeights, false);
    }

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically.  This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is set to true such that you end up with
     * several lines of text - the button will render large enough to accommodate it.  If necessary this will cause the header
     * for the grid as a whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight}. <P> Note that you need not set {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight
     * HeaderSpan.height} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanHeight headerSpanHeight} if you set
     * this property, but if you do, they will be used as minimum values.
     *
     * @return Current autoFitHeaderHeights value. Default value is null
     */
    public Boolean getAutoFitHeaderHeights()  {
        return getAttributeAsBoolean("autoFitHeaderHeights");
    }
    

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} to be enabled by default for
     * all icon fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} set to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the
     * width required for the icons is calculated by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} which performs a simple calculation based on the specified icon width for these types of fields.
     * <P> This setting governs default behavior for icon fields - for specific fields within a grid, this default behavior can
     * be overridden by setting an explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width}
     * or explicitly enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}
     * and setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} on the field in question.
     *
     * @param autoFitIconFields New autoFitIconFields value. Default value is "title"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAutoFitFieldWidths
     */
    public ListGrid setAutoFitIconFields(AutoFitIconFieldType autoFitIconFields) {
        return (ListGrid)setAttribute("autoFitIconFields", autoFitIconFields == null ? null : autoFitIconFields.getValue(), true);
    }

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} to be enabled by default for
     * all icon fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} set to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the
     * width required for the icons is calculated by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} which performs a simple calculation based on the specified icon width for these types of fields.
     * <P> This setting governs default behavior for icon fields - for specific fields within a grid, this default behavior can
     * be overridden by setting an explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width}
     * or explicitly enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}
     * and setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} on the field in question.
     *
     * @return Current autoFitIconFields value. Default value is "title"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     */
    public AutoFitIconFieldType getAutoFitIconFields()  {
        return EnumUtil.getEnum(AutoFitIconFieldType.values(), getAttribute("autoFitIconFields"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}.
     *
     * @param autoFitMaxColumns Maximum number of fields we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled horizontally. Default value is 50
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitMaxColumns(int autoFitMaxColumns) {
        return (ListGrid)setAttribute("autoFitMaxColumns", autoFitMaxColumns, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * @return Current autoFitMaxColumns value. Default value is 50
     */
    public int getAutoFitMaxColumns()  {
        return getAttributeAsInt("autoFitMaxColumns");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}.
     *
     * @param autoFitMaxHeight Maximum height in px we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto
     * fit} is enabled vertically. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitMaxHeight(Integer autoFitMaxHeight) {
        return (ListGrid)setAttribute("autoFitMaxHeight", autoFitMaxHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * @return Current autoFitMaxHeight value. Default value is null
     */
    public Integer getAutoFitMaxHeight()  {
        return getAttributeAsInt("autoFitMaxHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}.
     *
     * @param autoFitMaxRecords Maximum number of rows we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled vertically. Default value is 50
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitMaxRecords(int autoFitMaxRecords) {
        return (ListGrid)setAttribute("autoFitMaxRecords", autoFitMaxRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * @return Current autoFitMaxRecords value. Default value is 50
     */
    public int getAutoFitMaxRecords()  {
        return getAttributeAsInt("autoFitMaxRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}.
     *
     * @param autoFitMaxWidth Width we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is
     * enabled horizontally. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitMaxWidth(Integer autoFitMaxWidth) {
        return (ListGrid)setAttribute("autoFitMaxWidth", autoFitMaxWidth, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}. Note that this method
     * always returns an integer value - autoFitMaxWidth specified as a percentage will be resolved to a pixel value before
     * being returned. Default value is null
     */
    public Integer getAutoFitMaxWidth()  {
        return getAttributeAsInt("autoFitMaxWidth");
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}.
     *
     * @param autoFitMaxWidth Width we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is
     * enabled horizontally. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitMaxWidth(String autoFitMaxWidth) {
        return (ListGrid)setAttribute("autoFitMaxWidth", autoFitMaxWidth, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}. Note that this method
     * always returns an integer value - autoFitMaxWidth specified as a percentage will be resolved to a pixel value before
     * being returned. Default value is null
     */
    public String getAutoFitMaxWidthAsString()  {
        return getAttributeAsString("autoFitMaxWidth");
    }
    

    /**
     * Should listGrids automatically size time fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type time will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth defaultTimeFieldWidth}. This static value is
     * appropriate for dates rendered with the standard time formatter. If set to <code>"title"</code> or <code>"both"</code>,
     * the drawn width of the title will be taken into account when sizing the column. <P> This is achieved by enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth:true} on date fields when this property is
     * set to anything other than <code>"none"</code>, setting the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the value
     * specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth
     * defaultTimeFieldWidth} if appropriate.
     *
     * @param autoFitTimeFields New autoFitTimeFields value. Default value is "value"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitTimeFields(AutoFitWidthApproach autoFitTimeFields) {
        return (ListGrid)setAttribute("autoFitTimeFields", autoFitTimeFields == null ? null : autoFitTimeFields.getValue(), true);
    }

    /**
     * Should listGrids automatically size time fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type time will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth defaultTimeFieldWidth}. This static value is
     * appropriate for dates rendered with the standard time formatter. If set to <code>"title"</code> or <code>"both"</code>,
     * the drawn width of the title will be taken into account when sizing the column. <P> This is achieved by enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth:true} on date fields when this property is
     * set to anything other than <code>"none"</code>, setting the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the value
     * specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth
     * defaultTimeFieldWidth} if appropriate.
     *
     * @return Current autoFitTimeFields value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitTimeFields()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitTimeFields"));
    }
    

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}.
     *
     * @param autoFitWidthApproach new AutoFitWidth approach. Default value is "value"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setAutoFitWidthApproach(AutoFitWidthApproach autoFitWidthApproach) {
        return (ListGrid)setAttribute("autoFitWidthApproach", autoFitWidthApproach == null ? null : autoFitWidthApproach.getValue(), true);
    }

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * @return Current autoFitWidthApproach value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitWidthApproach()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitWidthApproach"));
    }
    

    /**
     * Setting this property to a non-null value will enable automatic saving of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} to offline storage. This saved view state will then
     * be restored automatically when the user visits the page again. <P> <i><b>Note:</b> <a
     * href='http://www.smartclient.com/product' target='_blank'>Smart GWT Pro users</a>,  may also be interested in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSaveSearches canSaveSearches} feature. This uses the {@link
     * com.smartgwt.client.data.SavedSearches Saved Search subsystem} to allow users to explicitly store and apply multiple
     * named views or "saved searches". Each saved search includes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchStoredState full view state} for the grid by default.</i> <P>
     * <code>autoPersistViewState</code> may be set to a list of  {@link com.smartgwt.client.docs.ListGridViewState view state}
     * {@link com.smartgwt.client.types.ListGridViewStatePart parts} that should be automatically persisted into offline
     * storage when changed. <P> This feature saves the derived state whenever the grid's view state changes due to user
     * interaction (see {@link com.smartgwt.client.widgets.grid.ListGrid#addViewStateChangedHandler
     * ListGrid.viewStateChanged()}), and restores the saved state from offline storage when the grid is drawn. <P> The state
     * is saved to offline storage using the grid's {@link com.smartgwt.client.docs.AutoTestLocator locator} as the key. See
     * Locator details below. <P> Note that <code>autoPersistViewState</code> should only be set on specific listGrid
     * instances, and never as a default value for the class by changing the ListGrid defaults. Enabling this feature as a
     * default would be an invalid usage as it would apply to listgrids (and subclasses of ListGrid) created and re-used
     * internally by framework features as well as those explicitly created by application code. <P> The current saved value
     * can be retrieved or cleared by calling {@link com.smartgwt.client.widgets.grid.ListGrid#getSavedViewState
     * getSavedViewState()} or {@link com.smartgwt.client.widgets.grid.ListGrid#clearSavedViewState clearSavedViewState()}
     * respectively. <P> <b>Locator details</b> <P> The grid must have a stable locator so that previous state can be retrieved
     * during initial draw and saved back into the same place.  If the grid has an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getID ID} the locator will always be stable. Setting an explicit ID on a known parent
     * of the grid can also lead to a stable ID as described in the {@link com.smartgwt.client.docs.UsingSelenium Best
     * Practices section of Using Selenium Scripts}. <P> For purposes of this feature the top-level parent of the grid must
     * have an explicit ID. <P> Additional details on locators and their use can be found in {@link
     * com.smartgwt.client.util.AutoTest} and {@link com.smartgwt.client.types.LocatorStrategy}.
     *
     * @param autoPersistViewState New autoPersistViewState value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSavedViewState
     * @see com.smartgwt.client.widgets.grid.ListGrid#clearSavedViewState
     */
    public ListGrid setAutoPersistViewState(ListGridViewStatePart... autoPersistViewState) {
        return (ListGrid)setAttribute("autoPersistViewState", autoPersistViewState, true);
    }

    /**
     * Setting this property to a non-null value will enable automatic saving of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} to offline storage. This saved view state will then
     * be restored automatically when the user visits the page again. <P> <i><b>Note:</b> <a
     * href='http://www.smartclient.com/product' target='_blank'>Smart GWT Pro users</a>,  may also be interested in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSaveSearches canSaveSearches} feature. This uses the {@link
     * com.smartgwt.client.data.SavedSearches Saved Search subsystem} to allow users to explicitly store and apply multiple
     * named views or "saved searches". Each saved search includes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchStoredState full view state} for the grid by default.</i> <P>
     * <code>autoPersistViewState</code> may be set to a list of  {@link com.smartgwt.client.docs.ListGridViewState view state}
     * {@link com.smartgwt.client.types.ListGridViewStatePart parts} that should be automatically persisted into offline
     * storage when changed. <P> This feature saves the derived state whenever the grid's view state changes due to user
     * interaction (see {@link com.smartgwt.client.widgets.grid.ListGrid#addViewStateChangedHandler
     * ListGrid.viewStateChanged()}), and restores the saved state from offline storage when the grid is drawn. <P> The state
     * is saved to offline storage using the grid's {@link com.smartgwt.client.docs.AutoTestLocator locator} as the key. See
     * Locator details below. <P> Note that <code>autoPersistViewState</code> should only be set on specific listGrid
     * instances, and never as a default value for the class by changing the ListGrid defaults. Enabling this feature as a
     * default would be an invalid usage as it would apply to listgrids (and subclasses of ListGrid) created and re-used
     * internally by framework features as well as those explicitly created by application code. <P> The current saved value
     * can be retrieved or cleared by calling {@link com.smartgwt.client.widgets.grid.ListGrid#getSavedViewState
     * getSavedViewState()} or {@link com.smartgwt.client.widgets.grid.ListGrid#clearSavedViewState clearSavedViewState()}
     * respectively. <P> <b>Locator details</b> <P> The grid must have a stable locator so that previous state can be retrieved
     * during initial draw and saved back into the same place.  If the grid has an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getID ID} the locator will always be stable. Setting an explicit ID on a known parent
     * of the grid can also lead to a stable ID as described in the {@link com.smartgwt.client.docs.UsingSelenium Best
     * Practices section of Using Selenium Scripts}. <P> For purposes of this feature the top-level parent of the grid must
     * have an explicit ID. <P> Additional details on locators and their use can be found in {@link
     * com.smartgwt.client.util.AutoTest} and {@link com.smartgwt.client.types.LocatorStrategy}.
     *
     * @return Current autoPersistViewState value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSavedViewState
     * @see com.smartgwt.client.widgets.grid.ListGrid#clearSavedViewState
     */
    public ListGridViewStatePart[] getAutoPersistViewState()  {
        final String[] strings = getAttributeAsStringArray("autoPersistViewState");
        return EnumUtil.getEnums(ListGridViewStatePart.values(), strings, strings == null ? null : new ListGridViewStatePart[strings.length]);
    }
    

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or {@link com.smartgwt.client.types.EnterKeyEditAction hits 'Enter'} to end editing.
     * See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * saveEdits()} is called to save a particular row, or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits
     * saveAllEdits()} is called to save all changes in a batch. <P> <b>Note:</b> when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByField listGrid grouping} is enabled, or when working with
     * hierarchical data in a {@link com.smartgwt.client.widgets.tree.TreeGrid}, users have the option to hide records from
     * view by collapsing the parent folder or group. This, in conjunction with <code>autoSaveEdits</code> being set to
     * <code>false</code> can lead to a case where a user is unable to save edits due to validation errors on hidden rows.
     * Therefore we recommend developers consider having validators in place such that errors are caught and displayed to the
     * user on change or editor exit rather than being caught only when saving is attempted. If it's not possible for all
     * validation to be performed immediately  on row exit, we recommend that a different UI design be used that does not
     * involve <code>autoSaveEdits</code> being set to <code>false</code>.
     *
     * @param autoSaveEdits New autoSaveEdits value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setAutoSaveEdits(Boolean autoSaveEdits) {
        return (ListGrid)setAttribute("autoSaveEdits", autoSaveEdits, true);
    }

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or {@link com.smartgwt.client.types.EnterKeyEditAction hits 'Enter'} to end editing.
     * See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * saveEdits()} is called to save a particular row, or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits
     * saveAllEdits()} is called to save all changes in a batch. <P> <b>Note:</b> when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByField listGrid grouping} is enabled, or when working with
     * hierarchical data in a {@link com.smartgwt.client.widgets.tree.TreeGrid}, users have the option to hide records from
     * view by collapsing the parent folder or group. This, in conjunction with <code>autoSaveEdits</code> being set to
     * <code>false</code> can lead to a case where a user is unable to save edits due to validation errors on hidden rows.
     * Therefore we recommend developers consider having validators in place such that errors are caught and displayed to the
     * user on change or editor exit rather than being caught only when saving is attempted. If it's not possible for all
     * validation to be performed immediately  on row exit, we recommend that a different UI design be used that does not
     * involve <code>autoSaveEdits</code> being set to <code>false</code>.
     *
     * @return Current autoSaveEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAutoSaveEdits()  {
        Boolean result = getAttributeAsBoolean("autoSaveEdits");
        return result == null ? true : result;
    }
    

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @param autoSizeHeaderSpans New autoSizeHeaderSpans value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setAutoSizeHeaderSpans(Boolean autoSizeHeaderSpans)  throws IllegalStateException {
        return (ListGrid)setAttribute("autoSizeHeaderSpans", autoSizeHeaderSpans, false);
    }

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @return Current autoSizeHeaderSpans value. Default value is false
     */
    public Boolean getAutoSizeHeaderSpans()  {
        Boolean result = getAttributeAsBoolean("autoSizeHeaderSpans");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getShowBackgroundComponents
     * showBackgroundComponents} is <code>true</code>. <P> Canvas created and embedded in the body behind a given record.  
     * When {@link com.smartgwt.client.widgets.grid.ListGridRecord#getBackgroundComponent ListGridRecord.backgroundComponent}
     * is set, this autoChild canvas will be constructed (if listGridRecord.backgroundComponent is not already a Canvas) and
     * its properties combined with those of listGridRecord.backgroundComponent and then displayed behind a specific record in
     * the page's z-order, meaning it will only be visible if the cell styling is transparent.
     *
     * @return null
     */
    public Canvas getBackgroundComponent()  {
        return null;
    }
    

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @param badFormulaResultValue New badFormulaResultValue value. Default value is "."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public ListGrid setBadFormulaResultValue(String badFormulaResultValue) {
        return (ListGrid)setAttribute("badFormulaResultValue", badFormulaResultValue, true);
    }

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @return Current badFormulaResultValue value. Default value is "."
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public String getBadFormulaResultValue()  {
        return getAttributeAsString("badFormulaResultValue");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined with the base style to
     * generate stateful cell styles.
     *
     * @param baseStyle New baseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setBaseStyle(String baseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("baseStyle", baseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined with the base style to
     * generate stateful cell styles.
     *
     * @return Return the base styleName for this cell.  Has the following implementation by default: <ul> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle this.editFailedBaseStyle} is defined, and the     cell
     * is displaying a validation error return this value.</li> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditPendingBaseStyle this.editFailedPendingStyle} is defined, and     the
     * cell is displaying an edit value that has not yet been saved (see     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}) return this value.</li> <li>Otherwise return
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordBaseStyleProperty record[listGrid.recordBaseStyleProperty]},  
     * if defined, otherwise {@link com.smartgwt.client.widgets.grid.ListGridField#getBaseStyle field.baseStyle}.</li> </ul> If
     * no custom style is found for the cell as described above, the default baseStyle will be returned. If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is specified this will be used. Otherwise for grids
     * showing fixed height rows which match {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight
     * normalCellHeight} {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. For
     * grids with variable, or modified cell heights, {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle
     * tallBaseStyle} will be used. <P> Note also that enabling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} will cause the <code>tallBaseStyle</code>
     * to be used rather than {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle}. <P> As
     * noted under {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping}, cell content which
     * renders taller than the available space within a cell may cause rows to expand even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}  is true. This can lead to
     * misaligned rows when frozen columns are used. Developers should be aware that changing cell styling such that there is
     * increased borders or padding will reduce the available space for content within the specified cell height, making this
     * scenario more common. To fix this, specify a larger cellHeight, or set enforceVClipping to true. <p> <b>Note: This is an
     * override point.</b>. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBaseStyle()  {
        return getAttributeAsString("baseStyle");
    }
    
    

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @param bodyBackgroundColor New bodyBackgroundColor value. Default value is "white"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setBodyBackgroundColor(String bodyBackgroundColor) {
        return (ListGrid)setAttribute("bodyBackgroundColor", bodyBackgroundColor, true);
    }

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @return Current bodyBackgroundColor value. Default value is "white"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyBackgroundColor()  {
        return getAttributeAsString("bodyBackgroundColor");
    }
    

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> <b>This is a very
     * advanced setting</b> which is typically only changed by subclasses of ListGrid which never show a header.  To achieve
     * auto-fitting, instead use properties such as {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData}, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow bodyOverflow} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param bodyOverflow new overflow setting for the body. Default value is Canvas.AUTO
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public ListGrid setBodyOverflow(Overflow bodyOverflow) {
        return (ListGrid)setAttribute("bodyOverflow", bodyOverflow == null ? null : bodyOverflow.getValue(), true);
    }

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> <b>This is a very
     * advanced setting</b> which is typically only changed by subclasses of ListGrid which never show a header.  To achieve
     * auto-fitting, instead use properties such as {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData}, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * @return Current bodyOverflow value. Default value is Canvas.AUTO
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Overflow getBodyOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("bodyOverflow"));
    }
    

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName bodyStyleName} for this listGrid.
     *
     * @param bodyStyleName new body style name. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setBodyStyleName(String bodyStyleName) {
        return (ListGrid)setAttribute("bodyStyleName", bodyStyleName, true);
    }

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * @return Current bodyStyleName value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyStyleName()  {
        return getAttributeAsString("bodyStyleName");
    }
    

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanBaseStyle New booleanBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanBaseStyle(String booleanBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("booleanBaseStyle", booleanBaseStyle, false);
    }

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     *
     * @return Current booleanBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanBaseStyle()  {
        return getAttributeAsString("booleanBaseStyle");
    }
    

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage CheckboxItem.uncheckedImage}. <P>
     * <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean false" appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanFalseImage New booleanFalseImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanFalseImage(String booleanFalseImage) {
        return (ListGrid)setAttribute("booleanFalseImage", booleanFalseImage, true);
    }

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage CheckboxItem.uncheckedImage}. <P>
     * <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean false" appearance.
     *
     * @return Current booleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanFalseImage()  {
        return getAttributeAsString("booleanFalseImage");
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight CheckboxItem.valueIconHeight}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageHeight New booleanImageHeight value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanImageHeight(int booleanImageHeight) {
        return (ListGrid)setAttribute("booleanImageHeight", booleanImageHeight, true);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight CheckboxItem.valueIconHeight}.
     *
     * @return Current booleanImageHeight value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageHeight()  {
        return getAttributeAsInt("booleanImageHeight");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth CheckboxItem.valueIconWidth}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageWidth New booleanImageWidth value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanImageWidth(int booleanImageWidth) {
        return (ListGrid)setAttribute("booleanImageWidth", booleanImageWidth, true);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth CheckboxItem.valueIconWidth}.
     *
     * @return Current booleanImageWidth value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageWidth()  {
        return getAttributeAsInt("booleanImageWidth");
    }
    

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true. <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage
     * CheckboxItem.partialSelectedImage}. <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image,
     * by setting this property to a {@link com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers
     * can omit this property and instead use CSS directly in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property to provide a "boolean true"
     * appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanPartialImage New booleanPartialImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanPartialImage(String booleanPartialImage) {
        return (ListGrid)setAttribute("booleanPartialImage", booleanPartialImage, true);
    }

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true. <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage
     * CheckboxItem.partialSelectedImage}. <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image,
     * by setting this property to a {@link com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers
     * can omit this property and instead use CSS directly in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property to provide a "boolean true"
     * appearance.
     *
     * @return Current booleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanPartialImage()  {
        return getAttributeAsString("booleanPartialImage");
    }
    

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * ListGridField.suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage}. <P>
     * {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean true" appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanTrueImage New booleanTrueImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setBooleanTrueImage(String booleanTrueImage) {
        return (ListGrid)setAttribute("booleanTrueImage", booleanTrueImage, true);
    }

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * ListGridField.suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage}. <P>
     * {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean true" appearance.
     *
     * @return Current booleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanTrueImage()  {
        return getAttributeAsString("booleanTrueImage");
    }
    

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @param canAcceptDroppedRecords New canAcceptDroppedRecords value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public ListGrid setCanAcceptDroppedRecords(Boolean canAcceptDroppedRecords) {
        return (ListGrid)setAttribute("canAcceptDroppedRecords", canAcceptDroppedRecords, true);
    }

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @return Current canAcceptDroppedRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public Boolean getCanAcceptDroppedRecords()  {
        Boolean result = getAttributeAsBoolean("canAcceptDroppedRecords");
        return result == null ? false : result;
    }
    
    
    

    /**
     * Can the user perform one-time autofit for specific columns in this grid? <P> If set to true, the default header menu
     * will include options to auto fit {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitAllText all fields} such
     * that they fit their content or titles as specified via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach}.<br>
     * Autofitting of individual fields via a {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldText header
     * context menu item}, or the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}
     * will also be enabled when this property is set unless {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is explicitly set to
     * false <P> Note that the ability to perform one-time autofitting of fields via this  subsystem is separate from the
     * programmatic autofit behavior enabled  via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths}. <P> This subsystem is requires canResizeFields be enabled and will be disabled if that property is
     * set to false
     *
     * @param canAutoFitFields New canAutoFitFields value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanAutoFitFields(Boolean canAutoFitFields) {
        return (ListGrid)setAttribute("canAutoFitFields", canAutoFitFields, true);
    }

    /**
     * Can the user perform one-time autofit for specific columns in this grid? <P> If set to true, the default header menu
     * will include options to auto fit {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitAllText all fields} such
     * that they fit their content or titles as specified via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach}.<br>
     * Autofitting of individual fields via a {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldText header
     * context menu item}, or the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}
     * will also be enabled when this property is set unless {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is explicitly set to
     * false <P> Note that the ability to perform one-time autofitting of fields via this  subsystem is separate from the
     * programmatic autofit behavior enabled  via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths}. <P> This subsystem is requires canResizeFields be enabled and will be disabled if that property is
     * set to false
     *
     * @return Current canAutoFitFields value. Default value is true
     */
    public Boolean getCanAutoFitFields()  {
        Boolean result = getAttributeAsBoolean("canAutoFitFields");
        return result == null ? true : result;
    }
    

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @param cancelEditingConfirmationMessage New cancelEditingConfirmationMessage value. Default value is Cancelling this edit will discard unsaved changes for this record. Continue?
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setCancelEditingConfirmationMessage(String cancelEditingConfirmationMessage) {
        return (ListGrid)setAttribute("cancelEditingConfirmationMessage", cancelEditingConfirmationMessage, true);
    }

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @return Current cancelEditingConfirmationMessage value. Default value is Cancelling this edit will discard unsaved changes for this record. Continue?
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getCancelEditingConfirmationMessage()  {
        return getAttributeAsString("cancelEditingConfirmationMessage");
    }
    

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @param canCollapseGroup New canCollapseGroup value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setCanCollapseGroup(Boolean canCollapseGroup)  throws IllegalStateException {
        return (ListGrid)setAttribute("canCollapseGroup", canCollapseGroup, false);
    }

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @return Current canCollapseGroup value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanCollapseGroup()  {
        Boolean result = getAttributeAsBoolean("canCollapseGroup");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll, but see the discussion of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showDragHandles drag handles}. If  {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @param canDragRecordsOut New canDragRecordsOut value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public ListGrid setCanDragRecordsOut(Boolean canDragRecordsOut) {
        return (ListGrid)setAttribute("canDragRecordsOut", canDragRecordsOut, true);
    }

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll, but see the discussion of  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showDragHandles drag handles}. If  {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @return Current canDragRecordsOut value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public Boolean getCanDragRecordsOut()  {
        Boolean result = getAttributeAsBoolean("canDragRecordsOut");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically.
     * However, for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch
     * scrolling enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @param canDragSelect New canDragSelect value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public ListGrid setCanDragSelect(Boolean canDragSelect) {
        return (ListGrid)setAttribute("canDragSelect", canDragSelect, true);
    }

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically.
     * However, for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch
     * scrolling enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @return Current canDragSelect value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public Boolean getCanDragSelect()  {
        Boolean result = getAttributeAsBoolean("canDragSelect");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select text within grid rows, ready to be cliped to clipboard.<br>
     * This is mutually exclusive with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows
     * or cells by dragging}, and with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of
     * rows}. <P> To enable selecting cell text on click, see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectCellTextOnClick selectCellTextOnClick}.
     *
     * @param canDragSelectText New canDragSelectText value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setCanDragSelectText(Boolean canDragSelectText) {
        return (ListGrid)setAttribute("canDragSelectText", canDragSelectText, true);
    }

    /**
     * If this property is true, users can drag the mouse to select text within grid rows, ready to be cliped to clipboard.<br>
     * This is mutually exclusive with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows
     * or cells by dragging}, and with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of
     * rows}. <P> To enable selecting cell text on click, see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectCellTextOnClick selectCellTextOnClick}.
     *
     * @return Current canDragSelectText value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanDragSelectText()  {
        Boolean result = getAttributeAsBoolean("canDragSelectText");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @param canDropInEmptyArea New canDropInEmptyArea value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public ListGrid setCanDropInEmptyArea(Boolean canDropInEmptyArea) {
        return (ListGrid)setAttribute("canDropInEmptyArea", canDropInEmptyArea, true);
    }

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @return Current canDropInEmptyArea value. Default value is true
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public Boolean getCanDropInEmptyArea()  {
        Boolean result = getAttributeAsBoolean("canDropInEmptyArea");
        return result == null ? true : result;
    }
    

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline unless a      custom override
     * of {@link com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} allows it.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.     
     * <P>      For more information on editing, see the {@link com.smartgwt.client.docs.Editing editing overview}.
     *
     * @param canEdit New canEdit value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public ListGrid setCanEdit(Boolean canEdit) {
        return (ListGrid)setAttribute("canEdit", canEdit, true);
    }

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline unless a      custom override
     * of {@link com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} allows it.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.     
     * <P>      For more information on editing, see the {@link com.smartgwt.client.docs.Editing editing overview}.
     *
     * @return Current canEdit value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public Boolean getCanEdit()  {
        return getAttributeAsBoolean("canEdit");
    }
    

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields} array, that
     * property will be respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit FormItem.canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit ListGridField.canEdit}). Also note that individual
     * dataBoundComponents may have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} may be overridden.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canEditFieldAttribute New canEditFieldAttribute value. Default value is "canEdit"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanEditFieldAttribute(String canEditFieldAttribute)  throws IllegalStateException {
        return (ListGrid)setAttribute("canEditFieldAttribute", canEditFieldAttribute, false);
    }

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields} array, that
     * property will be respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit FormItem.canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit ListGridField.canEdit}). Also note that individual
     * dataBoundComponents may have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} may be overridden.
     *
     * @return Current canEditFieldAttribute value. Default value is "canEdit"
     */
    public String getCanEditFieldAttribute()  {
        return getAttributeAsString("canEditFieldAttribute");
    }
    

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @param canEditHilites New canEditHilites value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setCanEditHilites(boolean canEditHilites) {
        return (ListGrid)setAttribute("canEditHilites", canEditHilites, true);
    }

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @return Current canEditHilites value. Default value is false
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public boolean getCanEditHilites()  {
        Boolean result = getAttributeAsBoolean("canEditHilites");
        return result == null ? false : result;
    }
    

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles by
     * default (see {@link com.smartgwt.client.widgets.DataBoundComponent#shouldIncludeTitleInFieldState
     * DataBoundComponent.shouldIncludeTitleInFieldState()}).
     *
     * @param canEditTitles New canEditTitles value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanEditTitles(boolean canEditTitles) {
        return (ListGrid)setAttribute("canEditTitles", canEditTitles, true);
    }

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles by
     * default (see {@link com.smartgwt.client.widgets.DataBoundComponent#shouldIncludeTitleInFieldState
     * DataBoundComponent.shouldIncludeTitleInFieldState()}).
     *
     * @return Current canEditTitles value. Default value is false
     */
    public boolean getCanEditTitles()  {
        Boolean result = getAttributeAsBoolean("canEditTitles");
        return result == null ? false : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     *
     * @param canExpandMultipleRecords New canExpandMultipleRecords value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanExpandMultipleRecords(Boolean canExpandMultipleRecords) {
        return (ListGrid)setAttribute("canExpandMultipleRecords", canExpandMultipleRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     *
     * @return Current canExpandMultipleRecords value. Default value is true
     */
    public Boolean getCanExpandMultipleRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandMultipleRecords");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @param canExpandRecordProperty New canExpandRecordProperty value. Default value is "canExpand"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanExpand
     */
    public ListGrid setCanExpandRecordProperty(String canExpandRecordProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("canExpandRecordProperty", canExpandRecordProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @return Current canExpandRecordProperty value. Default value is "canExpand"
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanExpand
     */
    public String getCanExpandRecordProperty()  {
        return getAttributeAsString("canExpandRecordProperty");
    }
    

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord()} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for details on record expansion. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} is automatically enabled when
     * canExpandRecords is set to true. <P> Note that expanded records are not currently supported in conjunction with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords}
     *
     * @param canExpandRecords new value for listGrid.canExpandRecords. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanExpandRecords(Boolean canExpandRecords) {
        return (ListGrid)setAttribute("canExpandRecords", canExpandRecords, true);
    }

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord()} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for details on record expansion. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} is automatically enabled when
     * canExpandRecords is set to true. <P> Note that expanded records are not currently supported in conjunction with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * @return Current canExpandRecords value. Default value is false
     */
    public Boolean getCanExpandRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandRecords");
        return result == null ? false : result;
    }
    

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canFocusInEmptyGrid New canFocusInEmptyGrid value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanFocusInEmptyGrid(boolean canFocusInEmptyGrid)  throws IllegalStateException {
        return (ListGrid)setAttribute("canFocusInEmptyGrid", canFocusInEmptyGrid, false);
    }

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     *
     * @return Current canFocusInEmptyGrid value. Default value is true
     */
    public boolean getCanFocusInEmptyGrid()  {
        Boolean result = getAttributeAsBoolean("canFocusInEmptyGrid");
        return result == null ? true : result;
    }
    

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField unfreezeField()}. <P> Developers should also be aware that if
     * the cell content for some field exceeds the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight}, and {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping} is not set to
     * true,  this can cause misalignment between rows in frozen and unfrozen columns. See the {@link
     * com.smartgwt.client.docs.FrozenFields Frozen fields overview} for more on this.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields canFreezeFields}
     *
     * @param canFreezeFields New value for <code>listGrid.canFreezeFields</code>. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public ListGrid setCanFreezeFields(Boolean canFreezeFields) {
        return (ListGrid)setAttribute("canFreezeFields", canFreezeFields, true);
    }

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField unfreezeField()}. <P> Developers should also be aware that if
     * the cell content for some field exceeds the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight}, and {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping} is not set to
     * true,  this can cause misalignment between rows in frozen and unfrozen columns. See the {@link
     * com.smartgwt.client.docs.FrozenFields Frozen fields overview} for more on this.
     *
     * @return Current canFreezeFields value. Default value is null
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public Boolean getCanFreezeFields()  {
        return getAttributeAsBoolean("canFreezeFields");
    }
    

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @param canGroupBy New canGroupBy value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setCanGroupBy(Boolean canGroupBy) {
        return (ListGrid)setAttribute("canGroupBy", canGroupBy, true);
    }

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @return Current canGroupBy value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanGroupBy()  {
        Boolean result = getAttributeAsBoolean("canGroupBy");
        return result == null ? true : result;
    }
    

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @param canHover New canHover value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#setShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public ListGrid setCanHover(Boolean canHover) {
        return (ListGrid)setAttribute("canHover", canHover, true);
    }

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @return Current canHover value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#getShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public Boolean getCanHover()  {
        return getAttributeAsBoolean("canHover");
    }
    

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @param canMultiGroup New canMultiGroup value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanMultiGroup(boolean canMultiGroup) {
        return (ListGrid)setAttribute("canMultiGroup", canMultiGroup, true);
    }

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @return Current canMultiGroup value. Default value is false
     */
    public boolean getCanMultiGroup()  {
        Boolean result = getAttributeAsBoolean("canMultiGroup");
        return result == null ? false : result;
    }
    

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the {@link
     * com.smartgwt.client.data.DataSource#getCanMultiSort DataSource doesn't support multi-sort}, or if sorting for a field is
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is available.
     *
     * @param canMultiSort New canMultiSort value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortNumeralMenuButtonSpaceOffset
     */
    public ListGrid setCanMultiSort(Boolean canMultiSort) {
        return (ListGrid)setAttribute("canMultiSort", canMultiSort, true);
    }

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the {@link
     * com.smartgwt.client.data.DataSource#getCanMultiSort DataSource doesn't support multi-sort}, or if sorting for a field is
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is available.
     *
     * @return Current canMultiSort value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralMenuButtonSpaceOffset
     */
    public Boolean getCanMultiSort()  {
        Boolean result = getAttributeAsBoolean("canMultiSort");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide ListGridField.canHide}.
     *
     * @param canPickFields New canPickFields value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanPickFields(Boolean canPickFields) {
        return (ListGrid)setAttribute("canPickFields", canPickFields, true);
    }

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide ListGridField.canHide}.
     *
     * @return Current canPickFields value. Default value is true
     */
    public Boolean getCanPickFields()  {
        Boolean result = getAttributeAsBoolean("canPickFields");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @param canPickOmittedFields New canPickOmittedFields value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanPickOmittedFields(Boolean canPickOmittedFields)  throws IllegalStateException {
        return (ListGrid)setAttribute("canPickOmittedFields", canPickOmittedFields, false);
    }

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @return Current canPickOmittedFields value. Default value is false
     */
    public Boolean getCanPickOmittedFields()  {
        Boolean result = getAttributeAsBoolean("canPickOmittedFields");
        return result == null ? false : result;
    }
    

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick removeRecordClick()} which removes the row from the data set
     * (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()} status for the record). Individual
     * records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits saveEdits()}. Otherwise, the record will disappear from view.
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the removed
     * record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Updates the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} property for this listGrid at runtime.
     *
     * @param canRemoveRecords new canRemoveRecords value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setCanRemoveRecords(Boolean canRemoveRecords) {
        return (ListGrid)setAttribute("canRemoveRecords", canRemoveRecords, true);
    }

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick removeRecordClick()} which removes the row from the data set
     * (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()} status for the record). Individual
     * records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits saveEdits()}. Otherwise, the record will disappear from view.
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the removed
     * record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * @return Current canRemoveRecords value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getCanRemoveRecords()  {
        Boolean result = getAttributeAsBoolean("canRemoveRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.  If true, can be
     * overridden at the field level via  {@link com.smartgwt.client.widgets.grid.ListGridField#getCanReorder
     * ListGridField.canReorder}.
     *
     * @param canReorderFields New canReorderFields value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public ListGrid setCanReorderFields(Boolean canReorderFields) {
        return (ListGrid)setAttribute("canReorderFields", canReorderFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.  If true, can be
     * overridden at the field level via  {@link com.smartgwt.client.widgets.grid.ListGridField#getCanReorder
     * ListGridField.canReorder}.
     *
     * @return Current canReorderFields value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public Boolean getCanReorderFields()  {
        Boolean result = getAttributeAsBoolean("canReorderFields");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll, but see the discussion of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showDragHandles drag handles}. If  {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords canReorderRecords} attribute.
     *
     * @param canReorderRecords new value for <code>this.canReorderRecords</code>. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public ListGrid setCanReorderRecords(Boolean canReorderRecords) {
        return (ListGrid)setAttribute("canReorderRecords", canReorderRecords, true);
    }

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll, but see the discussion of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showDragHandles drag handles}. If  {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * @return Current canReorderRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public Boolean getCanReorderRecords()  {
        Boolean result = getAttributeAsBoolean("canReorderRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for updating {@link com.smartgwt.client.widgets.grid.ListGrid#getCanResizeFields canResizeFields} at runtime.
     *
     * @param canResizeFields new value for this.canResizeFields. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public ListGrid setCanResizeFields(Boolean canResizeFields) {
        return (ListGrid)setAttribute("canResizeFields", canResizeFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * @return Current canResizeFields value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public Boolean getCanResizeFields()  {
        Boolean result = getAttributeAsBoolean("canResizeFields");
        return result == null ? true : result;
    }
    

    /**
     * When enabled (the default), causes a "Saved views >" submenu to appear in the header context menu, last, allowing the
     * user to create new saved searches, select previously saved searches, and edit or copy existing searches. <p> Note that
     * disabling this feature does not mean that saved searches are disallowed - you can stil implement a separate UI via a
     * {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem} that targets this component. But, when disabled, the
     * grid-integrated menu described above will not be shown. <p> This feature uses the global settings found in {@link
     * com.smartgwt.client.data.SavedSearches}.  Some aspects can be overridden for this component.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS savedSearchDS}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchAdminRole savedSearchAdminRole}. <p> To avoid leaking local
     * storage, this setting will be disregarded, disabling the feature, unless the grid specifies {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId savedSearchId}, or an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getLocalId local or global ID} is present. <p> <b>Note:</b> this feature requires <a
     * href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
     *
     * @param canSaveSearches New canSaveSearches value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanSaveSearches(boolean canSaveSearches)  throws IllegalStateException {
        return (ListGrid)setAttribute("canSaveSearches", canSaveSearches, false);
    }

    /**
     * When enabled (the default), causes a "Saved views >" submenu to appear in the header context menu, last, allowing the
     * user to create new saved searches, select previously saved searches, and edit or copy existing searches. <p> Note that
     * disabling this feature does not mean that saved searches are disallowed - you can stil implement a separate UI via a
     * {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem} that targets this component. But, when disabled, the
     * grid-integrated menu described above will not be shown. <p> This feature uses the global settings found in {@link
     * com.smartgwt.client.data.SavedSearches}.  Some aspects can be overridden for this component.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchDS savedSearchDS}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSavedSearchAdminRole savedSearchAdminRole}. <p> To avoid leaking local
     * storage, this setting will be disregarded, disabling the feature, unless the grid specifies {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId savedSearchId}, or an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getLocalId local or global ID} is present. <p> <b>Note:</b> this feature requires <a
     * href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
     *
     * @return Current canSaveSearches value. Default value is true
     */
    public boolean getCanSaveSearches()  {
        Boolean result = getAttributeAsBoolean("canSaveSearches");
        return result == null ? true : result;
    }
    

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @param canSelectAll New canSelectAll value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setCanSelectAll(Boolean canSelectAll) {
        return (ListGrid)setAttribute("canSelectAll", canSelectAll, true);
    }

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @return Current canSelectAll value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanSelectAll()  {
        return getAttributeAsBoolean("canSelectAll");
    }
    

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. You can also use <code>canSelectCells</code> in conjunction with {@link
     * com.smartgwt.client.types.SelectionAppearance}  set to "checkbox" to complete this experience. <P> The following
     * keyboard selection behaviors are enabled with this property in addition to standard single-selection Arrow Key
     * navigation: <P> SHIFT +        [Arrow Key]:  begin or continue incremental selection <P> SHIFT + CTRL + [Arrow Key]: 
     * incremental selection to the end of row or column <P> CTRL  + A: select all cells (enabled only with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll}) <P> Incremental selection allows selection of
     * rows and columns of cells via keyboard or mouse provided the shift key is down.  Behavior is designed to match Excel.
     * Thus, if a previous selection has begun, cells will be selected from that origin. <P> Users may also navigate through
     * cells using the <i>Tab</i> and <i>Shift+Tab</i> keypresses if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs to the end of the
     * row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine
     * whether to shift selection to the next row, return to the beginning of the same row, or simply move on through the
     * page's tab order.
     *
     * @param canSelectCells New canSelectCells value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanSelectCells(Boolean canSelectCells)  throws IllegalStateException {
        return (ListGrid)setAttribute("canSelectCells", canSelectCells, false);
    }

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. You can also use <code>canSelectCells</code> in conjunction with {@link
     * com.smartgwt.client.types.SelectionAppearance}  set to "checkbox" to complete this experience. <P> The following
     * keyboard selection behaviors are enabled with this property in addition to standard single-selection Arrow Key
     * navigation: <P> SHIFT +        [Arrow Key]:  begin or continue incremental selection <P> SHIFT + CTRL + [Arrow Key]: 
     * incremental selection to the end of row or column <P> CTRL  + A: select all cells (enabled only with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll}) <P> Incremental selection allows selection of
     * rows and columns of cells via keyboard or mouse provided the shift key is down.  Behavior is designed to match Excel.
     * Thus, if a previous selection has begun, cells will be selected from that origin. <P> Users may also navigate through
     * cells using the <i>Tab</i> and <i>Shift+Tab</i> keypresses if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs to the end of the
     * row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine
     * whether to shift selection to the next row, return to the beginning of the same row, or simply move on through the
     * page's tab order.
     *
     * @return Current canSelectCells value. Default value is false
     */
    public Boolean getCanSelectCells()  {
        Boolean result = getAttributeAsBoolean("canSelectCells");
        return result == null ? false : result;
    }
    

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @param canSelectGroups New canSelectGroups value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setCanSelectGroups(boolean canSelectGroups) {
        return (ListGrid)setAttribute("canSelectGroups", canSelectGroups, true);
    }

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @return Current canSelectGroups value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public boolean getCanSelectGroups()  {
        Boolean result = getAttributeAsBoolean("canSelectGroups");
        return result == null ? false : result;
    }
    

    /**
     * Whether to allow selection of the summary row, for example by clicking on the record.  The default is to disallow it.
     * <p> If this property is set, further customization of selection can be made by applying the appropriate
     * selection-related properties to the autochild via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow
     * summaryRowProperties}.  The request to fetch the summary row(s) can be customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canSelectSummaryRows New canSelectSummaryRows value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCanSelectSummaryRows(boolean canSelectSummaryRows)  throws IllegalStateException {
        return (ListGrid)setAttribute("canSelectSummaryRows", canSelectSummaryRows, false);
    }

    /**
     * Whether to allow selection of the summary row, for example by clicking on the record.  The default is to disallow it.
     * <p> If this property is set, further customization of selection can be made by applying the appropriate
     * selection-related properties to the autochild via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow
     * summaryRowProperties}.  The request to fetch the summary row(s) can be customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}.
     *
     * @return Current canSelectSummaryRows value. Default value is false
     */
    public boolean getCanSelectSummaryRows()  {
        Boolean result = getAttributeAsBoolean("canSelectSummaryRows");
        return result == null ? false : result;
    }
    

    /**
     * Should a menu item allowing the user to show or hide the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} be displayed in  the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}? <P> Note that if this ListGrid is not
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource bound to a dataSource}  it can not be filtered. In this
     * case the context menu option to show the filterEditor will not be displayed even if  <code>canShowFilterEditor</code> is
     * true.
     *
     * @param canShowFilterEditor New canShowFilterEditor value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowFilterEditorTitle
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHideFilterEditorTitle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public ListGrid setCanShowFilterEditor(boolean canShowFilterEditor) {
        return (ListGrid)setAttribute("canShowFilterEditor", canShowFilterEditor, true);
    }

    /**
     * Should a menu item allowing the user to show or hide the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} be displayed in  the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}? <P> Note that if this ListGrid is not
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource bound to a dataSource}  it can not be filtered. In this
     * case the context menu option to show the filterEditor will not be displayed even if  <code>canShowFilterEditor</code> is
     * true.
     *
     * @return Current canShowFilterEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditorTitle
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHideFilterEditorTitle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public boolean getCanShowFilterEditor()  {
        Boolean result = getAttributeAsBoolean("canShowFilterEditor");
        return result == null ? true : result;
    }
    

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @param canSort New canSort value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCanSort(Boolean canSort) {
        return (ListGrid)setAttribute("canSort", canSort, true);
    }

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @return Current canSort value. Default value is true
     */
    public Boolean getCanSort()  {
        Boolean result = getAttributeAsBoolean("canSort");
        return result == null ? true : result;
    }
    

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if     {@link com.smartgwt.client.util.SC#setScreenReaderMode SC.setScreenReaderMode()}  is
     * called.
     *
     * @param canTabToHeader New canTabToHeader value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setCanTabToHeader(Boolean canTabToHeader)  throws IllegalStateException {
        return (ListGrid)setAttribute("canTabToHeader", canTabToHeader, false);
    }

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if     {@link com.smartgwt.client.util.SC#setScreenReaderMode SC.setScreenReaderMode()}  is
     * called.
     *
     * @return Current canTabToHeader value. Default value is null
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getCanTabToHeader()  {
        return getAttributeAsBoolean("canTabToHeader");
    }
    

    /**
     * Should the {@link com.smartgwt.client.widgets.grid.ListGrid#getSorterConstructor corner sort button} be included in the 
     * tab-order for the page?
     *
     * @param canTabToSorter New canTabToSorter value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setCanTabToSorter(Boolean canTabToSorter)  throws IllegalStateException {
        return (ListGrid)setAttribute("canTabToSorter", canTabToSorter, false);
    }

    /**
     * Should the {@link com.smartgwt.client.widgets.grid.ListGrid#getSorterConstructor corner sort button} be included in the 
     * tab-order for the page?
     *
     * @return Current canTabToSorter value. Default value is false
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getCanTabToSorter()  {
        Boolean result = getAttributeAsBoolean("canTabToSorter");
        return result == null ? false : result;
    }
    

    /**
     * The menu displayed when a cell is right clicked on.
     * <p>
     * This component is an AutoChild named "cellContextMenu".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current cellContextMenu value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Layout getCellContextMenu() throws IllegalStateException {
        errorIfNotCreated("cellContextMenu");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("cellContextMenu"));
    }
    

    /**
     * Default height for each row in pixels. See {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} and {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping} for
     * information on how rows are sized when  cell content height exceeds this specified value.
     *
     * @param cellHeight New cellHeight value. Default value is 20
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public ListGrid setCellHeight(int cellHeight) {
        return (ListGrid)setAttribute("cellHeight", cellHeight, true);
    }

    /**
     * Default height for each row in pixels. See {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} and {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping} for
     * information on how rows are sized when  cell content height exceeds this specified value.
     *
     * @return Current cellHeight value. Default value is 20
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public int getCellHeight()  {
        return getAttributeAsInt("cellHeight");
    }
    

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @param cellPadding New cellPadding value. Default value is 2
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCellPadding(int cellPadding) {
        return (ListGrid)setAttribute("cellPadding", cellPadding, true);
    }

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @return Current cellPadding value. Default value is 2
     */
    public int getCellPadding()  {
        return getAttributeAsInt("cellPadding");
    }
    

    /**
     * Returns the default WAI ARIA role for cells within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRole getCellRole()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param cellRole New cellRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setCellRole(String cellRole) {
        return (ListGrid)setAttribute("cellRole", cellRole, true);
    }

    /**
     * Returns the default WAI ARIA role for cells within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRole getCellRole()}
     *
     * @return Returns the WAI ARIA role for cells within this listGrid. <P> If the record has a value for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCellRoleProperty recordCellRoleProperty}, this will be respected.<br>
     * Otherwise if {@link com.smartgwt.client.widgets.grid.ListGrid#getCellRole cellRole} is specified, it will be used. <P>
     * If neither property is set, the default implementation will return <code>"gridcell"</code>  if this listGrid has {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole role:"grid"}, otherwise <code>null</code>, meaning no role will be
     * written out for cells. Default value is null
     */
    public String getCellRole()  {
        return getAttributeAsString("cellRole");
    }
    

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @param chartConstructor New chartConstructor value. Default value is "FacetChart"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setChartConstructor(String chartConstructor)  throws IllegalStateException {
        return (ListGrid)setAttribute("chartConstructor", chartConstructor, false);
    }

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @return Current chartConstructor value. Default value is "FacetChart"
     */
    public String getChartConstructor()  {
        return getAttributeAsString("chartConstructor");
    }
    

    /**
     * Default type of chart to plot.
     *
     * @param chartType New chartType value. Default value is "Column"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setChartType(ChartType chartType) {
        return (ListGrid)setAttribute("chartType", chartType == null ? null : chartType.getValue(), true);
    }

    /**
     * Default type of chart to plot.
     *
     * @return Current chartType value. Default value is "Column"
     */
    public ChartType getChartType()  {
        return EnumUtil.getEnum(ChartType.values(), getAttribute("chartType"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldFalseImage New checkboxFieldFalseImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setCheckboxFieldFalseImage(String checkboxFieldFalseImage) {
        return (ListGrid)setAttribute("checkboxFieldFalseImage", checkboxFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getCheckboxFieldFalseImage()  {
        return getAttributeAsString("checkboxFieldFalseImage");
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param checkboxFieldImageHeight New checkboxFieldImageHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCheckboxFieldImageHeight(Integer checkboxFieldImageHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("checkboxFieldImageHeight", checkboxFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Current checkboxFieldImageHeight value. Default value is null
     */
    public Integer getCheckboxFieldImageHeight()  {
        return getAttributeAsInt("checkboxFieldImageHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param checkboxFieldImageWidth New checkboxFieldImageWidth value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCheckboxFieldImageWidth(Integer checkboxFieldImageWidth)  throws IllegalStateException {
        return (ListGrid)setAttribute("checkboxFieldImageWidth", checkboxFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Current checkboxFieldImageWidth value. Default value is null
     */
    public Integer getCheckboxFieldImageWidth()  {
        return getAttributeAsInt("checkboxFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldPartialImage New checkboxFieldPartialImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setCheckboxFieldPartialImage(String checkboxFieldPartialImage) {
        return (ListGrid)setAttribute("checkboxFieldPartialImage", checkboxFieldPartialImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getCheckboxFieldPartialImage()  {
        return getAttributeAsString("checkboxFieldPartialImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldTrueImage New checkboxFieldTrueImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setCheckboxFieldTrueImage(String checkboxFieldTrueImage) {
        return (ListGrid)setAttribute("checkboxFieldTrueImage", checkboxFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getCheckboxFieldTrueImage()  {
        return getAttributeAsString("checkboxFieldTrueImage");
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param childExpansionMode New childExpansionMode value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setChildExpansionMode(ExpansionMode childExpansionMode) {
        return (ListGrid)setAttribute("childExpansionMode", childExpansionMode == null ? null : childExpansionMode.getValue(), true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     *
     * @return Current childExpansionMode value. Default value is null
     */
    public ExpansionMode getChildExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("childExpansionMode"));
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @param clearAllSortingText New clearAllSortingText value. Default value is "Clear All Sorting"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setClearAllSortingText(String clearAllSortingText) {
        return (ListGrid)setAttribute("clearAllSortingText", clearAllSortingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @return Current clearAllSortingText value. Default value is "Clear All Sorting"
     */
    public String getClearAllSortingText()  {
        return getAttributeAsString("clearAllSortingText");
    }
    

    /**
     * When set to false, this attribute prevents user-criteria in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} from being cleared when the user hides it.
     *
     * @param clearCriteriaOnFilterEditorHide New clearCriteriaOnFilterEditorHide value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setClearCriteriaOnFilterEditorHide(boolean clearCriteriaOnFilterEditorHide)  throws IllegalStateException {
        return (ListGrid)setAttribute("clearCriteriaOnFilterEditorHide", clearCriteriaOnFilterEditorHide, false);
    }

    /**
     * When set to false, this attribute prevents user-criteria in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} from being cleared when the user hides it.
     *
     * @return Current clearCriteriaOnFilterEditorHide value. Default value is true
     */
    public boolean getClearCriteriaOnFilterEditorHide()  {
        Boolean result = getAttributeAsBoolean("clearCriteriaOnFilterEditorHide");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @param clearFilterText New clearFilterText value. Default value is "Clear Filter"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setClearFilterText(String clearFilterText) {
        return (ListGrid)setAttribute("clearFilterText", clearFilterText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @return Current clearFilterText value. Default value is "Clear Filter"
     */
    public String getClearFilterText()  {
        return getAttributeAsString("clearFilterText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @param clearSortFieldText New clearSortFieldText value. Default value is "Clear Sort"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setClearSortFieldText(String clearSortFieldText) {
        return (ListGrid)setAttribute("clearSortFieldText", clearSortFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @return Current clearSortFieldText value. Default value is "Clear Sort"
     */
    public String getClearSortFieldText()  {
        return getAttributeAsString("clearSortFieldText");
    }
    

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * ListGridField.wrap}, and will automatically be disabled for wrapping fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param clipHeaderTitles New clipHeaderTitles value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setClipHeaderTitles(Boolean clipHeaderTitles)  throws IllegalStateException {
        return (ListGrid)setAttribute("clipHeaderTitles", clipHeaderTitles, false);
    }

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * ListGridField.wrap}, and will automatically be disabled for wrapping fields.
     *
     * @return Current clipHeaderTitles value. Default value is varies
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getClipHeaderTitles()  {
        return getAttributeAsBoolean("clipHeaderTitles");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @param collapseGroupOnRowClick New collapseGroupOnRowClick value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setCollapseGroupOnRowClick(boolean collapseGroupOnRowClick)  throws IllegalStateException {
        return (ListGrid)setAttribute("collapseGroupOnRowClick", collapseGroupOnRowClick, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @return Current collapseGroupOnRowClick value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getCollapseGroupOnRowClick()  {
        Boolean result = getAttributeAsBoolean("collapseGroupOnRowClick");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @param configureGroupingText New configureGroupingText value. Default value is "Configure Grouping..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setConfigureGroupingText(String configureGroupingText) {
        return (ListGrid)setAttribute("configureGroupingText", configureGroupingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @return Current configureGroupingText value. Default value is "Configure Grouping..."
     */
    public String getConfigureGroupingText()  {
        return getAttributeAsString("configureGroupingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiSortDialog} to configure the sort-specification for this grid.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @param configureSortText New configureSortText value. Default value is "Configure Sort..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setConfigureSortText(String configureSortText) {
        return (ListGrid)setAttribute("configureSortText", configureSortText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiSortDialog} to configure the sort-specification for this grid.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @return Current configureSortText value. Default value is "Configure Sort..."
     */
    public String getConfigureSortText()  {
        return getAttributeAsString("configureSortText");
    }
    

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @param confirmCancelEditing New confirmCancelEditing value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setConfirmCancelEditing(Boolean confirmCancelEditing) {
        return (ListGrid)setAttribute("confirmCancelEditing", confirmCancelEditing, true);
    }

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @return Current confirmCancelEditing value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmCancelEditing()  {
        Boolean result = getAttributeAsBoolean("confirmCancelEditing");
        return result == null ? false : result;
    }
    

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @param confirmDiscardEdits New confirmDiscardEdits value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setConfirmDiscardEdits(Boolean confirmDiscardEdits) {
        return (ListGrid)setAttribute("confirmDiscardEdits", confirmDiscardEdits, true);
    }

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @return Current confirmDiscardEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmDiscardEdits()  {
        Boolean result = getAttributeAsBoolean("confirmDiscardEdits");
        return result == null ? true : result;
    }
    

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @param confirmDiscardEditsMessage New confirmDiscardEditsMessage value. Default value is "This action will discard unsaved changes for this list."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setConfirmDiscardEditsMessage(String confirmDiscardEditsMessage) {
        return (ListGrid)setAttribute("confirmDiscardEditsMessage", confirmDiscardEditsMessage, true);
    }

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @return Current confirmDiscardEditsMessage value. Default value is "This action will discard unsaved changes for this list."
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getConfirmDiscardEditsMessage()  {
        return getAttributeAsString("confirmDiscardEditsMessage");
    }
    

    /**
     * The color of the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterWindowCriteriaIndicator filterWindow
     * criteria indicator}.
     *
     * @param criteriaIndicatorColor New criteriaIndicatorColor value. Default value is "#0066cc"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCriteriaIndicatorColor(String criteriaIndicatorColor)  throws IllegalStateException {
        return (ListGrid)setAttribute("criteriaIndicatorColor", criteriaIndicatorColor, false);
    }

    /**
     * The color of the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterWindowCriteriaIndicator filterWindow
     * criteria indicator}.
     *
     * @return Current criteriaIndicatorColor value. Default value is "#0066cc"
     */
    public String getCriteriaIndicatorColor()  {
        return getAttributeAsString("criteriaIndicatorColor");
    }
    

    /**
     * The color of the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterWindowCriteriaIndicator filterWindow
     * criteria indicator} when shown on the {@link com.smartgwt.client.widgets.grid.ListGrid#getSorterConstructor sorter
     * button} or the last {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor header button} in the
     * grid header. The default is to use {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteriaIndicatorColor
     * criteriaIndicatorColor}.
     *
     * @param criteriaIndicatorHeaderColor New criteriaIndicatorHeaderColor value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setCriteriaIndicatorHeaderColor(String criteriaIndicatorHeaderColor)  throws IllegalStateException {
        return (ListGrid)setAttribute("criteriaIndicatorHeaderColor", criteriaIndicatorHeaderColor, false);
    }

    /**
     * The color of the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterWindowCriteriaIndicator filterWindow
     * criteria indicator} when shown on the {@link com.smartgwt.client.widgets.grid.ListGrid#getSorterConstructor sorter
     * button} or the last {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor header button} in the
     * grid header. The default is to use {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteriaIndicatorColor
     * criteriaIndicatorColor}.
     *
     * @return Current criteriaIndicatorHeaderColor value. Default value is null
     */
    public String getCriteriaIndicatorHeaderColor()  {
        return getAttributeAsString("criteriaIndicatorHeaderColor");
    }
    

    /**
     * A list of ListGridRecord objects, specifying the data to be used to populate the ListGrid.  In ListGrids, the data array
     * specifies rows. <p> When using a {@link com.smartgwt.client.data.DataSource}, rather than directly providing
     * <code>data</code>, you will typically call {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}
     * instead, which will automatically establish <code>data</code> as a {@link com.smartgwt.client.data.ResultSet ResultSet}
     * (see the {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} docs for details). <p> If you call
     * <code>fetchData</code>, any previously supplied <code>data</code> is discarded.  Also, it is not necessary to call
     * <code>setData()</code> after calling {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}. <p> When
     * calling <code>setData()</code>, if <code>data</code> is provided as a RecordList or ResultSet, direct changes to the
     * list using Framework APIs such as {@link com.smartgwt.client.data.RecordList#add RecordList.add()} or  {@link
     * com.smartgwt.client.data.RecordList#remove RecordList.remove()} will be automatically  detected and the ListGrid will
     * redraw in response. However, direct changes to individual Records will not be automatically detected and require calls
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#refreshCell refreshCell()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#refreshRow refreshRow()} to cause the ListGrid to visually update.  Calling
     * methods such as {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} always causes automatic visual refresh.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Provides a new data set to the ListGrid after the grid has been created or drawn. The ListGrid will redraw to show the new data automatically. <P> Note that passing null will not clear {@link com.smartgwt.client.widgets.grid.ListGrid#getData data}, but will regroup it and reapply the current sort, highlighting, and summaries to the grid.  Size will be recalculated for fields marked as {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autofitWidth}:true and a {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionManager selection manager} will be created if none exists.  To clear the grid instead, pass [].
     *
     * @param data data to show in the list. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridRecord
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_inline_data" target="examples">Inline data Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_local_data" target="examples">Local data Example</a>
     */
    public ListGrid setData(ListGridRecord... data) {
        return (ListGrid)setAttribute("data", data, true);
    }
    

    /**
     * A ListGrid is a {@link com.smartgwt.client.widgets.DataBoundComponent#getDataArity dataArity}:multiple component.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dataArity New dataArity value. Default value is "multiple"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setDataArity(String dataArity) {
        return (ListGrid)setAttribute("dataArity", dataArity, true);
    }

    /**
     * A ListGrid is a {@link com.smartgwt.client.widgets.DataBoundComponent#getDataArity dataArity}:multiple component.
     *
     * @return Current dataArity value. Default value is "multiple"
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public String getDataArity()  {
        return getAttributeAsString("dataArity");
    }
    

    /**
     * Delay in milliseconds before fetching data. <P> Note: the floor value for this attribute is 1.  If you set this value to
     * zero, it will be defaulted to 1 for you instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dataFetchDelay New dataFetchDelay value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setDataFetchDelay(Integer dataFetchDelay) {
        return (ListGrid)setAttribute("dataFetchDelay", dataFetchDelay, true);
    }

    /**
     * Delay in milliseconds before fetching data. <P> Note: the floor value for this attribute is 1.  If you set this value to
     * zero, it will be defaulted to 1 for you instead.
     *
     * @return Current dataFetchDelay value. Default value is 1
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Integer getDataFetchDelay()  {
        return getAttributeAsInt("dataFetchDelay");
    }
    

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode ResultSet.fetchMode} applies.
     *
     * @param dataFetchMode New dataFetchMode value. Default value is "paged"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowAllRecords
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setDataFetchMode(FetchMode dataFetchMode)  throws IllegalStateException {
        return (ListGrid)setAttribute("dataFetchMode", dataFetchMode == null ? null : dataFetchMode.getValue(), false);
    }

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode ResultSet.fetchMode} applies.
     *
     * @return Current dataFetchMode value. Default value is "paged"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public FetchMode getDataFetchMode()  {
        return EnumUtil.getEnum(FetchMode.values(), getAttribute("dataFetchMode"));
    }
    
    
    

    /**
     * The DataSource that this component should bind to for default fields and for performing {@link
     * com.smartgwt.client.data.DSRequest DataSource requests}. <P> Can be specified as either a DataSource instance or the
     * String ID of a DataSource.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Bind to a new DataSource. <P> Like passing the "dataSource" property on creation, binding to a DataSource means that the component will use the DataSource to provide default data for its fields. <P> When binding to a new DataSource, if the component has any existing "fields" or has a dataset, these will be discarded by default, since it is assumed the new DataSource may represent a completely unrelated set of objects.  If the old "fields" are still relevant, pass them to setDataSource().
     *
     * @param dataSource DataSource to bind to. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public ListGrid setDataSource(DataSource dataSource) {
        return (ListGrid)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj(), true);
    }

    /**
     * The DataSource that this component should bind to for default fields and for performing {@link
     * com.smartgwt.client.data.DSRequest DataSource requests}. <P> Can be specified as either a DataSource instance or the
     * String ID of a DataSource.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Bind to a new DataSource. <P> Like passing the "dataSource" property on creation, binding to a DataSource means that the component will use the DataSource to provide default data for its fields. <P> When binding to a new DataSource, if the component has any existing "fields" or has a dataset, these will be discarded by default, since it is assumed the new DataSource may represent a completely unrelated set of objects.  If the old "fields" are still relevant, pass them to setDataSource().
     *
     * @param dataSource DataSource to bind to. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public ListGrid setDataSource(String dataSource) {
        return (ListGrid)setAttribute("dataSource", dataSource, true);
    }
    

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} are specified those
     * properties will take precedence over the component level settings. <P> If unset, date values will be formatted according
     * to the system wide {@link com.smartgwt.client.util.DateUtil#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields.
     * <P> If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param dateFormatter New dateFormatter value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDateFormatter(DateDisplayFormat dateFormatter) {
        return (ListGrid)setAttribute("dateFormatter", dateFormatter == null ? null : dateFormatter.getValue(), true);
    }

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} are specified those
     * properties will take precedence over the component level settings. <P> If unset, date values will be formatted according
     * to the system wide {@link com.smartgwt.client.util.DateUtil#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields.
     * <P> If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return Current dateFormatter value. Default value is null
     */
    public DateDisplayFormat getDateFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("dateFormatter"));
    }
    

    /**
     * If this is an editable listGrid, this property will specify the {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getInputFormat inputFormat} applied to editors for fields of type
     * <code>"date"</code>. May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getInputFormat ListGridField.inputFormat}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dateInputFormat New dateInputFormat value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDateFormatter
     * @see com.smartgwt.client.docs.DateInputFormat DateInputFormat 
     */
    public ListGrid setDateInputFormat(String dateInputFormat) {
        return (ListGrid)setAttribute("dateInputFormat", dateInputFormat, true);
    }
    

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat
     * DateUtil.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to
     * change the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} <P> If this field is
     * editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param datetimeFormatter New datetimeFormatter value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridField#setDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setDatetimeFormatter(DateDisplayFormat datetimeFormatter) {
        return (ListGrid)setAttribute("datetimeFormatter", datetimeFormatter == null ? null : datetimeFormatter.getValue(), true);
    }

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat
     * DateUtil.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to
     * change the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} <P> If this field is
     * editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return Current datetimeFormatter value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DateDisplayFormat getDatetimeFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("datetimeFormatter"));
    }
    

    /**
     * Default width for date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultDateFieldWidth New defaultDateFieldWidth value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDefaultDateFieldWidth(Integer defaultDateFieldWidth) {
        return (ListGrid)setAttribute("defaultDateFieldWidth", defaultDateFieldWidth, true);
    }

    /**
     * Default width for date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultDateFieldWidth value. Default value is varies
     */
    public Integer getDefaultDateFieldWidth()  {
        return getAttributeAsInt("defaultDateFieldWidth");
    }
    

    /**
     * Default width for datetime type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultDateTimeFieldWidth New defaultDateTimeFieldWidth value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDefaultDateTimeFieldWidth(Integer defaultDateTimeFieldWidth) {
        return (ListGrid)setAttribute("defaultDateTimeFieldWidth", defaultDateTimeFieldWidth, true);
    }

    /**
     * Default width for datetime type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultDateTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultDateTimeFieldWidth()  {
        return getAttributeAsInt("defaultDateTimeFieldWidth");
    }
    

    /**
     * Default width for editable date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultEditableDateFieldWidth New defaultEditableDateFieldWidth value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDefaultEditableDateFieldWidth(Integer defaultEditableDateFieldWidth) {
        return (ListGrid)setAttribute("defaultEditableDateFieldWidth", defaultEditableDateFieldWidth, true);
    }

    /**
     * Default width for editable date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultEditableDateFieldWidth value. Default value is varies
     */
    public Integer getDefaultEditableDateFieldWidth()  {
        return getAttributeAsInt("defaultEditableDateFieldWidth");
    }
    

    /**
     * Default width for editable datetime type fields. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields autoFitDateFields} for details on how this property is
     * used.
     *
     * @param defaultEditableDateTimeFieldWidth New defaultEditableDateTimeFieldWidth value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDefaultEditableDateTimeFieldWidth(Integer defaultEditableDateTimeFieldWidth) {
        return (ListGrid)setAttribute("defaultEditableDateTimeFieldWidth", defaultEditableDateTimeFieldWidth, true);
    }

    /**
     * Default width for editable datetime type fields. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields autoFitDateFields} for details on how this property is
     * used.
     *
     * @return Current defaultEditableDateTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultEditableDateTimeFieldWidth()  {
        return getAttributeAsInt("defaultEditableDateTimeFieldWidth");
    }
    

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid affecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param defaultFields New defaultFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setDefaultFields(ListGridField... defaultFields)  throws IllegalStateException {
        return (ListGrid)setAttribute("defaultFields", defaultFields, false);
    }

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid affecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     *
     * @return Current defaultFields value. Default value is null
     */
    public ListGridField[] getDefaultFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("defaultFields"));
    }
    

    /**
     * Default {@link com.smartgwt.client.types.OperatorId filter operator} to use for text-based fields in this grid's  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filter editor}, when producing {@link
     * com.smartgwt.client.data.AdvancedCriteria}.   When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are enabled for the grid, the
     * default is {@link com.smartgwt.client.data.DataSource#getTranslatePatternOperators "iContainsPattern"}.  Otherwise, the
     * default is "iContains". <p> Does not apply to special fields where exact match is obviously the right default setting,
     * such as fields of type:"enum", or fields with a {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueMap
     * valueMap} or  {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}.
     *
     * @param defaultFilterOperator New defaultFilterOperator value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setDefaultFilterOperator(OperatorId defaultFilterOperator)  throws IllegalStateException {
        return (ListGrid)setAttribute("defaultFilterOperator", defaultFilterOperator == null ? null : defaultFilterOperator.getValue(), false);
    }

    /**
     * Default {@link com.smartgwt.client.types.OperatorId filter operator} to use for text-based fields in this grid's  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filter editor}, when producing {@link
     * com.smartgwt.client.data.AdvancedCriteria}.   When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are enabled for the grid, the
     * default is {@link com.smartgwt.client.data.DataSource#getTranslatePatternOperators "iContainsPattern"}.  Otherwise, the
     * default is "iContains". <p> Does not apply to special fields where exact match is obviously the right default setting,
     * such as fields of type:"enum", or fields with a {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueMap
     * valueMap} or  {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}.
     *
     * @return Current defaultFilterOperator value. Default value is null
     */
    public OperatorId getDefaultFilterOperator()  {
        return EnumUtil.getEnum(OperatorId.values(), getAttribute("defaultFilterOperator"));
    }
    

    /**
     * Text to show after the name of the default filterOperator in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @param defaultFilterOperatorSuffix New defaultFilterOperatorSuffix value. Default value is "(default)"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setDefaultFilterOperatorSuffix(String defaultFilterOperatorSuffix)  throws IllegalStateException {
        return (ListGrid)setAttribute("defaultFilterOperatorSuffix", defaultFilterOperatorSuffix, false);
    }

    /**
     * Text to show after the name of the default filterOperator in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @return Current defaultFilterOperatorSuffix value. Default value is "(default)"
     */
    public String getDefaultFilterOperatorSuffix()  {
        return getAttributeAsString("defaultFilterOperatorSuffix");
    }
    

    /**
     * Default width for time type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultTimeFieldWidth New defaultTimeFieldWidth value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDefaultTimeFieldWidth(Integer defaultTimeFieldWidth) {
        return (ListGrid)setAttribute("defaultTimeFieldWidth", defaultTimeFieldWidth, true);
    }

    /**
     * Default width for time type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultTimeFieldWidth()  {
        return getAttributeAsInt("defaultTimeFieldWidth");
    }
    

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an icon in the
     * <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly specified by
     * this property, removal of records will be deferred if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits
     * autoSaveEdits} is false for the grid.
     *
     * @param deferRemoval New deferRemoval value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setDeferRemoval(Boolean deferRemoval)  throws IllegalStateException {
        return (ListGrid)setAttribute("deferRemoval", deferRemoval, false);
    }

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an icon in the
     * <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly specified by
     * this property, removal of records will be deferred if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits
     * autoSaveEdits} is false for the grid.
     *
     * @return Current deferRemoval value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getDeferRemoval()  {
        return getAttributeAsBoolean("deferRemoval");
    }
    

    /**
     * Should partially selected checkbox be deselected or selected on click? This setting affects {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll header selection checkbox}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups group\n checkboxes} and folder checkbox selection in a Tree
     * data set. <p> By default clicking a partially selected checkbox selects it.
     *
     * @param deselectOnPartialCheckboxClick New deselectOnPartialCheckboxClick value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setDeselectOnPartialCheckboxClick(Boolean deselectOnPartialCheckboxClick) {
        return (ListGrid)setAttribute("deselectOnPartialCheckboxClick", deselectOnPartialCheckboxClick, true);
    }

    /**
     * Should partially selected checkbox be deselected or selected on click? This setting affects {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll header selection checkbox}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups group\n checkboxes} and folder checkbox selection in a Tree
     * data set. <p> By default clicking a partially selected checkbox selects it.
     *
     * @return Current deselectOnPartialCheckboxClick value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getDeselectOnPartialCheckboxClick()  {
        Boolean result = getAttributeAsBoolean("deselectOnPartialCheckboxClick");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     *
     * @param detailDS New detailDS value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDetailDS(String detailDS) {
        return (ListGrid)setAttribute("detailDS", detailDS, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     *
     * @return Current detailDS value. Default value is null
     */
    public String getDetailDS()  {
        return getAttributeAsString("detailDS");
    }
    

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     *
     * @param detailField New detailField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDetailField(String detailField) {
        return (ListGrid)setAttribute("detailField", detailField, true);
    }

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     *
     * @return Current detailField value. Default value is null
     */
    public String getDetailField()  {
        return getAttributeAsString("detailField");
    }
    

    /**
     * Prompt to indicate that grouping is disabled as the data set size exceeds {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> This prompt will be shown as a
     * hover for the disabled {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy group by menu item}. <P> See also
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecordsExceededMessage groupByMaxRecordsExceededMessage}.
     *
     * @param disabledGroupByPrompt New disabledGroupByPrompt value. Default value is "Grouping is not supported for datasets of this size"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDisabledGroupByPrompt(String disabledGroupByPrompt) {
        return (ListGrid)setAttribute("disabledGroupByPrompt", disabledGroupByPrompt, true);
    }

    /**
     * Prompt to indicate that grouping is disabled as the data set size exceeds {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> This prompt will be shown as a
     * hover for the disabled {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy group by menu item}. <P> See also
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecordsExceededMessage groupByMaxRecordsExceededMessage}.
     *
     * @return Current disabledGroupByPrompt value. Default value is "Grouping is not supported for datasets of this size"
     */
    public String getDisabledGroupByPrompt()  {
        return getAttributeAsString("disabledGroupByPrompt");
    }
    

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits
     *
     * @param discardEditsOnHideField New discardEditsOnHideField value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDiscardEditsOnHideField(boolean discardEditsOnHideField) {
        return (ListGrid)setAttribute("discardEditsOnHideField", discardEditsOnHideField, true);
    }

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits
     *
     * @return Current discardEditsOnHideField value. Default value is true
     */
    public boolean getDiscardEditsOnHideField()  {
        Boolean result = getAttributeAsBoolean("discardEditsOnHideField");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @param discardEditsSaveButtonTitle New discardEditsSaveButtonTitle value. Default value is "Save"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setDiscardEditsSaveButtonTitle(String discardEditsSaveButtonTitle) {
        return (ListGrid)setAttribute("discardEditsSaveButtonTitle", discardEditsSaveButtonTitle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @return Current discardEditsSaveButtonTitle value. Default value is "Save"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getDiscardEditsSaveButtonTitle()  {
        return getAttributeAsString("discardEditsSaveButtonTitle");
    }
    
    

    /**
     * An automatically generated field that can be dragged to drag the current selection (where otherwise the grid itself
     * might be scrolled).  Visibility is controlled by  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowInitialDragHandles showInitialDragHandles}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showDragHandles showDragHandles()}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideDragHandles hideDragHandles()}.
     * <p>
     * This component is an AutoChild named "dragHandleField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current dragHandleField value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getDragHandleField() throws IllegalStateException {
        errorIfNotCreated("dragHandleField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("dragHandleField"));
    }
    

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field}. <P> By
     * default this title is not displayed in the drag column header button as the autochild defaults for the field set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dragHandleFieldTitle New dragHandleFieldTitle value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     */
    public ListGrid setDragHandleFieldTitle(String dragHandleFieldTitle) {
        return (ListGrid)setAttribute("dragHandleFieldTitle", dragHandleFieldTitle, true);
    }

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field}. <P> By
     * default this title is not displayed in the drag column header button as the autochild defaults for the field set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     *
     * @return Current dragHandleFieldTitle value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     */
    public String getDragHandleFieldTitle()  {
        return getAttributeAsString("dragHandleFieldTitle");
    }
    

    /**
     * Default icon to show in the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field}..
     *
     * @param dragHandleIcon New dragHandleIcon value. Default value is "[SKIN]/actions/drag.png"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setDragHandleIcon(String dragHandleIcon)  throws IllegalStateException {
        return (ListGrid)setAttribute("dragHandleIcon", dragHandleIcon, false);
    }

    /**
     * Default icon to show in the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field}..
     *
     * @return Current dragHandleIcon value. Default value is "[SKIN]/actions/drag.png"
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getDragHandleIcon()  {
        return getAttributeAsString("dragHandleIcon");
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleIcon drag handle icons} for
     * this ListGrid.
     *
     * @param dragHandleIconSize New dragHandleIconSize value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     */
    public ListGrid setDragHandleIconSize(int dragHandleIconSize) {
        return (ListGrid)setAttribute("dragHandleIconSize", dragHandleIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleIcon drag handle icons} for
     * this ListGrid.
     *
     * @return Current dragHandleIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     */
    public int getDragHandleIconSize()  {
        return getAttributeAsInt("dragHandleIconSize");
    }
    

    /**
     * Like {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}, but applies when the
     * component is being drag-scrolled (via a scrollbar).  This value is typically set higher than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} to avoid too many concurrent fetches
     * to the server for {@link com.smartgwt.client.data.ResultSet}-backed components since it's quite easy to induce such a
     * case with a scrollbar and a grid bound to a large databaset.
     *
     * @param dragScrollRedrawDelay New dragScrollRedrawDelay value. Default value is 75
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDragScrollRedrawDelay(int dragScrollRedrawDelay) {
        return (ListGrid)setAttribute("dragScrollRedrawDelay", dragScrollRedrawDelay, true);
    }

    /**
     * Like {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}, but applies when the
     * component is being drag-scrolled (via a scrollbar).  This value is typically set higher than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} to avoid too many concurrent fetches
     * to the server for {@link com.smartgwt.client.data.ResultSet}-backed components since it's quite easy to induce such a
     * case with a scrollbar and a grid bound to a large databaset.
     *
     * @return Current dragScrollRedrawDelay value. Default value is 75
     */
    public int getDragScrollRedrawDelay()  {
        return getAttributeAsInt("dragScrollRedrawDelay");
    }
    

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dragTrackerMode New dragTrackerMode value. Default value is "icon"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setDragTrackerMode(DragTrackerMode dragTrackerMode)  throws IllegalStateException {
        return (ListGrid)setAttribute("dragTrackerMode", dragTrackerMode == null ? null : dragTrackerMode.getValue(), false);
    }

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     *
     * @return Current dragTrackerMode value. Default value is "icon"
     */
    public DragTrackerMode getDragTrackerMode()  {
        return EnumUtil.getEnum(DragTrackerMode.values(), getAttribute("dragTrackerMode"));
    }
    
    

    /**
     * How far should we render records ahead of the currently visible area?  This is expressed as a ratio from viewport size
     * to rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRecords is
     * false.
     *
     * @param drawAheadRatio New drawAheadRatio value. Default value is 2.0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public ListGrid setDrawAheadRatio(float drawAheadRatio) {
        return (ListGrid)setAttribute("drawAheadRatio", drawAheadRatio, true);
    }

    /**
     * How far should we render records ahead of the currently visible area?  This is expressed as a ratio from viewport size
     * to rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRecords is
     * false.
     *
     * @return Current drawAheadRatio value. Default value is 2.0
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public float getDrawAheadRatio()  {
        return getAttributeAsFloat("drawAheadRatio");
    }
    

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param drawAllMaxCells New drawAllMaxCells value. Default value is 250
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setDrawAllMaxCells(int drawAllMaxCells) {
        return (ListGrid)setAttribute("drawAllMaxCells", drawAllMaxCells, true);
    }

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     *
     * @return Current drawAllMaxCells value. Default value is 250
     */
    public int getDrawAllMaxCells()  {
        return getAttributeAsInt("drawAllMaxCells");
    }
    

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @param editByCell New editByCell value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public ListGrid setEditByCell(Boolean editByCell) {
        return (ListGrid)setAttribute("editByCell", editByCell, true);
    }

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @return Current editByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public Boolean getEditByCell()  {
        return getAttributeAsBoolean("editByCell");
    }
    

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing startEditing()}.
     *
     * @param editEvent New editEvent value. Default value is "doubleClick"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public ListGrid setEditEvent(ListGridEditEvent editEvent) {
        return (ListGrid)setAttribute("editEvent", editEvent == null ? null : editEvent.getValue(), true);
    }

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing startEditing()}.
     *
     * @return Current editEvent value. Default value is "doubleClick"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public ListGridEditEvent getEditEvent()  {
        return EnumUtil.getEnum(ListGridEditEvent.values(), getAttribute("editEvent"));
    }
    

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedBaseStyle New editFailedBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedCSSText
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setEditFailedBaseStyle(String editFailedBaseStyle) {
        return (ListGrid)setAttribute("editFailedBaseStyle", editFailedBaseStyle, true);
    }

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     *
     * @return Current editFailedBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedCSSText
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedBaseStyle()  {
        return getAttributeAsString("editFailedBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedCSSText New editFailedCSSText value. Default value is "color:red;border:1px solid red;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setEditFailedCSSText(String editFailedCSSText) {
        return (ListGrid)setAttribute("editFailedCSSText", editFailedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     *
     * @return Current editFailedCSSText value. Default value is "color:red;border:1px solid red;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedCSSText()  {
        return getAttributeAsString("editFailedCSSText");
    }
    

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnF2Keypress New editOnF2Keypress value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setEditOnF2Keypress(Boolean editOnF2Keypress) {
        return (ListGrid)setAttribute("editOnF2Keypress", editOnF2Keypress, true);
    }

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     *
     * @return Current editOnF2Keypress value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnF2Keypress()  {
        Boolean result = getAttributeAsBoolean("editOnF2Keypress");
        return result == null ? true : result;
    }
    

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnFocus New editOnFocus value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setEditOnFocus(Boolean editOnFocus) {
        return (ListGrid)setAttribute("editOnFocus", editOnFocus, true);
    }

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     *
     * @return Current editOnFocus value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnFocus()  {
        return getAttributeAsBoolean("editOnFocus");
    }
    

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingBaseStyle New editPendingBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setEditPendingBaseStyle(String editPendingBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("editPendingBaseStyle", editPendingBaseStyle, false);
    }

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     *
     * @return Current editPendingBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingBaseStyle()  {
        return getAttributeAsString("editPendingBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingCSSText New editPendingCSSText value. Default value is "color:#0066CC;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setEditPendingCSSText(String editPendingCSSText) {
        return (ListGrid)setAttribute("editPendingCSSText", editPendingCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     *
     * @return Current editPendingCSSText value. Default value is "color:#0066CC;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingCSSText()  {
        return getAttributeAsString("editPendingCSSText");
    }
    

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @param editProxyConstructor New editProxyConstructor value. Default value is "GridEditProxy"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public ListGrid setEditProxyConstructor(String editProxyConstructor)  throws IllegalStateException {
        return (ListGrid)setAttribute("editProxyConstructor", editProxyConstructor, false);
    }

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @return Current editProxyConstructor value. Default value is "GridEditProxy"
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public String getEditProxyConstructor()  {
        return getAttributeAsString("editProxyConstructor");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectOnEdit selectOnEdit} is true, what should be the
     * edit-selection behavior be? <P> Default setting of <code>"single"</code> will cause the edit row to be automatically
     * selected and any other selection in the grid to be dropped.<br> If set to <code>"multiple"</code>, selection will be
     * additive (as a record goes  into edit mode, it is selected in addition to any pre-existant selection). <P> If set to
     * <code>null</code> behavior is as follows:<ul> <li>For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} set to <code>"simple"</code> edit rows will be
     * selected additively - this is the same behavior as if the <code>editSelectionType</code> was
     * <code>"multiple"</code></li> <li>Otherwise edit rows will be selected singly - this is the same behavior as if the
     * <code>editSelectionType</code> was <code>"single"</code></li> </ul>
     *
     * @param editSelectionType New editSelectionType value. Default value is "single"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setEditSelectionType(SelectionStyle editSelectionType) {
        return (ListGrid)setAttribute("editSelectionType", editSelectionType == null ? null : editSelectionType.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectOnEdit selectOnEdit} is true, what should be the
     * edit-selection behavior be? <P> Default setting of <code>"single"</code> will cause the edit row to be automatically
     * selected and any other selection in the grid to be dropped.<br> If set to <code>"multiple"</code>, selection will be
     * additive (as a record goes  into edit mode, it is selected in addition to any pre-existant selection). <P> If set to
     * <code>null</code> behavior is as follows:<ul> <li>For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} set to <code>"simple"</code> edit rows will be
     * selected additively - this is the same behavior as if the <code>editSelectionType</code> was
     * <code>"multiple"</code></li> <li>Otherwise edit rows will be selected singly - this is the same behavior as if the
     * <code>editSelectionType</code> was <code>"single"</code></li> </ul>
     *
     * @return Current editSelectionType value. Default value is "single"
     */
    public SelectionStyle getEditSelectionType()  {
        return EnumUtil.getEnum(SelectionStyle.values(), getAttribute("editSelectionType"));
    }
    

    /**
     * This is the pixel-amount by which child components are offset within the grid-body, by  default from the left, or from
     * the right when {@link com.smartgwt.client.util.Page#isRTL RTL} is in effect.  For {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanding rows}, this attribute is overridden by  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionIndent expansionIndent}. <P> This setting overrides the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentMargin general margin} for embedded-components, on the
     * appropriate side.
     *
     * @param embeddedComponentIndent New embeddedComponentIndent value. Default value is 25
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setEmbeddedComponentIndent(Integer embeddedComponentIndent) {
        return (ListGrid)setAttribute("embeddedComponentIndent", embeddedComponentIndent, true);
    }

    /**
     * This is the pixel-amount by which child components are offset within the grid-body, by  default from the left, or from
     * the right when {@link com.smartgwt.client.util.Page#isRTL RTL} is in effect.  For {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expanding rows}, this attribute is overridden by  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionIndent expansionIndent}. <P> This setting overrides the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentMargin general margin} for embedded-components, on the
     * appropriate side.
     *
     * @return Current embeddedComponentIndent value. Default value is 25
     */
    public Integer getEmbeddedComponentIndent()  {
        return getAttributeAsInt("embeddedComponentIndent");
    }
    

    /**
     * This is the space to apply as margin around child-components embedded in this grid.   This value is overridden on one
     * side for  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansion components} by  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionIndent expansionIndent} and in other scenarios by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentIndent embeddedComponentIndent}.
     *
     * @param embeddedComponentMargin New embeddedComponentMargin value. Default value is 0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setEmbeddedComponentMargin(Integer embeddedComponentMargin) {
        return (ListGrid)setAttribute("embeddedComponentMargin", embeddedComponentMargin, true);
    }

    /**
     * This is the space to apply as margin around child-components embedded in this grid.   This value is overridden on one
     * side for  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansion components} by  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionIndent expansionIndent} and in other scenarios by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentIndent embeddedComponentIndent}.
     *
     * @return Current embeddedComponentMargin value. Default value is 0
     */
    public Integer getEmbeddedComponentMargin()  {
        return getAttributeAsInt("embeddedComponentMargin");
    }
    

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @param emptyCellValue New emptyCellValue value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridField#setEmptyCellValue
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public ListGrid setEmptyCellValue(String emptyCellValue) {
        return (ListGrid)setAttribute("emptyCellValue", emptyCellValue, true);
    }

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @return Current emptyCellValue value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.grid.ListGridField#getEmptyCellValue
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public String getEmptyCellValue()  {
        return getAttributeAsString("emptyCellValue");
    }
    

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @param emptyMessage New emptyMessage value. Default value is "No items to show."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public ListGrid setEmptyMessage(String emptyMessage) {
        return (ListGrid)setAttribute("emptyMessage", emptyMessage, true);
    }

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @return Current emptyMessage value. Default value is "No items to show."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public String getEmptyMessage()  {
        return getAttributeAsString("emptyMessage");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @param emptyMessageStyle New emptyMessageStyle value. Default value is "emptyMessage"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setEmptyMessageStyle(String emptyMessageStyle) {
        return (ListGrid)setAttribute("emptyMessageStyle", emptyMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @return Current emptyMessageStyle value. Default value is "emptyMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getEmptyMessageStyle()  {
        return getAttributeAsString("emptyMessageStyle");
    }
    

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @param enforceVClipping New enforceVClipping value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setEnforceVClipping(Boolean enforceVClipping) {
        return (ListGrid)setAttribute("enforceVClipping", enforceVClipping, true);
    }

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @return Current enforceVClipping value. Default value is false
     */
    public Boolean getEnforceVClipping()  {
        Boolean result = getAttributeAsBoolean("enforceVClipping");
        return result == null ? false : result;
    }
    

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @param enterKeyEditAction New enterKeyEditAction value. Default value is "done"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setEnterKeyEditAction(EnterKeyEditAction enterKeyEditAction) {
        return (ListGrid)setAttribute("enterKeyEditAction", enterKeyEditAction == null ? null : enterKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @return Current enterKeyEditAction value. Default value is "done"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EnterKeyEditAction getEnterKeyEditAction()  {
        return EnumUtil.getEnum(EnterKeyEditAction.values(), getAttribute("enterKeyEditAction"));
    }
    

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @param enumCriteriaAsInitialValues New enumCriteriaAsInitialValues value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setEnumCriteriaAsInitialValues(Boolean enumCriteriaAsInitialValues)  throws IllegalStateException {
        return (ListGrid)setAttribute("enumCriteriaAsInitialValues", enumCriteriaAsInitialValues, false);
    }

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @return Current enumCriteriaAsInitialValues value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEnumCriteriaAsInitialValues()  {
        Boolean result = getAttributeAsBoolean("enumCriteriaAsInitialValues");
        return result == null ? true : result;
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconHeight New errorIconHeight value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setErrorIconHeight(Integer errorIconHeight) {
        return (ListGrid)setAttribute("errorIconHeight", errorIconHeight, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Current errorIconHeight value. Default value is 16
     */
    public Integer getErrorIconHeight()  {
        return getAttributeAsInt("errorIconHeight");
    }
    

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @param errorIconSrc New errorIconSrc value. Default value is "[SKIN]/ListGrid/validation_error_icon.png"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setErrorIconSrc(String errorIconSrc) {
        return (ListGrid)setAttribute("errorIconSrc", errorIconSrc, true);
    }

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @return Current errorIconSrc value. Default value is "[SKIN]/ListGrid/validation_error_icon.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getErrorIconSrc()  {
        return getAttributeAsString("errorIconSrc");
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconWidth New errorIconWidth value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setErrorIconWidth(Integer errorIconWidth) {
        return (ListGrid)setAttribute("errorIconWidth", errorIconWidth, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Current errorIconWidth value. Default value is 16
     */
    public Integer getErrorIconWidth()  {
        return getAttributeAsInt("errorIconWidth");
    }
    

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @param escapeKeyEditAction New escapeKeyEditAction value. Default value is "cancel"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setEscapeKeyEditAction(EscapeKeyEditAction escapeKeyEditAction) {
        return (ListGrid)setAttribute("escapeKeyEditAction", escapeKeyEditAction == null ? null : escapeKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @return Current escapeKeyEditAction value. Default value is "cancel"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EscapeKeyEditAction getEscapeKeyEditAction()  {
        return EnumUtil.getEnum(EscapeKeyEditAction.values(), getAttribute("escapeKeyEditAction"));
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionCanEdit New expansionCanEdit value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExpansionCanEdit(Boolean expansionCanEdit) {
        return (ListGrid)setAttribute("expansionCanEdit", expansionCanEdit, true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     *
     * @return Current expansionCanEdit value. Default value is null
     */
    public Boolean getExpansionCanEdit()  {
        return getAttributeAsBoolean("expansionCanEdit");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionComponentPoolingMode New expansionComponentPoolingMode value. Default value is "destroy"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExpansionComponentPoolingMode(ExpansionComponentPoolingMode expansionComponentPoolingMode) {
        return (ListGrid)setAttribute("expansionComponentPoolingMode", expansionComponentPoolingMode == null ? null : expansionComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     *
     * @return Current expansionComponentPoolingMode value. Default value is "destroy"
     */
    public ExpansionComponentPoolingMode getExpansionComponentPoolingMode()  {
        return EnumUtil.getEnum(ExpansionComponentPoolingMode.values(), getAttribute("expansionComponentPoolingMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.HTMLFlow} for displaying the contents of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailField a specified field} in a record's expanded section when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>. <P> This component is an
     * {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailFieldProperties</code> and <code>listGrid.expansionDetailFieldDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HTMLFlow getExpansionDetailField()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.HLayout} appearing in a record's expanded section when
     * {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailRelated</code>. This component
     * contains two other autoChild components, a {@link com.smartgwt.client.widgets.viewer.DetailViewer} for viewing fields
     * from the record which are not already present in the grid and a separate embedded {@link
     * com.smartgwt.client.widgets.grid.ListGrid} for displaying other data related to this record via record.detailDS.  See
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionDetails expansionDetails} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionRelated expansionRelated} for more information. <P> This component
     * is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailRelatedProperties</code> and <code>listGrid.expansionDetailRelatedDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HLayout getExpansionDetailRelated()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.viewer.DetailViewer} for displaying the details of a record
     * in its expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is
     * <code>details</code>.  Note that only those fields which do not already appear in the grid are displayed in the expanded
     * section. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailsProperties</code> and <code>listGrid.expansionDetailsDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DetailViewer getExpansionDetails()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.form.DynamicForm} for editing the details of a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>editor</code>. 
     * Note that only those fields which do not already appear in the grid will appear in the expanded section. <P> According
     * to the value of {@link com.smartgwt.client.widgets.grid.ListGrid#getShowExpansionEditorSaveButton
     * showExpansionEditorSaveButton}, a save button is shown beneath the editor.  You can save the values in the editor by
     * clicking this button <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized
     * via <code>listGrid.expansionEditorProperties</code> and <code>listGrid.expansionEditorDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DynamicForm getExpansionEditor()  {
        return null;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should the row be collapsed following a save
     * initiated by the expansion-component's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * save button}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current expansionEditorCollapseOnSave value. Default value is true
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getExpansionEditorCollapseOnSave() throws IllegalStateException {
        errorIfNotCreated("expansionEditorCollapseOnSave");
        Boolean result = getAttributeAsBoolean("expansionEditorCollapseOnSave");
        return result == null ? true : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.IButton} for saving the values in the expanded portion of a
     * ListGrid row. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionEditorSaveButtonProperties</code> and <code>listGrid.expansionEditorSaveButtonDefaults</code>.
     * <P> Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public IButton getExpansionEditorSaveButton()  {
        return null;
    }
    

    /**
     * The title for the {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * expansionEditorSaveButton}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current expansionEditorSaveButtonTitle value. Default value is "Save"
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public String getExpansionEditorSaveButtonTitle() throws IllegalStateException {
        errorIfNotCreated("expansionEditorSaveButtonTitle");
        return getAttributeAsString("expansionEditorSaveButtonTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorSaveDialogPrompt New expansionEditorSaveDialogPrompt value. Default value is "You have unsaved changes - do you want to save them now?"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionEditorSaveDialogPrompt(String expansionEditorSaveDialogPrompt)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionEditorSaveDialogPrompt", expansionEditorSaveDialogPrompt, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return Current expansionEditorSaveDialogPrompt value. Default value is "You have unsaved changes - do you want to save them now?"
     */
    public String getExpansionEditorSaveDialogPrompt()  {
        return getAttributeAsString("expansionEditorSaveDialogPrompt");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorShowSaveDialog New expansionEditorShowSaveDialog value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionEditorShowSaveDialog(Boolean expansionEditorShowSaveDialog)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionEditorShowSaveDialog", expansionEditorShowSaveDialog, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return Current expansionEditorShowSaveDialog value. Default value is null
     */
    public Boolean getExpansionEditorShowSaveDialog()  {
        return getAttributeAsBoolean("expansionEditorShowSaveDialog");
    }
    

    /**
     * The field providing the facility to expand and collapse rows.
     * <p>
     * This component is an AutoChild named "expansionField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Returns the specially generated expansion field used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true. <P> Called during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields setFields()}, this method can be overridden to add advanced dynamic
     * defaults to the expansion field (call Super, modify the default field returned by Super, return the modified field). 
     * Normal customization can be handled by just setting {@link com.smartgwt.client.types.AutoChild} properties, as mentioned
     * under the docs for {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField}. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getExpansionField() throws IllegalStateException {
        errorIfNotCreated("expansionField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("expansionField"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldFalseImage New expansionFieldFalseImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setExpansionFieldFalseImage(String expansionFieldFalseImage) {
        return (ListGrid)setAttribute("expansionFieldFalseImage", expansionFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     *
     * @return Current expansionFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getExpansionFieldFalseImage()  {
        return getAttributeAsString("expansionFieldFalseImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param expansionFieldImageHeight New expansionFieldImageHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionFieldImageHeight(Integer expansionFieldImageHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionFieldImageHeight", expansionFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Current expansionFieldImageHeight value. Default value is null
     */
    public Integer getExpansionFieldImageHeight()  {
        return getAttributeAsInt("expansionFieldImageHeight");
    }
    

    /**
     * If this grid is in RTL mode, should an "_rtl" suffix be added to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage expansionFieldTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage expansionFieldFalseImage} image URLs? This should
     * only be enabled if RTL media for the true and false expansion field images are available. <P> If both this property and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowSelected expansionFieldImageShowSelected} are
     * true, and the grid is in RTL mode, both suffixes will be applied to selected rows' expansion field images (combined as
     * "selected_rtl").
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldImageShowRTL New expansionFieldImageShowRTL value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionFieldImageShowRTL(boolean expansionFieldImageShowRTL)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionFieldImageShowRTL", expansionFieldImageShowRTL, false);
    }

    /**
     * If this grid is in RTL mode, should an "_rtl" suffix be added to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage expansionFieldTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage expansionFieldFalseImage} image URLs? This should
     * only be enabled if RTL media for the true and false expansion field images are available. <P> If both this property and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowSelected expansionFieldImageShowSelected} are
     * true, and the grid is in RTL mode, both suffixes will be applied to selected rows' expansion field images (combined as
     * "selected_rtl").
     *
     * @return Current expansionFieldImageShowRTL value. Default value is false
     */
    public boolean getExpansionFieldImageShowRTL()  {
        Boolean result = getAttributeAsBoolean("expansionFieldImageShowRTL");
        return result == null ? false : result;
    }
    

    /**
     * Should a "_selected" suffix be added to the  {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * expansionFieldTrueImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * expansionFieldFalseImage} image URLs for selected rows? <P> This allows developers to provide separate expansion field
     * media for selected rows, in case the selected row style does not contrast well with the standard expansion field image
     * media. <P> If both this property and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowRTL
     * expansionFieldImageShowRTL} are true, and the grid is in RTL mode, both suffixes will be applied to selected rows'
     * expansion field image (combined as "selected_rtl")
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldImageShowSelected New expansionFieldImageShowSelected value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionFieldImageShowSelected(boolean expansionFieldImageShowSelected)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionFieldImageShowSelected", expansionFieldImageShowSelected, false);
    }

    /**
     * Should a "_selected" suffix be added to the  {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * expansionFieldTrueImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * expansionFieldFalseImage} image URLs for selected rows? <P> This allows developers to provide separate expansion field
     * media for selected rows, in case the selected row style does not contrast well with the standard expansion field image
     * media. <P> If both this property and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowRTL
     * expansionFieldImageShowRTL} are true, and the grid is in RTL mode, both suffixes will be applied to selected rows'
     * expansion field image (combined as "selected_rtl")
     *
     * @return Current expansionFieldImageShowSelected value. Default value is false
     */
    public boolean getExpansionFieldImageShowSelected()  {
        Boolean result = getAttributeAsBoolean("expansionFieldImageShowSelected");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param expansionFieldImageWidth New expansionFieldImageWidth value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionFieldImageWidth(Integer expansionFieldImageWidth)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionFieldImageWidth", expansionFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Current expansionFieldImageWidth value. Default value is null
     */
    public Integer getExpansionFieldImageWidth()  {
        return getAttributeAsInt("expansionFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldTrueImage New expansionFieldTrueImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setExpansionFieldTrueImage(String expansionFieldTrueImage) {
        return (ListGrid)setAttribute("expansionFieldTrueImage", expansionFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     *
     * @return Current expansionFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getExpansionFieldTrueImage()  {
        return getAttributeAsString("expansionFieldTrueImage");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this is the 
     * pixel-amount by which child components are offset within the grid-body, by default from the left, or from the right when
     * {@link com.smartgwt.client.util.Page#isRTL RTL} is in effect.  If unset, assumes the width of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField}, so that child components line up with the
     * following field, according to RTL. <P> This setting overrides the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentIndent general indent} for embedded-components, on the
     * appropriate side.
     *
     * @param expansionIndent New expansionIndent value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExpansionIndent(Integer expansionIndent) {
        return (ListGrid)setAttribute("expansionIndent", expansionIndent, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this is the 
     * pixel-amount by which child components are offset within the grid-body, by default from the left, or from the right when
     * {@link com.smartgwt.client.util.Page#isRTL RTL} is in effect.  If unset, assumes the width of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField}, so that child components line up with the
     * following field, according to RTL. <P> This setting overrides the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEmbeddedComponentIndent general indent} for embedded-components, on the
     * appropriate side.
     *
     * @return Current expansionIndent value. Default value is null
     */
    public Integer getExpansionIndent()  {
        return getAttributeAsInt("expansionIndent");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.VLayout} which fills a record's expanded section and
     * contains other builtin {@link com.smartgwt.client.types.ExpansionMode expansion-components}.  You can also override
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()} to provide components of
     * your own specification. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be
     * customized via <code>listGrid.expansionLayoutProperties</code> and <code>listGrid.expansionLayoutDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public VLayout getExpansionLayout()  {
        return null;
    }
    

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true but <code>expansionMode</code> 
     * is not set, it defaults to "detailRelated" if {@link com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} is
     * set, or to  "details" otherwise.
     *
     * @param expansionMode New expansionMode value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExpansionMode(ExpansionMode expansionMode) {
        return (ListGrid)setAttribute("expansionMode", expansionMode == null ? null : expansionMode.getValue(), true);
    }

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true but <code>expansionMode</code> 
     * is not set, it defaults to "detailRelated" if {@link com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} is
     * set, or to  "details" otherwise.
     *
     * @return Current expansionMode value. Default value is null
     */
    public ExpansionMode getExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("expansionMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid} for displaying data related to a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>related</code>.
     * The {@link com.smartgwt.client.data.DataSource} containing the related data is provided by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRelatedDataSource getRelatedDataSource()} which, by default, returns the
     * DataSource referred to in {@link com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}.
     * <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionRelatedProperties</code> and <code>listGrid.expansionRelatedDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public ListGrid getExpansionRelated()  {
        return null;
    }
    

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being expanded. Be sure
     * the expansion screen meets these {@link com.smartgwt.client.widgets.Canvas#getAutoPopulateData requirements} to utilize
     * the <code>dataContext</code>.
     *
     * @param expansionScreen New expansionScreen value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExpansionScreen(String expansionScreen)  throws IllegalStateException {
        return (ListGrid)setAttribute("expansionScreen", expansionScreen, false);
    }

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being expanded. Be sure
     * the expansion screen meets these {@link com.smartgwt.client.widgets.Canvas#getAutoPopulateData requirements} to utilize
     * the <code>dataContext</code>.
     *
     * @return Current expansionScreen value. Default value is null
     */
    public String getExpansionScreen()  {
        return getAttributeAsString("expansionScreen");
    }
    

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), this property determines the delay in kicking off the filter request if the current filter
     * values are submitted by clicking the filter button or hitting return.  By default, this property is set to zero so that
     * a filter request is immediately sent.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param explicitFetchDelay New explicitFetchDelay value. Default value is 0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFetchDelay
     */
    public ListGrid setExplicitFetchDelay(int explicitFetchDelay) {
        return (ListGrid)setAttribute("explicitFetchDelay", explicitFetchDelay, true);
    }

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), this property determines the delay in kicking off the filter request if the current filter
     * values are submitted by clicking the filter button or hitting return.  By default, this property is set to zero so that
     * a filter request is immediately sent.
     *
     * @return Current explicitFetchDelay value. Default value is 0
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFetchDelay
     */
    public int getExplicitFetchDelay()  {
        return getAttributeAsInt("explicitFetchDelay");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportAlternateRowBGColor New exportAlternateRowBGColor value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public ListGrid setExportAlternateRowBGColor(String exportAlternateRowBGColor)  throws IllegalStateException {
        return (ListGrid)setAttribute("exportAlternateRowBGColor", exportAlternateRowBGColor, false);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return Current exportAlternateRowBGColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getExportAlternateRowBGColor()  {
        return getAttributeAsString("exportAlternateRowBGColor");
    }
    

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportDefaultBGColor New exportDefaultBGColor value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public ListGrid setExportDefaultBGColor(String exportDefaultBGColor)  throws IllegalStateException {
        return (ListGrid)setAttribute("exportDefaultBGColor", exportDefaultBGColor, false);
    }

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return Current exportDefaultBGColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getExportDefaultBGColor()  {
        return getAttributeAsString("exportDefaultBGColor");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether field
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal header alignments} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should be replicated in the resulting
     * spreadsheet.  <p> If this attribute is not set, cells will be assigned a default alignment by the spreadsheet, which is
     * typically right-aligned for numeric and date values, and left-aligned for  everything else (including dates and numbers
     * that have been exported as strings, as would be the case, for example, if {@link
     * com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString DSRequest.exportDatesAsFormattedString} is set)
     *
     * @param exportFieldAlignments New exportFieldAlignments value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExportFieldAlignments(boolean exportFieldAlignments) {
        return (ListGrid)setAttribute("exportFieldAlignments", exportFieldAlignments, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether field
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal header alignments} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should be replicated in the resulting
     * spreadsheet.  <p> If this attribute is not set, cells will be assigned a default alignment by the spreadsheet, which is
     * typically right-aligned for numeric and date values, and left-aligned for  everything else (including dates and numbers
     * that have been exported as strings, as would be the case, for example, if {@link
     * com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString DSRequest.exportDatesAsFormattedString} is set)
     *
     * @return Current exportFieldAlignments value. Default value is false
     */
    public boolean getExportFieldAlignments()  {
        Boolean result = getAttributeAsBoolean("exportFieldAlignments");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether widths
     * of fields should be replicated in the resulting spreadsheet. <p> Because Excel's unit of measurement for field widths is
     * based on the default system font, there is no exact way to translate field widths in pixels to Excel column widths.  The
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale exportWidthScale} property can be set to adjust
     * scaling; it's default value errs on the side of making Excel's columns slightly wider than the ListGrid field's actual
     * width to avoid clipping. <p> Note that you can switch off width export for individual fields with the  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth ListGridField.exportFieldWidth} flag.
     *
     * @param exportFieldWidths New exportFieldWidths value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExportHiddenFieldWidth
     */
    public ListGrid setExportFieldWidths(boolean exportFieldWidths) {
        return (ListGrid)setAttribute("exportFieldWidths", exportFieldWidths, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether widths
     * of fields should be replicated in the resulting spreadsheet. <p> Because Excel's unit of measurement for field widths is
     * based on the default system font, there is no exact way to translate field widths in pixels to Excel column widths.  The
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale exportWidthScale} property can be set to adjust
     * scaling; it's default value errs on the side of making Excel's columns slightly wider than the ListGrid field's actual
     * width to avoid clipping. <p> Note that you can switch off width export for individual fields with the  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth ListGridField.exportFieldWidth} flag.
     *
     * @return Current exportFieldWidths value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExportHiddenFieldWidth
     */
    public boolean getExportFieldWidths()  {
        Boolean result = getAttributeAsBoolean("exportFieldWidths");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, causes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} and {@link
     * com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding cells in
     * the spreadsheet.
     *
     * @param exportHeaderHeights New exportHeaderHeights value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExportHeaderHeights(boolean exportHeaderHeights) {
        return (ListGrid)setAttribute("exportHeaderHeights", exportHeaderHeights, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, causes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} and {@link
     * com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding cells in
     * the spreadsheet.
     *
     * @return Current exportHeaderHeights value. Default value is false
     */
    public boolean getExportHeaderHeights()  {
        Boolean result = getAttributeAsBoolean("exportHeaderHeights");
        return result == null ? false : result;
    }
    

    /**
     * Width to size non-visible fields (which may be specified with {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getExportFields exportFields} or {@link
     * com.smartgwt.client.data.DSRequest#getExportFields DSRequest.exportFields}) during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, if they have no defined numeric {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth width}.
     *
     * @param exportHiddenFieldWidth New exportHiddenFieldWidth value. Default value is 100
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExportFieldWidths
     */
    public ListGrid setExportHiddenFieldWidth(int exportHiddenFieldWidth) {
        return (ListGrid)setAttribute("exportHiddenFieldWidth", exportHiddenFieldWidth, true);
    }

    /**
     * Width to size non-visible fields (which may be specified with {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getExportFields exportFields} or {@link
     * com.smartgwt.client.data.DSRequest#getExportFields DSRequest.exportFields}) during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, if they have no defined numeric {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth width}.
     *
     * @return Current exportHiddenFieldWidth value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths
     */
    public int getExportHiddenFieldWidth()  {
        return getAttributeAsInt("exportHiddenFieldWidth");
    }
    

    /**
     * Dictates whether numeric values should be exported as raw numbers instead of formatted values when using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <P> This property is only consulted if
     * <code>exportRawValues</code> is not set to true at the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportRawValues grid} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field} level. That property causes all values,
     * including numeric values, to be exported unformatted. <P> This is useful for cases where an explicit ListGrid formatter
     * function simply displays the number as a formatted string for the user (for example "1,234"). Exporting that formatted
     * string rather than the underlying numeric value causes spreadsheet applications such as Excel to lose some
     * functionality. <P> If this property is not explicitly set, numeric values will be exported as raw numbers for {@link
     * com.smartgwt.client.data.DSRequest#getExportAs XLS and OOXML export} only. <P> May be overridden at the field level via
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawNumbers ListGridField.exportRawNumbers}.
     *
     * @param exportRawNumbers New exportRawNumbers value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExportRawNumbers(Boolean exportRawNumbers)  throws IllegalStateException {
        return (ListGrid)setAttribute("exportRawNumbers", exportRawNumbers, false);
    }

    /**
     * Dictates whether numeric values should be exported as raw numbers instead of formatted values when using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <P> This property is only consulted if
     * <code>exportRawValues</code> is not set to true at the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportRawValues grid} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field} level. That property causes all values,
     * including numeric values, to be exported unformatted. <P> This is useful for cases where an explicit ListGrid formatter
     * function simply displays the number as a formatted string for the user (for example "1,234"). Exporting that formatted
     * string rather than the underlying numeric value causes spreadsheet applications such as Excel to lose some
     * functionality. <P> If this property is not explicitly set, numeric values will be exported as raw numbers for {@link
     * com.smartgwt.client.data.DSRequest#getExportAs XLS and OOXML export} only. <P> May be overridden at the field level via
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawNumbers ListGridField.exportRawNumbers}.
     *
     * @return Current exportRawNumbers value. Default value is null
     */
    public Boolean getExportRawNumbers()  {
        return getAttributeAsBoolean("exportRawNumbers");
    }
    

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @param exportRawValues New exportRawValues value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setExportRawValues(Boolean exportRawValues)  throws IllegalStateException {
        return (ListGrid)setAttribute("exportRawValues", exportRawValues, false);
    }

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @return Current exportRawValues value. Default value is null
     */
    public Boolean getExportRawValues()  {
        return getAttributeAsBoolean("exportRawValues");
    }
    

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @param exportWidthScale New exportWidthScale value. Default value is 0.12
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExportWidthScale(double exportWidthScale) {
        return (ListGrid)setAttribute("exportWidthScale", exportWidthScale, true);
    }

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @return Current exportWidthScale value. Default value is 0.12
     */
    public double getExportWidthScale()  {
        return getAttributeAsDouble("exportWidthScale");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether titles
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid header} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p> Excel will wrap at
     * the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into your titles. <p>
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for replicating the
     * widths of fields in the exported spreadsheet.
     *
     * @param exportWrapHeaderTitles New exportWrapHeaderTitles value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setExportWrapHeaderTitles(boolean exportWrapHeaderTitles) {
        return (ListGrid)setAttribute("exportWrapHeaderTitles", exportWrapHeaderTitles, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether titles
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid header} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p> Excel will wrap at
     * the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into your titles. <p>
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for replicating the
     * widths of fields in the exported spreadsheet.
     *
     * @return Current exportWrapHeaderTitles value. Default value is false
     */
    public boolean getExportWrapHeaderTitles()  {
        Boolean result = getAttributeAsBoolean("exportWrapHeaderTitles");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note: This property only has an effect in Internet Explorer</b> <P> Advanced property to improve performance for
     * dynamic styling of gridRenderer cells in Internet Explorer, at the expense of slightly slower initial drawing, and some 
     * limitations on supported styling options. <P> <code>fastCellUpdates</code> speeds up the dynamic styling system used by
     * rollovers, selections, and custom styling that calls {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#refreshCellStyle GridRenderer.refreshCellStyle()}, at the cost of slightly
     * slower draw() and redraw() times. <P> Notes: <ul> <li>When this property is set, ListGrid cells may be styled using the 
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()} for      more information.</li> <li>If any cell
     * styles specify a a background image URL, the URL will be resolved relative     to the page location rather than the
     * location of the CSS stylesheet. This means cell     styles with a background URL should either supply a fully qualified
     * path, or the     background image media should be made available at a second location for IE.</li> <li>fastCellUpdates
     * will not work if the styles involved are in an external stylesheet loaded     from a remote host. Either the stylesheet
     * containing cell styles needs to be loaded     from the same host as the main page, or the cell styles need to be inlined
     * in the html      of the bootstrap page.</li> <li>fastCellUpdates will not work if the css styles for cells are defined
     * in     a <code>.css</code> file loaded via <code>@import</code>. Instead the <code>.css</code>     file should be loaded
     * via a <code>&lt;link ...&gt;</code> tag.</li> </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.GridRenderer#getFastCellUpdates GridRenderer.fastCellUpdates}. Has no effect in browsers other than Internet Explorer.
     *
     * @param fastCellUpdates whether to enable fastCellUpdates. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFastCellUpdates(Boolean fastCellUpdates)  throws IllegalStateException {
        return (ListGrid)setAttribute("fastCellUpdates", fastCellUpdates, false);
    }
    

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true),  and {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} are enabled, this property is the
     * delay in milliseconds between the user changing the filter and the filter request being sent to the server. If multiple
     * changes are made to the filter within this fetch delay, only the most recent will actually cause a re-filter
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fetchDelay New fetchDelay value. Default value is 300
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExplicitFetchDelay
     */
    public ListGrid setFetchDelay(int fetchDelay) {
        return (ListGrid)setAttribute("fetchDelay", fetchDelay, true);
    }

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true),  and {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} are enabled, this property is the
     * delay in milliseconds between the user changing the filter and the filter request being sent to the server. If multiple
     * changes are made to the filter within this fetch delay, only the most recent will actually cause a re-filter
     *
     * @return Current fetchDelay value. Default value is 300
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExplicitFetchDelay
     */
    public int getFetchDelay()  {
        return getAttributeAsInt("fetchDelay");
    }
    

    /**
     * The field criteria prefix to show in filter editor field hover before the descriptive version of the field's criteria,
     * if any. The descriptive text is formatted by {@link com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription
     * DataSource.getAdvancedCriteriaDescription()}.
     *
     * @param fieldCriteriaText New fieldCriteriaText value. Default value is "Field criteria:"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setFieldCriteriaText(String fieldCriteriaText)  throws IllegalStateException {
        return (ListGrid)setAttribute("fieldCriteriaText", fieldCriteriaText, false);
    }

    /**
     * The field criteria prefix to show in filter editor field hover before the descriptive version of the field's criteria,
     * if any. The descriptive text is formatted by {@link com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription
     * DataSource.getAdvancedCriteriaDescription()}.
     *
     * @return Current fieldCriteriaText value. Default value is "Field criteria:"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFieldCriteriaText()  {
        return getAttributeAsString("fieldCriteriaText");
    }
    

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen ListGridField.frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision ListGridField.decimalPrecision} respectively.
     *
     * @param fieldPickerFieldProperties New fieldPickerFieldProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFieldPickerFieldProperties(String... fieldPickerFieldProperties)  throws IllegalStateException {
        return (ListGrid)setAttribute("fieldPickerFieldProperties", fieldPickerFieldProperties, false);
    }

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen ListGridField.frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision ListGridField.decimalPrecision} respectively.
     *
     * @return Current fieldPickerFieldProperties value. Default value is null
     */
    public String[] getFieldPickerFieldProperties()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("fieldPickerFieldProperties"));
    }
    

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @param fieldPickerShowSampleValues New fieldPickerShowSampleValues value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFieldPickerShowSampleValues(Boolean fieldPickerShowSampleValues)  throws IllegalStateException {
        return (ListGrid)setAttribute("fieldPickerShowSampleValues", fieldPickerShowSampleValues, false);
    }

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @return Current fieldPickerShowSampleValues value. Default value is true
     */
    public Boolean getFieldPickerShowSampleValues()  {
        Boolean result = getAttributeAsBoolean("fieldPickerShowSampleValues");
        return result == null ? true : result;
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.FieldPickerWindow} used if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set.
     * <p>
     * This component is an AutoChild named "fieldPickerWindow".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current fieldPickerWindow value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public FieldPickerWindow getFieldPickerWindow() throws IllegalStateException {
        errorIfNotCreated("fieldPickerWindow");
        return (FieldPickerWindow)FieldPickerWindow.getByJSObject(getAttributeAsJavaScriptObject("fieldPickerWindow"));
    }
    

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets the fields array and/or field widths to newFields and sizes, respectively. <p> If newFields is specified, it is assumed that the new fields may have nothing in common with the old fields, and the component is substantially rebuilt.  Furthermore, it's invalid to modify any of the existing {@link com.smartgwt.client.widgets.grid.ListGridField}s after they've been passed to this function. Consider the following methods for more efficient, more incremental changes: {@link com.smartgwt.client.widgets.grid.ListGrid#resizeField resizeField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#reorderField reorderField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()}, or {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties setFieldProperties()}. <p> Two specific values of newFields have explicit meanings: <ul> <li>null - a newFields value of <code>null</code> indicates there are no field overrides.            All current fields are removed and, if the grid is bound to a             {@link com.smartgwt.client.data.DataSource}, the "default binding" is used. (see             {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields}).</li> <li>empty array  - providing an empty array for the            newFields indicates that no fields are desired even if a dataSource is            provided.</li> </ul>
     *
     * @param fields array of fields to draw. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public ListGrid setFields(ListGridField... fields) {
        return (ListGrid)setAttribute("fields", fields, true);
    }

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields}.
     *
     * @return Get the array of all <b>currently visible</b> fields for this ListGrid. <P> This list fields is only valid once the
     * ListGrid has been {@link com.smartgwt.client.widgets.Canvas#draw drawn} or once {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields setFields()} has been called explicitly.  If called earlier, only
     * the list of directly specified fields will be returned (the Array passed to create()). <P> This Array should be treated
     * as <b>read-only</b>.  To modify the set of visible fields, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and related APIs.  To update properties of individual
     * fields, use {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties setFieldProperties()} or more specific
     * APIs such as {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldTitle setFieldTitle()}. <P> To get the Array of
     * all fields, including fields that are not currently visible or were specified implicitly, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllFields getAllFields()}. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public ListGridField[] getFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("fields"));
    }
    

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.docs.ViewState} can be used to initialize all view properties of the grid. When doing so,
     * <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both are provided,
     * <code>fieldState</code> has priority for field state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets some presentation properties (visibility, width, userFormula and userSummary) of the listGrid fields based on the {@link com.smartgwt.client.docs.ListGridFieldState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState getFieldState()}. <P> The optional <code>isSparse</code> parameter may be passed to indicate whether the fieldState object is "sparse" - whether it includes explicit state information for hidden fields. In this case any fields defined on the component not explicitly included in the fieldState object will be hidden.<br> If <code>isSparse</code> is not explicitly passed as a parameter,  sparseness will be assumed if {@link com.smartgwt.client.widgets.DataBoundComponent#getSparseFieldState DataBoundComponent.sparseFieldState} is true.
     *
     * @param fieldState state to apply to the listGrid's fields. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ListGridFieldState ListGridFieldState 
     */
    public ListGrid setFieldState(String fieldState) {
        return (ListGrid)setAttribute("fieldState", fieldState, true);
    }

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.docs.ViewState} can be used to initialize all view properties of the grid. When doing so,
     * <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both are provided,
     * <code>fieldState</code> has priority for field state.
     *
     * @return Returns a snapshot of the current presentation of this listGrid's fields as a {@link
     * com.smartgwt.client.docs.ListGridFieldState} object. <P> This object can later be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFieldState setFieldState()} to reset this grid's fields to the current
     * state. <P> Note that the information stored includes the current width and visibility of each of this grid's fields, as
     * well as any {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddFormulaFields formula} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary fields} added by the user. <P> The optional
     * <code>sparse</code> parameter governs whether the returned field state should omit state information for hidden fields.
     * If this parameter is not passed explicitly, field state will be sparse if {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSparseFieldState DataBoundComponent.sparseFieldState} is true.<br>
     * When applying sparse field state to a component via {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldState
     * setFieldState()}, any  explicitly defined fields on the component that were not captured in the stored state object will
     * be hidden. Default value is null
     * @see com.smartgwt.client.docs.ListGridFieldState ListGridFieldState 
     */
    public String getFieldState()  {
        return getAttributeAsString("fieldState");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @param fieldVisibilitySubmenuTitle New fieldVisibilitySubmenuTitle value. Default value is "Columns"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFieldVisibilitySubmenuTitle(String fieldVisibilitySubmenuTitle) {
        return (ListGrid)setAttribute("fieldVisibilitySubmenuTitle", fieldVisibilitySubmenuTitle, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @return Current fieldVisibilitySubmenuTitle value. Default value is "Columns"
     */
    public String getFieldVisibilitySubmenuTitle()  {
        return getAttributeAsString("fieldVisibilitySubmenuTitle");
    }
    

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @param filterButtonPrompt New filterButtonPrompt value. Default value is "Filter"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFilterButtonPrompt(String filterButtonPrompt)  throws IllegalStateException {
        return (ListGrid)setAttribute("filterButtonPrompt", filterButtonPrompt, false);
    }

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @return Current filterButtonPrompt value. Default value is "Filter"
     */
    public String getFilterButtonPrompt()  {
        return getAttributeAsString("filterButtonPrompt");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @param filterButtonProperties New filterButtonProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public ListGrid setFilterButtonProperties(Button filterButtonProperties)  throws IllegalStateException {
        if (filterButtonProperties != null) {
            if (filterButtonProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setFilterButtonProperties", "Button");
            }
            filterButtonProperties.setConfigOnly(true);
        }
        JavaScriptObject config = filterButtonProperties == null ? null : filterButtonProperties.getConfig();
        return (ListGrid)setAttribute("filterButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @return Current filterButtonProperties value. Default value is null
     */
    public Button getFilterButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterButtonProperties"));
        return properties;
    }
    

    /**
     * If we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, should this
     * list be filtered every time the user changes edit values for particular cells rather than waiting for an Enter keypress
     * or a click on the filterEditor submit button. <P> Note that by default fields in the filter editor will be set to 
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getChangeOnKeypress changeOnKeypress:false}, so the grid will
     * not filter as the user types in text-based items.<br> To enable filtering as the user types in text fields, we recommend
     * the  {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} attribute. Also note that
     * <code>filterOnKeypress:true</code> implies filtering will occur on change to edit values for cells, even if
     * <code>filterByCell</code> is not set to true.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterByCell New filterByCell value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFetchDelay
     */
    public ListGrid setFilterByCell(boolean filterByCell) {
        return (ListGrid)setAttribute("filterByCell", filterByCell, true);
    }

    /**
     * If we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, should this
     * list be filtered every time the user changes edit values for particular cells rather than waiting for an Enter keypress
     * or a click on the filterEditor submit button. <P> Note that by default fields in the filter editor will be set to 
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getChangeOnKeypress changeOnKeypress:false}, so the grid will
     * not filter as the user types in text-based items.<br> To enable filtering as the user types in text fields, we recommend
     * the  {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} attribute. Also note that
     * <code>filterOnKeypress:true</code> implies filtering will occur on change to edit values for cells, even if
     * <code>filterByCell</code> is not set to true.
     *
     * @return Current filterByCell value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFetchDelay
     */
    public boolean getFilterByCell()  {
        Boolean result = getAttributeAsBoolean("filterByCell");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is set to true, the
     * <code>filterEditor</code> is automatically created as an AutoChild. <P> The filterEditor autoChild is a {@link
     * com.smartgwt.client.widgets.grid.RecordEditor} - essentially it is a specialized listGrid in edit mode for editing a
     * single set of values to be used as criteria. Once created,  developers may access it and use standard listGrid APIs to
     * interact with it. For example, given a listGrid <i><code>myListGrid</code></i>, live edit items could be accessed
     * via<br>   <code> myListGrid.getFilterEditor().getEditFormItem(someFieldName); </code>  <P> Developers may configure the
     * AutoChild using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorProperties filterEditorProperties}.
     * <p>
     * This component is an AutoChild named "filterEditor".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterEditor value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.widgets.grid.events.FilterEditorSubmitEvent
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell
     */
    public RecordEditor getFilterEditor() throws IllegalStateException {
        errorIfNotCreated("filterEditor");
        return (RecordEditor)RecordEditor.getByJSObject(getAttributeAsJavaScriptObject("filterEditor"));
    }
    

    /**
     * Height for the filterEditor, if shown.
     *
     * @param filterEditorHeight New filterEditorHeight value. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFilterEditorHeight(int filterEditorHeight) {
        return (ListGrid)setAttribute("filterEditorHeight", filterEditorHeight, true);
    }

    /**
     * Height for the filterEditor, if shown.
     *
     * @return Current filterEditorHeight value. Default value is 22
     */
    public int getFilterEditorHeight()  {
        return getAttributeAsInt("filterEditorHeight");
    }
    

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @param filterEditorProperties New filterEditorProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public ListGrid setFilterEditorProperties(RecordEditor filterEditorProperties)  throws IllegalStateException {
        if (filterEditorProperties != null) {
            if (filterEditorProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setFilterEditorProperties", "RecordEditor");
            }
            filterEditorProperties.setConfigOnly(true);
        }
        JavaScriptObject config = filterEditorProperties == null ? null : filterEditorProperties.getConfig();
        return (ListGrid)setAttribute("filterEditorProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @return Current filterEditorProperties value. Default value is null
     */
    public RecordEditor getFilterEditorProperties()  {
        RecordEditor properties = new RecordEditor();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterEditorProperties"));
        return properties;
    }
    

    /**
     * Causes filtering to be performed against the local data set, even when a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is provided. <p> When using this mode, data must be
     * provided to the grid via {@link com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as  
     * a RecordList.   <p> Note that a {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} must be
     * provided for filtering to occur even when filtering locally. <P> If this property is set to true, the supplied data is
     * applied as the  {@link com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link
     * com.smartgwt.client.data.ResultSet}, which is then  filtered according to the specified criteria, and the results
     * displayed. If false, a  normal databound fetch will occur, retrieving records that match the specified criteria  from
     * this component's {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <p>
     * <code>filterLocalData</code> includes both calls to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * fetchData()} and {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} as well as automatic
     * filtering when the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} is enabled. <p> If
     * this property is not explicitly set, default behavior will filter against the dataSource unless the grid has a specified
     * {@link com.smartgwt.client.docs.DataPath dataPath}, in which case filtering will occur locally. <p> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} to cause saves to ignore the DataSource and affect
     * the local data set only.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterLocalData New filterLocalData value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFilterLocalData(Boolean filterLocalData)  throws IllegalStateException {
        return (ListGrid)setAttribute("filterLocalData", filterLocalData, false);
    }

    /**
     * Causes filtering to be performed against the local data set, even when a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is provided. <p> When using this mode, data must be
     * provided to the grid via {@link com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as  
     * a RecordList.   <p> Note that a {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} must be
     * provided for filtering to occur even when filtering locally. <P> If this property is set to true, the supplied data is
     * applied as the  {@link com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link
     * com.smartgwt.client.data.ResultSet}, which is then  filtered according to the specified criteria, and the results
     * displayed. If false, a  normal databound fetch will occur, retrieving records that match the specified criteria  from
     * this component's {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <p>
     * <code>filterLocalData</code> includes both calls to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * fetchData()} and {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} as well as automatic
     * filtering when the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} is enabled. <p> If
     * this property is not explicitly set, default behavior will filter against the dataSource unless the grid has a specified
     * {@link com.smartgwt.client.docs.DataPath dataPath}, in which case filtering will occur locally. <p> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} to cause saves to ignore the DataSource and affect
     * the local data set only.
     *
     * @return Current filterLocalData value. Default value is null
     */
    public Boolean getFilterLocalData()  {
        return getAttributeAsBoolean("filterLocalData");
    }
    

    /**
     * If we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, should this
     * list be filtered for every keypress within the filter editor fields? <P> This is equivalent to setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} to true and explicitly setting {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getChangeOnKeypress FormItem.changeOnKeypress} to true for each
     * text-based field within the {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * ListGridField.filterEditorProperties}. <P>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterOnKeypress New filterOnKeypress value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFetchDelay
     */
    public ListGrid setFilterOnKeypress(boolean filterOnKeypress) {
        return (ListGrid)setAttribute("filterOnKeypress", filterOnKeypress, true);
    }

    /**
     * If we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, should this
     * list be filtered for every keypress within the filter editor fields? <P> This is equivalent to setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} to true and explicitly setting {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getChangeOnKeypress FormItem.changeOnKeypress} to true for each
     * text-based field within the {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * ListGridField.filterEditorProperties}. <P>
     *
     * @return Current filterOnKeypress value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFetchDelay
     */
    public boolean getFilterOnKeypress()  {
        Boolean result = getAttributeAsBoolean("filterOnKeypress");
        return result == null ? false : result;
    }
    

    /**
     * Text for the menu item shown in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * headerContextMenu} when {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators}
     * is enabled.
     *
     * @param filterUsingText New filterUsingText value. Default value is "Filter using"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setFilterUsingText(String filterUsingText)  throws IllegalStateException {
        return (ListGrid)setAttribute("filterUsingText", filterUsingText, false);
    }

    /**
     * Text for the menu item shown in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * headerContextMenu} when {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators}
     * is enabled.
     *
     * @return Current filterUsingText value. Default value is "Filter using"
     */
    public String getFilterUsingText()  {
        return getAttributeAsString("filterUsingText");
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.Window} used to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showFilterWindow show} the
     *  {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowFilter FilterBuilder}.
     *  <p>
     *  For a discussion of the various filtering and criteria-management APIs and when to use 
     *  them, see the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}.
     *  <p>
     *  By default the <code>FilterBuilder</code> shows with the top operator selection as a
     *  radio group and allows switching between simple and advanced modes. These defaults can
     *  be changed using {@link com.smartgwt.client.docs.AutoChildUsage autoChild} features such as setting
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowFilter filterWindowFilter} properties on a grid instance
     * or globally
     *  by changing the <code>ListGrid</code> defaults.
     *  <p>
     *  
     *  
     *  For example, to always use advanced mode on a single grid:
     *  <pre>
     *  FilterBuilder filterBuilderProperties = new FilterBuilder();          
     *  filterBuilderProperties.setTopOperatorAppearance(TopOperatorAppearance.BRACKET);
     *  filterBuilderProperties.setShowModeSwitcher(false);
     * 
     *  ListGrid listGrid = new ListGrid();
     *  listGrid.setAutoChildProperties("filterWindowFilter", filterBuilderProperties);
     *  </pre>
     *  or to always use advanced mode: 
     *  <pre>
     *  ListGrid.changeAutoChildDefaults("filterWindowFilter", filterBuilderProperties);
     *  </pre>
     * 
     * <p>
     * This component is an AutoChild named "filterWindow".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterWindow value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Window getFilterWindow() throws IllegalStateException {
        errorIfNotCreated("filterWindow");
        return (Window)Window.getByJSObject(getAttributeAsJavaScriptObject("filterWindow"));
    }
    

    /**
     * Advanced filtering criteria, either {@link com.smartgwt.client.data.Criteria simple} or {@link
     * com.smartgwt.client.data.AdvancedCriteria advanced}, that is combined with the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria filter editor criteria} during filtering. <P> This
     * criteria is normally configured via {@link com.smartgwt.client.widgets.grid.ListGrid#showFilterWindow advanced filtering
     * dialog} shown because of the {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow}
     * option but can be assigned directly as well. <p> For a discussion of the various filtering and criteria-management APIs
     * and when to use  them, see the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria filterWindowCriteria}.
     *
     * @param filterWindowCriteria criteria for advanced filtering. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFilterWindowCriteria(Criteria filterWindowCriteria) {
        if (filterWindowCriteria instanceof Criterion) {
            filterWindowCriteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        return (ListGrid)setAttribute("filterWindowCriteria", filterWindowCriteria == null ? null : filterWindowCriteria.getJsObj(), true);
    }

    /**
     * Advanced filtering criteria, either {@link com.smartgwt.client.data.Criteria simple} or {@link
     * com.smartgwt.client.data.AdvancedCriteria advanced}, that is combined with the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria filter editor criteria} during filtering. <P> This
     * criteria is normally configured via {@link com.smartgwt.client.widgets.grid.ListGrid#showFilterWindow advanced filtering
     * dialog} shown because of the {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow allowFilterWindow}
     * option but can be assigned directly as well. <p> For a discussion of the various filtering and criteria-management APIs
     * and when to use  them, see the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}.
     *
     * @return Returns the current {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria filterWindowCriteria}. Default value is null
     */
    public Criteria getFilterWindowCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("filterWindowCriteria"));
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.Canvas} used to show visual indicator that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria filterWindowCriteria} is configured. {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowFilterWindowCriteriaIndicator showFilterWindowCriteriaIndicator} must
     * be enabled to show indicator.
     * <p>
     * This component is an AutoChild named "filterWindowCriteriaIndicator".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterWindowCriteriaIndicator value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Canvas getFilterWindowCriteriaIndicator() throws IllegalStateException {
        errorIfNotCreated("filterWindowCriteriaIndicator");
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("filterWindowCriteriaIndicator"));
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.form.FilterBuilder} shown in {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterWindow filterWindow} by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showFilterWindow showFilterWindow()}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterWindow filterWindow} for more information on the filter defaults and
     * changing them.
     * <p>
     * This component is an AutoChild named "filterWindowFilter".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterWindowFilter value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public FilterBuilder getFilterWindowFilter() throws IllegalStateException {
        errorIfNotCreated("filterWindowFilter");
        return (FilterBuilder)FilterBuilder.getByJSObject(getAttributeAsJavaScriptObject("filterWindowFilter"));
    }
    

    /**
     * The instruction text to display at the top of the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindow
     * filterWindow}.
     *
     * @param filterWindowInstructions New filterWindowInstructions value. Default value is "Enter criteria below. These criteria are &lt;i&gt;in addition to&lt;/i&gt; any criteria entered in the filter immediately above column headers."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setFilterWindowInstructions(String filterWindowInstructions)  throws IllegalStateException {
        return (ListGrid)setAttribute("filterWindowInstructions", filterWindowInstructions, false);
    }

    /**
     * The instruction text to display at the top of the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindow
     * filterWindow}.
     *
     * @return Current filterWindowInstructions value. Default value is "Enter criteria below. These criteria are &lt;i&gt;in addition to&lt;/i&gt; any criteria entered in the filter immediately above column headers."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFilterWindowInstructions()  {
        return getAttributeAsString("filterWindowInstructions");
    }
    

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedFieldWidths New fixedFieldWidths value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFixedFieldWidths(Boolean fixedFieldWidths) {
        return (ListGrid)setAttribute("fixedFieldWidths", fixedFieldWidths, true);
    }

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     *
     * @return Current fixedFieldWidths value. Default value is true
     */
    public Boolean getFixedFieldWidths()  {
        Boolean result = getAttributeAsBoolean("fixedFieldWidths");
        return result == null ? true : result;
    }
    

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * CubeGrid.autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content
     * (such as images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedRecordHeights New fixedRecordHeights value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public ListGrid setFixedRecordHeights(Boolean fixedRecordHeights) {
        return (ListGrid)setAttribute("fixedRecordHeights", fixedRecordHeights, true);
    }

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * CubeGrid.autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content
     * (such as images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     *
     * @return Current fixedRecordHeights value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public Boolean getFixedRecordHeights()  {
        Boolean result = getAttributeAsBoolean("fixedRecordHeights");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @param formulaBuilderSpanTitleSeparator New formulaBuilderSpanTitleSeparator value. Default value is " - "
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFormulaBuilderSpanTitleSeparator(String formulaBuilderSpanTitleSeparator) {
        return (ListGrid)setAttribute("formulaBuilderSpanTitleSeparator", formulaBuilderSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @return Current formulaBuilderSpanTitleSeparator value. Default value is " - "
     */
    public String getFormulaBuilderSpanTitleSeparator()  {
        return getAttributeAsString("formulaBuilderSpanTitleSeparator");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param freezeFieldText New freezeFieldText value. Default value is "Freeze ${title}"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setFreezeFieldText(String freezeFieldText) {
        return (ListGrid)setAttribute("freezeFieldText", freezeFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     *
     * @return Current freezeFieldText value. Default value is "Freeze ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFreezeFieldText()  {
        return getAttributeAsString("freezeFieldText");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @param frozenBaseStyle New frozenBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setFrozenBaseStyle(String frozenBaseStyle) {
        return (ListGrid)setAttribute("frozenBaseStyle", frozenBaseStyle, true);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getFrozenBaseStyle()  {
        return getAttributeAsString("frozenBaseStyle");
    }
    

    /**
     * Maximum width available for any {@link com.smartgwt.client.docs.FrozenFields frozen fields} shown  in this grid. May be
     * specified as a percentage or numeric pixel value. <P> If the frozen fields' combined width exceeds this value, a
     * horizontal scrollbar will be shown, allowing the frozen fields to be horizontally scrolled (independently from the
     * unfrozen fields).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenFieldsMaxWidth frozenFieldsMaxWidth} attribute
     *
     * @param frozenFieldsMaxWidth new maximum width for frozen fields. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFrozenFieldsMaxWidth(String frozenFieldsMaxWidth) {
        return (ListGrid)setAttribute("frozenFieldsMaxWidth", frozenFieldsMaxWidth, true);
    }

    /**
     * Maximum width available for any {@link com.smartgwt.client.docs.FrozenFields frozen fields} shown  in this grid. May be
     * specified as a percentage or numeric pixel value. <P> If the frozen fields' combined width exceeds this value, a
     * horizontal scrollbar will be shown, allowing the frozen fields to be horizontally scrolled (independently from the
     * unfrozen fields).
     *
     * @return Current frozenFieldsMaxWidth value. Default value is null
     */
    public String getFrozenFieldsMaxWidth()  {
        return getAttributeAsString("frozenFieldsMaxWidth");
    }

    /**
     * Maximum width available for any {@link com.smartgwt.client.docs.FrozenFields frozen fields} shown  in this grid. May be
     * specified as a percentage or numeric pixel value. <P> If the frozen fields' combined width exceeds this value, a
     * horizontal scrollbar will be shown, allowing the frozen fields to be horizontally scrolled (independently from the
     * unfrozen fields).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenFieldsMaxWidth frozenFieldsMaxWidth} attribute
     *
     * @param frozenFieldsMaxWidth new maximum width for frozen fields. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setFrozenFieldsMaxWidth(Integer frozenFieldsMaxWidth) {
        return (ListGrid)setAttribute("frozenFieldsMaxWidth", frozenFieldsMaxWidth, true);
    }

    /**
     * Maximum width available for any {@link com.smartgwt.client.docs.FrozenFields frozen fields} shown  in this grid. May be
     * specified as a percentage or numeric pixel value. <P> If the frozen fields' combined width exceeds this value, a
     * horizontal scrollbar will be shown, allowing the frozen fields to be horizontally scrolled (independently from the
     * unfrozen fields).
     *
     * @return Current frozenFieldsMaxWidth value. Default value is null
     */
    public Integer getFrozenFieldsMaxWidthAsInt()  {
        return getAttributeAsInt("frozenFieldsMaxWidth");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderBaseStyle New frozenHeaderBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setFrozenHeaderBaseStyle(String frozenHeaderBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("frozenHeaderBaseStyle", frozenHeaderBaseStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenHeaderBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getFrozenHeaderBaseStyle()  {
        return getAttributeAsString("frozenHeaderBaseStyle");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderTitleStyle New frozenHeaderTitleStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setFrozenHeaderTitleStyle(String frozenHeaderTitleStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("frozenHeaderTitleStyle", frozenHeaderTitleStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenHeaderTitleStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getFrozenHeaderTitleStyle()  {
        return getAttributeAsString("frozenHeaderTitleStyle");
    }
    
    
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnEnter New generateClickOnEnter value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGenerateClickOnEnter(Boolean generateClickOnEnter) {
        return (ListGrid)setAttribute("generateClickOnEnter", generateClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     *
     * @return Current generateClickOnEnter value. Default value is false
     */
    public Boolean getGenerateClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateClickOnEnter");
        return result == null ? false : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnSpace New generateClickOnSpace value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGenerateClickOnSpace(Boolean generateClickOnSpace) {
        return (ListGrid)setAttribute("generateClickOnSpace", generateClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     *
     * @return Current generateClickOnSpace value. Default value is true
     */
    public Boolean getGenerateClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateClickOnSpace");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnEnter New generateDoubleClickOnEnter value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGenerateDoubleClickOnEnter(Boolean generateDoubleClickOnEnter) {
        return (ListGrid)setAttribute("generateDoubleClickOnEnter", generateDoubleClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     *
     * @return Current generateDoubleClickOnEnter value. Default value is true
     */
    public Boolean getGenerateDoubleClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnEnter");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnSpace New generateDoubleClickOnSpace value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGenerateDoubleClickOnSpace(Boolean generateDoubleClickOnSpace) {
        return (ListGrid)setAttribute("generateDoubleClickOnSpace", generateDoubleClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     *
     * @return Current generateDoubleClickOnSpace value. Default value is false
     */
    public Boolean getGenerateDoubleClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnSpace");
        return result == null ? false : result;
    }
    

    /**
     * The additional criteria prefix to show in filter editor field hover, the filter action button or the sorter button
     * before the descriptive version of the +{filterWindowCriteria}, if any. The descriptive text is formatted by {@link
     * com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription DataSource.getAdvancedCriteriaDescription()}.
     *
     * @param gridAdditionalCriteriaText New gridAdditionalCriteriaText value. Default value is "Grid additional criteria:"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setGridAdditionalCriteriaText(String gridAdditionalCriteriaText)  throws IllegalStateException {
        return (ListGrid)setAttribute("gridAdditionalCriteriaText", gridAdditionalCriteriaText, false);
    }

    /**
     * The additional criteria prefix to show in filter editor field hover, the filter action button or the sorter button
     * before the descriptive version of the +{filterWindowCriteria}, if any. The descriptive text is formatted by {@link
     * com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription DataSource.getAdvancedCriteriaDescription()}.
     *
     * @return Current gridAdditionalCriteriaText value. Default value is "Grid additional criteria:"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getGridAdditionalCriteriaText()  {
        return getAttributeAsString("gridAdditionalCriteriaText");
    }
    

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *  <P>
     * See <a href='https://smartclient.com/smartgwt/showcase/#grid_appearance_custom_toolbar' target='_blank'>this example</a>
     *  of subclassing ListGrid and using gridComponents to add a tool bar with standard functions that 
     *  you want throughout your application.
     *
     * @param gridComponents New gridComponents value. Default value is (see below)
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setGridComponents(ListGridComponent... gridComponents)  throws IllegalStateException {
        return (ListGrid)setAttribute("gridComponents", gridComponents, false);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *  <P>
     * See <a href='https://smartclient.com/smartgwt/showcase/#grid_appearance_custom_toolbar' target='_blank'>this example</a>
     *  of subclassing ListGrid and using gridComponents to add a tool bar with standard functions that 
     *  you want throughout your application.
     *
     * @return Current gridComponents value. Default value is (see below)
     */
    public ListGridComponent[] getGridComponents()  {
        final String[] strings = getAttributeAsStringArray("gridComponents");
        return EnumUtil.getEnums(ListGridComponent.values(), strings, strings == null ? null : new ListGridComponent[strings.length]);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *  <P>
     * See <a href='https://smartclient.com/smartgwt/showcase/#grid_appearance_custom_toolbar' target='_blank'>this example</a>
     *  of subclassing ListGrid and using gridComponents to add a tool bar with standard functions that 
     *  you want throughout your application.
     *
     * @param gridComponents New gridComponents value. Default value is (see below)
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setGridComponents(Object... gridComponents)  throws IllegalStateException {
        return (ListGrid)setAttribute("gridComponents", gridComponents, false);
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @param gridSummaryRecordProperty New gridSummaryRecordProperty value. Default value is "isGridSummary"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGridSummaryRecordProperty(String gridSummaryRecordProperty) {
        return (ListGrid)setAttribute("gridSummaryRecordProperty", gridSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @return Current gridSummaryRecordProperty value. Default value is "isGridSummary"
     */
    public String getGridSummaryRecordProperty()  {
        return getAttributeAsString("gridSummaryRecordProperty");
    }
    

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During async grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asynchronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @param groupByAsyncThreshold New groupByAsyncThreshold value. Default value is 50
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGroupByAsyncThreshold(int groupByAsyncThreshold) {
        return (ListGrid)setAttribute("groupByAsyncThreshold", groupByAsyncThreshold, true);
    }

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During async grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asynchronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @return Current groupByAsyncThreshold value. Default value is 50
     */
    public int getGroupByAsyncThreshold()  {
        return getAttributeAsInt("groupByAsyncThreshold");
    }
    

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()} to update the grouping field
     * list, instead of modifying groupByField directly.
     *
     * @param groupByField New groupByField value. Default value is see below
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public ListGrid setGroupByField(String groupByField)  throws IllegalStateException {
        return (ListGrid)setAttribute("groupByField", groupByField, false);
    }

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()} to update the grouping field
     * list, instead of modifying groupByField directly.
     *
     * @param groupByField New groupByField value. Default value is see below
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public ListGrid setGroupByField(String... groupByField)  throws IllegalStateException {
        return (ListGrid)setAttribute("groupByField", groupByField, false);
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries groupByFieldSummaries} attribute
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByFieldSummaries new value for this.groupByFieldSummaries. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowGroupSummary
     */
    public ListGrid setGroupByFieldSummaries(String... groupByFieldSummaries) {
        return (ListGrid)setAttribute("groupByFieldSummaries", groupByFieldSummaries, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * @return Current groupByFieldSummaries value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary
     */
    public String[] getGroupByFieldSummaries()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("groupByFieldSummaries"));
    }
    

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}
     * will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of all
     * records that match the current filter criteria before records can be grouped.  The default maximum represents a number
     * of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern browsers can handle far more),
     * and is also a good upper limit from the perspective of loading data from a database. <P> Going beyond this limit can
     * cause "script running slowly" errors from legacy browsers (as well as high database load).  To build an interface for
     * grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand TreeGrid.loadDataOnDemand} with server-side grouping code.
     *
     * @param groupByMaxRecords New groupByMaxRecords value. Default value is 1000
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setGroupByMaxRecords(int groupByMaxRecords) {
        return (ListGrid)setAttribute("groupByMaxRecords", groupByMaxRecords, true);
    }

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}
     * will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of all
     * records that match the current filter criteria before records can be grouped.  The default maximum represents a number
     * of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern browsers can handle far more),
     * and is also a good upper limit from the perspective of loading data from a database. <P> Going beyond this limit can
     * cause "script running slowly" errors from legacy browsers (as well as high database load).  To build an interface for
     * grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand TreeGrid.loadDataOnDemand} with server-side grouping code.
     *
     * @return Current groupByMaxRecords value. Default value is 1000
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupByMaxRecords()  {
        return getAttributeAsInt("groupByMaxRecords");
    }
    

    /**
     * Warning shown to the user when a grouping attempt failed as the data set length exceeds {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> If defined, this prompt will be
     * shown to the user in a {@link com.smartgwt.client.util.isc#warn warning dialog} when the user attempts to group a data
     * set that exceeds the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} threshold.
     * <P> This can occur if an already-grouped grid's filter criteria are modified such  that a new set of records is loaded
     * from the DataSource which exceeds the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords
     * groupByMaxRecords} threshold. <P> It can also occur when a user attempts to group a grid with a partially loaded data
     * set where the true size of the data set is not known due to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getProgressiveLoading progressiveLoading}. In this case, the grouping logic
     * will attempt to retrieve all the  records in the data set and may get back a new total row count from the DataSource
     * which exceeds {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> In either
     * case the warning will be displayed to the user and the  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * group by menu item} will be disabled. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDisabledGroupByPrompt disabledGroupByPrompt}.
     *
     * @param groupByMaxRecordsExceededMessage New groupByMaxRecordsExceededMessage value. Default value is "Grouping has been disabled. This data set is too large to apply grouping efficiently."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGroupByMaxRecordsExceededMessage(String groupByMaxRecordsExceededMessage) {
        return (ListGrid)setAttribute("groupByMaxRecordsExceededMessage", groupByMaxRecordsExceededMessage, true);
    }

    /**
     * Warning shown to the user when a grouping attempt failed as the data set length exceeds {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> If defined, this prompt will be
     * shown to the user in a {@link com.smartgwt.client.util.isc#warn warning dialog} when the user attempts to group a data
     * set that exceeds the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} threshold.
     * <P> This can occur if an already-grouped grid's filter criteria are modified such  that a new set of records is loaded
     * from the DataSource which exceeds the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords
     * groupByMaxRecords} threshold. <P> It can also occur when a user attempts to group a grid with a partially loaded data
     * set where the true size of the data set is not known due to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getProgressiveLoading progressiveLoading}. In this case, the grouping logic
     * will attempt to retrieve all the  records in the data set and may get back a new total row count from the DataSource
     * which exceeds {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}. <P> In either
     * case the warning will be displayed to the user and the  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * group by menu item} will be disabled. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDisabledGroupByPrompt disabledGroupByPrompt}.
     *
     * @return Current groupByMaxRecordsExceededMessage value. Default value is "Grouping has been disabled. This data set is too large to apply grouping efficiently."
     */
    public String getGroupByMaxRecordsExceededMessage()  {
        return getAttributeAsString("groupByMaxRecordsExceededMessage");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByText New groupByText value. Default value is "Group by ${title}"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setGroupByText(String groupByText) {
        return (ListGrid)setAttribute("groupByText", groupByText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     *
     * @return If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field.<br> Default implementation evaluates
     * and returns the dynamic {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByText groupByText} string. Default value is "Group by ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getGroupByText()  {
        return getAttributeAsString("groupByText");
    }
    

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @param groupIcon New groupIcon value. Default value is "[SKINIMG]/TreeGrid/opener.gif"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setGroupIcon(String groupIcon) {
        return (ListGrid)setAttribute("groupIcon", groupIcon, true);
    }

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @return Current groupIcon value. Default value is "[SKINIMG]/TreeGrid/opener.gif"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getGroupIcon()  {
        return getAttributeAsString("groupIcon");
    }
    

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @param groupIconSize New groupIconSize value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setGroupIconSize(int groupIconSize) {
        return (ListGrid)setAttribute("groupIconSize", groupIconSize, true);
    }

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @return Current groupIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupIconSize()  {
        return getAttributeAsInt("groupIconSize");
    }
    

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @param groupIndentSize New groupIndentSize value. Default value is 20
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public ListGrid setGroupIndentSize(int groupIndentSize) {
        return (ListGrid)setAttribute("groupIndentSize", groupIndentSize, true);
    }

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @return Current groupIndentSize value. Default value is 20
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupIndentSize()  {
        return getAttributeAsInt("groupIndentSize");
    }
    

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @param groupLeadingIndent New groupLeadingIndent value. Default value is 10
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public ListGrid setGroupLeadingIndent(int groupLeadingIndent) {
        return (ListGrid)setAttribute("groupLeadingIndent", groupLeadingIndent, true);
    }

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @return Current groupLeadingIndent value. Default value is 10
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupLeadingIndent()  {
        return getAttributeAsInt("groupLeadingIndent");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @param groupNodeBaseStyle New groupNodeBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGroupNodeBaseStyle(String groupNodeBaseStyle) {
        return (ListGrid)setAttribute("groupNodeBaseStyle", groupNodeBaseStyle, true);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @return Current groupNodeBaseStyle value. Default value is null
     */
    public String getGroupNodeBaseStyle()  {
        return getAttributeAsString("groupNodeBaseStyle");
    }
    

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @param groupNodeStyle New groupNodeStyle value. Default value is "groupNode"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGroupNodeStyle(String groupNodeStyle) {
        return (ListGrid)setAttribute("groupNodeStyle", groupNodeStyle, true);
    }

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @return Current groupNodeStyle value. Default value is "groupNode"
     */
    public String getGroupNodeStyle()  {
        return getAttributeAsString("groupNodeStyle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @param groupSortDirection New groupSortDirection value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortByGroupFirst
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupSortNormalizer
     */
    public ListGrid setGroupSortDirection(SortDirection groupSortDirection) {
        return (ListGrid)setAttribute("groupSortDirection", groupSortDirection == null ? null : groupSortDirection.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @return Current groupSortDirection value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupSortNormalizer
     */
    public SortDirection getGroupSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("groupSortDirection"));
    }
    
    

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's grouping to match the {@link com.smartgwt.client.docs.ListGridGroupState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupState getGroupState()}.
     *
     * @param groupState Object describing the desired grouping state of                                              the grid. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ListGridGroupState ListGridGroupState 
     */
    public ListGrid setGroupState(String groupState) {
        return (ListGrid)setAttribute("groupState", groupState, true);
    }

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * @return Returns a snapshot of the current grouping state of this ListGrid.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setGroupState setGroupState()} to reset this grid's grouping to the current
     * state (assuming the same data / fields are present in the grid).<br>. Default value is null
     * @see com.smartgwt.client.docs.ListGridGroupState ListGridGroupState 
     */
    public String getGroupState()  {
        return getAttributeAsString("groupState");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @param groupSummaryRecordProperty New groupSummaryRecordProperty value. Default value is "isGroupSummary"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setGroupSummaryRecordProperty(String groupSummaryRecordProperty) {
        return (ListGrid)setAttribute("groupSummaryRecordProperty", groupSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @return Current groupSummaryRecordProperty value. Default value is "isGroupSummary"
     */
    public String getGroupSummaryRecordProperty()  {
        return getAttributeAsString("groupSummaryRecordProperty");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle ListGridRecord.customStyle} for the group-level
     * summary row displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is
     * true.
     *
     * @param groupSummaryStyle New groupSummaryStyle value. Default value is "gridSummaryCell"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setGroupSummaryStyle(String groupSummaryStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("groupSummaryStyle", groupSummaryStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle ListGridRecord.customStyle} for the group-level
     * summary row displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is
     * true.
     *
     * @return Current groupSummaryStyle value. Default value is "gridSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getGroupSummaryStyle()  {
        return getAttributeAsString("groupSummaryStyle");
    }
    
    

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @param groupTitleColumnProperties New groupTitleColumnProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setGroupTitleColumnProperties(ListGridField groupTitleColumnProperties)  throws IllegalStateException {
        JavaScriptObject config = groupTitleColumnProperties == null ? null : groupTitleColumnProperties.getJsObj();
        return (ListGrid)setAttribute("groupTitleColumnProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @return Current groupTitleColumnProperties value. Default value is null
     */
    public ListGridField getGroupTitleColumnProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("groupTitleColumnProperties"));
    }
    

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @param groupTitleField New groupTitleField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setGroupTitleField(String groupTitleField)  throws IllegalStateException {
        return (ListGrid)setAttribute("groupTitleField", groupTitleField, false);
    }

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @return Current groupTitleField value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getGroupTitleField()  {
        return getAttributeAsString("groupTitleField");
    }
    

    /**
     * The data tree that results from a call to  {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}. This
     * will be a {@link com.smartgwt.client.widgets.tree.ResultTree} if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is present, otherwise it will be a {@link
     * com.smartgwt.client.widgets.tree.Tree}.
     * <p>
     * This component is an AutoChild named "groupTree".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current groupTree value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Tree getGroupTree()  {
        return Tree.getOrCreateRef(getAttributeAsJavaScriptObject("groupTree"));
    }
    

    /**
     * A Toolbar used to manager the headers shown for each column of the grid.
     * <p>
     * This component is an AutoChild named "header".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current header value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Layout getHeader() throws IllegalStateException {
        errorIfNotCreated("header");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("header"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Canvas#getAriaRole Aria role} for this listGrid's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAriaRole getHeaderAriaRole()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerAriaRole New headerAriaRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderAriaRole(String headerAriaRole)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerAriaRole", headerAriaRole, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Canvas#getAriaRole Aria role} for this listGrid's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAriaRole getHeaderAriaRole()}
     *
     * @return Returns the {@link com.smartgwt.client.widgets.Canvas#getAriaRole role} for this listGrid's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header}. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAriaRole headerAriaRole} is explicitly provided, it will be used.<br>
     * Otherwise default implementation returns <code>"row"</code> if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} is set to  <code>"grid"</code>. Default value is null
     */
    public String getHeaderAriaRole()  {
        return getAttributeAsString("headerAriaRole");
    }
    

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click. <P> Only has an impact when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} or  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is set to
     * <code>true</code>.
     *
     * @param headerAutoFitEvent New headerAutoFitEvent value. Default value is "doubleClick"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderAutoFitEvent(AutoFitEvent headerAutoFitEvent)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerAutoFitEvent", headerAutoFitEvent == null ? null : headerAutoFitEvent.getValue(), false);
    }

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click. <P> Only has an impact when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} or  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is set to
     * <code>true</code>.
     *
     * @return Current headerAutoFitEvent value. Default value is "doubleClick"
     */
    public AutoFitEvent getHeaderAutoFitEvent()  {
        return EnumUtil.getEnum(AutoFitEvent.values(), getAttribute("headerAutoFitEvent"));
    }
    

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @param headerBackgroundColor New headerBackgroundColor value. Default value is "#CCCCCC"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setHeaderBackgroundColor(String headerBackgroundColor) {
        return (ListGrid)setAttribute("headerBackgroundColor", headerBackgroundColor, true);
    }

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @return Current headerBackgroundColor value. Default value is "#CCCCCC"
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBackgroundColor()  {
        return getAttributeAsString("headerBackgroundColor");
    }
    

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @param headerBarStyle New headerBarStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setHeaderBarStyle(String headerBarStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerBarStyle", headerBarStyle, false);
    }

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @return Current headerBarStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBarStyle()  {
        return getAttributeAsString("headerBarStyle");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the buttons in the header, and the
     * sorter, for this ListGrid. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @param headerBaseStyle New headerBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setClipHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGrid#setWrapHeaderTitles
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setHeaderBaseStyle(String headerBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerBaseStyle", headerBaseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the buttons in the header, and the
     * sorter, for this ListGrid. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @return Current headerBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBaseStyle()  {
        return getAttributeAsString("headerBaseStyle");
    }
    

    /**
     * Default {@link com.smartgwt.client.widgets.Canvas#getAriaRole role} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header buttons}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaRole getHeaderButtonAriaRole()}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerButtonAriaRole New headerButtonAriaRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderButtonAriaRole(String headerButtonAriaRole)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerButtonAriaRole", headerButtonAriaRole, false);
    }

    /**
     * Default {@link com.smartgwt.client.widgets.Canvas#getAriaRole role} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header buttons}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaRole getHeaderButtonAriaRole()}.
     *
     * @return Returns the {@link com.smartgwt.client.widgets.Canvas#getAriaRole role} for this listGrid's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header buttons}. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaRole ListGridField.headerButtonAriaRole} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaRole headerButtonAriaRole} is set, it will be used.<br>
     * Othewise, the default implementation returns <code>"columnheader"</code> if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} is set to  <code>"grid"</code>, <code>"button"</code>
     * otherwise. Default value is null
     */
    public String getHeaderButtonAriaRole()  {
        return getAttributeAsString("headerButtonAriaRole");
    }
    

    /**
     * Default {@link com.smartgwt.client.widgets.Canvas#getAriaState ARIA state} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header buttons}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaState getHeaderButtonAriaState()}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerButtonAriaState New headerButtonAriaState value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderButtonAriaState(Map headerButtonAriaState)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerButtonAriaState", headerButtonAriaState, false);
    }

    /**
     * Default {@link com.smartgwt.client.widgets.Canvas#getAriaState ARIA state} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header buttons}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaState getHeaderButtonAriaState()}.
     *
     * @return Returns a map of {@link com.smartgwt.client.widgets.Canvas#getAriaState WAI ARIA state attribute values} to be written
     * into header buttons for this grid. <P> Default implementation returns an object with combined properties from any
     * specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonAriaState header button aria state default
     * object},  overlaid with any {@link com.smartgwt.client.widgets.grid.ListGridField#getHeaderButtonAriaState
     * ListGridField.headerButtonAriaState} properties specified on the  field itself, plus the following attributes: <ul>
     * <li><code>haspopup</code> - true if the button should show the header context menu</li> <li><code>colindex</code> -
     * index of the column if {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} is
     * <code>"grid"</code></li> <li><code>sort</code> - "ascending", "descending" or "none" depending on the sort-state of the
     * field</li> </ul> Also, if an explicit property is set in ariaState, it will be respected and will take precedence over 
     * the calculated property. Default value is null
     */
    public Map getHeaderButtonAriaState()  {
        return getAttributeAsMap("headerButtonAriaState");
    }
    
    
    

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerButtonProperties New headerButtonProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public ListGrid setHeaderButtonProperties(Button headerButtonProperties)  throws IllegalStateException {
        if (headerButtonProperties != null) {
            if (headerButtonProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setHeaderButtonProperties", "Button");
            }
            headerButtonProperties.setConfigOnly(true);
        }
        JavaScriptObject config = headerButtonProperties == null ? null : headerButtonProperties.getConfig();
        return (ListGrid)setAttribute("headerButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     *
     * @return Current headerButtonProperties value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Button getHeaderButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("headerButtonProperties"));
        return properties;
    }
    

    /**
     * The context menu displayed for column headers.
     * <p>
     * This component is an AutoChild named "headerContextMenu".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current headerContextMenu value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Canvas getHeaderContextMenu() throws IllegalStateException {
        errorIfNotCreated("headerContextMenu");
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("headerContextMenu"));
    }
    

    /**
     * The height of this listGrid's header, in pixels.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Modify the height of a listGrid. To hide the header set height to zero.
     *
     * @param headerHeight new height for the header. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public ListGrid setHeaderHeight(int headerHeight) {
        return (ListGrid)setAttribute("headerHeight", headerHeight, true);
    }

    /**
     * The height of this listGrid's header, in pixels.
     *
     * @return Current headerHeight value. Default value is 22
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public int getHeaderHeight()  {
        return getAttributeAsInt("headerHeight");
    }
    

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverAlign New headerHoverAlign value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverAlign(Alignment headerHoverAlign) {
        return (ListGrid)setAttribute("headerHoverAlign", headerHoverAlign == null ? null : headerHoverAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverAlign value. Default value is null
     */
    public Alignment getHeaderHoverAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("headerHoverAlign"));
    }
    

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverHeight New headerHoverHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverHeight(Integer headerHoverHeight) {
        return (ListGrid)setAttribute("headerHoverHeight", headerHoverHeight, true);
    }

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Current headerHoverHeight value. Default value is null
     */
    public Integer getHeaderHoverHeight()  {
        return getAttributeAsInt("headerHoverHeight");
    }
    

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverOpacity New headerHoverOpacity value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverOpacity(Integer headerHoverOpacity) {
        return (ListGrid)setAttribute("headerHoverOpacity", headerHoverOpacity, true);
    }

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverOpacity value. Default value is null
     */
    public Integer getHeaderHoverOpacity()  {
        return getAttributeAsInt("headerHoverOpacity");
    }
    

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverStyle New headerHoverStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setHeaderHoverStyle(String headerHoverStyle) {
        return (ListGrid)setAttribute("headerHoverStyle", headerHoverStyle, true);
    }

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getHeaderHoverStyle()  {
        return getAttributeAsString("headerHoverStyle");
    }
    

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverVAlign New headerHoverVAlign value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverVAlign(VerticalAlignment headerHoverVAlign) {
        return (ListGrid)setAttribute("headerHoverVAlign", headerHoverVAlign == null ? null : headerHoverVAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverVAlign value. Default value is null
     */
    public VerticalAlignment getHeaderHoverVAlign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("headerHoverVAlign"));
    }
    

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverWidth New headerHoverWidth value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverWidth(Integer headerHoverWidth) {
        return (ListGrid)setAttribute("headerHoverWidth", headerHoverWidth, true);
    }

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Current headerHoverWidth value. Default value is null
     */
    public Integer getHeaderHoverWidth()  {
        return getAttributeAsInt("headerHoverWidth");
    }
    

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverWrap New headerHoverWrap value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderHoverWrap(Boolean headerHoverWrap) {
        return (ListGrid)setAttribute("headerHoverWrap", headerHoverWrap, true);
    }

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverWrap value. Default value is null
     */
    public Boolean getHeaderHoverWrap()  {
        return getAttributeAsBoolean("headerHoverWrap");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when the user
     * rolls over the header buttons in this grid the headerMenuButton will be shown over the header button in question. When
     * clicked this button will display the standard header context menu (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu displayHeaderContextMenu()}). <P> {@link
     * com.smartgwt.client.docs.HeaderMenuButton Several properties} exist to customize the appearance of the headerMenuButton.
     * Also see the {@link com.smartgwt.client.types.AutoChild} documentation for information on how to make free-form
     * modifications to autoChild widgets
     * <p>
     * This component is an AutoChild named "headerMenuButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current headerMenuButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public StatefulCanvas getHeaderMenuButton() throws IllegalStateException {
        errorIfNotCreated("headerMenuButton");
        return (StatefulCanvas)StatefulCanvas.getByJSObject(getAttributeAsJavaScriptObject("headerMenuButton"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonHeight New headerMenuButtonHeight value. Default value is "100%"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRotatedHeaderMenuButtonHeight
     */
    public ListGrid setHeaderMenuButtonHeight(int headerMenuButtonHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonHeight", headerMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonHeight value. Default value is "100%"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRotatedHeaderMenuButtonHeight
     */
    public int getHeaderMenuButtonHeight()  {
        return getAttributeAsInt("headerMenuButtonHeight");
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonHeight New headerMenuButtonHeight value. Default value is "100%"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRotatedHeaderMenuButtonHeight
     */
    public ListGrid setHeaderMenuButtonHeight(String headerMenuButtonHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonHeight", headerMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonHeight value. Default value is "100%"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRotatedHeaderMenuButtonHeight
     */
    public String getHeaderMenuButtonHeightAsString()  {
        return getAttributeAsString("headerMenuButtonHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIcon New headerMenuButtonIcon value. Default value is "[SKIN]/ListGrid/headerMenuButton_icon.gif"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.URL URL 
     */
    public ListGrid setHeaderMenuButtonIcon(String headerMenuButtonIcon)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonIcon", headerMenuButtonIcon, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIcon value. Default value is "[SKIN]/ListGrid/headerMenuButton_icon.gif"
     * @see com.smartgwt.client.docs.URL URL 
     */
    public String getHeaderMenuButtonIcon()  {
        return getAttributeAsString("headerMenuButtonIcon");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconHeight New headerMenuButtonIconHeight value. Default value is 7
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderMenuButtonIconHeight(int headerMenuButtonIconHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonIconHeight", headerMenuButtonIconHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIconHeight value. Default value is 7
     */
    public int getHeaderMenuButtonIconHeight()  {
        return getAttributeAsInt("headerMenuButtonIconHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconWidth New headerMenuButtonIconWidth value. Default value is 7
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderMenuButtonIconWidth(int headerMenuButtonIconWidth)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonIconWidth", headerMenuButtonIconWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIconWidth value. Default value is 7
     */
    public int getHeaderMenuButtonIconWidth()  {
        return getAttributeAsInt("headerMenuButtonIconWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonWidth New headerMenuButtonWidth value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRotatedHeaderMenuButtonWidth
     */
    public ListGrid setHeaderMenuButtonWidth(int headerMenuButtonWidth)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerMenuButtonWidth", headerMenuButtonWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonWidth value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRotatedHeaderMenuButtonWidth
     */
    public int getHeaderMenuButtonWidth()  {
        return getAttributeAsInt("headerMenuButtonWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowColor Canvas.shadowColor} for the header shadow.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowColor New headerShadowColor value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public ListGrid setHeaderShadowColor(String headerShadowColor)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerShadowColor", headerShadowColor, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowColor Canvas.shadowColor} for the header shadow.
     *
     * @return Current headerShadowColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getHeaderShadowColor()  {
        return getAttributeAsString("headerShadowColor");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowHOffset Canvas.shadowHOffset} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowHOffset New headerShadowHOffset value. Default value is 0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderShadowHOffset(int headerShadowHOffset)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerShadowHOffset", headerShadowHOffset, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowHOffset Canvas.shadowHOffset} for the header shadow
     *
     * @return Current headerShadowHOffset value. Default value is 0
     */
    public int getHeaderShadowHOffset()  {
        return getAttributeAsInt("headerShadowHOffset");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowSoftness Canvas.shadowSoftness} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowSoftness New headerShadowSoftness value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderShadowSoftness(int headerShadowSoftness)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerShadowSoftness", headerShadowSoftness, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowSoftness Canvas.shadowSoftness} for the header shadow
     *
     * @return Current headerShadowSoftness value. Default value is 1
     */
    public int getHeaderShadowSoftness()  {
        return getAttributeAsInt("headerShadowSoftness");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowVOffset Canvas.shadowVOffset} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowVOffset New headerShadowVOffset value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderShadowVOffset(int headerShadowVOffset)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerShadowVOffset", headerShadowVOffset, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowVOffset Canvas.shadowVOffset} for the header shadow
     *
     * @return Current headerShadowVOffset value. Default value is 1
     */
    public int getHeaderShadowVOffset()  {
        return getAttributeAsInt("headerShadowVOffset");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are created via the {@link
     * com.smartgwt.client.types.AutoChild} pattern, hence <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code>
     * and <code>headerSpanProperties</code> are valid.
     *
     * @return null
     */
    public StatefulCanvas getHeaderSpan()  {
        return null;
    }
    
    

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @param headerSpanHeight New headerSpanHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHeaderSpanHeight(Integer headerSpanHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerSpanHeight", headerSpanHeight, false);
    }

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @return Current headerSpanHeight value. Default value is null
     */
    public Integer getHeaderSpanHeight()  {
        return getAttributeAsInt("headerSpanHeight");
    }
    

    /**
     * Header spans are a second level of headers that appear above the normal ListGrid headers,
     *  spanning one or more listGrid fields in a manner similar to a column-spanning cell in an
     *  HTML table.
     *  <P>
     *  A header span can be created by simply naming the fields the header should span.  The
     *  example below creates a headerSpan that spans the first two fields of the ListGrid.
     *  
     *  
     *  <pre>
     *       ListGrid grid = new ListGrid();
     *       grid.setHeaderHeight(40);
     *       grid.setFields(new ListGridField[] {
     *           new ListGridField("field1"),
     *           new ListGridField("field2"),
     *           new ListGridField("field3")
     *       });
     *       grid.setHeaderSpans(new HeaderSpan[] {
     *           new HeaderSpan("Field 1 and 2", new String[] {"field1", "field2"})
     *       });
     *  </pre>
     *  
     *  Header spans can be nested, allowing fields to be grouped by multiple levels of
     * granularity. See {@link com.smartgwt.client.widgets.grid.HeaderSpan#getSpans HeaderSpan.spans} for further information
     * on nesting spans.
     *  <P>
     *  Header spans will automatically react to resizing of the headers they span, and will be
     *  hidden automatically when all of the spanned fields are hidden.
     *  <P>
     * Header spans appear in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader header} area of the ListGrid,
     * sharing space
     * with the existing headers, so it's typical to set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight} to
     *  approximately double its normal height when using headerSpans, or if using nested header
     *  spans, the default header height multiplied by the number of levels of header spans to be
     *  shown.
     *  <P>
     *  See {@link com.smartgwt.client.widgets.grid.HeaderSpan} for many properties that allow the control of the appearance of
     *  headerSpans.
     *  
     *  <P>
     *  Neither headerSpans themselves nor the fields within them may be drag reordered, but other
     *  unspanned headers may be.
     *  <P>
     *  A span can only span adjacent fields - if a span is defined and the spanned fields don't
     *  sit next to each other in the specified fields array, the fields array will be automatically
     * reordered to match the order specified in the span's {@link com.smartgwt.client.widgets.grid.HeaderSpan#getFields
     * HeaderSpan.fields} array.
     *  <P>
     *  Note that headerSpans primarily provide a visual cue for grouping multiple headers
     *  together.  If you have an OLAP, data "cube" or multi-dimensional data model, the
     *  {@link com.smartgwt.client.widgets.cube.CubeGrid} component is the right choice.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the headerSpans configuration on the grid dynamically.
     *
     * @param headerSpans same configuration block as that passed to                                          {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHeaderSpans(HeaderSpan... headerSpans) {
        return (ListGrid)setAttribute("headerSpans", headerSpans, true);
    }
    
    

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle StretchImgButton.titleStyle} to apply to the buttons
     * in the header, and the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @param headerTitleStyle New headerTitleStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setHeaderTitleStyle(String headerTitleStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerTitleStyle", headerTitleStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle StretchImgButton.titleStyle} to apply to the buttons
     * in the header, and the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @return Current headerTitleStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderTitleStyle()  {
        return getAttributeAsString("headerTitleStyle");
    }
    

    /**
     * Specifies vertical alignment in the column headers: "top", "center", or "bottom".  Can  be overridden for individual
     * fields by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getValign ListGridField.valign}. <p> When using
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRotateHeaderTitles rotated titles}, this attribute defaults to
     * "bottom" if it remains unset.
     *
     * @param headerTitleVAlign New headerTitleVAlign value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValign
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRotateHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGridField#setRotateTitle
     */
    public ListGrid setHeaderTitleVAlign(VerticalAlignment headerTitleVAlign)  throws IllegalStateException {
        return (ListGrid)setAttribute("headerTitleVAlign", headerTitleVAlign == null ? null : headerTitleVAlign.getValue(), false);
    }

    /**
     * Specifies vertical alignment in the column headers: "top", "center", or "bottom".  Can  be overridden for individual
     * fields by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getValign ListGridField.valign}. <p> When using
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRotateHeaderTitles rotated titles}, this attribute defaults to
     * "bottom" if it remains unset.
     *
     * @return Current headerTitleVAlign value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValign
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRotateHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle
     */
    public VerticalAlignment getHeaderTitleVAlign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("headerTitleVAlign"));
    }
    

    /**
     * If true, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow} component to be hidden if
     * it has no data after summaries have been recalculated
     *
     * @param hideEmptySummaryRow New hideEmptySummaryRow value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHideEmptySummaryRow(Boolean hideEmptySummaryRow) {
        return (ListGrid)setAttribute("hideEmptySummaryRow", hideEmptySummaryRow, true);
    }

    /**
     * If true, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow} component to be hidden if
     * it has no data after summaries have been recalculated
     *
     * @return Current hideEmptySummaryRow value. Default value is null
     */
    public Boolean getHideEmptySummaryRow()  {
        return getAttributeAsBoolean("hideEmptySummaryRow");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor canShowFilterEditor} is true, this is the
     * title for the filterEditor show/hide menu-item, in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}, when the filterEditor is visible. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditorTitle showFilterEditorTitle} affects the same
     * menu-item when the filterEditor is hidden.
     *
     * @param hideFilterEditorTitle New hideFilterEditorTitle value. Default value is "Hide Filter Row"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public ListGrid setHideFilterEditorTitle(String hideFilterEditorTitle) {
        return (ListGrid)setAttribute("hideFilterEditorTitle", hideFilterEditorTitle, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor canShowFilterEditor} is true, this is the
     * title for the filterEditor show/hide menu-item, in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}, when the filterEditor is visible. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditorTitle showFilterEditorTitle} affects the same
     * menu-item when the filterEditor is hidden.
     *
     * @return Current hideFilterEditorTitle value. Default value is "Hide Filter Row"
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public String getHideFilterEditorTitle()  {
        return getAttributeAsString("hideFilterEditorTitle");
    }
    

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue} feature to cause values in hilited cells to
     * be replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values
     * ranging from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieu of the cell's original value.
     *
     * @param hiliteCanReplaceValue New hiliteCanReplaceValue value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteCanReplaceValue(Boolean hiliteCanReplaceValue)  throws IllegalStateException {
        return (ListGrid)setAttribute("hiliteCanReplaceValue", hiliteCanReplaceValue, false);
    }

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue} feature to cause values in hilited cells to
     * be replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values
     * ranging from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieu of the cell's original value.
     *
     * @return Current hiliteCanReplaceValue value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Boolean getHiliteCanReplaceValue()  {
        return getAttributeAsBoolean("hiliteCanReplaceValue");
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @param hiliteEditorSpanTitleSeparator New hiliteEditorSpanTitleSeparator value. Default value is " - "
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHiliteEditorSpanTitleSeparator(String hiliteEditorSpanTitleSeparator) {
        return (ListGrid)setAttribute("hiliteEditorSpanTitleSeparator", hiliteEditorSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @return Current hiliteEditorSpanTitleSeparator value. Default value is " - "
     */
    public String getHiliteEditorSpanTitleSeparator()  {
        return getAttributeAsString("hiliteEditorSpanTitleSeparator");
    }
    

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore Hilite.htmlBefore}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlAfter Hilite.htmlAfter}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlValue Hilite.htmlValue}</li> </ul> <P> May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat ListGridField.hiliteHTMLAfterFormat}
     *
     * @param hiliteHTMLAfterFormat New hiliteHTMLAfterFormat value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHiliteHTMLAfterFormat(boolean hiliteHTMLAfterFormat)  throws IllegalStateException {
        return (ListGrid)setAttribute("hiliteHTMLAfterFormat", hiliteHTMLAfterFormat, false);
    }

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore Hilite.htmlBefore}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlAfter Hilite.htmlAfter}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlValue Hilite.htmlValue}</li> </ul> <P> May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat ListGridField.hiliteHTMLAfterFormat}
     *
     * @return Current hiliteHTMLAfterFormat value. Default value is true
     */
    public boolean getHiliteHTMLAfterFormat()  {
        Boolean result = getAttributeAsBoolean("hiliteHTMLAfterFormat");
        return result == null ? true : result;
    }
    

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @param hiliteIconHeight New hiliteIconHeight value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconHeight(Integer hiliteIconHeight) {
        return (ListGrid)setAttribute("hiliteIconHeight", hiliteIconHeight, true);
    }

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @return Current hiliteIconHeight value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconHeight()  {
        return getAttributeAsInt("hiliteIconHeight");
    }
    

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconLeftPadding New hiliteIconLeftPadding value. Default value is 2
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconLeftPadding(int hiliteIconLeftPadding) {
        return (ListGrid)setAttribute("hiliteIconLeftPadding", hiliteIconLeftPadding, true);
    }

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return Current hiliteIconLeftPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconLeftPadding()  {
        return getAttributeAsInt("hiliteIconLeftPadding");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be
     * overridden at the field level.
     *
     * @param hiliteIconPosition New hiliteIconPosition value. Default value is "before"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconPosition(HiliteIconPosition hiliteIconPosition)  throws IllegalStateException {
        return (ListGrid)setAttribute("hiliteIconPosition", hiliteIconPosition == null ? null : hiliteIconPosition.getValue(), false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be
     * overridden at the field level.
     *
     * @return Current hiliteIconPosition value. Default value is "before"
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public HiliteIconPosition getHiliteIconPosition()  {
        return EnumUtil.getEnum(HiliteIconPosition.values(), getAttribute("hiliteIconPosition"));
    }
    

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconRightPadding New hiliteIconRightPadding value. Default value is 2
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconRightPadding(int hiliteIconRightPadding) {
        return (ListGrid)setAttribute("hiliteIconRightPadding", hiliteIconRightPadding, true);
    }

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return Current hiliteIconRightPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconRightPadding()  {
        return getAttributeAsInt("hiliteIconRightPadding");
    }
    

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon Hilite.icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition DataBoundComponent.hiliteIconPosition} controls
     * where the icon will  appear for that field -- the default is that it appears in front of the normal cell content. This
     * can also be overridden at the field level.
     *
     * @param hiliteIcons New hiliteIcons value. Default value is ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"]
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIcons(String... hiliteIcons)  throws IllegalStateException {
        return (ListGrid)setAttribute("hiliteIcons", hiliteIcons, false);
    }

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon Hilite.icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition DataBoundComponent.hiliteIconPosition} controls
     * where the icon will  appear for that field -- the default is that it appears in front of the normal cell content. This
     * can also be overridden at the field level.
     *
     * @return Current hiliteIcons value. Default value is ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"]
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public String[] getHiliteIcons()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("hiliteIcons"));
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @param hiliteIconSize New hiliteIconSize value. Default value is 12
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#setHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconSize(int hiliteIconSize) {
        return (ListGrid)setAttribute("hiliteIconSize", hiliteIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @return Current hiliteIconSize value. Default value is 12
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconSize()  {
        return getAttributeAsInt("hiliteIconSize");
    }
    

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @param hiliteIconWidth New hiliteIconWidth value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public ListGrid setHiliteIconWidth(Integer hiliteIconWidth) {
        return (ListGrid)setAttribute("hiliteIconWidth", hiliteIconWidth, true);
    }

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @return Current hiliteIconWidth value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconWidth()  {
        return getAttributeAsInt("hiliteIconWidth");
    }
    

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @param hiliteReplaceValueFieldTitle New hiliteReplaceValueFieldTitle value. Default value is "Replace value with"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHiliteReplaceValueFieldTitle(String hiliteReplaceValueFieldTitle)  throws IllegalStateException {
        return (ListGrid)setAttribute("hiliteReplaceValueFieldTitle", hiliteReplaceValueFieldTitle, false);
    }

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @return Current hiliteReplaceValueFieldTitle value. Default value is "Replace value with"
     */
    public String getHiliteReplaceValueFieldTitle()  {
        return getAttributeAsString("hiliteReplaceValueFieldTitle");
    }
    

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @param hiliteRowOnFocus New hiliteRowOnFocus value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHiliteRowOnFocus(Boolean hiliteRowOnFocus) {
        return (ListGrid)setAttribute("hiliteRowOnFocus", hiliteRowOnFocus, true);
    }

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @return Current hiliteRowOnFocus value. Default value is null
     */
    public Boolean getHiliteRowOnFocus()  {
        return getAttributeAsBoolean("hiliteRowOnFocus");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored. <p> If <code>showHoverComponents</code> is true but
     * <code>hoverMode</code> is not set, it  defaults to "detailRelated" if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} is set, or to "details" otherwise. If
     * <code>showHoverComponents</code> is not set (ie, is null) and <code>hoverMode</code> <i>is</i> set,
     * <code>showHoverComponents</code> defaults to true.
     *
     * @param hoverMode New hoverMode value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setHoverMode(HoverMode hoverMode) {
        return (ListGrid)setAttribute("hoverMode", hoverMode == null ? null : hoverMode.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored. <p> If <code>showHoverComponents</code> is true but
     * <code>hoverMode</code> is not set, it  defaults to "detailRelated" if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} is set, or to "details" otherwise. If
     * <code>showHoverComponents</code> is not set (ie, is null) and <code>hoverMode</code> <i>is</i> set,
     * <code>showHoverComponents</code> defaults to true.
     *
     * @return Current hoverMode value. Default value is null
     */
    public HoverMode getHoverMode()  {
        return EnumUtil.getEnum(HoverMode.values(), getAttribute("hoverMode"));
    }
    

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.Canvas#getHoverComponent getHoverComponent()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being shown at the row.
     *
     * @param hoverScreen New hoverScreen value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setHoverScreen(String hoverScreen)  throws IllegalStateException {
        return (ListGrid)setAttribute("hoverScreen", hoverScreen, false);
    }

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.Canvas#getHoverComponent getHoverComponent()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being shown at the row.
     *
     * @return Current hoverScreen value. Default value is null
     */
    public String getHoverScreen()  {
        return getAttributeAsString("hoverScreen");
    }
    

    /**
     * Style to apply to hovers shown over this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param hoverStyle New hoverStyle value. Default value is "gridHover"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setHoverStyle(String hoverStyle) {
        return (ListGrid)setAttribute("hoverStyle", hoverStyle, true);
    }

    /**
     * Style to apply to hovers shown over this grid.
     *
     * @return Current hoverStyle value. Default value is "gridHover"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getHoverStyle()  {
        return getAttributeAsString("hoverStyle");
    }
    

    /**
     * Default cursor to display when the user rolls over icons within cells of an {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type:icon} field. <P> May be overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIconCursor ListGridField.iconCursor}. <P> Note: Unlike the field-level
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getIconCursor ListGridField.iconCursor} property,
     * listGrid.iconCursor has no effect on the cursor displayed for {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons valueIcons}. <br> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconCursor getValueIconCursor()} for more details.
     *
     * @param iconCursor New iconCursor value. Default value is Canvas.POINTER
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#getIconCursor
     */
    public ListGrid setIconCursor(Cursor iconCursor) {
        return (ListGrid)setAttribute("iconCursor", iconCursor == null ? null : iconCursor.getValue(), true);
    }

    /**
     * Default cursor to display when the user rolls over icons within cells of an {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type:icon} field. <P> May be overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIconCursor ListGridField.iconCursor}. <P> Note: Unlike the field-level
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getIconCursor ListGridField.iconCursor} property,
     * listGrid.iconCursor has no effect on the cursor displayed for {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons valueIcons}. <br> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconCursor getValueIconCursor()} for more details.
     *
     * @return Returns the cursor to display when the mouse pointer is over an {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIcon icon} in an <code>"icon"</code> type field. <P> Default behavior
     * will display the {@link com.smartgwt.client.widgets.grid.ListGridField#getIconCursor ListGridField.iconCursor} if
     * specified, otherwise the component level {@link com.smartgwt.client.widgets.grid.ListGrid#getIconCursor iconCursor}. Default value is Canvas.POINTER
     * @see com.smartgwt.client.widgets.grid.ListGrid#getIconCursor
     */
    public Cursor getIconCursor()  {
        return EnumUtil.getEnum(Cursor.values(), getAttribute("iconCursor"));
    }
    

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @param iconPadding New iconPadding value. Default value is 2
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setIconPadding(Integer iconPadding)  throws IllegalStateException {
        return (ListGrid)setAttribute("iconPadding", iconPadding, false);
    }

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @return Current iconPadding value. Default value is 2
     */
    public Integer getIconPadding()  {
        return getAttributeAsInt("iconPadding");
    }
    

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize ListGridField.imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth ListGridField.imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight ListGridField.imageHeight}
     *
     * @param imageSize New imageSize value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setImageSize(int imageSize) {
        return (ListGrid)setAttribute("imageSize", imageSize, true);
    }

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize ListGridField.imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth ListGridField.imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight ListGridField.imageHeight}
     *
     * @return Current imageSize value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getImageSize()  {
        return getAttributeAsInt("imageSize");
    }
    
    

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param includeHilitesInSummaryFields New includeHilitesInSummaryFields value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public ListGrid setIncludeHilitesInSummaryFields(boolean includeHilitesInSummaryFields) {
        return (ListGrid)setAttribute("includeHilitesInSummaryFields", includeHilitesInSummaryFields, true);
    }

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     *
     * @return Current includeHilitesInSummaryFields value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public boolean getIncludeHilitesInSummaryFields()  {
        Boolean result = getAttributeAsBoolean("includeHilitesInSummaryFields");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @param includeInSummaryProperty New includeInSummaryProperty value. Default value is "includeInSummary"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setIncludeInSummaryProperty(String includeInSummaryProperty) {
        return (ListGrid)setAttribute("includeInSummaryProperty", includeInSummaryProperty, true);
    }

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @return Current includeInSummaryProperty value. Default value is "includeInSummary"
     */
    public String getIncludeInSummaryProperty()  {
        return getAttributeAsString("includeInSummaryProperty");
    }
    
    

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @param initialSort New initialSort value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setInitialSort(SortSpecifier... initialSort)  throws IllegalStateException {
        return (ListGrid)setAttribute("initialSort", initialSort, false);
    }

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @return Current initialSort value. Default value is null
     */
    public SortSpecifier[] getInitialSort()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSortSpecifier(getAttributeAsJavaScriptObject("initialSort"));
    }
    

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @param instantScrollTrackRedraw New instantScrollTrackRedraw value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setInstantScrollTrackRedraw(Boolean instantScrollTrackRedraw) {
        return (ListGrid)setAttribute("instantScrollTrackRedraw", instantScrollTrackRedraw, true);
    }

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @return Current instantScrollTrackRedraw value. Default value is true
     */
    public Boolean getInstantScrollTrackRedraw()  {
        Boolean result = getAttributeAsBoolean("instantScrollTrackRedraw");
        return result == null ? true : result;
    }
    

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param invalidSummaryValue New invalidSummaryValue value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setInvalidSummaryValue(String invalidSummaryValue) {
        return (ListGrid)setAttribute("invalidSummaryValue", invalidSummaryValue, true);
    }

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     *
     * @return Current invalidSummaryValue value. Default value is "&amp;nbsp;"
     */
    public String getInvalidSummaryValue()  {
        return getAttributeAsString("invalidSummaryValue");
    }
    

    /**
     * True if this listGrid is grouped, false otherwise
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current isGrouped value. Default value is false
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getIsGrouped() throws IllegalStateException {
        errorIfNotCreated("isGrouped");
        Boolean result = getAttributeAsBoolean("isGrouped");
        return result == null ? false : result;
    }
    

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @param isSeparatorProperty New isSeparatorProperty value. Default value is "isSeparator"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setIsSeparatorProperty(String isSeparatorProperty) {
        return (ListGrid)setAttribute("isSeparatorProperty", isSeparatorProperty, true);
    }

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @return Current isSeparatorProperty value. Default value is "isSeparator"
     */
    public String getIsSeparatorProperty()  {
        return getAttributeAsString("isSeparatorProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when
     * auto-fitting fields to the title width via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths} or {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * ListGridField.autoFitWidth}, should the button be sized such that there is enough space for the header menu button to
     * show without covering the field title? <P> May be explicitly specified at the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLeaveHeaderMenuButtonSpace field level} or at the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace grid level}. If not explicitly specified space
     * will be left for fields with {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign ListGridField.align} set to
     * <code>"left"</code> or <code>"right"</code>, but not for fields with align set to <code>"center"</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param leaveHeaderMenuButtonSpace New leaveHeaderMenuButtonSpace value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortNumeralMenuButtonSpaceOffset
     */
    public ListGrid setLeaveHeaderMenuButtonSpace(Boolean leaveHeaderMenuButtonSpace) {
        return (ListGrid)setAttribute("leaveHeaderMenuButtonSpace", leaveHeaderMenuButtonSpace, true);
    }
    

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @param leaveScrollbarGap New leaveScrollbarGap value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public ListGrid setLeaveScrollbarGap(Boolean leaveScrollbarGap) {
        return (ListGrid)setAttribute("leaveScrollbarGap", leaveScrollbarGap, true);
    }

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @return Current leaveScrollbarGap value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getLeaveScrollbarGap()  {
        Boolean result = getAttributeAsBoolean("leaveScrollbarGap");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty ListGridField.linkTextProperty} if you have more than
     * one link field and
     *
     * @param linkTextProperty New linkTextProperty value. Default value is "linkText"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkTextProperty
     */
    public ListGrid setLinkTextProperty(String linkTextProperty) {
        return (ListGrid)setAttribute("linkTextProperty", linkTextProperty, true);
    }

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty ListGridField.linkTextProperty} if you have more than
     * one link field and
     *
     * @return Current linkTextProperty value. Default value is "linkText"
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty
     */
    public String getLinkTextProperty()  {
        return getAttributeAsString("linkTextProperty");
    }
    

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @param listEndEditAction New listEndEditAction value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public ListGrid setListEndEditAction(RowEndEditAction listEndEditAction) {
        return (ListGrid)setAttribute("listEndEditAction", listEndEditAction == null ? null : listEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @return Current listEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public RowEndEditAction getListEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("listEndEditAction"));
    }
    

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @param loadingDataMessage New loadingDataMessage value. Default value is "${loadingImage}&amp;nbsp;Loading data..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setLoadingDataMessageStyle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setLoadingDataMessage(String loadingDataMessage) {
        return (ListGrid)setAttribute("loadingDataMessage", loadingDataMessage, true);
    }

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @return Current loadingDataMessage value. Default value is "${loadingImage}&amp;nbsp;Loading data..."
     * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingDataMessageStyle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getLoadingDataMessage()  {
        return getAttributeAsString("loadingDataMessage");
    }
    

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @param loadingDataMessageStyle New loadingDataMessageStyle value. Default value is "loadingDataMessage"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setLoadingDataMessageStyle(String loadingDataMessageStyle) {
        return (ListGrid)setAttribute("loadingDataMessageStyle", loadingDataMessageStyle, true);
    }

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @return Current loadingDataMessageStyle value. Default value is "loadingDataMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getLoadingDataMessageStyle()  {
        return getAttributeAsString("loadingDataMessageStyle");
    }
    

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @param loadingMessage New loadingMessage value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setLoadingMessage(String loadingMessage)  throws IllegalStateException {
        return (ListGrid)setAttribute("loadingMessage", loadingMessage, false);
    }

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @return Current loadingMessage value. Default value is "&amp;nbsp;"
     */
    public String getLoadingMessage()  {
        return getAttributeAsString("loadingMessage");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @param locateColumnsBy New locateColumnsBy value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public ListGrid setLocateColumnsBy(String locateColumnsBy) {
        return (ListGrid)setAttribute("locateColumnsBy", locateColumnsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @return Current locateColumnsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public String getLocateColumnsBy()  {
        return getAttributeAsString("locateColumnsBy");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @param locateRowsBy New locateRowsBy value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public ListGrid setLocateRowsBy(String locateRowsBy) {
        return (ListGrid)setAttribute("locateRowsBy", locateRowsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @return Current locateRowsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public String getLocateRowsBy()  {
        return getAttributeAsString("locateRowsBy");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds this value, the ListGrid shows an edit field of type {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType longTextEditorType} rather than the standard text field
     * when the field enters inline edit mode.
     *
     * @param longTextEditorThreshold New longTextEditorThreshold value. Default value is 255
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setLongTextEditorThreshold(int longTextEditorThreshold) {
        return (ListGrid)setAttribute("longTextEditorThreshold", longTextEditorThreshold, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds this value, the ListGrid shows an edit field of type {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType longTextEditorType} rather than the standard text field
     * when the field enters inline edit mode.
     *
     * @return Current longTextEditorThreshold value. Default value is 255
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public int getLongTextEditorThreshold()  {
        return getAttributeAsInt("longTextEditorThreshold");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds <code>this.longTextEditorThreshold</code> show an edit field of this type rather than
     * the standard text field when the field enters inline edit mode.
     *
     * @param longTextEditorType New longTextEditorType value. Default value is "PopUpTextAreaItem"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setLongTextEditorType(String longTextEditorType) {
        return (ListGrid)setAttribute("longTextEditorType", longTextEditorType, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds <code>this.longTextEditorThreshold</code> show an edit field of this type rather than
     * the standard text field when the field enters inline edit mode.
     *
     * @return Current longTextEditorType value. Default value is "PopUpTextAreaItem"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getLongTextEditorType()  {
        return getAttributeAsString("longTextEditorType");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     *
     * @param maxExpandedRecords New maxExpandedRecords value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setMaxExpandedRecords(Integer maxExpandedRecords) {
        return (ListGrid)setAttribute("maxExpandedRecords", maxExpandedRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     *
     * @return Current maxExpandedRecords value. Default value is null
     */
    public Integer getMaxExpandedRecords()  {
        return getAttributeAsInt("maxExpandedRecords");
    }
    

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @param maxExpandedRecordsPrompt New maxExpandedRecordsPrompt value. Default value is "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setMaxExpandedRecordsPrompt(String maxExpandedRecordsPrompt)  throws IllegalStateException {
        return (ListGrid)setAttribute("maxExpandedRecordsPrompt", maxExpandedRecordsPrompt, false);
    }

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @return Current maxExpandedRecordsPrompt value. Default value is "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getMaxExpandedRecordsPrompt()  {
        return getAttributeAsString("maxExpandedRecordsPrompt");
    }
    

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Updates {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth minFieldWidth} and redraws any columns as needed.
     *
     * @param minFieldWidth New minFieldWidth value. Default value is 15
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setMinFieldWidth(int minFieldWidth) {
        return (ListGrid)setAttribute("minFieldWidth", minFieldWidth, true);
    }

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * @return Current minFieldWidth value. Default value is 15
     */
    public int getMinFieldWidth()  {
        return getAttributeAsInt("minFieldWidth");
    }
    

    /**
     * Sets the {@link com.smartgwt.client.widgets.Canvas#getMinHeight minimum height} for the entire list (smaller than this
     * doesn't tend to work very well).  If not set, this value will be defaulted when {@link
     * com.smartgwt.client.widgets.Canvas#draw draw()} is called to something reasonable based on whether we're showing the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header},  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary summary rows}, and/or the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowEmptyMessage empty message}. Any top or bottom CSS padding specified by
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessageStyle emptyMessageStyle} will be taken into account,
     * increasing <code>minHeight</code> so that the empty message can be shown without overflow. <P> <b>Note:</b> Minimum
     * sizes do not apply to all situations. See {@link com.smartgwt.client.widgets.Canvas#getMinWidth minimum sizing rules}
     * for details.
     *
     * @param minHeight New minHeight value. Default value is varies
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.Canvas#setMinHeight
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public ListGrid setMinHeight(int minHeight) {
        return (ListGrid)setAttribute("minHeight", minHeight, true);
    }

    /**
     * Sets the {@link com.smartgwt.client.widgets.Canvas#getMinHeight minimum height} for the entire list (smaller than this
     * doesn't tend to work very well).  If not set, this value will be defaulted when {@link
     * com.smartgwt.client.widgets.Canvas#draw draw()} is called to something reasonable based on whether we're showing the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header},  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary summary rows}, and/or the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowEmptyMessage empty message}. Any top or bottom CSS padding specified by
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessageStyle emptyMessageStyle} will be taken into account,
     * increasing <code>minHeight</code> so that the empty message can be shown without overflow. <P> <b>Note:</b> Minimum
     * sizes do not apply to all situations. See {@link com.smartgwt.client.widgets.Canvas#getMinWidth minimum sizing rules}
     * for details.
     *
     * @return Current minHeight value. Default value is varies
     * @see com.smartgwt.client.widgets.Canvas#getMinHeight
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getMinHeight()  {
        return getAttributeAsInt("minHeight");
    }
    

    /**
     * Minimum height for ListGrid cells, settable by the skin, based on the size of the  checkbox media used for boolean
     * fields plus minimal surrounding padding.   <code>minimumCellHeight</code> is used by {@link
     * com.smartgwt.client.widgets.Canvas#resizeControls Canvas.resizeControls()} to  avoid shrinking ListGrid rows so much
     * that correct display is impossible.   Do not set minimumCellHeight on a per-instance basis - it's only for use in custom
     * skins.
     *
     * @param minimumCellHeight New minimumCellHeight value. Default value is 20
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setMinimumCellHeight(int minimumCellHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("minimumCellHeight", minimumCellHeight, false);
    }

    /**
     * Minimum height for ListGrid cells, settable by the skin, based on the size of the  checkbox media used for boolean
     * fields plus minimal surrounding padding.   <code>minimumCellHeight</code> is used by {@link
     * com.smartgwt.client.widgets.Canvas#resizeControls Canvas.resizeControls()} to  avoid shrinking ListGrid rows so much
     * that correct display is impossible.   Do not set minimumCellHeight on a per-instance basis - it's only for use in custom
     * skins.
     *
     * @return Current minimumCellHeight value. Default value is 20
     */
    public int getMinimumCellHeight()  {
        return getAttributeAsInt("minimumCellHeight");
    }
    

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @param missingSummaryFieldValue New missingSummaryFieldValue value. Default value is "-"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setMissingSummaryFieldValue(String missingSummaryFieldValue) {
        return (ListGrid)setAttribute("missingSummaryFieldValue", missingSummaryFieldValue, true);
    }

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @return Current missingSummaryFieldValue value. Default value is "-"
     */
    public String getMissingSummaryFieldValue()  {
        return getAttributeAsString("missingSummaryFieldValue");
    }
    

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param modalEditing New modalEditing value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public ListGrid setModalEditing(Boolean modalEditing) {
        return (ListGrid)setAttribute("modalEditing", modalEditing, true);
    }

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     *
     * @return Current modalEditing value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public Boolean getModalEditing()  {
        return getAttributeAsBoolean("modalEditing");
    }
    

    /**
     * Class-level defaults to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically 
     * generated when {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @param multiGroupDialogDefaults New multiGroupDialogDefaults value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public ListGrid setMultiGroupDialogDefaults(MultiGroupDialog multiGroupDialogDefaults)  throws IllegalStateException {
        if (multiGroupDialogDefaults != null) {
            if (multiGroupDialogDefaults.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setMultiGroupDialogDefaults", "MultiGroupDialog");
            }
            multiGroupDialogDefaults.setConfigOnly(true);
        }
        JavaScriptObject config = multiGroupDialogDefaults == null ? null : multiGroupDialogDefaults.getConfig();
        return (ListGrid)setAttribute("multiGroupDialogDefaults", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Class-level defaults to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically 
     * generated when {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @return Current multiGroupDialogDefaults value. Default value is null
     */
    public MultiGroupDialog getMultiGroupDialogDefaults()  {
        MultiGroupDialog properties = new MultiGroupDialog();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("multiGroupDialogDefaults"));
        return properties;
    }
    

    /**
     * Properties to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically  generated when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @param multiGroupDialogProperties New multiGroupDialogProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public ListGrid setMultiGroupDialogProperties(MultiGroupDialog multiGroupDialogProperties)  throws IllegalStateException {
        if (multiGroupDialogProperties != null) {
            if (multiGroupDialogProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setMultiGroupDialogProperties", "MultiGroupDialog");
            }
            multiGroupDialogProperties.setConfigOnly(true);
        }
        JavaScriptObject config = multiGroupDialogProperties == null ? null : multiGroupDialogProperties.getConfig();
        return (ListGrid)setAttribute("multiGroupDialogProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically  generated when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @return Current multiGroupDialogProperties value. Default value is null
     */
    public MultiGroupDialog getMultiGroupDialogProperties()  {
        MultiGroupDialog properties = new MultiGroupDialog();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("multiGroupDialogProperties"));
        return properties;
    }
    
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order. <P> Note - if this property is not explicitly set, navigateOnTab behavior will be  enabled for grids unless
     * {@link com.smartgwt.client.util.isc#setScreenReaderMode screenReader mode is on} in  which case it will be disabled.<br>
     * Developers should be aware that setting <code>navigateOnTab</code> explicitly to true enabled the behavior even in
     * screenReader mode. This may have an impact on the  accessibility of an application - screen reader mode users navigating
     * the application via the keyboard would have to tab through every single data cell in the grid grid before being able to
     * tab to the next component.
     *
     * @param navigateOnTab New navigateOnTab value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setNavigateOnTab(Boolean navigateOnTab) {
        return (ListGrid)setAttribute("navigateOnTab", navigateOnTab, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order. <P> Note - if this property is not explicitly set, navigateOnTab behavior will be  enabled for grids unless
     * {@link com.smartgwt.client.util.isc#setScreenReaderMode screenReader mode is on} in  which case it will be disabled.<br>
     * Developers should be aware that setting <code>navigateOnTab</code> explicitly to true enabled the behavior even in
     * screenReader mode. This may have an impact on the  accessibility of an application - screen reader mode users navigating
     * the application via the keyboard would have to tab through every single data cell in the grid grid before being able to
     * tab to the next component.
     *
     * @return Current navigateOnTab value. Default value is null
     */
    public Boolean getNavigateOnTab()  {
        return getAttributeAsBoolean("navigateOnTab");
    }
    

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param neverValidate New neverValidate value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public ListGrid setNeverValidate(Boolean neverValidate) {
        return (ListGrid)setAttribute("neverValidate", neverValidate, true);
    }

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     *
     * @return Current neverValidate value. Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getNeverValidate()  {
        return getAttributeAsBoolean("neverValidate");
    }
    

    /**
     * If this listGrid is showing the 'newRecordRow' (used for adding new rows to the end of the data), this property
     * determines what message should be displayed in this row.
     *
     * @param newRecordRowMessage New newRecordRowMessage value. Default value is "-- Add New Row --"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setNewRecordRowMessage(String newRecordRowMessage)  throws IllegalStateException {
        return (ListGrid)setAttribute("newRecordRowMessage", newRecordRowMessage, false);
    }

    /**
     * If this listGrid is showing the 'newRecordRow' (used for adding new rows to the end of the data), this property
     * determines what message should be displayed in this row.
     *
     * @return Current newRecordRowMessage value. Default value is "-- Add New Row --"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getNewRecordRowMessage()  {
        return getAttributeAsString("newRecordRowMessage");
    }
    

    /**
     * Text to show for saving the current view as a new "saved search".
     *
     * @param newSearchText New newSearchText value. Default value is "Save View..."
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setNewSearchText(String newSearchText)  throws IllegalStateException {
        return (ListGrid)setAttribute("newSearchText", newSearchText, false);
    }

    /**
     * Text to show for saving the current view as a new "saved search".
     *
     * @return Current newSearchText value. Default value is "Save View..."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getNewSearchText()  {
        return getAttributeAsString("newSearchText");
    }
    

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined
     * with the base style to generate stateful cell styles.
     *
     * @param normalBaseStyle New normalBaseStyle value. Default value is "cell"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setNormalBaseStyle(String normalBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("normalBaseStyle", normalBaseStyle, false);
    }

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined
     * with the base style to generate stateful cell styles.
     *
     * @return Current normalBaseStyle value. Default value is "cell"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getNormalBaseStyle()  {
        return getAttributeAsString("normalBaseStyle");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param normalCellHeight New normalCellHeight value. Default value is 20
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setNormalCellHeight(int normalCellHeight) {
        return (ListGrid)setAttribute("normalCellHeight", normalCellHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     *
     * @return Current normalCellHeight value. Default value is 20
     */
    public int getNormalCellHeight()  {
        return getAttributeAsInt("normalCellHeight");
    }
    

    /**
     * Text to show in menu listing saved searches when there are no saved searches.
     *
     * @param noSavedSearchesText New noSavedSearchesText value. Default value is "[None]"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setNoSavedSearchesText(String noSavedSearchesText)  throws IllegalStateException {
        return (ListGrid)setAttribute("noSavedSearchesText", noSavedSearchesText, false);
    }

    /**
     * Text to show in menu listing saved searches when there are no saved searches.
     *
     * @return Current noSavedSearchesText value. Default value is "[None]"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getNoSavedSearchesText()  {
        return getAttributeAsString("noSavedSearchesText");
    }
    

    /**
     * Default alias to use for groups with no value
     *
     * @param nullGroupTitle New nullGroupTitle value. Default value is '-none-'
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setNullGroupTitle(String nullGroupTitle) {
        return (ListGrid)setAttribute("nullGroupTitle", nullGroupTitle, true);
    }

    /**
     * Default alias to use for groups with no value
     *
     * @return Current nullGroupTitle value. Default value is '-none-'
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getNullGroupTitle()  {
        return getAttributeAsString("nullGroupTitle");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @param offlineMessageStyle New offlineMessageStyle value. Default value is "offlineMessage"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setOfflineMessageStyle(String offlineMessageStyle) {
        return (ListGrid)setAttribute("offlineMessageStyle", offlineMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @return Current offlineMessageStyle value. Default value is "offlineMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getOfflineMessageStyle()  {
        return getAttributeAsString("offlineMessageStyle");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Inline icon shown inside {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} fields when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @return null
     */
    public FormItemIcon getOperatorIcon()  {
        return null;
    }
    
    

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @param originBaseStyle New originBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setOriginBaseStyle(String originBaseStyle) {
        return (ListGrid)setAttribute("originBaseStyle", originBaseStyle, true);
    }

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @return Current originBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getOriginBaseStyle()  {
        return getAttributeAsString("originBaseStyle");
    }
    

    /**
     * Since {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} is configured with overflow: auto by default, no
     * overflow is expected for the {@link com.smartgwt.client.widgets.grid.ListGrid} itself so by default it has overflow:
     * hidden.
     *
     * @param overflow New overflow value. Default value is Canvas.HIDDEN
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.layout.Layout#setOverflow
     */
    public ListGrid setOverflow(Overflow overflow) {
        return (ListGrid)setAttribute("overflow", overflow == null ? null : overflow.getValue(), true);
    }

    /**
     * Since {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} is configured with overflow: auto by default, no
     * overflow is expected for the {@link com.smartgwt.client.widgets.grid.ListGrid} itself so by default it has overflow:
     * hidden.
     *
     * @return Current overflow value. Default value is Canvas.HIDDEN
     * @see com.smartgwt.client.widgets.layout.Layout#getOverflow
     */
    public Overflow getOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("overflow"));
    }
    

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @param poolComponentsPerColumn New poolComponentsPerColumn value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setPoolComponentsPerColumn(Boolean poolComponentsPerColumn) {
        return (ListGrid)setAttribute("poolComponentsPerColumn", poolComponentsPerColumn, true);
    }

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @return Current poolComponentsPerColumn value. Default value is true
     */
    public Boolean getPoolComponentsPerColumn()  {
        Boolean result = getAttributeAsBoolean("poolComponentsPerColumn");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteRowOnFocus hiliteRowOnFocus} is true the current keyboard focus row
     * for navigation via arrow keys, etc, will be hilighted with <code>"Over"</code> styling. This is particularly  valuable
     * to indicate which row has keyboard focus where there are multiple  selected rows, or where the user is navigating
     * without changing selection  (see {@link com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyAction
     * arrowKeyAction}).<br> However, note that as the user interacts with the rows using the mouse, the rollover  styling will
     * be updated to reflect the mouse position if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver
     * showRollOver} is true. <P> When the user rolls the mouse off the grid, the default behavior is to re-style the current
     * focus row with <code>"Over"</code> styling if the grid has keyboard focus. That way a user has a clear visual indication
     * of where navigation  would start. This may be disabled by setting <code>preserveFocusStylingOnMouseOut</code> to false.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param preserveFocusStylingOnMouseOut New preserveFocusStylingOnMouseOut value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setPreserveFocusStylingOnMouseOut(Boolean preserveFocusStylingOnMouseOut) {
        return (ListGrid)setAttribute("preserveFocusStylingOnMouseOut", preserveFocusStylingOnMouseOut, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteRowOnFocus hiliteRowOnFocus} is true the current keyboard focus row
     * for navigation via arrow keys, etc, will be hilighted with <code>"Over"</code> styling. This is particularly  valuable
     * to indicate which row has keyboard focus where there are multiple  selected rows, or where the user is navigating
     * without changing selection  (see {@link com.smartgwt.client.widgets.grid.ListGrid#getArrowKeyAction
     * arrowKeyAction}).<br> However, note that as the user interacts with the rows using the mouse, the rollover  styling will
     * be updated to reflect the mouse position if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver
     * showRollOver} is true. <P> When the user rolls the mouse off the grid, the default behavior is to re-style the current
     * focus row with <code>"Over"</code> styling if the grid has keyboard focus. That way a user has a clear visual indication
     * of where navigation  would start. This may be disabled by setting <code>preserveFocusStylingOnMouseOut</code> to false.
     *
     * @return Current preserveFocusStylingOnMouseOut value. Default value is true
     */
    public Boolean getPreserveFocusStylingOnMouseOut()  {
        Boolean result = getAttributeAsBoolean("preserveFocusStylingOnMouseOut");
        return result == null ? true : result;
    }
    

    /**
     * Should cells be written out with css that will preserve whitespace? <P> If true, depending on the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, the css generated for cells will use the <a
     * href='https://www.w3.org/wiki/CSS/Properties/white-space#Values' target='_blank'>white-space</a> property values of
     * <code>pre</code> or <code>pre-wrap</code>. This avoids collapsing sequences of whitespace without requiring special
     * <i>&amp;nbsp;</i> characters.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param preserveWhitespace New preserveWhitespace value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setPreserveWhitespace(Boolean preserveWhitespace) {
        return (ListGrid)setAttribute("preserveWhitespace", preserveWhitespace, true);
    }

    /**
     * Should cells be written out with css that will preserve whitespace? <P> If true, depending on the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, the css generated for cells will use the <a
     * href='https://www.w3.org/wiki/CSS/Properties/white-space#Values' target='_blank'>white-space</a> property values of
     * <code>pre</code> or <code>pre-wrap</code>. This avoids collapsing sequences of whitespace without requiring special
     * <i>&amp;nbsp;</i> characters.
     *
     * @return Current preserveWhitespace value. Default value is false
     */
    public Boolean getPreserveWhitespace()  {
        Boolean result = getAttributeAsBoolean("preserveWhitespace");
        return result == null ? false : result;
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @param printAutoFit New printAutoFit value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintAutoFit(Boolean printAutoFit) {
        return (ListGrid)setAttribute("printAutoFit", printAutoFit, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @return Current printAutoFit value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintAutoFit()  {
        Boolean result = getAttributeAsBoolean("printAutoFit");
        return result == null ? true : result;
    }
    

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @param printBaseStyle New printBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintBaseStyle(String printBaseStyle) {
        return (ListGrid)setAttribute("printBaseStyle", printBaseStyle, true);
    }

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @return Current printBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBaseStyle()  {
        return getAttributeAsString("printBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when {@link
     * com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanBaseStyle New printBooleanBaseStyle value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setPrintBooleanBaseStyle(String printBooleanBaseStyle)  throws IllegalStateException {
        return (ListGrid)setAttribute("printBooleanBaseStyle", printBooleanBaseStyle, false);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when {@link
     * com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printBooleanBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getPrintBooleanBaseStyle()  {
        return getAttributeAsString("printBooleanBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintUncheckedImage
     * CheckboxItem.printUncheckedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanFalseImage New printBooleanFalseImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setPrintBooleanFalseImage(String printBooleanFalseImage) {
        return (ListGrid)setAttribute("printBooleanFalseImage", printBooleanFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintUncheckedImage
     * CheckboxItem.printUncheckedImage}.
     *
     * @return Current printBooleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getPrintBooleanFalseImage()  {
        return getAttributeAsString("printBooleanFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when
     * {@link com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} are unset, this will be set
     * to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintPartialSelectedImage
     * CheckboxItem.printPartialSelectedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanPartialImage New printBooleanPartialImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setPrintBooleanPartialImage(String printBooleanPartialImage) {
        return (ListGrid)setAttribute("printBooleanPartialImage", printBooleanPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when
     * {@link com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} are unset, this will be set
     * to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintPartialSelectedImage
     * CheckboxItem.printPartialSelectedImage}.
     *
     * @return Current printBooleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getPrintBooleanPartialImage()  {
        return getAttributeAsString("printBooleanPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintCheckedImage
     * CheckboxItem.printCheckedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanTrueImage New printBooleanTrueImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public ListGrid setPrintBooleanTrueImage(String printBooleanTrueImage) {
        return (ListGrid)setAttribute("printBooleanTrueImage", printBooleanTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintCheckedImage
     * CheckboxItem.printCheckedImage}.
     *
     * @return Current printBooleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getPrintBooleanTrueImage()  {
        return getAttributeAsString("printBooleanTrueImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldFalseImage New printCheckboxFieldFalseImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintCheckboxFieldFalseImage(String printCheckboxFieldFalseImage) {
        return (ListGrid)setAttribute("printCheckboxFieldFalseImage", printCheckboxFieldFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldFalseImage()  {
        return getAttributeAsString("printCheckboxFieldFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldPartialImage New printCheckboxFieldPartialImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintCheckboxFieldPartialImage(String printCheckboxFieldPartialImage) {
        return (ListGrid)setAttribute("printCheckboxFieldPartialImage", printCheckboxFieldPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldPartialImage()  {
        return getAttributeAsString("printCheckboxFieldPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldTrueImage New printCheckboxFieldTrueImage value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintCheckboxFieldTrueImage(String printCheckboxFieldTrueImage) {
        return (ListGrid)setAttribute("printCheckboxFieldTrueImage", printCheckboxFieldTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldTrueImage()  {
        return getAttributeAsString("printCheckboxFieldTrueImage");
    }
    

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @param printHeaderStyle New printHeaderStyle value. Default value is "printHeader"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintHeaderStyle(String printHeaderStyle) {
        return (ListGrid)setAttribute("printHeaderStyle", printHeaderStyle, true);
    }

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @return Current printHeaderStyle value. Default value is "printHeader"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintHeaderStyle()  {
        return getAttributeAsString("printHeaderStyle");
    }
    

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printMaxRows New printMaxRows value. Default value is 100
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintMaxRows(int printMaxRows) {
        return (ListGrid)setAttribute("printMaxRows", printMaxRows, true);
    }

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     *
     * @return Current printMaxRows value. Default value is 100
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public int getPrintMaxRows()  {
        return getAttributeAsInt("printMaxRows");
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @param printWrapCells New printWrapCells value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public ListGrid setPrintWrapCells(Boolean printWrapCells) {
        return (ListGrid)setAttribute("printWrapCells", printWrapCells, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @return Current printWrapCells value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintWrapCells()  {
        Boolean result = getAttributeAsBoolean("printWrapCells");
        return result == null ? true : result;
    }
    

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @param quickDrawAheadRatio New quickDrawAheadRatio value. Default value is 2.0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setQuickDrawAheadRatio(float quickDrawAheadRatio) {
        return (ListGrid)setAttribute("quickDrawAheadRatio", quickDrawAheadRatio, true);
    }

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @return Current quickDrawAheadRatio value. Default value is 2.0
     */
    public float getQuickDrawAheadRatio()  {
        return getAttributeAsFloat("quickDrawAheadRatio");
    }
    

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordBaseStyleProperty New recordBaseStyleProperty value. Default value is "_baseStyle"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setRecordBaseStyleProperty(String recordBaseStyleProperty) {
        return (ListGrid)setAttribute("recordBaseStyleProperty", recordBaseStyleProperty, true);
    }

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     *
     * @return Current recordBaseStyleProperty value. Default value is "_baseStyle"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRecordBaseStyleProperty()  {
        return getAttributeAsString("recordBaseStyleProperty");
    }
    

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanRemoveProperty New recordCanRemoveProperty value. Default value is "_canRemove"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setRecordCanRemoveProperty(String recordCanRemoveProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordCanRemoveProperty", recordCanRemoveProperty, false);
    }

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     *
     * @return Current recordCanRemoveProperty value. Default value is "_canRemove"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordCanRemoveProperty()  {
        return getAttributeAsString("recordCanRemoveProperty");
    }
    

    /**
     * If set to false on a record, selection of that record is disallowed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanSelectProperty New recordCanSelectProperty value. Default value is "canSelect"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setRecordCanSelectProperty(String recordCanSelectProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordCanSelectProperty", recordCanSelectProperty, false);
    }

    /**
     * If set to false on a record, selection of that record is disallowed.
     *
     * @return Current recordCanSelectProperty value. Default value is "canSelect"
     */
    public String getRecordCanSelectProperty()  {
        return getAttributeAsString("recordCanSelectProperty");
    }
    

    /**
     * If this property is set on a record it will designate the WAI ARIA role for cells within this records row
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCellRoleProperty New recordCellRoleProperty value. Default value is "cellRole"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordCellRoleProperty(String recordCellRoleProperty) {
        return (ListGrid)setAttribute("recordCellRoleProperty", recordCellRoleProperty, true);
    }

    /**
     * If this property is set on a record it will designate the WAI ARIA role for cells within this records row
     *
     * @return Current recordCellRoleProperty value. Default value is "cellRole"
     */
    public String getRecordCellRoleProperty()  {
        return getAttributeAsString("recordCellRoleProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentHeight recordComponent height. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setVirtualScrolling
     */
    public ListGrid setRecordComponentHeight(Integer recordComponentHeight) {
        return (ListGrid)setAttribute("recordComponentHeight", recordComponentHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * @return Current recordComponentHeight value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling
     */
    public Integer getRecordComponentHeight()  {
        return getAttributeAsInt("recordComponentHeight");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent updateRecordComponent()} to apply any changes to make
     * reused components applicable to the new record they appear in, if necessary.  For example, if you have several controls
     * in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentPoolingMode New recordComponentPoolingMode value. Default value is "viewport"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordComponentPoolingMode(RecordComponentPoolingMode recordComponentPoolingMode) {
        return (ListGrid)setAttribute("recordComponentPoolingMode", recordComponentPoolingMode == null ? null : recordComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent updateRecordComponent()} to apply any changes to make
     * reused components applicable to the new record they appear in, if necessary.  For example, if you have several controls
     * in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     *
     * @return Current recordComponentPoolingMode value. Default value is "viewport"
     */
    public RecordComponentPoolingMode getRecordComponentPoolingMode()  {
        return EnumUtil.getEnum(RecordComponentPoolingMode.values(), getAttribute("recordComponentPoolingMode"));
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} may be set to specify
     * where the component should render within  the row or cell, and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} / {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft} may  be set to indent recordComponents
     * within their parent cells.  Note that if unset, the component will show up at the top/left edge  for components embedded
     * within an entire row, or for per-cell components, cell  align and valign will be respected.  Note also that, when
     * rendering components "within"  cells, specified component heights will be respected and will change the height of the 
     * row.  However, if you want components to completely fill a cell at it's default height,  set height: "100%" or rows will
     * render at the default height of the component. </li> <li><code>"expand"</code>: the component will be written into the
     * cell below the  normal cell content, causing the cell to expand vertically to accommodate it. <li><code>null</code>: If
     * this attribute is unset, we will default to showing  recordComponents with position <code>"within"</code> if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} is true, otherwise
     * using <code>"expand"</code>  logic. </ul>
     *
     * @param recordComponentPosition New recordComponentPosition value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponents
     */
    public ListGrid setRecordComponentPosition(EmbeddedPosition recordComponentPosition) {
        return (ListGrid)setAttribute("recordComponentPosition", recordComponentPosition == null ? null : recordComponentPosition.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} may be set to specify
     * where the component should render within  the row or cell, and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} / {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft} may  be set to indent recordComponents
     * within their parent cells.  Note that if unset, the component will show up at the top/left edge  for components embedded
     * within an entire row, or for per-cell components, cell  align and valign will be respected.  Note also that, when
     * rendering components "within"  cells, specified component heights will be respected and will change the height of the 
     * row.  However, if you want components to completely fill a cell at it's default height,  set height: "100%" or rows will
     * render at the default height of the component. </li> <li><code>"expand"</code>: the component will be written into the
     * cell below the  normal cell content, causing the cell to expand vertically to accommodate it. <li><code>null</code>: If
     * this attribute is unset, we will default to showing  recordComponents with position <code>"within"</code> if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} is true, otherwise
     * using <code>"expand"</code>  logic. </ul>
     *
     * @return Current recordComponentPosition value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents
     */
    public EmbeddedPosition getRecordComponentPosition()  {
        return EnumUtil.getEnum(EmbeddedPosition.values(), getAttribute("recordComponentPosition"));
    }
    
    

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordDetailDSProperty New recordDetailDSProperty value. Default value is "detailDS"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordDetailDSProperty(String recordDetailDSProperty) {
        return (ListGrid)setAttribute("recordDetailDSProperty", recordDetailDSProperty, true);
    }

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     *
     * @return Current recordDetailDSProperty value. Default value is "detailDS"
     */
    public String getRecordDetailDSProperty()  {
        return getAttributeAsString("recordDetailDSProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop recordDrop()} event handler.
     *
     * @param recordDropAppearance New recordDropAppearance value. Default value is ListGrid.BETWEEN
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordDropAppearance(RecordDropAppearance recordDropAppearance) {
        return (ListGrid)setAttribute("recordDropAppearance", recordDropAppearance == null ? null : recordDropAppearance.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop recordDrop()} event handler.
     *
     * @return Current recordDropAppearance value. Default value is ListGrid.BETWEEN
     */
    public RecordDropAppearance getRecordDropAppearance()  {
        return EnumUtil.getEnum(RecordDropAppearance.values(), getAttribute("recordDropAppearance"));
    }
    

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordEditProperty New recordEditProperty value. Default value is "_canEdit"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setRecordEditProperty(String recordEditProperty) {
        return (ListGrid)setAttribute("recordEditProperty", recordEditProperty, true);
    }

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     *
     * @return Current recordEditProperty value. Default value is "_canEdit"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordEditProperty()  {
        return getAttributeAsString("recordEditProperty");
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @param recordEnabledProperty New recordEnabledProperty value. Default value is "enabled"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public ListGrid setRecordEnabledProperty(String recordEnabledProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordEnabledProperty", recordEnabledProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @return Current recordEnabledProperty value. Default value is "enabled"
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public String getRecordEnabledProperty()  {
        return getAttributeAsString("recordEnabledProperty");
    }
    

    /**
     * If this property is set on a record it will designate a mapping of WAI ARIA attribute names and values for this record's
     * row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordRowAriaStateProperty New recordRowAriaStateProperty value. Default value is "rowAriaState"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordRowAriaStateProperty(String recordRowAriaStateProperty) {
        return (ListGrid)setAttribute("recordRowAriaStateProperty", recordRowAriaStateProperty, true);
    }

    /**
     * If this property is set on a record it will designate a mapping of WAI ARIA attribute names and values for this record's
     * row.
     *
     * @return Current recordRowAriaStateProperty value. Default value is "rowAriaState"
     */
    public String getRecordRowAriaStateProperty()  {
        return getAttributeAsString("recordRowAriaStateProperty");
    }
    

    /**
     * If this property is set on a record it will designate the WAI ARIA role for this record's row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordRowRoleProperty New recordRowRoleProperty value. Default value is "rowRole"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRecordRowRoleProperty(String recordRowRoleProperty) {
        return (ListGrid)setAttribute("recordRowRoleProperty", recordRowRoleProperty, true);
    }

    /**
     * If this property is set on a record it will designate the WAI ARIA role for this record's row.
     *
     * @return Current recordRowRoleProperty value. Default value is "rowRole"
     */
    public String getRecordRowRoleProperty()  {
        return getAttributeAsString("recordRowRoleProperty");
    }
    

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponent getRecordComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being shown at the row.
     * Be sure the record screen meets these {@link com.smartgwt.client.widgets.Canvas#getAutoPopulateData requirements} to
     * utilize the <code>dataContext</code>.
     *
     * @param recordScreen New recordScreen value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setRecordScreen(String recordScreen)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordScreen", recordScreen, false);
    }

    /**
     * Screen to create (via {@link com.smartgwt.client.rpc.RPCManager#createScreen createScreen()}) in lieu of calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponent getRecordComponent()}. <P> If this grid has a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, the created screen is provided with a {@link
     * com.smartgwt.client.widgets.Canvas#getDataContext Canvas.dataContext} that includes the record being shown at the row.
     * Be sure the record screen meets these {@link com.smartgwt.client.widgets.Canvas#getAutoPopulateData requirements} to
     * utilize the <code>dataContext</code>.
     *
     * @return Current recordScreen value. Default value is null
     */
    public String getRecordScreen()  {
        return getAttributeAsString("recordScreen");
    }
    

    /**
     * Name of the property that can be set on a per-record basis to disabled rollover for an individual record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @param recordShowRollOverProperty New recordShowRollOverProperty value. Default value is "showRollOver"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setRecordShowRollOverProperty(String recordShowRollOverProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordShowRollOverProperty", recordShowRollOverProperty, false);
    }

    /**
     * Name of the property that can be set on a per-record basis to disabled rollover for an individual record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @return Current recordShowRollOverProperty value. Default value is "showRollOver"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRecordShowRollOverProperty()  {
        return getAttributeAsString("recordShowRollOverProperty");
    }
    

    /**
     * Prefix prepended to the name of a {@link com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction
     * "summary"} {@link com.smartgwt.client.widgets.grid.ListGridField#getType type} field when accessing its value as record
     * metadata. The Framework may write out this value to make rendering the cell values or calculating a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary row} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows} more efficient.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordSummaryAttributePrefix New recordSummaryAttributePrefix value. Default value is "_"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridField#setType
     * @see com.smartgwt.client.widgets.grid.ListGridField#setRecordSummaryFunction
     */
    public ListGrid setRecordSummaryAttributePrefix(String recordSummaryAttributePrefix)  throws IllegalStateException {
        return (ListGrid)setAttribute("recordSummaryAttributePrefix", recordSummaryAttributePrefix, false);
    }

    /**
     * Prefix prepended to the name of a {@link com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction
     * "summary"} {@link com.smartgwt.client.widgets.grid.ListGridField#getType type} field when accessing its value as record
     * metadata. The Framework may write out this value to make rendering the cell values or calculating a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary row} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows} more efficient.
     *
     * @return Current recordSummaryAttributePrefix value. Default value is "_"
     * @see com.smartgwt.client.widgets.grid.ListGridField#getType
     * @see com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction
     */
    public String getRecordSummaryAttributePrefix()  {
        return getAttributeAsString("recordSummaryAttributePrefix");
    }
    

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordSummaryBaseStyle New recordSummaryBaseStyle value. Default value is "recordSummaryCell"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setRecordSummaryBaseStyle(String recordSummaryBaseStyle) {
        return (ListGrid)setAttribute("recordSummaryBaseStyle", recordSummaryBaseStyle, true);
    }

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     *
     * @return Current recordSummaryBaseStyle value. Default value is "recordSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getRecordSummaryBaseStyle()  {
        return getAttributeAsString("recordSummaryBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removedCSSText New removedCSSText value. Default value is "text-decoration:line-through;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setRemovedCSSText(String removedCSSText) {
        return (ListGrid)setAttribute("removedCSSText", removedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     *
     * @return Current removedCSSText value. Default value is "text-decoration:line-through;"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRemovedCSSText()  {
        return getAttributeAsString("removedCSSText");
    }
    
    

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @param removeFieldProperties New removeFieldProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setRemoveFieldProperties(ListGridField removeFieldProperties)  throws IllegalStateException {
        JavaScriptObject config = removeFieldProperties == null ? null : removeFieldProperties.getJsObj();
        return (ListGrid)setAttribute("removeFieldProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @return Current removeFieldProperties value. Default value is null
     */
    public ListGridField getRemoveFieldProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("removeFieldProperties"));
    }
    

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removeFieldTitle New removeFieldTitle value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRemoveFieldTitle(String removeFieldTitle) {
        return (ListGrid)setAttribute("removeFieldTitle", removeFieldTitle, true);
    }

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     *
     * @return Current removeFieldTitle value. Default value is "&amp;nbsp;"
     */
    public String getRemoveFieldTitle()  {
        return getAttributeAsString("removeFieldTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @param removeIcon New removeIcon value. Default value is "[SKIN]/actions/remove.png"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public ListGrid setRemoveIcon(String removeIcon)  throws IllegalStateException {
        return (ListGrid)setAttribute("removeIcon", removeIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @return Current removeIcon value. Default value is "[SKIN]/actions/remove.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getRemoveIcon()  {
        return getAttributeAsString("removeIcon");
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @param removeIconSize New removeIconSize value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRemoveIconSize(int removeIconSize) {
        return (ListGrid)setAttribute("removeIconSize", removeIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @return Current removeIconSize value. Default value is 16
     */
    public int getRemoveIconSize()  {
        return getAttributeAsInt("removeIconSize");
    }
    

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdate New reselectOnUpdate value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setReselectOnUpdate(boolean reselectOnUpdate)  throws IllegalStateException {
        return (ListGrid)setAttribute("reselectOnUpdate", reselectOnUpdate, false);
    }

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     *
     * @return Current reselectOnUpdate value. Default value is true
     */
    public boolean getReselectOnUpdate()  {
        Boolean result = getAttributeAsBoolean("reselectOnUpdate");
        return result == null ? true : result;
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdateNotifications New reselectOnUpdateNotifications value. Default value is "selectionChanged"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setReselectOnUpdateNotifications(SelectionNotificationType reselectOnUpdateNotifications) {
        return (ListGrid)setAttribute("reselectOnUpdateNotifications", reselectOnUpdateNotifications == null ? null : reselectOnUpdateNotifications.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     *
     * @return Current reselectOnUpdateNotifications value. Default value is "selectionChanged"
     */
    public SelectionNotificationType getReselectOnUpdateNotifications()  {
        return EnumUtil.getEnum(SelectionNotificationType.values(), getAttribute("reselectOnUpdateNotifications"));
    }
    

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param resizeFieldsInRealTime New resizeFieldsInRealTime value. Default value is see below
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setResizeFieldsInRealTime(boolean resizeFieldsInRealTime) {
        return (ListGrid)setAttribute("resizeFieldsInRealTime", resizeFieldsInRealTime, true);
    }

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     *
     * @return Current resizeFieldsInRealTime value. Default value is see below
     */
    public boolean getResizeFieldsInRealTime()  {
        Boolean result = getAttributeAsBoolean("resizeFieldsInRealTime");
        return result == null ? false : result;
    }
    

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign ListGridField.cellAlign} be reversed (so an
     * <code>align:"right"</code> field will have content aligned on the left and vice versa)? <P> This is true by default to
     * match user expectation that text flows from start-to end and is aligned with the start of text flow (left in LTR mode,
     * right in RTL mode) by default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @param reverseRTLAlign New reverseRTLAlign value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setReverseRTLAlign(Boolean reverseRTLAlign) {
        return (ListGrid)setAttribute("reverseRTLAlign", reverseRTLAlign, true);
    }

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign ListGridField.cellAlign} be reversed (so an
     * <code>align:"right"</code> field will have content aligned on the left and vice versa)? <P> This is true by default to
     * match user expectation that text flows from start-to end and is aligned with the start of text flow (left in LTR mode,
     * right in RTL mode) by default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @return Current reverseRTLAlign value. Default value is true
     */
    public Boolean getReverseRTLAlign()  {
        Boolean result = getAttributeAsBoolean("reverseRTLAlign");
        return result == null ? true : result;
    }
    
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code> over a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rotatedHeaderMenuButtonHeight New rotatedHeaderMenuButtonHeight value. Default value is "100%"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderMenuButtonHeight
     */
    public ListGrid setRotatedHeaderMenuButtonHeight(int rotatedHeaderMenuButtonHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("rotatedHeaderMenuButtonHeight", rotatedHeaderMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code> over a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     *
     * @return Current rotatedHeaderMenuButtonHeight value. Default value is "100%"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonHeight
     */
    public int getRotatedHeaderMenuButtonHeight()  {
        return getAttributeAsInt("rotatedHeaderMenuButtonHeight");
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code> over a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rotatedHeaderMenuButtonHeight New rotatedHeaderMenuButtonHeight value. Default value is "100%"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderMenuButtonHeight
     */
    public ListGrid setRotatedHeaderMenuButtonHeight(String rotatedHeaderMenuButtonHeight)  throws IllegalStateException {
        return (ListGrid)setAttribute("rotatedHeaderMenuButtonHeight", rotatedHeaderMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code> over a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     *
     * @return Current rotatedHeaderMenuButtonHeight value. Default value is "100%"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonHeight
     */
    public String getRotatedHeaderMenuButtonHeightAsString()  {
        return getAttributeAsString("rotatedHeaderMenuButtonHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code> over a  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rotatedHeaderMenuButtonWidth New rotatedHeaderMenuButtonWidth value. Default value is 16
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderMenuButtonWidth
     */
    public ListGrid setRotatedHeaderMenuButtonWidth(int rotatedHeaderMenuButtonWidth)  throws IllegalStateException {
        return (ListGrid)setAttribute("rotatedHeaderMenuButtonWidth", rotatedHeaderMenuButtonWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code> over a  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle rotated} header button.
     *
     * @return Current rotatedHeaderMenuButtonWidth value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonWidth
     */
    public int getRotatedHeaderMenuButtonWidth()  {
        return getAttributeAsInt("rotatedHeaderMenuButtonWidth");
    }
    

    /**
     * Whether to rotate the field titles so they're rendered vertically from bottom to top. Can be overridden for individual
     * fields by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle ListGridField.rotateTitle}. <P>
     * Note that you can manually set the header height and field widths as you please when using this feature, but it's not
     * compatible with {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitHeaderHeights autoFitHeaderHeights} or
     * autofitting of field widths in any {@link com.smartgwt.client.types.AutoFitWidthApproach} other than "value". <P> You
     * can use {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleVAlign headerTitleVAlign} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValign ListGridField.valign} to control vertical positioning of the
     * titles, and {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign ListGridField.align} to control the
     * horizontal. You may also choose between {@link com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles clipping}
     * or  {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles wrapping}, and set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} as you please (which reserves
     * space in each header button for the header menu button). <P> Note that this feature is incompatible with clipping via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles clipHeaderTitles}:false, and may not work with
     * older browsers, particular IE versions before IE10.  The "TreeFrog" and "Basic" {@link com.smartgwt.client.docs.Skins
     * skins} are not supported for this feature.
     *
     * @param rotateHeaderTitles New rotateHeaderTitles value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderTitleVAlign
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValign
     * @see com.smartgwt.client.widgets.grid.ListGridField#setRotateTitle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rotated_titles" target="examples">Rotated Titles Example</a>
     */
    public ListGrid setRotateHeaderTitles(Boolean rotateHeaderTitles)  throws IllegalStateException {
        return (ListGrid)setAttribute("rotateHeaderTitles", rotateHeaderTitles, false);
    }

    /**
     * Whether to rotate the field titles so they're rendered vertically from bottom to top. Can be overridden for individual
     * fields by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle ListGridField.rotateTitle}. <P>
     * Note that you can manually set the header height and field widths as you please when using this feature, but it's not
     * compatible with {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitHeaderHeights autoFitHeaderHeights} or
     * autofitting of field widths in any {@link com.smartgwt.client.types.AutoFitWidthApproach} other than "value". <P> You
     * can use {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleVAlign headerTitleVAlign} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValign ListGridField.valign} to control vertical positioning of the
     * titles, and {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign ListGridField.align} to control the
     * horizontal. You may also choose between {@link com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles clipping}
     * or  {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles wrapping}, and set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} as you please (which reserves
     * space in each header button for the header menu button). <P> Note that this feature is incompatible with clipping via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles clipHeaderTitles}:false, and may not work with
     * older browsers, particular IE versions before IE10.  The "TreeFrog" and "Basic" {@link com.smartgwt.client.docs.Skins
     * skins} are not supported for this feature.
     *
     * @return Current rotateHeaderTitles value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleVAlign
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValign
     * @see com.smartgwt.client.widgets.grid.ListGridField#getRotateTitle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rotated_titles" target="examples">Rotated Titles Example</a>
     */
    public Boolean getRotateHeaderTitles()  {
        return getAttributeAsBoolean("rotateHeaderTitles");
    }
    

    /**
     * Returns a mapping of default WAI ARIA attributes for rows within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowAriaState New rowAriaState value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRowAriaState(Map rowAriaState) {
        return (ListGrid)setAttribute("rowAriaState", rowAriaState, true);
    }

    /**
     * Returns a mapping of default WAI ARIA attributes for rows within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}
     *
     * @return Returns a map of {@link com.smartgwt.client.widgets.Canvas#getAriaState WAI ARIA state attribute values} to be written
     * into rows within this grid. <P> <P> Default implementation returns an object with combined properties from any specified
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState row aria state default object}, overlaid with any
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordRowAriaStateProperty recordRowAriaStateProperty} properties
     * specified on the record itself, plus the following attributes: <ul> <li><code>setsize</code> - total row count for the
     * grid if {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} is set to   <code>"list"</code></li>
     * <li><code>posinset</code> - index of the row if {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole}
     * is set to <code>"list"</code></li> <li><code>rowindex</code> - index of the row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} is set to <code>"grid"</code></li>
     * <li><code>selected</code> - true if the record is {@link com.smartgwt.client.widgets.grid.ListGrid#getSelection
     * selected}</li> <li><code>expanded</code> - true for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords
     * expanded records}   or {@link com.smartgwt.client.widgets.tree.Tree#isOpen open folders}</li> </ul>. Default value is null
     */
    public Map getRowAriaState()  {
        return getAttributeAsMap("rowAriaState");
    }
    

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @param rowEndEditAction New rowEndEditAction value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setRowEndEditAction(RowEndEditAction rowEndEditAction) {
        return (ListGrid)setAttribute("rowEndEditAction", rowEndEditAction == null ? null : rowEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @return Current rowEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public RowEndEditAction getRowEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("rowEndEditAction"));
    }
    

    /**
     * An automatically generated field that displays the current row number when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true.
     * <p>
     * This component is an AutoChild named "rowNumberField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current rowNumberField value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getRowNumberField() throws IllegalStateException {
        errorIfNotCreated("rowNumberField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("rowNumberField"));
    }
    

    /**
     * The number to start the row-count from - default value is 1.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStart New rowNumberStart value. Default value is 1
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRowNumberStart(int rowNumberStart) {
        return (ListGrid)setAttribute("rowNumberStart", rowNumberStart, true);
    }

    /**
     * The number to start the row-count from - default value is 1.
     *
     * @return Current rowNumberStart value. Default value is 1
     */
    public int getRowNumberStart()  {
        return getAttributeAsInt("rowNumberStart");
    }
    

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStyle New rowNumberStyle value. Default value is "specialCol"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public ListGrid setRowNumberStyle(String rowNumberStyle) {
        return (ListGrid)setAttribute("rowNumberStyle", rowNumberStyle, true);
    }

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     *
     * @return Current rowNumberStyle value. Default value is "specialCol"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getRowNumberStyle()  {
        return getAttributeAsString("rowNumberStyle");
    }
    

    /**
     * Returns the default WAI ARIA role for rows within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowRole getRowRole()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowRole New rowRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRowRole(String rowRole) {
        return (ListGrid)setAttribute("rowRole", rowRole, true);
    }

    /**
     * Returns the default WAI ARIA role for rows within this listGrid. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowRole getRowRole()}
     *
     * @return Returns the WAI ARIA role for rows within this listGrid. <P> If the record has a value for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordRowRoleProperty recordRowRoleProperty}, this will be respected.<br>
     * Otherwise if {@link com.smartgwt.client.widgets.grid.ListGrid#getRowRole rowRole} is specified, it will be used. <P> If
     * the property is not explicitly set, default implementation will  return <code>"separator"</code> for separator rows,
     * <code>"listitem"</code> for data rows if this listGrid has  {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * role:"list"}, or <code>"row"</code> for data rows if this  listGrid has <code>ariaRole:"grid"</code>. Default value is null
     */
    public String getRowRole()  {
        return getAttributeAsString("rowRole");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowSpanEditMode New rowSpanEditMode value. Default value is "first"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setRowSpanEditMode(RowSpanEditMode rowSpanEditMode) {
        return (ListGrid)setAttribute("rowSpanEditMode", rowSpanEditMode == null ? null : rowSpanEditMode.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     *
     * @return Current rowSpanEditMode value. Default value is "first"
     */
    public RowSpanEditMode getRowSpanEditMode()  {
        return EnumUtil.getEnum(RowSpanEditMode.values(), getAttribute("rowSpanEditMode"));
    }
    

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @param rowSpanSelectionMode New rowSpanSelectionMode value. Default value is "forward"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setRowSpanSelectionMode(RowSpanSelectionMode rowSpanSelectionMode)  throws IllegalStateException {
        return (ListGrid)setAttribute("rowSpanSelectionMode", rowSpanSelectionMode == null ? null : rowSpanSelectionMode.getValue(), false);
    }

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @return Current rowSpanSelectionMode value. Default value is "forward"
     */
    public RowSpanSelectionMode getRowSpanSelectionMode()  {
        return EnumUtil.getEnum(RowSpanSelectionMode.values(), getAttribute("rowSpanSelectionMode"));
    }
    

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @param saveByCell New saveByCell value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setSaveByCell(Boolean saveByCell) {
        return (ListGrid)setAttribute("saveByCell", saveByCell, true);
    }

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @return Current saveByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSaveByCell()  {
        return getAttributeAsBoolean("saveByCell");
    }
    

    /**
     * Should the current {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria filter-criteria} be included
     * along with other details when saving this grid's {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState
     * view-state}? <P> If true, the current criteria will be saved when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState getViewState()} and will be applied to the grid via a filter when
     * calling {@link com.smartgwt.client.widgets.grid.ListGrid#setViewState setViewState()}. <P> Notes <ul> <li>If this grid
     * has never actually fetched data, criteria will not be included <li>If this flag is set to <code>false</code>, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setViewState setViewState()} will not      modify the grid's filter even if
     * criteria were included when viewState was stored.</li> </ul>
     *
     * @param saveCriteriaInViewState New saveCriteriaInViewState value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#getUserCriteriaState
     * @see com.smartgwt.client.widgets.grid.ListGrid#setUserCriteriaState
     */
    public ListGrid setSaveCriteriaInViewState(Boolean saveCriteriaInViewState) {
        return (ListGrid)setAttribute("saveCriteriaInViewState", saveCriteriaInViewState, true);
    }

    /**
     * Should the current {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria filter-criteria} be included
     * along with other details when saving this grid's {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState
     * view-state}? <P> If true, the current criteria will be saved when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState getViewState()} and will be applied to the grid via a filter when
     * calling {@link com.smartgwt.client.widgets.grid.ListGrid#setViewState setViewState()}. <P> Notes <ul> <li>If this grid
     * has never actually fetched data, criteria will not be included <li>If this flag is set to <code>false</code>, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setViewState setViewState()} will not      modify the grid's filter even if
     * criteria were included when viewState was stored.</li> </ul>
     *
     * @return Current saveCriteriaInViewState value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getUserCriteriaState
     * @see com.smartgwt.client.widgets.grid.ListGrid#setUserCriteriaState
     */
    public Boolean getSaveCriteriaInViewState()  {
        Boolean result = getAttributeAsBoolean("saveCriteriaInViewState");
        return result == null ? true : result;
    }
    

    /**
     * Saves the name of the default search to localStorage, under the key "sc_defaultSearch:" + minimal locator. <p> See
     * {@link com.smartgwt.client.data.SavedSearches} "Default Searches" for why this is stored separately from the search
     * itself if there is no saved default search, but there is a {@link com.smartgwt.client.data.SavedSearches#getDefaultField
     * SavedSearches.defaultField}, the first user-specfic search marked default will be used, otherwise the first admn search
     * marked default <p> If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData autoFetchData} is enabled, the
     * autoFetch will be postponed as needed until a default search can be looked up and applied.  If anything fails in the
     * default search lookup, an autoFetch will still be performed (without any saved search information)
     *
     * @param saveDefaultSearch New saveDefaultSearch value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setSaveDefaultSearch(boolean saveDefaultSearch)  throws IllegalStateException {
        return (ListGrid)setAttribute("saveDefaultSearch", saveDefaultSearch, false);
    }

    /**
     * Saves the name of the default search to localStorage, under the key "sc_defaultSearch:" + minimal locator. <p> See
     * {@link com.smartgwt.client.data.SavedSearches} "Default Searches" for why this is stored separately from the search
     * itself if there is no saved default search, but there is a {@link com.smartgwt.client.data.SavedSearches#getDefaultField
     * SavedSearches.defaultField}, the first user-specfic search marked default will be used, otherwise the first admn search
     * marked default <p> If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData autoFetchData} is enabled, the
     * autoFetch will be postponed as needed until a default search can be looked up and applied.  If anything fails in the
     * default search lookup, an autoFetch will still be performed (without any saved search information)
     *
     * @return Current saveDefaultSearch value. Default value is true
     */
    public boolean getSaveDefaultSearch()  {
        Boolean result = getAttributeAsBoolean("saveDefaultSearch");
        return result == null ? true : result;
    }
    

    /**
     * Override of {@link com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole} for this component.
     *
     * @param savedSearchAdminRole New savedSearchAdminRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setSavedSearchAdminRole(String savedSearchAdminRole)  throws IllegalStateException {
        return (ListGrid)setAttribute("savedSearchAdminRole", savedSearchAdminRole, false);
    }

    /**
     * Override of {@link com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole} for this component.
     *
     * @return Current savedSearchAdminRole value. Default value is null
     */
    public String getSavedSearchAdminRole()  {
        return getAttributeAsString("savedSearchAdminRole");
    }
    

    /**
     * Properties for the separator record between locally saved and admin searches.
     * <p>
     * This component is an AutoChild named "savedSearchAdminSeparator".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current savedSearchAdminSeparator value. Default value is {isSeparator:true}
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridRecord getSavedSearchAdminSeparator() throws IllegalStateException {
        errorIfNotCreated("savedSearchAdminSeparator");
        return ListGridRecord.getOrCreateRef(getAttributeAsJavaScriptObject("savedSearchAdminSeparator"));
    }
    

    /**
     * Override of {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource SavedSearches.defaultDataSource} for this
     * component.
     *
     * @param savedSearchDS New savedSearchDS value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setSavedSearchDS(String savedSearchDS)  throws IllegalStateException {
        return (ListGrid)setAttribute("savedSearchDS", savedSearchDS, false);
    }

    /**
     * Override of {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource SavedSearches.defaultDataSource} for this
     * component.
     *
     * @return Current savedSearchDS value. Default value is null
     */
    public String getSavedSearchDS()  {
        return getAttributeAsString("savedSearchDS");
    }
    

    /**
     * Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of
     * the component.
     *
     * @param savedSearchStoredState New savedSearchStoredState value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.form.fields.SavedSearchItem
     */
    public ListGrid setSavedSearchStoredState(SavedSearchStoredState savedSearchStoredState)  throws IllegalStateException {
        return (ListGrid)setAttribute("savedSearchStoredState", savedSearchStoredState == null ? null : savedSearchStoredState.getValue(), false);
    }

    /**
     * Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of
     * the component.
     *
     * @return Current savedSearchStoredState value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.SavedSearchItem
     */
    public SavedSearchStoredState getSavedSearchStoredState()  {
        return EnumUtil.getEnum(SavedSearchStoredState.values(), getAttribute("savedSearchStoredState"));
    }
    

    /**
     * Text to show for the saved searches submenu.
     *
     * @param savedSearchText New savedSearchText value. Default value is "Saved views"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ListGrid setSavedSearchText(String savedSearchText)  throws IllegalStateException {
        return (ListGrid)setAttribute("savedSearchText", savedSearchText, false);
    }

    /**
     * Text to show for the saved searches submenu.
     *
     * @return Current savedSearchText value. Default value is "Saved views"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getSavedSearchText()  {
        return getAttributeAsString("savedSearchText");
    }
    

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to cause the grid directly update its local data set instead of performing an operation
     * against it's configured DataSource. <p> When using this mode, data must be provided to the grid via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as   a RecordList.  Setting
     * <code>saveLocally</code> is invalid if either {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is
     * called or if a {@link com.smartgwt.client.data.ResultSet} is provided as the data model. <p> <code>saveLocally</code>
     * mode includes changes made via  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit inline editing}, record
     * removal via {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}, as well as
     * programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()}.  This also causes saves to be performed
     * synchronously (unlike normal DataSource operations). <p> Note that using this mode also disables the automatic cache
     * synchronization provided by the DataSource system - changes made to this grid are saved only to this grid's data set.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} to allow filtering,
     * such as filtering performed by the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}, to
     * also work only with the local data set. <P> If saveLocally is unset, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} is true, the saveLocally behavior is
     * enabled by default
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveLocally New saveLocally value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setSaveLocally(Boolean saveLocally)  throws IllegalStateException {
        return (ListGrid)setAttribute("saveLocally", saveLocally, false);
    }

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to cause the grid directly update its local data set instead of performing an operation
     * against it's configured DataSource. <p> When using this mode, data must be provided to the grid via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as   a RecordList.  Setting
     * <code>saveLocally</code> is invalid if either {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is
     * called or if a {@link com.smartgwt.client.data.ResultSet} is provided as the data model. <p> <code>saveLocally</code>
     * mode includes changes made via  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit inline editing}, record
     * removal via {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}, as well as
     * programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()}.  This also causes saves to be performed
     * synchronously (unlike normal DataSource operations). <p> Note that using this mode also disables the automatic cache
     * synchronization provided by the DataSource system - changes made to this grid are saved only to this grid's data set.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} to allow filtering,
     * such as filtering performed by the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}, to
     * also work only with the local data set. <P> If saveLocally is unset, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} is true, the saveLocally behavior is
     * enabled by default
     *
     * @return Current saveLocally value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getSaveLocally()  {
        return getAttributeAsBoolean("saveLocally");
    }
    

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation DataBoundComponent.addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation DataBoundComponent.updateOperation} are available to
     * developers, allowing specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update
     * operation performed on save.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveRequestProperties New saveRequestProperties value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setSaveRequestProperties(DSRequest saveRequestProperties) {
        JavaScriptObject config = saveRequestProperties == null ? null : saveRequestProperties.getJsObj();
        return (ListGrid)setAttribute("saveRequestProperties", JSOHelper.cleanProperties(config, true), true);
    }

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation DataBoundComponent.addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation DataBoundComponent.updateOperation} are available to
     * developers, allowing specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update
     * operation performed on save.
     *
     * @return Current saveRequestProperties value. Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public DSRequest getSaveRequestProperties()  {
        return DSRequest.getOrCreateRef(getAttributeAsJavaScriptObject("saveRequestProperties"));
    }
    

    /**
     * Special cell-separator that may be inserted between cell values when screen-readers are reading the content of a row.
     * Only applies when screen-reader mode is enabled, and for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole:"list"}. <P> When {@link
     * com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} set to <code>"list"</code>, each row in the grid will be
     * rendered as HTML with role <code>"listItem"</code>.<br> In this mode, the <code>screenReaderCellSeparator</code>
     * property, (along with {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderIncludeFieldTitles
     * screenReaderIncludeFieldTitles} and {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator
     * screenReaderRowSeparator}),  gives developers a way to customize how screen readers read the row's text value in a way
     * that may be helpful for grids with multiple columns.<br> Instead of just picking up the value of each cell in the row
     * strung together,  readers will instead pick up the field title, the cell value and then the cellSeparator for each cell,
     * and then the rowSeparator to mark the end of the row. Most screenreaders will also read the row index and total row
     * count - something like "3 of 20". <P> <P> Note that screen readers vary widely on which punctuation symbols are read
     * aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver
     * screen readers all read the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver. <P>
     * Implementation notes: the generated row HTML makes use of the  <a
     * href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_aria-labelledby_attribute'
     * target='_blank'>aria-labelledby</a> property to achieve this - pointing the screenReader to the title button for the
     * column, the cell content, and a special hidden element containing the cellSeparator.<br> Note that this aria-labelledby
     * setting is applied in addition to other aria state specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}. <P> To entirely disable this feature,
     * developers may set  {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderWriteRowLabelledBy
     * screenReaderWriteRowLabelledBy} to <code>false</code>. In this case other row aria attributes will still be picked up
     * from {@link com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}, including the
     * <code>setsize</code> and <code>posinset</code> attributes that tell the screen reader where they currently are in the
     * list. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} for more information on the ARIA
     * attributes generated by ListGrids.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderCellSeparator New screenReaderCellSeparator value. Default value is "/"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setScreenReaderCellSeparator(String screenReaderCellSeparator)  throws IllegalStateException {
        return (ListGrid)setAttribute("screenReaderCellSeparator", screenReaderCellSeparator, false);
    }

    /**
     * Special cell-separator that may be inserted between cell values when screen-readers are reading the content of a row.
     * Only applies when screen-reader mode is enabled, and for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole:"list"}. <P> When {@link
     * com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} set to <code>"list"</code>, each row in the grid will be
     * rendered as HTML with role <code>"listItem"</code>.<br> In this mode, the <code>screenReaderCellSeparator</code>
     * property, (along with {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderIncludeFieldTitles
     * screenReaderIncludeFieldTitles} and {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator
     * screenReaderRowSeparator}),  gives developers a way to customize how screen readers read the row's text value in a way
     * that may be helpful for grids with multiple columns.<br> Instead of just picking up the value of each cell in the row
     * strung together,  readers will instead pick up the field title, the cell value and then the cellSeparator for each cell,
     * and then the rowSeparator to mark the end of the row. Most screenreaders will also read the row index and total row
     * count - something like "3 of 20". <P> <P> Note that screen readers vary widely on which punctuation symbols are read
     * aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver
     * screen readers all read the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver. <P>
     * Implementation notes: the generated row HTML makes use of the  <a
     * href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_aria-labelledby_attribute'
     * target='_blank'>aria-labelledby</a> property to achieve this - pointing the screenReader to the title button for the
     * column, the cell content, and a special hidden element containing the cellSeparator.<br> Note that this aria-labelledby
     * setting is applied in addition to other aria state specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}. <P> To entirely disable this feature,
     * developers may set  {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderWriteRowLabelledBy
     * screenReaderWriteRowLabelledBy} to <code>false</code>. In this case other row aria attributes will still be picked up
     * from {@link com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState getRowAriaState()}, including the
     * <code>setsize</code> and <code>posinset</code> attributes that tell the screen reader where they currently are in the
     * list. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} for more information on the ARIA
     * attributes generated by ListGrids.
     *
     * @return Current screenReaderCellSeparator value. Default value is "/"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderCellSeparator()  {
        return getAttributeAsString("screenReaderCellSeparator");
    }
    

    /**
     * Should column titles be read along with cell values when screen-readers are reading the content of a row? Only applies
     * when screen-reader mode is enabled, and for ListGrids with {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole:"list"}. <P> Has no effect if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeader showHeader} is
     * false. <P> See the documentation for {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator
     * screenReaderCellSeparator} for implementation  details on how the header values, cell separators and row separators are
     * picked up by screenreaders in this mode. <P> For more information on the ARIA attributes generated by ListGrids, see
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderIncludeFieldTitles New screenReaderIncludeFieldTitles value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setScreenReaderIncludeFieldTitles(Boolean screenReaderIncludeFieldTitles)  throws IllegalStateException {
        return (ListGrid)setAttribute("screenReaderIncludeFieldTitles", screenReaderIncludeFieldTitles, false);
    }

    /**
     * Should column titles be read along with cell values when screen-readers are reading the content of a row? Only applies
     * when screen-reader mode is enabled, and for ListGrids with {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole:"list"}. <P> Has no effect if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeader showHeader} is
     * false. <P> See the documentation for {@link com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator
     * screenReaderCellSeparator} for implementation  details on how the header values, cell separators and row separators are
     * picked up by screenreaders in this mode. <P> For more information on the ARIA attributes generated by ListGrids, see
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole}.
     *
     * @return Current screenReaderIncludeFieldTitles value. Default value is true
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getScreenReaderIncludeFieldTitles()  {
        Boolean result = getAttributeAsBoolean("screenReaderIncludeFieldTitles");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode is enabled}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true should the user be able to navigate 
     * the grid cell-by-cell, highlighting and focusing on individual cells within the selected row via left and right arrow
     * keypresses? <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this
     * property will have no effect as all navigation is by cell.
     *
     * @param screenReaderNavigateByCell New screenReaderNavigateByCell value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setScreenReaderNavigateByCell(boolean screenReaderNavigateByCell) {
        return (ListGrid)setAttribute("screenReaderNavigateByCell", screenReaderNavigateByCell, true);
    }

    /**
     * If {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode is enabled}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true should the user be able to navigate 
     * the grid cell-by-cell, highlighting and focusing on individual cells within the selected row via left and right arrow
     * keypresses? <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this
     * property will have no effect as all navigation is by cell.
     *
     * @return Current screenReaderNavigateByCell value. Default value is false
     */
    public boolean getScreenReaderNavigateByCell()  {
        Boolean result = getAttributeAsBoolean("screenReaderNavigateByCell");
        return result == null ? false : result;
    }
    

    /**
     * Special row-separator that may be inserted at the end of the row value when screen-readers are reading the content of a
     * row. Only applies when screen-reader mode is enabled, and for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole:"list"}. <P> See the documentation for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} for details on how the
     * header values, cell separators and row separators are picked up by screenreaders in this mode. <P> For more information
     * on the ARIA attributes generated by ListGrids, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderRowSeparator New screenReaderRowSeparator value. Default value is ","
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setScreenReaderRowSeparator(String screenReaderRowSeparator)  throws IllegalStateException {
        return (ListGrid)setAttribute("screenReaderRowSeparator", screenReaderRowSeparator, false);
    }

    /**
     * Special row-separator that may be inserted at the end of the row value when screen-readers are reading the content of a
     * row. Only applies when screen-reader mode is enabled, and for ListGrids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole:"list"}. <P> See the documentation for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} for details on how the
     * header values, cell separators and row separators are picked up by screenreaders in this mode. <P> For more information
     * on the ARIA attributes generated by ListGrids, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole}.
     *
     * @return Current screenReaderRowSeparator value. Default value is ","
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderRowSeparator()  {
        return getAttributeAsString("screenReaderRowSeparator");
    }
    

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, for grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} set to <code>"list"</code>, should a custom <a
     * href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_aria-labelledby_attribute'
     * target='_blank'>aria-labelledby</a> attribute be written out in addition to any other  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState row aria properties}  to ensure the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderIncludeFieldTitles column titles}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} are read out along with
     * cell content when reading rows? <P> Setting this property to false will disable the writing out of this
     * <code>labelled-by</code> attribute. See the documentation for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} for more on how the
     * header values, cell separators and row separators are picked up by screenreaders in this mode. <P> For more information
     * on the ARIA attributes generated by ListGrids, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderWriteRowLabelledBy New screenReaderWriteRowLabelledBy value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public ListGrid setScreenReaderWriteRowLabelledBy(Boolean screenReaderWriteRowLabelledBy)  throws IllegalStateException {
        return (ListGrid)setAttribute("screenReaderWriteRowLabelledBy", screenReaderWriteRowLabelledBy, false);
    }

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, for grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAriaRole ariaRole} set to <code>"list"</code>, should a custom <a
     * href='https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_aria-labelledby_attribute'
     * target='_blank'>aria-labelledby</a> attribute be written out in addition to any other  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowAriaState row aria properties}  to ensure the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderIncludeFieldTitles column titles}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} are read out along with
     * cell content when reading rows? <P> Setting this property to false will disable the writing out of this
     * <code>labelled-by</code> attribute. See the documentation for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator screenReaderCellSeparator} for more on how the
     * header values, cell separators and row separators are picked up by screenreaders in this mode. <P> For more information
     * on the ARIA attributes generated by ListGrids, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAriaRole
     * ariaRole}.
     *
     * @return Current screenReaderWriteRowLabelledBy value. Default value is true
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getScreenReaderWriteRowLabelledBy()  {
        Boolean result = getAttributeAsBoolean("screenReaderWriteRowLabelledBy");
        return result == null ? true : result;
    }
    

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch
     * browsers}, {@link com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is
     * used instead.
     *
     * @param scrollRedrawDelay New scrollRedrawDelay value. Default value is 0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setScrollRedrawDelay(int scrollRedrawDelay) {
        return (ListGrid)setAttribute("scrollRedrawDelay", scrollRedrawDelay, true);
    }

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch
     * browsers}, {@link com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is
     * used instead.
     *
     * @return Current scrollRedrawDelay value. Default value is 0
     */
    public int getScrollRedrawDelay()  {
        return getAttributeAsInt("scrollRedrawDelay");
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellXPosition New scrollToCellXPosition value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setScrollToCellXPosition(Alignment scrollToCellXPosition) {
        return (ListGrid)setAttribute("scrollToCellXPosition", scrollToCellXPosition == null ? null : scrollToCellXPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @return Current scrollToCellXPosition value. Default value is "center"
     */
    public Alignment getScrollToCellXPosition()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("scrollToCellXPosition"));
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellYPosition New scrollToCellYPosition value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setScrollToCellYPosition(VerticalAlignment scrollToCellYPosition) {
        return (ListGrid)setAttribute("scrollToCellYPosition", scrollToCellYPosition == null ? null : scrollToCellYPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @return Current scrollToCellYPosition value. Default value is "center"
     */
    public VerticalAlignment getScrollToCellYPosition()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("scrollToCellYPosition"));
    }
    

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw
     * GridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
     *
     * @param scrollWheelRedrawDelay New scrollWheelRedrawDelay value. Default value is 0
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setScrollWheelRedrawDelay(Integer scrollWheelRedrawDelay) {
        return (ListGrid)setAttribute("scrollWheelRedrawDelay", scrollWheelRedrawDelay, true);
    }

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw
     * GridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
     *
     * @return Current scrollWheelRedrawDelay value. Default value is 0
     */
    public Integer getScrollWheelRedrawDelay()  {
        return getAttributeAsInt("scrollWheelRedrawDelay");
    }
    

    /**
     * When declared, the specified form is automatically used as a search form for this grid,  with criteria that are additive
     * with any criteria shown in the FilterEditor or  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
     * Filter Window}. <p> For a discussion of the various filtering and criteria-management APIs and when to use  them, see
     * the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}. <P> This is similar to the effect of adding
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#addFilterEditorSubmitHandler ListGrid.filterEditorSubmit()} override
     * that pulls  in criteria from the external form, and having the external form call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterByEditor filterByEditor()} instead of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}, as shown in the  +exampleLink{additiveFilter} example.
     * <P> In particular. the grid will automatically filter when the searchForm.search() or  dynamicForm.submit() event fires
     * on the form (happens if a SubmitItem is present and is  pressed), and will automatically trigger filtering if enter is
     * pressed in the form, as  though searchOnEnter / saveOnEnter had been set. <P> If the FilterEditor is enabled and
     * listGrid.filterOnKeypress is set, the grid will  automatically watch for searchForm.criteriaChanged(), and filter
     * whenever that method  fires.  For the purposes of this behavior, the FilterEditor is considered to be enabled  even if
     * it is not currently visible but {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor
     * canShowFilterEditor} is true (as  otherwise filtering behavior in the form would change when the FilterEditor appears).
     * <P> The criteria from the specified <code>searchForm</code> will only be shown and edited in the external form; they
     * will neither be shown nor editable in the FilterEditor, even if  the FilterEditor also allows criteria on the same
     * fields.  That is, they are treated  much like {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria
     * implicitCriteria}. <P> Note: when using <code>listGrid.searchForm</code> don't add your own logic to call  fetchData()
     * or the criteria you specify will appear in the FilterEditor and be editable  there, potentially creating user confusion,
     * especially if some of the criteria in your  form cannot be displayed and edited in the FilterEditor.
     *
     * @param searchForm New searchForm value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setSearchForm(DynamicForm searchForm) {
        return (ListGrid)setAttribute("searchForm", searchForm == null ? null : searchForm.getOrCreateJsObj(), true);
    }

    /**
     * When declared, the specified form is automatically used as a search form for this grid,  with criteria that are additive
     * with any criteria shown in the FilterEditor or  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
     * Filter Window}. <p> For a discussion of the various filtering and criteria-management APIs and when to use  them, see
     * the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}. <P> This is similar to the effect of adding
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#addFilterEditorSubmitHandler ListGrid.filterEditorSubmit()} override
     * that pulls  in criteria from the external form, and having the external form call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterByEditor filterByEditor()} instead of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}, as shown in the  +exampleLink{additiveFilter} example.
     * <P> In particular. the grid will automatically filter when the searchForm.search() or  dynamicForm.submit() event fires
     * on the form (happens if a SubmitItem is present and is  pressed), and will automatically trigger filtering if enter is
     * pressed in the form, as  though searchOnEnter / saveOnEnter had been set. <P> If the FilterEditor is enabled and
     * listGrid.filterOnKeypress is set, the grid will  automatically watch for searchForm.criteriaChanged(), and filter
     * whenever that method  fires.  For the purposes of this behavior, the FilterEditor is considered to be enabled  even if
     * it is not currently visible but {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor
     * canShowFilterEditor} is true (as  otherwise filtering behavior in the form would change when the FilterEditor appears).
     * <P> The criteria from the specified <code>searchForm</code> will only be shown and edited in the external form; they
     * will neither be shown nor editable in the FilterEditor, even if  the FilterEditor also allows criteria on the same
     * fields.  That is, they are treated  much like {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria
     * implicitCriteria}. <P> Note: when using <code>listGrid.searchForm</code> don't add your own logic to call  fetchData()
     * or the criteria you specify will appear in the FilterEditor and be editable  there, potentially creating user confusion,
     * especially if some of the criteria in your  form cannot be displayed and edited in the FilterEditor.
     *
     * @return Current searchForm value. Default value is null
     */
    public DynamicForm getSearchForm()  {
        return (DynamicForm)DynamicForm.getByJSObject(getAttributeAsJavaScriptObject("searchForm"));
    }

    /**
     * When declared, the specified form is automatically used as a search form for this grid,  with criteria that are additive
     * with any criteria shown in the FilterEditor or  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
     * Filter Window}. <p> For a discussion of the various filtering and criteria-management APIs and when to use  them, see
     * the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}. <P> This is similar to the effect of adding
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#addFilterEditorSubmitHandler ListGrid.filterEditorSubmit()} override
     * that pulls  in criteria from the external form, and having the external form call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterByEditor filterByEditor()} instead of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}, as shown in the  +exampleLink{additiveFilter} example.
     * <P> In particular. the grid will automatically filter when the searchForm.search() or  dynamicForm.submit() event fires
     * on the form (happens if a SubmitItem is present and is  pressed), and will automatically trigger filtering if enter is
     * pressed in the form, as  though searchOnEnter / saveOnEnter had been set. <P> If the FilterEditor is enabled and
     * listGrid.filterOnKeypress is set, the grid will  automatically watch for searchForm.criteriaChanged(), and filter
     * whenever that method  fires.  For the purposes of this behavior, the FilterEditor is considered to be enabled  even if
     * it is not currently visible but {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor
     * canShowFilterEditor} is true (as  otherwise filtering behavior in the form would change when the FilterEditor appears).
     * <P> The criteria from the specified <code>searchForm</code> will only be shown and edited in the external form; they
     * will neither be shown nor editable in the FilterEditor, even if  the FilterEditor also allows criteria on the same
     * fields.  That is, they are treated  much like {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria
     * implicitCriteria}. <P> Note: when using <code>listGrid.searchForm</code> don't add your own logic to call  fetchData()
     * or the criteria you specify will appear in the FilterEditor and be editable  there, potentially creating user confusion,
     * especially if some of the criteria in your  form cannot be displayed and edited in the FilterEditor.
     *
     * @param searchForm New searchForm value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setSearchForm(ValuesManager searchForm) {
        return (ListGrid)setAttribute("searchForm", searchForm == null ? null : searchForm.getOrCreateJsObj(), true);
    }

    /**
     * When declared, the specified form is automatically used as a search form for this grid,  with criteria that are additive
     * with any criteria shown in the FilterEditor or  {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterWindow
     * Filter Window}. <p> For a discussion of the various filtering and criteria-management APIs and when to use  them, see
     * the {@link com.smartgwt.client.docs.GridFiltering Grid Filtering overview}. <P> This is similar to the effect of adding
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#addFilterEditorSubmitHandler ListGrid.filterEditorSubmit()} override
     * that pulls  in criteria from the external form, and having the external form call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterByEditor filterByEditor()} instead of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}, as shown in the  +exampleLink{additiveFilter} example.
     * <P> In particular. the grid will automatically filter when the searchForm.search() or  dynamicForm.submit() event fires
     * on the form (happens if a SubmitItem is present and is  pressed), and will automatically trigger filtering if enter is
     * pressed in the form, as  though searchOnEnter / saveOnEnter had been set. <P> If the FilterEditor is enabled and
     * listGrid.filterOnKeypress is set, the grid will  automatically watch for searchForm.criteriaChanged(), and filter
     * whenever that method  fires.  For the purposes of this behavior, the FilterEditor is considered to be enabled  even if
     * it is not currently visible but {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor
     * canShowFilterEditor} is true (as  otherwise filtering behavior in the form would change when the FilterEditor appears).
     * <P> The criteria from the specified <code>searchForm</code> will only be shown and edited in the external form; they
     * will neither be shown nor editable in the FilterEditor, even if  the FilterEditor also allows criteria on the same
     * fields.  That is, they are treated  much like {@link com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria
     * implicitCriteria}. <P> Note: when using <code>listGrid.searchForm</code> don't add your own logic to call  fetchData()
     * or the criteria you specify will appear in the FilterEditor and be editable  there, potentially creating user confusion,
     * especially if some of the criteria in your  form cannot be displayed and edited in the FilterEditor.
     *
     * @return Current searchForm value. Default value is null
     */
    public ValuesManager getSearchFormAsValuesManager()  {
        return ValuesManager.getOrCreateRef(getAttributeAsJavaScriptObject("searchForm"));
    }
    

    /**
     * If this property is set to true, clicking on a cell will natively select the  cell's content, ready to be copied to the
     * browser clipboard. <P> For control of this behavior at the field level,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSelectCellTextOnClick ListGridField.selectCellTextOnClick} may be
     * used. These properties interact as follows: <table border=1 cellpadding=4><tr>  <td><b>listGrid.selectCellTextOnClick
     * value</b></td>  <td><b>listGridField.selectCellTextOnClick value</b></td>  <td><b>Behavior</b></td> </tr><tr>  <td
     * rowspan=2><code>true</code></td>      <td><i>unset</i> or <code>true</code></td>          <td>Cell contents will be
     * natively selected on click.</td> </tr><tr>      <td><code>false</code></td>          <td>Cell contents will not be
     * natively selected on click.</td> </tr><tr> </tr><tr>  <td rowspan=2><i>unset</i></td>      <td><code>true</code></td>   
     * <td>Cell contents will be natively selected on click.</td> </tr><tr>      <td><i>unset</i> or <code>false</code></td>   
     * <td>Cell contents will not be natively selected on click.</td> </tr><tr>  <td><code>false</code></td>     
     * <td><code>true</code>, <code>false</code> or <i>unset</i></td>          <td>Cell contents will not be natively selected
     * on click.</td> </tr></table> <P> This is related to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelectText canDragSelectText} attribute which enables native text
     * selection of grid content by standard browser interactions (drag selecting or double-click selecting). <P> Note that
     * developers may also be interested in the related formItem properties {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnClick FormItem.selectOnClick} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnFocus FormItem.selectOnFocus}.
     *
     * @param selectCellTextOnClick New selectCellTextOnClick value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setSelectCellTextOnClick(Boolean selectCellTextOnClick) {
        return (ListGrid)setAttribute("selectCellTextOnClick", selectCellTextOnClick, true);
    }

    /**
     * If this property is set to true, clicking on a cell will natively select the  cell's content, ready to be copied to the
     * browser clipboard. <P> For control of this behavior at the field level,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSelectCellTextOnClick ListGridField.selectCellTextOnClick} may be
     * used. These properties interact as follows: <table border=1 cellpadding=4><tr>  <td><b>listGrid.selectCellTextOnClick
     * value</b></td>  <td><b>listGridField.selectCellTextOnClick value</b></td>  <td><b>Behavior</b></td> </tr><tr>  <td
     * rowspan=2><code>true</code></td>      <td><i>unset</i> or <code>true</code></td>          <td>Cell contents will be
     * natively selected on click.</td> </tr><tr>      <td><code>false</code></td>          <td>Cell contents will not be
     * natively selected on click.</td> </tr><tr> </tr><tr>  <td rowspan=2><i>unset</i></td>      <td><code>true</code></td>   
     * <td>Cell contents will be natively selected on click.</td> </tr><tr>      <td><i>unset</i> or <code>false</code></td>   
     * <td>Cell contents will not be natively selected on click.</td> </tr><tr>  <td><code>false</code></td>     
     * <td><code>true</code>, <code>false</code> or <i>unset</i></td>          <td>Cell contents will not be natively selected
     * on click.</td> </tr></table> <P> This is related to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelectText canDragSelectText} attribute which enables native text
     * selection of grid content by standard browser interactions (drag selecting or double-click selecting). <P> Note that
     * developers may also be interested in the related formItem properties {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnClick FormItem.selectOnClick} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnFocus FormItem.selectOnFocus}.
     *
     * @return Current selectCellTextOnClick value. Default value is null
     */
    public Boolean getSelectCellTextOnClick()  {
        return getAttributeAsBoolean("selectCellTextOnClick");
    }
    

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to reset this grid's selection the
     * current state (assuming the same data is present in the grid).<br>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's selection to match the {@link com.smartgwt.client.docs.ListGridSelectedState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedState getSelectedState()}.
     *
     * @param selectedState Object describing the desired selection state of                                              the grid. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState 
     */
    public ListGrid setSelectedState(String selectedState) {
        return (ListGrid)setAttribute("selectedState", selectedState, true);
    }

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to reset this grid's selection the
     * current state (assuming the same data is present in the grid).<br>
     *
     * @return For components bound to a {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} with records
     * identified by  unique {@link com.smartgwt.client.data.DataSourceField#getPrimaryKey primaryKeys}, this method returns a
     * snapshot of  the component's current selection, as a {@link com.smartgwt.client.docs.ListGridSelectedState} object.<br>
     * This object can be passed to {@link com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to
     * reset this grid's current selection state (assuming the same data is present in the grid).<br> Selected state is not
     * supported if the component has no dataSource, or the dataSource has no primaryKey fields. Default value is null
     * @see com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState 
     */
    public String getSelectedState()  {
        return getAttributeAsString("selectedState");
    }
    

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @param selectHeaderOnSort New selectHeaderOnSort value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setSelectHeaderOnSort(Boolean selectHeaderOnSort) {
        return (ListGrid)setAttribute("selectHeaderOnSort", selectHeaderOnSort, true);
    }

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @return Current selectHeaderOnSort value. Default value is true
     */
    public Boolean getSelectHeaderOnSort()  {
        Boolean result = getAttributeAsBoolean("selectHeaderOnSort");
        return result == null ? true : result;
    }
    
    

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treeGrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox
     * TreeGrid.showDisabledSelectionCheckbox}. <p> Note that the default behavior when you enable checkbox selection is to
     * continue to show the selected style.  This can be changed by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedStyle showSelectedStyle} to false.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionAppearance on the fly.
     *
     * @param selectionAppearance new selection appearance. Default value is "rowStyle"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setSelectionAppearance(SelectionAppearance selectionAppearance) {
        return (ListGrid)setAttribute("selectionAppearance", selectionAppearance == null ? null : selectionAppearance.getValue(), true);
    }

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treeGrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox
     * TreeGrid.showDisabledSelectionCheckbox}. <p> Note that the default behavior when you enable checkbox selection is to
     * continue to show the selected style.  This can be changed by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedStyle showSelectedStyle} to false.
     *
     * @return Current selectionAppearance value. Default value is "rowStyle"
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public SelectionAppearance getSelectionAppearance()  {
        return EnumUtil.getEnum(SelectionAppearance.values(), getAttribute("selectionAppearance"));
    }
    
    
    

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectionProperty New selectionProperty value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setSelectionProperty(String selectionProperty)  throws IllegalStateException {
        return (ListGrid)setAttribute("selectionProperty", selectionProperty, false);
    }

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     *
     * @return Current selectionProperty value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getSelectionProperty()  {
        return getAttributeAsString("selectionProperty");
    }
    

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionType on the fly.
     *
     * @param selectionType New selection style. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public ListGrid setSelectionType(SelectionStyle selectionType) {
        return (ListGrid)setAttribute("selectionType", selectionType == null ? null : selectionType.getValue(), true);
    }

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * @return Current selectionType value. Default value is null
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public SelectionStyle getSelectionType()  {
        return EnumUtil.getEnum(SelectionStyle.values(), getAttribute("selectionType"));
    }
    
    

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditSelectionType editSelectionType} for how edit-selection behaves.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectOnEdit New selectOnEdit value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public ListGrid setSelectOnEdit(Boolean selectOnEdit) {
        return (ListGrid)setAttribute("selectOnEdit", selectOnEdit, true);
    }

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditSelectionType editSelectionType} for how edit-selection behaves.
     *
     * @return Current selectOnEdit value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSelectOnEdit()  {
        Boolean result = getAttributeAsBoolean("selectOnEdit");
        return result == null ? true : result;
    }
    

    /**
     * When set to false, clicking a record's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansion
     * field} will not add the record to the current selection.
     *
     * @param selectOnExpandRecord New selectOnExpandRecord value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setSelectOnExpandRecord(boolean selectOnExpandRecord) {
        return (ListGrid)setAttribute("selectOnExpandRecord", selectOnExpandRecord, true);
    }

    /**
     * When set to false, clicking a record's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansion
     * field} will not add the record to the current selection.
     *
     * @return Current selectOnExpandRecord value. Default value is true
     */
    public boolean getSelectOnExpandRecord()  {
        Boolean result = getAttributeAsBoolean("selectOnExpandRecord");
        return result == null ? true : result;
    }
    

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @param showAllColumns New showAllColumns value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setShowAllColumns(Boolean showAllColumns)  throws IllegalStateException {
        return (ListGrid)setAttribute("showAllColumns", showAllColumns, false);
    }

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @return Current showAllColumns value. Default value is false
     */
    public Boolean getShowAllColumns()  {
        Boolean result = getAttributeAsBoolean("showAllColumns");
        return result == null ? false : result;
    }
    

    /**
     * Whether all records should be drawn all at once, or only records visible in the viewport. <P> Drawing all records causes
     * longer initial rendering time, but allows smoother vertical scrolling.  With a very large number of records,
     * showAllRecords will become too slow. <P> This setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataFetchMode dataFetchMode}: "paged" as it requires all records matching
     * the criteria to be fetched from the server at once.
     *
     * @param showAllRecords New showAllRecords value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDrawAheadRatio
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDrawAllMaxCells
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public ListGrid setShowAllRecords(Boolean showAllRecords) {
        return (ListGrid)setAttribute("showAllRecords", showAllRecords, true);
    }

    /**
     * Whether all records should be drawn all at once, or only records visible in the viewport. <P> Drawing all records causes
     * longer initial rendering time, but allows smoother vertical scrolling.  With a very large number of records,
     * showAllRecords will become too slow. <P> This setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataFetchMode dataFetchMode}: "paged" as it requires all records matching
     * the criteria to be fetched from the server at once.
     *
     * @return Current showAllRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDrawAllMaxCells
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getShowAllRecords()  {
        Boolean result = getAttributeAsBoolean("showAllRecords");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @param showAsynchGroupingPrompt New showAsynchGroupingPrompt value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setShowAsynchGroupingPrompt(Boolean showAsynchGroupingPrompt)  throws IllegalStateException {
        return (ListGrid)setAttribute("showAsynchGroupingPrompt", showAsynchGroupingPrompt, false);
    }

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @return Current showAsynchGroupingPrompt value. Default value is null
     */
    public Boolean getShowAsynchGroupingPrompt()  {
        return getAttributeAsBoolean("showAsynchGroupingPrompt");
    }
    

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @param showBackgroundComponents New showBackgroundComponents value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowBackgroundComponents(Boolean showBackgroundComponents) {
        return (ListGrid)setAttribute("showBackgroundComponents", showBackgroundComponents, true);
    }

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @return Current showBackgroundComponents value. Default value is false
     */
    public Boolean getShowBackgroundComponents()  {
        Boolean result = getAttributeAsBoolean("showBackgroundComponents");
        return result == null ? false : result;
    }
    

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @param showCellContextMenus New showCellContextMenus value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowCellContextMenus(Boolean showCellContextMenus) {
        return (ListGrid)setAttribute("showCellContextMenus", showCellContextMenus, true);
    }

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @return Current showCellContextMenus value. Default value is false
     */
    public Boolean getShowCellContextMenus()  {
        Boolean result = getAttributeAsBoolean("showCellContextMenus");
        return result == null ? false : result;
    }
    

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedHeaderTitlesOnHover New showClippedHeaderTitlesOnHover value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public ListGrid setShowClippedHeaderTitlesOnHover(boolean showClippedHeaderTitlesOnHover)  throws IllegalStateException {
        return (ListGrid)setAttribute("showClippedHeaderTitlesOnHover", showClippedHeaderTitlesOnHover, false);
    }

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     *
     * @return Current showClippedHeaderTitlesOnHover value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public boolean getShowClippedHeaderTitlesOnHover()  {
        Boolean result = getAttributeAsBoolean("showClippedHeaderTitlesOnHover");
        return result == null ? true : result;
    }
    

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedValuesOnHover New showClippedValuesOnHover value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public ListGrid setShowClippedValuesOnHover(Boolean showClippedValuesOnHover)  throws IllegalStateException {
        return (ListGrid)setAttribute("showClippedValuesOnHover", showClippedValuesOnHover, false);
    }

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     *
     * @return Current showClippedValuesOnHover value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public Boolean getShowClippedValuesOnHover()  {
        return getAttributeAsBoolean("showClippedValuesOnHover");
    }
    

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowCollapsedGroupSummary showCollapsedGroupSummary}
     *
     * @param showCollapsedGroupSummary new showCollapsedGroupSummary value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setShowCollapsedGroupSummary(Boolean showCollapsedGroupSummary) {
        return (ListGrid)setAttribute("showCollapsedGroupSummary", showCollapsedGroupSummary, true);
    }

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * @return Current showCollapsedGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowCollapsedGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showCollapsedGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> When this
     * property is <code>true</code>, the <code>ListGrid</code> will include all detail fields unless fields have been
     * specifically declared using the {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array. <P> Any field
     * which has been included directly in the <code>fields</code> array will be included regardless of the fields
     * <code>detail</code> attribute. <p> Detail fields included will initially be hidden but the user may show these fields
     * via the default header context menu ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * showHeaderContextMenu}). <P> The field's visibility can also be overridden programatically using the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially. <P> Setting this property to false will completely exclude all detail fields from the
     * list grid's fields array, such that they cannot be shown by the user or programmatically.
     *
     * @param showDetailFields New showDetailFields value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public ListGrid setShowDetailFields(Boolean showDetailFields)  throws IllegalStateException {
        return (ListGrid)setAttribute("showDetailFields", showDetailFields, false);
    }

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> When this
     * property is <code>true</code>, the <code>ListGrid</code> will include all detail fields unless fields have been
     * specifically declared using the {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array. <P> Any field
     * which has been included directly in the <code>fields</code> array will be included regardless of the fields
     * <code>detail</code> attribute. <p> Detail fields included will initially be hidden but the user may show these fields
     * via the default header context menu ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * showHeaderContextMenu}). <P> The field's visibility can also be overridden programatically using the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially. <P> Setting this property to false will completely exclude all detail fields from the
     * list grid's fields array, such that they cannot be shown by the user or programmatically.
     *
     * @return Current showDetailFields value. Default value is true
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getShowDetailFields()  {
        Boolean result = getAttributeAsBoolean("showDetailFields");
        return result == null ? true : result;
    }
    

    /**
     * Should ellipses be displayed when cell content is clipped? May be overridden at the field  level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowEllipsisWhenClipped ListGridField.showEllipsisWhenClipped}
     *
     * @param showEllipsisWhenClipped New showEllipsisWhenClipped value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowEllipsisWhenClipped(boolean showEllipsisWhenClipped) {
        return (ListGrid)setAttribute("showEllipsisWhenClipped", showEllipsisWhenClipped, true);
    }

    /**
     * Should ellipses be displayed when cell content is clipped? May be overridden at the field  level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowEllipsisWhenClipped ListGridField.showEllipsisWhenClipped}
     *
     * @return Current showEllipsisWhenClipped value. Default value is true
     */
    public boolean getShowEllipsisWhenClipped()  {
        Boolean result = getAttributeAsBoolean("showEllipsisWhenClipped");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @param showEmptyMessage New showEmptyMessage value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public ListGrid setShowEmptyMessage(Boolean showEmptyMessage) {
        return (ListGrid)setAttribute("showEmptyMessage", showEmptyMessage, true);
    }

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @return Current showEmptyMessage value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public Boolean getShowEmptyMessage()  {
        Boolean result = getAttributeAsBoolean("showEmptyMessage");
        return result == null ? true : result;
    }
    

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @param showErrorIcons New showErrorIcons value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowErrorIcons(boolean showErrorIcons) {
        return (ListGrid)setAttribute("showErrorIcons", showErrorIcons, true);
    }

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @return Current showErrorIcons value. Default value is true
     */
    public boolean getShowErrorIcons()  {
        Boolean result = getAttributeAsBoolean("showErrorIcons");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should a Save button be shown below the the
     * expanded editor? <P> Note that if an expanded-row containing an editor is collapsed while changes are outstanding,
     * changes will be either be automatically updated to the grid, or will first show a confirmation dialog, according to the
     * value of {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorShowSaveDialog
     * expansionEditorShowSaveDialog}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current showExpansionEditorSaveButton value. Default value is true
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getShowExpansionEditorSaveButton() throws IllegalStateException {
        errorIfNotCreated("showExpansionEditorSaveButton");
        Boolean result = getAttributeAsBoolean("showExpansionEditorSaveButton");
        return result == null ? true : result;
    }
    

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data.
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} attributes allow
     *  developers to configure whether filtering occurs automatically on change or requires
     *  an enter-keypress or filter button click.<br>
     *  {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} determines
     *  the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator}.   When
     * <code>field.filterOperator</code> 
     *  has been set calls to retrieve the criteria from the grid return {@link com.smartgwt.client.data.AdvancedCriteria}.  
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} for a UI that
     * allows end users to change the search
     *  operator on the fly
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria getCriteria()} - this ensures that if the user has typed a
     * new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} property. Allows the filter editor to be shown or hidden at runtime. <P> By default, hiding the <code>filterEditor</code> will also clear any user-criteria it  specified and refetch the data.  To prevent this behavior, you can set  {@link com.smartgwt.client.widgets.grid.ListGrid#getClearCriteriaOnFilterEditorHide clearCriteriaOnFilterEditorHide} to false.
     *
     * @param showFilterEditor true if the filter editor should be shown, false if it should be hidden. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public ListGrid setShowFilterEditor(boolean showFilterEditor) {
        return (ListGrid)setAttribute("showFilterEditor", showFilterEditor, true);
    }

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data.
     * The {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterByCell filterByCell} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} attributes allow
     *  developers to configure whether filtering occurs automatically on change or requires
     *  an enter-keypress or filter button click.<br>
     *  {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} determines
     *  the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator}.   When
     * <code>field.filterOperator</code> 
     *  has been set calls to retrieve the criteria from the grid return {@link com.smartgwt.client.data.AdvancedCriteria}.  
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} for a UI that
     * allows end users to change the search
     *  operator on the fly
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria getCriteria()} - this ensures that if the user has typed a
     * new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *
     * @return Current showFilterEditor value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public boolean getShowFilterEditor()  {
        Boolean result = getAttributeAsBoolean("showFilterEditor");
        return result == null ? false : result;
    }
    

    /**
     * When set to false, no hover is shown for the filter editor fields. Otherwise, a hover shows the current field's criteria
     * description along with the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria
     * filterWindowCriteria} description if configured. <p> Hovers can also be disabled for individual fields using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowFilterEditorHovers ListGridField.showFilterEditorHovers}. <p> The
     * descriptive text for criteria is formatted by {@link com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription
     * DataSource.getAdvancedCriteriaDescription()}.
     *
     * @param showFilterEditorHovers New showFilterEditorHovers value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridField#setShowFilterEditorHovers
     */
    public ListGrid setShowFilterEditorHovers(Boolean showFilterEditorHovers)  throws IllegalStateException {
        return (ListGrid)setAttribute("showFilterEditorHovers", showFilterEditorHovers, false);
    }

    /**
     * When set to false, no hover is shown for the filter editor fields. Otherwise, a hover shows the current field's criteria
     * description along with the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria
     * filterWindowCriteria} description if configured. <p> Hovers can also be disabled for individual fields using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowFilterEditorHovers ListGridField.showFilterEditorHovers}. <p> The
     * descriptive text for criteria is formatted by {@link com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription
     * DataSource.getAdvancedCriteriaDescription()}.
     *
     * @return Current showFilterEditorHovers value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getShowFilterEditorHovers
     */
    public Boolean getShowFilterEditorHovers()  {
        return getAttributeAsBoolean("showFilterEditorHovers");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor canShowFilterEditor} is true, this is the
     * title for the filterEditor show/hide menu-item, in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}, when the filterEditor is hidden. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHideFilterEditorTitle hideFilterEditorTitle} affects the same
     * menu-item when the filterEditor is visible.
     *
     * @param showFilterEditorTitle New showFilterEditorTitle value. Default value is "Show Filter Row"
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public ListGrid setShowFilterEditorTitle(String showFilterEditorTitle) {
        return (ListGrid)setAttribute("showFilterEditorTitle", showFilterEditorTitle, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanShowFilterEditor canShowFilterEditor} is true, this is the
     * title for the filterEditor show/hide menu-item, in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenu headerContextmenu}, when the filterEditor is hidden. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHideFilterEditorTitle hideFilterEditorTitle} affects the same
     * menu-item when the filterEditor is visible.
     *
     * @return Current showFilterEditorTitle value. Default value is "Show Filter Row"
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public String getShowFilterEditorTitle()  {
        return getAttributeAsString("showFilterEditorTitle");
    }
    

    /**
     * Should an indicator be shown to indicate that {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria
     * filterWindowCriteria} is configured? The indicator is a small triangle shown in the top-right of the grid header or
     * filter.
     *
     * @param showFilterWindowCriteriaIndicator New showFilterWindowCriteriaIndicator value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setShowFilterWindowCriteriaIndicator(Boolean showFilterWindowCriteriaIndicator)  throws IllegalStateException {
        return (ListGrid)setAttribute("showFilterWindowCriteriaIndicator", showFilterWindowCriteriaIndicator, false);
    }

    /**
     * Should an indicator be shown to indicate that {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterWindowCriteria
     * filterWindowCriteria} is configured? The indicator is a small triangle shown in the top-right of the grid header or
     * filter.
     *
     * @return Current showFilterWindowCriteriaIndicator value. Default value is true
     */
    public Boolean getShowFilterWindowCriteriaIndicator()  {
        Boolean result = getAttributeAsBoolean("showFilterWindowCriteriaIndicator");
        return result == null ? true : result;
    }
    

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary
     * ListGridField.showGridSummary} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction
     * getGridSummaryFunction()} for details on how the summary value to be displayed for each column will be calculated. <P>
     * Note that the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to
     * actually display the summary row.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} attribute
     *
     * @param showGridSummary new value for this.showGridSummary. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowGridSummary(Boolean showGridSummary) {
        return (ListGrid)setAttribute("showGridSummary", showGridSummary, true);
    }

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary
     * ListGridField.showGridSummary} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction
     * getGridSummaryFunction()} for details on how the summary value to be displayed for each column will be calculated. <P>
     * Note that the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to
     * actually display the summary row.
     *
     * @return Current showGridSummary value. Default value is false
     */
    public Boolean getShowGridSummary()  {
        Boolean result = getAttributeAsBoolean("showGridSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction
     * ListGridField.summaryFunction}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} attribute
     *
     * @param showGroupSummary new value for this.showGroupSummary. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setGroupByFieldSummaries
     */
    public ListGrid setShowGroupSummary(Boolean showGroupSummary) {
        return (ListGrid)setAttribute("showGroupSummary", showGroupSummary, true);
    }

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction
     * ListGridField.summaryFunction}.
     *
     * @return Current showGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries
     */
    public Boolean getShowGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader}
     *
     * @param showGroupSummaryInHeader new showGroupSummaryInHeader state. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public ListGrid setShowGroupSummaryInHeader(Boolean showGroupSummaryInHeader) {
        return (ListGrid)setAttribute("showGroupSummaryInHeader", showGroupSummaryInHeader, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * @return Current showGroupSummaryInHeader value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowGroupSummaryInHeader()  {
        Boolean result = getAttributeAsBoolean("showGroupSummaryInHeader");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @param showGroupTitleColumn New showGroupTitleColumn value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setShowGroupTitleColumn(Boolean showGroupTitleColumn)  throws IllegalStateException {
        return (ListGrid)setAttribute("showGroupTitleColumn", showGroupTitleColumn, false);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @return Current showGroupTitleColumn value. Default value is true
     */
    public Boolean getShowGroupTitleColumn()  {
        Boolean result = getAttributeAsBoolean("showGroupTitleColumn");
        return result == null ? true : result;
    }
    

    /**
     * If this is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and has  {@link
     * com.smartgwt.client.docs.FrozenFields frozen fields}, should the group title show in the frozen or unfrozen body? <P>
     * Setting this property to false will cause the group title to show in the  unfrozen body in this case, meaning it will
     * appear to the right of the frozen fields, and scroll horizontally as the user scrolls the unfrozen fields.  This can be
     * useful for grids where there isn't enough available space to show the group title text in the frozen body. <P> Note that
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField} is explicitly set, or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, this property
     * has no effect. In this case rather than the group title showing in a single cell spanning multiple other fields, it will
     * be rendered into a specific column.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showGroupTitleInFrozenBody New showGroupTitleInFrozenBody value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowGroupTitleInFrozenBody(boolean showGroupTitleInFrozenBody) {
        return (ListGrid)setAttribute("showGroupTitleInFrozenBody", showGroupTitleInFrozenBody, true);
    }

    /**
     * If this is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and has  {@link
     * com.smartgwt.client.docs.FrozenFields frozen fields}, should the group title show in the frozen or unfrozen body? <P>
     * Setting this property to false will cause the group title to show in the  unfrozen body in this case, meaning it will
     * appear to the right of the frozen fields, and scroll horizontally as the user scrolls the unfrozen fields.  This can be
     * useful for grids where there isn't enough available space to show the group title text in the frozen body. <P> Note that
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField} is explicitly set, or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, this property
     * has no effect. In this case rather than the group title showing in a single cell spanning multiple other fields, it will
     * be rendered into a specific column.
     *
     * @return Current showGroupTitleInFrozenBody value. Default value is true
     */
    public boolean getShowGroupTitleInFrozenBody()  {
        Boolean result = getAttributeAsBoolean("showGroupTitleInFrozenBody");
        return result == null ? true : result;
    }
    

    /**
     * Should we show the header for this ListGrid?
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Show or hide the ListGrid header.
     *
     * @param showHeader true to show the header, false to hide it. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setShowHeader(Boolean showHeader) {
        return (ListGrid)setAttribute("showHeader", showHeader, true);
    }

    /**
     * Should we show the header for this ListGrid?
     *
     * @return Current showHeader value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getShowHeader()  {
        Boolean result = getAttributeAsBoolean("showHeader");
        return result == null ? true : result;
    }
    

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderContextMenu New showHeaderContextMenu value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public ListGrid setShowHeaderContextMenu(Boolean showHeaderContextMenu)  throws IllegalStateException {
        return (ListGrid)setAttribute("showHeaderContextMenu", showHeaderContextMenu, false);
    }

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Current showHeaderContextMenu value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getShowHeaderContextMenu()  {
        Boolean result = getAttributeAsBoolean("showHeaderContextMenu");
        return result == null ? true : result;
    }
    

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderMenuButton New showHeaderMenuButton value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public ListGrid setShowHeaderMenuButton(Boolean showHeaderMenuButton)  throws IllegalStateException {
        return (ListGrid)setAttribute("showHeaderMenuButton", showHeaderMenuButton, false);
    }

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Current showHeaderMenuButton value. Default value is true
     */
    public Boolean getShowHeaderMenuButton()  {
        Boolean result = getAttributeAsBoolean("showHeaderMenuButton");
        return result == null ? true : result;
    }
    

    /**
     * Should partial selection of all records be shown in header with a special icon? The partial icon will show in the header
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll} is enabled and at least one record
     * is selected but all records are not selected. To only show all selected and none selected states, set this attribute to
     * <code>false</code>.
     *
     * @param showHeaderPartialSelection New showHeaderPartialSelection value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setShowHeaderPartialSelection(Boolean showHeaderPartialSelection) {
        return (ListGrid)setAttribute("showHeaderPartialSelection", showHeaderPartialSelection, true);
    }

    /**
     * Should partial selection of all records be shown in header with a special icon? The partial icon will show in the header
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll} is enabled and at least one record
     * is selected but all records are not selected. To only show all selected and none selected states, set this attribute to
     * <code>false</code>.
     *
     * @return Current showHeaderPartialSelection value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getShowHeaderPartialSelection()  {
        return getAttributeAsBoolean("showHeaderPartialSelection");
    }
    

    /**
     * Should the header show a drop-shadow? Shadow will be applied to the header, or for a grid with frozen columns, the
     * header layout.  <P> Header shadow will only be displayed if {@link com.smartgwt.client.widgets.Canvas#getUseCSSShadow
     * css shadows} are being used.
     *
     * @param showHeaderShadow New showHeaderShadow value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowVOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowHOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowSoftness
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowColor
     */
    public ListGrid setShowHeaderShadow(Boolean showHeaderShadow) {
        return (ListGrid)setAttribute("showHeaderShadow", showHeaderShadow, true);
    }

    /**
     * Should the header show a drop-shadow? Shadow will be applied to the header, or for a grid with frozen columns, the
     * header layout.  <P> Header shadow will only be displayed if {@link com.smartgwt.client.widgets.Canvas#getUseCSSShadow
     * css shadows} are being used.
     *
     * @return Current showHeaderShadow value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowVOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowHOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowSoftness
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowColor
     */
    public Boolean getShowHeaderShadow()  {
        Boolean result = getAttributeAsBoolean("showHeaderShadow");
        return result == null ? false : result;
    }
    

    /**
     * Whether to show a context menu on the header span with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderSpanContextMenu New showHeaderSpanContextMenu value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public ListGrid setShowHeaderSpanContextMenu(Boolean showHeaderSpanContextMenu)  throws IllegalStateException {
        return (ListGrid)setAttribute("showHeaderSpanContextMenu", showHeaderSpanContextMenu, false);
    }

    /**
     * Whether to show a context menu on the header span with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Current showHeaderSpanContextMenu value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getShowHeaderSpanContextMenu()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanContextMenu");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @param showHeaderSpanTitlesInFormulaBuilder New showHeaderSpanTitlesInFormulaBuilder value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFormulaBuilderSpanTitleSeparator
     */
    public ListGrid setShowHeaderSpanTitlesInFormulaBuilder(Boolean showHeaderSpanTitlesInFormulaBuilder) {
        return (ListGrid)setAttribute("showHeaderSpanTitlesInFormulaBuilder", showHeaderSpanTitlesInFormulaBuilder, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @return Current showHeaderSpanTitlesInFormulaBuilder value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFormulaBuilderSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInFormulaBuilder()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInFormulaBuilder");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @param showHeaderSpanTitlesInHiliteEditor New showHeaderSpanTitlesInHiliteEditor value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteEditorSpanTitleSeparator
     */
    public ListGrid setShowHeaderSpanTitlesInHiliteEditor(Boolean showHeaderSpanTitlesInHiliteEditor) {
        return (ListGrid)setAttribute("showHeaderSpanTitlesInHiliteEditor", showHeaderSpanTitlesInHiliteEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @return Current showHeaderSpanTitlesInHiliteEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInHiliteEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInHiliteEditor");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}.
     *
     * @param showHeaderSpanTitlesInSortEditor New showHeaderSpanTitlesInSortEditor value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortEditorSpanTitleSeparator
     */
    public ListGrid setShowHeaderSpanTitlesInSortEditor(Boolean showHeaderSpanTitlesInSortEditor) {
        return (ListGrid)setAttribute("showHeaderSpanTitlesInSortEditor", showHeaderSpanTitlesInSortEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}.
     *
     * @return Current showHeaderSpanTitlesInSortEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInSortEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInSortEditor");
        return result == null ? true : result;
    }
    

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary ListGridField.showHilitesInGroupSummary}.
     * <P> Hiliting in summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @param showHilitesInGroupSummary New showHilitesInGroupSummary value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowHilitesInGroupSummary(boolean showHilitesInGroupSummary) {
        return (ListGrid)setAttribute("showHilitesInGroupSummary", showHilitesInGroupSummary, true);
    }

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary ListGridField.showHilitesInGroupSummary}.
     * <P> Hiliting in summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @return Current showHilitesInGroupSummary value. Default value is true
     */
    public boolean getShowHilitesInGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showHilitesInGroupSummary");
        return result == null ? true : result;
    }
    

    /**
     * If true, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} is also true, shows popup hover text
     * next to the mouse when the user hovers over a cell.  The content of the hover is  determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML cellHoverHTML()}. <P> This is the default setting for the grid
     * and can be overridden on a  {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover per-field} basis.
     *
     * @param showHover New showHover value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public ListGrid setShowHover(Boolean showHover) {
        return (ListGrid)setAttribute("showHover", showHover, true);
    }

    /**
     * If true, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} is also true, shows popup hover text
     * next to the mouse when the user hovers over a cell.  The content of the hover is  determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML cellHoverHTML()}. <P> This is the default setting for the grid
     * and can be overridden on a  {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover per-field} basis.
     *
     * @return Current showHover value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public Boolean getShowHover()  {
        Boolean result = getAttributeAsBoolean("showHover");
        return result == null ? true : result;
    }
    

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.widgets.grid.ListGrid#getHoverMode hoverMode}.  Note, if a 
     * <code>hoverMode</code> is set but <code>showHoverComponents</code> is left null, it will default to true. <P> Also
     * supported at the {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHoverComponents field-level}.
     *
     * @param showHoverComponents New showHoverComponents value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowHoverComponents(Boolean showHoverComponents) {
        return (ListGrid)setAttribute("showHoverComponents", showHoverComponents, true);
    }

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.widgets.grid.ListGrid#getHoverMode hoverMode}.  Note, if a 
     * <code>hoverMode</code> is set but <code>showHoverComponents</code> is left null, it will default to true. <P> Also
     * supported at the {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHoverComponents field-level}.
     *
     * @return Current showHoverComponents value. Default value is null
     */
    public Boolean getShowHoverComponents()  {
        return getAttributeAsBoolean("showHoverComponents");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHover showHover} is true, should cell hover HTML be displayed
     * on disabled cells?
     *
     * @param showHoverOnDisabledCells New showHoverOnDisabledCells value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowHoverOnDisabledCells(boolean showHoverOnDisabledCells) {
        return (ListGrid)setAttribute("showHoverOnDisabledCells", showHoverOnDisabledCells, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHover showHover} is true, should cell hover HTML be displayed
     * on disabled cells?
     *
     * @return Current showHoverOnDisabledCells value. Default value is false
     */
    public boolean getShowHoverOnDisabledCells()  {
        Boolean result = getAttributeAsBoolean("showHoverOnDisabledCells");
        return result == null ? false : result;
    }
    

    /**
     * When set to true, shows the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field} on
     * initial draw.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showInitialDragHandles New showInitialDragHandles value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see com.smartgwt.client.widgets.grid.ListGrid#hideDragHandles
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDragHandleField
     */
    public ListGrid setShowInitialDragHandles(Boolean showInitialDragHandles)  throws IllegalStateException {
        return (ListGrid)setAttribute("showInitialDragHandles", showInitialDragHandles, false);
    }

    /**
     * When set to true, shows the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField drag handle field} on
     * initial draw.
     *
     * @return Current showInitialDragHandles value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#showDragHandles
     * @see com.smartgwt.client.widgets.grid.ListGrid#hideDragHandles
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragHandleField
     */
    public Boolean getShowInitialDragHandles()  {
        return getAttributeAsBoolean("showInitialDragHandles");
    }
    

    /**
     * If this is an editable ListGrid, setting this property to true causes an extra  row with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNewRecordRowMessage newRecordRowMessage} to be displayed below the last
     * record. <P> Clicking this row will start editing a new record at the end of the data set, as if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew startEditingNew()} had been called. <P> Note that for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound grids}, the new record row will be suppressed if the
     * grid has not {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetched data}, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} has been set.
     *
     * @param showNewRecordRow New showNewRecordRow value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowNewRecordRow(Boolean showNewRecordRow) {
        return (ListGrid)setAttribute("showNewRecordRow", showNewRecordRow, true);
    }

    /**
     * If this is an editable ListGrid, setting this property to true causes an extra  row with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNewRecordRowMessage newRecordRowMessage} to be displayed below the last
     * record. <P> Clicking this row will start editing a new record at the end of the data set, as if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew startEditingNew()} had been called. <P> Note that for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound grids}, the new record row will be suppressed if the
     * grid has not {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetched data}, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} has been set.
     *
     * @return Current showNewRecordRow value. Default value is null
     */
    public Boolean getShowNewRecordRow()  {
        return getAttributeAsBoolean("showNewRecordRow");
    }
    

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @param showPartialSelection New showPartialSelection value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public ListGrid setShowPartialSelection(Boolean showPartialSelection) {
        return (ListGrid)setAttribute("showPartialSelection", showPartialSelection, true);
    }

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @return Current showPartialSelection value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getShowPartialSelection()  {
        Boolean result = getAttributeAsBoolean("showPartialSelection");
        return result == null ? false : result;
    }
    

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent()} will be
     * called when saved rows are being rendered, and any returned component will be displayed embedded within the row or cell.
     * <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <P> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons ListGridField.valueIcons} (possibly with a specified      
     * {@link com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler)
     * for icons based on field values      which may be displayed alone in the cell or alongside standard content      (see
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly ListGridField.showValueIconOnly}); <li> for
     * clickable icons representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType ListGridField.editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons FormItem.icons} are a common      way to add clickable
     * buttons.  You can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls
     * per record}.  These options are      usually better that using <code>recordComponents</code> as custom editors, since   
     * you won't have to manage issues like making the <code>recordComponent</code> appear      only when editing, having
     * changes affect {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation
     * errors, etc. </ul> <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to
     * optimize use of <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can
     * explicitly refresh record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * refreshRecordComponent()}. <P> <i>Interaction with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths column auto-fit}</i>: per-cell record components are not
     * taken into account when determining the size for column auto fit. The default {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} implementation looks at cell
     * content only. We typically recommend that, for fields showing record-components,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} be disabled, or if  the
     * record components are of a predictable size, a {@link com.smartgwt.client.widgets.grid.ListGridField#getDefaultWidth
     * ListGridField.defaultWidth} be specified.<br> This is particularly pertinent where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition} is set to "within", in
     * which case cells' content is often empty or completely covered by record-components.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} attribute
     *
     * @param showRecordComponents new value for <code>this.showRecordComponents</code>. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public ListGrid setShowRecordComponents(Boolean showRecordComponents) {
        return (ListGrid)setAttribute("showRecordComponents", showRecordComponents, true);
    }

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent()} will be
     * called when saved rows are being rendered, and any returned component will be displayed embedded within the row or cell.
     * <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <P> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons ListGridField.valueIcons} (possibly with a specified      
     * {@link com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler)
     * for icons based on field values      which may be displayed alone in the cell or alongside standard content      (see
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly ListGridField.showValueIconOnly}); <li> for
     * clickable icons representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType ListGridField.editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons FormItem.icons} are a common      way to add clickable
     * buttons.  You can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls
     * per record}.  These options are      usually better that using <code>recordComponents</code> as custom editors, since   
     * you won't have to manage issues like making the <code>recordComponent</code> appear      only when editing, having
     * changes affect {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation
     * errors, etc. </ul> <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to
     * optimize use of <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can
     * explicitly refresh record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * refreshRecordComponent()}. <P> <i>Interaction with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths column auto-fit}</i>: per-cell record components are not
     * taken into account when determining the size for column auto fit. The default {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} implementation looks at cell
     * content only. We typically recommend that, for fields showing record-components,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} be disabled, or if  the
     * record components are of a predictable size, a {@link com.smartgwt.client.widgets.grid.ListGridField#getDefaultWidth
     * ListGridField.defaultWidth} be specified.<br> This is particularly pertinent where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition} is set to "within", in
     * which case cells' content is often empty or completely covered by record-components.
     *
     * @return Current showRecordComponents value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public Boolean getShowRecordComponents()  {
        return getAttributeAsBoolean("showRecordComponents");
    }
    

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRecordComponentsByCell New showRecordComponentsByCell value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     */
    public ListGrid setShowRecordComponentsByCell(Boolean showRecordComponentsByCell) {
        if(showRecordComponentsByCell) setRecordComponentPosition(EmbeddedPosition.WITHIN);
        return (ListGrid)setAttribute("showRecordComponentsByCell", showRecordComponentsByCell, true);
    }

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     *
     * @return Current showRecordComponentsByCell value. Default value is null
     */
    public Boolean getShowRecordComponentsByCell()  {
        return getAttributeAsBoolean("showRecordComponentsByCell");
    }
    

    /**
     * Should we show different styling for the cell the mouse is over? <p> If true, the cell style will have the suffix "Over"
     * appended. <p> Can be overridden on a per-record basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getShowRollOver ListGridRecord.showRollOver}.
     *
     * @param showRollOver New showRollOver value. Default value is true
     * @return {@link com.smartgwt.client.widgets.grid.ListGrid ListGrid} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ListGrid setShowRollOver(Boolean showRollOver) {
        return (ListGrid)setAttribute("showRollOver", showRollOver, true);
    }

    /**
     * Should we show different styling for the cell the mouse is over? <p> If true, the cell style will have the suffix "Over"
     * appended. <p> Can be overridden on a per-record basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getShowRollOver ListGridRecord.showRollOver}.
     *
     * @return Current showRollOver value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getShowRollOver()  {
        Boolean result = getAttributeAsBoolean("showRollOver");
        return result == null ? true : result;
    }
    

    /**
     * When enabled, when the mouse moves over a row or cell (depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers}), an arbitrary Canvas can be shown
     * layered on top of the row or cell (the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas
     * rollOverCanvas}), layered underneath the row or cell (the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas}), or both.  <P> This can be used to
     * dynamically show controls or informational displays only on rollover.  For example, controls to delete a row might
     * appear only on rollover so they do not clutter the static display, or a "rollUnder" Canvas could be used to display
     * additional information that can appear behind normal cell values (like displaying percent complete via as a bar of color
     * that appears behind text values). <p> {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo positioning} can be
     * used to place the rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative to the cell,
     * for row-level rollOver, position is relative to the portion of the row that is scrolled into view (this implies a
     * row-level rollOver/UnderCanvas can never be placed horizontally scrolled out of view, but this is possible for a
     * cell-level rollOver).   <p> <code>snapTo</code> positioning makes it easy to do something like place a button at the
     * right edge of the grid, next to the scrollbar: just set snapTo:"R" on the <code>rollOverCanvas</code>. <p> The
     * rollOver/rollUnder Canvas can be a single static component (the same for all cells/rows) configured via the {@link
     * com.smartgwt.client.types.AutoChild} system, or can instead be provided dynamically by implementing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas getRollOverCanvas()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas getRollUnderCanvas()}. <p> The rollOver/rollUnder canvas
     * will be automatically added to the grid's {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} as an  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent embedded component}.<br> For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the behavior is as follows: <ul><li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers} is false (the default), embedded
     * components   will be added to both the body and th