
package com.smartgwt.client.docs;

/**
 * The history mechanism automatically maintains a list of recent actions taken by an AI as part
 * of a CoTProcess, to help the AI maintain context when it needs to execute a series of  CoTTasks
 * as part of an overall, logical task. <p> What is recorded: (a) transitions (the model emitted
 * {goTo,intent,stepAfter}), and (b) successful non?transition results that were validated and
 * applied to {@link com.smartgwt.client.util.workflow.Process#getState state} (for example via 
 * CoTTask.stateUpdates). <p> History storage: The primary list is kept on the process as 
 * history. For ease of serialization and prompt access, a bounded mirror is also maintained at
 * <code>process.state.history</code>. Both lists are append?only during a run. Limits are
 * controlled by  CoTProcess.historyMaxItems (memory) and  CoTProcess.stateHistoryMaxItems (state
 * mirror).
 */
public interface CoTHistory {
}
