/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthStatus;
import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class Authentication
extends Base {
    private static Logger log = new Logger(Authentication.class.getName());
    private static Map authCache = new HashMap();
    public static boolean enabled = config.getBoolean((Object)"authentication.enabled", false);
    public static String authenticatorKey = "isc.auth.authenticator";

    public static IAuthenticator getAuthenticator(RequestContext context) throws Exception {
        return (IAuthenticator)context.request.getAttribute(authenticatorKey);
    }

    public static String getUsername(RequestContext context) throws Exception {
        return context.request.getRemoteUser();
    }

    public static Object getUser(RequestContext context) throws Exception {
        return context.request.getUserPrincipal();
    }

    public static void setUser(RequestContext context, Object user) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        Principal p = null;
        if (user instanceof Principal) {
            p = (Principal)user;
        } else if (user instanceof Map) {
            Map userRow = (Map)user;
            p = new AuthenticatedUser((String)userRow.get("username"), userRow, authenticator);
        }
        authenticator.setUser(context, p);
    }

    public static boolean isAuthenticated(RequestContext context) throws Exception {
        return Authentication.getUser(context) != null;
    }

    public static void logout(RequestContext context) throws Exception {
        Authentication.clearAuthInfo(context);
    }

    public static void clearAuthInfo(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.logout(context);
    }

    public static String getRealm(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator != null) {
            return authenticator.getRealm(context);
        }
        throw new Exception("No Authenticator configured for this URL");
    }

    public static void setRealm(RequestContext context, String realm) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.setRealm(context, realm);
    }

    public static void setLoginCounter(RequestContext context, int counter) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.setLoginCounter(context, counter);
    }

    public static int getLoginCounter(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator != null) {
            return authenticator.getLoginCounter(context);
        }
        throw new Exception("No Authenticator configured for this URL");
    }

    public static String getInitialTargetJsCallback(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator != null) {
            return authenticator.getInitialTargetJsCallback(context);
        }
        throw new Exception("No Authenticator configured for this URL");
    }

    public static void setInitialTargetJsCallback(RequestContext context, String jsCallback) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.setInitialTargetJsCallback(context, jsCallback);
    }

    public static String getInitialTarget(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator != null) {
            return authenticator.getInitialTarget(context);
        }
        throw new Exception("No Authenticator configured for this URL");
    }

    public static void setInitialTarget(RequestContext context, String initialTarget) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.setInitialTarget(context, initialTarget);
    }

    public static AuthStatus getStatus(RequestContext context) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator != null) {
            return authenticator.getStatus(context);
        }
        throw new Exception("No Authenticator configured for this URL");
    }

    public static void setStatus(RequestContext context, AuthStatus status) throws Exception {
        IAuthenticator authenticator = Authentication.getAuthenticator(context);
        if (authenticator == null) {
            throw new Exception("No Authenticator configured for this URL");
        }
        authenticator.setStatus(context, status);
    }
}

