/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.place.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceChangeRequestEvent;
import com.google.gwt.user.client.Window;
import java.util.logging.Logger;

public class PlaceController {
    private static final Logger log = Logger.getLogger(PlaceController.class.getName());
    private final com.google.web.bindery.event.shared.EventBus eventBus;
    private final Delegate delegate;
    private Place where = Place.NOWHERE;

    @Deprecated
    public PlaceController(EventBus eventBus) {
        this((com.google.web.bindery.event.shared.EventBus)eventBus);
    }

    @Deprecated
    public PlaceController(EventBus eventBus, Delegate delegate) {
        this((com.google.web.bindery.event.shared.EventBus)eventBus, delegate);
    }

    public PlaceController(com.google.web.bindery.event.shared.EventBus eventBus) {
        this(eventBus, (Delegate)GWT.create(DefaultDelegate.class));
    }

    public PlaceController(com.google.web.bindery.event.shared.EventBus eventBus, Delegate delegate) {
        this.eventBus = eventBus;
        this.delegate = delegate;
        delegate.addWindowClosingHandler(new Window.ClosingHandler(){

            @Override
            public void onWindowClosing(Window.ClosingEvent event) {
                String warning = PlaceController.this.maybeGoTo(Place.NOWHERE);
                if (warning != null) {
                    event.setMessage(warning);
                }
            }
        });
    }

    public Place getWhere() {
        return this.where;
    }

    public void goTo(Place newPlace) {
        this.log().fine("goTo: " + newPlace);
        if (this.getWhere().equals(newPlace)) {
            this.log().fine("Asked to return to the same place: " + newPlace);
            return;
        }
        String warning = this.maybeGoTo(newPlace);
        if (warning == null || this.delegate.confirm(warning)) {
            this.where = newPlace;
            this.eventBus.fireEvent(new PlaceChangeEvent(newPlace));
        }
    }

    Logger log() {
        return log;
    }

    private String maybeGoTo(Place newPlace) {
        PlaceChangeRequestEvent willChange = new PlaceChangeRequestEvent(newPlace);
        this.eventBus.fireEvent(willChange);
        String warning = willChange.getWarning();
        return warning;
    }

    public static interface Delegate {
        public HandlerRegistration addWindowClosingHandler(Window.ClosingHandler var1);

        public boolean confirm(String var1);
    }

    public static class DefaultDelegate
    implements Delegate {
        @Override
        public HandlerRegistration addWindowClosingHandler(Window.ClosingHandler handler) {
            return Window.addWindowClosingHandler(handler);
        }

        @Override
        public boolean confirm(String message) {
            return Window.confirm(message);
        }
    }
}

