/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.builder;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc.CacheInstanceManager;
import org.hibernate.cache.jbc.util.CacheHelper;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCacheInstanceManager
implements CacheInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(SharedCacheInstanceManager.class);
    public static final String CACHE_RESOURCE_PROP = "hibernate.cache.jbc.cfg.shared";
    public static final String LEGACY_CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.shared";
    public static final String DEFAULT_CACHE_RESOURCE = "treecache.xml";
    public static final String CHANNEL_FACTORY_RESOURCE_PROP = "hibernate.cache.jbc.cfg.jgroups.stacks";
    public static final String LEGACY_CHANNEL_FACTORY_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.jgroups.stacks";
    public static final String DEF_JGROUPS_RESOURCE = "org/hibernate/cache/jbc/builder/jgroups-stacks.xml";
    private Cache cache;
    private ChannelFactory channelFactory;
    private boolean use2ndLevel;
    private boolean useQuery;

    public SharedCacheInstanceManager() {
    }

    public SharedCacheInstanceManager(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public SharedCacheInstanceManager(Cache cache) {
        this.cache = cache;
    }

    public Cache getEntityCacheInstance() {
        return this.use2ndLevel ? this.cache : null;
    }

    public Cache getCollectionCacheInstance() {
        return this.use2ndLevel ? this.cache : null;
    }

    public Cache getQueryCacheInstance() {
        if (!this.useQuery) {
            return null;
        }
        if (CacheHelper.isClusteredInvalidation(this.cache)) {
            throw new CacheException("Query cache not supported for clustered invalidation");
        }
        return this.cache;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.use2ndLevel = settings.isSecondLevelCacheEnabled();
        this.useQuery = settings.isQueryCacheEnabled();
        if (this.cache == null) {
            if (this.channelFactory == null) {
                String muxStacks = PropertiesHelper.getString(CHANNEL_FACTORY_RESOURCE_PROP, properties, null);
                if (muxStacks == null) {
                    PropertiesHelper.getString(LEGACY_CHANNEL_FACTORY_RESOURCE_PROP, properties, DEF_JGROUPS_RESOURCE);
                }
                if (muxStacks != null) {
                    this.channelFactory = new JChannelFactory();
                    try {
                        this.channelFactory.setMultiplexerConfig(muxStacks);
                    }
                    catch (Exception e) {
                        throw new CacheException("Problem setting ChannelFactory config", e);
                    }
                }
            }
            this.cache = this.createSharedCache(settings, properties);
            this.configureTransactionManager(this.cache, settings, properties);
            if (this.cache.getConfiguration().getMultiplexerStack() != null && this.cache.getConfiguration().getRuntimeConfig().getMuxChannelFactory() == null) {
                this.cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory(this.channelFactory);
            }
        }
        this.cache.start();
    }

    public Cache getTimestampsCacheInstance() {
        if (!this.useQuery) {
            return null;
        }
        if (CacheHelper.isClusteredInvalidation(this.cache)) {
            throw new CacheException("Query cache not supported for clustered invalidation");
        }
        return this.cache;
    }

    public void stop() {
        if (this.cache != null) {
            this.stopSharedCache(this.cache);
        }
    }

    protected Cache createSharedCache(Settings settings, Properties properties) {
        String configResource = PropertiesHelper.getString(CACHE_RESOURCE_PROP, properties, null);
        if (configResource == null) {
            configResource = PropertiesHelper.getString(LEGACY_CACHE_RESOURCE_PROP, properties, DEFAULT_CACHE_RESOURCE);
        }
        return new DefaultCacheFactory().createCache(configResource, false);
    }

    protected void configureTransactionManager(Cache cache, Settings settings, Properties properties) {
        Configuration cacheConfig;
        TransactionManager cacheTm;
        TransactionManager tm = null;
        if (settings.getTransactionManagerLookup() != null) {
            tm = settings.getTransactionManagerLookup().getTransactionManager(properties);
        }
        if (!this.safeEquals(tm, cacheTm = (cacheConfig = cache.getConfiguration()).getRuntimeConfig().getTransactionManager())) {
            if (cache.getCacheStatus() != CacheStatus.INSTANTIATED && cache.getCacheStatus() != CacheStatus.DESTROYED) {
                log.debug("JBoss Cache is already started with a transaction manager (" + cacheTm + ") that is not equal to our own (" + tm + ")");
            } else {
                cacheConfig.getRuntimeConfig().setTransactionManager(tm);
                if (tm == null) {
                    cacheConfig.setTransactionManagerLookupClass(null);
                }
            }
        }
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected void stopSharedCache(Cache cache) {
        try {
            if (cache.getCacheStatus() == CacheStatus.STARTED) {
                cache.stop();
            }
            if (cache.getCacheStatus() != CacheStatus.DESTROYED && cache.getCacheStatus() != CacheStatus.INSTANTIATED) {
                cache.destroy();
            }
        }
        catch (Throwable t) {
            log.warn("Unable to stop cache instance", t);
        }
    }
}

