/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.htmlparser.lexerapplications.thumbelina.Picture;

public class TileSet {
    protected Vector mRegions = new Vector();

    public int getSize() {
        return this.mRegions.size();
    }

    public Enumeration getPictures() {
        return this.mRegions.elements();
    }

    public void add(Picture r) {
        Vector regions = new Vector();
        Enumeration e = this.getPictures();
        while (e.hasMoreElements()) {
            Picture rover = (Picture)e.nextElement();
            if (rover.intersects(r)) {
                Rectangle intersection = rover.intersection(r);
                if (!intersection.equals(rover)) {
                    Vector splits = this.split(r, rover, false);
                    Enumeration frags = splits.elements();
                    while (frags.hasMoreElements()) {
                        regions.addElement(frags.nextElement());
                    }
                    continue;
                }
                rover.setImage(null);
                continue;
            }
            regions.addElement(rover);
        }
        regions.addElement(r);
        this.mRegions = regions;
    }

    private Vector split(Picture small, Picture large, boolean keep) {
        Vector<Picture> ret = new Vector<Picture>();
        if (large.intersects(small)) {
            Picture m;
            Rectangle intersection = large.intersection(small);
            if (intersection.y + intersection.height != large.y + large.height) {
                m = new Picture(large);
                m.y = intersection.y + intersection.height;
                m.height = large.y + large.height - m.y;
                ret.addElement(m);
            }
            if (intersection.x != large.x) {
                m = new Picture(large);
                m.y = intersection.y;
                m.width = intersection.x - large.x;
                m.height = intersection.height;
                ret.addElement(m);
            }
            if (keep) {
                m = new Picture(large);
                m.x = intersection.x;
                m.y = intersection.y;
                m.width = intersection.width;
                m.height = intersection.height;
                ret.addElement(m);
            }
            if (intersection.x + intersection.width != large.x + large.width) {
                m = new Picture(large);
                m.x = intersection.x + intersection.width;
                m.y = intersection.y;
                m.width = large.x + large.width - m.x;
                m.height = intersection.height;
                ret.addElement(m);
            }
            if (intersection.y != large.y) {
                m = new Picture(large);
                m.height = intersection.y - large.y;
                ret.addElement(m);
            }
        }
        return ret;
    }

    public Picture pictureAt(int x, int y) {
        Picture ret = null;
        for (int i = 0; null == ret && i < this.mRegions.size(); ++i) {
            Picture m = (Picture)this.mRegions.elementAt(i);
            if (!m.contains(x, y)) continue;
            ret = m;
        }
        return ret;
    }

    public void bringToTop(Picture picture) {
        Object ret = null;
        int i = 0;
        while (null == ret && i < this.mRegions.size()) {
            Picture m = (Picture)this.mRegions.elementAt(i);
            if (picture.same(m)) {
                this.mRegions.removeElementAt(i);
                continue;
            }
            ++i;
        }
        this.add(picture);
    }
}

